/*
			===== IDBSP - id Software's BSP builder for DOOM ====
	DOS port (c) 1994 Ron Rossbach (ej070@cleveland.freenet.edu)

	File WADFILE.H
		Header file for WAD handling routines and data structures.  In id's
		terminology, a "lump" is a directory entry, i.e. a resource in a WAD.

*/
#ifndef __WADFILE__
#define __WADFILE__

typedef struct
{
	FILE			*handle;
	char			*pathname;
	STORAGE 	*info;
	boolean		dirty;
} WADFILE;

typedef struct
{
	char	identification[4];     /* IWAD or PWAD									*/
	int   numlumps;              /* number of director entries 		*/
	int   infotableofs;          /* offset to start of directory 	*/
} wadinfo_t;

typedef struct
{
	int   filepos;							/* Offset to start of "lump" 			*/
	int   size;                 /* size (in bytes) of "lump"			*/
	char  name[8];              /* name of "lump"									*/
} lumpinfo_t;

/*
	Function prototypes - implementation of the following functions is in
	module WADFILE.C
*/
void				initFromFile(void);
void				initNew(void);
void				WadfileClose(void);
void				WadfileFree(void);
int 				numLumps(void);
int 				lumpsize(int);
int 				lumpstart(int);
char const 	*lumpname(int);
int 				lumpNamed(char const *);
void 				*loadLump(int);
void 				*loadLumpNamed(char const *);
void 				addName(char const *, void *, int);
void 				writeDirectory(void);

#endif		/* __WADFILE__ */