/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 W_OBJECT.H

*/

#ifndef _W_OBJECT_H_
#define _W_OBJECT_H_

#include "w_levels.h"

/* prototypes */
Int16 GetMaxObjectNum(LevelPtr level, int objtype);

void DeleteObject(LevelPtr level, int objtype, Int16 objnum);
void DeleteObjects(LevelPtr level, int objtype, SelPtr *listp);
void InsertObject(LevelPtr level, int objtype, Int16 copyfrom, Int16 xpos, Int16 ypos);

void DuplicateObjects(LevelPtr level, int objtype, SelPtr list);
Bool MoveObjectsToCoords(LevelPtr level, int objtype, SelPtr list, Int16 newx, Int16 newy, Int16 grid);

void GetObjectCoords(LevelPtr level, int objtype, Int16 objnum, Int16 *xpos, Int16 *ypos);
void RotateAndScaleObjects(LevelPtr level, int objtype, SelPtr obj, double angle, double scale);
void MirrorObjects(LevelPtr level, int objtype, SelPtr obj, Bool vertmirror);

void RenumberObject(LevelPtr level, int objtype, Int16 oldnum, Int16 newnum);

Int16 FindFreeTag(LevelPtr level);

#endif /* _W_OBJECT_H_ */
/* end of file */
