/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 M_INFO.C - Display the information box (info about the selected object)

*/

/* the includes */
#include "deu.h"
#include <math.h>
#include "d_misc.h"
#include "d_config.h"
#include "g_gfx.h"
#include "w_levels.h"
#include "w_names.h"
#include "w_things.h"
#include "w_lindef.h"
#include "w_sector.h"
#include "i_dialog.h"
/* #include "m_object.h" */
#include "m_info.h"

/*
   display the information about one object
*/

void DisplayObjectInfo(LevelPtr level, int objtype, Int16 objnum)
{
  char  texname[9];
  Int16 tag, n;
  Int16 sd1 = 0, sd2 = 0, s1 = 0, s2 = 0;
  Int16 x0, y0;

  switch (objtype)
    {
    case OBJ_THINGS:
      x0 = 0;
      y0 = ScrMaxY - 60;
      if (Config.infoShown)
        y0 -= 13;
      DrawScreenBox3D(x0, y0, x0 + 260, y0 + 60);
      if (objnum < 0)
        {
          DrawScreenText(x0 + 60, y0 + 20, "Use the cursor to");
          DrawScreenText(x0 + 72, y0 + 30, "select a Thing  ");
          break;
        }
      SetColor(YELLOW);
      DrawScreenText(x0 + 5, y0 + 5, "Selected Thing (#%d)", objnum);
      SetColor(BLACK);
      DrawScreenText(-1, y0 + 20, "Coordinates:  (%d, %d)", level->things[objnum].xpos, level->things[objnum].ypos);
      DrawScreenText(-1, -1, "Type:         %s", GetThingName(level->things[objnum].type));
      DrawScreenText(-1, -1, "Angle:        %s", GetThingAngleName(level->things[objnum].angle));
      DrawScreenText(-1, -1, "Appears when: %s", GetThingWhenName(level->things[objnum].when));
      break;
    case OBJ_LINEDEFS:
      x0 = 0;
      y0 = ScrMaxY - 80;
      if (Config.infoShown)
        y0 -= 13;
      DrawScreenBox3D(x0, y0, x0 + 218, y0 + 80);
      if (objnum >= 0)
        {
          SetColor(YELLOW);
          DrawScreenText(x0 + 5, y0 + 5, "Selected LineDef (#%d)", objnum);
          SetColor(BLACK);
          DrawScreenText(-1, y0 + 20, "Flags:%3d    %s", level->linedefs[objnum].flags, GetLineDefFlagsName(level->linedefs[objnum].flags));
          DrawScreenText(-1, -1, "Type: %3d %s", level->linedefs[objnum].type, GetLineDefTypeName(level->linedefs[objnum].type));
          sd1 = level->linedefs[objnum].sidedef1;
          sd2 = level->linedefs[objnum].sidedef2;
          tag = level->linedefs[objnum].tag;
          s1 = level->linedefs[objnum].start;
          s2 = level->linedefs[objnum].end;
          n = (Int16) (hypot((double) (level->vertexes[s2].x - level->vertexes[s1].x),
                             (double) (level->vertexes[s2].y - level->vertexes[s1].y))
                       + 0.5);
          DrawScreenText(x0 + 160, y0 + 60, "Length:");
          DrawScreenText(x0 + 170, y0 + 70, "%d", n);
          if (tag > 0)
            {
              for (n = 0; n < level->num_sectors; n++)
                if (level->sectors[n].tag == tag)
                  break;
            }
          else
            n = level->num_sectors;
          if (n < level->num_sectors)
            DrawScreenText(x0 + 5, y0 + 40, "Sector tag:  %d (#%d)", tag, n);
          else
            DrawScreenText(x0 + 5, y0 + 40, "Sector tag:  %d (none)", tag);
          DrawScreenText(-1, -1, "Vertexes:    (#%d, #%d)", s1, s2);
          DrawScreenText(-1, -1, "1st SideDef: #%d", sd1);
          DrawScreenText(-1, -1, "2nd SideDef: #%d", sd2);
          if (sd1 >= 0)
            s1 = level->sidedefs[sd1].sector;
          else
            s1 = -1;
          if (sd2 >= 0)
            s2 = level->sidedefs[sd2].sector;
          else
            s2 = -1;
        }
      else
        {
          SetColor(DARKGRAY);
          DrawScreenText(x0 + 25, y0 + 35, "(No LineDef selected)");
        }
      x0 = 220;
      y0 = ScrMaxY - 80;
      if (Config.infoShown)
        y0 -= 13;
      DrawScreenBox3D(x0, y0, x0 + 218, y0 + 80);
      if (objnum >= 0 && sd1 >= 0)
        {
          SetColor(YELLOW);
          DrawScreenText(x0 + 5, y0 + 5, "First SideDef (#%d)", sd1);
          texname[8] = '\0';
          strncpy(texname, level->sidedefs[sd1].tex1, 8);
          if (s1 >= 0 && s2 >= 0 && level->sectors[s1].ceilh > level->sectors[s2].ceilh)
            {
              if (texname[0] == '-' && texname[1] == '\0')
                SetColor(RED);
              else
                SetColor(BLACK);
            }
          else
            SetColor(DARKGRAY);
          DrawScreenText(-1, y0 + 20, "Upper texture:  %s", texname);
          SetColor(BLACK);
          strncpy(texname, level->sidedefs[sd1].tex3, 8);
          DrawScreenText(-1, -1, "Normal texture: %s", texname);
          strncpy(texname, level->sidedefs[sd1].tex2, 8);
          if (s1 >= 0 && s2 >= 0 && level->sectors[s1].floorh < level->sectors[s2].floorh)
            {
              if (texname[0] == '-' && texname[1] == '\0')
                SetColor(RED);
            }
          else
            SetColor(DARKGRAY);
          DrawScreenText(-1, -1, "Lower texture:  %s", texname);
          SetColor(BLACK);
          DrawScreenText(-1, -1, "Tex. X offset:  %d", level->sidedefs[sd1].xoff);
          DrawScreenText(-1, -1, "Tex. Y offset:  %d", level->sidedefs[sd1].yoff);
          DrawScreenText(-1, -1, "Sector:         #%d", s1);
        }
      else
        {
          SetColor(DARKGRAY);
          DrawScreenText(x0 + 25, y0 + 35, "(No first SideDef)");
        }
      x0 = 440;
      y0 = ScrMaxY - 80;
      if (Config.infoShown)
        y0 -= 13;
      DrawScreenBox3D(x0, y0, x0 + 200, y0 + 80);
      if (objnum >= 0 && sd2 >= 0)
        {
          SetColor(YELLOW);
          DrawScreenText(x0 + 5, y0 + 5, "Second SideDef (#%d)", sd2);
          texname[8] = '\0';
          strncpy(texname, level->sidedefs[sd2].tex1, 8);
          if (s1 >= 0 && s2 >= 0 && level->sectors[s2].ceilh > level->sectors[s1].ceilh)
            {
              if (texname[0] == '-' && texname[1] == '\0')
                SetColor(RED);
              else
                SetColor(BLACK);
            }
          else
            SetColor(DARKGRAY);
          DrawScreenText(-1, y0 + 20, "Upper texture:  %s", texname);
          SetColor(BLACK);
          strncpy(texname, level->sidedefs[sd2].tex3, 8);
          DrawScreenText(-1, -1, "Normal texture: %s", texname);
          strncpy(texname, level->sidedefs[sd2].tex2, 8);
          if (s1 >= 0 && s2 >= 0 && level->sectors[s2].floorh < level->sectors[s1].floorh)
            {
              if (texname[0] == '-' && texname[1] == '\0')
                SetColor(RED);
            }
          else
            SetColor(DARKGRAY);
          DrawScreenText(-1, -1, "Lower texture:  %s", texname);
          SetColor(BLACK);
          DrawScreenText(-1, -1, "Tex. X offset:  %d", level->sidedefs[sd2].xoff);
          DrawScreenText(-1, -1, "Tex. Y offset:  %d", level->sidedefs[sd2].yoff);
          DrawScreenText(-1, -1, "Sector:         #%d", s2);
        }
      else
        {
          SetColor(DARKGRAY);
          DrawScreenText(x0 + 25, y0 + 35, "(No second SideDef)");
        }
      break;
    case OBJ_VERTEXES:
      x0 = 0;
      y0 = ScrMaxY - 30;
      if (Config.infoShown)
        y0 -= 13;
      DrawScreenBox3D(x0, y0, x0 + 220, y0 + 30);
      if (objnum < 0)
        {
          SetColor(DARKGRAY);
          DrawScreenText(x0 + 30, y0 + 12, "(No Vertex selected)");
          break;
        }
      SetColor(YELLOW);
      DrawScreenText(x0 + 5, y0 + 5, "Selected Vertex (#%d)", objnum);
      SetColor(BLACK);
      DrawScreenText(-1, y0 + 20, "Coordinates: (%d, %d)", level->vertexes[objnum].x, level->vertexes[objnum].y);
      break;
    case OBJ_SECTORS:
      x0 = 0;
      y0 = ScrMaxY - 90;
      if (Config.infoShown)
        y0 -= 13;
      DrawScreenBox3D(x0, y0, x0 + 255, y0 + 90);
      if (objnum < 0)
        {
          SetColor(DARKGRAY);
          DrawScreenText(x0 + 48, y0 + 35, "(No Sector selected)");
          break;
        }
      SetColor(YELLOW);
      DrawScreenText(x0 + 5, y0 + 5, "Selected Sector (#%d)", objnum);
      SetColor(BLACK);
      DrawScreenText(-1, y0 + 20, "Floor height:    %d", level->sectors[objnum].floorh);
      DrawScreenText(-1, -1, "Ceiling height:  %d", level->sectors[objnum].ceilh);
      texname[8] = '\0';
      strncpy(texname, level->sectors[objnum].floort, 8);
      DrawScreenText(-1, -1, "Floor texture:   %s", texname);
      strncpy(texname, level->sectors[objnum].ceilt, 8);
      DrawScreenText(-1, -1, "Ceiling texture: %s", texname);
      DrawScreenText(-1, -1, "Light level:     %d", level->sectors[objnum].light);
      DrawScreenText(-1, -1, "Type: %3d        %s", level->sectors[objnum].type, GetSectorTypeName(level->sectors[objnum].type));
      tag = level->sectors[objnum].tag;
      if (tag == 0)
        n = level->num_linedefs;
      else
        for (n = 0; n < level->num_linedefs; n++)
          if (level->linedefs[n].tag == tag)
            break;
      if (n < level->num_linedefs)
        DrawScreenText(-1, -1, "LineDef tag:     %d (#%d)", tag, n);
      else if (tag == 99 || tag == 999)
        DrawScreenText(-1, -1, "LineDef tag:     %d (stairs?)", tag);
      else if (tag == 666)
        DrawScreenText(-1, -1, "LineDef tag:     %d (lower@end)", tag);
      else
        DrawScreenText(-1, -1, "LineDef tag:     %d (none)", tag);
      break;
    }
}



/* end of file */
