
#include <sys/time.h>
#include <stdio.h>

struct {
	char name[24];
	unsigned char val, shift_val, ctrl_val;
	} syms[128];

void getstr(char *string)
{
	fd_set fdset;
	struct timeval tv;
	do {
		bzero(&tv, sizeof(tv));
		read(0, string++, 1);
		FD_ZERO(&fdset);
		FD_SET(0, &fdset);
	} while ( select(64, &fdset, NULL, NULL, &tv) == 1 );
	*string='\0';
}

main(int argc, char *argv[])
{
	FILE *keys;
	char buf[1025], name[24];
	int i, sym;

	if ( !argv[1] || !(keys=fopen(argv[1], "r")) ) {
		fprintf(stderr, "Couldn't open keymap\n");
		exit(1);
	}
	system("stty -echo raw");
	
	for ( i=0; i<128; ++i ) {
		syms[i].name[0] = '\0';
		syms[i].val = '\0';
		syms[i].shift_val = '\0';
		syms[i].ctrl_val = '\0';
	}

	while ( fgets(buf, 1024, keys) ) {
		if ( strncmp(buf, "keycode", 7) != 0 )
			continue;
		name[0] = '\0';
		sscanf(buf, "keycode %d = %s", &sym, &name);
		if ( ! name[0] )
			continue;
		strcpy(syms[sym].name, name);
		fprintf(stderr, "Enter '%s': ", name);
		getstr(buf);
		fprintf(stderr, "\r\n");
		if ( strlen(buf) == 1 )
			syms[sym].val = buf[0];
		fprintf(stderr, "Enter Shift '%s': ", name);
		getstr(buf);
		fprintf(stderr, "\r\n");
		if ( strlen(buf) == 1 )
			syms[sym].shift_val = buf[0];
		fprintf(stderr, "Enter Ctrl '%s': ", name);
		getstr(buf);
		fprintf(stderr, "\r\n");
		if ( strlen(buf) == 1 )
			syms[sym].ctrl_val = buf[0];
	}
	system("stty -raw echo");

	/* Dump a list of defines. :) */
	for ( i=0; i<128; ++i ) {
		if ( syms[i].name[0] )
			printf("#define Sym_%s\t\t%d\n", syms[i].name, i);
	}
	/* Dump the tables. :) */
	printf("\n\n");
	printf("#define NORMAL_MAP\t0\n");
	printf("#define SHIFT_MAP\t1\n");
	printf("#define CONTROL_MAP\t2\n");
	printf("static unsigned char keymaps[3][128] = {\n");
	printf("/* Normal Keymap */\n\t{");
	for ( i=0; i<128; ++i ) {
		if ( !(i%8) )
			printf("\n\t");
		printf("0x%.2x, ", syms[i].val);
	}
	printf("\n\t},\n");
	printf("/* Shift Keymap */\n\t{");
	for ( i=0; i<128; ++i ) {
		if ( !(i%8) )
			printf("\n\t");
		printf("0x%.2x, ", syms[i].shift_val);
	}
	printf("\n\t},\n");
	printf("/* Control Keymap */\n\t{");
	for ( i=0; i<128; ++i ) {
		if ( !(i%8) )
			printf("\n\t");
		printf("0x%.2x, ", syms[i].ctrl_val);
	}
	printf("\n\t},\n");
	printf("};\n");
	exit(0);
}
