/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 G_MOUX11.C - Mouse driver for X-Window

 Functions written by Mike Thomas and Raphael Quinet
*/

/* the includes */
#include "deu.h"
#include <X11/Xlib.h>
#include "g_gfx.h"
#include "g_mouse.h"

/* from g_gfxx11.c */
extern Display     *x_display;
extern Window       x_win;
extern int          x_pointerx;
extern int          x_pointery;
extern unsigned int x_buttons;
extern long         x_inputeventmask;


/* the global data */
Bool UseMouse = FALSE;                  /* is there a mouse driver? */


/*
   Initialize the mouse driver.
*/

void InitMouseDriver(void)
{
  UseMouse = TRUE;
}



/*
   Show the pointer.
*/

void ShowMousePointer(void)
{
  XSelectInput(x_display, x_win, ExposureMask
	       | KeyPressMask | KeyReleaseMask
	       | EnterWindowMask | LeaveWindowMask
	       | PointerMotionMask
	       | ButtonPressMask | ButtonReleaseMask);
  x_inputeventmask = ExposureMask /*! ? */
               | KeyPressMask
               | PointerMotionMask
               | ButtonPressMask | ButtonReleaseMask;
}



/*
   Hide the pointer.
*/

void HideMousePointer(void)
{
  XSelectInput(x_display, x_win, ExposureMask
	       | KeyPressMask | KeyReleaseMask
	       | EnterWindowMask | LeaveWindowMask);
  x_inputeventmask = ExposureMask /*! ? */
               | KeyPressMask;
}


/*
   Read pointer coordinates.
*/

void GetMouseCoords(UInt16 *x, UInt16 *y, UInt16 *buttons)
{
  *x = x_pointerx;
  *y = x_pointery;
  *buttons = x_buttons;
}


/*
   Change pointer coordinates.
*/

void SetMouseCoords(UInt16 x, UInt16 y)
{
  x_pointerx = x;
  x_pointery = y;
  XWarpPointer(x_display, x_win, x_win, 0, 0, ScrMaxX, ScrMaxY, x, y);
}



/*
   Set horizontal and vertical limits (constrain pointer in a box).
*/
/*ARGSUSED*/
void SetMouseLimits(UInt16 x0, UInt16 y0, UInt16 x1, UInt16 y1)
{
  /* ignored */
}



/*
   Reset horizontal and vertical limits.
*/

void ResetMouseLimits(void)
{
   /* ignored */
}


/* end of file */
