// Structures for DoomEd 4
// Copyright  1995 by Geoff Allan

typedef struct WadDirectoryEntry {
    long Offset;                    // start in WAD
    long Length;                    // length
    char Title[9];                  // name (in file, is max 8 bytes)
    int  Type;                      // what type of lump this is
} WadDir;

typedef struct WadThingsFile {      // 10 bytes
    int  x;                         // location x
    int  y;                         // location y
    int  face;                      // direction it faces (degrees)
    int  item;                      // the item type number
    int  lev;                       // bit mask for level(s)
} WadThings;

typedef struct ExtraThingsTag {
    BOOL Used;
    BOOL Selected;
} ExtraThings;

typedef struct WadLineDefsFile {    // 14 bytes
    int  from;                      // vertex from
    int  to;                        // vertex to
    int  solidity;                  // bit mask
    int  special;                   // list
    int  tag;                       // attached to sector - trigger
    int  sidedef1;                  // front side texturing
    int  sidedef2;                  // back side texturing
} WadLineDefs;

typedef struct ExtraLineDefsTag {
    BOOL Used;
    BOOL Moving;
    BOOL Selected;
} ExtraLineDefs;

typedef struct WadSideDefsFile {    // 30 bytes
    int  x;                         // offset for texture start point
    int  y;                         // offset for texture start point
    char t1[8];                     // texture above a lower adjacent ceiling
    char t2[8];                     // texture below a higher adjacent floor
    char t3[8];                     // texture for the main wall area
    int  sector;                    // which sector this is a part of
} WadSideDefs;

typedef struct ExtraSideDefsTag {
    BOOL Used;
} ExtraSideDefs;

typedef struct WadVertexFile {      // 4 bytes  ( USE POINT STRUCT )
    int  x;                         // location x
    int  y;                         // location y
} WadVertexes;

typedef struct ExtraVertexTag {
    BOOL Used;
    BOOL Moving;
    BOOL Selected;
} ExtraVertex;

typedef struct WadSegsFile {        // 12 bytes
    int  from;                      // vertex from
    int  to;                        // vertex to
    int  angle;                     // angle:     0 = east,  16384 = north,
                                    //       -32768 = west, -16384 = south
    int  linedef;                   // linedef number
    int  normal;                    // BOOL - TRUE means vertex1 to vertex2
                                    //       FALSE means vertex2 to vertex1
    int  distance;                  // distance from end of linedef
} WadSegs;

typedef struct WadSSectorsFile {    // 4 bytes
    int  num;                       // # of segs in sector
    int  segs;                      // segs record number to start at
} WadSSectors;

typedef struct WadNodesFile {       // 28 bytes
    int  x;                         // start location
    int  y;                         //       likewise
    int  dx;                        // offset to end of nodeline
    int  dy;
    int  maxy1;                     // rectangular area 1
    int  miny1;
    int  minx1;
    int  maxx1;
    int  maxy2;                     // rectangular area 2
    int  miny2;
    int  minx2;
    int  maxx2;
    int  ssector1;                  // if bit 15 set, these are ssectors
    int  ssector2;                  // (must be &'d with 0x7fff)
} WadNodes;

typedef struct WadSectorsFile {     // 26 bytes
    int  floorZ;                    // Z axis location of floor
    int  ceilZ;                     // Z axis location of ceiling
    char Floor[8];                  // name of floor tile
    char Ceil[8];                   // name of ceiling tile
    int  light;                     // brightness of area (0-255)
    int  flash;                     // light flashing info
    int  tag;                       // tag number (activations)
} WadSectors;

typedef struct ExtraSectorsTag {
    BOOL Used;
    BOOL Selected;
    RECT Extent;
} ExtraSectors;

typedef struct WadBlockMapFile {    // used for wall collision detection
    int  x;                         // origin (bottom left corner)
    int  y;
    int  xblocks;                   // #: X direction (columns)
    int  yblocks;                   // #: Y direction (rows)
} WadBlockMap;

typedef struct WadSoundHeader {
    int  id;                        // must be 3
    int  rate;                      // sampling rate (must be 11025)
    long size;                      // number of bytes
} WadSound;

// not in WAD file, just for DoomEd:

typedef struct ProblemTag {         // problems detected during MapCheck
    char desc[48];                  // description of problem
    int  what;                      // what type of item to show (or Nothing)
    int  which;                     // which item to highlight (or Nothing)
} prob;
    
typedef struct dThingTag {          // descriptions of things
    char desc[40];                  // a nice description
    int  num;                       // the item number
    char image[9];                  // the WAD image
} dThing;

typedef struct TextureInfoTag {
    char name[9];                   // name of texture
    long offset;                    // where in WAD is data
    int  v1;
    int  v2;
    int  x;
    int  y;
    int  v5;
    int  v6;
    int  num;
} TextureInfo;

typedef struct TextureItemTag {
    int  x;
    int  y;
    int  pname;
    int  v4;
    int  v5;
} TextureItem;

typedef struct PNameInfo {
    char name[9];
    int  num;
} PNames;

typedef struct WavSoundHeader {     // brute force, dammit!
    FOURCC riff;                    // (multimedia extensions
    long size;                      //  way is too complex...)
    FOURCC wave;
    FOURCC fmt;
    long  offset;
    WAVEFORMAT wf;
    int  u1;
    FOURCC data;
    long datasize;
} WavSound;

typedef struct TagsTag {            // Abstraction of plats
    int  Num;                       // platform number for Doom
    char Name[16];                  // symbolic name
    char Desc[256];                 // description for editing
} WadTags;                          // WadPlats

typedef struct StyleTag {           // Predefined sector styles
    char Name[32];
    char Floor[16];
    char Ceiling[16];
    char Walls[16];
} Styles;

typedef struct BuilderTag {         // BSP Builders
    char Name[32];                  // whatever user wants
    char Command[128];              // command to run builder
    int  Format;                    // 0 = WAD, 1 = DWD, future?
} Builders;

// data structure for something we are waiting for another
// program to return to us with.
typedef struct PendingTag {
    char filename[144];             // filename of temp file
    int  where;                     // DD_INTERNAL or DD_EXTERNAL
    int  which;                     // Wad entry number
    int  type;                      // WD_??
} PENDING;

typedef struct {                    // 3-d point
  int   x, y, z;                    // x, y, z coordinates
  } iPoint3d;
  
typedef struct {                    // 3-d rectangle
  iPoint3d  p1, p2;                 // opposite corners
  POINT     s1, s2, s3, s4;         // screen coordinates
  int       distance;               // distance to observer
  } iRect3d;
    
// Array class from WinBuild Copyright  1995 by Geoff Allan.
// Unauthorised distribution of this class is strictly prohibited.

class Array {
  protected:
    void FAR **     m_Data;         // pointers to data
    HGLOBAL         m_hData;        // handle of data pointers
    int             m_RecordSize;   // bytes / record
    int             m_MaxEntries;   // maximum allocated for
    int             m_MaxUsed;      // highest number used
    int             m_TotalUsed;    // number actually in use
    int             m_Allocate;     // # to allocate each expansion
    BOOL            m_Dynamic;      // resize automatically?
  public:
    Array(int RecSize, BOOL IsDynamic = FALSE, int ToAlloc = 50);
    ~Array();
    inline int  Entries() const { return m_MaxUsed; } ;
    inline int  InUse() const   { return m_TotalUsed; } ;
    inline void FAR * operator[](int Record) const { return m_Data[Record]; } ;
    inline BOOL IsUsed(int Record) const { return (m_Data[Record] ? TRUE : FALSE); } ;
    inline void Flush() { ReSize(0); } ;
    BOOL ReSize(int Records);
    int  New();
    void Del(int Record, BOOL Shrink = FALSE);
    void Save(HFILE);
    void Load(HFILE);
};

// User derivatives of classes:
class RectArray : public Array {
  public:
    RectArray() : Array(sizeof(iRect3d)) {};
    ~RectArray() {};
    iRect3d FAR * operator[](int Record) const
            { return (iRect3d FAR *)m_Data[Record]; } ;
    void PreCalc(int, int, int);  // in h3d.cpp
};

