// Splash dialog for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

static HBITMAP hSplashBitmap;

int EXPORT DialogSplash(HWND  hDlg,
                        WORD  wMsg,
                        WORD  wParam,
                        DWORD lParam)
{
  HDC   hdcB = NULL;

  switch(wMsg)
    {
    case WM_INITDIALOG:
      Ctl3dSubclassDlgEx(hDlg, CTL3D_ALL);
      ShowingSplash = TRUE;
      KillTimer(hDlg, 1);
      SetTimer(hDlg, 1, 5000, NULL);
      return FALSE;
      break;
      
    case WM_TIMER:
      if(wParam == 1) {
        KillTimer(hDlg, 1);
        SplashDown();
        return FALSE;
        }
      return TRUE;  
      break;

    case WM_PAINT:
      {
      PAINTSTRUCT ps;
      HDC hMemDC;
      HBITMAP old;
      
      BeginPaint(hDlg, &ps);
      hSplashBitmap = LoadBitmap(hinst, MAKEINTRESOURCE(IDB_SPLASH3));
      hdcB=ps.hdc;
      hMemDC=CreateCompatibleDC(hdcB);
      old = SelectObject(hMemDC, hSplashBitmap);
      BitBlt(hdcB, 0, 0, 354, 220,
             hMemDC, 0, 0, SRCCOPY);
      SelectObject(hMemDC, old);
      DeleteDC(hMemDC);
      EndPaint(hDlg, &ps);
      }
      return TRUE;
      break;

    default:
      return FALSE;
    }
}

void SplashDown(void)
{
  // get rid of splash screen
  HIDE_HWND(hwndDialogSplash);
  ShowingSplash = FALSE;
  DeleteBitmap(hSplashBitmap);
}