// Function Prototypes for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

// in DoomEd40.cpp
int PASCAL WinMain(HANDLE hInstance,
                   HANDLE hPrevInstance,
                   LPSTR lpszCmdLine,
                   int nCmdShow);               // Windows routine
int DoMain(HANDLE hInstance);                   // Windows routine
long EXPORT DoomEdWindowProc (HWND   hWnd,
                              UINT   wMsgID,
                              WPARAM wParam,
                              LONG   lParam);   // Main Windows routine

long EXPORT CustomDialogProc(HWND   hDlg,
                             UINT   wMsgID,
                             WPARAM wParam,
                             LONG   lParam);    // Custom dialog proc
// in 3d.cpp
void  Do3d(void);
int   EXPORT Dialog3d(HWND hDlg,
                      WORD wMsg,
                      WORD wParam,
                      DWORD lParam);
int   EXPORT Dialog3dSetup(HWND hDlg,
                           WORD wMsg,
                           WORD wParam,
                           DWORD lParam);
void Draw3dMap(HDC rDC);

// in Bitmaps.cpp
HBITMAP BitmapFromDoom(int which);              // convert Doom data to BMP
HBITMAP BitmapFromDir(int which);               // convert wad data to BMP
HBITMAP ConvertImageToBMP(BYTE __huge *imbuf);  // called by above two
HBITMAP TileFromDoom(int which);                // convert Doom floor/ceil
HBITMAP TileFromDir(int which);                 // convert wad floor/ceil
HBITMAP ConvertTileToBMP(BYTE __huge *imbuf);   // called by above two
HBITMAP TextureImageFromDoom(int t);            // create texture image

// in Blockmap.cpp
void BuildBlockmap(void);

// in Builders.cpp
void DoBuilders(void);                          // handle nodes builder database
int EXPORT DialogBuilders(HWND hDlg,
                          WORD wMsg, 
                          WORD wParam, 
                          DWORD lParam);        // Dialog Callback
int EXPORT DialogBuilder(HWND hDlg,
                         WORD wMsg, 
                         WORD wParam, 
                         DWORD lParam);         // Dialog Callback

// in Cdb.cpp
void DefineDoomWad(void);                       // find the main doom.wad file
void DefineThingsDef(void);                     // find the things.def file
BOOL OpenAFile(void);                           // Open any file type
BOOL FileNameExportDWD(void);                   // get filename to export
void DefineExportDirectory(void);               // define where to export to
void DefinePrinting(void);                      // printer dialog

// in CtrlBars.cpp
void ClientRect(HWND hWnd, RECT FAR *rr);       // return the drawing area
void EnableControlBarItems(void);               // turn on cbar buttons
void DisableControlBarItems(void);              // turn off cbar buttons
void InvalidateMain(void);                      // force a repaint
int EXPORT ControlBar(HWND hDlg,
                      WORD wMsg,
                      WORD wParam,
                      DWORD lParam);            // Dialog Callback
int EXPORT ControlBot(HWND hDlg,
                      WORD wMsg,
                      WORD wParam,
                      DWORD lParam);            // Dialog Callback
void BottomMessage(char *text);                 // display message on bottom
void BottomMapName(char *text);                 // display name on bottom
void DisplayCoords(int x, int y);               // update coordinates

// in Dib.cpp     (from Microsoft - sample program "ShowDib")
HANDLE      OpenDIB (LPSTR szFile);
BOOL        WriteDIB (LPSTR szFile,HANDLE hdib);
WORD        PaletteSize (VOID FAR * pv);
WORD        DibNumColors (VOID FAR * pv);
HPALETTE    CreateDibPalette (HANDLE hdib);
HPALETTE    CreateBIPalette (LPBITMAPINFOHEADER lpbi);
HANDLE      DibFromBitmap (HBITMAP hbm, DWORD biStyle,
                           WORD biBits, HPALETTE hpal);
HANDLE      BitmapFromDib (HANDLE hdib, HPALETTE hpal);
BOOL        DibBlt (HDC hdc, int x0, int y0, int dx, int dy,
                    HANDLE hdib, int x1, int y1, LONG rop);
BOOL        StretchDibBlt (HDC hdc, int x0, int y0, int dx, int dy,
                           HANDLE hdib, int x1, int y1, int dx1, int dy1,
                           LONG rop);
BOOL        DibInfo (HANDLE hdib,LPBITMAPINFOHEADER lpbi);
HANDLE      ReadDibBitmapInfo (int fh);
BOOL        DrawBitmap (HDC hdc, int x, int y, HBITMAP hbm, DWORD rop);

// in Directry.cpp
void DoDirectory(void);                         // caller entry
int EXPORT DialogDirectory(HWND hDlg,
                           WORD wMsg,
                           WORD wParam,
                           DWORD lParam);       // Dialog Callback
void SavePending(void);                         // save data from external editor
void DoMapName(void);                           // change the current map title
int EXPORT DialogMapName(HWND hDlg,
                         WORD wMsg,
                         WORD wParam,
                         DWORD lParam);         // Dialog Callback

// in Dwd.cpp
void ExportDWD(void);                           // export map in DWD format
void ImportDWD(void);                           // import map in DWD format

// in Edit.cpp
void DoomEdEditUndo(void);
void DoomEdEditRedo(void);
void DoomEdEditCut(void);
void DoomEdEditCopy(void);
void DoomEdEditPaste(void);
void DoomEdEditDelete(void);
void DoomEdEditPartDelete(void);
void DoomEdEditAttributes(void);
void DoomEdScale(void);
void DoomEdRotate(void);
void SectorRotateScale(void);

// in File.cpp
void DoomEdFileOpen(void);
void DoomEdFileClose(void);
void DoomEdFileSave(void);
void DoomEdFileSaveAs(void);
void DoomEdFileNew(void);
void DoomEdFilePrint(void);
void DoomEdFileExport(void);
void DoomEdFileExit(void);
void LoadPreviousFile(WPARAM wParam);
void MapChange(void);
void MapChangeNode(void);
void CopyWad(char *dest, char *source);

// in Finders.cpp
int NearestVertex(POINT mouse);
int NearestLineDef(POINT mouse);
int NearestSector(POINT mouse);
int NearestThing(POINT mouse);
int NearestSectorNotMove(POINT mouse);
int DoomEntry(char *Search);
int DirEntry(char *Search);
int TextureEntry(char *Search);

// in Help.cpp
void DoomEdHelpContents(void);
void DoomEdHelpSearch(void);
void DoomEdHelpSupport(void);
void DoomEdHelpAbout(void);
int EXPORT SimpleDialog(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam);
void SeriousError(char *Message);

// in Init.cpp
BOOL DoomEdInit(HANDLE hInstance,
                HANDLE hPrevInstance,
                LPSTR lpszCmdLine,
                int nCmdShow);
void Initialize(void);
BOOL ReadDoomWadDirectory(void);

// in ItemAdd.cpp
void DoWhatToAdd(void);
int  EXPORT DialogItemAdd(HWND hDlg,
                          WORD wMsg,
                          WORD wParam,
                          DWORD lParam);
int  SectorNew(void);
int  LineDefNew(void);
int  LineDefSideDefNew(void);
int  SideDefNew(void);
int  VertexNew(void);
int  ThingNew(void);
void SectorDel(int);
void LineDefDel(int);
void SideDefDel(int);
void VertexDel(int);
void ThingDel(int);
void PackMap(void);

// in Join.cpp
void ProcessJoins(void);            // Do joins after something moved
void ProcessSectorJoins(void);      // do joins after floor/ceil changed
void Join2Vertexes(int a, int b);   // join any two vertexes
void Join2Lines(int a, int b);      // join any two lines

// in label.cpp
void DoLabel(HWND hWnd, int which);
int  EXPORT DialogLabel(HWND hDlg,
                        WORD wMsg,
                        WORD wParam,
                        DWORD lParam);

// in LineDef.cpp
void PutLineDefInDialog(int CurrentLineDef);
int  EXPORT DialogLineDef(HWND  hDlg,
                          WORD  wMsg,
                          WORD  wParam,
                          DWORD lParam);
int  EXPORT DialogLineDefs(HWND  hDlg,
                           WORD  wMsg,
                           WORD  wParam,
                           DWORD lParam);

// in Lists.cpp
void FillListWithStyles(HWND hList);
void FillListWithBuilders(HWND hList);
void FillListWithTextures(HWND hList);
void FillListWithTiles(HWND hList);
void FillListWithPanels(HWND hList);
void FillListWithSprites(HWND hList);
void FillListWithGraphics(HWND hList);
void FillListWithPlatforms(HWND hList);
void FillComboWithStyles(HWND hList);
void FillComboWithTextures(HWND hList);
void FillComboWithTiles(HWND hList);
void FillComboWithPanels(HWND hList);
void FillComboWithSprites(HWND hList);
void FillComboWithGraphics(HWND hList);
void FillComboWithPlatforms(HWND hList);
void FillComboWithSectorAttributes(HWND);
void FillListWithLineDefActions(HWND hList);
void FillListWithLineAttributes(HWND hList);
void FillComboWithDirections(HWND hList);
int FillComboWithThings(HWND hList);    // returns "unknown"

// in Load.cpp
void LoadWad(char *szFileName);
void LoadProject(char *szFileName);
void LoadMap(char *szFileName);
void LoadBlock(char *szBlockName);
HBITMAP LoadBmp(char *szFileName);

// in Memory.cpp
void AllocateSectors(int num);
void AllocateLineDefs(int num);
void AllocateSideDefs(int num);
void AllocateThings(int num);
void AllocateVertex(int num);
void AllocateNodes(int num);
void AllocateSSectors(int num);
void AllocateSegs(int num);

// in MenuHelp.cpp
void DoomEdMenuSelect(WPARAM wParam);
void DoomEdButtonSelect(WPARAM wParam);

// in Mouse.cpp
void DoomEdRButtonDown(HDC hdc, WPARAM wParam, LPARAM lParam);
void DoomEdRButtonUp  (HDC hdc, WPARAM wParam, LPARAM lParam);
void DoomEdRDouble    (HDC hdc, WPARAM wParam, LPARAM lParam);
void DoomEdLButtonDown(HDC hdc, WPARAM wParam, LPARAM lParam);
void DoomEdLButtonUp  (HDC hdc, WPARAM wParam, LPARAM lParam);
void DoomEdLDouble    (HDC hdc, WPARAM wParam, LPARAM lParam);
void DoomEdMouseMove  (HDC hdc, WPARAM wParam, LPARAM lParam);
void DoomEdNCMouseMove(void);

// in NewSect.cpp
void AddNewSector(WPARAM wParam);
void DoSides(void);
int EXPORT DialogSides(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam);

// in Nodes.cpp
void BspBuild(void);

// in Options.cpp
void DoOptions(void);
int EXPORT DialogOptions(HWND hDlg,
                         WORD wMsg,
                         WORD wParam,
                         DWORD lParam);
void DoomEdStatistics(void);
int EXPORT DialogStats(HWND hDlg,
                       WORD wMsg,
                       WORD wParam,
                       DWORD lParam);
void DoGrid(void);
int EXPORT DialogGrid(HWND hDlg,
                      WORD wMsg,
                      WORD wParam,
                      DWORD lParam);

// in Paint.cpp
void SetMapping(HDC);
void RepaintMap(void);
void DoomEdPaint(void);
void DoomEdSize(LPARAM lParam);

// in PickList.cpp
int PickListTiles(void);

// in Popups.cpp
void PopupSetup(void);
void PopupSelectedObject(LPARAM lParam);
void PopupNewSector(LPARAM lParam);
void PopupQuit(void);

// in Print.cpp
void PrintMap(void);

// in Read.cpp
RECT GetMapExtents(void);
void FindVertexesInUse(void);
void ReadMap(int where, int which);
void ReadGraphic(int where, int which);

// in Quit.cpp
long DoomEdClose(HWND hWnd);
void DoomEdDestroy(void);

// in Save.cpp
void SaveWad(char *szFileName);
void SaveProject(char *szFileName);
void SaveMap(char *szFileName);
void SaveBlock(char *szBlockName);
void SaveBmp(HBITMAP hTBitmap, char *szFileName);
void SaveLump(int where, int which, char *szFileName);

// in Scroll.cpp
void DoomEdVScroll(WPARAM wParam);
void DoomEdHScroll(WPARAM wParam);
void DoomEdScrollInit(void);
void DoomEdScrollNewView(void);
void DoomEdZoomOut(void);
void DoomEdZoomIn(void);

// in Sector.cpp
void PutSectorInDialog(int num);
void PutSectorsInDialog(int num);
int EXPORT DialogSector(HWND  hDlg,
                        WORD  wMsg,
                        WORD  wParam,
                        DWORD lParam);
void PutValueInFloorAndCeiling(int num, int val);
int EXPORT DialogSectors(HWND  hDlg,
                         WORD  wMsg,
                         WORD  wParam,
                         DWORD lParam);
void DetachSectors(void);

// in Select.cpp
void GetSectorExtents(void);
void SelectThing(int num);
void SelectVertex(int num);
void SelectSector(int num);
void SelectLineDef(int num);
void UnSelectAll(void);
void UnSelectAllThings(void);
void UnSelectAllVertexes(void);
void UnSelectAllSectors(void);
void UnSelectAllLineDefs(void);
void MarkLineDef(int num);
void MarkVertex(int num);
void MarkSector(int num);
void MarkThing(int num);
void TagLineDef(int num);
void UnTagLineDef(int num);
void TagSector(int num);
void UnTagSector(int num);
void UnMarkLineDef(int num);
void UnMarkVertex(int num);
void UnMarkSector(int num);
void UnMarkThing(int num);

// in Splash.cpp
int EXPORT DialogSplash(HWND  hDlg,
                        WORD  wMsg,
                        WORD  wParam,
                        DWORD lParam);
void SplashDown(void);

// in Steps.cpp
void DoSteps(void);
int EXPORT DialogSteps(HWND hDlg,
                       WORD wMsg,
                       WORD wParam,
                       DWORD lParam);

// in Styles.cpp
void DoStyles(void);
int EXPORT DialogStyles(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam);
int EXPORT DialogStyle(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam);
void DoSectorDefault(void);
void ApplyStyle(int num);

// in Tags.cpp
void DoPlatforms(void);
int EXPORT DialogPlatforms(HWND hDlg,
                           WORD wMsg, 
                           WORD wParam, 
                           DWORD lParam);        // Dialog Callback
int EXPORT DialogPlatform(HWND hDlg,
                          WORD wMsg, 
                          WORD wParam, 
                          DWORD lParam);         // Dialog Callback

// in TempWait.cpp
void TempWait(HINSTANCE hEditor);
void TaskComplete(void);

// in Textures.cpp
void ReadTextures(void);

// in Thing.cpp
void PutThingInDialog(int num);
int EXPORT DialogThing(HWND  hDlg,
                       WORD  wMsg,
                       WORD  wParam,
                       DWORD lParam);
int EXPORT DialogThings(HWND  hDlg,
                        WORD  wMsg,
                        WORD  wParam,
                        DWORD lParam);

// in Tools.cpp
void MakeSectorDoor(int num);           // makes a door out of the sector
void DropSectors(POINT Current, POINT Gridded);  // drop moved sector(s)
void SectorDuplicate(void);
void DoSearch(void);
void DoReplace(void);
int EXPORT DialogMapCheck(HWND hDlg,
                          WORD wMsg,
                          WORD wParam,
                          DWORD lParam);    // modeless

// in Viewers.cpp
void PutTileInViewer(char *Title);
int EXPORT DialogTileViewer(HWND hDlg,
                            WORD wMsg,
                            WORD wParam,
                            DWORD lParam);
void PutTextureInViewer(int TextureNum);
int EXPORT DialogTextureViewer(HWND hDlg,
                               WORD wMsg,
                               WORD wParam,
                               DWORD lParam);
void DoViewer(void);
int EXPORT DialogViewer(HWND hDlg,
                        WORD wMsg,
                        WORD wParam,
                        DWORD lParam);
void DoSounds(void);
int EXPORT DialogSounds(HWND hDlg,
                        WORD wMsg,
                        WORD wParam,
                        DWORD lParam);

// in Write.cpp
void WriteLump(int where, int which, char *filename);
void WriteBitmap(int where, int which, char *filename);


