// Popup Menus for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

HMENU hPopupSelectedObject = 0,  // handles to popup menus
      hPopupNewSector = 0,
      hPopupStyles = 0;
int   ExtraPixels;              // adjustment for window border

void PopupSetup(void)
{
  SystemParametersInfo(SPI_GETBORDER, 0, &ExtraPixels, FALSE);
  ExtraPixels++;

  // if we've been here before, clear out the old data
  // since all the setup is append
  if(hPopupSelectedObject)
    DestroyMenu(hPopupSelectedObject);
  if(hPopupNewSector)
    DestroyMenu(hPopupNewSector);
  if(hPopupStyles)
    DestroyMenu(hPopupStyles);

  hPopupSelectedObject = CreatePopupMenu();
  hPopupNewSector      = CreatePopupMenu();
  hPopupStyles         = CreatePopupMenu();

  if(StylesNum > 0)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE00, Style[0].Name);
  if(StylesNum > 1)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE01, Style[1].Name);
  if(StylesNum > 2)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE02, Style[2].Name);
  if(StylesNum > 3)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE03, Style[3].Name);
  if(StylesNum > 4)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE04, Style[4].Name);
  if(StylesNum > 5)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE05, Style[5].Name);
  if(StylesNum > 6)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE06, Style[6].Name);
  if(StylesNum > 7)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE07, Style[7].Name);
  if(StylesNum > 8)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE08, Style[8].Name);
  if(StylesNum > 9)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE09, Style[9].Name);
  if(StylesNum > 10)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE10, Style[10].Name);
  if(StylesNum > 11)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE11, Style[11].Name);
  if(StylesNum > 12)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE12, Style[12].Name);
  if(StylesNum > 13)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE13, Style[13].Name);
  if(StylesNum > 14)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE14, Style[14].Name);
  if(StylesNum > 15)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE15, Style[15].Name);
  if(StylesNum > 16)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE16, Style[16].Name);
  if(StylesNum > 17)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE17, Style[17].Name);
  if(StylesNum > 18)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE18, Style[18].Name);
  if(StylesNum > 19)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE19, Style[19].Name);
  if(StylesNum > 20)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE20, Style[20].Name);
  if(StylesNum > 21)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE21, Style[21].Name);
  if(StylesNum > 22)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE22, Style[22].Name);
  if(StylesNum > 23)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE23, Style[23].Name);
  if(StylesNum > 24)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE24, Style[24].Name);
  if(StylesNum > 25)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE25, Style[25].Name);
  if(StylesNum > 26)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE26, Style[26].Name);
  if(StylesNum > 27)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE27, Style[27].Name);
  if(StylesNum > 28)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE28, Style[28].Name);
  if(StylesNum > 29)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE29, Style[29].Name);
  if(StylesNum > 30)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE30, Style[30].Name);
  if(StylesNum > 31)
    AppendMenu(hPopupStyles, MF_ENABLED, POPUP_STYLE31, Style[31].Name);

  AppendMenu(hPopupSelectedObject, MF_GRAYED,    POPUP_TITLE,       "SELECTED OBJECT");
  AppendMenu(hPopupSelectedObject, MF_SEPARATOR, NULL, NULL);
  AppendMenu(hPopupSelectedObject, MF_ENABLED,   POPUP_MAKEDOOR,    "Make Sector a &Door");
  AppendMenu(hPopupSelectedObject, MF_ENABLED,   POPUP_ROTATESCALE, "&Rotate and/or Scale");
  AppendMenu(hPopupSelectedObject, MF_ENABLED,   POPUP_DUPLICATE,   "&Duplicate");
  AppendMenu(hPopupSelectedObject, MF_SEPARATOR, NULL, NULL);
  AppendMenu(hPopupSelectedObject, MF_ENABLED,   ID_EDIT_PARTDELETE,"&Partial Delete\tDel");
  AppendMenu(hPopupSelectedObject, MF_ENABLED,   ID_EDIT_DELETE,    "D&elete\tShift+Del");
  AppendMenu(hPopupSelectedObject, MF_SEPARATOR, NULL, NULL);
  AppendMenu(hPopupSelectedObject, MF_POPUP,     hPopupStyles,      "&Apply Style");
  AppendMenu(hPopupSelectedObject, MF_ENABLED,   POPUP_STYLES,      "&Styles...");
  AppendMenu(hPopupSelectedObject, MF_SEPARATOR, NULL, NULL);
  AppendMenu(hPopupSelectedObject, MF_ENABLED,   POPUP_CANCEL,      "&Cancel");

  AppendMenu(hPopupNewSector,      MF_GRAYED,    POPUP_TITLE,       "NEW SECTOR");
  AppendMenu(hPopupNewSector,      MF_SEPARATOR, NULL, NULL);
  AppendMenu(hPopupNewSector,      MF_ENABLED,   POPUP_RECTANGLE,   "&Rectangular");
  AppendMenu(hPopupNewSector,      MF_ENABLED,   POPUP_POLYGON,     "&Polygonal...");
  AppendMenu(hPopupNewSector,      MF_ENABLED,   POPUP_SHAPE_STAR,  "&Star");
  AppendMenu(hPopupNewSector,      MF_ENABLED,   POPUP_STEPS,       "S&teps...");
  AppendMenu(hPopupNewSector,      MF_SEPARATOR, NULL, NULL);
  AppendMenu(hPopupNewSector,      MF_ENABLED,   POPUP_CANCEL,      "&Cancel");
}

void PopupSelectedObject(LPARAM lParam)
{
  POINT     ptCurrent;
  RECT      rCurrent;
  GetWindowRect(hwnd, &rCurrent);
  ptCurrent = MAKEPOINT(lParam);
  
  TrackPopupMenu(hPopupSelectedObject, TPM_LEFTALIGN | TPM_RIGHTBUTTON,
                 ptCurrent.x + rCurrent.left + ExtraPixels,
                 ptCurrent.y + rCurrent.top, 0, hwnd, NULL);
}

void PopupNewSector(LPARAM lParam)
{
  POINT     ptCurrent;
  RECT      rCurrent;
  GetWindowRect(hwnd, &rCurrent);
  ptCurrent = MAKEPOINT(lParam);
  
  TrackPopupMenu(hPopupNewSector, TPM_RIGHTALIGN | TPM_LEFTBUTTON,
                 ptCurrent.x + rCurrent.left + ExtraPixels,
                 ptCurrent.y + rCurrent.top, 0, hwnd, NULL);
}

void PopupQuit(void)
{
  // deallocate the menus (called during cleanup)
  if(hPopupSelectedObject)
    DestroyMenu(hPopupSelectedObject);
  if(hPopupNewSector)
    DestroyMenu(hPopupNewSector);
  if(hPopupStyles)
    DestroyMenu(hPopupStyles);
}

