// Paint Routine for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

void RepaintMap(void)
{
  // mark it all as dirty
  InvalidateRect(hwnd, NULL, TRUE);
  // force an immediate repaint
  SendMessage(hwnd, WM_PAINT, NULL, NULL);
  // update scroll bar thumbs
  DoomEdScrollNewView();
}

void SetMapping(HDC hDc) {
  int   extra;
  float ratioX, ratioY;
  SIZE  MapSize, DisplaySize;
  RECT  rc, pc;         // rc=real coordinates, pc = pseudo coordinates
  int   TopHeight, BotHeight;
#if defined( _DEBUG )
  char  szTemp[128];
#endif
  
  // adjust so map is centered in window
  SetMapMode(hdc, MM_TEXT);
  GetClientRect(hwnd, &rc);             // get display extents
  TopHeight = 28;
  BotHeight = 30;
  DisplaySize.cx = rc.right;            // total display width
  DisplaySize.cy = rc.bottom;           // total display height
  DisplaySize.cy -= (TopHeight + BotHeight);
  pc = MapExtent;                       // get map extents
  // get the world width and height
  MapSize.cx = pc.right - pc.left;
  MapSize.cy = pc.top - pc.bottom;
  // calculate the screen/map ratios:
  ratioX = (float)MapSize.cx / (float)DisplaySize.cx;
  ratioY = (float)MapSize.cy / (float)DisplaySize.cy;
  // adjust either x or y
  if(ratioX > ratioY) {
    extra = (int)((float)DisplaySize.cy * (float)ratioX) - MapSize.cy;
    pc.top += (extra / 2); pc.bottom -= (extra / 2); }
  else {
    extra = (int)((float)DisplaySize.cx * (float)ratioY) - MapSize.cx;
    pc.left -= (extra / 2); pc.right += (extra / 2); }
  // set the new world width and height
  MapSize.cx = pc.right - pc.left;
  MapSize.cy = pc.top - pc.bottom;
  // keep track of how much of the map is actually displayed:
  MapOnScreen = pc;
#if defined( _DEBUG )
  wsprintf(szTemp, "MapOnScreen=(%i,%i)-(%i,%i) MapExtent=(%i,%i)-(%i,%i)",
                    MapOnScreen.left,
                    MapOnScreen.top,
                    MapOnScreen.right,
                    MapOnScreen.bottom,
                    MapExtent.left,
                    MapExtent.top,
                    MapExtent.right,
                    MapExtent.bottom);
  BottomMessage(szTemp);
#endif
  // setup Windows mapping so logical and physical units are correct.
  SetMapMode(hDc, MM_ISOTROPIC);
  SetWindowExt(hDc, MapSize.cx, -MapSize.cy);
  SetViewportExt(hDc, DisplaySize.cx, DisplaySize.cy);
  SetWindowOrg(hDc, MapOnScreen.left, MapOnScreen.top +
                                      (int)(ratioY * TopHeight));
  return;
}

void DoomEdPaint(void)
{
  PAINTSTRUCT ps;
  int   i, j;
  int   m, n;
  HPEN  hpen, hpenOld;

  BeginPaint(hwnd, &ps);    // get paint information
  if(MapLoaded) {           // if a map is being displayed,
    SetMapping(ps.hdc);

    // draw the axis:
    SetBkColor(ps.hdc, ColorBackground);  // for axis line background
    hpen = CreatePen(PS_DASHDOT, 0, PALETTERGB(0, 0, 192));   // very blue
    hpenOld = SelectPen(ps.hdc, hpen);
    MoveTo(ps.hdc, MapOnScreen.left, 0);
    LineTo(ps.hdc, MapOnScreen.right,0);
    MoveTo(ps.hdc, 0, MapOnScreen.bottom);
    LineTo(ps.hdc, 0,  MapOnScreen.top);
    SelectPen(ps.hdc, hpenOld);
    DeletePen(hpen);

    SelectBrush(ps.hdc, hBrushBackground);

    // now the tile grid:
    if(oShow64x64Grid) {
      if((MapOnScreen.right - MapOnScreen.left) < 2200) {
        SelectPen(ps.hdc, hPenGrid);
        for(i = ((MapOnScreen.left / 64) * 64);
            i < MapOnScreen.right;
            i += 64)
          for(j = ((MapOnScreen.bottom / 64) * 64);
              j < MapOnScreen.top;
              j += 64) {
            MoveTo(ps.hdc, i - 4, j);
            LineTo(ps.hdc, i + 5, j);
            MoveTo(ps.hdc, i, j - 4);
            LineTo(ps.hdc, i, j + 5);
            }   // next j
        }       // endif((MapOnScreen.right
      }         // endif(oShow64x64Grid)

    // next the user snap-to grid
    if(oShowSnapToGrid) {
      if(((MapOnScreen.right - MapOnScreen.left) < 2200) && (GridSize > 4)) {
        for(i = ((MapOnScreen.left / GridSize) * GridSize);
            i < MapOnScreen.right;
            i += GridSize)
          for(j = ((MapOnScreen.bottom / GridSize) * GridSize);
              j < MapOnScreen.top;
              j += GridSize) {
            SetPixel(ps.hdc, i, j, ColorUserGrid);
            }   // next j
        }       // endif((MapOnScreen.right
      }         // endif(oShowSnapToGrid)
  
    // draw the map walls:
    switch(Tool) {
      case T_SECTOR:
        for(i = 0; i < LineDefsNum; i++)
          if(eLineDef[i].Used) {
            if((LineDef[i].sidedef1 != Nothing) &&
               (LineDef[i].sidedef2 != Nothing))
              SelectPen(ps.hdc, hPenMapInnerLines);
            else
              SelectPen(ps.hdc, hPenMapLines);
            if(LineDef[i].sidedef1 != Nothing)
              if(eSector[SideDef[LineDef[i].sidedef1].sector].Selected)
              SelectPen(ps.hdc, hPenSelected);
            if(LineDef[i].sidedef2 != Nothing)
              if(eSector[SideDef[LineDef[i].sidedef2].sector].Selected)
              SelectPen(ps.hdc, hPenSelected);
            if((TagShowing > 0) &&
               IsWindowVisible(hwndDialogSector) &&
               (LineDef[i].tag == TagShowing))
              SelectPen(ps.hdc, hPenMarked);
            MoveTo(ps.hdc, Vertex[LineDef[i].from].x,
                           Vertex[LineDef[i].from].y);
            LineTo(ps.hdc, Vertex[LineDef[i].to].x,
                           Vertex[LineDef[i].to].y);
            }       // endif linedefUsed
        break;

      case T_LINE:
        for(i = 0; i < LineDefsNum; i++)
          if(eLineDef[i].Used) {
            if(eLineDef[i].Selected)
              SelectPen(ps.hdc, hPenSelected);
            else {
              if((TagShowing > 0) &&
                 IsWindowVisible(hwndDialogLineDef) &&
                 (((LineDef[i].sidedef1 != Nothing) &&
                   (Sector[SideDef[LineDef[i].sidedef1].sector].tag == 
                           TagShowing)) ||
                  ((LineDef[i].sidedef2 != Nothing) &&
                   (Sector[SideDef[LineDef[i].sidedef2].sector].tag == 
                           TagShowing))))
                SelectPen(ps.hdc, hPenMarked);
              else {
                if((LineDef[i].sidedef1 != Nothing) &&
                   (LineDef[i].sidedef2 != Nothing))
                  SelectPen(ps.hdc, hPenMapInnerLines);
                else
                  SelectPen(ps.hdc, hPenMapLines);
                }
              }
            MoveTo(ps.hdc, Vertex[LineDef[i].from].x,
                           Vertex[LineDef[i].from].y);
            LineTo(ps.hdc, Vertex[LineDef[i].to].x,
                           Vertex[LineDef[i].to].y);
            n = (Vertex[LineDef[i].from].x + Vertex[LineDef[i].to].x) / 2;
            m = (Vertex[LineDef[i].from].y + Vertex[LineDef[i].to].y) / 2;
            MoveTo(ps.hdc, n, m); // this is the center of the line just drawn
            LineTo(ps.hdc, n + (Vertex[LineDef[i].to].y - Vertex[LineDef[i].from].y) / 3,
                           m + (Vertex[LineDef[i].from].x - Vertex[LineDef[i].to].x) / 3);
            }
        break;

      default:
        for(i = 0; i < LineDefsNum; i++)
          if(eLineDef[i].Used) {
            if((LineDef[i].sidedef1 != Nothing) &&
               (LineDef[i].sidedef2 != Nothing))
              SelectPen(ps.hdc, hPenMapInnerLines);
            else
              SelectPen(ps.hdc, hPenMapLines);
            MoveTo(ps.hdc, Vertex[LineDef[i].from].x,
                           Vertex[LineDef[i].from].y);
            LineTo(ps.hdc, Vertex[LineDef[i].to].x,
                           Vertex[LineDef[i].to].y);
            }       // endif linedefUsed
        break;
      }             // end switch
  
    // draw the things:
    SelectBrush(ps.hdc, hBrushBackground);
    for(i = 0; i < ThingsNum; i++)
      if(eThing[i].Used) {
        if(eThing[i].Selected)
          SelectPen(ps.hdc, hPenSelected);
        else  
          SelectPen(ps.hdc, hPenMapLines);
        Rectangle(ps.hdc, Thing[i].x - 8, Thing[i].y - 8,
                          Thing[i].x + 8, Thing[i].y + 8);
        } // endif used

    if(Tool == T_VERTEX) {
      // draw the vertexes:
      SelectBrush(ps.hdc, hBrushNull);
      for(i = 0; i < VertexNum; i++)
        if(eVertex[i].Used) {
          if(eVertex[i].Selected)
            SelectPen(ps.hdc, hPenSelected);    // purple
          else  
            SelectPen(ps.hdc, hPenMarked);      // green
          Rectangle(ps.hdc, Vertex[i].x - 4, Vertex[i].y - 4,
                            Vertex[i].x + 4, Vertex[i].y + 4);
          } // endif used
      }     // endif tool = vertex
      
    }       // endif (MapLoaded)
  EndPaint(hwnd, &ps);      // done painting
}

void DoomEdSize(LPARAM lParam)
{
  RECT tRect;
  GetClientRect(hwnd, &tRect);
  SetWindowPos(hwndControlBot, hwndControlBar, 0, tRect.bottom - 20,
               tRect.right, tRect.bottom,
               SWP_NOACTIVATE);
}

