// Options for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

void DoOptions(void)
{
  FARPROC lpfnDlgProc;
  lpfnDlgProc = MakeProcInstance((FARPROC)DialogOptions, hinst);
  if(lpfnDlgProc) {
    DialogBox(hinst,
              MAKEINTRESOURCE(IDD_OPTIONS),
              hwnd,
              lpfnDlgProc);
    FreeProcInstance(lpfnDlgProc);
    }
}

void DoColors(void);

HWND    hCheck1, hCheck2, hCheck5, hCheck7;

int EXPORT DialogOptions(HWND hDlg,
                         WORD wMsg,
                         WORD wParam,
                         DWORD lParam)
{
  switch(wMsg) 
    {
    case WM_INITDIALOG:
      hCheck1 = GetDlgItem(hDlg, IDC_CHECK1);
      hCheck2 = GetDlgItem(hDlg, IDC_CHECK2);
      hCheck5 = GetDlgItem(hDlg, IDC_CHECK5);
      hCheck7 = GetDlgItem(hDlg, IDC_CHECK7);
      Button_SetCheck(hCheck1, oShowSnapToGrid);
      Button_SetCheck(hCheck2, oShow64x64Grid);
      Button_SetCheck(hCheck5, oVerifyExit);
      break;

    case WM_COMMAND:
      switch(wParam) {
        case IDC_COLORS:
          DoColors();
          break;
        case IDOK:
          // save changes
          oShowSnapToGrid               = Button_GetCheck(hCheck1);
          oShow64x64Grid                = Button_GetCheck(hCheck2);
          oVerifyExit                   = Button_GetCheck(hCheck5);
          oAutoLoadMostRecentFile       = TRUE;
          EndDialog(hDlg, IDOK);
          return TRUE;
          break;
        case IDCANCEL:
          EndDialog(hDlg, IDOK);
          return TRUE;
          break;
        default:
          break;
        }
    default:
      return FALSE;
    }
    return FALSE;
}

void DoomEdStatistics(void)
{
  FARPROC lpfnDlgProc;
  PackMap();
  lpfnDlgProc = MakeProcInstance((FARPROC)DialogStats, hinst);
  if(lpfnDlgProc) {
    DialogBox(hinst,
              MAKEINTRESOURCE(IDD_STATS),
              hwnd,
              lpfnDlgProc);
    FreeProcInstance(lpfnDlgProc);
    }
}

static HWND hStats;

int EXPORT DialogStats(HWND hDlg,
                       WORD wMsg,
                       WORD wParam,
                       DWORD lParam)
{
  char  szTemp[128];
  int   i,
        CountThings = 0,
        CountLineDefs = 0,
        CountSideDefs = 0,
        CountVertex = 0,
        CountSectors = 0;
  
  switch(wMsg) 
    {
    case WM_INITDIALOG:
      hStats = GetDlgItem(hDlg, IDC_STATS);
      for(i = 0; i < ThingsNum; i++)
        if(eThing[i].Used)
          CountThings++;
      for(i = 0; i < LineDefsNum; i++)
        if(eLineDef[i].Used)
          CountLineDefs++;
      for(i = 0; i < SideDefsNum; i++)
        if(eSideDef[i].Used)
          CountSideDefs++;
      for(i = 0; i < VertexNum; i++)
        if(eVertex[i].Used)
          CountVertex++;
      for(i = 0; i < SectorsNum; i++)
        if(eSector[i].Used)
          CountSectors++;
      wsprintf(szTemp, "%i\n%i\n%i\n%i\n%i\n%i\n%i\n%i\n%li\n%li\n%i\n",
              CountThings,
              CountLineDefs,
              CountSideDefs,
              CountVertex,
              CountSectors,
              NodesNum,
              SegsNum,
              SSectorsNum,
              RejectSize,
              BlockMapSize,
              TagsNum - 1);
      Static_SetText(hStats, szTemp);
      break;

    case WM_COMMAND:
      EndDialog(hDlg, IDOK);
      return TRUE;
    default:
      return FALSE;
    }
    return FALSE;
}

void DoGrid(void)
{
  FARPROC lpfnDlgProc;
  lpfnDlgProc = MakeProcInstance((FARPROC) DialogGrid, hinst);
  if(lpfnDlgProc) {
    DialogBox(hinst,
              MAKEINTRESOURCE(IDD_SETGRID),
              hwnd,
              lpfnDlgProc);
    FreeProcInstance(lpfnDlgProc);
    }
}

static HWND hGrid;

int EXPORT DialogGrid(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
  char sztemp[8];
  switch(wMsg)
    {
    case WM_INITDIALOG:
      hGrid = GetDlgItem(hDlg, IDC_GRID);
      sprintf(sztemp,"%i",GridSize);
      Static_SetText(hGrid, sztemp);
      return TRUE;
      break;

    case WM_COMMAND:
      switch (wParam)
        {
        // quick buttons take you right out.
        case IDC_GRID4:
          GridSize = 4;
          EndDialog(hDlg, IDOK);
          return TRUE;
          break;
        case IDC_GRID8:
          GridSize = 8;
          EndDialog(hDlg, IDOK);
          return TRUE;
          break;
        case IDC_GRID16:
          GridSize = 16;
          EndDialog(hDlg, IDOK);
          return TRUE;
          break;
        case IDC_GRID24:
          GridSize = 24;
          EndDialog(hDlg, IDOK);
          return TRUE;
          break;
        case IDC_GRID32:
          GridSize = 32;
          EndDialog(hDlg, IDOK);
          return TRUE;
          break;
        case IDC_GRID64:
          GridSize = 64;
          EndDialog(hDlg, IDOK);
          return TRUE;
          break;

        case IDOK:              // OK button
          Static_GetText(hGrid, sztemp, 8);
          sscanf(sztemp, "%i", &GridSize);
          if(GridSize < 1) GridSize = 1;
          if(GridSize > 256) GridSize = 256;
          EndDialog(hDlg, IDOK);
          return TRUE;
          break;
        default:
          return FALSE;
          break;
        }
      
    default:
      return FALSE;
    }
}

static HWND localhwnd;

COLORREF GetColor(COLORREF oldcolor)
{
  // from online help for color select (common dialog box)
  CHOOSECOLOR cc;
  COLORREF  clr;
  COLORREF  aclrCust[16];
  COLORREF  bclrCust[16];  // for compares
  char      szTemp[128];
  char      szTemp2[10] = "ColorA";
  int       i, j;
  // get all custom colors from Control.ini:
  for(i = 0; i < 16; i++) {
    szTemp2[5] = 'A' + i;
    GetPrivateProfileString("Custom Colors",
                            szTemp2,
                            "000000",
                            szTemp,
                            128,
                            "control.ini");
    sscanf(szTemp, "%lx", &(COLORREF)aclrCust[i]);
    bclrCust[i] = aclrCust[i];
    }
  clr = oldcolor;
  memset(&cc, 0, sizeof(CHOOSECOLOR));
  cc.lStructSize = sizeof(CHOOSECOLOR);
  cc.hwndOwner = localhwnd;
  cc.rgbResult = clr;
  cc.lpCustColors = aclrCust;
  cc.Flags = CC_RGBINIT;
  if(ChooseColor(&cc)) {
    for(j = 0; j < 16; j++)
      if(aclrCust[j] != bclrCust[j]) {
        // custom colors changed - save them:
        for(i = 0; i < 16; i++) {
          szTemp2[5] = 'A' + i;
          sprintf(szTemp, "%lX", aclrCust[i]);
          WritePrivateProfileString("Custom Colors",
                                    szTemp2,
                                    szTemp,
                                    "control.ini");
          }
        break;
        }
    // return the selected color:
    return (COLORREF)cc.rgbResult;
    }
  else
    // return without change:
    return oldcolor;
    // (colors are saved at exit)
}

int EXPORT DialogColors(HWND hDlg,
                        WORD wMsg,
                        WORD wParam,
                        DWORD lParam);

void DoColors(void)
{
  FARPROC lpfnDlgProc;

  lpfnDlgProc = MakeProcInstance((FARPROC)DialogColors, hinst);
  if(lpfnDlgProc) {
    DialogBox(hinst,
              MAKEINTRESOURCE(IDD_COLORS),
              hwnd,
              lpfnDlgProc);
    FreeProcInstance(lpfnDlgProc);
    }
}

#define COLOR_LEFT  60      // left edge
#define COLOR_RIGHT 85      // right edge
#define COLOR_TOP   4       // top of first one
#define COLOR_SIZE  14      // height of rectangle
#define COLOR_SPACE 18      // vertical space between rectangles
#define DrawRect(num, col)  hBrush = CreateSolidBrush(col);                     \
                            hOldBrush = SelectObject(ps.hdc, hBrush);           \
                            dSize.left = COLOR_LEFT; dSize.right = COLOR_RIGHT; \
                            dSize.top = (COLOR_TOP + (COLOR_SPACE * num));      \
                            dSize.bottom = dSize.top + COLOR_SIZE;              \
                            MapDialogRect(hDlg, &dSize);                        \
                            Rectangle(ps.hdc, dSize.left, dSize.top,            \
                                              dSize.right,dSize.bottom);        \
                            SelectBrush(ps.hdc, hOldBrush);                     \
                            DeleteBrush(hBrush);

int EXPORT DialogColors(HWND hDlg,
                        WORD wMsg,
                        WORD wParam,
                        DWORD lParam)
{
  HBRUSH   hBrush, hOldBrush;
  
  switch(wMsg)
    {
    case WM_INITDIALOG:
      localhwnd = hDlg; // to attach CDB to this dialog (kludge)
      return TRUE;
      break;
      
    case WM_PAINT:
      {
      PAINTSTRUCT ps;
      RECT        dSize;
      BeginPaint(hDlg, &ps);

      DrawRect(0, ColorBackground);
      DrawRect(1, ColorMapLines);
      DrawRect(2, ColorMapInnerLines);
      DrawRect(3, ColorSelected);
      DrawRect(4, ColorMarked);
      DrawRect(5, ColorGrid);
      DrawRect(6, ColorUserGrid);

      EndPaint(hDlg, &ps);
      }
      return TRUE;
      break;
      
    case WM_COMMAND:
      switch(wParam)
        {
        case IDC_BACKGROUND_CHANGE:
          ColorBackground = GetColor(ColorBackground);
          InvalidateRect(hDlg, NULL, FALSE);
          DeletePen(hPenBackground);
          DeleteBrush(hBrushBackground);
          hPenBackground = CreatePen(PS_SOLID, 0, ColorBackground);
          hBrushBackground = CreateSolidBrush(ColorBackground);
          SetClassWord(hwnd, GCW_HBRBACKGROUND, hBrushBackground);
          SetBkColor(hwnd, ColorBackground);
          return FALSE;

        case IDC_MAPLINES_CHANGE:
          ColorMapLines = GetColor(ColorMapLines);
          InvalidateRect(hDlg, NULL, FALSE);
          DeletePen(hPenMapLines);
          DeleteBrush(hBrushMapLines);
          hPenMapLines = CreatePen(PS_SOLID, 0, ColorMapLines);
          hBrushMapLines = CreateSolidBrush(ColorMapLines);
          return FALSE;

        case IDC_MAPINNERLINES_CHANGE:
          ColorMapInnerLines = GetColor(ColorMapInnerLines);
          InvalidateRect(hDlg, NULL, FALSE);
          DeletePen(hPenMapInnerLines);
          DeleteBrush(hBrushMapInnerLines);
          hPenMapInnerLines = CreatePen(PS_SOLID, 0, ColorMapInnerLines);
          hBrushMapInnerLines = CreateSolidBrush(ColorMapInnerLines);
          return FALSE;

        case IDC_SELECTED_CHANGE:
          ColorSelected = GetColor(ColorSelected);
          InvalidateRect(hDlg, NULL, FALSE);
          DeletePen(hPenSelected);
          DeleteBrush(hBrushSelected);
          hPenSelected = CreatePen(PS_SOLID, 0, ColorSelected);
          hBrushSelected = CreateSolidBrush(ColorSelected);
          return FALSE;

        case IDC_MARKED_CHANGE:
          ColorMarked = GetColor(ColorMarked);
          InvalidateRect(hDlg, NULL, FALSE);
          DeletePen(hPenMarked);
          DeleteBrush(hBrushMarked);
          hPenMarked = CreatePen(PS_SOLID, 0, ColorMarked);
          hBrushMarked = CreateSolidBrush(ColorMarked);
          return FALSE;

        case IDC_GRID_CHANGE:
          ColorGrid = GetColor(ColorGrid);
          InvalidateRect(hDlg, NULL, FALSE);
          DeletePen(hPenGrid);
          DeleteBrush(hBrushGrid);
          hPenGrid = CreatePen(PS_SOLID, 0, ColorGrid);
          hBrushGrid = CreateSolidBrush(ColorGrid);
          return FALSE;

        case IDC_USERGRID_CHANGE:
          ColorUserGrid = GetColor(ColorUserGrid);
          InvalidateRect(hDlg, NULL, FALSE);
          DeletePen(hPenUserGrid);
          DeleteBrush(hBrushUserGrid);
          hPenUserGrid = CreatePen(PS_SOLID, 0, ColorUserGrid);
          hBrushUserGrid = CreateSolidBrush(ColorUserGrid);
          return FALSE;

        case IDCANCEL:
          EndDialog(hDlg, IDCANCEL);
          return TRUE;

        case IDOK:
          // Force a redraw using the new colors:
          InvalidateMain();
          EndDialog(hDlg, IDOK);
          return TRUE;
        
        default:
          return FALSE;
        }
    default:
      return FALSE;
    }
}

