// New Sector support for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"
#include <math.h>       // for polygons

#define PI180           (double)0.017453292     // pi / 180

int     NumberOfSides = 8;
POINT   NewSectorCenter;

void AddNewSector(WPARAM wParam)
{
  int   i;
  int   news, newv[64], newl;
  
  // global SelRect contains the extent.
  NewSectorCenter.x = SelRect.left + ((SelRect.right - SelRect.left) / 2);
  NewSectorCenter.y = SelRect.bottom + ((SelRect.top - SelRect.bottom) / 2);
  switch(wParam) {
    case POPUP_RECTANGLE:
      if(ShowingSectorRectangle) {
        ShowingSectorRectangle = FALSE;
        HDC rDC = GetDC(hwnd);
        int oldROP = SetROP2(rDC, R2_XORPEN);
        SelectBrush(rDC, hBrushNull);
        SelectPen(rDC, hPenSelected);
        // erase selection rectangle
        Rectangle(rDC, SelRect.left, SelRect.top,
                       SelRect.right, SelRect.bottom);
        SetROP2(rDC, oldROP);
        ReleaseDC(hwnd, rDC);
        BottomMessage("");
        }
      // just add a simple rectangle like the user stretched out:
      news = SectorNew();
      newv[0] = VertexNew();
      Vertex[newv[0]].x = SelRect.left;
      Vertex[newv[0]].y = SelRect.top;
      newv[1] = VertexNew();
      Vertex[newv[1]].x = SelRect.right;
      Vertex[newv[1]].y = SelRect.top;
      newv[2] = VertexNew();
      Vertex[newv[2]].x = SelRect.right;
      Vertex[newv[2]].y = SelRect.bottom;
      newv[3] = VertexNew();
      Vertex[newv[3]].x = SelRect.left;
      Vertex[newv[3]].y = SelRect.bottom;
      newl = LineDefSideDefNew();
      SideDef[LineDef[newl].sidedef1].sector = news;
      LineDef[newl].from = newv[0];
      LineDef[newl].to   = newv[1];
      newl = LineDefSideDefNew();
      SideDef[LineDef[newl].sidedef1].sector = news;
      LineDef[newl].from = newv[1];
      LineDef[newl].to   = newv[2];
      newl = LineDefSideDefNew();
      SideDef[LineDef[newl].sidedef1].sector = news;
      LineDef[newl].from = newv[2];
      LineDef[newl].to   = newv[3];
      newl = LineDefSideDefNew();
      SideDef[LineDef[newl].sidedef1].sector = news;
      LineDef[newl].from = newv[3];
      LineDef[newl].to   = newv[0];
      // that's it!
      UnSelectAllSectors();
      SelectSector(news);   // make it draw.
      if(IsWindowVisible(hwndDialogSector))
        PutSectorInDialog(news);
      break;
    case POPUP_POLYGON:
      DoSides();
      if(ShowingSectorRectangle) {
        ShowingSectorRectangle = FALSE;
        HDC rDC = GetDC(hwnd);
        int oldROP = SetROP2(rDC, R2_XORPEN);
        SelectBrush(rDC, hBrushNull);
        SelectPen(rDC, hPenSelected);
        // erase selection rectangle
        Rectangle(rDC, SelRect.left, SelRect.top,
                       SelRect.right, SelRect.bottom);
        SetROP2(rDC, oldROP);
        ReleaseDC(hwnd, rDC);
        BottomMessage("");
        }
      if((NumberOfSides > 2) && (NumberOfSides < 65)) {
        double ex = (double)(SelRect.right - SelRect.left) / 2;
        double ey = (double)(SelRect.top - SelRect.bottom) / 2;
        double rot = 0;
        if(!(NumberOfSides & 1))    // even number
          rot = (((double)360 / (double)NumberOfSides) / (double)2);
        news = SectorNew();
        for(i=0; i<NumberOfSides; i++) {
          double deg = (double)i * ((double)360 / (double)NumberOfSides);
          newv[i] = VertexNew();
          Vertex[newv[i]].x = NewSectorCenter.x +
                              (int)(sin((rot + deg) * PI180) * ex);
          Vertex[newv[i]].y = NewSectorCenter.y +
                              (int)(cos((rot + deg) * PI180) * ey);
          }     // next i
        for(i=0; i < (NumberOfSides - 1); i++) {
          newl = LineDefSideDefNew();
          SideDef[LineDef[newl].sidedef1].sector = news;
          LineDef[newl].from = newv[i];
          LineDef[newl].to   = newv[i+1];
          }     // next i
        newl = LineDefSideDefNew();
        SideDef[LineDef[newl].sidedef1].sector = news;
        LineDef[newl].from = newv[NumberOfSides - 1];
        LineDef[newl].to   = newv[0];
        UnSelectAllSectors();
        SelectSector(news);   // make it draw.
        if(IsWindowVisible(hwndDialogSector))
          PutSectorInDialog(news);
        }       // endif valid #sides
      return;
      break;

    case POPUP_SHAPE_STAR:
      {
      double ex = (double)(SelRect.right - SelRect.left) / 2;
      double ey = (double)(SelRect.top - SelRect.bottom) / 2;
      int v = 0;
      if(ShowingSectorRectangle) {
        ShowingSectorRectangle = FALSE;
        HDC rDC = GetDC(hwnd);
        int oldROP = SetROP2(rDC, R2_XORPEN);
        SelectBrush(rDC, hBrushNull);
        SelectPen(rDC, hPenSelected);
        // erase selection rectangle
        Rectangle(rDC, SelRect.left, SelRect.top,
                       SelRect.right, SelRect.bottom);
        SetROP2(rDC, oldROP);
        ReleaseDC(hwnd, rDC);
        BottomMessage("");
        }
      news = SectorNew();
      for(i=0; i<5; i++) {
        double deg = (double)i * (double)72;
        newv[v] = VertexNew();
        Vertex[newv[v]].x = NewSectorCenter.x +
                            (int)(sin(deg * PI180) * ex);
        Vertex[newv[v]].y = NewSectorCenter.y +
                            (int)(cos(deg * PI180) * ey);
        v += 2;
        }     // next i
      ex = (double)(SelRect.right - SelRect.left) / 5;
      ey = (double)(SelRect.top - SelRect.bottom) / 5;
      v = 1;
      for(i=0; i<5; i++) {
        double deg = (double)i * (double)72;
        newv[v] = VertexNew();
        Vertex[newv[v]].x = NewSectorCenter.x +
                            (int)(sin((deg + 36) * PI180) * ex);
        Vertex[newv[v]].y = NewSectorCenter.y +
                            (int)(cos((deg + 36) * PI180) * ey);
        v += 2;
        }     // next i
      for(i=0; i < 9; i++) {
        newl = LineDefSideDefNew();
        SideDef[LineDef[newl].sidedef1].sector = news;
        LineDef[newl].from = newv[i];
        LineDef[newl].to   = newv[i+1];
        }     // next i
      newl = LineDefSideDefNew();
      SideDef[LineDef[newl].sidedef1].sector = news;
      LineDef[newl].from = newv[9];
      LineDef[newl].to   = newv[0];
      UnSelectAllSectors();
      SelectSector(news);   // make it draw.
      if(IsWindowVisible(hwndDialogSector))
        PutSectorInDialog(news);
      }
      return;
      break;

    case POPUP_STEPS:
      DoSteps();
      break;

    default:
      break;
    }   // end switch wParam
}

void DoSides(void)
{
  FARPROC lpfnDlgProc;
  lpfnDlgProc = MakeProcInstance((FARPROC)DialogSides, hinst);
  if(lpfnDlgProc) {
    DialogBox(hinst,
              MAKEINTRESOURCE(IDD_POLYGON),
              hwnd,
              lpfnDlgProc);
    FreeProcInstance(lpfnDlgProc);
    }
}

HWND    hSides;

int EXPORT DialogSides(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
  char  szTemp[12];
  
  switch(wMsg) {
    case WM_INITDIALOG:
      hSides = GetDlgItem(hDlg, IDC_SIDES);
      Edit_SetText(hSides, "8");
      return FALSE;
      break;
    case WM_COMMAND:
      switch(wParam) {
        case IDOK:
          Edit_GetText(hSides, szTemp, 8);
          sscanf(szTemp, "%u", &NumberOfSides);
          EndDialog(hDlg, IDOK);
          return TRUE;
          break;
        case IDCANCEL:
          NumberOfSides = Nothing;
          EndDialog(hDlg, IDCANCEL);
          return TRUE;
          break;
        default:
          break;
        }
    default:
      return FALSE;
    }
}

