// Menu Help for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

void DoomEdMenuSelect(WPARAM wParam)
{
  switch(wParam) {
    case ID_HELP_ABOUT:
      BottomMessage("Get information on this program and available resources");
      break;
    case ID_HELP_SHAREWARE:
      BottomMessage("Get information on registering this program");
      break;

    case ID_FILE_OPEN:
      BottomMessage("Open a Wad file for editing");
      break;
    case ID_FILE_SAVE:
      BottomMessage("Ensure that current work is saved");
      break;
    case ID_FILE_NEW:
      BottomMessage("Create a new Wad file");
      break;
    case ID_FILE_PRINT:
      BottomMessage("Print the current map on the printer or to a file");
      break;
    case ID_FILE_EXPORT:
      BottomMessage("Export the current map to a DWD file for IDBSP");
      break;
    case ID_FILE_EXIT:
      BottomMessage("Exit DoomEd 4.2");
      break;
    case ID_FILE_FILE1:
    case ID_FILE_FILE2:
    case ID_FILE_FILE3:
    case ID_FILE_FILE4:
      BottomMessage("Load a previously loaded file");
      break;

    case ID_EDIT_OPTIONS:
      BottomMessage("Configure the DoomEd program");
      break;

      case ID_EDIT_DEFAULTSECTORSTYLE:
      BottomMessage("Setup the style for new sectors");
      break;

    case POPUP_DEFINESTYLE:
      BottomMessage("Create a style based on the attributes of the current item");
      break;
    case POPUP_STYLES:
      BottomMessage("Work with the list of styles");
      break;
    case POPUP_RECTANGLE:
      BottomMessage("Create a rectangular sector as drawn");
      break;
    case POPUP_POLYGON:
      BottomMessage("Create a polygon to fill the drawn rectangle");
      break;
    case POPUP_SHAPE_STAR:
      BottomMessage("Create a 5 pointed star to fill the drawn rectangle");
      break;
    case POPUP_STEPS:
      BottomMessage("Create a row of steps to fill the drawn rectangle");
      break;

    default:
      BottomMessage("");
      break;
  }
}

void DoomEdButtonSelect(WPARAM wParam)
{
  switch(wParam) {
    case IDC_CB_CONTENTS:
      BottomMessage("Display/Edit the Contents of the current Wad file");
      break;
    case IDC_CB_OPEN:
      BottomMessage("Open a Wad file for editing");
      break;
    case IDC_CB_SAVE:
      BottomMessage("Ensure that current work is saved");
      break;
    case IDC_CB_NEW:
      BottomMessage("Create a new Wad file");
      break;

    case IDC_CB_THINGS:
      BottomMessage("Switch the current editing mode to Things");
      break;
    case IDC_CB_VERTEXES:
      BottomMessage("Switch the current editing mode to Vertices");
      break;
    case IDC_CB_LINEDEFS:
      BottomMessage("Switch the current editing mode to LineDefs");
      break;
    case IDC_CB_SECTORS:
      BottomMessage("Switch the current editing mode to Sectors");
      break;

    case IDC_CB_ZOOMPREV:
      BottomMessage("Change view to the previous zoom-level");
      break;
    case IDC_CB_ZOOMALL:
      BottomMessage("Change view to include entire map");
      break;
    case IDC_CB_ZOOMWIN:
      BottomMessage("Change view to include a window that you draw");
      break;

    default:
      BottomMessage("");
      break;
  }
}


