// Global Variables for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#define DOOMED_GLOBALS      // to avoid including Globals.h

#include "DoomEd40.hpp"

// Windows stuff:
HWND         hwnd;               // handle to our window
HINSTANCE    hinst;              // handle to our instance
HDC          hdc;                // device context - our client area
WNDCLASS     rClass;             // our class
WNDCLASS     dClass;             // our Dialog box class
HWND         hDialogWindow;      // our Dialog box handle
HANDLE       hAccel;             // accelerator table
HPALETTE     hPalette;           // palette of 256 colors
HCURSOR      oldCursor;
HCURSOR      hCursorMag;         // Magnifying glass
POINT        MouseOnScreen;      // mostly for zooms...
BOOL         ReallyBusy = FALSE; // for multi-tasking emulation
HWND         hCBSave;            // the save button on the control bar

// Modeless Dialog stuff:
HWND         Frontmost;          // which modeless dialog gets messages
HWND         hwndDialogThing = 0;       // modeless dialog boxes
HWND         hwndDialogSector = 0;
HWND         hwndDialogLineDef = 0;
HWND         hwndDialogSplash = 0;
HWND         hwndControlBar = 0;
HWND         hwndControlBot = 0;
HWND         hwndTileViewer = 0;
HWND         hwndTextureViewer = 0;
HWND         hwndProblems = 0;
HWND         hwndViewer = 0;
FARPROC      lpfnDialogThing = NULL;    // function pointers
FARPROC      lpfnDialogSector = NULL;
FARPROC      lpfnDialogLineDef = NULL;
FARPROC      lpfnDialogSplash = NULL;
FARPROC      lpfnControlBar = NULL;
FARPROC      lpfnControlBot = NULL;
FARPROC      lpfnTileViewer = NULL;
FARPROC      lpfnTextureViewer = NULL;
FARPROC      lpfnProblems = NULL;
FARPROC      lpfnViewer = NULL;

// 3d stuff:
RectArray    Rect;

// Pens and brushes:
HPEN         hPenBackground, hPenMapLines, hPenMapInnerLines,
             hPenSelected, hPenMarked, hPenDialogs, hPenGrid,
             hPenUserGrid, hPenDrag;
HBRUSH       hBrushBackground, hBrushMapLines, hBrushMapInnerLines,
             hBrushSelected, hBrushMarked, hBrushDialogs, hBrushGrid,
             hBrushUserGrid;
HBRUSH       hBrushNull;         // for null filled rectangles
HPEN         hOriginalPen;
HBRUSH       hOriginalBrush;

// Colors:
COLORREF     ColorBackground;
COLORREF     ColorMapLines;
COLORREF     ColorMapInnerLines;
COLORREF     ColorSelected;
COLORREF     ColorMarked;
COLORREF     ColorGrid;
COLORREF     ColorUserGrid;
HGLOBAL      hgPalette;

// memory allocation:
HGLOBAL      hgDoom, hgDir,
             hgVertex, hgLineDef, hgSideDef, hgSector,
             hgThing, hgNode, hgSSector, hgSeg,
             hgTag, hgReject, hgBlockMap,
             hgeVertex, hgeLineDef, hgeSideDef, hgeSector,
             hgeThing, hgProblem,
             hgStyle, hgBuilder;

int          MAX_VERTEX,
             MAX_LINEDEF,
             MAX_SIDEDEF,
             MAX_SECTOR,
             MAX_THING,
             MAX_NODE,
             MAX_SSECTOR,
             MAX_SEG,
             MAX_TAG,
             MAX_STYLE,
             MAX_BUILDER;

// data structures:
// Wad directories:
WadDir           FAR  *Doom;           // Doom.Wad directory
int                    DoomEntries;
WadDir           FAR  *Dir;            // external Wad directory
int                    DirEntries;
DWORD                  WadSize = 0,    // for status and determining
                       WadUsed = 0;    // if a purge is required.

// current map:
WadThings      __huge *Thing;
POINT          __huge *Vertex;
WadLineDefs    __huge *LineDef;
WadSideDefs    __huge *SideDef;
WadSectors     __huge *Sector;
WadNodes       __huge *Node;
WadSSectors    __huge *SSector;
WadSegs        __huge *Seg;
WadTags          FAR  *Tag;              // Platform
BYTE             FAR  *Reject;           // reject data block
DWORD                  RejectSize;       // how big it is (bytes)
int              FAR  *BlockMap;         // blockmap data block
DWORD                  BlockMapSize;     // how big it is (bytes)
char                   szMapName[10];    // title (ie. E1M1)
ExtraVertex    __huge *eVertex;
ExtraThings    __huge *eThing;
ExtraLineDefs  __huge *eLineDef;
ExtraSideDefs  __huge *eSideDef;
ExtraSectors   __huge *eSector;
int                    NextTag,
                       CurrentTag,
                       TagShowing;

prob             FAR  *Problem;
int                    ProblemsNum;

RECT                   SelRect;            // for outlining multiple selections
int                    SelectedThings = 0,
                       SelectedVertexes = 0,
                       SelectedLineDefs = 0,
                       SelectedSectors = 0;
int                    CurrentThing = Nothing,
                       CurrentVertex = Nothing,
                       CurrentSector = Nothing,
                       CurrentLineDef = Nothing;
BOOL                   CreatingSectorWithinSector = FALSE;

// Map information:
int          VertexNum, LineDefsNum, ThingsNum, NodesNum, SectorsNum,
             SideDefsNum, SSectorsNum, SegsNum, TagsNum;
RECT         MapExtent;          // how big the map is
RECT         MapOnScreen;        // how much is displayed
RECT         PreviousZoom;       // for ZoomPrev button
int          GridSize = 16;      // the snap-to grid size
WadThings    DefThing;           // default for new additions
WadLineDefs  DefLineDef;
WadSideDefs  DefSideDef;
WadSectors   DefSector;
int          MapEntry = 0;       // where the map came from (and goes)
int          SectorInside = Nothing;

// Bitmap stuff
int          ViewerOffsetX, ViewerOffsetY;  // lock point
PALETTEENTRY Pal[256];
HBITMAP      hBitmap;
WORD         BitmapWidth, BitmapHeight;

// Textures and related support:
int          TexturesNum;
TextureInfo *Texture;
int          PNamesNum;
PNames      *PName;

// Multimedia stuff (sounds & music)
struct       WadSoundHeader wsh;
struct       WavSoundHeader wav;

// Sector creation stuff:
int          DefaultSectorBottom = 0;
int          DefaultSectorTop    = 128;
int          DefaultSectorLight  = 200;
int          vv;                 // needed for Wall macros
int          floorUD = S_RAISED, 
             ceilUD = S_LOWERED;

// Task tracking
TASKENTRY    te;
BOOL         WaitingForTask = FALSE;
HTASK        TaskToWatch = NULL;
UINT         hTimer = NULL;
PENDING      Pending;            // only one pending for now

// Flags and Options:
BOOL         ShowGrid = TRUE;
BOOL         RegisteredVersion = FALSE;
         //  note: macro SharewareVersion = (!RegisteredVersion)
BOOL         ShowingSplash = FALSE;
BOOL         PaletteLoaded = FALSE;
BOOL         MapLoaded = FALSE;
BOOL         MapEdited = FALSE;
BOOL         MapNodes  = FALSE; // whether changes require node build
BOOL         WaitGraphics = FALSE;
BOOL         WaitSound = FALSE;
BOOL         WaitMusic = FALSE;
BOOL         WaitAnsi = FALSE;
BOOL         ShowingSectorRectangle = FALSE;
int          Paradigm = P_SECTOR;
int          Tool = T_THING;
int          MouseAction = MA_NORMAL;
int          NodeBuilderAction;
int          RejectAction;
int          DoomVersion = 1;
// options selectable using Options dialog
BOOL         oVerifyExit;
BOOL         oShowSnapToGrid;
BOOL         oShow64x64Grid;
BOOL         oBuildNodesAtEverySave;
BOOL         oAutoStitchDuringConstruction;
BOOL         oAutoLoadMostRecentFile;
BOOL         oVerifyAfterEdit;

// strings:
// constants:
char         Direction[8][10] = { "East", "NorthEast", "North", "NorthWest",
                                  "West", "SouthWest", "South", "SouthEast" };
// variables:
char         lpszMessage[255];   // for loading strings
char         DefaultSectorWall[10]  = "MARBLE1";
char         DefaultSectorFloor[10] = "FLAT5_2";
char         DefaultSectorCeil[10]  = "CEIL1_1";
// filenames:
char         szDoomWad[128] = "PlaceHolder - fully qualified Doom.Wad filename";
char         szThingsDef[128] = "PlaceHolder - fully qualified Things.Def filename";
char         szSound[128] = "PlaceHolder - fully qualified sound file name";
char         szMusic[128] = "PlaceHolder - fully qualified music file name";
char         szBitmap[128] = "PlaceHolder - fully qualified bitmap file name";
char         szEndScreen[128] = "PlaceHolder - fully qualified ansi text file name";
char         szExportFile[128] = "PlaceHolder - fully qualified export file name";
char         szPrevFile1[128] = "PlaceHolder - previous filename 1";
char         szPrevFile2[128] = "PlaceHolder - previous filename 2";
char         szPrevFile3[128] = "PlaceHolder - previous filename 3";
char         szPrevFile4[128] = "PlaceHolder - previous filename 4";
char         szEditorGraphics[128] = "PlaceHolder - Full executeable name for Graphics Editor";
char         szEditorText[128] = "PlaceHolder - fully qualified executeable name for Text Editor";
char         szEditorAnsi[128] = "PlaceHolder - fully qualified executeable name for Ansi Editor";
char         szEditorSound[128] = "PlaceHolder - fully qualified executeable name for Sound Editor";
char         szEditorMusic[128] = "PlaceHolder - fully qualified executeable name for Music Editor";
// directory names:
char         szDoomDir[128] = "PlaceHolder - Doom directory name";
char         szExportDir[128] = "PlaceHolder - Export directory name";

// styles:
int          StylesNum = 0;
Styles       FAR *Style;

// BSP Builders
int          BuildersNum;
Builders     FAR *Builder;

// thing descriptions and bitmaps:
int          ThingUnknown;   // the listbox entry for Unknown

dThing  ThingDesc[128] = {
        "Armor: Green",                 2018,   "ARM1A0",
        "Armor: Blue",                  2019,   "ARM2A0",
        "Block: Big Tree",              54,     "TRE2A0",
        "Block: Blue Torch",            44,     "TBLUA0",
        "Block: Blue Torch Short",      55,     "SMBTA0",
        "Block: Burnt Tree",            43,     "TRE1A0",
        "Block: Evil Eye",              41,     "CEYEA0",
        "Block: Float Skull",           42,     "FSKUA0",
        "Block: Green Pillar Big",      30,     "COL1A0",
        "Block: Green Pillar Heart",    36,     "COL5A0",
        "Block: Green Pillar Short",    31,     "COL2A0",
        "Block: Green Torch",           45,     "TGRNA0",
        "Block: Green Torch Short",     56,     "SMGTA0",
        "Block: Red Torch",             46,     "TREDA0",
        "Block: Red Torch Short",       57,     "SMRTA0",
        "Block: Red Pillar Big",        32,     "COL3A0",
        "Block: Red Pillar Short",      33,     "COL4A0",
        "Block: Red Pillar Skull",      37,     "COL6A0",
        "Block: Stalagmite",            47,     "SMITA0",
        "Block: Techno Pillar",         48,     "ELECA0",
        "Bonus: Health Potion",         2014,   "BON1A0",
        "Bonus: Spirit Armor",          2015,   "BON2A0",
        "Dead: Bottom Me",              12,     "PLAYW0",
        "Dead: Gibs",                   24,     "POB1A0",
        "Dead: Head",                   22,     "HEADL0",
        "Dead: Player",                 15,     "PLAYN0",
        "Dead: Possessed Human",        18,     "POSSL0",
        "Dead: Poss. Shotgunman",       19,     "SPOSL0",
        "Dead: Pink Demon",             21,     "SARGN0",
        "Dead: Torso Me",               10,     "PLAYW0",
        "Dead: Trooper",                20,     "TROOM0",
        "Demon: Pink",                  3002,   "SARGA1",
        "Demon: Arachnotron",           68,     "BSPIA1D1",
        "Demon: ArchVile",              64,     "VILEA1D1",
        "Demon: Baron Of Hell",         3003,   "BOSSA1",
        "Demon: BossBrain",             88,     "BBRNA0",
        "Demon: BossShooter",           89,     "BOSFA0",
        "Demon: Cacodemon",             3005,   "HEADA1",
        "Demon: Cyberdemon",            16,     "CYBRA1",
        "Demon: HellKnight",            69,     "BOS2A1C1",
        "Demon: Imp",                   3001,   "TROOA1",
        "Demon: LostSoul",              3006,   "SKULA1",
        "Demon: Mancubus",              67,     "FATTA1",
        "Demon: PainElemental",         71,     "PAINA1",
        "Demon: PossChaingunner",       65,     "CPOSA1",
        "Demon: PossHuman",             3004,   "POSSA1",
        "Demon: PossShotgunman",        9,      "SPOSA1",
        "Demon: Revenant",              66,     "SKELA1D1",
        "Demon: Spawnspot",             87,     "BOSFC0",
        "Demon: Spectre",               58,     "SARGA5",
        "Demon: SpiderMastermind",      7,      "SPIDA1D1",
        "Demon: Wolfenstein SS",        84,     "SSWVA1",
        "Fred: Barrel",                 2035,   "BAR1A0",
        "Fred: Bloody Twitcher",        49,     "GOR1A0",
        "Fred: Bloody Twitcher Noblock", 63,    "GOR1A0",
        "Fred: Bloody Brain And Stem",  81,     "BRS1A0",
        "Fred: Bunch Of Heads",         28,     "POL2A0",
        "Fred: Burning Barrel",         70,     "FCANA0",
        "Fred: Candelabra",             35,     "CBRAA0",
        "Fred: Candle",                 34,     "CANDA0",
        "Fred: Colon Gibs",             79,     "POL5A0",
        "Fred: Hanging",                50,     "GOR2A0",
        "Fred: Hanging Keen",           72,     "KEENA0",
        "Fred: Hanging Leg",            52,     "GOR5A0",
        "Fred: Hanging Leg Noblock",    59,     "GOR5A0",
        "Fred: Hanging Noblock",        60,     "GOR2A0",
        "Fred: Hanging No Guts",        73,     "HDB1A0",
        "Fred: Hanging No Guts/Brain",  74,     "HDB2A0",
        "Fred: Hanging NoLeg",          51,     "GOR3A0",
        "Fred: Hanging No Leg Noblock", 61,     "GOR3A0",
        "Fred: Hanging Torso Look Down",75,     "HDB3A0",
        "Fred: Hanging Torso Look Up",  77,     "HDB5A0",
        "Fred: Hanging Torso NoBrain",  78,     "HDB6A0",
        "Fred: Hanging Torso OpenHead", 76,     "HDB4A0",
        "Fred: Hanging Two Legs",       53,     "GOR4A0",
        "Fred: Hanging Two Legs Noblock", 62,   "GOR4A0",
        "Fred: Head On A Stick",        27,     "POL4A0",
        "Fred: Heads & Candles",        29,     "POL3A0",
        "Fred: On A Stick Dead",        25,     "POL1A0",
        "Fred: On A Stick Live",        26,     "POL6A0",
        "Fred: Small Pool of Gibs",     80,     "POB2A0",
        "Fred: TechLight Column",       85,     "TLMPA0",
        "Fred: TechLight Column Short", 86,     "TLP2A0",
        "Fred: Low Electric Lamp",      2028,   "COLUA0",
        "Health: Medikit",              2012,   "MEDIA0",
        "Health: MegaSphere",           83,     "MEGAA0",
        "Health: Soul Sphere",          2013,   "SOULA0",
        "Health: Stimpack",             2011,   "STIMA0",
        "Key: Blue",                    5,      "BKEYA0",
        "Key: Blue Skull",              40,     "BSKUA0",
        "Key: Red",                     13,     "RKEYA0",
        "Key: Red Skull",               38,     "RSKUA0",
        "Key: Yellow",                  6,      "YKEYA0",
        "Key: Yellow Skull",            39,     "YSKUA0",
        "Player 1 start",               1,      "PLAYA1",
        "Player 2 start",               2,      "WIBP2",
        "Player 3 start",               3,      "WIBP3",
        "Player 4 start",               4,      "WIBP4",
        "Player Deathmatch",            11,     "BLUDC0",
        "PowerUp: Invulnerable",        2022,   "PINVA0",
        "PowerUp: Berserk",             2023,   "PSTRA0",
        "PowerUp: Invisible",           2024,   "PINSA0",
        "PowerUp: Radiation Suit",      2025,   "SUITA0",
        "PowerUp: SuperMap",            2026,   "PMAPA0",
        "PowerUp: Light Amplification", 2045,   "PVISA0",
        "TeleportMan",                  14,     "CANDA0",
        "Ammo: Backpack",               8,      "BPAKA0",
        "Ammo: Cell",                   2047,   "CELLA0",
        "Ammo: Cell Pack",              17,     "CELPA0",
        "Ammo: Clip",                   2007,   "CLIPA0",
        "Ammo: Clips o Plenty",         2048,   "AMMOA0",
        "Ammo: Rocket",                 2010,   "ROCKA0",
        "Ammo: Rockets o Plenty",       2046,   "BROKA0",
        "Ammo: Shells",                 2008,   "SHELA0",
        "Ammo: Shells o Plenty",        2049,   "SBOXA0",
        "Weapon: BFG-9000",             2006,   "BFUGA0",
        "Weapon: Chaingun",             2002,   "MGUNA0",
        "Weapon: Chainsaw",             2005,   "CSAWA0",
        "Weapon: Plasma Gun",           2004,   "PLASA0",
        "Weapon: Rocket Launcher",      2003,   "LAUNA0",
        "Weapon: Shotgun",              2001,   "SHOTA0",
        "Weapon: Supershotgun",         82,     "SGN2A0",
        "UNKNOWN",                      0,      "M_DOOM"
    };