// Common Dialog Box calls for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

// July 9 - decided not to do this for everything:

// June:
// Everything that uses common dialog boxes should be in here,
// which will make it easier to port to another platform.

// Common Dialog boxes are simply shortcuts to well defined,
// robust dialogs for file open/save/saveas, color control,
// printer setup, etc.

// Purpose:
// allow the user to define the Doom.Wad file
// must set the global variable szDoomWad to the full pathname
void DefineDoomWad(void)
{
  int           cbString, i;
  char          szFilter[128], szTemp[128], chReplace;
  OPENFILENAME  ofn;

  strcpy(szTemp, szDoomWad);
  cbString = LoadString(hinst, IDS_FILTER_WAD,
                        szFilter, sizeof(szFilter));
  chReplace = szFilter[cbString - 1];
  for(i = 0; szFilter[i] != '\0'; i++)
    if(szFilter[i] == chReplace)
      szFilter[i] = '\0';
  memset(&ofn, 0, sizeof(OPENFILENAME));
  ofn.lStructSize     = sizeof(OPENFILENAME);
  ofn.hwndOwner       = hwnd;
  ofn.lpstrFilter     = szFilter;
  ofn.nFilterIndex    = 1;
  ofn.lpstrFile       = szTemp;
  ofn.nMaxFile        = sizeof(szTemp);
  ofn.lpstrFileTitle  = NULL;
  ofn.nMaxFileTitle   = 0;
  ofn.lpstrInitialDir = szDoomDir;
  ofn.Flags           = OFN_PATHMUSTEXIST |
                        OFN_FILEMUSTEXIST;
  ofn.lpstrTitle      = "Looking for DOOM.WAD";
  if(GetOpenFileName(&ofn))
    strcpy(szDoomWad, szTemp);
    // only keep it if it was a valid filename
}

// Purpose:
// allow the user to define the Things.Def file
// must set the global variable szThingsDef to the full pathname
void DefineThingsDef(void)
{
    ;
}

BOOL OpenAFile(void)    // TRUE if ok, else FALSE
{
  int           cbString, i;
  char          szFilter[128], szTemp[128], chReplace;
  OPENFILENAME  ofn;
  HMENU         hMenu;

  strcpy(szTemp, "*.wad");
  cbString = LoadString(hinst, IDS_FILTER_ALL,
                        szFilter, sizeof(szFilter));
  chReplace = szFilter[cbString - 1];
  for(i = 0; szFilter[i] != '\0'; i++)
    if(szFilter[i] == chReplace)
      szFilter[i] = '\0';
  memset(&ofn, 0, sizeof(OPENFILENAME));
  ofn.lStructSize     = sizeof(OPENFILENAME);
  ofn.hwndOwner       = hwnd;
  ofn.lpstrFilter     = szFilter;
  ofn.nFilterIndex    = 2;
  ofn.lpstrFile       = szTemp;
  ofn.nMaxFile        = sizeof(szTemp);
  ofn.lpstrFileTitle  = NULL;
  ofn.nMaxFileTitle   = 0;
  ofn.lpstrInitialDir = szDoomDir;
  ofn.Flags           = OFN_PATHMUSTEXIST |
                        OFN_FILEMUSTEXIST;
  ofn.lpstrTitle      = "Open Existing File";
  if(GetOpenFileName(&ofn)) {
    if(strcmp(szTemp, szPrevFile1) == 0)
      return TRUE;
    if(strcmp(szTemp, szPrevFile2) == 0) {
      strcpy(szPrevFile2, szPrevFile1);
      strcpy(szPrevFile1, szTemp);
      goto TackList;
      }
    if(strcmp(szTemp, szPrevFile3) == 0) {
      strcpy(szPrevFile3, szPrevFile2);
      strcpy(szPrevFile2, szPrevFile1);
      strcpy(szPrevFile1, szTemp);
      goto TackList;
      }
    // Otherwise:
    strcpy(szPrevFile4, szPrevFile3);
    strcpy(szPrevFile3, szPrevFile2);
    strcpy(szPrevFile2, szPrevFile1);
    strcpy(szPrevFile1, szTemp);

TackList:
    // tack the recent files list onto the File menu
    hMenu = GetSubMenu(GetMenu(hwnd), 0);   // handle of "file" menu
    RemoveMenu(hMenu, ID_FILE_FILE1, MF_BYCOMMAND);
    RemoveMenu(hMenu, ID_FILE_FILE2, MF_BYCOMMAND);
    RemoveMenu(hMenu, ID_FILE_FILE3, MF_BYCOMMAND);
    RemoveMenu(hMenu, ID_FILE_FILE4, MF_BYCOMMAND);
    if(szPrevFile1[0] != '\0') {
      AppendMenu(hMenu, MF_ENABLED, ID_FILE_FILE1, szPrevFile1);
    if(szPrevFile2[0] != '\0')
      AppendMenu(hMenu, MF_ENABLED, ID_FILE_FILE2, szPrevFile2);
    if(szPrevFile3[0] != '\0')
      AppendMenu(hMenu, MF_ENABLED, ID_FILE_FILE3, szPrevFile3);
    if(szPrevFile4[0] != '\0')
      AppendMenu(hMenu, MF_ENABLED, ID_FILE_FILE4, szPrevFile4);
      }
    return TRUE;
    }
  else
    return FALSE;
}

BOOL FileNameExportDWD(void)
{
  int           cbString, i;
  char          szFilter[128], chReplace;
  OPENFILENAME  ofn;

  strcpy(szExportFile, "*.dwd");
  cbString = LoadString(hinst, IDS_FILTER_DWD,
                        szFilter, sizeof(szFilter));
  chReplace = szFilter[cbString - 1];
  for(i = 0; szFilter[i] != '\0'; i++)
    if(szFilter[i] == chReplace)
      szFilter[i] = '\0';
  memset(&ofn, 0, sizeof(OPENFILENAME));
  ofn.lStructSize     = sizeof(OPENFILENAME);
  ofn.hwndOwner       = hwnd;
  ofn.lpstrFilter     = szFilter;
  ofn.nFilterIndex    = 1;
  ofn.lpstrFile       = szExportFile;
  ofn.nMaxFile        = sizeof(szExportFile);
  ofn.lpstrFileTitle  = NULL;
  ofn.nMaxFileTitle   = 0;
  ofn.lpstrInitialDir = szExportDir;
  ofn.Flags           = OFN_OVERWRITEPROMPT;
  ofn.lpstrTitle      = "Export DWD file";
  return GetSaveFileName(&ofn);
}

// Purpose:
// allow user to choose a directory for exporting
void DefineExportDirectory(void)
{
}

// Purpose:
// Allow the user to select printing options
void DefinePrinting(void)
{
  // moved to Print.c - since it's integrated with the print procedure...
}

