VERSION 2.00
Begin Form Viewer 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "WAD"
   ClientHeight    =   5730
   ClientLeft      =   420
   ClientTop       =   1200
   ClientWidth     =   9045
   ClipControls    =   0   'False
   ControlBox      =   0   'False
   Height          =   6420
   HelpContextID   =   1000
   Icon            =   VIEWER.FRX:0000
   Left            =   360
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   5730
   ScaleWidth      =   9045
   Top             =   570
   Width           =   9165
   Begin Frame FrmOffs 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Offsets"
      ForeColor       =   &H00000000&
      Height          =   2235
      Left            =   7140
      TabIndex        =   6
      Top             =   720
      Width           =   1815
      Begin CommandButton CmdOffs 
         Caption         =   "Apply"
         Height          =   315
         Left            =   960
         TabIndex        =   7
         Top             =   1800
         Width           =   735
      End
      Begin VScrollBar SetOfsY 
         Height          =   1155
         HelpContextID   =   4080
         LargeChange     =   10
         Left            =   1440
         Max             =   -400
         Min             =   400
         TabIndex        =   8
         Top             =   180
         Width           =   255
      End
      Begin HScrollBar SetOfsX 
         Height          =   240
         HelpContextID   =   4080
         LargeChange     =   10
         Left            =   120
         Max             =   -640
         Min             =   640
         TabIndex        =   10
         Top             =   1080
         Width           =   1215
      End
      Begin Image SetOfs 
         BorderStyle     =   1  'Fixed Single
         Height          =   330
         Index           =   5
         Left            =   1380
         Picture         =   VIEWER.FRX:0302
         Top             =   1380
         Width           =   330
      End
      Begin Image SetOfs 
         BorderStyle     =   1  'Fixed Single
         Height          =   330
         Index           =   4
         Left            =   960
         Picture         =   VIEWER.FRX:046C
         Top             =   1380
         Width           =   330
      End
      Begin Image SetOfs 
         BorderStyle     =   1  'Fixed Single
         Height          =   330
         Index           =   3
         Left            =   540
         Picture         =   VIEWER.FRX:05D6
         Top             =   1380
         Width           =   330
      End
      Begin Image SetOfs 
         BorderStyle     =   1  'Fixed Single
         Height          =   330
         Index           =   2
         Left            =   540
         Picture         =   VIEWER.FRX:0740
         Top             =   1800
         Width           =   330
      End
      Begin Image SetOfs 
         BorderStyle     =   1  'Fixed Single
         Height          =   330
         Index           =   1
         Left            =   120
         Picture         =   VIEWER.FRX:08AA
         Top             =   1380
         Width           =   330
      End
      Begin Image SetOfs 
         BorderStyle     =   1  'Fixed Single
         Height          =   330
         Index           =   0
         Left            =   120
         Picture         =   VIEWER.FRX:0A14
         Top             =   1800
         Width           =   330
      End
      Begin Label Relatv 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         BackStyle       =   0  'Transparent
         Caption         =   "Ground Spot"
         ForeColor       =   &H00000000&
         Height          =   195
         Left            =   120
         TabIndex        =   12
         Top             =   780
         Width           =   1155
      End
      Begin Label Info 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         Caption         =   "Reference:"
         ForeColor       =   &H00800000&
         Height          =   195
         Index           =   0
         Left            =   120
         TabIndex        =   13
         Top             =   540
         Width           =   1095
      End
      Begin Label ShowOfsY 
         BackColor       =   &H00C0C0C0&
         BackStyle       =   0  'Transparent
         Caption         =   "0"
         Height          =   195
         Left            =   660
         TabIndex        =   21
         Top             =   300
         Width           =   495
      End
      Begin Label Info 
         BackStyle       =   0  'Transparent
         Caption         =   ":"
         ForeColor       =   &H00800000&
         Height          =   195
         Index           =   3
         Left            =   600
         TabIndex        =   22
         Top             =   300
         Width           =   75
      End
      Begin Label ShowOfsX 
         Alignment       =   1  'Right Justify
         BackColor       =   &H00C0C0C0&
         BackStyle       =   0  'Transparent
         Caption         =   "0"
         Height          =   195
         Left            =   120
         TabIndex        =   23
         Top             =   300
         Width           =   480
      End
   End
   Begin Frame FrmView 
      BackColor       =   &H00C0C0C0&
      ForeColor       =   &H00000000&
      Height          =   2115
      Left            =   7140
      TabIndex        =   40
      Top             =   3000
      Width           =   1815
      Begin Label Info 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         Caption         =   "Frame:"
         ForeColor       =   &H00800000&
         Height          =   195
         Index           =   7
         Left            =   60
         TabIndex        =   24
         Top             =   1800
         Width           =   675
      End
      Begin Label View 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         Caption         =   "-"
         Height          =   255
         Index           =   3
         Left            =   780
         TabIndex        =   25
         Top             =   1740
         Width           =   915
      End
      Begin Label View 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         Caption         =   "-"
         Height          =   255
         Index           =   2
         Left            =   120
         TabIndex        =   26
         Top             =   1440
         Width           =   1575
      End
      Begin Label Info 
         BackStyle       =   0  'Transparent
         Caption         =   "Mirrored Viewpoint: "
         ForeColor       =   &H00800000&
         Height          =   195
         Index           =   6
         Left            =   60
         TabIndex        =   27
         Top             =   1200
         Width           =   1695
      End
      Begin Label View 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         Caption         =   "-"
         Height          =   255
         Index           =   1
         Left            =   780
         TabIndex        =   44
         Top             =   780
         Width           =   915
      End
      Begin Label Info 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         Caption         =   "Frame:"
         ForeColor       =   &H00800000&
         Height          =   195
         Index           =   5
         Left            =   60
         TabIndex        =   43
         Top             =   840
         Width           =   675
      End
      Begin Label View 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         Caption         =   "-"
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   42
         Top             =   480
         Width           =   1575
      End
      Begin Label Info 
         BackStyle       =   0  'Transparent
         Caption         =   "Normal Viewpoint:"
         ForeColor       =   &H00800000&
         Height          =   195
         Index           =   4
         Left            =   60
         TabIndex        =   41
         Top             =   240
         Width           =   1575
      End
   End
   Begin CommandButton CmdNext 
      Caption         =   "Next"
      Height          =   315
      Index           =   1
      Left            =   900
      TabIndex        =   15
      Top             =   4800
      Width           =   555
   End
   Begin CommandButton CmdNext 
      Caption         =   "Prev."
      Height          =   315
      Index           =   0
      Left            =   240
      TabIndex        =   29
      Top             =   4800
      Width           =   555
   End
   Begin ListBox DirB 
      BackColor       =   &H00C0C0C0&
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Courier"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   3735
      HelpContextID   =   500
      Left            =   120
      MultiSelect     =   2  'Extended
      TabIndex        =   28
      Top             =   780
      Width           =   1575
   End
   Begin Frame FrmAuthor 
      BackColor       =   &H00C0C0C0&
      Height          =   3795
      Left            =   2640
      TabIndex        =   18
      Top             =   780
      Width           =   5475
      Begin CommandButton CmdReg 
         Caption         =   "Registration Info"
         Height          =   315
         Left            =   1800
         TabIndex        =   0
         Top             =   3120
         Width           =   1575
      End
      Begin Label banner 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         BackStyle       =   0  'Transparent
         Caption         =   "This program is shareware."
         ForeColor       =   &H00800000&
         Height          =   255
         Index           =   3
         Left            =   780
         TabIndex        =   31
         Top             =   2760
         Width           =   3615
      End
      Begin Label banner 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         BackStyle       =   0  'Transparent
         Caption         =   "DOOM, DOOM2, HERETIC and HEXEN "
         ForeColor       =   &H00800000&
         Height          =   255
         Index           =   6
         Left            =   840
         TabIndex        =   9
         Top             =   1980
         Width           =   3555
      End
      Begin Label banner 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         BackStyle       =   0  'Transparent
         Caption         =   "by id software and raven software."
         ForeColor       =   &H00000000&
         Height          =   255
         Index           =   4
         Left            =   840
         TabIndex        =   33
         Top             =   2220
         Width           =   3555
      End
      Begin Label banner 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         BackStyle       =   0  'Transparent
         Caption         =   "WAD editor for the games"
         ForeColor       =   &H00000000&
         Height          =   255
         Index           =   5
         Left            =   900
         TabIndex        =   32
         Top             =   1740
         Width           =   3495
      End
      Begin Label banner 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         BackStyle       =   0  'Transparent
         Caption         =   "July 96"
         ForeColor       =   &H00FF0000&
         Height          =   255
         Index           =   1
         Left            =   1680
         TabIndex        =   30
         Top             =   1200
         Width           =   1755
      End
      Begin Label banner 
         BackColor       =   &H00C0C0C0&
         BackStyle       =   0  'Transparent
         Caption         =   "by Olivier Montanuy"
         ForeColor       =   &H00800080&
         Height          =   255
         Index           =   2
         Left            =   1740
         TabIndex        =   16
         Top             =   900
         Width           =   1815
      End
      Begin Label banner 
         BackColor       =   &H00C0C0C0&
         BackStyle       =   0  'Transparent
         Caption         =   "WinTex 4.4"
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "MS Serif"
         FontSize        =   24
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H00800000&
         Height          =   495
         Index           =   0
         Left            =   1320
         TabIndex        =   17
         Top             =   360
         Width           =   2535
      End
   End
   Begin PictureBox LvlB 
      BackColor       =   &H00000000&
      BorderStyle     =   0  'None
      Height          =   4155
      Left            =   1860
      ScaleHeight     =   4155
      ScaleWidth      =   6915
      TabIndex        =   37
      Top             =   780
      Width           =   6915
   End
   Begin Frame FrmSDir 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Directory"
      ForeColor       =   &H00000000&
      Height          =   4395
      Left            =   7140
      TabIndex        =   38
      Top             =   720
      Width           =   1815
      Begin ListBox SDirB 
         BackColor       =   &H00C0C0C0&
         ForeColor       =   &H00000000&
         Height          =   3540
         Left            =   120
         TabIndex        =   39
         Top             =   720
         Width           =   1575
      End
      Begin Label SDirRef 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "-"
         ForeColor       =   &H00000000&
         Height          =   255
         Left            =   1020
         TabIndex        =   34
         Top             =   360
         Width           =   675
      End
      Begin Label Info 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         Caption         =   "Entry:"
         ForeColor       =   &H00800000&
         Height          =   195
         Index           =   1
         Left            =   180
         TabIndex        =   35
         Top             =   360
         Width           =   675
      End
   End
   Begin ListBox LstB 
      BackColor       =   &H00808080&
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Fixedsys"
      FontSize        =   9
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   4305
      Left            =   1860
      TabIndex        =   36
      Top             =   780
      Visible         =   0   'False
      Width           =   6975
   End
   Begin Frame FrmPic 
      BackColor       =   &H00C0C0C0&
      ForeColor       =   &H00000000&
      Height          =   4155
      Left            =   1860
      TabIndex        =   1
      Top             =   720
      Visible         =   0   'False
      Width           =   5235
      Begin PictureBox PicB 
         BackColor       =   &H00C0C0C0&
         BorderStyle     =   0  'None
         Height          =   3675
         Left            =   180
         ScaleHeight     =   3675
         ScaleWidth      =   4800
         TabIndex        =   2
         Top             =   240
         Width           =   4800
      End
      Begin Line GndLine 
         Index           =   0
         Visible         =   0   'False
         X1              =   0
         X2              =   5160
         Y1              =   2580
         Y2              =   2580
      End
      Begin Line GndLine 
         Index           =   1
         Visible         =   0   'False
         X1              =   2400
         X2              =   2400
         Y1              =   120
         Y2              =   4140
      End
   End
   Begin Image DirType 
      BorderStyle     =   1  'Fixed Single
      Height          =   330
      Index           =   9
      Left            =   3720
      Picture         =   VIEWER.FRX:0B7E
      Top             =   5280
      Width           =   330
   End
   Begin Image DirType 
      BorderStyle     =   1  'Fixed Single
      Height          =   330
      Index           =   8
      Left            =   3360
      Picture         =   VIEWER.FRX:0CE8
      Top             =   5280
      Width           =   330
   End
   Begin Image DirType 
      BorderStyle     =   1  'Fixed Single
      Height          =   330
      Index           =   7
      Left            =   3000
      Picture         =   VIEWER.FRX:0E52
      Top             =   5280
      Width           =   330
   End
   Begin Image DirType 
      BorderStyle     =   1  'Fixed Single
      Height          =   330
      Index           =   6
      Left            =   2640
      Picture         =   VIEWER.FRX:0FBC
      Top             =   5280
      Width           =   330
   End
   Begin Image DirType 
      BorderStyle     =   1  'Fixed Single
      Height          =   330
      Index           =   5
      Left            =   2160
      Picture         =   VIEWER.FRX:1126
      Top             =   5280
      Width           =   330
   End
   Begin Image DirType 
      BorderStyle     =   1  'Fixed Single
      Height          =   330
      Index           =   4
      Left            =   1800
      Picture         =   VIEWER.FRX:1290
      Top             =   5280
      Width           =   330
   End
   Begin Image DirType 
      BorderStyle     =   1  'Fixed Single
      Height          =   330
      Index           =   3
      Left            =   1320
      Picture         =   VIEWER.FRX:13FA
      Top             =   5280
      Width           =   330
   End
   Begin Image DirType 
      BorderStyle     =   1  'Fixed Single
      Height          =   330
      Index           =   2
      Left            =   960
      Picture         =   VIEWER.FRX:1564
      Top             =   5280
      Width           =   330
   End
   Begin Image DirType 
      BorderStyle     =   1  'Fixed Single
      Height          =   330
      Index           =   1
      Left            =   540
      Picture         =   VIEWER.FRX:16CE
      Top             =   5280
      Width           =   330
   End
   Begin Image DirType 
      BorderStyle     =   1  'Fixed Single
      Height          =   330
      Index           =   0
      Left            =   60
      Picture         =   VIEWER.FRX:1838
      Top             =   5280
      Width           =   330
   End
   Begin Line Line 
      BorderColor     =   &H00FFFFFF&
      BorderWidth     =   2
      Index           =   4
      X1              =   4320
      X2              =   8940
      Y1              =   5280
      Y2              =   5280
   End
   Begin Line Line 
      BorderColor     =   &H00FFFFFF&
      BorderWidth     =   2
      Index           =   5
      X1              =   4320
      X2              =   4320
      Y1              =   5280
      Y2              =   5640
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   2
      Index           =   7
      X1              =   4320
      X2              =   8940
      Y1              =   5640
      Y2              =   5640
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   2
      Index           =   6
      X1              =   8940
      X2              =   8940
      Y1              =   5280
      Y2              =   5640
   End
   Begin Line Line 
      BorderColor     =   &H00FFFFFF&
      BorderWidth     =   2
      Index           =   0
      X1              =   60
      X2              =   8880
      Y1              =   60
      Y2              =   60
   End
   Begin Line Line 
      BorderColor     =   &H00FFFFFF&
      BorderWidth     =   2
      Index           =   1
      X1              =   60
      X2              =   60
      Y1              =   60
      Y2              =   540
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   2
      Index           =   3
      X1              =   8880
      X2              =   8880
      Y1              =   60
      Y2              =   540
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   2
      Index           =   2
      X1              =   60
      X2              =   8880
      Y1              =   540
      Y2              =   540
   End
   Begin Label EntryId 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      Caption         =   "-"
      ForeColor       =   &H00800000&
      Height          =   255
      Left            =   7080
      TabIndex        =   3
      Top             =   180
      Width           =   1755
   End
   Begin Label EntryHelp 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      ForeColor       =   &H00800000&
      Height          =   255
      Left            =   3840
      TabIndex        =   4
      Top             =   180
      Width           =   3135
   End
   Begin Label EntryPtr 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "0"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Fixedsys"
      FontSize        =   9
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Left            =   2580
      TabIndex        =   5
      Top             =   180
      Width           =   1095
   End
   Begin Label EntrySize 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "0"
      Height          =   255
      Left            =   1560
      TabIndex        =   11
      Top             =   180
      Width           =   915
   End
   Begin Label EntryNm 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "-"
      ForeColor       =   &H00000000&
      Height          =   255
      Left            =   120
      TabIndex        =   20
      Top             =   180
      Width           =   1395
   End
   Begin Label WhatsUp 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      Caption         =   "Help"
      Height          =   255
      Left            =   4380
      TabIndex        =   45
      Top             =   5340
      Width           =   4515
   End
   Begin Label PwadRef 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      BackStyle       =   0  'Transparent
      Caption         =   "PWadRef"
      ForeColor       =   &H00000080&
      Height          =   195
      Left            =   360
      TabIndex        =   19
      Top             =   2040
      Visible         =   0   'False
      Width           =   855
   End
   Begin Label PwadFile 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      Caption         =   "PwadFile"
      ForeColor       =   &H00000080&
      Height          =   255
      Left            =   180
      TabIndex        =   14
      Top             =   1800
      Visible         =   0   'False
      Width           =   1155
   End
   Begin Menu M_F0 
      Caption         =   "&File"
      Begin Menu M_Fupdt 
         Caption         =   "&Save WAD"
      End
      Begin Menu M_F1 
         Caption         =   "-"
      End
      Begin Menu M_Gwaste 
         Caption         =   "&List wasted space"
      End
      Begin Menu M_Fclean 
         Caption         =   "&Cleanup WAD"
      End
      Begin Menu M_F2 
         Caption         =   "-"
      End
      Begin Menu M_Frest 
         Caption         =   "&Cancel && Quit"
      End
      Begin Menu M_Quit 
         Caption         =   "&Quit"
      End
   End
   Begin Menu M_E0 
      Caption         =   "&Edit"
      Begin Menu M_Ecopy 
         Caption         =   "&Copy entries"
      End
      Begin Menu M_Epaste 
         Caption         =   "&Paste entries"
      End
      Begin Menu M_Ecut 
         Caption         =   "&Cut entries"
      End
      Begin Menu M_E2 
         Caption         =   "-"
      End
      Begin Menu M_Eload 
         Caption         =   "&Load entry from file"
      End
      Begin Menu M_Esave 
         Caption         =   "&Save entries to file"
      End
      Begin Menu M_E1 
         Caption         =   "-"
      End
      Begin Menu M_Eedit 
         Caption         =   "&Edit entry"
      End
   End
   Begin Menu M_A0 
      Caption         =   "&Advanced"
      Begin Menu M_ALvl 
         Caption         =   "Edit &Levels"
      End
      Begin Menu M_ATexu 
         Caption         =   "Edit &Texture"
      End
      Begin Menu M_Aflat 
         Caption         =   "Edit &Floors"
         Enabled         =   0   'False
      End
      Begin Menu M_A1 
         Caption         =   "-"
      End
      Begin Menu M_AInst 
         Caption         =   "&Install WAD"
      End
      Begin Menu M_A2 
         Caption         =   "-"
      End
      Begin Menu M_Absp 
         Caption         =   "Edit &BSP models"
      End
   End
   Begin Menu M_S0 
      Caption         =   "&Select"
      Begin Menu M_Sfind 
         Caption         =   "Find an Entry"
      End
      Begin Menu M_S1 
         Caption         =   "-"
      End
      Begin Menu M_OCMap 
         Caption         =   "&Light level..."
         Begin Menu M_OCM 
            Caption         =   "Normal (255)"
            Index           =   0
         End
         Begin Menu M_OCM 
            Caption         =   "Bright (220)"
            Index           =   1
         End
         Begin Menu M_OCM 
            Caption         =   "Middle (192)"
            Index           =   2
         End
         Begin Menu M_OCM 
            Caption         =   "Dark (128)"
            Index           =   3
         End
         Begin Menu M_OCM 
            Caption         =   "Very dark (64)"
            Index           =   4
         End
         Begin Menu M_OCM 
            Caption         =   "Invincible"
            Index           =   5
         End
      End
      Begin Menu M_S2 
         Caption         =   "-"
      End
      Begin Menu M_Sel 
         Caption         =   "&All entries"
         Index           =   0
      End
      Begin Menu M_Sel 
         Caption         =   "L&umps"
         Index           =   1
      End
      Begin Menu M_Sel 
         Caption         =   "&Graphics"
         Index           =   2
      End
      Begin Menu M_Sel 
         Caption         =   "&Sprites"
         Index           =   3
      End
      Begin Menu M_Sel 
         Caption         =   "S&ounds"
         Index           =   4
      End
      Begin Menu M_Sel 
         Caption         =   "&Music"
         Index           =   5
      End
      Begin Menu M_Sel 
         Caption         =   "&Levels"
         Index           =   6
      End
      Begin Menu M_Sel 
         Caption         =   "&Textures"
         Index           =   7
      End
      Begin Menu M_Sel 
         Caption         =   "&Patches"
         Index           =   8
      End
      Begin Menu M_Sel 
         Caption         =   "&Flats"
         Index           =   9
      End
   End
   Begin Menu M_G0 
      Caption         =   "&Guru Only"
      Begin Menu M_Gnew 
         Caption         =   "&New entry"
      End
      Begin Menu M_Grenm 
         Caption         =   "&Rename entry"
      End
      Begin Menu M_Geq 
         Caption         =   "&Make entries identical"
      End
      Begin Menu M_G1 
         Caption         =   "-"
      End
      Begin Menu M_Gren 
         Caption         =   "Use &S_END in sprites list"
         Index           =   0
      End
      Begin Menu M_Gren 
         Caption         =   "Use &F_END in flats list"
         Index           =   1
      End
   End
   Begin Menu M_M0 
      Caption         =   "&Music"
      Begin Menu M_Mstop 
         Caption         =   "&Stop music"
      End
      Begin Menu M_M1 
         Caption         =   "-"
      End
      Begin Menu M_Sound 
         Caption         =   "&No Sounds"
      End
   End
   Begin Menu M_H0 
      Caption         =   " &Help"
      Begin Menu M_Habout 
         Caption         =   "About"
      End
      Begin Menu M_H1 
         Caption         =   "-"
      End
      Begin Menu M_Hedt 
         Caption         =   "Edit WAD"
      End
      Begin Menu M_Htex 
         Caption         =   "Edit Texture"
      End
      Begin Menu M_Hlev 
         Caption         =   "Edit Levels"
      End
      Begin Menu M_Hinst 
         Caption         =   "Install WAD"
      End
   End
End
Option Explicit

Dim PWADself%    'ref of WAD object
Dim PWADmainWad% 'ref of main WAD object
Dim PWADtyp%     'type shown in PWAD
Dim PWADgame%    'game in PWAD
Dim PWADfilenam$ 'wad file name
Dim PWADsdir%       '>0 if displaying a subdir entry
Dim PWADsdirEntry%  'subdir container entry
Dim PWADsdirName$   'subdir container name
'
Dim PicBB As windoze 'picture box
Dim LvlBB As windoze 'level picture box
Dim LstBB As windoze 'text list box
Dim SDirBB As windoze 'subdir list box

Sub CmdNext_Click (Index As Integer)
  'look for previous/next entry  0=down, 1=up
  'select direction
  Dim add%
  add% = Index% * 2 - 1 ' -1, 1
  Dim n%, Max%
  Max% = DirB.ListCount
  n% = DirB.ListIndex
  If n% < 0 Or Max% <= 0 Then Exit Sub
  DirB.Selected(n%) = False
  '
  Dim match$
  match$ = Left$(DirB.List(n%), 4)
  Do
    n% = n% + add%
    If n% < 0 Or n% >= Max% Then Exit Sub
    If Left$(DirB.List(n%), 4) <> match$ Then Exit Do
  Loop
  DirB.ListIndex = n%
  DirB.Selected(n%) = True 'Call DirB_Click
End Sub

Sub CmdOffs_Click ()
  If Not tutor(1, " modify the placement of the picture (the offsets). It is NOT reversible.") Then Exit Sub
  '
  Dim entry%, ident%
  entry% = PWADdirGetEntry(DirB, ident%)
  If entry% < 0 Then Exit Sub
  '
  Select Case ident% And &HFF 'EMASK
    Case 4, 5: 'graphic, sprites
      Dim OfsX%, OfsY%
      OfsX% = SetOfsX.Value
      OfsY% = SetOfsY.Value
    Case Else
      Exit Sub
  End Select
  '
  ' set offsets
  '
  If WADsetOffsets(PWADself%, entry%, OfsX%, OfsY%) < 0 Then Exit Sub
End Sub

Sub CmdReg_Click ()
  Call WinTexHelp(20) 'REGISTER
End Sub

Sub DirB_Click ()
  
  Dim entry%, ident%, Nam$
  entry% = PWADdirGetName(DirB, ident%, Nam$)
  If entry% < 0 Then Exit Sub
  If Not DirB.Selected(DirB.ListIndex) Then Exit Sub
  '
  ' display type show name and size, and start of entry
  '
  Call PWADentrySetInfo(entry%, ident%, Nam$)
  'show entry
  If Not PWADentryShow(entry%, Nam$) Then Exit Sub
  'decode viewpoints
  Call PWADviewpoints(entry%, ident%, Nam$)
End Sub

Sub DirB_DblClick ()
  Call M_Eedit_click
End Sub

Sub DirB_KeyDown (KeyCode As Integer, Shift As Integer)
   Select Case KeyCode
     Case KEY_DELETE
       Call M_Ecut_Click
   End Select
End Sub

Sub DirB_KeyPress (Keyascii As Integer)
    Keyascii = PWADnameSeek(Keyascii)
End Sub

Sub DirB_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
   WhatsUp.Caption = "Click: display  Dble Click: edit  Ctrl-Click: select"
End Sub

Sub DirType_Click (Index As Integer)
  Call PWADselType(-1, Index%)
End Sub

Sub DirType_MouseMove (Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
  Dim Nam$
  Select Case Index
    Case 0: Nam$ = "all"
    Case 1: Nam$ = "lumps"
    Case 2: Nam$ = "graphics"
    Case 3: Nam$ = "sprites"
    Case 4: Nam$ = "sound"
    Case 5: Nam$ = "music"
    Case 6: Nam$ = "levels"
    Case 7: Nam$ = "textures"
    Case 8: Nam$ = "patches"
    Case 9: Nam$ = "flats"
  End Select
  WhatsUp.Caption = "Select " & Nam$
End Sub

Sub DisplayOffsetX (ByVal OfsX%)
  Dim X%
  If OfsX > 0 Then '0 non comprised
    X% = 160 - OfsX  '160= middle screen
    If Not GndLine(1).Visible Then GndLine(1).Visible = True
  Else
    X% = 10 - OfsX   'pos relative to 320x200 screen
                     '10=arbitrary
    If GndLine(1).Visible Then GndLine(1).Visible = False
  End If
  If OfsX <= 0 Then
    Relatv.Caption = "Game Screen"
  ElseIf OfsX > 0 Then
    Relatv.Caption = "Ground Spot"
  End If
  PicB.Left = X% * Screen.TwipsPerPixelX
End Sub

Sub DisplayOffsetY (ByVal OfsY%)
  Dim Y%
  '
  ' the value of the X offset commands the calculation
  ' of the Y offset
  '
  If SetOfsX.Value > 0 Then '0 non comprised
    Y% = 172 - OfsY  '172= arbitrary ground
    If Not GndLine(0).Visible Then GndLine(0).Visible = True
  Else
    Y% = 50 - OfsY'pos relative to 320x200 screen
                  '50=arbitrary
    If GndLine(0).Visible Then GndLine(0).Visible = False
  End If
  PicB.Top = Y% * Screen.TwipsPerPixelY
End Sub

Sub EntryHelp_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
   WhatsUp.Caption = "Specific usage of the entry (if any)"
End Sub

Sub EntryId_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
  WhatsUp.Caption = "Type of entry"
End Sub

Sub EntryNm_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
    WhatsUp.Caption = "Name of the entry in WAD"
End Sub

Sub EntryPtr_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
  WhatsUp.Caption = "Position of the entry in WAD"
End Sub

Sub EntrySize_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
  WhatsUp.Caption = "Size of the entry in WAD"
End Sub

Sub Form_Load ()
  '
  ' Form initialisation
  '
  Call WindowInit
End Sub

Sub Form_Unload (Cancel As Integer)
  Call WindowFree
End Sub

Sub Info_Click (Index As Integer)
  Select Case Index
    Case 0 'relative
      Call Infos("The offsets are used to adjust the position of sprites")
      Call Infos("If offset is POSITIVE, then the sprite picture is positioned relatively to the sprite position (generally, the ground spot where the sprite lies)")
      Call Infos("If offset is NEGATIVE, then the sprite picture is positioned on a 320x200 game screen (this is only useful for weapons)")
    Case 1 'Sub dir entry
      Call Infos("The position of the entry in the directory")
    Case 4, 5, 6, 7 'viewpoints
      Call View_Click(Index - 4)
   End Select
End Sub

Sub LvlB_Paint ()
  '
  ' repaint level display
  '
  Dim res%
  LvlBB.hWnd = LvlB.hWnd
  LvlBB.hDC = LvlB.hDC
  res% = WADshowWindoze(LvlBB, 0)
End Sub

Sub M_Absp_Click ()
  '
  ' edit a BSP level
  '
  If Not tutor(0, "open the BSP model viewer") Then Exit Sub
  '
  Dim entry%, ident%, Nam$
  entry% = PWADdirGetName(DirB, ident%, Nam$)
  If entry% < 0 Then Exit Sub
 
  If (ident% And &HFF) <> &HA0 Then  'A0=EQK_BSP
    Nam$ = ""
    ident% = &HA0
  End If
  Nam$ = ChooseEntry(Nam$, ident%, PWADgame%, "BSP model", 1, PWADself%)
  '
  entry% = WADfindEntry(PWADself%, 0, Nam$)
  '
  If entry% < 0 Then Exit Sub
  Call PWADentryEdit(entry%, ident%, Nam$)
  '
End Sub

Sub M_AInst_Click ()
  If Not tutor(0, " help you create an installation for your WAD") Then Exit Sub
  '
  Call WindowOpenEdtInst
End Sub

Sub M_ALvl_Click ()
   If Not tutor(0, "let you fiddle with levels.") Then Exit Sub
   Call WindowOpenEdtLevel
End Sub

Sub M_ATexu_Click ()
  If Not tutor(0, "let you create new wall textures. You can use the patches in main WAD, or your own patches.") Then Exit Sub
  Call WindowOpenEdtTexu
End Sub

Sub M_Ecopy_Click ()
  If Not tutor(0, "copy the selected entries into clipboard") Then Exit Sub
  Call PWADdirECopy(PWADself%, DirB)
End Sub

Sub M_Ecut_Click ()
  If Not tutor(1, "cut the selected entries into clipboard") Then Exit Sub
  Call PWADdirECut(PWADself%, DirB)
  ' list directory
  Call PWADdirList(PWADself%, DirB, PWADtyp%, -1)
End Sub

Sub M_Eedit_click ()
  '
  ' edit entry
  '
  If Not tutor(0, "start a custom editor for the entry. WinTex will be hidden until you quit your editor.") Then Exit Sub
  '
  ' get params
  '
  Dim entry%, ident%, Nam$
  entry% = PWADdirGetName(DirB, ident%, Nam$)
  If entry% < 0 Then Exit Sub
  Call PWADentryEdit(entry%, ident%, Nam$)
End Sub

Sub M_Eload_Click ()
  Dim entry%
  entry% = PWADentryLoad(PWADself%, DirB, PWADtyp%, PWADgame%)
  '
  ' list updated directory
  '
  If entry% < 0 Then Exit Sub
  Call PWADdirList(PWADself%, DirB, PWADtyp%, entry%)
End Sub

Sub M_Epaste_Click ()
  If Not tutor(1, "paste clipboard entries into WAD") Then Exit Sub
  Dim n%
  n% = PWADdirEPaste%(PWADself%, DirB)
  WhatsUp.Caption = "Pasted " & n% & " entries"
  ' list directory again
  Call PWADdirList(PWADself%, DirB, PWADtyp%, -1)
End Sub

Sub M_Esave_Click ()
 If PWADsdir% > 0 Then
   '
   ' save subdirectory entry
   '
   Call PWADsdirSave(PWADself%, PWADsdirEntry%, PWADsdirName$, SDirB)
 Else
   '
   ' save directory entry
   '
   Call PWADentrySave(PWADself%, DirB)
 End If
End Sub

Sub M_Fclean_Click ()
  If Not tutor(1, "cleanup a WAD to remove unused areas. This creates a new WAD.") Then Exit Sub
   
  Dim res%
  res% = WADsaveDir(PWADself%)
  If res% < 0 Then Exit Sub
  If Not DIRexistFile(PWADfilenam$) Then Exit Sub
  Dim old$, File$
  old$ = MakeFileOld(PWADfilenam$)
  If old$ = "" Then Exit Sub
  File$ = Left$(old$, Len(old$) - 4) & ".new"
  ' cleanup
  Screen.MousePointer = 11 'wait
  res% = WADcleanup(PWADself%, File$)
  Screen.MousePointer = 0'normal
  '
  On Error Resume Next
  Name PWADfilenam$ As old$
  Name File$ As PWADfilenam$
  Call Infos("Clean file " & PWADfilenam$ & " was created." & Chr$(10) & "(backup file: " & old$ & ").")
  '
  ' Close WAD file, don't restore it
  '
  Call PWADfree(PWADself%, False)
  Unload Me
End Sub

Sub M_Frest_Click ()
  If Not tutor(1, " restore the WAD and Quit. All your work will be lost.") Then Exit Sub
  '
  ' Close WAD file, restore it
  '
  Call PWADfree(PWADself%, True)
  Unload Me
End Sub

Sub M_Fupdt_Click ()
  If Not tutor(0, " take the modifications into account, and save the WAD directory.") Then Exit Sub
  Dim res%
  res% = WADsaveDir(PWADself%)
  If res% < 0 Then Exit Sub
End Sub

Sub M_Geq_Click ()
  If Not tutor(1, "All the selected entries will become the same as the last selected entry.") Then Exit Sub
  Call PWADmakeSame(PWADself%, DirB)
End Sub

Sub M_Gnew_Click ()
  '
  ' insert a new entry in WAD
  '
  If Not tutor(1, " insert a new entry in WAD, at the selected position.") Then Exit Sub
  '
  '
  '
  Dim entry%, Typ%
  entry% = PWADdirGetEntry%(DirB, Typ%)
  If entry% < 0 Then Exit Sub
  If PWADtyp% >= 0 Then Typ% = PWADtyp%
  '
  Dim Nam$
  Nam$ = ChooseEntry$("NEW", Typ%, PWADgame%, "new entry", False, PWADself%)
  If Nam$ = "" Then Exit Sub
  '
  entry% = WADsetEntry%(PWADself%, entry%, Nam$, 0, 0, Typ%, OPS_INS)'insert
  If entry% < 0 Then Exit Sub
  '
  ' list directory, point to the entry
  '
  Call PWADdirList(PWADself%, DirB, Typ%, entry%)
End Sub

Sub M_Gren_Click (Index As Integer)
  Dim how%, Nam$, old$, who$
  Select Case Index
    Case 0
      who$ = "sprite"
      Nam$ = "S_END"
    Case 1
      who$ = "flat"
      Nam$ = "F_END"
    Case Else
      Exit Sub
  End Select
  old$ = Left$(Nam$, 1) & Nam$
  how% = Not M_Gren(Index).Checked
  If how% Then
    If Not tutor(1, "The " & Nam$ & " marker will be used at the end of the " & who$ & " list." & Chr$(10) & "Be warned that if you use but one redefined " & who$ & ", THE GAME WILL LOCKUP!") Then Exit Sub
  Else
    who$ = old$: old$ = Nam$: Nam$ = who$
  End If
  If Not PWADentryRename(PWADself%, Nam$, old$) Then Exit Sub
  M_Gren(Index).Checked = how%
  '
  ' list directory
  '
  Call PWADdirList(PWADself%, DirB, PWADtyp%, -1)
End Sub

Sub M_Grenm_Click ()
  '
  ' rename entry
  '
  If Not tutor(0, "rename the entry.") Then Exit Sub
  '
  ' get params
  '
  Dim entry%, ident%, Nam$
  entry% = PWADdirGetName(DirB, ident%, Nam$)
  If entry% < 0 Then Exit Sub
  '
  Nam$ = InputBox$("Name of the entry?", "WinTex", Nam$)
  If Nam$ = "" Then Exit Sub
  Nam$ = Trim$(Left$(Nam$, 8))
  DoEvents
  '
  ' set the name
  '
  entry% = WADsetEntry%(PWADself%, entry%, Nam$, -1, -1, -1, OPS_SET)'set
  '
  ' list directory, point to the entry
  '
  Call PWADdirList(PWADself%, DirB, PWADtyp%, entry%)
End Sub

Sub M_Gwaste_Click ()
  Dim res%
  res% = PWADentryShow(INVALID, "")
End Sub

Sub M_Habout_Click ()
  Load AboutInfo
  AboutInfo.Show 1
  Unload AboutInfo
End Sub

Sub M_Hedt_Click ()
  Call WinTexHelp(500)  'E_EDIT
End Sub

Sub M_HInst_Click ()
  Call WinTexHelp(4700)  'TUT_INSTALL
End Sub

Sub M_Hlev_Click ()
  Call WinTexHelp(600)  'L_LEVEL
End Sub

Sub M_Htex_Click ()
  Call WinTexHelp(530)  'E_TEXTURE
End Sub

Sub M_Mstop_Click ()
  '
  ' stop music
  '
  Dim res%
  res% = WADsetParams(PWADself%, -1) 'stop music
End Sub

Sub M_OCM_Click (Index As Integer)
   Dim map%
   '0=light 255, 31=light 0,32=invincible
   map% = Choose(Index + 1, 0, 4, 8, 16, 24, 32)
   '
   ' find COLORMAP entry, and set colormap
   '
   If WADcolorMap(PWADself%, -2, map%) < 0 Then Exit Sub
End Sub

Sub M_Quit_Click ()
  If Not tutor(1, " update the WAD directory and Quit, preserving your work.") Then Exit Sub
  '
  ' Close WAD file, don't restore it
  '
  Call PWADfree(PWADself%, False)
  Unload Me
End Sub

Sub M_Sel_Click (Index As Integer)
  Call PWADselType(-1, Index%)
End Sub

Sub M_Sfind_Click ()
  If Not tutor(0, " look for an entry in the entry list.") Then Exit Sub
  '
  Dim Nam$
  Nam$ = ChooseEntry("", PWADtyp%, PWADgame%, "entry", False, -1)
  If Nam$ = "" Then Exit Sub
  '
  Call ListFindSelect(DirB, Nam$)
End Sub

Sub M_Sound_Click ()
  '
  ' toggle sound
  '
  Dim snd%
  snd% = 0  'disable
  If M_Sound.Checked Then snd% = 1 'enable
  snd% = WADsetParams(PWADself%, snd%)  'set sound
  M_Sound.Checked = Not M_Sound.Checked
End Sub

Sub OffsetSelect (ByVal Index%)
   '
   ' select offset
   '
   Dim szx%, szy%, OfsX%, OfsY%
   szx% = PicB.Width / Screen.TwipsPerPixelX
   szy% = PicB.Height / Screen.TwipsPerPixelY
   Select Case Index
    Case 0   'weapon low
      OfsX% = -(160 - (szx% / 2))
      OfsY% = -(200 - szy%)
    Case 1   'weapon  up
      OfsX% = -(160 - (szx% / 2))
      OfsY% = -(168 - szy%)
    Case 2   'walking
      OfsX% = szx% / 2
      OfsY% = szy% - 5
    Case 3   'centred
      OfsX% = szx% / 2
      OfsY% = szy% / 2
    Case 4   'wall
      OfsX% = szx% / 2
      OfsY% = szy% - 5
    Case 5   'none
     OfsX% = 0
     OfsY% = 0
  End Select
  SetOfsX.Value = OfsX%
  SetOfsY.Value = OfsY%
End Sub

Sub PicB_Paint ()
  '
  ' repain picture box
  '
  Dim res%
  PicBB.hWnd = PicB.hWnd
  PicBB.hDC = PicB.hDC
  res% = WADshowWindoze(PicBB, 0)
End Sub

Sub PWADentryEdit (ByVal entry%, ByVal ident%, ByVal Nam$)
  '
  ' Edit a WAD entry
  '
  Select Case ident% And &HFF 'EMASK
    Case 1, 2, 4, 5, 6, 7
    Case 0 'level
      Call WindowOpenEdtLevel     'edit level
      Exit Sub
    Case 3 'textures
      Call WindowOpenEdtTexu      'edit textures
      Exit Sub
    Case 8 'music
      Call M_Mstop_Click 'stop music
    Case &HA0 'bsp
      Call WindowOpenEdtBsp(entry%, ident%)  'edit bsp
      Exit Sub
    Case Else
      Call Crash("This entry cannot be edited")
      Exit Sub
  End Select
  '
  ' Save an entry to temporary file
  '
  Dim File$, ext$
  File$ = PWADentrySaveTmp(PWADself%, entry%, ident%, Nam$, ext$)
  If File$ = "" Then Exit Sub
  '
  ' launch application
  '
  Dim appli%
  appli% = XternFileEdit(ext$, File$)
  If appli% = 0 Then Exit Sub
  '
  Select Case ident% And &HFF 'EMASK
    Case 8 'mus
      ' play music
      ' do not hide wintex
      ' do not kill temp file
      'Call Infos("MUS files cannot be edited.")
    Case Else
      '
      ' wait for appli to terminate
      '
      Me.Visible = False: DoEvents
      Call XternWaitEnd(appli%)
      Me.Visible = True: DoEvents
      '
      ' reload entry
      '
      Dim pos%
      If QueryOk("Really modify entry?") Then
        pos% = WADloadEntry(PWADself%, entry%, ident%, Nam$, File$)
        If pos% < 0 Then Call Crash("Entry could not be loaded")
      End If
      If DIRexistFile(File$) Then
        On Error Resume Next
        Kill File$
      End If
    '
    ' select entry again
    '
    Call DirB_Click
  End Select
End Sub

Sub PWADentrySetInfo (ByVal entry%, ByVal ident%, Nam$)
  '
  ' Display the characteristics of an entry
  ' EntryId = entry identification
  ' EntrySize = size of enttry
  ' EntryPtr = pointer to the entry
  '
  EntryNm.Caption = Nam$
  Dim res%, start&, size&
  res% = -1
  If entry% >= 0 Then
    res% = WADgetEntry(PWADself%, start&, size&, entry%)
  End If
  If res% >= 0 Then
    Dim txt As String * 128
    res% = HELPforType(ident%, txt$, 128)
  End If
  If res% > 0 Then
    EntryId.Caption = Left$(txt$, res%)
  Else
    EntryId.Caption = "Unknown"
  End If
  EntryPtr.Caption = Format$(Hex$(start), "@@@@@@") & "h"
  EntrySize.Caption = Str$(size)
  'help
  EntryHelp.Caption = ChooseIdent(Nam$, ident% And &HFF, PWADgame%) 'EMASK
End Sub

Function PWADentryShow (ByVal entry%, Nam$)
  '
  ' Show an entry, depending on the type
  '
  PWADentryShow = False
  '
  ' init checks
  '
  If entry% < 0 And entry% <> INVALID Then Exit Function
  '
  ' determine what must be shown
  '
  Dim sel%
  sel% = WADshowEntry(PWADself%, entry%, PicBB, 0)
  If sel% < 0 Then Exit Function
  ' select
  Call PWADformSelect(sel%)
  '
  ' show
  '
  Dim res%
  '
  ' subdir
  '
  PWADsdir% = -1 'no subdir entry displayed
  If sel% And 32 Then 'sdir
    SDirBB.hWnd = SDirB.hWnd
    SDirBB.hDC = 0
    res% = WADshowEntry(PWADself%, entry%, SDirBB, 1)
    PWADsdirEntry% = entry% 'container entry
    PWADsdirName$ = Nam$    'container name
  Else
    '
    ' normal
    '
    PWADsdirEntry% = -1
    If sel% And 1 Then 'picB
      Dim OfsY%, OfsX%
      PicBB.hWnd = PicB.hWnd
      PicBB.hDC = PicB.hDC
      'get picture
      res% = WADshowEntry(PWADself%, entry%, PicBB, 1)
      If sel% And 2 Then 'offsets
        OfsX% = PicBB.OfsX
        If OfsX% = INVALID Then OfsX% = 0
        OfsY% = PicBB.OfsY
        If OfsY% = INVALID Then OfsY% = 0
      Else
        OfsX% = 0
        OfsY% = 0
      End If
      If OfsX% > -640 And OfsX% < 640 Then SetOfsX.Value = OfsX%
      If OfsY% > -400 And OfsY% < 400 Then SetOfsY.Value = OfsY%
      'paint picture
      res% = WADshowWindoze(PicBB, 0)
    ElseIf sel% And 8 Then 'list
      LstBB.hWnd = LstB.hWnd
      LstBB.hDC = 0
      res% = WADshowEntry(PWADself%, entry%, LstBB, 1)
    ElseIf sel% And 16 Then 'level
      LvlBB.hWnd = LvlB.hWnd
      LvlBB.hDC = LvlB.hDC
      'get level
      res% = WADshowEntry(PWADself%, entry%, LvlBB, 1)
      'paint picture
      res% = WADshowWindoze(LvlBB, 0)
    Else
      'sound, music
      res% = WADshowEntry(PWADself%, entry%, PicBB, 1)
    End If
  End If
  PWADentryShow = True
End Function

Sub PwadFile_Change ()
  '
  ' evenement called, when PwadFile is modified
  '
  If PwadFile.Caption = "" Then Exit Sub
  '
  DoEvents 'draw window
  '
  ' Init WAD file, set PWADself% and PWADmainWad%
  '
  If PWADinit(Trim(PwadFile.Caption), PWADself%, PWADmainWad%) > 0 Then
    '
    If WindowInit2(PWADself%) > 0 Then Exit Sub
    '
    ' close WAD file
    '
    Call PWADfree(PWADself%, False)
  End If
  '
  ' exit window
  '
  PwadFile.Caption = "" 'init failed
  Unload Me
End Sub

Sub PWADformSelect (ByVal sel%)
  FrmAuthor.Visible = False
  FrmPic.Visible = sel% And 1 'picB
  FrmOffs.Visible = sel% And 2 'offsets
  FrmView.Visible = sel% And 4 'views
  'FrmLump.Visible = sel% And 8 'list
  LstB.Visible = sel% And 8 'list
  LvlB.Visible = sel% And 16 'levels
  FrmSDir.Visible = sel% And 32 'sub dir
End Sub

Function PWADnameSeek (ByVal Keyascii%)
   '
   ' seek in DirB
   '
   Static match$
   PWADnameSeek = 0 'cancel key
   Dim lmatch%
   Select Case Keyascii
     Case KEY_BACK  'backspace
       lmatch% = Len(match$)
       If lmatch% > 0 Then lmatch% = lmatch% - 1
       match$ = Left$(match$, lmatch%)
     Case 0 To 32
       'ignore non-ascii
       match$ = ""
     Case Else
       match$ = match$ & UCase$(Chr$(Keyascii))
  End Select
  lmatch% = Len(match$)
  If lmatch% <= 0 Or lmatch% > 8 Then
    match$ = ""
    Exit Function
  End If
  If Len(match$) <= 0 Then Exit Function
  Dim res%
  res% = ListFind(DirB, DirB.ListIndex - 1, match$)
  If res% >= 0 Then DirB.ListIndex = res%
End Function

Sub PwadRef_Change ()
  '
  '  event called when PwadRef is modified
  '
  If WindowInit2(Val(PwadRef.Caption)) > 0 Then Exit Sub
  '
  ' Close WAD file, don't restore it
  '
  Call PWADfree(PWADself%, False)
  Unload Me
End Sub

Sub PWADsdirShow ()
  '
  ' Show an entry from subdirectory
  '
  Dim sdir%
  sdir% = PWADsdirGetRef%(SDirB)
  If sdir% < 0 Then Exit Sub
  PWADsdir% = 1 'ART
  '
  ' Display ref. of dir entry
  '
  SDirRef.Caption = Str$(sdir%)
  If PWADsdirEntry% >= 0 Then
    '
    ' Display picture
    '
    FrmPic.Visible = True
    SetOfsX.Value = 0
    SetOfsY.Value = 0
    Dim sel%
    sel% = WADsdirShow(PWADself%, PWADsdirEntry, sdir%, PicBB, 0)
    If sel% < 0 Then Exit Sub
    Call PWADformSelect(sel%)
    If sel% And 1 Then 'picB
      PicBB.hWnd = PicB.hWnd
      PicBB.hDC = PicB.hDC
      sel% = WADsdirShow(PWADself%, PWADsdirEntry, sdir%, PicBB, 1)
      If sel% < 0 Then Exit Sub
      sel% = WADshowWindoze(PicBB, 0)'paint picture
    End If
  End If
End Sub

Sub PWADselType (ByVal Typ%, ByVal Index%)
  '
  ' select by type, or by
  '
  Typ% = HELPgetIdxType%(Index%, PWADgame%, Typ%)
  If PWADtyp% = Typ% Then Exit Sub
  '
  ' Type change
  '
  PWADtyp% = Typ%
  '
  'display directory
  '
  Call PWADdirList(PWADself%, DirB, PWADtyp%, -1)
  '
  ' update buttons
  '
  For Typ% = 0 To 9
   DirType(Typ%).Enabled = True
  Next
  If Index% >= 0 And Index% <= 9 Then DirType(Index%).Enabled = False
End Sub

Function PWADspritView$ (ByVal View$)
   Select Case Left$(View$, 1)
     Case "0" To "8"
       PWADspritView$ = Choose(Val(View$) + 1, "All Views", "Front", "Front Left", "Left", "Back Left", "Back", "Back Right", "Right", "Front Right")
     Case Else
       PWADspritView$ = ""
   End Select
End Function

Sub PWADviewpoints (ByVal entry%, ByVal ident%, ByVal Nam$)
  '
  ' decode view points
  '
  If (ident% And &HFF) <> 5 Then Exit Sub ' EMASK 5=ESPRITE
  '
  ' artifacts
  '
  Dim Vnorm$, Pnorm$, Vinv$, Pinv$
  If UCase$(Left$(Nam$, 4)) = "ARTI" Then
    Vnorm$ = "ARTIFACT": Pnorm$ = ""
    Vinv$ = "": Pinv$ = ""
  Else
    Vnorm$ = PWADspritView$(Mid$(Nam$, 5 + 1, 1))
    Pnorm$ = Mid$(Nam$, 4 + 1, 1)
    Vinv$ = PWADspritView$(Mid$(Nam$, 7 + 1, 1))
    Pinv$ = Mid$(Nam$, 6 + 1, 1)
  End If
  View(0).Caption = Vnorm$  ' view normal
  View(1).Caption = Pnorm$
  View(2).Caption = Vinv$   ' view inverted
  View(3).Caption = Pinv$
End Sub

Sub Relatv_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
  WhatsUp.Caption = "Reference for offsets"
End Sub

Sub SDirB_Click ()
  '
  ' display art directory number
  ' and art picture
  '
  Call PWADsdirShow
End Sub

Sub SetOfs_Click (Index As Integer)
   Call OffsetSelect(Index%)
End Sub

Sub SetOfs_MouseMove (Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
   Dim Nam$
   Select Case Index
     Case 0: Nam$ = "weapon"
     Case 1: Nam$ = "weapon up"
     Case 2: Nam$ = "walking sprite"
     Case 3: Nam$ = "flying sprite"
     Case 4: Nam$ = "wall"
     Case 5:
       WhatsUp.Caption = "Null offsets": Exit Sub
   End Select
   WhatsUp.Caption = "Set offsets for " & Nam$
End Sub

Sub SetOfsX_Change ()
 ShowOfsX.Caption = SetOfsX.Value
 Call DisplayOffsetX(SetOfsX.Value)
End Sub

Sub SetOfsY_Change ()
  ShowOfsY.Caption = SetOfsY.Value
  Call DisplayOffsetY(SetOfsY.Value)
End Sub

Sub ShowOfsX_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
  WhatsUp.Caption = "Horizontal Offset"
End Sub

Sub ShowOfsY_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
   WhatsUp.Caption = "Vertical Offset"
End Sub

Sub View_Click (Index As Integer)
  If (Index < 0) Or (Index > 4) Then Exit Sub
  If View(Index).Caption = "" Then Exit Sub
  Dim txt$
  txt$ = "The sprite is represented by the picture "
  Select Case Index
    Case 2, 3
      txt$ = txt$ & "mirrored horizontally "
  End Select
  Select Case Index
    Case 0, 2
      txt$ = txt$ & "when seen from " & View(Index).Caption & "."
    Case 1, 3
      txt$ = txt$ & "when the sprite frame is " & View(Index).Caption & "."
  End Select
  Call Infos(txt$)
End Sub

Sub View_MouseMove (Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
  WhatsUp.Caption = "Viewpoints (Click for info)"
End Sub

Sub WindowFree ()
  '
  ' cleanup  picutre boxes
  '
  Dim res%
  res% = WADshowWindoze(PicBB, -1)
  res% = WADshowWindoze(LvlBB, -1)
End Sub

Sub WindowInit ()
  '
  ' Re-Init window, if WAD object already allocated
  '
  '
  ' init picture boxes
  '
  Dim res%
  LstBB.Typ = WlistBox
  SDirBB.Typ = WlistBox
  PicBB.Typ = WpicBox
  res% = WADshowWindoze(PicBB, 1)
  LvlBB.Typ = WpicBox
  res% = WADshowWindoze(LvlBB, 1)
  '
  DoEvents 'draw window
  '
  ' Init PWAD
  '
  PWADself% = -1
  PWADsdirEntry% = -1  'no current art entry
  '
  ' right justify help menu
  M_H0.Caption = Chr$(8) & M_H0.Caption
  'add scroll bar to the list box
  Dim ret&
  ret& = SendMessage(LstB.hWnd, LB_SETHORIZONTALEXTENT, 640, "")
  '
  ' select nothing, display banner
  FrmAuthor.Visible = True
  LvlB.Visible = False
  LstB.Visible = False
  FrmPic.Visible = False
  FrmOffs.Visible = False
  FrmView.Visible = False
  FrmSDir.Visible = False
  '
  DoEvents 'draw window
End Sub

Function WindowInit2 (ByVal self%)
  '
  ' Re-Init window, if WAD object already allocated
  '
  DoEvents 'draw window
  WindowInit2 = -1  'fail by default
  '
  '
  Dim dirty%, File$
  If Not PWADgetInfo(self%, PWADgame%, PWADmainWad%, dirty%, File$) Then
    Call Crash("Cannot use WAD " & File$)
    Exit Function
  End If
  PWADfilenam$ = File$
  PWADself% = self%    'reference of WAD object
  '
  DoEvents 'draw window
  '
  ' declare window handle (for error window)
  '
  If WADsetCustoms(PWADself%, Me.hWnd) < 0 Then Exit Function
  '
  ' list dir
  '
  DoEvents ' Process window redraw event
  '
  PWADtyp% = -1 'select all types
  '
  'display directory
  '
  Call PWADdirList(PWADself%, DirB, PWADtyp%, -1)
  '
  ' form title
  '
  Me.Caption = "Entries in " & File$
  '
  ' disable stuff, for DukeNukem
  '
  If PWADgame% And (GAM_QUAK Or GAM_DUKE) Then
    M_A0.Visible = False 'menu Advanced
    M_OCMap.Visible = False 'Colormap
    M_Gren(0).Visible = False 'S_END
    M_Gren(1).Visible = False 'F_END
    FrmOffs.Enabled = False 'offsets
    FrmView.Enabled = False 'viewpoints
  End If
  '
  WindowInit2 = 1 'ok
End Function

Sub WindowOpenEdtBsp (ByVal entry%, ByVal ident%)
  '
  ' Hide current window and open EdtLevel window instead
  '
  If entry% >= 0 And ident% = &HA0 Then
    Dim Edt As New EdtBsp
    Edt.EntryRef.Caption = entry%
    Edt.PwadRef.Caption = PWADself%
    Edt.Show
    Unload Me
  End If
End Sub

Sub WindowOpenEdtInst ()
  '
  ' Hide current window and open EdtInst instead
  '
  Dim Edt As New EdtInst
  Edt.PwadRef.Caption = PWADself%
  Edt.Show 0
  Unload Me
End Sub

Sub WindowOpenEdtLevel ()
  '
  ' Hide current window and open EdtLevel window instead
  '
  Dim Edt As New EdtLevel
  Edt.PwadRef.Caption = PWADself%
  Edt.Show
  Unload Me
End Sub

Sub WindowOpenEdtTexu ()
  '
  ' Hide current window and open EdtTexu window instead
  '
  Dim Edt As New EdtTexu
  Edt.PwadRef.Caption = PWADself%
  Edt.Show 0
  Unload Me
End Sub

