Option Explicit
'
' Use the internal name of libraries, not the external name
' Used LbWintex  not lbwintex.dll  (doesn't work)
'

'code for invalid integers
'(used for patches)
Global Const INVALID = -6666
'
'Global Const GAM_DOOM = &H10
'Global Const GAM_HTIC = &H20
'Global Const GAM_HEXN = &H40
'Global Const GAM_STRF = &H80
Global Const GAM_QUAK = &H100
Global Const GAM_DUKE = &H200


'Global Const OPS_ADD = 1 'add
Global Const OPS_INS = 2 'insert
Global Const OPS_SET = 3 'set
Global Const OPS_DEL = 4 'delete

' lb common
'
' type WINDOZE for visual basic
'
Global Const Wpicbox = 666
Global Const WlistBox = 777
Global Const Wdropbox = 999
'
Type windoze
  Typ As Integer  'type
  hWnd As Long 'handle on a window
  hDC As Long   'handle on a display controler
  hBitmap As Long 'handle on a bitmap
  hPal As Long 'handle on a palette
  SzX As Integer  'picture width
  SzY As Integer 'picture height
  OfsX As Integer
  OfsY As Integer
End Type
'
Dim DirBB As windoze 'directory list box
'
' Level bounds
'
Type Bound
' screen
  SzX As Integer   'MUST BE SET
  SzY As Integer   'height,width
'  level scaled
  ScaleX As Long   'screen X scale
  ScaleY As Long   'screen Y scale
  OfsX   As Long   'screen X offset
  OfsY   As Long   'screen Y offset
'  max and min to display in level
  Xmin As Long  'MUST BE SET
  Ymin As Long
  Zmin As Long
  Xmax As Long
  Ymax As Long
  Zmax As Long
' viewpoint
  X      As Long
  Y      As Long
  Z      As Long
  Phi    As Long   'horiz rot, in degree
  The    As Long   'vertical rot, in degree
End Type
'
'
Type BspInfos
  Id     As Long 'type of BSP object
  Nb     As Long 'Nb of elements
  N      As Long 'Id of element
  N2     As Long
  PlanType  As Long
  NodeFront As Long
  NodeBack  As Long
  TinfTexu  As Long
  TinfSoffs  As Single
  TinfToffs  As Single
  FaceLType As Integer
  FaceShadow As Integer
  FaceLite1 As Integer
  FaceLite2 As Integer
  LeafType  As Long
  ModlNode As Long
  ModlClip As Long
  ModlClip2 As Long
  ModlClip3 As Long
  ModlLeafNb As Long
  TexuName  As String * 16
End Type
'
'    show a picture on screen
'    on Form.Load()   WadshowWindoze(PicBB,1)
'    on PicB.Paint()  WadshowWindoze(PicBB,0)
'    on Form.Unload() WadshowWindoze(PicBB,-1)
Declare Function WADshowWindoze% Lib "lbwintex.dll" (PicB As windoze, ByVal Ops%)
'lbwad
' Basic Operations on the WAD object
' (Init,Free,Get entries, Modify entries)
' init WAD object, returns object reference>0
' if Lock =1, lock the WAD for read only.
Declare Function WADinit% Lib "lbwintex.dll" (ByVal file$, ByVal Main%, ByVal Lck%, ByVal Transparent&)
'    forget WAD object, save modified directory
'    if Sav = -1, restore WAD. =0 ignore, =1, save dir
Declare Function WADfree% Lib "lbwintex.dll" (ByVal Self%, ByVal Sav%)
'  Set customs parameters
'  error windows
Declare Function WADsetCustoms% Lib "lbwintex.dll" (ByVal Self%, ByVal ErrWnd&)
'    check WAD. returns 16bit flags
Declare Function WADcheck% Lib "lbwintex.dll" (ByVal Self%)
'    get Id of the Game this WAD is for (10,11,12=DOOM 20,21=HERETIC, 42 = hexen)
'    get the reference of the MainWAD
'    tell if the WAD directory was modified and not saved.
'    if File$<>"", give the name of the WAD file
Declare Function WADgetInfos% Lib "lbwintex.dll" (ByVal Self%, Gam%, MainWad%, DirDirty%, ByVal file$)
'    get Size and Start of a dir entry
'    returns id
Declare Function WADgetEntry% Lib "lbwintex.dll" (ByVal Self%, start&, size&, ByVal Entry%)
'    Find entry, starting at Here, from entry name
Declare Function WADfindEntry% Lib "lbwintex.dll" (ByVal Self%, ByVal Here%, ByVal Nam$)
'    Set dir Entry, with the provided Name, Start, Size
'    Modif: 1=add 2=ins 3=set 4=del
'    If Id%>=0 then set identifier
'    the WAD directory is not saved on file, it is kept dirty
Declare Function WADsetEntry% Lib "lbwintex.dll" (ByVal Self%, ByVal Here%, ByVal Nam$, ByVal start&, ByVal size&, ByVal Id%, ByVal Modif%)
'    Save Directory of WAD, so that WAD becomes usable
'    by other WAD tools, like level editors
Declare Function WADsaveDir% Lib "lbwintex.dll" (ByVal Self%)
'    Restore a WAD file
'    whose directory was modified
Declare Function WADrestore% Lib "lbwintex.dll" (ByVal file$, ByVal Safe%)
'    cleanup PWAD into another WAD
'    this ignores entry compression
Declare Function WADcleanup% Lib "lbwintex.dll" (ByVal Self%, ByVal file$)
'
' List entries
'
'    list entries in directory, according to type.
'    hLst = listbox where to list entries
'           itemdata will contain entry id and reference
'    Type = type of entries to list.
'           if<0, all entries.
'           if sub type, only that sub type.
'    Entry = Entry to look for
'    returns position of entry >=0
Declare Function WADlistDir% Lib "lbwintex.dll" (ByVal Self%, Wnd As windoze, ByVal Typ%, ByVal Entry%)
'
'    List all entries in PWAD and IWAD, with references
'    if Type has a general type, list that type
'    in Type has a subtype, list only the subtype
'    returns 1
Declare Function WADlistAll% Lib "lbwintex.dll" (ByVal Self%, Wnd As windoze, ByVal Typ%)
'
'   Check the name of an entry, warn user if needed.
'   Name = Entry name
'   Type = proposed entry type (general type)
'   txt   = text buffer, for message
'   txtsz = buffer size
'   return <0 if error,  ident if accepted
Declare Function WADentryCheckId% Lib "lbwintex.dll" (ByVal Self%, ByVal Typ%, ByVal Nam$, ByVal txt$, ByVal txtsz%)
'
'   Show any entries, depending on type.
'    PicB = Picture Box for sprites/patches
'    Wnd = window for picture/level/lists
'    Shw = if>0, then show, else just say what is selected
'   Returns indication of what is displayed
'    SHOWE_NONE 0  no entry shown
'    SHOWE_PICB 1  show a picture
'    SHOWE_OFFS 2       with offsets
'    SHOWE_VIEW 4       with views
'    SHOWE_LIST 8  show a list
'    SHOWE_LEVL 16 show a level map
'    SHOWE_SDIR 32 show a entry subdirectory list
Declare Function WADshowEntry% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%, Wnd As windoze, ByVal Shw%)
'
'        Show Sub Directory entry
'         Entry = entry containing the SubDir
'         Sdir = entry in the subdir
'         Wnd = window for picture/level/lists
'         Show = if <0, then do not display anything
'                                if >0, then display the relevant data
'        returns the type of what is to be displayed
'        (call first with show<0, set the right window, call again with show>0)
Declare Function WADsdirShow% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%, ByVal Sdir%, Wnd As windoze, ByVal Shw%)
'
'  Set various parameters
'   Sound: <0 ignored,=0 no sound, >0 sound
'
Declare Function WADsetParams% Lib "lbwintex.dll" (ByVal Self%, ByVal Sound%)
'
'   Show an entry, by name rather than by entry ref.
'   PicB = picture box where entry is shown
'   Ident = EPATCH or EFLAT
'   Name = name of the patch or flat
'   Search in PWAD first, then in main WAD.
Declare Function WADshowByName% Lib "lbwintex.dll" (ByVal Self%, Pic As windoze, ByVal Ident%, ByVal Nam$)
'   Change colormap for picture display
'   Entry = Colormap entry (if <0, use COLORMAP in main WAD)
'   Mapref = Which colormap (if <0, restore normal one)
Declare Function WADcolorMap% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%, ByVal Mapref%)
'
' Save entries to individual files
'
'   Save any entry to a file
'   Entry = reference of entry. must be valid.
'   File = name of the file. must be valid.
'   The format of File will depend on the entry type
Declare Function WADsaveEntry% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%, ByVal file$)
'
'       Save a subdir entry
'        File = file where art is saved
'        Entry = entry containing the ART
'        Sdir =  entry in subdir
'        File = name of the file. must be valid.
'       The format of File will depend on the entry type
Declare Function WADsdirSave% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%, ByVal Sdir%, ByVal file$)
'
' Load entries from individual files, into the WAD
'
'    Load an entry from file,
'    Entry = suggested position in WAD directory.
'    Id = identification of the entry
'    Name = name of the entry
'    File = file name where the data is.
'    File will be read depending on Id
Declare Function WADloadEntry% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%, ByVal Id%, ByVal Nam$, ByVal file$)
'    Load a level part
'    Entry = position of existing level header
'    File = a WAD file that contains a level
'    What = 0: all level  1:nodes and blockmap 2:only reject
Declare Function WADloadLevel% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%, ByVal file$, ByVal What%)
'    Load a text entry from listbox
'    Entry = suggested position in wad dir.
'    Id = identification of entry
'    Name = name of entry
'    hList = Listbox
Declare Function WADloadText% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%, ByVal Id%, ByVal Nam$, Lst As windoze)
''    Load an entry from another opened WAD
''    Wad = object reference of the other Wad
''    WadEntry = Entry in that other Wad
''Declare Function WADloadFromWad% Lib "lbwintex.dll" (ByVal Self%, ByVal Wad2%, ByVal Wad2Entry%)
'    Set offsets of DOOM picture
'    Entry = picture entry (must be sprite or patch or graphic)
'    OfsX = X offset
'    OfsY = Y offset
Declare Function WADsetOffsets% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%, ByVal OfsX%, ByVal OfsY%)
'
' Check WAD
'
'    List textures used in a WAD
'    hList = listbox where to list textures
Declare Function WADlistTextures% Lib "lbwintex.dll" (ByVal Self%, Lst As windoze)
'    Check WAD
'    hList = listbox where to put the result
Declare Function WADcheckWad% Lib "lbwintex.dll" (ByVal Self%, Lst As windoze)
'
' Texture
'
'   Allocate texture lump
'   Start texture, and start cacheing patches
'   Read textures and PNAMES in main WAD and in PWAD
Declare Function WADTinit% Lib "lbwintex.dll" (ByVal pwad%)
'   return name and size, from reference
'   name must be string*8+2. returns size of name
Declare Function WADTgetTex% Lib "lbwintex.dll" (ByVal pwad%, ByVal Texu%, ByVal Nam$, SzX%, SzY%)
'   Modif: 1=add, 2=ins 3=set 4=del  entry
Declare Function WADTsetTex% Lib "lbwintex.dll" (ByVal pwad%, ByVal Texu%, ByVal Nam$, ByVal SzX%, ByVal SzY%, ByVal Modif%)
'   find texture
Declare Function WADTfindTex% Lib "lbwintex.dll" (ByVal pwad%, ByVal Nam$)
'   list textures. Filt=0: all  Filt=1:only redefined
'  which filters texture 1 or 2 (if <0, no filter)
'  new filters old 0 and new 1(if <0, no filter)
Declare Function WADTlistTex% Lib "lbwintex.dll" (ByVal pwad%, Lst As windoze, ByVal Whch%, ByVal Nw%)
'   display a texture
Declare Function WADTshowTex% Lib "lbwintex.dll" (ByVal pwad%, ByVal Texu%, Pic As windoze)
'   Modif: 1=add, 2=ins 3=set 4=del patch
Declare Function WADTsetPatch% Lib "lbwintex.dll" (ByVal pwad%, ByVal Texu%, ByVal Pat%, ByVal Nam$, ByVal OfsX%, ByVal OfsY%, ByVal Modif%)
'   get patch Pat in texture Texu, into Name, OfsX, OfsY
'   Name must be string*8+2
Declare Function WADTgetPatch% Lib "lbwintex.dll" (ByVal pwad%, ByVal Texu%, ByVal Pat%, ByVal Nam$, OfsX%, OfsY%)
'   list patches. Name, OfsX, OfsY. ItemData= patch reference
'  list to a list box
Declare Function WADTlistPatch% Lib "lbwintex.dll" (ByVal pwad%, ByVal Texu%, Lst As windoze)
'   save all texture and PNAME to WAD
Declare Function WADTsaveAll% Lib "lbwintex.dll" (ByVal pwad%)
'   free texture
'   stop cacheing patches
'   clean up the mess
Declare Function WADTfree% Lib "lbwintex.dll" (ByVal pwad%)
'
' Clear texture clipboard
Declare Function WADTclipbClear% Lib "lbwintex.dll" ()
'
' Copy texture in clipboard
Declare Function WADTclipbCopy% Lib "lbwintex.dll" (ByVal pwad%, ByVal Texu%)
'
'  Paste textures from clipboard
Declare Function WADTclipbPaste% Lib "lbwintex.dll" (ByVal pwad%, ByVal Texu%)
'
'
'
'   /*get Xmin Xmax Ymin Ymax of a level*/
Declare Function WADLboundLevel% Lib "lbwintex.dll" (ByVal pwad%, ByVal Entry%, BoundEx As Bound)
'   /*set Xmin Xmax Ymin Ymax of a boudn box*/
'   /*if Zoom>0, zoom in, else Zoom out*/
Declare Function WADLboundScale% Lib "lbwintex.dll" (BoundEx As Bound, ByVal X%, ByVal Y%, ByVal Zoom%)
'   point to an object of a given type
'   returns the identifier of that object, or -1
'   if Id=ELINDEF, Point to linedef
'   if Id=ESIDEDEF, Point to sidedef
'   if Id=ESECTOR, Point to sector
'   if Id=ENODE, Point to node. return a node, and depth
'   if Id=EREJECT, get reject for sector at X,Y
Declare Function WADLpointObject& Lib "lbwintex.dll" (ByVal pwad%, ByVal Entry%, ByVal Id%, ByVal Object%, ByVal X%, ByVal Y%, ByVal OX%, ByVal OY%)
'    Modify reject data
'    Entry = level header
'    Target = Target sector (player sector)
'    Sector = monster sector
'    Ops = 0 toggle Sector can/cant see Target
'         1 make target safe, 2 make target unsafe
'    returns status of reject
Declare Function WADLmodifyReject% Lib "lbwintex.dll" (ByVal pwad%, ByVal Entry%, ByVal Target%, ByVal Sector%, ByVal Ops%)
'
'         Modify sidedef data
'         Entry = level header
'         Sid = Sidedef number
'         Ops = 0 Set texture names from Texu
'                         1 Get texture names into Texu
'          2 Set ceil/floor names from Texu
'          3 Get ceil/floor names into Texu
'         Texu[24] = Upper[8] Middle[8] Lower[8]
'         Texu[24] = Ceiling[8] Floor[8]
'                         Texu must of size 24 at least.
'        returns >0 if ok
Declare Function WADLmodifTexu% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%, ByVal Obj%, ByVal Ops%, ByVal Texu$)
'   Draw the linedefs of a level map
'   Depending on Id, display the object Obj
'   highlighted. Use only level entries for Id
Declare Function WADLshowLevel% Lib "lbwintex.dll" (ByVal pwad%, ByVal Entry%, ByVal Lin%, ByVal Id%, BoundEx As Bound, Pic As windoze)
'   Save level part
'   Id=part to save
'   Entry=level header
Declare Function WADLsaveLevel% Lib "lbwintex.dll" (ByVal pwad%, ByVal Entry%, ByVal Id%)
'
'   clear clipboard
'
Declare Function WADclipbClear% Lib "lbwintex.dll" ()
'
'   Copy entry from WAD into clipboard
'
Declare Function WADclipbCopy% Lib "lbwintex.dll" (ByVal pwad%, ByVal Entry%)
'
'   Copy first entry from cliboard to WAD
'   return <=0 if clipboard is empty
'
Declare Function WADclipbPaste% Lib "lbwintex.dll" (ByVal pwad%, ByVal Entry%)
'
'   Init BSP model from entry
Declare Function BSPinit% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%)
'
'   Free BSP model
Declare Function BSPfree% Lib "lbwintex.dll" (ByVal Self%)
'
'   Save BSP model
Declare Function BSPsave% Lib "lbwintex.dll" (ByVal Self%)
'
'   Check BSP model
'   report problems in windows
'   return >0 if ok, <0 if problems
Declare Function BSPcheck% Lib "lbwintex.dll" (ByVal Self%, Wnd As windoze)
'
'  Show a BSP level
'
Declare Function BSPshow% Lib "lbwintex.dll" (ByVal Self%, Wnd As windoze, BoundEx As Bound, ByVal Obj&, ByVal Typ%)
'
'  Show/Modify BSP element
Declare Function BSPmodify% Lib "lbwintex.dll" (ByVal Self%, Infos As BspInfos, ByVal What%)
'        Get Entry/Ident for ItemData
'         Ident = Entry identification
'         Code = Entry code = LstB.ItemData(n)
'         Returns Ident and Entry ref in PWAD.
Declare Function HELPdecodeEntry% Lib "lbwintex.dll" (Ident%, ByVal Code&)
'       Get type and Index of button
'         *pIndex = -1 or Index of the type selection button (0...9)
'         Game = Current game
'         Id   = Type of entry, or -1
'         returns Type and *pIndex
Declare Function HELPgetIdxType% Lib "lbwintex.dll" (Index%, ByVal Gam%, ByVal Typ%)
'
'    List the entries of the given type into drop box
'     Type= types of entries listed
'     Game= which game is it for?
Declare Sub HELPforWad Lib "lbwintex.dll" (hWnd As windoze, ByVal Typ%, ByVal Gam%)
'
'    Find if a given name is matched
'     Type= types of entries listed
'     Game= which game is it for?
'    returns <0 if name not matched
'    returns 0 if name contains illegal char
'    returns 1 if name is matched
Declare Function HELPfindName% Lib "lbwintex.dll" (ByVal Nam$, ByVal Typ%, ByVal Gam%)
'
'    Give help test for a name
'     Name =  name searched
'     Type = Type searched  (-1=all)
'     Game = game searched
'     Text = buffer
'     TextSz = size of buffer
'    returns actual size of text
Declare Function HELPforName% Lib "lbwintex.dll" (ByVal Nam$, ByVal Typ%, ByVal Gam%, ByVal txt$, ByVal txtsz%)
'
'    Give the name of a type
'     Type = entry type to be identified
'     Text = buffer
'     TextSz = size of buffer
'    returns actual size of text
Declare Function HELPforType% Lib "lbwintex.dll" (ByVal Typ%, ByVal txt$, ByVal txtsz%)
' HELP for file extension
' Id = entry type
'  Ops = 1:file to load   0:file to save
' returns the type of editor for the file
Declare Function HELPfileForType% Lib "lbwintex.dll" (ByVal Typ%, ByVal Ops%)

Sub PWADdirECopy (ByVal Self%, DirB As Control)
  If Not tutor(1, "cut the selected entries into clipboard") Then Exit Sub
  '
  ' copy into clipboard
  '
  Dim pos%, Entry%
  Entry% = WADclipbClear()
  '
  ' copy list from end to start, otherwise
  ' the levels cannot be pasted again
  '
  Screen.MousePointer = 11 'wait
  pos% = DirB.ListCount    'top
  Do
    If Not PWADdirPrevSel(pos%, Entry%, DirB) Then Exit Do
    'add to clipboard
    Entry% = WADclipbCopy(Self%, Entry%)
  Loop
  Screen.MousePointer = 0 'normal
End Sub

Sub PWADdirECut (ByVal Self%, DirB As Control)
  If Not tutor(1, "cut the selected entries into clipboard") Then Exit Sub
  '
  ' copy into clipboard
  '
  Call PWADdirECopy(Self%, DirB)
  '
  ' delete
  '
  Dim pos%, Entry%
  Screen.MousePointer = 11 'wait
  pos% = DirB.ListCount    'top
  Do
    If Not PWADdirPrevSel(pos%, Entry%, DirB) Then Exit Do
    Entry% = WADsetEntry%(Self%, Entry%, "", 0, 0, -1, OPS_DEL)'delete
  Loop
  Screen.MousePointer = 0 'normal
  ' save directory
  If WADsaveDir(Self%) < 0 Then Exit Sub
End Sub

Function PWADdirEPaste% (ByVal Self%, DirB As Control)
  '
  ' Paste entries, at position DirB.ListIndex
  '
  Screen.MousePointer = 11 'wait
  PWADdirEPaste% = WADclipbPaste(Self%, DirB.ListIndex)
  Screen.MousePointer = 0 'normal
  '
  ' save directory
  '
  If WADsaveDir(Self%) < 0 Then Exit Function
End Function

Function PWADdirNextSel% (pos%, DirB As Control)
  '
  ' return the next entry select >= pos%
  ' return -1 if no entry selected after pos%
  '
  ' pod% = -1
  ' while PWADdirNextSel%(pos%, DirB)
  '
  PWADdirNextSel% = False
  Dim posmax%
  posmax% = DirB.ListCount
  Do
    pos% = pos% + 1
    If pos% >= posmax% Then Exit Function
    If DirB.Selected(pos%) Then Exit Do
  Loop
  PWADdirNextSel% = True
End Function

Function PWADdirPrevSel% (pos%, Entry%, DirB As Control)
  '
  ' return the next entry selected <= pos%
  ' return -1 if no entry selected after pos%
  '
  ' pod% = DirB.ListCount
  ' while PWADdirPrevSel%(pos%, entry%,DirB)
  '
  PWADdirPrevSel% = False
  If pos% > DirB.ListCount Then Exit Function
  Do
    pos% = pos% - 1
    If pos% < 0 Then Exit Function
    If DirB.Selected(pos%) Then Exit Do
  Loop
  Dim Ident%
  Entry% = HELPdecodeEntry%(Ident%, DirB.ItemData(pos%))
  PWADdirPrevSel% = True
End Function

Function PWADentryFile$ (ByVal Ident%, ByVal Nam$, ext$, ByVal Ops%)
  '
  ' get the right extension for a file where to save
  ' the entry, according to the identification.
  '
  ' returns: entry name with extension
  '          extension
  '
  Dim res%
  res% = HELPfileForType(Ident%, Ops%)
  If res% < 0 Then Exit Function
  ext$ = ".lmp"
  If res% < &H10 Then
    '            0   1   2   3   4   5   6   7
    ext$ = Mid$(".txt.lmp.bmp.wav.voc.mid.rc .cfg", res% * 4 + 1, 4)
  ElseIf res% < &H20 Then
    '            10  11  12  13  14  15  16  17
    ext$ = Mid$(".wad.mus.scr.acs.bsp.mdl.spr.o  ", (res% - &H10) * 4 + 1, 4)
  ElseIf res% < &H30 Then
    '            20  21  22  23  24  25
    ext$ = Mid$(".map.art.dat.con.tmb.bin", (res% - &H20) * 4 + 1, 4)
  End If
  Nam$ = Trim$(Left$(Nam$, 8))
  ext$ = Trim$(ext$)
  ' deal with entries with bad names
  PWADentryFile = MakeOkName(Nam$ & ext$)
End Function

Function PWADentryLoad% (ByVal Self%, DirB As Control, ByVal Typ%, ByVal Game%)
  '
  ' load entry from user selected file, warn the user
  ' against someentries, update directory list
  '
  PWADentryLoad = -1
  If Not tutor(1, "load a WAD entry from a file.") Then Exit Function
  '
  ' get entry reference, or default entry
  '
  Dim done%, pos%, Entry%, Ident%, Nam$
  Dim file$, ext$
  
  '
  done% = False'no entry saved yet
  pos% = -1 ' just before 0
  Do
    If Not PWADdirNextSel(pos%, DirB) Then Exit Do
    '
    ' Get entry name and ident
    '
    Entry% = HELPdecodeEntry%(Ident%, DirB.ItemData(pos%))
    Nam$ = Trim$(Left$(DirB.List(pos%), 9)) 'GETNAME
    '
    ' Set type requested, if -1
    '
    If Typ% < 0 Then Typ% = Ident%
    '
    file$ = PWADentryFile(Ident%, Nam$, ext$, 0) 'save
    file$ = ChooseFile(file$, "*" & ext$, False, "Select a file name for the entry")
    If file$ = "" Then Exit Function
    '
    If PWADentryLoad2%(Self%, Entry%, Ident%, Nam$, file$) >= 0 Then
      done% = True
    End If
  Loop
  '
  ' exit if some entries were selected and loaded
  '
  If done% Then Exit Function
  '
  ' no entries were selected
  '
  
  
  If Typ% < 0 Then
    Call Crash("Please select a type of entry.")
    Exit Function
  End If
  '
  Nam$ = ChooseEntry(Nam$, Typ%, Game%, "entry", True, Self%)
  If Nam$ = "" Then Exit Function
  '
  ' check entry name is not conflicting with a name
  ' that can be identified as another type, in IWAD.
  ' Typ = general type
  Ident% = WADentryCheckId%(Self%, Typ%, Nam$, "", 0)
  If Ident% <= 0 Then Exit Function
  '
  ' check sprite and flat
  '
  Dim res%
  Select Case Ident% And &HFF 'EMASK
    Case 5      'ESPRITE
      res% = tutor(1, "modify Sprites. You will need to Add All Sprites before playing your WAD.")
    Case 7      'EFLATS
      res% = tutor(0, "work only if your Floor/Ceilings pictures is of size 64x64.")
    Case 3      'ETEXTURE
      res% = tutor(1, "work better if you use the texture editing panel.")
  End Select
  '
  ' Choose file name
  '
  file$ = PWADentryFile(Ident%, Nam$, ext$, 1) 'load
  file$ = ChooseFile(file$, "*" & ext$, False, "Select a file name for the entry")
  If file$ = "" Then Exit Function
  '
  ' Load entry
  '
  PWADentryLoad = PWADentryLoad2%(Self%, Entry%, Ident%, Nam$, file$)
End Function

Function PWADentryRename (ByVal Self%, Nam$, old$)
  '
  ' rename an entry, by name
  '  nam = new name
  '  old = old name
  '
  PWADentryRename = False
  Dim Entry%, res%
  Entry% = WADfindEntry%(Self%, 0, old$)
  If Entry% < 0 Then Exit Function
  res% = WADsetEntry(Self%, Entry%, Nam$, -1, -1, -1, OPS_SET)
  Call Infos("Changed name of entry " & Entry% & ": " & old$ & " becomes " & Nam$)
  PWADentryRename = True
End Function

Sub PWADentrySave (ByVal Self%, DirB As Control)
  '
  ' save entry to a user selected file
  '
  If Not tutor(0, "save the entry in a file.") Then Exit Sub
  '
  Dim pos%, Entry%, Ident%, Nam$
  Dim file$, ext$
  '
  pos% = -1 ' just before 0
  Do
    If Not PWADdirNextSel(pos%, DirB) Then Exit Do
    '
    ' Get entry name and ident
    '
    Entry% = HELPdecodeEntry%(Ident%, DirB.ItemData(pos%))
    Nam$ = Trim$(Left$(DirB.List(pos%), 9)) 'GETNAME
    '
    ' Get a file name
    '
    file$ = PWADentryFile(Ident%, Nam$, ext$, 0) 'save
    file$ = ChooseFile(file$, "*" & ext$, False, "Select a file name for the entry")
    If file$ <> "" Then
      '
      ' Save entry
      '
      Screen.MousePointer = 11 'wait
      Entry% = WADsaveEntry(Self%, Entry%, file$)
      Screen.MousePointer = 0 'normal
      If Entry% < 0 Then Call Crash("Entry " & Nam$ & " could not be saved.")
    End If
  Loop
End Sub

Function PWADentrySaveTmp$ (ByVal Self%, ByVal Entry%, ByVal Ident%, ByVal Nam$, ext$)
  '
  ' save file to temporary entry
  ' returns: name of temporary file
  '          which% = type of editor to use on this entry
  '
  PWADentrySaveTmp$ = ""
  ext$ = ""
  Dim file$
  file$ = PWADentryFile(Ident%, Nam$, ext$, 0) 'save
  file$ = MakeTempFile(file$)
  If file$ = "" Then Exit Function
  Dim res%
  Screen.MousePointer = 11 'wait
  res% = WADsaveEntry(Self%, Entry%, file$)
  Screen.MousePointer = 0 'normal
  If res% < 0 Then
    Call Crash("Entry could not be saved")
    Exit Function
  End If
   PWADentrySaveTmp$ = file$
End Function

Sub PWADfree (ByVal Self%, ByVal Restor%)
  '
  ' Release WAD file
  '
  '
  ' if the pwad is not valid, do not free
  '
  If Self% < 0 Then Exit Sub
  '
  ' free the PWAD. PWADself= -1
  '
  If Restor% Then
    Self% = WADfree(Self%, -1) 'restore WAD
  Else
    Self% = WADfree(Self%, 1) 'save dir
  End If
  '
  ' decrease IWAD lock count
  '
  Call WinTexLockIWAD(False)
  '
End Sub

Function PWADgetInfo (ByVal Self%, Gam%, Main%, dirty%, file$)
  '
  ' get WAD informations
  ' this function is here to format file$ correctly
  ' because VB doesn't handle null-terminated strings.
  '
  Dim res%
  Dim buf As String * 128
  PWADgetInfo = False
  res% = WADgetInfos(Self%, Gam%, Main%, dirty%, buf$)
  If res% < 0 Then Exit Function
  file$ = Trim$(Left$(buf$, res%))
  PWADgetInfo = True
End Function

Function PWADinit (ByVal file$, Self%, MainSelf%)
  '
  ' Init window
  '
  PWADinit = -1 'by default, failure
  '
  ' Free previous PWAD object
  '
  If Self% > 0 Then Self% = WADfree(Self%, 0)
  '
  ' Initialise PWAD object
  '
  If file$ = "" Then Exit Function
  '
  ' Get reference of the main WAD object
  '
  MainSelf% = WinTexGetGameSelf() 'the current main wad
  '
  ' get transparent color
  '
  Dim r%, g%, b%
  Call WinTexGetColor(r%, g%, b%)
  '
  ' open a PWAD, or create on if doesn't exist
  '
  Self% = WADinit(file$, MainSelf%, -1, RGB(r%, g%, b%)) 'no write locked
  If Self% < 0 Then
    If MainSelf% < 0 Then
      Call Crash("No main WAD defined")
    Else
      Call Crash("Cannot use WAD " & file$)
    End If
    Exit Function
  End If
  '
  ' increase main WAD's lock count
  '
  Call WinTexLockIWAD(True)
  '
  PWADinit = 1  'ok
End Function

Sub PWADmakeSame (ByVal Self%, DirB As Control)
  '
  ' All the selected entries must become the same
  ' as the last selected entry
  '
  Dim Entry%
  Entry% = DirB.ListIndex
  If Entry% < 0 Then Exit Sub
  Dim Ident%, start&, size&
  Ident% = WADgetEntry(Self%, start&, size&, Entry%)
  Dim e%, eident%, estart&, esize&
  For e% = DirB.ListCount - 1 To 0 Step -1
    If e% = Entry% Then
      eident% = -1
    ElseIf DirB.Selected(e%) Then
      eident% = WADgetEntry(Self%, estart&, esize&, e%)
      If eident% = Ident% Then
	'change only size start
	'and only if same identity
	eident% = WADsetEntry(Self%, e%, "", start&, size&, -1, OPS_SET)
      End If
    End If
  Next e%
End Sub

Function PWADsdirGetRef% (SdirB As Control)
  '
  ' get reference of entry in subdirectory
  '
  PWADsdirGetRef% = -1
  If SdirB.ListCount <= 0 Then Exit Function
  Dim res%
  res% = SdirB.ListIndex
  If res% < 0 Then Exit Function
  PWADsdirGetRef% = SdirB.ItemData(res%) And &H7FFF
End Function

Sub PWADsdirSave (ByVal Self%, ByVal Entry%, ByVal Nam$, SdirB As Control)
  '
  ' save sub dir entry to a user selected file
  '  entry = subdir container enttry
  '  name  = name fo subdir container entry
  '  sdir  = ref. of entry in subdir
  '
  Dim Sdir%, SDirNam$
  Sdir% = PWADsdirGetRef(SdirB)
  If Sdir% < 0 Or Entry% < 0 Then Exit Sub
  If Not tutor(0, "save the sub-directory entry in a file.") Then Exit Sub
  '
  SDirNam$ = Trim$(SdirB.List(SdirB.ListIndex))
  '
  '
  '
  Dim Ident%, res&
  Ident% = WADgetEntry%(Self%, res&, res&, Entry%)
  If Ident% < 0 Then Exit Sub
  '
  Dim file$, ext$, FileTyp%
  Select Case Ident% And &HFF 'EMASK
    Case &HD4 'EDK_ART
      ' name = tEEEpSSS.bmp  EEE=entry SSS=sdir
      Nam$ = Left$("t" & Trim$(Right$(Nam$, 3)) & "p" & Format(Sdir%, "000"), 8)
      FileTyp% = 4 'save as 4=EGRAPHIC
    Case &HA5 'EPK_SPR
      ' name = frameSSS.bmp  SSS=sdir
      Nam$ = Left$("frame" & Format(Sdir%, "000"), 8)
      FileTyp% = 4 'save as 4=EGRAPHIC
    Case &HA0 'EPK_BSP
      ' name = SDIRNAME.bmp
      Nam$ = Trim$(Left$(SDirNam$, 8))
      FileTyp% = 4 'save as 4=EGRAPHIC
    Case Else
      Exit Sub
  End Select
  '
  ' Save an entry
  '
  file$ = PWADentryFile(FileTyp%, Nam$, ext$, 0)
  file$ = ChooseFile(file$, ext$, False, "Select a file name for the entry")
  If file$ = "" Then Exit Sub
  Screen.MousePointer = 11 'wait
  res& = WADsdirSave(Self%, Entry%, Sdir%, file$)
  Screen.MousePointer = 0 'normal
  If res& < 0 Then
    Call Crash("Entry #" & Sdir% & " could not be saved.")
    Exit Sub
  End If
End Sub

Function PWADdirGetEntry% (DirB As Control, Ident%)
  '
  ' Get parames for entry:  entry% and ident%
  '
  PWADdirGetEntry% = -1
  Dim pos%
  pos% = DirB.ListIndex
  If DirB.ListCount <= 0 Or pos% < 0 Then Exit Function
  PWADdirGetEntry% = HELPdecodeEntry%(Ident%, DirB.ItemData(pos%))
End Function

Function PWADdirGetName% (DirB As Control, Ident%, Nam$)
  '
  ' get parameters for entry
  '   entry%, ident% and nam$
  '
  PWADdirGetName% = -1
  Nam$ = ""
  Ident% = -1
  Dim pos%
  pos% = DirB.ListIndex
  If DirB.ListCount <= 0 Or pos% < 0 Then Exit Function
  Nam$ = Trim$(Left$(DirB.List(pos%), 9)) 'GETNAME
  PWADdirGetName% = HELPdecodeEntry%(Ident%, DirB.ItemData(pos%))
End Function

Sub PWADdirList (ByVal Self%, DirB As Control, ByVal Typ%, ByVal Entry%)
  '
  ' list directory
  '   pwad% = WAD reference
  '   DirB = Directory List Box
  '   typ% = type of entry listed
  '   if entry% >=0, then set cursor to that entry
  '
  DirB.Visible = False
  DirB.Clear
  '
  DirBB.Typ = WlistBox
  DirBB.hWnd = DirB.hWnd
  Dim pos%
  'screen.MousePointer = 11 'wait
  pos% = WADlistDir(Self%, DirBB, Typ%, Entry%)
  'screen.MousePointer = 0 'normal
  DirB.Visible = True
  '
  ' set cursor to the right entry
  '
  pos% = pos% - 1 '0 means no selection
  If pos% < 0 Or pos% >= DirB.ListCount Then Exit Sub
  DirB.ListIndex = pos%
End Sub

Function PWADentryCheckId$ (ByVal Self%, ByVal Typ%, ByVal Nam$)
  '
  ' check
  '
  Dim buff As String * 68
  Dim Id%
  Id% = WADentryCheckId%(Self%, Typ%, Nam$, buff$, 68)
  PWADentryCheckId$ = Left$(buff, 64)
End Function

Function PWADentryLoad2% (ByVal Self%, ByVal Entry%, ByVal Ident%, ByVal Nam$, ByVal file$)
  '
  ' Direct load entry into file
  ' returns entry number
  '
  PWADentryLoad2% = -1
  '
  ' convert MIDI to MUS if needed
  '
  If (Ident% And &HFF) = 8 Then 'EMASK  8=EMUSIC
      If LCase$(Right$(file$, 4)) = ".mid" Then
	file$ = XternMidi2Mus(file$)
	If file$ = "" Then Exit Function
      End If
  End If
  '
  ' load entry
  '
  Dim res%
  Screen.MousePointer = 11 'wait
  res% = WADloadEntry(Self%, Entry%, Ident%, Nam$, file$)
  Screen.MousePointer = 0 'normal
  If res% < 0 Then
    Call Crash("Entry could not be loaded.")
    Exit Function
  End If
  PWADentryLoad2% = res%
End Function

