VERSION 2.00
Begin Form EdtTexu 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Texture"
   ClientHeight    =   6180
   ClientLeft      =   735
   ClientTop       =   840
   ClientWidth     =   8505
   ClipControls    =   0   'False
   Height          =   6840
   HelpContextID   =   400
   Icon            =   EDTTEXTU.FRX:0000
   Left            =   690
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   6180
   ScaleWidth      =   8505
   Top             =   225
   Width           =   8595
   Begin Frame FrmPlist 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Patches in Texture"
      ForeColor       =   &H00000000&
      Height          =   2955
      Left            =   2520
      TabIndex        =   22
      Top             =   2640
      Width           =   3915
      Begin CheckBox ChkSpeed 
         BackColor       =   &H00C0C0C0&
         Caption         =   "+16"
         ForeColor       =   &H00000000&
         Height          =   255
         Left            =   1080
         TabIndex        =   3
         Top             =   1380
         Width           =   675
      End
      Begin CommandButton CmdMove 
         Caption         =   "Delete"
         Height          =   315
         Index           =   5
         Left            =   780
         TabIndex        =   31
         Top             =   2520
         Width           =   795
      End
      Begin CommandButton CmdMove 
         Caption         =   "Move"
         Height          =   315
         Index           =   6
         Left            =   780
         TabIndex        =   30
         Top             =   2160
         Width           =   795
      End
      Begin CommandButton CmdMove 
         Caption         =   "Bring in Front"
         Height          =   315
         Index           =   4
         Left            =   120
         TabIndex        =   29
         Top             =   1740
         Width           =   1455
      End
      Begin CommandButton CmdMove 
         Caption         =   "Dn"
         Height          =   315
         Index           =   1
         Left            =   540
         TabIndex        =   28
         Top             =   1320
         Width           =   435
      End
      Begin CommandButton CmdMove 
         Caption         =   "Rgt"
         Height          =   315
         Index           =   3
         Left            =   960
         TabIndex        =   27
         Top             =   1020
         Width           =   435
      End
      Begin CommandButton CmdMove 
         Caption         =   "Lft"
         Height          =   315
         Index           =   2
         Left            =   120
         TabIndex        =   26
         Top             =   1020
         Width           =   435
      End
      Begin CommandButton CmdMove 
         Caption         =   "Up"
         Height          =   315
         Index           =   0
         Left            =   540
         TabIndex        =   25
         Top             =   720
         Width           =   435
      End
      Begin ListBox PtlB 
         BackColor       =   &H00C0C0C0&
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "System"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   2430
         Left            =   1800
         TabIndex        =   24
         Top             =   360
         Width           =   1935
      End
      Begin Image PCenter 
         BorderStyle     =   1  'Fixed Single
         Height          =   510
         Left            =   120
         Picture         =   EDTTEXTU.FRX:0302
         Top             =   2220
         Width           =   510
      End
      Begin Label TexPos 
         Alignment       =   2  'Center
         BackColor       =   &H00808080&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "0,0"
         ForeColor       =   &H00000000&
         Height          =   255
         Left            =   240
         TabIndex        =   23
         Top             =   360
         Width           =   1275
      End
   End
   Begin CheckBox TexuFlt 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Tex2"
      ForeColor       =   &H00000000&
      Height          =   255
      Index           =   2
      Left            =   900
      TabIndex        =   21
      Top             =   5820
      Value           =   1  'Checked
      Width           =   735
   End
   Begin CheckBox TexuFlt 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Tex1"
      ForeColor       =   &H00000000&
      Height          =   255
      Index           =   1
      Left            =   120
      TabIndex        =   20
      Top             =   5820
      Value           =   1  'Checked
      Width           =   735
   End
   Begin CheckBox TexuFlt 
      BackColor       =   &H00C0C0C0&
      Caption         =   "New"
      ForeColor       =   &H00000000&
      Height          =   255
      Index           =   0
      Left            =   1680
      TabIndex        =   19
      Top             =   5820
      Width           =   675
   End
   Begin ListBox TexuLst 
      BackColor       =   &H00C0C0C0&
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "System"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00000000&
      Height          =   2670
      Left            =   120
      MultiSelect     =   2  'Extended
      TabIndex        =   18
      Top             =   3000
      Width           =   2175
   End
   Begin ListBox PatB 
      BackColor       =   &H00C0C0C0&
      Height          =   3150
      HelpContextID   =   700
      Left            =   6660
      TabIndex        =   16
      Top             =   2940
      Width           =   1635
   End
   Begin Frame PicFrame 
      BackColor       =   &H00C0C0C0&
      ClipControls    =   0   'False
      ForeColor       =   &H00000000&
      Height          =   1935
      Left            =   200
      TabIndex        =   0
      Top             =   500
      Width           =   7695
      Begin PictureBox TexuB 
         BackColor       =   &H00000000&
         BorderStyle     =   0  'None
         ClipControls    =   0   'False
         Height          =   1935
         Left            =   0
         MousePointer    =   2  'Cross
         ScaleHeight     =   1935
         ScaleWidth      =   7710
         TabIndex        =   1
         Top             =   0
         Width           =   7710
         Begin PictureBox PicB 
            BackColor       =   &H00C0C0C0&
            BorderStyle     =   0  'None
            Enabled         =   0   'False
            Height          =   2655
            Left            =   4440
            ScaleHeight     =   2655
            ScaleWidth      =   3195
            TabIndex        =   2
            Top             =   0
            Visible         =   0   'False
            Width           =   3195
         End
      End
   End
   Begin VScrollBar TexuHeight 
      Height          =   1935
      LargeChange     =   16
      Left            =   8040
      Max             =   128
      Min             =   8
      TabIndex        =   14
      Top             =   480
      Value           =   128
      Width           =   240
   End
   Begin HScrollBar TexuWidth 
      Height          =   240
      LargeChange     =   2
      Left            =   5160
      Max             =   11
      Min             =   2
      TabIndex        =   10
      Top             =   120
      Value           =   9
      Width           =   1590
   End
   Begin HScrollBar TexOfs 
      Height          =   240
      Left            =   2820
      Max             =   -512
      TabIndex        =   8
      Top             =   120
      Visible         =   0   'False
      Width           =   1695
   End
   Begin Label Info 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Textures in WAD"
      ForeColor       =   &H00800000&
      Height          =   195
      Index           =   3
      Left            =   180
      TabIndex        =   17
      Top             =   2700
      Width           =   1515
   End
   Begin Label Info 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Patches"
      ForeColor       =   &H00800000&
      Height          =   195
      Index           =   1
      Left            =   6900
      TabIndex        =   15
      Top             =   2640
      Width           =   915
   End
   Begin Label TexuName 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "-"
      ForeColor       =   &H00000000&
      Height          =   255
      Left            =   780
      TabIndex        =   5
      Top             =   120
      Width           =   1215
   End
   Begin Label Info 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Name"
      ForeColor       =   &H00800000&
      Height          =   195
      Index           =   2
      Left            =   120
      TabIndex        =   9
      Top             =   120
      Width           =   615
   End
   Begin Label Info 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "x"
      ForeColor       =   &H00000000&
      Height          =   255
      Index           =   0
      Left            =   7440
      TabIndex        =   13
      Top             =   120
      Width           =   195
   End
   Begin Label ValTxHeight 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "128"
      ForeColor       =   &H00000000&
      Height          =   255
      Left            =   7680
      TabIndex        =   12
      Top             =   120
      Width           =   600
   End
   Begin Label ValTxWidth 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "512"
      ForeColor       =   &H00000000&
      Height          =   255
      Left            =   6840
      TabIndex        =   11
      Top             =   120
      Width           =   600
   End
   Begin Label EntryHelp 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      ForeColor       =   &H00800000&
      Height          =   315
      Left            =   2760
      TabIndex        =   7
      Top             =   5700
      Width           =   3615
   End
   Begin Label PwadFile 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "WadFile to load"
      ForeColor       =   &H00000080&
      Height          =   315
      Left            =   3060
      TabIndex        =   4
      Top             =   3240
      Visible         =   0   'False
      Width           =   2415
   End
   Begin Label PwadRef 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      BackStyle       =   0  'Transparent
      Caption         =   "PWadRef"
      ForeColor       =   &H000000FF&
      Height          =   195
      Left            =   660
      TabIndex        =   6
      Top             =   4440
      Visible         =   0   'False
      Width           =   855
   End
   Begin Menu M_F0 
      Caption         =   "&File"
      Begin Menu M_FLd 
         Caption         =   "&Load Texture as text"
         Enabled         =   0   'False
      End
      Begin Menu M_FSv 
         Caption         =   "&Save Texture as text"
         Enabled         =   0   'False
      End
      Begin Menu M_F1 
         Caption         =   "-"
      End
      Begin Menu M_FQuit 
         Caption         =   "&Quit Texture"
      End
   End
   Begin Menu M_T0 
      Caption         =   "&Textures"
      Begin Menu M_Tfind 
         Caption         =   "&Find Texture"
      End
      Begin Menu M_T1 
         Caption         =   "-"
      End
      Begin Menu M_Tcopy 
         Caption         =   "&Copy Texture"
      End
      Begin Menu M_Tcut 
         Caption         =   "C&ut Texture"
      End
      Begin Menu M_TPaste 
         Caption         =   "&Paste texture"
      End
      Begin Menu M_T2 
         Caption         =   "-"
      End
      Begin Menu M_Tnew 
         Caption         =   "&New Texture"
      End
      Begin Menu M_Tnam 
         Caption         =   "&Rename Texture"
      End
   End
   Begin Menu M_P0 
      Caption         =   "&Patches"
      Begin Menu M_Pfind 
         Caption         =   "&Find Patch"
      End
      Begin Menu M_P1 
         Caption         =   "-"
      End
      Begin Menu M_Patch 
         Caption         =   "List &Patches"
         Index           =   0
      End
      Begin Menu M_Patch 
         Caption         =   "List &Sprites"
         Index           =   1
      End
      Begin Menu M_Patch 
         Caption         =   "List &Graphics"
         Index           =   2
      End
      Begin Menu M_P2 
         Caption         =   "-"
      End
      Begin Menu M_Pnew 
         Caption         =   "&New Patch"
      End
   End
   Begin Menu M_H0 
      Caption         =   "&Help"
      Begin Menu M_Ht 
         Caption         =   "&Normal Textures"
         Index           =   0
      End
      Begin Menu M_Ht 
         Caption         =   "&Animated Textures"
         Index           =   1
      End
      Begin Menu M_Ht 
         Caption         =   "&Switch textures"
         Index           =   2
      End
   End
End
Option Explicit
'
'
Dim PWADself%      'ref. of the PWAD
Dim PWADgame%    'code for the game
Dim PWADmainWad% 'main Wad
Dim PWADtexu%    'currently edited texture
		 'if <0, then disable editing
Dim PWADtexuRef% 'currently edited texture, ref in list
'
' floating Bmp
'
Dim FBMPnam$    'name
'
Dim TexuDirty As Integer ' list of texture
' Floating Bmp
Dim FBMPcentX As Single  'bitmap decenter: percent X
Dim FBMPcentY As Single  'bitmap decenter: percent Y
'
' locks modifiations to textures
Dim texulock As Integer

Dim PatBB As windoze
Dim TxlBB As windoze
Dim PtlBB As windoze

Dim PicBB As windoze
Dim TexBB As windoze

Sub CmdMove_Click (Index As Integer)
  '
  ' Modification of existing patches
  ' (displacement, deletion, send to front)
  '
  If PWADtexu% < 0 Then Exit Sub
  Dim patidx%
  patidx% = PtlB.ListIndex
  If patidx% < 0 Then
    Call Crash("Please select a patch in the list")
    Exit Sub
  End If
  '
  ' get texture reference
  '
  Dim pat%
  pat% = (PtlB.ItemData(patidx%) And &H7FFF&)
  '
  'get patch into pat%, nam$,ofsx% ofsy%
  '
  Dim ofsx%, ofsy%, nam$, res%
  Dim buf As String * 10
  res% = WADTgetPatch(PWADself%, PWADtexu%, pat%, buf$, ofsx%, ofsy%)
  If res% < 0 Then Exit Sub
  nam$ = Trim$(Left$(buf$, res%))
  '
  ' execute patch modification order
  '
  Select Case Index%
    Case 4, 5, 6
      'delete patch
      If WADTsetPatch(PWADself%, PWADtexu%, pat%, "", 0, 0, 4) < 0 Then Exit Sub 'del
      TexuDirty = True 'textures are modified
      Select Case Index%
	Case 4    'bring to front
	  'add patch
	  If WADTsetPatch(PWADself%, PWADtexu%, -1, nam$, ofsx%, ofsy%, 1) < 0 Then Exit Sub 'add
	Case 5    'Delete
	Case 6    'Move patch
	  'make it the floating Bmp
	  Call FloatingSet(nam$)
      End Select
    Case 0, 1, 2, 3
      Dim stp%   ' get movement speed  (1 or 16)
      stp% = 1
      If ChkSpeed.Value Then stp% = 16
      Select Case Index%
	Case 0      'move UP
	  ofsy = ofsy - stp%
	Case 1     'move DOWN
	  ofsy = ofsy + stp%
	Case 2     'move LEFT
	  ofsx = ofsx - stp%
	Case 3    'move RIGHT
	  ofsx = ofsx + stp%
      End Select
      If WADTsetPatch(PWADself%, PWADtexu%, pat%, nam$, ofsx%, ofsy%, 3) < 0 Then Exit Sub'set
      TexuDirty = True 'textures are modified
    Case Else
      Exit Sub
  End Select
  '
  ' Redraw texture, list patches
  '
  Call TexuShow
  '
  ' Select the same patch as before
  '
  If patidx% < PtlB.ListCount Then PtlB.ListIndex = patidx%
End Sub

Sub FloatingDrop ()
   'returns the (X,Y) position of moving picture
   'doesn't return the name
   'return position BEFORE CLEARING PIC
   Dim X%, Y%
   'X = (PicB.Left + TexOfs.Value) / Screen.TwipsPerPixelX
   X = Int(PicB.Left / Screen.TwipsPerPixelX)
   Y = Int(PicB.Top / Screen.TwipsPerPixelY)
   'clear the moving picture
   PicB.Visible = False
   '
   ' check that texture exist
   '
   If PWADtexu% < 0 Then Exit Sub
   '
   ' Add one patch
   '
   If WADTsetPatch(PWADself%, PWADtexu%, -1, FBMPnam$, X, Y, 1) < 0 Then Exit Sub'add
   TexuDirty = True 'textures are modified
   '
   ' Redraw texture, update list of patches
   '
   Call TexuShow
End Sub

Sub FloatingMove (X As Integer, Y As Integer)
   Dim XX, YY As Integer
   If PicB.Visible Then
      XX = X - Int(FBMPcentX * PicB.Width)
      YY = Y - Int(FBMPcentY * PicB.Height)
      PicB.Move XX, YY
   Else
     XX = X
     YY = Y
   End If
   XX = Int(XX / Screen.TwipsPerPixelX) '- TexOfs.Value
   YY = Int(YY / Screen.TwipsPerPixelY)
   TexPos.Caption = XX & "," & YY
End Sub

Sub FloatingSet (ByVal nam$)
   ' set the name of the patch
   FBMPnam$ = Trim$(Left$(nam$, 8))
   ' show the patch on moving picB
   Dim res%
   '
   PicBB.hWnd = PicB.hWnd
   PicBB.hDC = PicB.hDC
   '
   res% = WADshowByName(PWADself%, PicBB, 6, nam$)'6=EPATCH
   If res% < 0 Then Exit Sub
   ' show picture
   PicB.Visible = True
   PicB.Refresh
   ' center patch
   Call FloatingMove(TexuB.Width / 2, TexuB.Height / 2)
End Sub

Sub Form_Load ()
  Call WindowInit
End Sub

Sub Form_Unload (Cancel As Integer)
  Call WindowFree
End Sub

Sub Info_Click (Index As Integer)
   Dim txt$
   Select Case Index
     Case 1  'DO NOT CHANGE. it's used in select patches
       txt$ = "This is the list of patches that you can use in your textures."
     Case 2
       txt$ = "This is the name of your texture. Some names are reserved for animated textures: see the list in the drop box."
   End Select
   Call Infos(txt$)
End Sub

Sub M_FLd_Click ()
   Call Crash("Not implemented yet")
End Sub

Sub M_FQuit_Click ()
  Unload Me
End Sub

Sub M_FSv_Click ()
  Call Crash("Not implemented yet")
  'If Not Tutor(1, "read textures from a file and add them to the list.") Then Exit Sub
  ' Dim file As String
  ' file = ChooseFile(".", "*.txt", True, "Select a file to import textures from")
  ' If file$ = "" Then Exit Sub
  '
  '
  '
End Sub

Sub M_Ht_Click (Index As Integer)
  Select Case Index
    Case 0
      Call WinTexHelp(530)  'E_TEXTURE
    Case 1
      Call WinTexHelp(531)  'E_TEXANIM
    Case 2
      Call WinTexHelp(532)  'E_TEXSWTCH
  End Select
End Sub

Sub M_Patch_Click (Index As Integer)
  '
  ' List patches in PWAD or in main WAD
  '
  Dim id%, txt$
  Select Case Index
    Case 0  'Patches
      txt$ = "Patches"
      id% = 6 'EPATCH
    Case 1  'Sprites
      txt$ = "Sprites"
      id% = 5 'ESPRITE
    Case 2  'Graphics
      txt$ = "Graphics"
      id% = 4 'EGRAPHIC
    Case Else
      Exit Sub
  End Select
  '
  Info(1).Caption = txt$
  
  '
  ' List flats
  '
  PatB.Visible = False
  PatB.Clear
  PatBB.Typ = WlistBox
  PatBB.hWnd = PatB.hWnd
  Dim res%
  If Index% = 2 Then 'graphic, list only those in PWAD
    res% = WADlistDir(PWADself%, PatBB, id%, -1)
  Else               'patches, sprites
    res% = WADlistAll(PWADself%, PatBB, id%)
  End If
  If res% < 0 Then Exit Sub
  PatB.Visible = True
  '
End Sub

Sub M_Pfind_Click ()
  If Not tutor(0, " look for a patch in the patch list.") Then Exit Sub
  '
  Dim nam$
  nam$ = ChooseEntry("", 6, PWADgame%, "patch", False, -1) 'patch
  If nam$ = "" Then Exit Sub
  '
  Call ListFindSelect(PatB, nam$)
End Sub

Sub M_Pnew_Click ()
  '
  ' Add a patch to the list
  '
  Call Infos("Not Implemented yet. If you want to add custom patches, select the patches list in the main editing panel, and load your patch.")
End Sub

Sub M_Tcopy_Click ()
  If Not tutor(0, "copy the selected textures into clipboard") Then Exit Sub
  Dim res%, n%, texu&
  'clear clipboard
  Screen.MousePointer = 11 'wait
  res% = WADTclipbClear()
  For n% = 0 To TexuLst.ListCount - 1
    If TexuLst.Selected(n%) Then
      texu& = TexuLst.ItemData(n%) And &H7FFF&
      'add to clipboard
      res% = WADTclipbCopy(PWADself%, texu&)
    End If
  Next
  Screen.MousePointer = 0 'normal
End Sub

Sub M_Tcut_Click ()
  '
  ' copy textures
  '
  Call M_Tcopy_Click
  '
  ' delete textures
  '
  Dim modf%
  modf% = False
  If Not tutor(0, "cut the selected textures into clipboard") Then Exit Sub
  Dim res%, n%, texu&
  '
  Screen.MousePointer = 11 'wait
  For n% = 0 To TexuLst.ListCount - 1
    If TexuLst.Selected(n%) Then
      texu& = TexuLst.ItemData(n%) And &H7FFF&
      'delete
      res% = WADTsetTex(PWADself%, texu&, "", 0, 0, OPS_DEL) 'del
      modf% = True
    End If
  Next
  Screen.MousePointer = 0 'normal
  If Not modf% Then Exit Sub
  '
  ' textures are modified, disable texture editing
  '
  TexuDirty = True
  PWADtexu% = -1
  '
  ' list all textures
  Call TexuList
End Sub

Sub M_Tfind_Click ()
  If Not tutor(0, " look for a texture in the texture list.") Then Exit Sub
  '
  Dim nam$
  nam$ = ChooseEntry("", &H18, PWADgame%, "texture", False, -1) 'ETEXNAM texture
  If nam$ = "" Then Exit Sub
  '
  Call ListFindSelect(TexuLst, nam$)
End Sub

Sub M_Tnam_Click ()
  '
  ' Rename a texture
  '
  If Not tutor(1, "rename an existing texture") Then Exit Sub
  If PWADtexu% < 0 Then Exit Sub
  Dim nam$
  nam$ = Left$(TexuName.Caption, 8)
  nam$ = ChooseEntry(nam$, &H18, PWADgame%, "texture", True, -1) 'ETEXNAM texture
  If nam$ = "" Then Exit Sub
  '
  ' Update the name of the texture
  '
  If WADTsetTex(PWADself%, PWADtexu%, nam$, -1, -1, 3) < 0 Then Exit Sub'set
  TexuName.Caption = nam$
  TexuDirty = True 'textures are modified
  '
  ' fix name in list
  '
  If TexuLst.ListCount <= 0 Then Exit Sub
  If PWADtexuRef < 0 Then Exit Sub
  If PWADtexuRef% >= TexuLst.ListCount Then Exit Sub
  If (TexuLst.ItemData(PWADtexuRef%) And &H7FFF&) <> PWADtexu% Then Exit Sub
  TexuLst.List(PWADtexuRef%) = Left$(nam$ & "       ", 8) & Mid$(TexuLst.List(PWADtexuRef%), 8 + 1)
End Sub

Sub M_Tnew_Click ()
  '
  ' Declare a new texture in TEXTURE1
  '
  If Not tutor(1, "start a new texture from scratch") Then Exit Sub
  Dim nam$
  nam$ = ChooseEntry("new", &H18, PWADgame%, "texture", True, -1)'ETEXNAM texture
  If nam$ = "" Then Exit Sub
  '
  ' create and position new texture
  '
  PWADtexu% = -1'disable texture modification
  Dim texu%
  If TexuLst.ListCount <= 0 Then
    texu% = -1
  Else
    texu% = TexuLst.ListIndex
    If texu% >= 0 Then texu% = (TexuLst.ItemData(texu%) And &H7FFF&)
  End If
' If texu% < 0 Then texu% = -1
  '
  ' For some reason, texture 0 is never displayed in DOOM
  ' so disable this texture. use 1 at minimum
  '
  If texu% <= 0 Then texu% = 1
  
  texu% = WADTsetTex(PWADself%, texu%, nam$, 128, 128, 2)'insert
  If texu% < 0 Then Exit Sub
  TexuName.Caption = nam$
  TexuWidth.Value = 7  '128
  TexuHeight.Value = 128
  PWADtexu% = texu% 'okay for texture modification
  Call TexuShow
  TexuDirty = True 'textures are modified
  '
  ' list all textures
  Call TexuList
End Sub

Sub M_TPaste_Click ()
  If Not tutor(1, "paste texture into texture list") Then Exit Sub
  Dim texu%, n%
  texu% = TexuLst.ListIndex
  Screen.MousePointer = 11 'wait
  n% = WADTclipbPaste(PWADself%, texu%)
  Screen.MousePointer = 0 'normal
  If n% <= 0 Then Exit Sub
  '
  ' textures are modified, disable texture editing
  '
  TexuDirty = True
  PWADtexu% = -1
  '
  ' list all textures
  Call TexuList
End Sub

Sub PatB_Click ()
  '
  ' Make the patch a floating patch, so that the users choose
  ' where to drop it.
  '
  'If PWADtexu% < 0 Then Exit Sub
  If PatB.ListCount <= 0 Then Exit Sub
  If PatB.ListIndex < 0 Then Exit Sub
  Dim nam$
  nam$ = Trim$(Left$(PatB.Text, 8))
  Call FloatingSet(nam$)
End Sub

Sub PCenter_DblClick ()
   Call Infos("Click here to chose a grabing point to move your patches.")
End Sub

Sub PCenter_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
   FBMPcentX = X / PCenter.Width
   FBMPcentY = Y / PCenter.Height
End Sub

Sub PicB_Paint ()
  Dim res%
  PicBB.hWnd = PicB.hWnd
  PicBB.hDC = PicB.hDC
  res% = WADshowWindoze(PicBB, 0)
End Sub

Sub PtlB_Click ()
  If PWADtexu% < 0 Then Exit Sub
  If PtlB.ListCount <= 0 Then Exit Sub
  If PtlB.ListIndex < 0 Then Exit Sub
  Dim pat%
  pat% = (PtlB.ItemData(PtlB.ListIndex) And &H7FFF&)
    'get patch into pat%, nam$,ofsx% ofsy%
  Dim ofsx%, ofsy%, nam$, res%
  Dim buf As String * 10
  res% = WADTgetPatch(PWADself%, PWADtexu%, pat%, buf$, ofsx%, ofsy%)
  If res% < 0 Then Exit Sub
  'nam$=trim$(left$(buf$,res%))
  TexPos.Caption = ofsx & "," & ofsy
End Sub

Sub PtlB_DblClick ()
  If PtlB.ListCount < 0 Then Exit Sub
  If PtlB.ListIndex < 0 Then Exit Sub
  'DUPLICATE
  Dim pat%
  pat% = (PtlB.ItemData(PtlB.ListIndex) And &H7FFF&)
  'get patch into pat%, nam$,ofsx% ofsy%
  Dim ofsx%, ofsy%, nam$, res%
  Dim buf As String * 10
  res% = WADTgetPatch(PWADself%, PWADtexu%, pat%, buf$, ofsx%, ofsy%)
  If res% < 0 Then Exit Sub
  nam$ = Trim$(Left$(buf$, res%))
  'make it a floating Bmp
  Call FloatingSet(nam$)
End Sub

Sub PtlB_KeyDown (KeyCode As Integer, Shift As Integer)
    Select Case KeyCode
      Case KEY_DELETE    'delete
	Call CmdMove_Click(5) 'delete
      Case KEY_SPACE     'bring front
	Call CmdMove_Click(4) 'bring front
    End Select
End Sub

Sub PwadRef_Change ()
  If WindowInit2(Val(PwadRef.Caption)) > 0 Then Exit Sub
  '
  ' Close WAD, don't restore it
  '
  Call PWADfree(PWADself%, False)
  PWADself% = -1
  Unload Me
End Sub

Sub TexOfs_Change ()
   '
   ' Move left and right the texture picture
   '
   TexuB.Move (TexOfs.Value * Screen.TwipsPerPixelX), 0
End Sub

Sub TexuB_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
  '
  ' PASTE patch on texture box if left click
  ' discard patch if right click
  '
  If PicB.Visible Then
    If Button And LEFT_BUTTON Then
     'left click: paste picture
     Call FloatingDrop
    Else
     'right click: discard
      PicB.Visible = False
    End If
  End If
End Sub

Sub TexuB_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
  'move Floating image
  Call FloatingMove(Int(X), Int(Y))
End Sub

Sub TexuB_Paint ()
  Dim res%
  TexBB.hWnd = TexuB.hWnd
  TexBB.hDC = TexuB.hDC
  res% = WADshowWindoze(TexBB, 0)
End Sub

Sub TexuChange ()
  Dim szx%, szy%
  szx% = 2 ^ TexuWidth.Value
  szy% = TexuHeight.Value
  If WADTsetTex(PWADself%, PWADtexu%, "", szx%, szy%, 3) < 0 Then Exit Sub'set
  '
  ' fix name in list
  '
  If TexuLst.ListCount <= 0 Then Exit Sub
  If PWADtexuRef < 0 Then Exit Sub
  If PWADtexuRef% >= TexuLst.ListCount Then Exit Sub
  If (TexuLst.ItemData(PWADtexuRef%) And &H7FFF&) <> PWADtexu% Then Exit Sub
  TexuLst.List(PWADtexuRef%) = Left$(TexuLst.List(PWADtexuRef%), 8) & " " & Format$(szx%, "@@@") & " " & Format$(szy%, "@@@")
End Sub

Sub TexuFlt_Click (Index As Integer)
   '
   ' Filters on texture list
   '
   Call TexuList
End Sub

Sub TexuHeight_Change ()
  If texulock Then Exit Sub
  texulock = True
  '
  ' change height of texture, from 0 to 128
  '
  Call TexuHeight_Scroll
  '
  texulock = False
  '
  If PWADtexu% < 0 Then Exit Sub
  '
  ' Modify texture in list
  '
  Call TexuChange
  '
  ' Show again
  '
  Call TexuShow
End Sub

Sub TexuHeight_Scroll ()
  ValTxHeight.Caption = Str$(TexuHeight.Value)
End Sub

Sub TexuList ()
  ' list all textures
  TexuLst.Visible = False
  Dim fltwhich%, fltnew%
  fltnew% = -1
  fltwhich% = 0
  If TexuFlt(0).Value Then fltnew% = 1
  If TexuFlt(1).Value Then fltwhich% = 1
  If TexuFlt(2).Value Then fltwhich% = 2 * (1 - fltwhich%)
  TxlBB.hWnd = TexuLst.hWnd
  If WADTlistTex(PWADself%, TxlBB, fltwhich%, fltnew%) < 0 Then Exit Sub
  TexuLst.Visible = True
  'select
  Call ListFindSelect(TexuLst, TexuName.Caption)
End Sub

Sub TexuLst_Click ()
  '
  ' Display a texture when clicked in texture list
  '
  If TexuLst.ListCount <= 0 Then Exit Sub
  If TexuLst.ListIndex < 0 Then Exit Sub
  Dim texu%
  texu% = (TexuLst.ItemData(TexuLst.ListIndex) And &H7FFF&)
  If texu% < 0 Then Exit Sub
  PWADtexu% = -1
  '
  ' get texture
  '
  Dim szx%, szy%, nam$, res%
  Dim buf As String * 10
  res% = WADTgetTex(PWADself%, texu%, buf$, szx%, szy%)
  If res% < 0 Then Exit Sub
  nam$ = Trim$(Left$(buf$, res%))
  '
  ' Indicate name
  '
  TexuName.Caption = nam$
  '
  ' Indicate size X and Y
  '
  If szy% > 4 And szy% <= 128 Then
     TexuHeight.Value = szy%
  End If
  Dim w%, pow%
  pow% = 4
  w% = 2
  Do While w% <= 11
    If pow% >= szx% Then Exit Do
    pow% = pow% * 2
    w% = w% + 1
  Loop
  TexuWidth.Value = w%
  '
  PWADtexu = texu%  'enable texture modification
  PWADtexuRef = TexuLst.ListIndex
  Call TexuShow
  '
  ' print help
  '
  EntryHelp.Caption = ChooseIdent(nam$, &H18, PWADgame%)'ETEXNAM texture
End Sub

Sub TexuLst_KeyDown (KeyCode As Integer, Shift As Integer)
   If KeyCode <> KEY_DELETE Then Exit Sub
   If TexuLst.ListCount <= 0 Then Exit Sub
   If TexuLst.ListIndex < 0 Then Exit Sub
   Dim texu%
   texu% = (TexuLst.ItemData(TexuLst.ListIndex) And &H7FFF&)
   'delete texture
   If WADTsetTex(PWADself%, texu%, "", 0, 0, 4) < 0 Then Exit Sub 'del
End Sub

Sub TexuShow ()
   If PWADtexu% < 0 Then Exit Sub
   '
   ' Update list of patches
   '
   Dim res%
   PtlBB.Typ = WlistBox
   PtlBB.hWnd = PtlB.hWnd
   res% = WADTlistPatch(PWADself%, PWADtexu%, PtlBB)
   DoEvents
   '
   ' Redraw Texture
   '
   TexBB.hWnd = TexuB.hWnd
   TexBB.hDC = TexuB.hDC
   '
   res% = WADTshowTex(PWADself%, PWADtexu%, TexBB)
   If res% < 0 Then Exit Sub
   'show texture
   res% = WADshowWindoze(TexBB, 0)
   'TexuB.Refresh 'provokes out of stack space
End Sub

Sub TexuWidth_Change ()
  If texulock Then Exit Sub
  texulock = True
  '
  ' Change the width of the texture, by power of 2
  '
  TexOfs.Value = 0
  If TexuWidth.Value > 9 Then
    TexOfs.Visible = True
    TexOfs.Max = 512 - 2 ^ TexuWidth.Value
  Else
    TexOfs.Visible = False
  End If
  Call TexuWidth_Scroll
  '
  texulock = False
  '
  If PWADtexu% < 0 Then Exit Sub
  '
  ' update on file
  '
  Call TexuChange
  '
  ' display
  '
  Call TexuShow
  '
End Sub

Sub TexuWidth_Scroll ()
  ValTxWidth.Caption = Str$(2 ^ TexuWidth.Value)
End Sub

Sub WindowFree ()
  '
  ' free pic boxes
  '
  Dim res%
  res% = WADshowWindoze(PicBB, -1)
  res% = WADshowWindoze(TexBB, -1)
  '
  ' Save texture and PNAMES if possible and needed
  ' Jump back to the main editing panel
  '
  If PWADself% < 0 Then Exit Sub
  '
  If TexuDirty Then
    If QueryOk("Save textures into PWAD?") Then
      Screen.MousePointer = 11 'wait
      'save textures and pnames
      res% = WADTsaveAll(PWADself%)
      Screen.MousePointer = 0 'normal
    End If
  End If
  'free texture list
  res% = WADTfree(PWADself%)
  '
  ' return to viewer
  '
  Dim View As New Viewer
  Load View
  View.PwadRef.Caption = PWADself%
  View.Show 0
End Sub

Sub WindowInit ()
  '
  ' Init window
  '
 '
 ' right justify help menu
 '
 M_H0.Caption = Chr$(8) & M_H0.Caption
 ' unlock modifs
 texulock = False
 '
 ' Initialise PWAD variables
 '
 PWADself% = -1
 PWADgame% = -1
 PWADtexu% = -1
 '
 ' no texture was modified
 '
 TexuDirty = False
 '
 ' patches are grabbed by the center
 '
 FBMPcentX = .5
 FBMPcentY = .5
 ' now the first event called must be WadRef_Change
 ' because this is the initialising event.
 ' call this even by setting Me.WadRef = ...
 '
End Sub

Function WindowInit2% (ByVal Self%)
  '
  ' Init window
  '
  WindowInit2 = -1 'fail, by default
  '
  ' boxes
  '
  PatBB.Typ = WlistBox
  TxlBB.Typ = WlistBox
  PtlBB.Typ = WlistBox
  Dim res%
  PicBB.Typ = WpicBox
  res% = WADshowWindoze(PicBB, 1)
  TexBB.Typ = WpicBox
  res% = WADshowWindoze(TexBB, 1)
  '
  '
  ' Check if PWAD exists
  '
  PWADself% = Self%       'reference of WAd
  Dim dirty%, file$
  If Not PWADgetInfo(PWADself%, PWADgame%, PWADmainWad%, dirty%, file$) Then
    Unload Me
    Exit Function
  End If
  '
  ' set windoze handle
  '
  If WADsetCustoms(PWADself%, Me.hWnd) < 0 Then Exit Function
  '
  ' form title
  '
  Me.Caption = "Textures in " & file$
  '
  ' Init, and retreive the name of game and wad
  '
  PWADtexu% = -1  'disable texture editing
  FBMPnam$ = ""   'no floating
  '
  ' Init texture (should check PWADself before)
  '
  Screen.MousePointer = 11'wait
  '
  res% = WADTinit(PWADself%)
  '
  If res% < 0 Then
    Screen.MousePointer = 0 'end wait
    PWADself% = -1
    Unload Me
  End If
  '
  ' List all textures in PWAD or IWAD
  '
  '
  Call TexuList
  '
  ' List patches in PWAD
  '
  Call M_Patch_Click(0)
  '
  Screen.MousePointer = 0 'end wait
  '
  WindowInit2 = 1 'ok
End Function

