VERSION 2.00
Begin Form EdtLevel 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Levels"
   ClientHeight    =   5685
   ClientLeft      =   525
   ClientTop       =   1155
   ClientWidth     =   8775
   ClipControls    =   0   'False
   FontBold        =   -1  'True
   FontItalic      =   0   'False
   FontName        =   "Courier"
   FontSize        =   9.75
   FontStrikethru  =   0   'False
   FontUnderline   =   0   'False
   Height          =   6345
   HelpContextID   =   100
   Icon            =   EDTLEVEL.FRX:0000
   Left            =   480
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   5685
   ScaleWidth      =   8775
   Top             =   540
   Width           =   8865
   Begin ListBox DirB 
      BackColor       =   &H00C0C0C0&
      Height          =   3150
      Left            =   60
      TabIndex        =   14
      Top             =   2400
      Width           =   1635
   End
   Begin Frame FrmShow 
      BackColor       =   &H00C0C0C0&
      ForeColor       =   &H00000000&
      Height          =   1875
      Left            =   60
      TabIndex        =   13
      Top             =   60
      Width           =   1635
      Begin CommandButton ShowWhat 
         Caption         =   "Nodes"
         Height          =   315
         Index           =   2
         Left            =   840
         TabIndex        =   21
         Top             =   1440
         Width           =   735
      End
      Begin CommandButton ShowWhat 
         Caption         =   "Walls"
         Height          =   315
         Index           =   3
         Left            =   60
         TabIndex        =   20
         Top             =   1440
         Width           =   735
      End
      Begin CommandButton ShowWhat 
         Caption         =   "Reject"
         Height          =   315
         Index           =   1
         Left            =   840
         TabIndex        =   19
         Top             =   1080
         Width           =   735
      End
      Begin CommandButton ShowWhat 
         Caption         =   "Sector"
         Height          =   315
         Index           =   0
         Left            =   60
         TabIndex        =   18
         Top             =   1080
         Width           =   735
      End
      Begin Label NodeDepth 
         BackColor       =   &H00C0C0C0&
         BackStyle       =   0  'Transparent
         Caption         =   "Depth= 0"
         ForeColor       =   &H00000080&
         Height          =   255
         Left            =   180
         TabIndex        =   17
         Top             =   720
         Visible         =   0   'False
         Width           =   975
      End
      Begin Label ValObj 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "0"
         ForeColor       =   &H00000000&
         Height          =   255
         Left            =   1020
         TabIndex        =   16
         Top             =   300
         Width           =   495
      End
      Begin Label LvlWhat 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Sector"
         ForeColor       =   &H00000000&
         Height          =   255
         Left            =   120
         TabIndex        =   15
         Top             =   240
         Width           =   795
      End
   End
   Begin PictureBox LevB 
      BackColor       =   &H00000000&
      BorderStyle     =   0  'None
      ClipControls    =   0   'False
      Height          =   4815
      Left            =   1800
      ScaleHeight     =   4815
      ScaleWidth      =   6915
      TabIndex        =   0
      Top             =   420
      Width           =   6915
   End
   Begin Label Infos 
      BackColor       =   &H00C0C0C0&
      BackStyle       =   0  'Transparent
      Caption         =   "List of Levels"
      ForeColor       =   &H00800000&
      Height          =   255
      Index           =   3
      Left            =   120
      TabIndex        =   24
      Top             =   2100
      Width           =   1335
   End
   Begin Label Infos 
      BackColor       =   &H00C0C0C0&
      BackStyle       =   0  'Transparent
      Caption         =   "Upper"
      ForeColor       =   &H00800000&
      Height          =   255
      Index           =   0
      Left            =   2100
      TabIndex        =   23
      Top             =   5340
      Width           =   615
   End
   Begin Label Infos 
      BackColor       =   &H00C0C0C0&
      BackStyle       =   0  'Transparent
      Caption         =   "Lower"
      ForeColor       =   &H00800000&
      Height          =   255
      Index           =   2
      Left            =   6600
      TabIndex        =   7
      Top             =   5340
      Width           =   615
   End
   Begin Label Infos 
      BackColor       =   &H00C0C0C0&
      BackStyle       =   0  'Transparent
      Caption         =   "Middle"
      ForeColor       =   &H00800000&
      Height          =   255
      Index           =   1
      Left            =   4380
      TabIndex        =   8
      Top             =   5340
      Width           =   615
   End
   Begin Label SideTex 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "-"
      Height          =   255
      Index           =   2
      Left            =   5100
      TabIndex        =   10
      Top             =   5340
      Width           =   1275
   End
   Begin Label SideTex 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "-"
      Height          =   255
      Index           =   1
      Left            =   7260
      TabIndex        =   12
      Top             =   5340
      Width           =   1275
   End
   Begin Label SideTex 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "-"
      ForeColor       =   &H00000000&
      Height          =   255
      Index           =   0
      Left            =   2880
      TabIndex        =   11
      Top             =   5340
      Width           =   1275
   End
   Begin Label EntryHelp 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      ForeColor       =   &H00800000&
      Height          =   315
      Left            =   5040
      TabIndex        =   6
      Top             =   60
      Width           =   3615
   End
   Begin Label LvlPos 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "0,0"
      ForeColor       =   &H00FF0000&
      Height          =   255
      Left            =   1860
      TabIndex        =   3
      Top             =   60
      Width           =   1275
   End
   Begin Label PwadRef 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      BackStyle       =   0  'Transparent
      Caption         =   "PWadRef"
      ForeColor       =   &H000000FF&
      Height          =   195
      Left            =   420
      TabIndex        =   1
      Top             =   840
      Visible         =   0   'False
      Width           =   855
   End
   Begin Menu M_F0 
      Caption         =   "&File"
      Begin Menu M_Fplay 
         Caption         =   "&Play game"
      End
      Begin Menu M_F1 
         Caption         =   "-"
      End
      Begin Menu M_Fquit 
         Caption         =   "&Quit"
      End
   End
   Begin Menu M_L0 
      Caption         =   "&Level"
      Begin Menu M_Ledit 
         Caption         =   "&Edit Level"
      End
      Begin Menu M_Ltx 
         Caption         =   "&Texture WAD..."
         Begin Menu M_Ltex 
            Caption         =   "&None"
            Index           =   0
         End
         Begin Menu M_Ltex 
            Caption         =   "&Current WAD"
            Checked         =   -1  'True
            Index           =   1
         End
      End
      Begin Menu M_Luse 
         Caption         =   "&Editor..."
         Begin Menu M_Edt 
            Caption         =   "DCK"
            Checked         =   -1  'True
            Index           =   0
         End
         Begin Menu M_Edt 
            Caption         =   "DEU"
            Index           =   1
         End
         Begin Menu M_Edt 
            Caption         =   "DeeP"
            Index           =   2
         End
         Begin Menu M_Edt 
            Caption         =   "DoomCAD"
            Index           =   3
         End
         Begin Menu M_Edt 
            Caption         =   "DoomEd"
            Index           =   4
         End
         Begin Menu M_Edt 
            Caption         =   "Edmap"
            Index           =   5
         End
         Begin Menu M_Edt 
            Caption         =   "EgoEd"
            Index           =   6
         End
         Begin Menu M_Edt 
            Caption         =   "WinDEU"
            Index           =   7
         End
         Begin Menu M_Edt 
            Caption         =   "Wad Author"
            Index           =   8
         End
         Begin Menu M_Edt 
            Caption         =   "WadEd"
            Index           =   9
         End
         Begin Menu M_Edt 
            Caption         =   "DMapEdit"
            Index           =   10
         End
         Begin Menu M_Edt 
            Caption         =   "DETH"
            Index           =   11
         End
         Begin Menu M_Edt 
            Caption         =   "Other"
            Index           =   12
         End
      End
      Begin Menu M_L1 
         Caption         =   "-"
      End
      Begin Menu M_Lload 
         Caption         =   "&Load Level"
      End
      Begin Menu M_Lsav 
         Caption         =   "&Save Level"
      End
      Begin Menu M_L2 
         Caption         =   "-"
      End
      Begin Menu M_Lren 
         Caption         =   "&Rename Level"
      End
      Begin Menu M_Ldel 
         Caption         =   "&Delete Level"
      End
   End
   Begin Menu M_N0 
      Caption         =   "&Nodes && Blocks"
      Begin Menu M_Nedit 
         Caption         =   "&Calculate"
      End
      Begin Menu M_Nuse 
         Caption         =   "&Tool..."
         Begin Menu M_Nnd 
            Caption         =   "&Warm BSP"
            Checked         =   -1  'True
            Index           =   0
         End
         Begin Menu M_Nnd 
            Caption         =   "&DeeP BSP"
            Index           =   1
         End
         Begin Menu M_Nnd 
            Caption         =   "&BSP"
            Index           =   2
         End
         Begin Menu M_Nnd 
            Caption         =   "&Other"
            Index           =   3
         End
      End
   End
   Begin Menu M_R0 
      Caption         =   "&Reject"
      Begin Menu M_Rcalc 
         Caption         =   "&Calculate"
      End
      Begin Menu M_Ruse 
         Caption         =   "&Tool..."
         Begin Menu M_Rrj 
            Caption         =   "&RMB"
            Checked         =   -1  'True
            Index           =   0
         End
         Begin Menu M_Rrj 
            Caption         =   "&Warm"
            Index           =   1
         End
         Begin Menu M_Rrj 
            Caption         =   "R&eject"
            Index           =   2
         End
         Begin Menu M_Rrj 
            Caption         =   "&Other"
            Index           =   3
         End
      End
      Begin Menu M_R1 
         Caption         =   "-"
      End
      Begin Menu M_Rsav 
         Caption         =   "&Save changes"
      End
      Begin Menu M_R2 
         Caption         =   "-"
      End
      Begin Menu M_RSafe 
         Caption         =   "&Safe sector"
         Index           =   0
      End
      Begin Menu M_RSafe 
         Caption         =   "&Unsafe sector"
         Index           =   1
      End
      Begin Menu M_R3 
         Caption         =   "-"
      End
      Begin Menu M_Redt 
         Caption         =   "&Edit .REJ file"
      End
      Begin Menu M_Reff 
         Caption         =   "E&fficiency"
         Enabled         =   0   'False
      End
   End
   Begin Menu M_T0 
      Caption         =   "&Texture"
      Begin Menu M_TTex 
         Caption         =   "Change &Textures"
      End
      Begin Menu M_TFlat 
         Caption         =   "Change &Floors"
      End
      Begin Menu M_T1 
         Caption         =   "-"
      End
      Begin Menu M_TexSave 
         Caption         =   "&Save changes"
      End
   End
   Begin Menu M_H0 
      Caption         =   "&Help"
      Begin Menu M_Hzm 
         Caption         =   "&Zoom"
      End
      Begin Menu M_H1 
         Caption         =   "-"
      End
      Begin Menu M_Hlv 
         Caption         =   "Edit Levels"
      End
      Begin Menu M_Htex 
         Caption         =   "New Textures"
      End
      Begin Menu M_Hflat 
         Caption         =   "New Floor/Ceilings"
      End
      Begin Menu M_Hnd 
         Caption         =   "Build Nodes"
      End
      Begin Menu M_Hrj 
         Caption         =   "Build Reject"
      End
      Begin Menu M_Hbl 
         Caption         =   "Tricks with Reject"
      End
   End
End
Option Explicit
'
'
Dim PWADself%      'ref. of the PWAD
Dim PWADgame%    'code for the game
Dim PWADmainWad% 'main Wad
Dim PWADtyp%     'type beeing listed
Dim PWADfile$    'PWAD file (here, the texture WAD)
'
'
Dim RejDirty% 'say if Reject data was modified
Dim SidDirty% 'say if Side data was modified
Dim SecDirty% 'say if Sector data was modified
'
'
Dim LvlCurrent%       ' level currently examined
Dim LvlWhich%         ' what is displayed? level, reject, node?
Dim LvlBound As bound ' level reference min/max
Dim LvlScale As bound ' current min/max/scale
Dim LvlObj%           'current object
Dim LvlX%             'current X
Dim LvlY%             'current Y
'
'
Dim EditorId% 'ident of the level editor
              '0=windeu 1=...
              'if <0, custor editor
Dim NodeBuildId%
Dim RejBuildId%

Dim LevBB As windoze

Sub DirB_Click ()
  '
  ' show level
  '
  Dim Entry%, ident%, nam$
  Entry% = PWADdirGetName(DirB, ident%, nam$)
  If Entry% < 0 Then Exit Sub
  Call LevelShow(Entry%, ident%, nam$)
End Sub

Sub DirB_DblClick ()
  Call M_Ledit_Click 'edit level
End Sub

Sub DirB_KeyDown (KeyCode As Integer, shift As Integer)
  Select Case KeyCode
    Case KEY_DELETE
      'delete entry
      Call M_Ldel_Click
  End Select
End Sub

Sub Form_Load ()
  '
  ' init window
  '
  Call WindowInit
End Sub

Sub Form_Unload (Cancel As Integer)
  Call WindowFree
End Sub

Function GetTexus$ (ByVal IsTexu%, ByVal upper$, ByVal lower$, ByVal middle$)
  '
  ' Select a texture name
  '
  Dim GetTex As New GetTexu
  Load GetTex
  'arguments
  GetTex.TexuName(0).Caption = upper$
  GetTex.TexuName(1).Caption = lower$
  GetTex.TexuName(2).Caption = middle$
  '
  ' params for GetTex
  If IsTexu% Then
    GetTex.IsTexu = 1 'it's a texture
  Else
    GetTex.IsTexu = 0 'it's a flat
  End If
  GetTex.PwadRef.Caption = PWADself%
  '
  ' default result is void
  '
  Call ChooseSetRes("")
  '
  ' show GetTexu, modal
  '
  Me.Visible = False
  GetTex.Show 1
  Me.Visible = True
  DoEvents
  '
  ' return result
  '
  GetTexus$ = ChooseGetRes$()

End Function

Sub Infos_Click (Index As Integer)
  Dim txt$
  Select Case Index
    Case 0
      txt$ = "upper"
    Case 1
      txt$ = "middle"
    Case 2
      txt$ = "lower"
  End Select
  Call Infos("This is the name of the texture in the " & txt$ & " part of the wall.")
End Sub

Sub LevB_KeyDown (KeyCode As Integer, shift As Integer)
 Dim modif%
 Select Case KeyCode
   Case KEY_LEFT
    modif% = 0
   Case KEY_UP
    modif% = 3
   Case KEY_RIGHT
    modif% = 1
   Case KEY_DOWN
    modif% = 2
   Case Else
    Exit Sub
 End Select
 If WADLboundScale(LvlScale, 0, 0, modif%) < 0 Then Exit Sub
 Call LevelDisplay
End Sub

Sub LevB_MouseDown (Button As Integer, shift As Integer, X As Single, Y As Single)
 
 If Button And LEFT_BUTTON Then
   Call LevelPoint(shift%, Int(X), Int(Y))
 Else
   ' zoom in zoom out, on right click
   Call LevelZoom(shift%, Int(X), Int(Y))
 End If
End Sub

Sub LevB_MouseMove (Button As Integer, shift As Integer, X As Single, Y As Single)
   LvlPos.Caption = Int(X) & "," & Int(Y)
End Sub

Sub LevB_Paint ()
  Dim res%
  res% = WADshowWindoze(LevBB, 0)
End Sub

Sub LevelDisplay ()
  '
  ' show reject
  '
  ' display level
  '
  ' BoundEx = bounding box. min/max must be set
  '           szX SzY must be set
  ' which:   0 = show sectors
  '          1 = show reject
  '          2 = show nodes
  '          4 = show walls
  '
  ' show
  '
  LvlScale.SzX = LvlBound.SzX
  LvlScale.SzY = LvlBound.SzY
  '
  Dim Id%, res%
  Select Case LvlWhich%
    Case 0 'level
      Id% = &H800 'ESECTOR
    Case 1 'reject
      Id% = &H900 'EREJECT
    Case 2 'nodes
      Id% = &H700 'ENODE
    Case 3 'texture
      Id% = &H300 'ESIDEDEF
    Case Else
      Exit Sub 'bug
  End Select
  '
  LevBB.hWnd = LevB.hWnd
  LevBB.hDC = LevB.hDC
  '
  res% = WADLshowLevel(PWADself%, LvlCurrent%, LvlObj%, Id%, LvlScale, LevBB)
  If res% < 0 Then Exit Sub
  LevB.Refresh
  Dim w&, h&
  w& = LvlScale.Xmax
  w& = w& - LvlScale.Xmin
  If w& > 1 And w& < &H7FFF Then LevB.ScaleWidth = w&
  h& = LvlScale.Ymax
  h& = h& - LvlScale.Ymin
  h& = -h& 'origin is lower left
  If w& > 1 And w& < &H7FFF Then LevB.ScaleHeight = h&
  w& = LvlScale.Xmin
  If w& > -&H7FFF And w& < &H7FFF Then LevB.ScaleLeft = w&
  h& = LvlScale.Ymax 'origin is lower left
  If h& > -&H7FFF And h& < &H7FFF Then LevB.ScaleTop = h&
End Sub

Sub LevelPoint (ByVal shift%, ByVal X%, ByVal Y%)

   '
   ' point object, on left click
   '
   Dim res&, Id%
   Select Case LvlWhich%
     Case 0 'level
       Id% = &H800 'ESECTOR
     Case 1 'reject
       Id% = &H800 'ESECTOR
     Case 2 'node
       Id% = &H700 'ENODE
     Case 3 'wall
       Id% = &H300 'ESIDEDEF
   End Select
   '
   ' point...
   '
   res& = WADLpointObject&(PWADself%, LvlCurrent%, Id%, LvlObj%, X%, Y%, LvlX%, LvlY%)
   If res& < 0 Then Exit Sub
   '
   If LvlWhich% = 2 Then 'nodes
     NodeDepth.Caption = "Depth=" & Str$((res& And &HFF0000) / &H10000)
     NodeDepth.Visible = True
   Else
     NodeDepth.Visible = False
   End If
   res& = res& And &H7FFF&
   '
   If LvlWhich% = 1 And shift Then 'reject, toggle
     '
     ' toggle sector status, if shift+click
     '
     res& = WADLmodifyReject(PWADself%, LvlCurrent%, LvlObj%, res&, 0)' 0=toggle
     If res& < 0 Then Exit Sub
     RejDirty% = True
   Else
     LvlX% = X%
     LvlY% = Y%
     LvlObj% = res&
     ValObj.Caption = LvlObj%
   End If
   '
   If LvlWhich% = 0 Then 'level
     Call SectorGetTexu(LvlCurrent%, LvlObj%)
   End If
   '
   If LvlWhich% = 3 Then 'wall
     Call SideGetTexu(LvlCurrent%, LvlObj%)
   End If
   Call LevelDisplay
End Sub

Sub LevelPointInit (ByVal which%)
  '
  ' Init for clicking in level data
  '
  LvlObj% = -1
  LvlX% = 0
  LvlY% = 0
  '
  LvlWhich% = which% '0,1,2,3
  Dim txt$
  M_T0.Enabled = False 'disable texture menu
  Select Case LvlWhich%
    Case 0  'level
      txt$ = "Sector"
      M_T0.Enabled = True 'enable texture menu
      M_TTex.Enabled = False 'disable texture
      M_TFlat.Enabled = True 'enable flat
    Case 1  'reject
      txt$ = "Sector"
    Case 2  'node
      txt$ = "Node"
    Case 3  'sidedef
      txt$ = "Sidedef"
      M_T0.Enabled = True 'enable texture menu
      M_TTex.Enabled = True 'enable texture
      M_TFlat.Enabled = False 'disable flat
  End Select
  LvlWhat.Caption = txt$
  Call LevelDisplay
End Sub

Sub LevelSave (ByVal check%)
  
  If check% Then
    If RejDirty% Then  'avoid losing reject
      If Not QueryOk("Save modified REJECT?") Then RejDirty% = False
    End If
    If SidDirty% Then  'avoid losing sidedef
      If Not QueryOk("Save modified SIDEDEFS?") Then SidDirty% = False
    End If
    If SecDirty% Then  'avoid losing sidedef
      If Not QueryOk("Save modified SECTORS?") Then SecDirty% = False
    End If
  End If
  Dim res%
  If RejDirty% Then  'avoid losing reject
     res% = WADLsaveLevel(PWADself%, LvlCurrent%, &H900) 'EREJECT
     RejDirty% = False
  End If
  If SidDirty% Then  'avoid losing sidedef
     res% = WADLsaveLevel(PWADself%, LvlCurrent%, &H300) 'ESIDEDEF
     SidDirty% = False
  End If
  If SecDirty% Then  'avoid losing sector
     res% = WADLsaveLevel(PWADself%, LvlCurrent%, &H800) 'ESECTOR
     SecDirty% = False
  End If
End Sub

Sub LevelShow (ByVal Entry%, ByVal ident%, nam$)
  '
  ' show current entry in list
  '
  If Entry% < 0 Then Exit Sub
  If ident% <> &HB00 Then Exit Sub  'ELVLHDR level header only
  'help
  EntryHelp.Caption = ChooseIdent(nam$, &H0, PWADgame%)'ELEVEL
  '
  ' Safeguard
  '
  Call LevelSave(True)
  
  '
  ' determine current level
  '
  LvlCurrent% = Entry%
  '
  ' determine bounds
  '
  Dim res%
  res% = WADLboundLevel(PWADself%, LvlCurrent%, LvlBound)
  LvlBound.SzX = 460
  LvlBound.SzY = 300
  '
  ' determine viewed area = all level
  '
  LvlScale.Xmin = LvlBound.Xmin
  LvlScale.Ymin = LvlBound.Ymin
  LvlScale.Xmax = LvlBound.Xmax
  LvlScale.Ymax = LvlBound.Ymax
  '
  ' reset level viewer.
  '
  LvlObj% = -1
  LvlX% = 0
  LvlY% = 0
  '
  ' display level
  '
  Call LevelDisplay
End Sub

Sub LevelZoom (ByVal shift%, ByVal X%, ByVal Y%)
   '
   ' zoom in or out
   '
   Dim modif%
   If shift Then
     modif% = &H10 'zoom out
   Else
     modif% = &H11 'zoom in
   End If
   If WADLboundScale(LvlScale, X%, Y%, modif%) < 0 Then Exit Sub
   Call LevelDisplay
End Sub

Sub M_Edt_Click (Index As Integer)
  Dim i%
  For i% = 0 To 11 'index max of M_Edt
    M_Edt(i%).Checked = False
  Next i%
  M_Edt(Index).Checked = True
  '
  ' choose identify of editor
  '
  EditorId% = Choose(Index + 1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, -1)
  Call INIputValue("LevelEdit", "Which", Str$(EditorId%), False)
End Sub

Sub M_Fplay_Click ()
  If Not tutor(2, "call DOOM or HERETIC on a single level file (plus custom textures and flats)") Then Exit Sub
  '
  ' select texture WAD
  '
  Dim texwd$    'texture WAD, if not null
  If M_Ltex(1).Checked Then  'selector
    texwd$ = PWADfile$
    If Not DIRexistFile(texwd$) Then texwd$ = ""
    If WADsaveDir(PWADself%) < 0 Then Exit Sub
  Else
    texwd$ = ""
  End If
  '
  ' save WAD to a temporary file
  '
  Dim Entry%, ident%, nam$
  Entry% = PWADdirGetName(DirB, ident%, nam$)
  If Entry% < 0 Then Exit Sub
  '
  ' Save an entry to temporary file
  '
  Dim file$, ext$
  file$ = PWADentrySaveTmp(PWADself%, Entry%, ident%, nam$, ext$)
  If file$ = "" Then Exit Sub
  '
  Call XternRunGame(file$, texwd$)
End Sub

Sub M_FQuit_Click ()
  Call LevelSave(True)
  Unload Me
End Sub

Sub M_Hbl_Click ()
  Call WinTexHelp(660)  'L_REJEFF
End Sub

Sub M_Hflat_Click ()
  Call WinTexHelp(690)  'L_FLAT
End Sub

Sub M_Hlv_Click ()
  Call WinTexHelp(600)  'L_LEVEL
End Sub

Sub M_Hnd_Click ()
  Call WinTexHelp(630)  'L_NODE
End Sub

Sub M_Hrj_Click ()
  Call WinTexHelp(650)  'L_REJECT
End Sub

Sub M_Htex_Click ()
    Call WinTexHelp(680)  'L_TEXTURE
End Sub

Sub M_Hzm_Click ()
   Call Infos("Zoom: Right Click to zoom in, SHIFT+Left Click to zoom out. Arrow keys to move display.")
End Sub

Sub M_Ldel_Click ()
  Dim Entry%, ident%, nam$
  Entry% = PWADdirGetName(DirB, ident%, nam$)
  If Entry% < 0 Then Exit Sub
  If Not tutor(1, "This will delete the level " & nam$ & "from the directory. Note that the data is NOT deleted from file.") Then Exit Sub
  'delete entry
  Dim res%
  res% = WADsetEntry%(PWADself%, Entry%, nam$, 0, 0, -1, OPS_DEL)'delete
  '
  ' list directory
  '
  Call PWADdirList(PWADself%, DirB, PWADtyp%, res%)
End Sub

Sub M_Ledit_Click ()
  '
  ' select texture WAD
  '
  Dim texwd$    'texture WAD, if not null
  If M_Ltex(1).Checked Then  'selector
    texwd$ = PWADfile$
    If Not DIRexistFile(texwd$) Then texwd$ = ""
    If WADsaveDir(PWADself%) < 0 Then Exit Sub
  Else
    texwd$ = ""
  End If
  '
  ' save WAD to a temporary file
  '
  Dim Entry%, ident%, nam$
  Entry% = PWADdirGetName(DirB, ident%, nam$)
  If Entry% < 0 Then Exit Sub
  '
  ' Save an entry to temporary file
  '
  Dim file$, ext$
  file$ = PWADentrySaveTmp(PWADself%, Entry%, ident%, nam$, ext$)
  If file$ = "" Then Exit Sub
  '
  ' start reject editor
  '
  Dim appli%
  appli% = XternEditor(EditorId%, file$, nam$, texwd$)
  If appli% = 0 Then Exit Sub
  '
  ' wait for appli to terminate
  '
  Me.Visible = False: DoEvents
  Call XternWaitEnd(appli%)
  Me.Visible = True: DoEvents
  '
  ' load wad from temporary file
  '
  If Not DIRexistFile(file$) Then Exit Sub
  If Not QueryOk("Really modify level map?") Then Exit Sub
  appli% = WADloadLevel(PWADself%, Entry%, file$, 0)'0=all level
  If appli% < 0 Then
    Call Crash("Level could not be loaded.")
  End If
End Sub

Sub M_Lload_Click ()
  Dim Entry%
  Entry% = PWADentryLoad(PWADself%, DirB, PWADtyp%, PWADgame%)
  '
  ' list updated directory
  '
  If Entry% < 0 Then Exit Sub
  Call PWADdirList(PWADself%, DirB, PWADtyp%, Entry%)
End Sub

Sub M_Lren_Click ()
  Dim Entry%, ident%, nam$
  Entry% = PWADdirGetName(DirB, ident%, nam$)
  If Entry% < 0 Then Exit Sub
  If Not tutor(1, "This will rename the level " & nam$ & "from the directory. Note that the data is NOT deleted from file.") Then Exit Sub
  '
  ' name it
  '
  nam$ = InputBox$("Choose a valid name for your Level (Beware! No checks!)", "WinTex", nam$)
  '
  ' rename entry
  '
  Dim res%
  res% = WADsetEntry(PWADself%, Entry%, nam$, -1, -1, -1, OPS_SET) 'set
  '
  ' list directory
  '
  Call PWADdirList(PWADself%, DirB, PWADtyp%, res%)
End Sub

Sub M_Lsav_Click ()
  Call PWADentrySave(PWADself%, DirB)
End Sub

Sub M_Nedit_Click ()
  If Not tutor(1, "Build the nodes and blockmap in your select level WAD. This is needed before you can play the WAD, if your level editor can't do it correctly.") Then Exit Sub
  '
  ' save WAD to a temporary file
  '
  Dim Entry%, ident%, nam$
  Entry% = PWADdirGetName(DirB, ident%, nam$)
  If Entry% < 0 Then Exit Sub
  '
  ' Save an entry to temporary file
  '
  Dim file$, ext$
  file$ = PWADentrySaveTmp(PWADself%, Entry%, ident%, nam$, ext$)
  If file$ = "" Then Exit Sub
  '
  ' start node editor
  '
  Dim appli%
  appli% = XternNode(NodeBuildId%, file$, nam$)
  If appli% = 0 Then Exit Sub
  '
  ' wait for appli to terminate
  '
  Me.Visible = False: DoEvents
  Call XternWaitEnd(appli%)
  Me.Visible = True: DoEvents
  '
  ' load wad from temporary file
  '
  If Not DIRexistFile(file$) Then Exit Sub
  If Not QueryOk("Really modify level BSP?") Then Exit Sub
  appli% = WADloadLevel(PWADself%, Entry%, file$, 1)'1=nodes
  If appli% < 0 Then
    Call Crash("Level BSP could not be loaded.")
  End If
End Sub

Sub M_Nnd_Click (Index As Integer)
  Dim i%
  For i% = 0 To 2 'index max of M_Edt
    M_Nnd(i%).Checked = False
  Next i%
  M_Nnd(Index).Checked = True
  '
  ' choose identify of editor
  '
  NodeBuildId% = Choose(Index + 1, 0, 1, 2, -1)
  Call INIputValue("NodeEdit", "Which", Str$(NodeBuildId%), False)
End Sub

Sub M_Rcalc_Click ()
  If Not tutor(1, "Build the reject data in your select level WAD. This is not required, but improves game speed.") Then Exit Sub
  '
  ' save WAD to a temporary file
  '
  Dim Entry%, ident%, nam$
  Entry% = PWADdirGetName(DirB, ident%, nam$)
  If Entry% < 0 Then Exit Sub
  '
  ' Save an entry to temporary file
  '
  Dim file$, ext$
  file$ = PWADentrySaveTmp(PWADself%, Entry%, ident%, nam$, ext$)
  If file$ = "" Then Exit Sub
  '
  ' start reject editor
  '
  Dim appli%
  appli% = XternReject(RejBuildId%, file$, nam$)
  If appli% = 0 Then Exit Sub
  '
  ' wait for appli to terminate
  '
  Me.Visible = False: DoEvents
  Call XternWaitEnd(appli%)
  Me.Visible = True: DoEvents
  '
  ' load wad from temporary file
  '
  If Not DIRexistFile(file$) Then Exit Sub
  If Not QueryOk("Really modify level Reject data?") Then Exit Sub
  appli% = WADloadLevel(PWADself%, Entry%, file$, 2)'2=reject
  If appli% < 0 Then
    Call Crash("Level Reject data could not be loaded.")
  End If
End Sub

Sub M_Redt_Click ()
  If Not tutor(1, "Edit the .REJ file of RMB (for special effects).") Then Exit Sub
  '
  ' get parameters of WAD
  '
  Dim Entry%, ident%, nam$
  Entry% = PWADdirGetName(DirB, ident%, nam$)
  If Entry% < 0 Then Exit Sub
  
  Dim file$
  file$ = MakeTempFile(nam$ & ".REJ")
  If Not DIRexistFile(file$) Then
    On Error GoTo norejed
    Open file$ For Output As #1
    Print #1, "# Reject file for level " & nam$
    Print #1, "# To be used with the RMB Tool."
    Close #1
  End If
  Dim appli%
  appli% = XternFileEdit(".txt", file$)'text
Exit Sub
norejed:
  Exit Sub
End Sub

Sub M_Reff_Click ()
  Call Infos("Not implemented yet")
End Sub

Sub M_Rrj_Click (Index As Integer)
  Dim i%
  For i% = 0 To 2 'index max of M_Edt
    M_Rrj(i%).Checked = False
  Next i%
  M_Rrj(Index).Checked = True
  '
  ' choose identify of editor
  '
  RejBuildId% = Choose(Index + 1, 1, 0, 2, -1)
  Call INIputValue("RejectEdit", "Which", Str$(RejBuildId%), False)
End Sub

Sub M_RSafe_Click (Index As Integer)
  If Not tutor(0, "make a sector totally safe (or unsafe), by modifying the Reject data.") Then Exit Sub
  Dim Ops%
  Ops% = 2 'unsafe
  If Index = 0 Then Ops% = 1'safe
  Ops% = WADLmodifyReject(PWADself%, LvlCurrent%, LvlObj%, -1, Ops%)' 1=safe,2=unsafe
  Call LevelDisplay
End Sub

Sub M_Rsav_Click ()
  If Not tutor(0, "save the modifications to the Reject lump of this level. Do this before selecting another level.") Then Exit Sub
  Call LevelSave(False)
End Sub

Sub M_TexSave_Click ()
  If Not tutor(0, "save the modifications to the Sidedef lump of this level. Do this before selecting another level.") Then Exit Sub
  Call LevelSave(False)
End Sub

Sub M_TFlat_Click ()
  '
  ' change texture name
  '
  Call SectorSetTexu(LvlCurrent%, LvlObj%)
  'Call LevelDisplay
End Sub

Sub M_TTex_Click ()
  '
  ' change texture name
  '
  Call SideSetTexu(LvlCurrent%, LvlObj%)
  'Call LevelDisplay
End Sub

Sub PwadRef_Change ()
  If WindowInit2(Val(PwadRef.Caption)) > 0 Then Exit Sub
  '
  ' Close WAD, don't restore it
  '
  Call PWADfree(PWADself%, False)
  PWADself% = -1
  '
  Unload Me
End Sub

Sub SectorGetTexu (ByVal lvl%, ByVal sec%)
  '
  ' Get name of texture
  '
  If lvl% < 0 Or sec% < 0 Then Exit Sub
  Dim Texu As String * 26
  Dim res%
  res% = WADLmodifTexu%(PWADself%, lvl%, sec%, 3, Texu$)'3=get sector
  If res% < 0 Then Exit Sub
  '
  ' Modify sect name
  '
  SideTex(0).Caption = Trim$(Mid$(Texu$, 1, 8))
  SideTex(1).Caption = Trim$(Mid$(Texu$, 1 + 8, 8))
  SideTex(2).Caption = ""
End Sub

Sub SectorSetTexu (ByVal lvl%, ByVal sec%)
  '
  ' Modify Texture, if allowed
  '
  If lvl% < 0 Or sec% < 0 Then Exit Sub
  Dim Texu$
  Texu$ = GetTexus$(False, SideTex(0).Caption, SideTex(1).Caption, "")
  If Texu$ = "" Then Exit Sub
  '
  ' update on screen
  '
  SideTex(0).Caption = Trim$(Mid$(Texu$, 1, 8))
  SideTex(1).Caption = Trim$(Mid$(Texu$, 1 + 8, 8))
  SideTex(2).Caption = ""
  '
  ' change in level
  '
  Dim res%
  res% = WADLmodifTexu%(PWADself%, LvlCurrent%, LvlObj%, 2, Texu$)'2=set sector
  '
  SecDirty% = True
End Sub

Sub ShowWhat_Click (Index As Integer)
  Call LevelPointInit(Index)
End Sub

Sub SideGetTexu (ByVal lvl%, ByVal sid%)
  '
  ' Get name of texture
  '
  If lvl% < 0 Or sid% < 0 Then Exit Sub
  Dim Texu As String * 26
  Dim res%
  res% = WADLmodifTexu%(PWADself%, lvl%, sid%, 1, Texu$)'1=get side
  If res% < 0 Then Exit Sub
  '
  ' Modify side name
  '
  SideTex(0).Caption = Trim$(Mid$(Texu$, 1, 8))
  SideTex(1).Caption = Trim$(Mid$(Texu$, 1 + 8, 8))
  SideTex(2).Caption = Trim$(Mid$(Texu$, 1 + 16, 8))
End Sub

Sub SideSetTexu (ByVal lvl%, ByVal sid%)
  '
  ' Modify Texture, if allowed
  '
  If lvl% < 0 Or sid% < 0 Then Exit Sub
  '
  ' get texture names
  '
  Dim Texu$
  Texu$ = GetTexus$(True, SideTex(0).Caption, SideTex(1).Caption, SideTex(2).Caption)
  If Texu$ = "" Then Exit Sub
  '
  ' update on screen
  '
  SideTex(0).Caption = Trim$(Mid$(Texu$, 1, 8))
  SideTex(1).Caption = Trim$(Mid$(Texu$, 1 + 8, 8))
  SideTex(2).Caption = Trim$(Mid$(Texu$, 1 + 16, 8))
  '
  ' change in level
  '
  Dim res%
  res% = WADLmodifTexu%(PWADself%, LvlCurrent%, LvlObj%, 0, Texu$)'0=set side
  '
  SidDirty% = True
End Sub

Sub WindowFree ()
  '
  ' Free level box
  '
  Dim res%
  res% = WADshowWindoze(LevBB, -1)
  '
  '
  ' return to viewer
  '
  If PWADself% < 0 Then Exit Sub
  Dim View As New Viewer
  Load View
  View.PwadRef.Caption = PWADself%
  View.Show 0
End Sub

Sub WindowInit ()
 '
 ' right justify help menu
 '
 M_H0.Caption = Chr$(8) & M_H0.Caption
 '
 PWADself% = -1
 '
 '
 RejDirty = False
 SidDirty = False
 SecDirty = False
 '
 ' select editor
 '
 Dim res%
 res% = Val(INIgetValue("LevelEdit", "Which"))
 If res% >= 0 Then Call M_Edt_Click(res%)
 res% = Val(INIgetValue("NodeEdit", "Which"))
 If res% >= 0 Then Call M_Nnd_Click(res%)
 res% = Val(INIgetValue("RejectEdit", "Which"))
 If res% >= 0 Then Call M_Rrj_Click(res%)
End Sub

Function WindowInit2% (ByVal self%)
  '
  ' Init window
  '
  WindowInit2 = -1 'fail
  '
  ' init level box
  '
  Dim res%
  LevBB.Typ = WpicBox
  res% = WADshowWindoze(LevBB, 1)
  '
  ' Init, and retrieve the name of game and wad
  '
  PWADself% = self%       'reference of WAd
  Dim dirty%, file$
  If Not PWADgetInfo(PWADself%, PWADgame%, PWADmainWad%, dirty%, file$) Then
    Exit Function
  End If
  PWADfile$ = file$
  PWADtyp% = &HB00   'ELVLHDR select level
  '
  ' set windoze handle
  '
  If WADsetCustoms(PWADself%, Me.hWnd) < 0 Then Exit Function
  '
  ' form title
  '
  Me.Caption = "Levels in " & file$
  '
  ' Current level
  '
  LvlCurrent% = -1  'none
  LvlWhich% = 0     'level map
  '
  Screen.MousePointer = 11'wait
  '
  ' List levels in PWAD
  '
  Call PWADdirList(PWADself%, DirB, PWADtyp%, -1)
  Screen.MousePointer = 0 'end wait
  '
  WindowInit2 = 1 'ok
End Function

