
/*
** WINDOZE related structure
*/
typedef struct
{
#if defined __WINDOWS__
  HWND  hWnd;  /* HWND Handle on a window*/
  HDC   hDC;   /* HDC Handle on a DC*/
  HBITMAP hBitmap;/* HBITMAP*/
  HPALETTE  hPal;  /* HPALETTE*/
  HDC   hBmpDC; /*DC to write in bitmap*/
  HANDLE Pad;  /*padding*/
#endif
  Int16 SzX;   /* bitmap width*/
  Int16 SzY;   /* bitmap height*/
  Int16 OfsX;
  Int16 OfsY;
}DISPLAY;
typedef DISPLAY PTR *pDISPLAY;
/*
** LISTBOX/COMBOBOX functions
*/
	 /*
	 ** Clear list box
	 */
Int16 LISTclear(HWND hWnd);
Int16 CMBXclear(HWND hWnd);
	 /*
	 ** Get number of elements  in list box
	 */
Int16 LISTcount(HWND hWnd);
Int16 CMBXcount(HWND hWnd);
	 /*
	 ** Set hList.List(Index)=Text hList.
	 ** ItemData(Index)=Code
	 */
Int16 LISTset(HWND hWnd, Int16 Index, Int32 Code, pInt8 Text);
Int16 CMBXset(HWND hWnd, Int16 Index, pInt8 Text);
	 /*
	 ** Get text, not more than TextSz.
	 ** return actual size of text
	 */
Int16 LISTget(HWND hWnd,Int16 Index,pInt8 Text,Int16 TextSz);
Int16 CMBXget(HWND hWnd,Int16 Index,pInt8 Text,Int16 TextSz);



	 /*
	 ** Get color in palette closets to RGB
	 */
Int8 BMP8getColor(pRGB Palette,Int16 Start,Int16 R,Int16 G,Int16 B);
	 /*
	 ** if Ops>0 init Windoze objects
	 ** if Ops==0 Display a bitmap 8 bits in Windoze
	 ** if Ops<0 free Windoze objects
	 */
Int16 BMP8display(pDISPLAY Pic, Int16 Ops);
	 /*
	 ** Create a bitmap 8 bits
	 */
Int16 BMP8create(pDISPLAY Pic,pInt8 Ptr,Int16 SzX,Int16 SzY,pRGB Pal, Int16 PalNb);
	 /*
	 ** Read a .BMP file
	 */
pInt8 BMP8readBMP(pInt16 pSzX, pInt16 pSzY, pRGB Palette, pInt8 File);
	 /*
	 ** Write a .BMP file
	 */
Int16 BMP8writeBMP(pInt8 Ptr,Int16 SzX,Int16 SzY, pRGB Palette, pInt8 File);
