/****************************************************\
*
*
* WAD OBJECT INTERNAL IDENTIFICATION API
*
*
\****************************************************/

	 /*
	 ** Find if an entry of same name and type exist,
	 ** otherwise instert entry at the right place in WAD.
	 ** Add any relevant sprite/patch/flat markers.
	 ** Entry = proposed position of entry
	 ** Id = identification of entry
	 ** Name = entry name
	 ** This allows safe entry insertion.
	 ** return entry reference, or <0 if error
	 */
Int16 WADwhereEntryI(pWADDEF This,Int16 Entry, IDENT Id, pInt8 Name);
#if (DLLFORDOOM)
	 /*
	 ** identify entry
	 **  Id = default identification
	 **  Name = entry name
	 ** return Id
	 */
IDENT WADidentEntry(pWADDEF This, IDENT Id, pInt8 Name);
	 /*
	 ** fast identification of all directory entries
	 ** without reading WAD file.
	 */
Int16 WADidentDirFastI(pWADDEF This);
	 /*
	 ** secure indentification of entries.
	 ** reads the WAD file, and is slow.
	 */
Int16 WADidentDirSlowI(pWADDEF This);
	 /*
	 ** default to lump
	 */
Int16 WADidentDirDefaultI(pWADDEF This);
#endif /*DLLFORDOOM*/

#if DLLFORQUAK
	 /*
	 ** returns identity of a Quake entry
	 ** from apparent Identification and name
	 */
IDENT WADidentQuake(pInt8 Name,Int8 Id);
	 /*
	 ** returns identity of a Pack entry
	 ** from apparent Identification and name
	 */
IDENT WADidentPack(pInt8 Name,pInt8 FullName);
#endif /*DLLFORQUAK*/

#if (DLLFORDUKE)
	 /*
	 ** Identify a Duke entry, by extension in FullName
	 ** returns Name[8] and identification
	 */
IDENT WADidentDuke(pInt8 Name,pInt8 FullName);
#endif
	 /*
	 ** list wasted space in WAD
	 */
Int16 WADIlistWaste(pWADDEF This, pWINDOZE Wnd);







