/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 'I'


#include "lbwintex.h"
#include "lbcommon.h"
#include <stdlib.h> /*qsort*/

#include "lbwad.h"
#include "lbdispl.h"

#include "lbwaddef.h"
#include "lbdoom.h"
#include "lbwaddir.h"
#include "lbwadir.h"
#include "lbwadid.h"
#include <ctype.h>






/****************************************************\
*
*
*  Insert entries in WAD, safe way
*
*
\****************************************************/


/*
** Find markers, if not, insert them
*/
#if (DLLFORDOOM)
static Int16 WADfindInsMarkerI(pWADDEF This, pInt16 pM_sta, IDENT Id)
{
  Int16 m_sta,m_end;
  IDENT IdS, IdE;
  pInt8 MarkS,MarkE,MarkEE;
  if(This==NULL) return ERR_BUG;
  /**/
  switch(Id&EMASK)
  {
	 case ESPRITE:
		IdS= ES_STA; MarkS = "SS_START";
		IdE= ES_END; MarkE = "SS_END";   MarkEE=MarkE;
		break;
	 case EPATCH:
		IdS= EP_STA; MarkS = "PP_START";
		IdE= EP_END; MarkE = "PP_END";   MarkEE=MarkE;
		break;
	 case EFLAT:
		IdS= EF_STA; MarkS = "FF_START";
		IdE= EF_END; MarkE = "FF_END";   MarkEE=&MarkE[1];
		break;
	 default: return ERRfault(ERR_BUG);
  }
  /*
  ** Find start marker
  */
  m_sta=WADDfindEntryI(This,0,&MarkS[1],-1);  /*X_START*/
  if(m_sta<0)
  { m_sta=WADDfindEntryI(This,0,MarkS,-1); }  /*XX_START*/
  if(m_sta<0)
  { m_sta=-1; }
  /*
  ** Find end marker
  */
  m_end=WADDfindEntryI(This,m_sta+1,&MarkE[1],-1);  /*X_END*/
  if(m_end<0)
  { m_end=WADDfindEntryI(This,m_sta+1,MarkE,-1); }  /*XX_END*/
  if(m_end<0)
  { m_end=-1; }
  /*
  ** Insert start/end markers if not present in WAD
  */
  if((m_end<0))
  {
	 if(m_sta<0)
	 { m_sta=WADinsertEntryI(This,-1,IdS,MarkS,NULL,0);} /*XX_START*/
	 m_end=WADinsertEntryI(This,-1,IdE, MarkEE,NULL,0);  /*XX_END or S_END*/
  }
  *pM_sta=m_sta;
  return m_end;
}
/*
** Find where a level should be inserted
*/
static Int16 WADwhereLevelI(pWADDEF This,Int16 Entry, IDENT Id, pInt8 Name);
#endif /*DLLFORDOOM*/
/*
** Find where an entry should be inserted,
** according to type, and insert it, at Entry if possible
** for level entries, provide level name, else NULL
** returns entry position
*/
Int16 WADwhereEntryI(pWADDEF This,Int16 Entry, IDENT Id, pInt8 Name)
{
  Int16 e;
#if (DLLFORDOOM)
  Int16 m_sta,m_end;
  pWADDIR TLst;
#endif
  if((This==NULL)||(This->Lst==NULL))
  { return ERRfault(ERR_BUG); }
  /*
  ** level treatment is a bit special because levels
  ** are a coherent set of lumps.
  */
#if (DLLFORDOOM)
  if((Id&EMASK)==ELEVEL)
  {
	 return WADwhereLevelI(This, Entry, Id, Name);
  }
#endif
  /*
  ** if no name, check only the ID
  */
  if((Name==NULL)||(Name[0]=='\0'))
  {
    if(Id==WADDgetEntryI(This, NULL, NULL, Entry))
    { return Entry; }
    else
    { return BAD_ENTRY; }
  }
  /*
  ** Check if an entry with same name, and same ID exists.
  ** if yes, return it's position.
  */
  e=WADDfindEntryI(This,0,Name,Id);
  if(e>=0) return e;
  /*
  ** Entry doesn't exist, insert it.
  ** Insert markers, if needed.
  */
#if (DLLFORDOOM)
  switch((Id&EMASK))
  {
	 case EPATCH:  /*position of P_END*/
	 case ESPRITE: /*position of S_END*/
	 case EFLAT:   /*position of F_END*/
		m_end=WADfindInsMarkerI(This,&m_sta,Id);
		if((Entry<=m_sta)||(Entry>m_end)) Entry=m_end;
		break;
	 case ETEXTUR: /*end of WAD*/
		Entry=-1; break;
	 default:      /*anything*/
		if((Entry>0)&&(Entry<This->LstNb)) /*non zero*/
		{ /*
		  ** If entry at this position is special, move entry at the end
		  */
		  TLst=&(This->Lst[Entry]);
		  switch(TLst->Id&EMASK)
		  { case ESPRITE: case EPATCH:
			 case EFLAT:   case ELEVEL:
			 case E_STA:   case E_END:
				Entry=-1; break;
		  }
		}
  }
#endif /*DLLFORDOOM*/
  /*
  ** Insert the entry, at the given position
  */
  return WADinsertEntryI(This, Entry, Id, Name, NULL, 0);
}
/*
** Find where a level should be inserted
** Check = FALSE if disable position checking
*/
#if (DLLFORDOOM)
static Int16 WADwhereLevelI(pWADDEF This,Int16 Entry, IDENT Id, pInt8 Name)
{ static Int16 e;
  static pWADDIR TLst;
  /*check if entry to be inserted at the end*/
  if(Entry>=This->LstNb) Entry=-1;
  /*
  ** if it's a level header
  */
  if(Id==ELVLHDR)
  { /*
	 ** see if it exists, only if not end of WAD
	 */
	 if(Entry>=0)
	 {
		e=WADDfindEntryI(This,0,Name,Id);
		if(e>=0) return e;
		/*
		** else introduce level header
		*/
		TLst=&(This->Lst[Entry]);
		switch(TLst->Id&EMASK)
		{
		  case ESPRITE: case EPATCH:
		  case EFLAT:   case ELEVEL:
		  case E_STA:   case E_END:
			 Entry=-1; break;
		}
	 }
	 return WADinsertEntryI(This, Entry, Id, Name, NULL, 0);
  }
  /*
  ** Level part
  */
  /*
  ** if request to insert at the end of directory,
  ** then introduce that entry. It may be isolated...
  */
  if(Entry<0)
  {
	 return WADinsertEntryI(This, -1, Id, Name, NULL, 0);
  }
  /*
  ** if attempt to replace a similar level part, then
  ** agree to replace level part.
  */
  TLst=&(This->Lst[Entry]);
  if(Id==TLst->Id)
  {
	 return Entry;
  }
  /*
  ** if attempt to introduce over a level header, find
  ** the first such entry after level header. if no such
  ** entry, insert at the end of entries
  */
  if(TLst->Id==ELVLHDR)
  {
	 e=Entry+1;
	 for(TLst=&(This->Lst[e]); e<This->LstNb; e++,TLst+=1)
	 { /* another Level header marks the end of level*/
		if(TLst->Id==ELVLHDR) break;
		/* a non-level part marks the end of level*/
		if((TLst->Id & EMASK)!=ELEVEL) break;
		/*
		** a similar level part, in same level, shall be
		** replaced. no need to insert an entry.
		*/
		if(TLst->Id==Id) return e;
	 }
	 /*
	 ** insert entry at the end of level
	 */
	 return WADinsertEntryI(This, e, Id, Name, NULL, 0);
  }

  /*
  ** else, replacement not allowed because level part
  ** shall not remain isolated.
  */
  return -1;
}
#endif /*DLLFORDOOM*/

/****************************************************\
*
*
*  Internal WAD IDENT API
*
*
\****************************************************/

#if (DLLFORDOOM)
  /*check name of entries. */
  /*called by a MACRO, never directly*/
static Int16 IDNcheckNameI(pInt8 Name,pInt8 Model);
  /*identify individual names*/
static IDENT IDNidentNameI(pInt8 Name, Int16 Game);

/****************************************************\
*
*
* Entry identification by name (hard way)
*
*
\****************************************************/

/*
** Identify entries
** @ = number
** ? = letter
** * = anything, including end of word
*/
static Int16 IDNcheckNameI(pInt8 Name,pInt8 Model)
{ Int16 i; Int8 n,m;
  for(i=1;i<NORMALISELEN;i++) /*start at 1, since the first letter is graranteed*/
  { n=Name[i];
	 m=Model[i];
	 if((n=='\0')&&(m=='\0'))break;/*end of sring*/
	 if(m=='@')               /*must be number*/
	 { if(!isdigit(n)) return 0;
		continue;
	 }
	 if(m=='*') { break; }    /*anything*/
	 if(m=='?') { continue; } /*any Int8*/
	 if(m!=n)   { return 0; } /*must be equal*/
  }
  return 1;
}
#define IDCHK(a,b)   if(IDNcheckNameI(Name,a)) return b
/*
** Should defintely use a hash table, but this is safer
*/
static IDENT IDNidentNameI(pInt8 Name, Int16 Game)
{ switch(Name[0])
  {
  case 'A':
	 IDCHK("AMMNUM@",  EGRAPHIC);
	if(Game & (GAM_HEXN|GAM_HTIC))
	{IDCHK("ACS@@",    ELMPACS);  /*level-related lump of H2*/
	 IDCHK("ADVISOR",  EGRAPHIC);
	 IDCHK("ANIMDEFS", ELMPTXT);  /*anims defs of H2*/
	 IDCHK("AUTOPAGE", ELUMP);    /*sound */
	 IDCHK("AMB@*",    ESNDWAV);  /*sound */
	}
    break;
  case 'B':
	 IDCHK("BLOCKMAP", EBLOCKMP);
	if(Game & (GAM_HEXN|GAM_HTIC))
	{IDCHK("BORD?*",   EGRAPHIC);
	 IDCHK("BEHAVIOR",EBEHAVE);
	}
	if(Game & GAM_DOOM)
	{IDCHK("BRDR_?*",  EGRAPHIC);
	 IDCHK("BOSSBACK", EGRAPHIC); /*DOOM2 boss back*/
	}
    break;
  case 'C':
	 IDCHK("COLORMAP", ELMPMAP);
	if(Game & GAM_DOOM)
	{IDCHK("CREDIT",   EGRAPHIC);  /*DOOM/HT credits*/
	 IDCHK("CWILV@@",  EGRAPHIC); /*end level stuff*/
	}
   else
	{ IDCHK("CREDIT",   ELMPPIC);  /*DOOM/HT credits*/
   }
   if(Game & GAM_STRF)
   {IDCHK("COPYRITE",  ELMPTXT); /*screen*/
    IDCHK("C1TEXT",  ELMPTXT);
   }
	if(Game & GAM_HEXN)
	{IDCHK("CLUS@MSG",  ELMPTXT);
	}
    break;
  case 'D':
	 IDCHK("DEMO@",    ELMPDMO);  /*Demo*/
	 IDCHK("DMXGUS",   ELMPTXT);
	if(Game & GAM_DOOM)
	{IDCHK("DMXGUSC",  ELMPTXT);
   }
   if(Game & (GAM_DOOM|GAM_STRF))
   {IDCHK("DP?*",     ESNDPC);
	 IDCHK("DS?*",     ESNDWAV);
    IDCHK("D_?*",     EMUSIC);
	}
    break;
  case 'E':
	 IDCHK("E@M@",     ELVLHDR);
	if(Game & GAM_DOOM)
	{IDCHK("END@",     EGRAPHIC);
	 IDCHK("ENDOOM",   ELMPSCR); /*screen*/
	 IDCHK("ENDPIC",   EGRAPHIC);
	}
	if(Game & (GAM_HEXN|GAM_HTIC))
	{IDCHK("E2END",    EGRAPHSP);
	 IDCHK("E2PAL",    ELMPPAL);
	 IDCHK("ENDTEXT",  ELMPSCR); /*screen*/
	}
   if(Game & GAM_STRF)
   {IDCHK("ENDSTRF",  ELMPSCR); /*screen*/
   }
    break;
  case 'F':
	 IDCHK("F@_END",   EVOID);
	 IDCHK("F@_START", EVOID);
	 IDCHK("FF_END",   EF_END);
	 IDCHK("FF_START", EF_STA);
	 IDCHK("F_END",    EF_END);
	 IDCHK("F_START",  EF_STA);
	if(Game & GAM_HTIC)
	{ IDCHK("FINAL@",   EGRAPHIC);
	}
	if(Game & GAM_HEXN)
	{IDCHK("FINALE@",  ELMPPIC);
	}
	if(Game & (GAM_HEXN|GAM_HTIC))
	{IDCHK("FACE?@",   EGRAPHIC);
	 IDCHK("FOGMAP",   ELMPMAP);
	 IDCHK("FONTA_S",  EVOID);
	 IDCHK("FONTA_E",  EVOID);
	 IDCHK("FONTAY_S", EVOID);
	 IDCHK("FONTAY_E", EVOID);
	 IDCHK("FONTB_S",  EVOID);
	 IDCHK("FONTB_E",  EVOID);
	 IDCHK("FONT?*",   EGRAPHIC); /*heretic fonts*/
	}
    break;
  case 'G':
	 IDCHK("GENMIDI",  ELUMP);
	if(Game & (GAM_HEXN|GAM_HTIC))
	{IDCHK("GOD@",     EGRAPHIC);
	}
    break;
  case 'H':
	if(Game & GAM_DOOM)
	{IDCHK("HELP",     EGRAPHIC);
	 IDCHK("HELP@",    EGRAPHIC);
	}
	if(Game & (GAM_HEXN|GAM_HTIC))
	{IDCHK("HELP",     ELMPPIC);
	 IDCHK("HELP@",    ELMPPIC);
	}
    break;
  case 'I':
	if(Game & (GAM_HEXN|GAM_HTIC))
	{
	 IDCHK("INTERPIC", ELMPPIC);
	 IDCHK("IN@",      EGRAPHIC);
	 IDCHK("INAM???",  EGRAPHIC);
	 IDCHK("INVGEM?@", EGRAPHIC);
	 IDCHK("INVBAR",   EGRAPHIC);
	}
	else
	{
	 IDCHK("INTERPIC", EGRAPHIC);
	}
    break;
  case 'L':
	 IDCHK("LINEDEFS", ELINEDEF);
	if(Game & (GAM_HEXN|GAM_HTIC))
	{IDCHK("LOADING",  ELMPSCR); /*screen*/
	 IDCHK("LIFE?*",   EGRAPHIC);
	}
   if(Game & GAM_STRF)
   {IDCHK("LOG@*",  ELMPTXT);
   }
    break;
  case 'M':
	 IDCHK("MAP@@",    ELVLHDR);
	 IDCHK("M_?*",     EGRAPHIC);  /*menu item*/
	if(Game & (GAM_HEXN|GAM_HTIC))
	{IDCHK("MAPE@",    EGRAPHIC);  /*H2*/
	 IDCHK("MAPINFO",  ELMPTXT);  /*map info of H2*/
	 IDCHK("MUS_?*",   EMUSIC);
	}
    break;
  case 'N':
	 IDCHK("NODES",    ENODE );
    break;
  case 'P':
	 IDCHK("PLAYPAL",  ELMPPAL);
	 IDCHK("PNAMES",   EPNAME);
	 IDCHK("P@_END",   EVOID);
	 IDCHK("P@_START", EVOID);
	 IDCHK("PP_END",   EP_END);
	 IDCHK("PP_START", EP_STA);
	 IDCHK("P_END",    EP_END);
	 IDCHK("P_START",  EP_STA);
	if(Game & (GAM_DOOM))
	{IDCHK("PFUB@",   EGRAPHIC);
	}
	if(Game & (GAM_HEXN|GAM_HTIC))
	{IDCHK("PAUSED",   EGRAPHIC);
	}
    break;
  case 'R':
	 IDCHK("REJECT",   EREJECT);
    break;
  case 'S':
	 IDCHK("S@_END",   EVOID);
	 IDCHK("S@_START", EVOID);
	 IDCHK("SECTORS",  ESECTOR);
	 IDCHK("SEGS",     ESEGS );
	 IDCHK("SIDEDEFS", ESIDEDEF);
	 IDCHK("SSECTORS", ESSECTOR);
	 IDCHK("SS_END",   ES_END);
	 IDCHK("SS_START", ES_STA);
	 IDCHK("S_END",    ES_END);
	 IDCHK("S_START",  ES_STA);
	if(Game & GAM_HEXN)
	{IDCHK("SNDINFO",  ELMPTXT);  /*anims defs of H2*/
	 IDCHK("SNDSEQ",   ELMPTXT);  /*sound seq of H2*/
	 IDCHK("SNDCURVE", ELUMP);    /*sound */
	 IDCHK("SPINBK@*", EGRAPHIC); /*H2*/
	 IDCHK("SPFLY@*",  EGRAPHIC); /*H2*/
	 IDCHK("SMALLIN@", EGRAPHIC);
	 IDCHK("STATBAR",  EGRAPHIC);
	 IDCHK("STARTUP",  ELUMP);
	 IDCHK("SCRIPTS",  ESCRIPT);
	}
	if(Game & GAM_DOOM)
	{IDCHK("ST?*",     EGRAPHIC); /*status bar*/
	}
   if(Game & GAM_STRF)
   {IDCHK("SERIAL",  ELMPTXT);
    IDCHK("SCRIPT@@",ELUMP);
   }
    break;
  case 'T':
	 IDCHK("TEXTURE1", ETEXU1);
	 IDCHK("TEXTURE2", ETEXU2);
	 IDCHK("THINGS",   ETHING);
	if(Game & GAM_DOOM)
	{IDCHK("TITLEPIC", EGRAPHIC); /*title*/
	}
	if(Game & (GAM_HEXN|GAM_HTIC))
	{IDCHK("TINTTAB",  ELUMP);
	 IDCHK("TITLE",    ELMPPIC); /*Heretic title*/
	 IDCHK("TITLEPIC", ELMPPIC); /*Hexen title*/
	}
   if(Game & GAM_STRF)
   {IDCHK("T1TEXT",  ELMPTXT);
   }
    break;
  case 'U':
	if(Game & (GAM_HEXN|GAM_HTIC))
	{IDCHK("USEARTI?", EGRAPHIC);
	}
    break;
  case 'V':
	 IDCHK("VERTEXES", EVERTEX);
	if(Game & GAM_DOOM)
	{IDCHK("VICTORY2",   EGRAPHIC);
	}
   if(Game & GAM_STRF)
   {IDCHK("VOC?*",     ESNDWAV);
   }
    break;
  case 'W':
	if(Game & GAM_DOOM)
	{IDCHK("WI?*",     EGRAPHIC); /*end level stuff*/
	}
	if(Game & GAM_HEXN)
	{IDCHK("WIN@MSG",  ELMPTXT);
	}
    break;
  case 'X':
	if(Game & (GAM_HEXN|GAM_HTIC))
	{IDCHK("XXTIC",    ELUMP);
	}
	 break;
  default:
	 break;
  }
  if(Game & (GAM_HEXN|GAM_HTIC))
  {IDCHK("?KEYICON",  EGRAPHIC);
	IDCHK("????PAI",    ESNDWAV);  /*sound */
	IDCHK("????ATK",    ESNDWAV);  /*sound */
	IDCHK("????DTH",    ESNDWAV);  /*sound */
	IDCHK("???PAI",    ESNDWAV);  /*sound */
	IDCHK("???ACT",    ESNDWAV);  /*sound */
	IDCHK("???DTH",    ESNDWAV);  /*sound */
	IDCHK("???ATK",    ESNDWAV);  /*sound */
	IDCHK("???AT1",    ESNDWAV);  /*sound */
	IDCHK("???AT2",    ESNDWAV);  /*sound */
	IDCHK("???SIT",    ESNDWAV);  /*sound */
	IDCHK("???SHT",    ESNDWAV);  /*sound */
	IDCHK("???POW",    ESNDWAV);  /*sound */
	IDCHK("???HIT",    ESNDWAV);  /*sound */
  }
  return EWHAT;
}
#undef IDCHK(a,b)

/****************************************************\
*
*
*  Entry identification
*
*
\****************************************************/

/*
** identify entry by name
*/
IDENT WADidentEntry(pWADDEF This, IDENT Id, pInt8 Name)
{
  IDENT id;
  /*check valid parameters*/
  if((This->Lst==NULL)||(This->LstNb<0))
  { return ERRfault(ERR_BUG);}
  if((Name==NULL)||(Name[0]=='\0'))
  { return ERRfault(BAD_PARM);}
  /*
  ** check game is acceptable
  */
  if(!(This->Game & (GAM_DOOM|GAM_HTIC|GAM_HEXN)))
	return Id; /*no specific identification*/
  /*check id*/
  switch(Id&EMASK)
  {
	 case ELEVEL:   /*check level name is valid*/
	 case ELUMP:    /*identify a lump*/
	 case ETEXTUR:  /*check texture name is valid*/
		id= IDNidentNameI(Name,This->Game);
		if(id<0) id=Id; /*no precise identification*/
		break;
	 case ESOUND:   case EMUSIC:
	 case EGRAPHIC: case ESPRITE:
	 case EFLAT:    case EPATCH:
	 default:
		id = Id;
		break;
  }
  return id;
}

/*
** Identify directory entries, only by name
*/
Int16 WADidentDirFastI(pWADDEF This)
{ static IDENT id;
  static Int16 e;
  static pWADDIR TLst;
  static Int16 f_sta,p_sta,s_sta;
  static Int16 f_end,p_end,s_end;
  /*check valid parameters*/
  if((This->Lst==NULL)||(This->LstNb<0))
  { return ERRfault(BAD_PARM);}
  /*
  ** check game is acceptable
  */
  if(!(This->Game & (GAM_DOOM|GAM_HTIC|GAM_HEXN|GAM_STRF)))
  { return 0; /*no identification*/
  }
  /*Implicit: all the entry names have been normalised*/
  /*init*/
  f_sta=p_sta=s_sta=-1;
  f_end=p_end=s_end=-1;
  /*
  ** Basic identification, from name
  */
  for(e=0,TLst=This->Lst; e<This->LstNb; e++,TLst+=1)
  { /*Tlst = This->Lst[e]*/
	 id= IDNidentNameI(TLst->Name,This->Game);
	 switch(id)
	 { case EF_STA: f_sta = e; break;
		case EF_END: f_end = e; break;
		case EP_STA: p_sta = e; break;
		case EP_END: p_end = e; break;
		case ES_STA: s_sta = e; break;
		case ES_END: s_end = e; break;
		case ELMPPIC:  /*picture lump must be 64000*/
		  if(TLst->Size!=64000L) {id=EGRAPHIC;}
	 }
	 switch(id&EMASK)
	 { case ESOUND:   case ETEXTUR:
		case EGRAPHIC: case ESPRITE:
		case EFLAT:    case EPATCH:
		  if(TLst->Size<0x8){id=EWHAT;}
		  break;
	 }
	 TLst->Id=id;
  }
  /*
  ** find flats  F_START F_END
  */
  for(e=f_end-1; e>=0; e--)
  {
	 TLst=&(This->Lst[e]);
	 if((TLst->Id & EMASK)==EVOID) continue;
	 if(f_sta>=0) /*F_START is prioritary*/
	 {
		if(e<=f_sta) break;
	 }
	 else  /*if F_START doesn't exist, break ASAP*/
	 {
		if((TLst->Id & EMASK)!=EWHAT) break;
	 }
	 switch(TLst->Size)
	 { case 0x1000: TLst->Id=EFLAT;break;
		case 0x1040: TLst->Id=EFLATH1;break;
		case 0x2000: TLst->Id=EFLATH2;break;
	 }
  }
  /*
  ** find sprites S_START S_END
  */
  for(e=s_end-1; e>=0; e--)
  {
	 TLst=&(This->Lst[e]);
	 if((TLst->Id & EMASK)==EVOID) continue;
	 if(s_sta>=0) /*S_START is prioritary*/
	 {
		if(e<=s_sta) break;
	 }
	 else  /*if S_START doesn't exist, break ASAP*/
	 {
		if((TLst->Id & EMASK)!=EWHAT) break;
	 }
	 /*is it big enough to be a sprite?*/
	 if(TLst->Size>0x8)
	 {
		TLst->Id=ESPRITE;
	 }
  }
  /*
  ** find patches P_START P_END
  */
  for(e=p_end-1; e>=0; e--)
  {
	 TLst=&(This->Lst[e]);
	 if((TLst->Id & EMASK)==EVOID) continue;
	 if(p_sta>=0) /*P_START is prioritary*/
	 {
		if(e<=p_sta) break;
	 }
	 else   /*if P_START doesn't exist, break ASAP*/
	 {
		if((TLst->Id & EMASK)!=EWHAT) break;
	 }
	 /*can it be patch?*/
	 if(TLst->Size>0x8)
	 {
		TLst->Id =EPATCH;
	 }
  }
  /*find patches from PNAMES*/
  return 1;
}
/*
** Slow identify, by reading names
*/
Int16 WADidentDirSlowI(pWADDEF This)
{ IDENT id=EWHAT;
  Int16 e;
  Int32 res;
  static pWADDIR TLst;
  static union   /*size 8*/
  { struct DMSNDHEAD snd;
	 struct DMPICINFO pic;
	 struct DMMUSINFO mus;
  }u;
  if(This==NULL){return BAD_PARM;}
  /*
  ** Detect if there are unidentified entries
  */
  id = 1;
  for(e=0, TLst=This->Lst; e<This->LstNb; e++,TLst+=1)
  { if(TLst->Id==EWHAT) id=0;
  }
  if(id==1) return 1;
  /*
  ** Try to identify unidentified entries
  */
  res=FILEopen(This->File,FREAD);
  if(res<0) {return (Int16)res;}
  for(e=0, TLst=This->Lst; e<This->LstNb; e++,TLst+=1)
  { /*TLst = This->Lst[e]*/
	 if(TLst->Id!=EWHAT)  continue;
	 if(TLst->Size<0x8)  continue;
	 if(TLst->Start<0) continue;
	 id = EWHAT;
	 /*read data*/
	 res=FILEread((pInt8)&u,TLst->Start,sizeof(u));
	 if(res<0) continue;
	 /*check sound*/
	 if((u.snd.Ident==3)&&(sizeof(struct DMSNDHEAD)+u.snd.Size==TLst->Size))
	 { id = ESNDWAV;}
	 if((u.snd.Ident==0)&&(sizeof(struct DMSNDHEAD)+u.snd.Size==TLst->Size))
	 { id = ESNDPC;}
	 if(u.mus.Ident== 0x1A53554DL) /*MUS,0x1A*/
	 { id = EMUSIC;}
	 /*check pic*/
	 else if((u.pic.SzX>0)&&(u.pic.SzX>0)&&(u.pic.SzX<512)&&(u.pic.SzY<256))
	 { id = EGRAPHIC;}
	 else switch( TLst->Size)
	 { case 0x1000: id=EFLAT;break;
		case 0x1040: id=EFLATH1;break;
		case 0x2000: id=EFLATH2;break;
	 }
	 TLst->Id=id;
  }
  FILEclose();
  return 1;
}
/*
** All unknown entries are lumps
*/
Int16 WADidentDirDefaultI(pWADDEF This)
{ Int16 e;
  static pWADDIR TLst;
  if(This==NULL){return BAD_PARM;}
  for(e=0, TLst=This->Lst; e<This->LstNb; e++,TLst+=1)
  {
	 if(TLst->Id==EWHAT) TLst->Id=ELUMP;
  }
  return 1;
}
#endif /*DLLFORDOOM*/

#if (DLLFORQUAK)
/*
** returns identity of a Quake entry
** for apparent Id and name
*/
IDENT WADidentQuake(pInt8 Name,Int8 Id)
{ (void)Name;
  switch(Id)
  { case 0x40: /*lump*/
		return EQKLMP;
	 case 0x42:
		return EQKPIC;
	 case 0x44:
		return EQKTEX;
	 case 0x45:
		return EQKCON;
  }
  return EQKLMP;
}
/*
** Identify a Quake entry, by extension in FullName[0x38]
** returns Name[8] and identification
*/
IDENT WADidentPack(pInt8 Name,pInt8 FullName)
{ Int16 n,deb,len;
  pInt8 Ext;
  /*
  ** Look for last '\'
  */
  for(deb=0,n=0; n<0x38; n++)
  { if( FullName[n]=='\0')
	 {break;}
	 if( FullName[n]=='/')
	 { deb = n+1; }
  }
  /*
  ** File name. deb= start of name
  */
  for(n=0;deb+n<0x38;n++)
  { if( FullName[deb+n] <= ' ')
	 { break; }
	 if( FullName[deb+n] == '.')
	 { break; }
	 if(n<NORMALISELEN)
	 { Name[n]=FullName[deb+n]; }
  }
  if(n<NORMALISELEN) Name[n]='\0';
  /*
  ** File Extension
  */
  deb+=n+1; /* +1 for the '.' */
  Ext = &FullName[deb];
  len = min(3, 0x38-deb);
  if(Strncmpi(Ext,"wav",len)>0)
	 return EPK_WAV;
  if(Strncmpi(Ext,"bsp",len)>0)
	 return EPK_BSP;
  if(Strncmpi(Ext,"mdl",len)>0)
	 return EPK_MDL;
  if(Strncmpi(Ext,"spr",len)>0)
	 return EPK_SPR;
  if(Strncmpi(Ext,"lmp",len)>0)
  {
	 if(Strncmpi(Name,"PALETTE",8)>0)
		return EPK_PAL;
	 if(Strncmpi(Name,"COLORMAP",8)>0)
		return EPK_COL;
	 return EPK_PIC;
  }
  if(Strncmpi(Ext,"rc",len)>0)
	 return EPK_RC;
  if(Strncmpi(Ext,"cfg",len)>0)
	 return EPK_CFG;
  if(Strncmpi(Ext,"dat",len)>0)
	 return EPK_DAT;
  if(Strncmpi(Ext,"wad",len)>0)
	 return EPK_WAD;
  if(Strncmpi(Ext,"bin",len)>0)
	 return EPK_BIN;
  return EPACK;
}
#endif

#if (DLLFORDUKE)
/*
** Identify a Duke entry, by extension in FullName
** returns Name[8] and identification
*/
IDENT WADidentDuke(pInt8 Name,pInt8 FullName)
{ Int16 n;
  /*
  ** Copy name
  */
  for(n=0;n<12;n++)
  { if( FullName[n] <= ' ')
	 { break; }
	 if( FullName[n] == '.')
	 { n++; break; }
	 if(n<NORMALISELEN)
	 { Name[n]=FullName[n];}
  }
  if(n<NORMALISELEN) Name[n]='\0';
  if(n<12-2) /* 3 character type*/
  { switch(FullName[n])
	 { case 'A': return EDK_ART;
		case 'B': return EDK_BIN;
		case 'C': return EDK_CON;
		case 'D': return EDK_DAT;
		case 'M':
		  switch(FullName[n+1])
		  { case 'A': return EDK_MAP;
			 case 'I': return EDK_MID;
		  }
		  break;
		case 'T': return EDK_TMB;
		case 'V': return EDK_VOC;
	 }
  }
  return EVOID;
}
#endif
/****************************************************\
*
*
*  Say if entry name is ok
*
*
\****************************************************/
/*
** Give a warning to the user
** Name = name of the entry concerned, or NULL
** Msg = message for the user
** return 1 if OK, 0 if Cancel
*/


Int16 WADwarn(pInt8 Text, Int16 TextSz, pInt8 Msg)
{ Int16 n;
  Bool  pad;
  Int8 Buff[64+2];
  /**/
  Buff[0]='\0';
  if(Msg!=NULL)
  { Strcpy(Buff,"Entry ");
	 Strcat(Buff,Msg);
	 Strcat(Buff,".");
  }
  /*
  ** Pad with white space
  */
  for(pad=FALSE,n=0; n<64; n++)
  { if(Buff[n]<' ')
	 { pad=TRUE;}
	 if(pad==TRUE)
	 { Buff[n]=' ';}
  }
  if(Text!=NULL)
  { Strncpy(Text,Buff, ((TextSz<64)? TextSz : 64));}
  return 64;
}
/*
** Check the name of an entry, warn user if needed.
** Name = Entry name
** Type = proposed entry type (general type)
** Text   = text buffer, for message
** Textsz = buffer size
**  return <0 if error or refused, entry Id if accepted
*/
Int16 EXPORT WADentryCheckId(Int16 Self, Int16 Type, pInt8 Name, pInt8 Text, Int16 TextSz)
{
  Int16 Entry;
  IDENT id,type=(IDENT)Type;
  pWADDEF That;
  pInt8 Msg=NULL;
  /*
  ** Get main Wad
  */
  That=WADgetThat(Self);
  if(That==NULL)
  { return BAD_PARM;}
  if(!(That->IwadSelf<0))
  {
	 That=WADgetThat(That->IwadSelf);
	 if(That==NULL)
	 { return BAD_PARM;}
  }
  if((That->Lst==NULL)||(That->LstNb<0))
  { return ERRfault(ERR_BUG);}
  /*
  ** Find entry in main WAD
  */
  Entry=WADDfindEntryI(That,0,Name,-1);
  id = -1;
  if(Entry>0)
  { /* Try to identify entry*/
	 id=WADDgetEntryI(That,NULL,NULL,Entry);
  }
  if(id>=0) /*entry identified, and exists*/
  {
	 if((id&EMASK)!=(type&EMASK))
	 { /*
		** Supposed id does not correspond to real id
		*/
		if(type!=ELUMP)/*lumps can be anything*/
		{ Msg="has a different type in IWAD";}
	 }
	 else
	 { /*
		** Make sure only replaceable entries are replaced
		*/
		switch(id&EMASK)
		{ /* No warning for level parts */
		  case ELEVEL:
			 if(!(id==ELVLHDR)) break;
			 /*no break;*/
		  /* Warning, for normal entries */
		  case EMUSIC:  case ESOUND: case ELUMP:
		  case ETEXTUR: case EGRAPHIC: case ESPRITE:
		  case EPATCH:  case EFLAT:
			 Msg="replaces an entry in IWAD";
			 break;
		default:
		  Msg="name is invalid";
		  id=-1;
		}
	 }
  }
  else  /*entry not identified, not existing */
  {
	 switch(type&EMASK)
	 { case EPATCH: case EFLAT: /*any name is ok*/
		case ESPRITE: /*should check root sprite name*/
		  id=type; /*ok*/
		  break;
		case ESOUND:  case EMUSIC:
		  /*HEXEN sounds and musics can have various names*/
		  if(That->Game & GAM_HEXN)
		  { id=type; break;}
		  /*no break;*/
		case ELEVEL: case ELUMP:
		case ETEXTUR: case EGRAPHIC:
		  Msg="does not exist in IWAD and may be ignored";
		  id= -1;
		default:
		  Msg="name is invalid";
		  id=-1;
	 }
  }
  WADwarn(Text,TextSz,Msg);
  return id;
}

