/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 'H'

#include "lbwintex.h"
#include "lbcommon.h"
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "lbwad.h"
#include "lbdispl.h"
#include "lbtext.h"

#include "lbwaddef.h"

#include "lbwadhlp.h"



/****************************************************\
*
*
* Identification services for files and selections
*
*
\****************************************************/
/*
** Get Entry/Ident for ItemData
**  *pId = Entry identification
**  Code = Entry code = LstB.ItemData(n)
**  Returns Entry ref in PWAD.
*/
Int16 EXPORT HELPdecodeEntry(pInt16 pId, Int32 Code)
{
  if(pId!=NULL)
  { *pId = (Int16) ((Code>>16)&0xFFFFL);}
  return (Int16)(Code &0x7FFFL);
}

/*
** Get Index/Type for Index
*/
#define HELPIDXMAX (10) /*nb of entries in table*/
#define HELPIDXGAM (3) /*nb of games*/
static IDENT HelpTypIdx[]=
{
  -1,       -1,      -1,  /*all*/
  ELUMP,    EDK_CON, EPK_DAT, /*Lump*/
  EGRAPHIC, EDK_ART, EPK_SPR, /*Graphic*/
  ESPRITE,  EDK_ART, EPK_MDL, /*Sprites*/
  ESNDWAV,  EDK_VOC, EPK_WAV, /*Sound*/
  EMUSIC,   EDK_MID, EPK_CFG, /*Music*/
  ELEVEL,   EDK_MAP, EPK_BSP, /*Level*/
  ETEXTUR,  EDK_TMB, EPK_RC,  /*Texure*/
  EPATCH,   EDK_DAT, EPK_WAD, /*Patch*/
  EFLAT,    EDK_BIN, EPK_PIC  /*Flat*/
};
/*
** Get Index and type
**  Game = Current game
**  Id   = Type of entry, or -1
**  *pIndex = Index of the type selection button (0...9)
*/
Int16 EXPORT HELPgetIdxType( pInt16 pIndex,Int16 Game, Int16 Id)
{
  Int16 idx,offset;
  IDENT type;
  if(pIndex==NULL) { return -1;}
  offset = (Game&GAM_PACK)? 2 : ((Game&GAM_DUKE)? 1 : 0);
  idx=*pIndex;
  /*
  ** Return type corresponding to index
  */
  if((idx>=0)||(idx<HELPIDXMAX))
  { return HelpTypIdx[(idx*HELPIDXGAM)+offset]; }
  /*
  ** Look for index matching type
  */
  type=Id;
  for(idx=0; idx<HELPIDXMAX; idx++)
  { if((type&EMASK)== (HelpTypIdx[(idx*HELPIDXGAM)+offset]&EMASK))
	 { break;}
  }
  if(idx>=HELPIDXMAX) {idx = -1;}
  *pIndex=idx;
  return type;
}

/*
** Get Extension for type
** Ops=1: load
** Ops!=1 Save
*/
Int16 EXPORT HELPfileForType(Int16 Id, Int16 Ops)
{
  switch(Id)
  {
	 case ESNDPC:  return FILE_LMP;
	 case ELMPPIC: return FILE_BMP;
	 case ELMPSCR: return FILE_SCR;
	 case ELMPTXT: return FILE_TXT;
	 case EBEHAVE: return (Ops==1)? FILE_OBJ: FILE_ACS;
	 case ELVLHDR: return FILE_WAD;
  }
  switch(Id&EMASK)
  {
	 case EGRAPHIC:
	 case ESPRITE:
	 case EPATCH:
	 case EFLAT:
	 case EQKCON:                   /*WAD2 CONsole entry*/
	 case EQKPIC:  return FILE_BMP; /*WAD2 PICture entry*/
	 case ESOUND:  return FILE_WAV;
	 case EMUSIC:  return (Ops==1)? FILE_MUS: FILE_MID;
	 case ELEVEL: /*level lump*/
	 case ELUMP:   return FILE_LMP;
	 case EDK_CON: return FILE_CON; /*Duke CON*/
	 case EDK_TMB: return FILE_TMB; /*Duke TMB*/
	 case EDK_BIN: return FILE_BIN; /*Duke BIN*/
	 case EDK_DAT: return FILE_DAT; /*Duke DAT*/
	 case EDK_VOC: return FILE_WAV; /*Duke VOC*/
	 case EDK_MID: return FILE_MID; /*Duke MID*/
	 case EDK_ART: return FILE_ART; /*Duke ART*/
	 case EDK_MAP: return FILE_MAP; /*Duke MAP*/
#if (DLLFORQUAK)
	 case EPK_BSP: return FILE_BSP; /*Pack BSP map entry*/
	 case EPK_DAT: return FILE_DAT; /*Pack DATa entry*/
	 case EPK_WAV: return FILE_WAV; /*Pack WAV entry*/
	 case EPK_RC:  return FILE_RC;  /*Pack RC entry*/
	 case EPK_MDL: return FILE_MDL; /*Pack MODel entry*/
	 case EPK_SPR: return FILE_SPR; /*Pack SPRite entry*/
	 case EPK_WAD: return FILE_WAD; /*Pack WAD entry*/
	 case EPK_CFG: return FILE_CFG; /*Pack WAD entry*/
	 case EPK_BIN: return FILE_BIN; /*Pack WAD entry*/
#endif
  }
  return FILE_LMP;
}



/****************************************************\
*
*
* ENTRIES explicit indentification service
*
*
\****************************************************/

/*
** flags for games
*/
#define H_AL (0x7F)          /*ALL*/
#define H_D1 (0x1)           /*DOOM*/
#define H_D2 (0x2)           /*DOOM2*/
#define H_H1 (0x4)           /*HERETIC*/
#define H_HX (0x8)           /*HEXEN*/
#define H_S  (0x10)          /*STRIFE*/
#define H_QK (0x20)          /*QUAKE*/
#define H_D12 (H_D1+H_D2)
#define H_H1X (H_H1+H_HX)
/*
** Help storage structure
*/
struct Help
{
  Int8 Name[8];
  Int8 *Help;
  IDENT Id;
  Int16 Game;
};
typedef struct Help PTR *pHelp;
/*
** Help storage
*/
struct Help HELPgeneral[]=
{
/*{ "????????","", ,H_AL},*/
{ "        ",NULL,-1,H_AL}
};



#if (DLLFORDOOM)
struct Help HELPmisc[]=
{

{ "TEXTURE1","Texture list 1",		ETEXTUR,H_AL},
{ "TEXTURE2","Texture list 2",		ETEXTUR,H_D1|H_H1X|H_S},
{ "PNAMES  ","Wall patch list",		ETEXTUR,H_AL},

{ "E#M#    ","Level ignored",			ELVLHDR,H_D2|H_HX|H_S},
{ "MAP##   ","Level header",			ELVLHDR,H_D2|H_HX|H_S},

{ "E#M#    ","Level header",			ELVLHDR,H_D1|H_H1},
{ "MAP##   ","Level ignored",			ELVLHDR,H_D1|H_H1},

{ "MAP31   ","Secret level 1",		ELVLHDR,H_D2},
{ "MAP32   ","Secret level 2",		ELVLHDR,H_D2},
{ "MAP41   ","Secret level 1",		ELVLHDR,H_HX},
{ "MAP42   ","Secret level 2",		ELVLHDR,H_HX},
{ "E1M4    ","Deathmatch level",		ELVLHDR,H_H1},

{ "THINGS  ","List of Objects",		ETHING,H_AL},
{ "LINEDEFS","Wall lines",				ELINEDEF,H_AL},
{ "SIDEDEFS","Wall sides",				ESIDEDEF,H_AL},
{ "VERTEXES","Wall corners",			EVERTEX,H_AL},
{ "SEGS    ","Wall segments",			ESEGS,H_AL},
{ "SECTORS ","Sectors",					ESECTOR,H_AL},
{ "SSECTORS","Sub sector",				ESSECTOR,H_AL},
{ "NODES   ","2D BSP nodes",			ENODE,H_AL},
{ "BLOCKMAP","Collision map",			EBLOCKMP,H_AL},
{ "REJECT  ","Reject map",				EREJECT,H_AL},
{ "BEHAVIOR","Scripts",					EBEHAVE,H_HX},
{ "SCRIPTS ","Scripts source",	  	ESCRIPT,H_HX},

{ "PLAYPAL ","Color palette",			ELMPPAL,H_AL},
{ "COLORMAP","Mapping of colors",	ELMPMAP,H_AL},
{ "DEMO1   ","Game Demo 1",			ELMPDMO,H_AL},
{ "DEMO2   ","Game Demo 2",			ELMPDMO,H_AL},
{ "DEMO3   ","Game Demo 3",			ELMPDMO,H_AL},
{ "DMXGUSC ","GUS mapping",			ELMPTXT,H_D12},
{ "DMXGUS  ","GUS mapping",			ELMPTXT,H_H1X|H_D1|H_S},
{ "GENMIDI ","General MIDI config.",ELUMP,H_AL},

{ "ENDOOM  ","End Screen",				ELMPSCR,H_D12},

{ "ENDTEXT ","End Screen",				ELMPSCR,H_H1},
{ "LOADING ","Loading Screen",		ELMPSCR,H_H1},
{ "AUTOPAGE","Table",					ELUMP,H_H1},
{ "SNDCURVE","Sound mapping",			ELUMP,H_H1},
{ "TINTTAB ","Sound table",			ELUMP,H_H1},
{ "E2PAL   ","Palette for E2END",	ELMPPAL,H_H1},
{ "TITLE   ","Title pic",				ELMPPIC,H_H1X},
{ "HELP@   ","Help pic",				ELMPPIC,H_H1X},
{ "CREDIT  ","Credit pic",				ELMPPIC,H_H1X},
{ "E2END   ","End pic",					ELMPPIC,H_H1},
{ "FINAL?  ","Final pic",				ELMPPIC,H_H1X},

{ "ANIMDEFS","Animations",				ELMPTXT,H_HX},
{ "CLUS@MSG","Cluster Exited",		ELMPTXT,H_HX},
{ "FOGMAP  ","Color fading",			ELMPMAP,H_HX},
{ "MAPINFO ","Level Info",				ELMPTXT,H_HX},
{ "SNDINFO ","Sound Info",				ELMPTXT,H_HX},
{ "SNDSEQ  ","Sound Defs",				ELMPTXT,H_HX},
{ "STARTUP ","Data",		      		ELMPTXT,H_HX},
{ "TINTAB  ","Table",		   		ELUMP,H_HX},
{ "TRANTBL#","Table",		   		ELUMP,H_HX},
{ "XXTIC   ","Tic data",				ELUMP,H_HX},
{ "WIN@MSG","Completed Game",			ELMPTXT,H_HX},
{ "????????"," ",							EVOID,H_AL},
{ "????????","Ordinary wall patch",	EPATCH,H_AL},
{ "        ",NULL,-1,H_AL}
};
#endif /*DLLFORDOOM*/
/*
** Musics
*/
#if (DLLFORDOOM)
struct Help HELPmusic[]=
{
{ "D_RUNNIN","Music of map01",	EMUSIC,H_D2},
{ "D_STALKS","Music of map02",	EMUSIC,H_D2},
{ "D_COUNTD","Music of map03",	EMUSIC,H_D2},
{ "D_BETWEE","Music of map04",	EMUSIC,H_D2},
{ "D_DOOM  ","Music of map05",	EMUSIC,H_D2},
{ "D_THE_DA","Music of map06",	EMUSIC,H_D2},
{ "D_SHAWN ","Music of map07",	EMUSIC,H_D2},
{ "D_DDTBLU","Music of map08",	EMUSIC,H_D2},
{ "D_IN_CIT","Music of map09",	EMUSIC,H_D2},
{ "D_DEAD  ","Music of map10",	EMUSIC,H_D2},
{ "D_STLKS2","Music of map11",	EMUSIC,H_D2},
{ "D_THEDA2","Music of map12",	EMUSIC,H_D2},
{ "D_DOOM2 ","Music of map13",	EMUSIC,H_D2},
{ "D_DDTBL2","Music of map14",	EMUSIC,H_D2},
{ "D_RUNNI2","Music of map15",	EMUSIC,H_D2},
{ "D_DEAD2 ","Music of map16",	EMUSIC,H_D2},
{ "D_STLKS3","Music of map17",	EMUSIC,H_D2},
{ "D_ROMERO","Music of map18",	EMUSIC,H_D2},
{ "D_SHAWN2","Music of map19",	EMUSIC,H_D2},
{ "D_MESSAG","Music of map20",	EMUSIC,H_D2},
{ "D_COUNT2","Music of map21",	EMUSIC,H_D2},
{ "D_DDTBL3","Music of map22",	EMUSIC,H_D2},
{ "D_AMPIE ","Music of map23",	EMUSIC,H_D2},
{ "D_THEDA3","Music of map24",	EMUSIC,H_D2},
{ "D_ADRIAN","Music of map25",	EMUSIC,H_D2},
{ "D_MESSG2","Music of map26",	EMUSIC,H_D2},
{ "D_ROMER2","Music of map27",	EMUSIC,H_D2},
{ "D_TENSE ","Music of map28",	EMUSIC,H_D2},
{ "D_SHAWN3","Music of map29",	EMUSIC,H_D2},
{ "D_OPENIN","Music of map30",	EMUSIC,H_D2},
{ "D_EVIL  ","Music of secret1",	EMUSIC,H_D2},
{ "D_ULTIMA","Music of secret2",	EMUSIC,H_D2},
{ "D_READ_M","Text music",			EMUSIC,H_D2},
{ "D_DM2TTL","Title music",		EMUSIC,H_D2},
{ "D_DM2INT","Inter music",		EMUSIC,H_D2},
{ "D_E#M#  ","Music of level E?M?",	EMUSIC,H_D1},
{ "D_VICTOR","Victory Music",		EMUSIC,H_D1},
{ "D_INTRO ","Intro Music",		EMUSIC,H_D1},
{ "D_INTER ","Episode End Music",	EMUSIC,H_D1},
{ "D_BUNNY ","End Music",			EMUSIC,H_D1},
{ "MUS_E#M#","Music of level E?M?",	EMUSIC,H_H1},
{ "MUS_TITL","Title music",		EMUSIC,H_H1},
{ "MUS_INTR","Intro music",		EMUSIC,H_H1},
{ "MUS_CPTD","Count down",		EMUSIC,H_H1},
{ "????????","See SNDINFO entry",	EMUSIC,	H_HX},
{ "        ",NULL,-1,H_AL}
};
#endif /*DLLFORDOOM*/
/*
** Graphics
*/
#if (DLLFORDOOM)
struct Help HELPgraph[]=
{
{ "HELP@   ","Help Screen",			EGRAPHIC,H_D1|H_S},
{ "WIMAP1  ","Map of Episode1",		EGRAPHIC,H_D1},
{ "WIMAP2  ","Map of Episode2",		EGRAPHIC,H_D1},
{ "WIMAP3  ","Map of Episode3",		EGRAPHIC,H_D1},
{ "VICTORY2","Final victory",			EGRAPHIC,H_D1},

{ "HELP    ","Help",						EGRAPHIC,H_D2},
{ "INTERPIC","End mission",			EGRAPHIC,H_D2},
{ "BOSSBACK","End Boss",				EGRAPHIC,H_D2},
{ "CWILV## ","Doom2 level names",	EGRAPHIC,H_D2},

{ "E2END   ","End of Episode 2",	EGRAPHIC,H_H1},
{ "FINAL1  ","End of Episode 3",	EGRAPHIC,H_H1},
{ "FINAL2  ","End of Episode 3",	EGRAPHIC,H_H1},
{ "MAPE1   ","Map of Episode 1",	EGRAPHIC,H_H1},
{ "MAPE2   ","Map of Episode 2",	EGRAPHIC,H_H1},
{ "MAPE3   ","Map of Episode 3",	EGRAPHIC,H_H1},
{ "FACE@#  ","Deathmatch player",	EGRAPHIC,H_H1},
{ "USEARTI@","Use artifact",		EGRAPHIC,H_H1},
{ "INVGEM@#","Invulnerability",		EGRAPHIC,H_H1},
{ "BARBACK ","Back of Status bar",	EGRAPHIC,H_H1},
{ "CHAINBAC","Back of Chain",		EGRAPHIC,H_H1},
{ "CHAIN   ","Life Chain",		EGRAPHIC,H_H1},
{ "LIFEGEM#","Life Gem",		EGRAPHIC,H_H1},
{ "ARTIBOX ","Box of Artifacts",	EGRAPHIC,H_H1},
{ "USEARTI#","Artifact used",		EGRAPHIC,H_H1},
{ "STATBAR ","Status bar",		EGRAPHIC,H_H1},
{ "INVBAR  ","Inventory bar",		EGRAPHIC,H_H1},
{ "BKEYICON","Blue key",		EGRAPHIC,H_H1},
{ "GKEYICON","Green key",		EGRAPHIC,H_H1},
{ "YKEYICON","Yellow key",		EGRAPHIC,H_H1},
{ "IN#     ","Big digits",		EGRAPHIC,H_H1},
{ "SMALLIN#","Tiny digits",		EGRAPHIC,H_H1},
{ "INAMGLD ","Elf Wand",		EGRAPHIC,H_H1},
{ "INAMBOW ","Crossbow",		EGRAPHIC,H_H1},
{ "INAMBST ","DragonClaw",		EGRAPHIC,H_H1},
{ "INAMRAM ","HellStaff",		EGRAPHIC,H_H1},
{ "INAMPNX ","Phoenix",			EGRAPHIC,H_H1},
{ "INAMLOB ","Mace",			EGRAPHIC,H_H1},
{ "LIFEBAR ","Life bar",		EGRAPHIC,H_H1},
{ "SPINBK##","Rotating Tome",		EGRAPHIC,H_H1},
{ "SPFLY## ","Rotating Wings",		EGRAPHIC,H_H1},
{ "M_HTIC  ","Title",			EGRAPHIC,H_H1},
{ "M_SKL## ","Rotat. Skull",		EGRAPHIC,H_H1},
{ "FONTA## ","Small fonts",		EGRAPHIC,H_H1},
{ "FONTB## ","Big fonts",			EGRAPHIC,H_H1},
{ "ADVISOR ","Sux",					EGRAPHIC,H_H1},

{ "TITLEPIC","Title screen",		EGRAPHIC,H_D12},
{ "CREDIT  ","Authors",				EGRAPHIC,H_D12},
{ "PFUB#   ","Final scene",		EGRAPHIC,H_D12},
{ "END#    ","End",					EGRAPHIC,H_D12},
{ "AMMNUM# ","Ammo Digits",		EGRAPHIC,H_D12},
{ "STBAR   ","Status Bar",			EGRAPHIC,H_D12},
{ "STGNUM# ","Small digits",		EGRAPHIC,H_D12},
{ "STTNUM# ","Big red digits",	EGRAPHIC,H_D12},
{ "STYSNUM#","Tiny digits",		EGRAPHIC,H_D12},
{ "STKEYS# ","Keys",					EGRAPHIC,H_D12},
{ "STARMS  ","Weapon table",		EGRAPHIC,H_D12},
{ "STCFN0##","Fonts",				EGRAPHIC,H_D12},
{ "STFB#   ","Blackout",			EGRAPHIC,H_D12},
{ "STPB#   ","Blackout",			EGRAPHIC,H_D12},
{ "STFST#1 ","Marine normal",		EGRAPHIC,H_D12},
{ "STFST#0 ","Marine peeks left",EGRAPHIC,H_D12},
{ "STFST#2 ","Marine peeks right",EGRAPHIC,H_D12},
{ "STFTL#0 ","Marine hit left",	EGRAPHIC,H_D12},
{ "STFTR#0 ","Marine hit right",	EGRAPHIC,H_D12},
{ "STFOUCH#","Marine hurt",		EGRAPHIC,H_D12},
{ "STFEVL# ","Marine grins",		EGRAPHIC,H_D12},
{ "STFKILL#","Marine dying",		EGRAPHIC,H_D12},
{ "STFDEAD0","Marine dead",		EGRAPHIC,H_D12},
{ "STFGOD0 ","Marine gid",			EGRAPHIC,H_D12},
{ "ST??????","Status bar item",	EGRAPHIC,H_D12},
{ "M_DOOM  ","Menu logo",			EGRAPHIC,H_D12},
{ "M_SKULL?","Pointer",				EGRAPHIC,H_D12},
{ "BRDR_???","Border",				EGRAPHIC,H_D12},
{ "WI??????","End level data",	EGRAPHIC,H_D12},

{ "M_ENDGAM","End of game",		EGRAPHIC,H_AL},
{ "M_PAUSE ","Pause message",		EGRAPHIC,H_AL},
{ "M_??????","Menu items",			EGRAPHIC,H_AL},
{ "        ",NULL,-1,H_AL}
};
#endif /*DLLFORDOOM*/
/*
** Flats
*/
#if (DLLFORDOOM)
struct Help HELPflat[]=
{
{ "F_SKY1  ","Fake Sky",				EFLAT,H_AL},

{ "NUKAGE1 ","Anim1 start",			EFLAT,H_D12},
{ "NUKAGE3 ","Anim1 stop",				EFLAT,H_D12},
{ "FWATER1 ","Anim2 start",			EFLAT,H_D12},
{ "FWATER4 ","Anim2 stop",				EFLAT,H_D12},
{ "SWATER1 ","Anim3 start",			EFLAT,H_D12},
{ "SWATER4 ","Anim3 stop",				EFLAT,H_D12},
{ "LAVA1   ","Anim4 start",			EFLAT,H_D12},
{ "LAVA4   ","Anim4 stop",				EFLAT,H_D12},
{ "BLOOD1  ","Anim5 start",			EFLAT,H_D12},
{ "BLOOD3  ","Anim5 stop",				EFLAT,H_D12},

{ "RROCK05 ","Anim6 start",			EFLAT,H_D2},
{ "RROCK08 ","Anim6 stop",				EFLAT,H_D2},
{ "SLIME01 ","Anim7 start",			EFLAT,H_D2},
{ "SLIME04 ","Anim7 stop",				EFLAT,H_D2},
{ "SLIME05 ","Anim8 start",			EFLAT,H_D2},
{ "SLIME08 ","Anim8 stop",				EFLAT,H_D2},
{ "SLIME09 ","Anim9 start",			EFLAT,H_D2},
{ "SLIME12 ","Anim9 stop",				EFLAT,H_D2},

{ "FLTWAWA1","Anim1 start(splash)",	EFLAT,H_H1},
{ "FLTWAWA3","Anim1 stop(splash)",	EFLAT,H_H1},
{ "FLTSLUD1","Anim2 start(splash)",	EFLAT,H_H1},
{ "FLTSLUD3","Anim2 stop(splash)",	EFLAT,H_H1},
{ "FLTTELE1","Anim3 start",			EFLAT,H_H1},
{ "FLTTELE4","Anim3 stop",				EFLAT,H_H1},
{ "FLTFLWW1","Anim4 start(splash)",	EFLAT,H_H1},
{ "FLTFLWW3","Anim4 stop(splash)",	EFLAT,H_H1},
{ "FLTLAVA1","Anim5 start(splash)",	EFLAT,H_H1},
{ "FLTLAVA4","Anim5 stop(splash)",	EFLAT,H_H1},
{ "FLATHUH1","Anim6 start",			EFLAT,H_H1},
{ "FLATHUH4","Anim6 stop",				EFLAT,H_H1},
{ "????????","See ANIMDEFS entry",	EFLAT,H_HX},
{ "????????","Ordinary Floor/Ceiling",	EFLAT,	H_D12|H_H1},
{ "        ",NULL,-1,H_AL}
};
#endif /*DLLFORDOOM*/
/*
** Sprite
*/
#if (DLLFORDOOM)
struct Help HELPsprite[]=
{
{ "PLAY@#@#","Player",					ESPRITE,H_AL},

{ "SARG@#@#","Demon",					ESPRITE,H_D12},
{ "TROO@#@#","Imp",						ESPRITE,H_D12},
{ "POSS@#@#","Soldier",					ESPRITE,H_D12},
{ "SPOS@#@#","Sergeant",				ESPRITE,H_D12},
{ "SKUL@#@#","Flying skull",			ESPRITE,H_D12},
{ "BOSS@#@#","Baron of Hell",			ESPRITE,H_D12},
{ "HEAD@#@#","Cacodemon",				ESPRITE,H_D12},
{ "CYBR@#@#","Cyber demon",			ESPRITE,H_D12},
{ "SPID@#@#","Spider Boss",			ESPRITE,H_D12},

{ "CPOS@#@#","Chaingun dude",			ESPRITE,H_D2},
{ "BOS2@#@#","Hell Knight",			ESPRITE,H_D2},
{ "PAIN@#@#","Pain Elemental",		ESPRITE,H_D2},
{ "BSPI@#@#","Arachnotron",			ESPRITE,H_D2},
{ "VILE@#@#","Arch vile",				ESPRITE,H_D2},
{ "FATT@#@#","Mancubus",				ESPRITE,H_D2},
{ "SKEL@#@#","Revenant",				ESPRITE,H_D2},
{ "SSWF@#@#","Nazi",						ESPRITE,H_D2},
{ "KEEN@#@#","Cmdr Keen",				ESPRITE,H_D2},
{ "FIRE@#@#","Archvile fire",			ESPRITE,H_D2},
{ "SHT2@#@#","Double shotgun",		ESPRITE,H_D2},
{ "MANF@#@#","Fire missile",			ESPRITE,H_D2},
{ "BOSF@#@#","Spawn cube",				ESPRITE,H_D2},
{ "BBRN@#@#","Romero",					ESPRITE,H_D2},

{ "MAGE@#@#","Mage player",		   ESPRITE,H_HX},
{ "CLER@#@#","Cleric player",		   ESPRITE,H_HX},
{ "ETTN@#@#","Ettin",		   		ESPRITE,H_HX},
{ "CENT@#@#","Centaur",		   		ESPRITE,H_HX},
{ "DEMN@#@#","Green Demon",		   ESPRITE,H_HX},
{ "FDMN@#@#","Fire Demon",				ESPRITE,H_HX},
{ "ICEY@#@#","Ice Guy",					ESPRITE,H_HX},
{ "PIGY@#@#","Pig",		     			ESPRITE,H_HX},
{ "SSPT@#@#","Serpent",		   		ESPRITE,H_HX},
{ "DEM2@#@#","Brown Demon",		   ESPRITE,H_HX},
{ "WRTH@#@#","Wraith",		   		ESPRITE,H_HX},
{ "DRAG@#@#","Dragon",		   		ESPRITE,H_HX},
{ "BISH@#@#","Bishop",		   		ESPRITE,H_HX},
{ "SORC@#@#","Sorcerer",		   	ESPRITE,H_HX},
{ "KORX@#@#","Korax",		   		ESPRITE,H_HX},


{ "CHKN@#@#","Bird",						ESPRITE,H_H1},
{ "IMPX@#@#","Gargoyle",				ESPRITE,H_H1},
{ "MUMM@#@#","Golem",					ESPRITE,H_H1},
{ "KNIG@#@#","Knight",					ESPRITE,H_H1},
{ "WZRD@#@#","Wizard",					ESPRITE,H_H1},
{ "HEAD@#@#","Iron Lich",				ESPRITE,H_H1},
{ "CLNK@#@#","SabreClaw",				ESPRITE,H_H1},
{ "BEAS@#@#","WereDragon",				ESPRITE,H_H1},
{ "SNKE@#@#","Ophidian",				ESPRITE,H_H1},
{ "MNTR@#@#","Maulotor",				ESPRITE,H_H1X},
{ "SRCR@#@#","D'sparil on Dragon",	ESPRITE,H_H1},
{ "SOR2@#@#","D'sparil",				ESPRITE,H_H1},
{ "SDTH@#@#","D'sparil's Death",		ESPRITE,H_H1},

{ "TFOG@#@#","Teleporter",				ESPRITE,H_D12},
{ "IFOG@#@#","Item Respawn",			ESPRITE,H_D12},
{ "PUNG@#@#","Punch",					ESPRITE,H_D12},
{ "SAWG@#@#","Chain Saw",				ESPRITE,H_D12},
{ "PISG@#@#","Pistol",					ESPRITE,H_D12},
{ "SHTG@#@#","Shotgun",					ESPRITE,H_D12},
{ "CHGG@#@#","Chain Gun",				ESPRITE,H_D12},
{ "MISG@#@#","Launcher",				ESPRITE,H_D12},
{ "PLSG@#@#","Plasma",					ESPRITE,H_D12},
{ "BFGG@#@#","BFG9000",					ESPRITE,H_D12},
{ "ARM?@#@#","Armor",					ESPRITE,H_D12},
{ "BON1@#@#","Vial",						ESPRITE,H_D12},
{ "SOUL@#@#","Soul sphere",			ESPRITE,H_D12},
{ "BON2@#@#","Helmet",					ESPRITE,H_D12},
{ "PINV@#@#","Invisibility",			ESPRITE,H_D12},
{ "BAL#@#@#","Projectiles",			ESPRITE,H_D12},
{ "PUFF@#@#","Bullet puff",			ESPRITE,H_D12},
{ "BLUD@#@#","Blood splat",			ESPRITE,H_D12},
{ "MISL@#@#","Rocket",					ESPRITE,H_D12},
{ "BFE?@#@#","BFG hit",					ESPRITE,H_D12},
{ "POL?@#@#","Pole",						ESPRITE,H_D12},
{ "COL?@#@#","Column",					ESPRITE,H_D12},
{ "FSKU@#@#","Skulls",					ESPRITE,H_D12},
{ "@SKU@#@#","Skull key",				ESPRITE,H_D12},
{ "@KEY@#@#","Key",						ESPRITE,H_D12},

{ "ARTI????","Artifact",				ESPRITE,H_H1X},
{ "GAUN@#@#","Gauntlets",				ESPRITE,H_H1},
{ "STFF@#@#","Staff",					ESPRITE,H_H1},
{ "GWND@#@#","Elf Wand",				ESPRITE,H_H1},
{ "CRBW@#@#","Crossbow",				ESPRITE,H_H1},
{ "BLSR@#@#","Dragon Claw",			ESPRITE,H_H1},
{ "HROD@#@#","Hell Staff",				ESPRITE,H_H1},
{ "PHNX@#@#","Phoenix rod",			ESPRITE,H_H1},
{ "MACE@#@#","Mace",						ESPRITE,H_H1},
{ "KGZYA#  ","Yellow Gizmo",			ESPRITE,H_H1},
{ "KGZBA#  ","Blue Gizmo",				ESPRITE,H_H1},
{ "KGZGA#  ","Green Gizmo",			ESPRITE,H_H1},
{ "CKYY@#@#","Yellow key",				ESPRITE,H_H1},
{ "AKYY@#@#","Green key",				ESPRITE,H_H1},
{ "BKYY@#@#","Blue key",				ESPRITE,H_H1},
{ "KFR1@#@#","Flamming pillar",		ESPRITE,H_H1},
{ "TGLT@#@#","Teleport glow",			ESPRITE,H_H1},
{ "TELE@#@#","Teleport",				ESPRITE,H_H1},
{ "PPOD@#@#","Exploding pod",			ESPRITE,H_H1},
{ "WGNTA#  ","Gauntlet",				ESPRITE,H_H1},
{ "WBOWA#  ","Crossbow",				ESPRITE,H_H1},
{ "WBLSA#  ","Dragon Claw",			ESPRITE,H_H1},
{ "WSKLA#  ","Hell staff",				ESPRITE,H_H1},
{ "WPHXA#  ","Phoenix rod",			ESPRITE,H_H1},
{ "WMCEA#  ","Mace",						ESPRITE,H_H1},
{ "FDTH@#@#","Death by fire",			ESPRITE,H_H1X},
{ "FX##@#@#","Special effect",		ESPRITE,H_H1X},
{ "????????","Ordinary Sprite",		ESPRITE,H_AL},
{ "        ",NULL,-1,H_AL}
};
#endif /*DLLFORDOOM*/
/*
** Graphics
*/
#if (DLLFORDOOM)
struct Help HELPsound[]=
{
{ "DSPISTOL","Pistol firing",		ESNDWAV,H_D12},
{ "DSSGCOCK","Shotgun cocking",		ESNDWAV,H_D12},
{ "DSSHOTGN","Shotgun firing",		ESNDWAV,H_D12},
{ "DSSAWUP ","Chainsaw start",		ESNDWAV,H_D12},
{ "DSSAWIDL","Chainsaw idle",		ESNDWAV,H_D12},
{ "DSSAWFUL","Chainsaw triggered",	ESNDWAV,H_D12},
{ "DSSAWHIT","Chainsaw hits",		ESNDWAV,H_D12},
{ "DSRLAUNC","Firing Rocket",		ESNDWAV,H_D12},
{ "DSRXPLOD","Rocket explodes",		ESNDWAV,H_D12},
{ "DSFIRSHT","Fireballs passing",	ESNDWAV,H_D12},
{ "DSFIRXPL","Fireball hits",		ESNDWAV,H_D12},
{ "DSPUNCH ","Player punching",		ESNDWAV,H_D12},
{ "DSPLASMA","Plasma firing",		ESNDWAV,H_D12},
{ "DSFIRXPL","Plasma hits",		ESNDWAV,H_D12},
{ "DSBFG   ","BFG9000 firing",		ESNDWAV,H_D12},
{ "DSPSTART","Lift starts",		ESNDWAV,H_D12},
{ "DSPSTOP ","Lift stops",		ESNDWAV,H_D12},
{ "DSSTNMOV","Ceilings moving",		ESNDWAV,H_D12},
{ "DSDOROPN","Door opens",		ESNDWAV,H_D12},
{ "DSDORCLS","Door closes",		ESNDWAV,H_D12},
{ "DSBDOPN ","Fast Door Opens",		ESNDWAV,H_D12},
{ "DSBDCLS ","Fast Door Closes",	ESNDWAV,H_D12},
{ "DSSWTCHN","Switch on",		ESNDWAV,H_D12},
{ "DSSWTCHX","Switch off",		ESNDWAV,H_D12},
{ "DSTELEPT","Teleport",		ESNDWAV,H_D12},
{ "DSSLOP  ","Guts",			ESNDWAV,H_D12},
{ "DSITMBK ","Respawn",			ESNDWAV,H_D12},
{ "DSBAREXP","Barrel explodes",		ESNDWAV,H_D12},
{ "DSSKLDTH","Push on wall",		ESNDWAV,H_D12},
{ "DSNOWAY ","Blocked by wall",		ESNDWAV,H_D12},
{ "DSOOF   ","Hit the ground",		ESNDWAV,H_D12},
{ "DSWPNUP ","Weapon pickup",		ESNDWAV,H_D12},
{ "DSITEMUP","Item pickup",		ESNDWAV,H_D12},
{ "DSGETPOW","Power up",		ESNDWAV,H_D12},
{ "DSPLPAIN","Player injured",		ESNDWAV,H_D12},
{ "DSPLDETH","Player death moan",	ESNDWAV,H_D12},
{ "DSPDIEHI","Player death yell",	ESNDWAV,H_D12},
{ "DSPOSACT","Soldier breathing",	ESNDWAV,H_D12},
{ "DSPOSIT1","Soldier sees Player",	ESNDWAV,H_D12},
{ "DSPOSIT2","Soldier sees Player",	ESNDWAV,H_D12},
{ "DSPOSIT3","Soldier sees Player",	ESNDWAV,H_D12},
{ "DSPOPAIN","Soldier injured",		ESNDWAV,H_D12},
{ "DSPODTH1","Soldier dying",		ESNDWAV,H_D12},
{ "DSPODTH2","Soldier dying",		ESNDWAV,H_D12},
{ "DSPODTH3","Soldier dying",		ESNDWAV,H_D12},
{ "DSBGACT ","Imps nearby",		ESNDWAV,H_D12},
{ "DSBGSIT1","Imp sees Player",		ESNDWAV,H_D12},
{ "DSBGSIT2","Imp sees Player",		ESNDWAV,H_D12},
{ "DSCLAW  ","Imp clawing",		ESNDWAV,H_D12},
{ "DSPOPAIN","Imp injured",		ESNDWAV,H_D12},
{ "DSBGDTH1","Imp dying",		ESNDWAV,H_D12},
{ "DSBGDTH2","Imp dying",		ESNDWAV,H_D12},
{ "DSSGTSIT","Demon Player",		ESNDWAV,H_D12},
{ "DSDMACT ","Demon nearby",		ESNDWAV,H_D12},
{ "DSSGTATK","Demon chewing",		ESNDWAV,H_D12},
{ "DSDMPAIN","Demon injured",		ESNDWAV,H_D12},
{ "DSSGTDTH","Demon dying",		ESNDWAV,H_D12},
{ "DSCACSIT","Caco sees player",	ESNDWAV,H_D12},
{ "DSDMACT ","Caco nearby",		ESNDWAV,H_D12},
{ "DSDMPAIN","Caco injured",		ESNDWAV,H_D12},
{ "DSCACDTH","Caco dying",		ESNDWAV,H_D12},
{ "DSBRSSIT","Baron sees Player",	ESNDWAV,H_D12},
{ "DSDMACT ","Baron nearby",		ESNDWAV,H_D12},
{ "DSCLAW  ","Baron clawing",		ESNDWAV,H_D12},
{ "DSDMPAIN","Baron injured",		ESNDWAV,H_D12},
{ "DSBRSDTH","Baron dying",		ESNDWAV,H_D12},
{ "DSSKLATK","LSoul attacking",		ESNDWAV,H_D12},
{ "DSDMACT ","LSoul nearby",		ESNDWAV,H_D12},
{ "DSDMPAIN","LSoul injured",		ESNDWAV,H_D12},
{ "DSFIRXPL","LSoul dying",		ESNDWAV,H_D12},
{ "DSSPISIT","Spider sees Player",	ESNDWAV,H_D12},
{ "DSMETAL ","Spider walking",		ESNDWAV,H_D12},
{ "DSSPIDTH","Spider dying",		ESNDWAV,H_D12},
{ "DSCYBSIT","Cyber sees Player",	ESNDWAV,H_D12},
{ "DSHOOF  ","Cyber walking",		ESNDWAV,H_D12},
{ "DSCYBDTH","Cyber dying",		ESNDWAV,H_D12},
{ "DSTINK  ","Modem Play",		ESNDWAV,H_D12},

{ "DSDBOPN ","Open S-Shotgun",		ESNDWAV,H_D2},
{ "DSDBCLS ","Close S-Shotgun",		ESNDWAV,H_D2},
{ "DSDBLOAD","Reload S-Shotgun",	ESNDWAV,H_D2},
{ "DSDSHTGN","Fire S-Shotgun",		ESNDWAV,H_D2},
{ "DSSKESIT","Revenant sees Player",	ESNDWAV,H_D2},
{ "DSSKEACT","Revenant nearby",		ESNDWAV,H_D2},
{ "DSSKEATK","Revenant fires missile",	ESNDWAV,H_D2},
{ "DSSKESWG","Revenant swings",		ESNDWAV,H_D2},
{ "DSSKEPCH","Revenant punches",	ESNDWAV,H_D2},
{ "DSSKEDTH","Revenant dying",		ESNDWAV,H_D2},
{ "DSMANSIT","Mancubis sees Player",	ESNDWAV,H_D2},
{ "DSMANATK","Mancubis attacks",	ESNDWAV,H_D2},
{ "DSMNPAIN","Mancubis injured",	ESNDWAV,H_D2},
{ "DSMANDTH","Mancubis dying",		ESNDWAV,H_D2},
{ "DSPESIT ","Pain-E sees Player",	ESNDWAV,H_D2},
{ "DSPEPAIN","Pain-E injured",		ESNDWAV,H_D2},
{ "DSPEDTH ","Pain-E dying",		ESNDWAV,H_D2},
{ "DSBSPSIT","BabSpider sees Player",	ESNDWAV,H_D2},
{ "DSBSPWLK","BabSpider walking",	ESNDWAV,H_D2},
{ "DSBSPACT","BabSpider nearby",	ESNDWAV,H_D2},
{ "DSBSPDTH","BabSpider dying",		ESNDWAV,H_D2},
{ "DSKNTSIT","HellKnight sees Player",	ESNDWAV,H_D2},
{ "DSDMACT ","HellKnight nearby",	ESNDWAV,H_D2},
{ "DSCLAW  ","Knight clawing",		ESNDWAV,H_D2},
{ "DSDMPAIN","Knight injured",		ESNDWAV,H_D2},
{ "DSKNTDTH","Knight dying",		ESNDWAV,H_D2},
{ "DSVILSIT","Vile sees Player",	ESNDWAV,H_D2},
{ "DSVILACT","Vile nearby",		ESNDWAV,H_D2},
{ "DSVILATK","Vile attacks",		ESNDWAV,H_D2},
{ "DSFLAMST","Vile Flames",		ESNDWAV,H_D2},
{ "DSFLAME ","Vile Flames",		ESNDWAV,H_D2},
{ "DSVIPAIN","Vile injured",		ESNDWAV,H_D2},
{ "DSVILDTH","Vile dying",		ESNDWAV,H_D2},
{ "DSBOSSIT","EndBoss greetings",	ESNDWAV,H_D2},
{ "DSBOSPIT","EndBoss Cube",		ESNDWAV,H_D2},
{ "DSBOSCUB","Cube Lands",		ESNDWAV,H_D2},
{ "DSBOSPN ","EndBoss injured",		ESNDWAV,H_D2},
{ "DSBOSDTH","EndBoss dying",		ESNDWAV,H_D2},
{ "DSSSSIT ","SS shouts",		ESNDWAV,H_D2},
{ "DSSSDTH ","SS dying",		ESNDWAV,H_D2},
{ "DSKEENPN","Keen injured",		ESNDWAV,H_D2},
{ "DSKEENDT","Keen dying",		ESNDWAV,H_D2},
{ "DSRADIO ","Chat message",		ESNDWAV,H_D2},

{ "STFHIT  ","Staff hit",		ESNDWAV,H_H1X},
{ "GLDHIT  ","Elf wand hit",		ESNDWAV,H_H1X},
{ "STFPOW  ","Staff hit+",		ESNDWAV,H_H1X},
{ "STFCRK  ","Staff ++",		ESNDWAV,H_H1X},
{ "GNTACT  ","Gauntlet",		ESNDWAV,H_H1X},
{ "GNTFUL  ","Gaunt ++",		ESNDWAV,H_H1X},
{ "GNTHIT  ","Gaunt hit",		ESNDWAV,H_H1X},
{ "GNTPOW  ","Gaunt hit+",		ESNDWAV,H_H1X},
{ "GNTUSE  ","Gaunt used",		ESNDWAV,H_H1X},
{ "BOWSHT  ","Crossbow",		ESNDWAV,H_H1X},
{ "HRNHIT  ","HellStf hit",		ESNDWAV,H_H1X},
{ "HRNSHT  ","HellStf shot",		ESNDWAV,H_H1X},
{ "HRNPOW  ","HellStf shot+",		ESNDWAV,H_H1X},
{ "RAMPHIT ","HellStf hit+",		ESNDWAV,H_H1X},
{ "RAMRAIN ","HellStf rains",		ESNDWAV,H_H1X},
{ "PHOHIT  ","Phoenix hits",		ESNDWAV,H_H1X},
{ "PHOSHT  ","Phoenix shot",		ESNDWAV,H_H1X},
{ "PHOPOW  ","Phoenix shot+",		ESNDWAV,H_H1X},
{ "LOBSHT  ","Mace shot",		ESNDWAV,H_H1X},
{ "LOBHIT  ","Mace hit",		ESNDWAV,H_H1X},
{ "LOBPOW  ","Mace hit+",		ESNDWAV,H_H1X},
{ "BOUNCE  ","Ball bounces",		ESNDWAV,H_H1X},
{ "NEWPOD  ","Gas Pod",			ESNDWAV,H_H1X},
{ "PODEXP  ","Pod Explodes",		ESNDWAV,H_H1X},
{ "IMPSIT  ","Gargoyle sees Player",	ESNDWAV,H_H1X},
{ "IMPAT1  ","Garg. attacks",		ESNDWAV,H_H1X},
{ "IMPAT2  ","Garg. attacks",		ESNDWAV,H_H1X},
{ "IMPDTH  ","Garg. dying",		ESNDWAV,H_H1X},
{ "IMPPAI  ","Garg. injured",		ESNDWAV,H_H1X},
{ "MUMSIT  ","Golem sees Player",	ESNDWAV,H_H1X},
{ "MUMAT1  ","Golem attacks",		ESNDWAV,H_H1X},
{ "MUMAT2  ","Golem attacks",		ESNDWAV,H_H1X},
{ "MUMDTH  ","Golem dying",		ESNDWAV,H_H1X},
{ "MUMPAI  ","Golem injured",		ESNDWAV,H_H1X},
{ "MUMHE   ","NitroGolem",		ESNDWAV,H_H1X},
{ "BLSSHT  ","Skull shot",		ESNDWAV,H_H1X},
{ "BLSHIT  ","Skull hit",		ESNDWAV,H_H1X},
{ "KGTSIT  ","Knight sees Player",	ESNDWAV,H_H1X},
{ "KGTATK  ","Knight attacks",		ESNDWAV,H_H1X},
{ "KGTAT2  ","Knight attacks",		ESNDWAV,H_H1X},
{ "KGTDTH  ","Knight dying",		ESNDWAV,H_H1X},
{ "KGTPAI  ","Knight injured",		ESNDWAV,H_H1X},
{ "WIZSIT  ","Wizard sees Player",	ESNDWAV,H_H1X},
{ "WIZATK  ","Wizard attacks",		ESNDWAV,H_H1X},
{ "WIZDTH  ","Wizard dying",		ESNDWAV,H_H1X},
{ "WIZACT  ","Wizard",			ESNDWAV,H_H1X},
{ "WIZPAI  ","Wizard injured",		ESNDWAV,H_H1X},
{ "HEDSIT  ","Head attacks",		ESNDWAV,H_H1X},
{ "HEDAT1  ","Head attacks",		ESNDWAV,H_H1X},
{ "HEDAT2  ","Head attacks",		ESNDWAV,H_H1X},
{ "HEDDTH  ","Head dying",		ESNDWAV,H_H1X},
{ "HEDACT  ","Head",			ESNDWAV,H_H1X},
{ "HEDPAI  ","Head injured",		ESNDWAV,H_H1X},
{ "BSTACT  ","WereDragon",		ESNDWAV,H_H1X},
{ "BSTSIT  ","WereD sees player",	ESNDWAV,H_H1X},
{ "BSTATK  ","WereD attacks",		ESNDWAV,H_H1X},
{ "BSTDT   ","WereD dying",		ESNDWAV,H_H1X},
{ "BSTPAI  ","WereD injujed",		ESNDWAV,H_H1X},
{ "CLKACT  ","SabreClaw",		ESNDWAV,H_H1X},
{ "CLKSIT  ","SabreC sees player",	ESNDWAV,H_H1X},
{ "CLKATK  ","SabreC attacks",		ESNDWAV,H_H1X},
{ "CLKDTH  ","SabreC dying",		ESNDWAV,H_H1X},
{ "CLKPAI  ","SabreC injured",		ESNDWAV,H_H1X},
{ "SNKACT  ","Ophidian",		ESNDWAV,H_H1X},
{ "SNKSIT  ","Ophd sees player",	ESNDWAV,H_H1X},
{ "SNKATK  ","Ophd attacks",		ESNDWAV,H_H1X},
{ "SNKDTH  ","Ophd dying",		ESNDWAV,H_H1X},
{ "SNKPAI  ","Ophd injured",		ESNDWAV,H_H1X},
{ "MINACT  ","Minautor",		ESNDWAV,H_H1X},
{ "MINSIT  ","Min. sees player",	ESNDWAV,H_H1X},
{ "MINAT1  ","Min. attacks",		ESNDWAV,H_H1X},
{ "MINAT2  ","Min. attacks",		ESNDWAV,H_H1X},
{ "MINDTH  ","Min. dying",		ESNDWAV,H_H1X},
{ "MINPAI  ","Min. injured",		ESNDWAV,H_H1X},
{ "SORACT  ","Sorcerer",		ESNDWAV,H_H1X},
{ "SORZAP  ","Sorc. teleport",		ESNDWAV,H_H1X},
{ "SORRISE ","Sorc. appears",		ESNDWAV,H_H1X},
{ "SORSIT  ","Sorc. sees Player",	ESNDWAV,H_H1X},
{ "SORATK  ","Sorc. attacks",		ESNDWAV,H_H1X},
{ "SORPAI  ","Sorc. injured",		ESNDWAV,H_H1X},
{ "SORDSPH ","Sorc. Dying",		ESNDWAV,H_H1X},
{ "SORDEXP ","Sorc. Explodes",		ESNDWAV,H_H1X},
{ "SORDBON ","Bones drop",		ESNDWAV,H_H1X},
{ "SBTACT  ","Dragon",			ESNDWAV,H_H1X},
{ "SBTDTH  ","Dragon dying",		ESNDWAV,H_H1X},
{ "SBTPAI  ","Dragon injured",		ESNDWAV,H_H1X},
{ "PLROOF  ","Player lands",		ESNDWAV,H_H1X},
{ "PLRPAI  ","Player injured",		ESNDWAV,H_H1X},
{ "PLRDTH  ","Player dying",		ESNDWAV,H_H1X},
{ "PLRWDTH ","Player dying",		ESNDWAV,H_H1X},
{ "PLRCDTH ","Player dying",		ESNDWAV,H_H1X},
{ "BURN    ","Flamed",			ESNDWAV,H_H1X},
{ "CHICPAI ","Bird injured",		ESNDWAV,H_H1X},
{ "CHICATK ","Bird attacks",		ESNDWAV,H_H1X},
{ "CHICDTH ","Bird dying",		ESNDWAV,H_H1X},
{ "CHICACT ","Bird",			ESNDWAV,H_H1X},
{ "CHICPK1 ","Bird peaks",		ESNDWAV,H_H1X},
{ "CHICPK2 ","Bird peaks",		ESNDWAV,H_H1X},
{ "CHICPK2 ","Bird peaks",		ESNDWAV,H_H1X},
{ "GIBDTH  ","Gib death",		ESNDWAV,H_H1X},
{ "KEYUP   ","Take Key",		ESNDWAV,H_H1X},
{ "ITEMUP  ","Take Item",		ESNDWAV,H_H1X},
{ "RESPAWN ","Item regenerated",	ESNDWAV,H_H1X},
{ "WPNUP   ","Take Weapon",		ESNDWAV,H_H1X},
{ "ARTIUP  ","Take Artifact",		ESNDWAV,H_H1X},
{ "CHAT    ","Modem Chat",		ESNDWAV,H_H1X},
{ "GFRAG   ","Frag Count",		ESNDWAV,H_H1X},
{ "ARTIUSE ","Use artifact",		ESNDWAV,H_H1X},
{ "SWITCH  ","Switch",			ESNDWAV,H_H1X},
{ "DOROPN  ","Door Open",		ESNDWAV,H_H1X},
{ "DORCLS  ","Door Close",		ESNDWAV,H_H1X},
{ "DORMOV  ","Door Move",		ESNDWAV,H_H1X},
{ "TELEPT  ","Teleport",		ESNDWAV,H_H1X},
{ "PSTART  ","Platform start",		ESNDWAV,H_H1X},
{ "PSTOP   ","Platform stop",		ESNDWAV,H_H1X},
{ "STNMOV  ","Platform move",		ESNDWAV,H_H1X},
{ "AMB??   ","Ambiance [01-15]",	ESNDWAV,H_H1X},
{ "WATERFL ","Water flowing",		ESNDWAV,H_H1X},
{ "WIND    ","Wind blowing",		ESNDWAV,H_H1X},
{ "RIPSLOP ","Squished",		ESNDWAV,H_H1X},
{ "GLOOP   ","Splash",			ESNDWAV,H_H1X},
{ "DP??????","PC speaker sound",	ESNDPC,H_D12},
{ "????????","See SNDINFO entry",	ESNDWAV,H_HX},
{ "        ",NULL,-1,H_AL}
};
/*
** Texture names
*/
struct Help HELPtexu[]=
{
{ "SW1?????","Switch OFF",			ETEXNAM,H_D12},
{ "SW2?????","Switch ON",			ETEXNAM,H_D12},
{ "BLODGR1 ","Anim1 Start",		ETEXNAM,H_D12},
{ "BLODGR4 ","Anim1 End",			ETEXNAM,H_D12},
{ "BLODRIP1","Anim2 Start",		ETEXNAM,H_D12},
{ "BLODRIP4","Anim2 End",			ETEXNAM,H_D12},
{ "FIREBLU1","Anim3 Start",		ETEXNAM,H_D12},
{ "FIREBLU2","Anim3 End",			ETEXNAM,H_D12},
{ "FIRELAV2","Anim4 Start",		ETEXNAM,H_D12},
{ "FIRELAVA","Anim4 End",			ETEXNAM,H_D12},
{ "FIREWALA","Anim5 Start",		ETEXNAM,H_D12},
{ "FIREWALL","Anim5 End",			ETEXNAM,H_D12},
{ "FIREMAG1","Anim6 Start",		ETEXNAM,H_D12},
{ "FIREMAG3","Anim6 End",			ETEXNAM,H_D12},
{ "GSTFONT1","Anim7 Start",		ETEXNAM,H_D12},
{ "GSTFONT3","Anim7 End",			ETEXNAM,H_D12},
{ "ROCKRED1","Anim8 Start",		ETEXNAM,H_D12},
{ "ROCKRED3","Anim8 End",			ETEXNAM,H_D12},
{ "SLADRIP1","Anim9 Start",		ETEXNAM,H_D12},
{ "SLADRIP3","Anim9 End",			ETEXNAM,H_D12},

{ "BFALL1  ","Anim10 Start",		ETEXNAM,H_D2},
{ "BFALL4  ","Anim10 End",			ETEXNAM,H_D2},
{ "SFALL1  ","Anim11 Start",		ETEXNAM,H_D2},
{ "SFALL4  ","Anim11 End",			ETEXNAM,H_D2},
{ "WFALL1  ","Anim12 Start",		ETEXNAM,H_D2},
{ "WFALL4  ","Anim12 End",			ETEXNAM,H_D2},
{ "DBRAIN1 ","Anim13 Start",		ETEXNAM,H_D2},
{ "DBRAIN4 ","Anim13 End",			ETEXNAM,H_D2},

{ "LAVAFL1 ","Anim1 Start",		ETEXNAM,H_H1},
{ "LAVAFL3 ","Anim1 End",			ETEXNAM,H_H1},
{ "WATRWAL1","Anim2 Start",		ETEXNAM,H_H1},
{ "WATRWAL3","Anim2 End",			ETEXNAM,H_H1},

{ "SKY1    ","Sky for episode 1",	ETEXNAM,H_D1+H_H1},
{ "SKY2    ","Sky for episode 2",	ETEXNAM,H_D1+H_H1},
{ "SKY3    ","Sky for episode 3",	ETEXNAM,H_D1+H_H1},

{ "SKY1    ","Sky for map 1-11",		ETEXNAM,H_D2},
{ "SKY2    ","Sky for map 12-22",	ETEXNAM,H_D2},
{ "SKY3    ","Sky for map 23-32",	ETEXNAM,H_D2},

{ "????????","See ANIMDEFS entry",	ETEXNAM,H_HX},
{ "????????","Ordinary texture",		ETEXNAM,H_D12|H_H1},

{ "        ",NULL,-1,H_AL}
};
#endif /*DLLFORDOOM*/

/****************************************************\
*
*
* ENTRIES internal indentification service
*
*
\****************************************************/

static pHelp HELPselectList(IDENT Id)
{
#if (DLLFORDOOM)
  switch(Id & EMASK)
  {
	  case ESPRITE:  return HELPsprite;
	  case EFLAT:    return HELPflat;
	  case EGRAPHIC: return HELPgraph;
	  case ESOUND:   return HELPsound;
	  case EMUSIC:   return HELPmusic;
	  case ETEXNAM:  return HELPtexu;
	  case ELEVEL:   case ELUMP:
	  case ETEXTUR:  case EPATCH:
	  case EVOID:    return HELPmisc;
  }
#else
  (void)Id;
#endif /*DLLFORDOOM*/
  return HELPgeneral;
}
/*
** Get game bit mask, for help selection
*/
static Int16 HELPgameMask(Int16 Game)
{
  if(Game & GAM_DOOM)
  {
	 if(Game & GAM_CMRC) return H_D2;
	 return H_D1;
  }
  else if(Game & GAM_HEXN)
  { return H_HX;
  }
  else if(Game & GAM_HTIC)
  { return H_H1;
  }
  else if(Game & GAM_STRF)
  { return H_S;
  }
  else if(Game & GAM_QUAK)
  { return H_QK;
  }
  return 0;/*no such game*/
}
/*
** Check that Name matches Model
** returns 1 if ok,0 if false
** Model  * = anything after this
**        ? = anything
**        @ = letter
**        # = digit
*/
static Int16 HELPmatchModelI(pInt8 Name,pInt8 Model)
{ Int16 i;
  Int8 n,m;
  for(i=0;i<8;i++)
  {
	 n=Name[i];
	 m=Model[i];
	 if(m<=' ')/*end of string*/
	 {
		if(n=='\0') break;
		return 0;
	 }
	 if(m=='#')               /*must be number*/
	 {
		if(isdigit(n))
		{ /*sprite: no second viewpoint*/
	if((i==4+1)&&(Strncmp(&Model[4],"@#@#",4)))
	{
	  if(Name[4+2]=='\0') break;
		  }
	continue;
		}
		return 0;
	 }
	 if(m=='@')               /*must be letter*/
	 {
		if(isalpha(n)) continue;
		return 0;
	 }
	 if(m=='*') { break; }    /*anything*/
	 if(m=='?') { continue; } /*any Int8*/
	 if(m!=n)   { return 0; } /*must be equal*/
  }
  return 1;
}
/*
** Say if name is valid
** returns 0 if not >0 if ok
*/
static Int16 HELPisLegalNameI(pInt8 Name)
{ Int16 i;
  Int8 n;
  for(i=0;i<8;i++)
  {
	 n=Name[i];
	 if(n<=' ')break;/*end of string*/
	 switch(n)
	 {
		case '#': case '@':
		case '?': case '*':
	return 0;
	 }
	 /*
	 if(isdigit(n))continue;
	 if(isalpha(n)) continue;
	 if(n=='_') continue;
	 return 0;
	 */
  }
  return 1;
}
/*
** say if name matches
** <0 if not, 0 if name illegal, >0 if ok
*/
pHelp HELPfindNameI(pInt8 Name, IDENT Id, Int16 Game)
{ pHelp Hlp;
  Int16 IdM;
  Int16 GameM;
  /**/
  GameM= HELPgameMask(Game);
  if(GameM<0) return NULL;
  /*
  ** Selection on entry types.
  ** Id=generic    select all entries of that type
  ** Id=specific	select only that type
  */
  IdM = ((Id&EMASK)==Id)? EMASK: 0xFFFF;
  Id = Id&IdM;
  /**/
  for(Hlp = HELPselectList(Id);Hlp->Id>0;Hlp+=1)
  { /* select game */
	 if(!(Hlp->Game & GameM)) continue;
	 /* select type */
	 if((Hlp->Id & IdM) != Id) continue;
	 /*
	 ** found in list
	 */
	 if(HELPmatchModelI(Name,Hlp->Name)>0)
	 {
		return Hlp;
	 }
  }
  return NULL;
}
/****************************************************\
*
*
* ENTRIES external indentification service
*
*
\****************************************************/

/*
** say if name matches something in the help list
** <0 if not, 0 if name illegal, >0 if ok
*/
Int16 EXPORT HELPfindName(pInt8 Name, IDENT Id, Int16 Game)
{ pHelp Hlp;
  Int8 Name2[NORMALISELEN+2];
  /**/
  Normalise(Name2,Name);
  /**/
  Hlp=HELPfindNameI(Name2,Id,Game);
  if(Hlp==NULL)
  { /*not found*/
	 return -1;
  }
  return HELPisLegalNameI(Name2);
}
/*
** get help text associated to a name
*/
Int16 EXPORT HELPforName(pInt8 Name, IDENT Id, Int16 Game,pInt8 Text,Int16 TextSz)
{ pHelp Hlp;
  pInt8 Txt;
  Int8 Name2[NORMALISELEN+2];
  /**/
  if(Text==NULL) return -1;
  Normalise(Name2,Name);
  /*
  ** try to find matching entry
  */
  Hlp=HELPfindNameI(Name2,Id,Game);
  /*
  ** result of search
  */
  Txt = ((Hlp==NULL)||(Hlp->Help==NULL))? " " : Hlp->Help;
  Strncpy(Text,Txt,TextSz-1);
  return Strlen(Txt,TextSz-1);
}
/*
** List all entries of a given type
*/
void EXPORT HELPforWad(pWINDOZE Wnd, IDENT Id,Int16 Game)
{ pHelp Hlp;
  Int16 IdM;
  Int16 GameM;
  Int16 x,y;
  TXTOBJ Txt;
  /**/
  GameM= HELPgameMask(Game);
  if(GameM<0) return;

  /*
  ** If specific type, set mask only for this type.
  */
  if(Id==ELVLHDR)
  { IdM = EMASK;} /*level header, special*/
  else
  { IdM= ((Id&EMASK)==Id)? EMASK: 0xFFFF;}
  /*
  ** Fill the list
  */
  TXTinitWnd(&Txt,0,Wnd);
  /**/
  for(Hlp = HELPselectList(Id); Hlp->Id>0; Hlp+=1)
  {
	 /* select according to game */
	 if(!(Hlp->Game & GameM)) continue;
	 /* select according to type */
	 if((Hlp->Id & IdM) != (Id & IdM)) continue;
	 /* add in list */
	 TXTprintFrm(&Txt,"%-8.8s %s.",Hlp->Name,((Hlp->Help!=NULL)? Hlp->Help : "???"));
  }
  /*
  ** Musics: special list
  */
  if((Id&IdM)==(EMUSIC&IdM))
  {
	 if(GameM&H_D1)
	 { for(x=1;x<=3;x++)
		  for(y=1;y<=9;y++)
			 TXTprintFrm(&Txt,"D_E%dM%d   Music for Ep%d Map%d.",x,y,x,y);
	 }
	 else if(GameM&H_H1)
	 { for(x=1;x<=2;x++)
		  for(y=1;y<=9;y++)
			 TXTprintFrm(&Txt,"MUS_E%dM%d Music for Ep%d Map%d.",x,y,x,y);
	 }
  }
  /*
  ** Levels: special list
  */
  else  if((Id&IdM)==(ELVLHDR&IdM))
  {
	 if(GameM&(H_D1|H_H1))
	 { /*DOOM/HERETIC level*/
		for(x=1;x<=4;x++)
		{
		  for(y=1;y<=8;y++)
			 TXTprintFrm(&Txt,"E%dM%d     Ep.%d Map%d.",x,y,x,y);
		  TXTprintFrm(&Txt,"E%dM9     Ep.%d Secret Map.",x,y,x,y);
		}
	 }
  }
  /**/
  TXTfree(&Txt);
}


/****************************************************\
*
*
* entry TYPES explicit indentification service
*
*
\****************************************************/

/*
** Identify all types.
*/
struct FLIC { Int16 Id; Int8 *Name; } Pasqua[]=
{
#if (DLLFORDOOM)
 /*level*/
 {ELEVEL,	"Level data"},
 {EVOID,		"Marker"},
/*markers   start= 11 end=12*/
 {ES_STA,	"Start of sprites"},
 {ES_END,	"End of sprites"},
 {EP_STA,	"Start of patches"},
 {EP_END,	"End of patches"},
 {EF_STA,	"Start of flats"},
 {EF_END,	"End of flats"},
/*entries*/
 {ELUMP,		"Data lump"},
 { ELMPTXT,	"Text lump"},
 { ELMPDMO,	"Demo lump"},
 { ELMPPAL,	"Palette lump"},
 { ELMPMAP,	"Colormap lump"},
 { ELMPPIC,	"Picture lump"},
 { ELMPSCR,	"Screen lump"},
 { ELMPACS,	"Anim. lump"},
 {ESOUND,	"Sound fx"},
 { ESNDPC,	"PC sound fx"},
 { ESNDWAV,	"Sound fx"},
 {ETEXTUR,	"Texture"},
 { ETEXU1,  "Texture list"},
 { ETEXU2,  "Texture list"},
 { EPNAME,	"Patch list"},
 {EGRAPHIC, "Graphic"},
 {EGRAPHSP, "Graphic"},
 {ESPRITE,	"Sprite"},
 {EPATCH, 	"Patch"},
 {EFLAT,	   "Flat(64x64)"},
 {EFLATH1,  "Flat(64x65)"},
 {EFLATH2,  "Flat(64x128)"},
 {EMUSIC,	"Music"},
#endif /*DLLFORDOOM*/

#if (DLLFORQUAK)
 /*Quake*/
 {EQKLMP,	"Quake data"},
 {EQKCON,	"Quake console"},
 {EQKTEX,	"Quake texture"},
 {EQKPIC,	"Quake sprite"},
/*Pack*/
 {EPACK,	   "Packed File"},
 {EPK_BSP,	"BSP Map"},
 {EPK_DAT,	"Data"},
 {EPK_WAV,	"WAV Sound"},
 {EPK_RC,	"Ressources"},
 {EPK_MDL,	"3D Model"},
 {EPK_SPR,	"Sprite Model"},
 {EPK_WAD,	"WAD File"},
 {EPK_LMP,	"Lump"},
 {EPK_PIC,	"Picture"},
 {EPK_BIN,	"Screen"},
 {EPK_CFG,	"Config"},
#endif /*DLLFORQUAK*/

#if DLLFORDUKE
/*Duke*/
 {EDK_CON,	"Duke Script"},
 {EDK_TMB,	"Timbr Data"},
 {EDK_BIN,	"Screen"},
 {EDK_DAT,	"Data"},
 {EDK_VOC,	"Sound"},
 {EDK_MID,	"Midi"},
 {EDK_ART,	"Art"},
 {EDK_MAP,	"Level Map"},
#endif /*DLLFORDUKE*/
  {-1,NULL}
};

Int16 EXPORT HELPforType(Int16 Id,pInt8 Text,Int16 TextSz)
{ Int16 i;
  if((Text==NULL)||(TextSz<0))
  { return ERRfault(BAD_PARM);}
  Text[0]='\0';
  if((Id&EMASK)==ELEVEL)
  {
	 i=0;
  }
  else
  {
	 for(i=1;i<256;i++)
	 { if((Pasqua[i].Id==-1)||(Pasqua[i].Name==NULL))return 0;
		if(Pasqua[i].Id==Id)break;
	 }
  }
  Strncpy(Text,Pasqua[i].Name,TextSz-1);
  return Strlen(Pasqua[i].Name,TextSz-1);
}











