/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 'w'

#include "lbwintex.h"
#include "lbcommon.h"
#include <stdlib.h>
#include "lbwad.h"

#include "lbdispl.h"

#include "lbwaddef.h"
#include "lbdoom.h"



/****************************************************\
*
*
*  Error handling
*
*
\****************************************************/



static Int8 *ERRmsgWad[] =
{ "none",
  "Too many WAD files opened",
  "Unclean WAD record",
  "Bad WAD file",
  "Bad WAD file header",
  "Bad WAD entry size",
  "Bad WAD entry pointer",
  "Main WAD cannot be identified",
  "Bad GRP file",
  "Bad WAD picture",
  "WAD directory modifications were not saved",
  "WAD directory modification failed. All changes are lost.",
  "WAD directory is full",
  "WAD directory is void",
  "WAD modification failed. The WAD might be unusable now.",
  "Bad patch list (PNAMES)",
  "Missing patch list (PNAMES)",
  "Wall patch cannot be found in WAD or main WAD",
  "Missing color palette (PLAYPAL)",
  "An entry is missing entry in level",
  "Line of size 0 in level",
  "This game is not registered. Expect problems",
  "Modification of a main WAD is not allowed. Please create a new PWAD.",
  "This entry cannot be modified",
  "Missing color mapping (COLORMAP)",
  "This WAD cannot be modified",
  "Picture size is not 64x64 (or 64x128)",
  "Picture size is not 320x200",
  "This is not a valid MUS format",
  "This is not a compiled Script",
  "Too many wall patches in texture",
  NULL
};
Int16 ERRfaultW(Int16 Line,Int16 Type, Int8 Module)
{ return ERRdeclare(ERRmsgWad,Type+100,Line,Module);
}

