
/****************************************************\
*
* QUAKE LEVEL OBJECT DEFINITION
*
\****************************************************/
#if (DLLFORQUAK)
typedef struct
{ Float32 M11; Float32 M12; Float32 M13;
  Float32 M21; Float32 M22; Float32 M23;
  Float32 M31; Float32 M32; Float32 M33;
} MATRIX;
typedef MATRIX PTR *pMATRIX;
typedef struct
{ Float32 X;
  Float32 Y;
  Float32 Z;
} VECTOR;
typedef VECTOR PTR *pVECTOR;
typedef struct
{ Float32 MinX;
  Float32 MinY;
  Float32 MinZ;
  Float32 MaxX;
  Float32 MaxY;
  Float32 MaxZ;
} BOUNDBOX;
typedef BOUNDBOX PTR *pBOUNDBOX;
typedef struct
{ Int16 MinX;
  Int16 MinY;
  Int16 MinZ;
  Int16 MaxX;
  Int16 MaxY;
  Int16 MaxZ;
} PACKEDBBOX;
typedef PACKEDBBOX PTR *pPACKEDBBOX;
/*
** BSP header list
*/
typedef struct
{ Int32 Start;
  Int32 Size;
}QKBSPE;
#define QKBSPVERSION (0x1D)
#define QKBSPDIRNB (0xF)
typedef struct
{ Int32 Id; /*0x1D*/
  QKBSPE Dir[QKBSPDIRNB];
}QKBSPHEAD;
typedef QKBSPHEAD PTR *pQKBSPHEAD;
#if sizeof(QKBSPHEAD)!= 0x7C
#error Wrong side for BSPHEAD
#endif
/*
** Plane
*/
typedef struct
{ VECTOR  Norm;
  Float32 Dist;
  Int32   Type;
}QKPLANE;
typedef QKPLANE PTR *pQKPLANE;
#if sizeof(QKPLANE)!= 0x14
#error Wrong size for Planes
#endif
/*
** Texture lump header
*/
typedef struct
{ Int32 Nb;
  Int32 Start[1];
}QKTEXLIST;
typedef QKTEXLIST PTR *pQKTEXLIST;
/*
** Texture header
*/
typedef struct
{ Int8   Name[16];   /*Name of the texture */
  Int32  SzX;        /* width of picture, must be a multiple of 8 */
  Int32  SzY;        /* height of picture, must be a multiple of 8 */
  Int32  Offs[4];    /* pointer to Pix[width*height/(2^(2*n))] */
} QKMIPTEX;
typedef QKMIPTEX PTR *pQKMIPTEX;
typedef pQKMIPTEX PTR *ppQKMIPTEX;
/*
** Vertex
*/
typedef VECTOR QKVERTEX;
typedef QKVERTEX PTR *pQKVERTEX;
/*
** Nodes
*/
typedef struct
{ UInt32   Plan;    /*Split plane of the node*/
  UInt16   Front;   /*if(!(child&0x8000)) :  child = Node*/
  UInt16   Back;    /*if(child&0x8000)    : child^0xFFFF = Leaf*/
  PACKEDBBOX Bound;   /* Bounding box of node and all childs*/
  UInt16   Face;    /*first face laying in split plane*/
  UInt16   FaceNb;  /*nb of faces*/
}QKNODE;
typedef QKNODE PTR *pQKNODE;
#if sizeof(QKNODE)!= 0x18
#error Wrong size for Nodes
#endif

typedef struct
{ VECTOR  Svect;    /*S vector*/
  Float32 Soffs;
  VECTOR  Tvect;    /*T vector*/
  Float32 Toffs;
  UInt32  Texu;     /*Texture*/
  UInt32  Anim;     /*1 for water texture*/
}QKTEXINFO;
typedef QKTEXINFO PTR *pQKTEXINFO;
#if sizeof(QKTEXINFO)!= 0x28
#error Wrong size for Texture Info
#endif

typedef struct
{ UInt16  Plan;    /*Plane id*/
  UInt16  Side;    /*0=front 1=back*/
  UInt32  LEdg;    /*First item in list of edges*/
  UInt16  LEdgNb;  /*Number of edges in list*/
  UInt16  Tinf;    /*Texture info*/
  UInt8   LType;   /* light type -1=no light maps*/
  UInt8   Shadow;  /* base light level for the surface */
  UInt8   Lite1;   /* more light models*/
  UInt8   Lite2;   /* more light models*/
  Int32   LiteMap; /* pointer in lightmap */
}QKFACE;
typedef QKFACE PTR *pQKFACE;
#if sizeof(QKFACE)!= 0x14
#error Wrong size for Face
#endif
/*
** Clip Node
*/
typedef struct
{ Int32  Plan;
  Int16  Front;   /*if(child>0) child*/
  Int16  Back;    /*if(child==-1) outside  if(child==-2) inside*/
}QKCLIPNOD;
typedef QKCLIPNOD PTR *pQKCLIPNOD;
#if sizeof(QKCLIPNOD)!= 0x8
#error Wrong size for Clip Nodes
#endif
/*
** Leaves
*/
typedef struct
{ Int32  Type;     /* Type of leaf*/
  Int32  Visi;     /* -1 or Begining of visibility lists*/
  PACKEDBBOX Bound; /* Bounding box of the leaf*/
  UInt16 LFac;     /* First item of the list of poly*/
  UInt16 LFacNb;   /* Number of poly in the list */
  UInt8  SndWater; /* sound level*/
  UInt8  SndSky;   /* sound level*/
  UInt8  SndSlime; /* sound level*/
  UInt8  SndLava;  /* sound level*/
}QKLEAF;
typedef QKLEAF PTR *pQKLEAF;
#if sizeof(QKLEAF)!=0x1C
#error Wrong size for Leaf
#endif
/*
** List of surfaces
*/
typedef Int16 QKLFACE;
typedef QKLFACE PTR *pQKLFACE;
/*
** Edge
*/
typedef struct
{ UInt16 Vrtx[2];  /*index of vertex*/
}QKEDGE;
typedef QKEDGE PTR *pQKEDGE;
#if sizeof(QKEDGE)!=0x4
#error Wrong size of edge
#endif
/*
** List of edges
*/
typedef Int32 QKLEDGE;
typedef QKLEDGE PTR *pQKLEDGE;

/*
** Int16 Edge  if >0, Edge= index of edge
**             if <0, -Edge = index of edge
** Edge=0 is never used
*/
/*
** Model
*/
typedef struct
{ BOUNDBOX Bound;   /* The bounding box of the Hull */
  VECTOR   Origin;  /* Origin of model */
  UInt32   Node;    /* id of top Hull internal BSP node */
  UInt32   Clip;    /* id of first top Hull Bound BSP node */
  UInt32   Clip2;   /* id of second top Hull Bound BSP node */
  UInt32   Clip3;   /* = 0 */
  UInt32   LeafNb;  /* number of Hull BSP leaves */
  UInt32   Face;    /* id of first faces */
  UInt32   FaceNb;  /* number faces */
}QKMODEL;
typedef QKMODEL PTR *pQKMODEL;
#if sizeof(QKMODEL)!= 0x40
#error Wrong size for Model
#endif

typedef struct
{ Int16   ScrX; /*screen X*/
  Int16   ScrY; /*screen Y*/
  Float32 X; /*Distance to screen. if<1 invalid*/
  Float32 Y; /*screen X*/
  Float32 Z; /*screen Y*/
}CACHVRTX;
typedef CACHVRTX PTR *pCACHVRTX;

/*
** Level
*/
typedef struct
{
  Int32      Level;       /* entry that is the start of level*/
  /* Entities*/
  Int32      EntiSz;      /* size of entities*/
  pInt8      Enti;        /* entities text*/
  /* Planes*/
  Int32      PlanNb;          /* Nb of planes*/
  pQKPLANE   Plan;         /* planes list*/
  /* MIP textures*/
  Int32      TexuNb;
  ppQKMIPTEX  Texu;
  /* Vertex*/
  Int32      VrtxNb;      /* nb of vertex*/
  pQKVERTEX  Vrtx;        /* vertex list*/
  /* Visibility Lists*/
  Int32      VisiSz;
  pInt8      Visi;
  /* Nodes*/
  Int32      NodeNb;
  pQKNODE    Node;
  /* Surfaces*/
  Int32      TinfNb;
  pQKTEXINFO Tinf;
  /* Poly*/
  Int32      FaceNb;
  pQKFACE    Face;
  /* Lightmaps*/
  Int32      LiteSz;
  pInt8      Lite;
  /* Bound Nodes*/
  Int32      ClipNb;
  pQKCLIPNOD Clip;
  /* Leaves*/
  Int32      LeafNb;
  pQKLEAF    Leaf;
  /* List of surfaces*/
  Int32      LFacNb;
  pQKLFACE   LFac;
  /* Edges*/
  Int32      EdgeNb;
  pQKEDGE    Edge;
  /* List of Edges*/
  Int32      LEdgNb;
  pQKLEDGE   LEdg;
  /* Hull*/
  Int32      ModlNb;
  pQKMODEL   Modl;
  /* Caches*/
  pCACHVRTX  CachVrtx; /*vertex cache*/
  pInt8      CachPlan; /*>0 if plan oriented ok*/
  pInt8      ColEdge;
}BSPDEF;
typedef BSPDEF PTR *pBSPDEF;
#if sizeof(BSPOBJ) != sizeof(BSPDEF)
#error Wrong size for BSPOBJ
#endif

#define QBSP_ENTI 0
#define QBSP_PLAN 1
#define QBSP_TEXU 2
#define QBSP_VRTX 3
#define QBSP_VISI 4
#define QBSP_NODE 5
#define QBSP_TINF 6
#define QBSP_FACE 7
#define QBSP_LITE 8
#define QBSP_CLIP 9
#define QBSP_LEAF 10
#define QBSP_LFAC 11
#define QBSP_EDGE 12
#define QBSP_LEDG 13
#define QBSP_MODL 14


/****************************************************\
*
* QUAKE MODEL DEFINITION
*
\****************************************************/

/*
** Model version
*/
#define QKMDLVERSION 6
/*
** Model header
*/
typedef struct
{ Int8    Name[4];
  Int32   Version;    /*must be 6*/
  Float32   ScaleX;
  Float32   ScaleY;
  Float32   ScaleZ;
  Float32   OrgX;
  Float32   OrgY;
  Float32   OrgZ;
  Float32   Radius;
  Float32   EyeX;     /*eye position*/
  Float32   EyeY;
  Float32   EyeZ;
  Int32   NumSkin;
  Int32   SzX;        /*X size, multiple of 4*/
  Int32   SzY;        /*Y size*/
  Int32   NbVertx;
  Int32   NbTris;
  Int32   NbFram;
  Int32   Sync;       /*0=sync 1=rand*/
  Int32   Flags;
  Float32  Size;      /*average triangle size*/
}QKMDLH;
typedef QKMDLH PTR *pQKMDLH;
#if (sizeof(QKMDLH) != 0x54)
#error Bad size for MDLH
#endif

typedef struct  /*Skin group*/
{ Int32 Id; /*Group or not*/
  Int32 Nb;
  Float32 Time[1]; /*Time[nb]*/
}QKMDLID;
#if (sizeof(QKMDLID) != 0xC)
#error Bad size for MDLID
#endif
typedef QKMDLID *pQKMDLID;


/****************************************************\
*
* QUAKE SPRITE DEFINITION
*
\****************************************************/


#define QKSPRVERSION 1
/*
** Sprite header
*/
typedef struct
{ Int8    Name[4];    /**/
  Int32   Version;    /*must be 1*/
  Int32   Type;       /*0=//upright,1=face upright, 2=//, 3=orientd, 4=//orientd*/
  Float32 Radius;
  Int32   SzX;        /*X size*/
  Int32   SzY;        /*Y size*/
  Int32   FrameNb;    /*Nb of frames*/
  Float32 Beamlength; /**/
  Int32   Synch;      /*0=synch 1= nosynch*/
}QKSPRH;
typedef QKSPRH PTR *pQKSPRH;
#if sizeof(QKSPRH)!= 0x24
#error Wrong size for QKSPRH
#endif
/**/
typedef struct
{ Int32   Id; /*type=1 or 0x10000000. if=0, then picture*/
  Int32   Nb;
  Float32 Num[1]; /* [Nb]*/
  /*SPRPIC Pics[Nb]*/
}QKSPRID;
typedef QKSPRID PTR *pQKSPRID;
#if sizeof(QKSPRID)!= 0xC
#error Wrong size for QKSPRID
#endif
/**/
typedef struct
{
  Int32   OfsX;    /**/
  Int32   OfsY;    /**/
  Int32   SzX;     /*X size*/
  Int32   SzY;     /*Y size*/
  /*Pic[SzX*SzY]*/
}QKSPRPIC;
typedef QKSPRPIC PTR *pQKSPRPIC;
#if sizeof(QKSPRPIC)!= 0x10
#error Wrong size for QKSPRPIC
#endif


#endif /*DLLFORQUAK*/
