/****************************************************\
*
*
* Quake BSP caches
*
*
\****************************************************/

  /*
  ** Init caches (after all the rest was initialised)
  */
Int16 BSPcachInit(pBSPDEF Bsp);
  /*
  ** Free caches
  */
Int16 BSPcachFree(pBSPDEF Bsp);
  /*
  ** Calculate Rotation matrix
  */
void BSPcachCalcRot(pMATRIX Rot, Int32 Phi, Int32 The);
  /*
  ** Calculate position of vertex on screen
  */
void BSPcachCalcVrtx(pBSPDEF Bsp, pBOUND BoundEx, pVECTOR Obs, pMATRIX Rot);
  /*
  ** Calculate orientation of planes toward observer
  */
void BSPcachCalcPlan(pBSPDEF Bsp, pVECTOR Obs);
  /*
  ** Show axis
  */
void BSPcachLineAxis(pBMPOBJ Bmp, pBOUND Bound, pVECTOR Obs, pMATRIX Rot);

/****************************************************\
*
*
* Quake BSP elements
*
*
\****************************************************/

  /*
  ** Entities
  */
Int16 BSPentiInit(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int32 BSPentiCopyAll(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int16 BSPentiCheck(pBSPDEF Bsp, pTXTOBJ Txt);
  /*
  ** Planes
  */
Int16 BSPplanInit(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int32 BSPplanCopyAll(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int16 BSPplanCheck(pBSPDEF Bsp, pTXTOBJ Txt);
Int16 BSPplanModify(pBSPDEF Bsp, pBSPINFOS Infos, Int16 What);
  /*
  ** Textures
  */
Int32 BSPtexuSz(pQKMIPTEX Texu);
Int16 BSPtexuInit(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int32 BSPtexuCopyAll(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int16 BSPtexuFree(pBSPDEF Bsp);
Int16 BSPtexuCheck(pBSPDEF Bsp, pTXTOBJ Txt);
pQKMIPTEX BSPtexuGetI(pBSPDEF Bsp, Int16 Texu);
  /*
  ** Vertices
  */
Int16 BSPvrtxInit(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int32 BSPvrtxCopyAll(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int16 BSPvrtxCheck(pBSPDEF Bsp, pTXTOBJ Txt);
Int16 BSPvrtxCalcBound(pBSPDEF Bsp, pBOUND Bound);
  /*
  ** Visi Lists
  */
Int16 BSPvisiInit(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int32 BSPvisiCopyAll(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int16 BSPvisiCheck(pBSPDEF Bsp, pTXTOBJ Txt);
Int16 BSPvisiPaint(pBSPDEF Bsp, Int32 Leaf);
  /*
  ** Nodes
  */
Int16 BSPnodeInit(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int32 BSPnodeCopyAll(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int16 BSPnodeCheck(pBSPDEF Bsp, pTXTOBJ Txt);
Int16 BSPnodeModify(pBSPDEF Bsp, pBSPINFOS Infos, Int16 What);
Int16 BSPnodePaint(pBSPDEF Bsp, Int32 Node);
  /*
  ** Surfaces TexInfo
  */
Int16 BSPtinfInit(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int32 BSPtinfCopyAll(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int16 BSPtinfCheck(pBSPDEF Bsp, pTXTOBJ Txt);
Int16 BSPtinfModify(pBSPDEF Bsp, pBSPINFOS Infos, Int16 What);
  /*
  ** Faces
  */
Int16 BSPfaceInit(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int32 BSPfaceCopyAll(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int16 BSPfaceCheck(pBSPDEF Bsp, pTXTOBJ Txt);
Int16 BSPfaceModify(pBSPDEF Bsp, pBSPINFOS Infos, Int16 What);
Int16 BSPfacePaintAll(pBSPDEF Bsp, Int8 Color);
Int16 BSPfacePaint(pBSPDEF Bsp, Int32 Face, Int8 Color);
void  BSPfaceEdgeList(pBSPDEF Bsp, pTXTOBJ Txt);
  /*
  ** Hack
  */
Int16 BSPfacePaintSpecial(pBSPDEF Bsp, Int32 Face, Int32 Nb, Int8 Color);
  /*
  ** Lights
  */
Int16 BSPliteInit(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int32 BSPliteCopyAll(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int16 BSPliteCheck(pBSPDEF Bsp, pTXTOBJ Txt);
  /*
  ** Bound Nodes
  */
Int16 BSPclipInit(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int32 BSPclipCopyAll(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int16 BSPclipCheck(pBSPDEF Bsp, pTXTOBJ Txt);
Int16 BSPclipModify(pBSPDEF Bsp, pBSPINFOS Infos, Int16 What);
  /*
  ** Leaves
  */
Int16 BSPleafInit(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int32 BSPleafCopyAll(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int16 BSPleafCheck(pBSPDEF Bsp, pTXTOBJ Txt);
Int16 BSPleafModify(pBSPDEF Bsp, pBSPINFOS Infos, Int16 What);
Int16 BSPleafPaint(pBSPDEF Bsp, Int32 Leaf, Int8 Color);
Int16 BSPleafPaintType(pBSPDEF Bsp);
  /*
  ** Lst Surf
  */
Int16 BSPlfacInit(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int32 BSPlfacCopyAll(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int16 BSPlfacCheck(pBSPDEF Bsp, pTXTOBJ Txt);
Int16 BSPlfacPaint(pBSPDEF Bsp, Int32 Lfac, Int32 LfacNb, Int8 Color);
  /*
  ** Edges
  */
Int16 BSPedgeInit(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int32 BSPedgeCopyAll(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int16 BSPedgeCheck(pBSPDEF Bsp, pTXTOBJ Txt);
Int16 BSPedgePaintAll(pBSPDEF Bsp, Int16 Color); /*Color<0: void*/
Int16 BSPedgeLineAll(pBSPDEF Bsp, pBMPOBJ Bmp, pBOUND Bound); /*Color=0: void*/
  /*
  ** Lst Edges
  */
Int16 BSPledgInit(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int32 BSPledgCopyAll(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int16 BSPledgCheck(pBSPDEF Bsp, pTXTOBJ Txt);
  /*
  ** Hull Model
  */
Int16 BSPmodlInit(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int32 BSPmodlCopyAll(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz);
Int16 BSPmodlCheck(pBSPDEF Bsp, pTXTOBJ Txt);
Int16 BSPmodlModify(pBSPDEF Bsp, pBSPINFOS Infos, Int16 What);
Int16 BSPmodlPaint(pBSPDEF Bsp, Int32 Hull, Int8 Color);

