/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 'Q'


#include "lbwintex.h"
#include "lbcommon.h"
#include <stdlib.h>
#include "lbwad.h"

#include "lbdispl.h"
#include "lbtext.h"

#include "lbwaddef.h"
#include "lbwaddir.h"
#include "lbwadir.h"
#include "lbwadid.h"
#include "lbqklump.h"



#if (DLLFORQUAK)
/****************************************************\
*
*
* Quake WAD2 stuff
*
*
\****************************************************/
/*
** Show a Quake pic to Bmp
*/
struct QKFLATH
{ Int32 SzX;
  Int32 SzY;
};
typedef struct QKFLATH PTR *pQKFLATH;

Int16 WADqkpicToBmp(pWADDEF This, pBMPOBJ Bmp, Int16 Entry)
{ Int16 SzX,SzY;
  pQKFLATH Head;
  pInt8 Lmp;
  Int32 res,LmpSz;
  Lmp=WADreadEntryI(This,&LmpSz,Entry);
  if(Lmp==NULL)
  { return BAD_PARM; }
  if(LmpSz<sizeof(struct QKFLATH))
  { Free(Lmp); return ERRfault(BAD_ENTRY); }
  Head=(pQKFLATH)&Lmp[0];
  SzX=(Int16)Head->SzX;
  SzY=(Int16)Head->SzY;
  res = ((Int32)SzX)*((Int32)SzY) + sizeof(struct QKFLATH);
  if((SzX<=0)||(SzY<=0)||(res>LmpSz))
  { Free(Lmp); return ERRfault(BAD_ENTRY); }
#if 0
  /*Quake pics used to be very special*/
  res=BMPinitQuakPic(Bmp,Pic,PicSz);
#endif
  /*Now Quake pics are just flats*/
  res=BMPinitFlat(Bmp,&Lmp[sizeof(struct QKFLATH)],SzX,SzY);
  if(res<=0)
  { ERRfault(BAD_ENTRY);}
  Free(Lmp);
  if(res<0)
  { return (Int16)res;}
  return 1;
}
/****************************************************\
*
*
* Quake palette
*
*
\****************************************************/


/*
#!/usr/local/bin/python
# Python script to enerate palette
fp = open("palette.lmp","r"); pal = fp.read(); fp.close()
import struct
print "static Int32 WADQpaletteRGB[]="; print "{"
for pos in xrange(0, 768, 16):
  print "  0x%08xL,0x%08xL,0x%08xL,0x%08xL," % struct.unpack("llll",pal[pos:pos+16])
print "  0x0L"; print"};"
*/
static Int32 WADQpaletteRGB[]=
{
  0x0f000000L,0x1f1f0f0fL,0x4b3f3f3fL,0x4b3f3f3fL,
  0x5b5b4b4bL,0x6b6b6b5bL,0x9b9b8b8bL,0x9b9b8b8bL,
  0xababab9bL,0xcbbbbbbbL,0xebebebdbL,0xebebebdbL,
  0x17070b0fL,0x171f0b0fL,0x3713232fL,0x3713232fL,
  0x2f3f172bL,0x1b374b17L,0x4b631f43L,0x4b631f43L,
  0x1f536b1fL,0x7b1f5773L,0x236f8f23L,0x236f8f23L,
  0x130f0b0bL,0x1b1b1b13L,0x373f2f2fL,0x373f2f2fL,
  0x3f3f4b37L,0x67474757L,0x63637f5bL,0x63637f5bL,
  0x976b6b8bL,0x7ba37373L,0xcb8b8bbbL,0xcb8b8bbbL,
  0x07000000L,0x0b0b0007L,0x23001b1bL,0x23001b1bL,
  0x2b2b0023L,0x072f2f07L,0x4747073fL,0x4747073fL,
  0x0b4b4b07L,0x5b0b5353L,0x0f6b6b0bL,0x0f6b6b0bL,
  0x0f000007L,0x00170000L,0x2f000027L,0x2f000027L,
  0x00370000L,0x00003f00L,0x00570000L,0x00570000L,
  0x00005f00L,0x6f000067L,0x00007f00L,0x00007f00L,
  0x1b001313L,0x2323001bL,0x43002f37L,0x43002f37L,
  0x3b4b0037L,0x07435707L,0x53770b4bL,0x53770b4bL,
  0x1357830fL,0x97135b8bL,0x2367af1fL,0x2367af1fL,
  0x2f071323L,0x1f3b0b17L,0x63172b57L,0x63172b57L,
  0x37731f2fL,0x2b3b7f23L,0x63af334fL,0x63af334fL,
  0x2f77bf2fL,0xdf2b8fcfL,0x1bf3ff1fL,0x1bf3ff1fL,
  0x1b00070bL,0x232b0013L,0x531b3347L,0x531b3347L,
  0x3f632337L,0x33476f2bL,0x6b9b475fL,0x6b9b475fL,
  0x5f7ba753L,0xc36b87b7L,0x97b3e38bL,0x97b3e38bL,
  0x9fa38babL,0x7393977fL,0x776f5b7fL,0x776f5b7fL,
  0x4b6b6353L,0x4b3f5f57L,0x2743372fL,0x2743372fL,
  0x231f372fL,0x231b172bL,0x07070f0bL,0x07070f0bL,
  0xaf9f73bbL,0x5fa38f6bL,0x7f6b4f8bL,0x7f6b4f8bL,
  0x43735f4bL,0x4b3b6b53L,0x2347372bL,0x2347372bL,
  0x231f3b2bL,0x231b172fL,0x07070f0bL,0x07070f0bL,
  0xcbbbc3dbL,0xa3bfa7b3L,0x977b87a3L,0x977b87a3L,
  0x6f876f7bL,0x53637b5fL,0x3f533b4bL,0x3f533b4bL,
  0x27334333L,0x271f2b37L,0x070b0f0fL,0x070b0f0fL,
  0x677b836fL,0x735f6f7bL,0x4757634fL,0x4757634fL,
  0x533f4f5bL,0x3f4b3747L,0x33232f3bL,0x33232f3bL,
  0x1f2b1f27L,0x0f172317L,0x070b070bL,0x070b070bL,
  0xef1bf3ffL,0xcbdb17dfL,0xab0fa7bbL,0xab0fa7bbL,
  0x839b0b97L,0x07738b07L,0x475b0053L,0x475b0053L,
  0x00374b00L,0x2b002b3bL,0x00070b00L,0x00070b00L,
  0x0bff0000L,0x1313ef0bL,0x2bbf2323L,0x2bbf2323L,
  0x2f2faf2bL,0x8f2f2f9fL,0x2f2f6f2fL,0x2f2f6f2fL,
  0x4f2b2b5fL,0x1b3f2323L,0x0f0b0b1fL,0x0f0b0b1fL,
  0x3b00002bL,0x074b0000L,0x7f000f6fL,0x7f000f6fL,
  0x1f930717L,0x0b27a307L,0x63cf1b4bL,0x63cf1b4bL,
  0x3b7fdb2bL,0xe74f97e3L,0x8bd3f777L,0x8bd3f777L,
  0xb73b7ba7L,0xc3c7379bL,0xabffbf7fL,0xabffbf7fL,
  0xffd7ffe7L,0x000067ffL,0x00d70000L,0x00d70000L,
  0x0000ff00L,0xff93f3ffL,0x535b9fffL,0x535b9fffL,
  0x0L
};

#if 0
/*outdate qtest1 colormap, doesn't work anymore*/
static UInt8 WADQcolorMap[]=
{   0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
	16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
	32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
	 0, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
	64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
	51, 52, 53, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
	96, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,
  112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
  128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
  144,145,146,147,148,149,150,151,152,153,154,155,156,141,142,143,
  160,161,162,163,164,165,166,167,168,169,170,171,172,173,174, 16,
  176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
  111,193,194,195,196,197,198,199,200,201,202,203,204,205,206,112,
  208,209,210,211,212,213,214,215,216,217,218,219,220,221,222, 32,
  224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
  240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255
};
#endif

pInt8 WADQpalGetLmp(Int16 PalSz)
{
  Int16 PalNb;
  pRGB  Pal;
  pRGB  PalOrg=(pRGB)WADQpaletteRGB;
  PalNb= PalSz/sizeof(RGB);
  if((PalNb<0)||(PalNb>0x100))
  { return NULL;}
  Pal=(pRGB)Malloc(PalSz); /* >= PalNb*sizeof(RGB)*/
  if(Pal==NULL) return NULL;
#if 0
  /*use colormap*/
  Int16 n,mapped;
  for(n=0; n<PalNb; n++)
  {
	 mapped =  ((Int16)WADQcolorMap[n])&0xFF;
	 Memcpy(&Pal[n],&PalOrg[mapped],sizeof(RGB));
  }
#else
  Memcpy(&Pal[0],PalOrg,PalNb*sizeof(RGB));
#endif
  return (pInt8)Pal;
}




#endif /*DLLFORQUAK*/