/****************************************************\
*
*
* WAD OBJECT INTERNAL PATCH CACHEING AND NUMBERING API
*    This API shall only be used for Texture editing
*
\****************************************************/

/*
** Note: this module sucks too much memory, because it
** never release any cached patch, until end of texture
** editing. only a limited nb of patch should be used.
*/
#if (DLLFORDOOM)
	/*
   ** Start cacheing patches
   */
Int16 WADPinitI(pTXPOBJ Txp, pWADDEF This);
	/*
	** Find/declare a new patch name
	*/
Int16 WADPaddI(pTXPOBJ Txp, pInt8 Name);
	/*
	** Tell name of a patch, referenced by Pat
	*/
Int16 WADPtellI(pTXPOBJ Txp, pInt8 Name, Int16 Pat);
	/*
	** Declare no patch is used (xcept those in IWAD)
	*/
Int16 WADPusedNoneI(pTXPOBJ Txp);
	/*
	** Declare patch of name Name is used, returns Id
	*/
Int16 WADPusedNameI(pTXPOBJ Txp, pInt8 Name);
	/*
	** Ensure that Bmp is cached, because patch will be needed
	*/
pInt8 WADPcacheBmpI(pTXPOBJ Txp,pWADDEF This, pBMPOBJ Bmp, pInt8 Name);
	/*
	** Get Bmp associated to patch, returns bytes, (SzX,SzY)
	*/
pInt8 WADPgetBmpI(pTXPOBJ Txp, pInt8 Name, pInt16 pSzX,pInt16 pSzY);
	/*
	** Save all patches to the WAD, in PNAMES
	** Create PNAMES if it doesn't exist
	*/
Int16 WADPsaveAllI(pTXPOBJ Txp, pWADDEF This);
	/*
	** Stop cacheing patches
	*/
Int16 WADPfreeI(pTXPOBJ Txp);

/****************************************************\
*
*
* WAD OBJECT INTERNAL TEXTURE PATCH LIST  API
*    This API shall only be used for Texture editing
*
\****************************************************/

/*
** texture ident:   OLD/NEW/REPL + TEX1/TEX2
*/
#define TEXOLD (0x00)
#define TEXNEW (0x10)
#define TEXRDF (0x20)
#define TEXMASK (0xF0) /*for which*/
  /*
  ** Init patch list, from Doompatch, if not NULL
  */
pTEXPAT WADKinitI(pTXPOBJ Txp, pDMPATCH DmPat,Int16 DmPatSz);
  /*
  ** Length of patch list
  */
Int16 WADKlengthI(pTEXPAT TexP);
  /*
  ** Add patch
  */
pTEXPAT WADKaddPatI(pTXPOBJ Txp, pTEXPAT TexP,pInt8 Name, Int16 OfsX, Int16 OfsY);
  /*
  ** Get patch
  */
Int16 WADKgetPatI(pTEXPAT TexP,Int16 idx,pInt8 Name,pInt16 pOfsX, pInt16 pOfsY);
  /*
  ** Set patch
  */
Int16 WADKsetPatI(pTXPOBJ Txp, pTEXPAT TexP,Int16 idx,pInt8 Name, Int16 OfsX, Int16 OfsY);
  /*
  ** Delete patch
  */
pTEXPAT WADKdelPatI(pTEXPAT TexP,Int16 idx);
  /*
  ** Free patch list
  */
void WADKfreeI(pTEXPAT TexP);
  /*
  ** Duplicate patch list
  */
pTEXPAT WADKduplicateI(pTEXPAT TexP);
  /*
  ** Compare. returns >0 if equal
  */
Int16 WADKcmpI(pTEXPAT TexP, pTEXPAT TexQ);
  /*
  ** Copy
  */
Int16 WADKcopyI(pTXPOBJ Txp, pDMPATCH DmPat, pTEXPAT TexP);



/*
**
** WAD OBJECT PATCH EXTERNAL API
**
*/
	/*Display PNAMES lump*/
Int16 WADPshowPnameI(pWADDEF This,Int16 Entry, pWINDOZE hLst);
#endif /*DLLFORDOOM*/

