/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 'U'

#include "lbwintex.h"
#include "lbcommon.h"
#include "lbwad.h"
#include "lbdoom.h"
/*windows music*/
#if defined __WINDOWS__
#include <windows.h>
#include <mmsystem.h>
#endif
#include <fcntl.h>
#include <io.h>

#include "lbmusic.h"


/*1 for MUS player, 0 for MIDI player, 2 for SNDPLAY*/
#define MUSPLAYER 1


/****************************************************\
*
*
*  Quick MUS2MIDI Filter
*
*
\****************************************************/


#if (DLLFORDOOM)
/*#include "wmus2mid.h"*/
pInt8 qmus2mid(pInt32 midsize, const pInt8 musdata, Int32 mussize,  Int16 division, Int32 BufferSize, Int16 nocomp );
/*
** Save MUS file
*/
Int16 MUSsaveMidi(pInt8 Lmp,Int32 LmpSz,pInt8 File)
{
  pInt8 Mid ;
  Int32 MidSz ;
  Int32 res;
  Mid = qmus2mid(&MidSz, Lmp, LmpSz, 0, 0, 0 ) ;
  if( Mid==NULL )
  {
	 return BAD_ENTRY;
  }
  res= FILEwriteData(Mid,0,MidSz,File);
  Free(Mid);
  if(res<0) return (Int16)res;
  return 1;
}

/****************************************************\
*
*
* MUS PLayer
*
*
\****************************************************/

#if (MUSPLAYER == 1)
#include "muslib.h"
/* MUS file header structure */
struct DMMUSHEAD {
	Int32	Ident;         /* identifier "MUS" 0x1A  */
	Int16	ScoreLen;      /* score length           */
	Int16	ScoreStart;    /* score start            */
	Int16	Channels;      /* primary channels       */
	Int16	Sec_channels;  /* secondary channels (??)*/
	Int16   InstrCnt;      /* used instrument count  */
	Int16	Dummy;
/*
	Int16	Instruments[...];	// table of used instruments
*/
};
typedef struct DMMUSHEAD PTR *pDMMUSHEAD;
/*
*/
static int MIDIdeviceID = MIDI_MAPPER;
static int MIDItimer = TIMER_WIN70;
static int MUShandle = -1;
static int MUSready = 0;
/*
** Init
*/
void MUSinit(void)
{
  MLinit(0/*(uint)hInstance*/);
  MLaddDriver(&WINdriver);
}
/*
** Stop
*/
Int16 MUSstop(void)
{
  if (MUShandle >= 0)
  { /*
	 ** stop music
	 */
	 MLstop(MUShandle);
	 MLfreeHandle(MUShandle);
	 MUShandle=-1;
  }
  /*
  ** deinit
  */
  if (MUSready)
  {
	 MLdeinitHardware(DRV_WINDOWS);
	 MLshutdownTimer();
	 MUSready = 0;
  }
  return 0;
}
/*
**  play a music
*/
Int16 MUSplay(pInt8 File,Int32 Start,Int32 Size)
{
  int fd;
  int res;
  if(Size<1) return ERR_SURE;

  /*
  ** Shutdown previous music
  */
  MUSstop();
  /*
  ** Initialise, if needed
  */
  if(MUSready!=1)
  {
	 /* initialize timer and sound hardware */
	 if(MLinitTimer(MIDItimer))
	 {
		return ERRfault(ERR_SURE);
	 }
	 res=MLinitHardware(DRV_WINDOWS, MIDIdeviceID, -1, -1);
	 if(res<0)
	 {
		MLshutdownTimer();
		return ERRfault(ERR_SURE);
	 }
	 MUSready = 1;
  }
  /* load MUS file */
  /* the file must be open in binary mode */
  Strncpy(Buff,File,MAXBUFFSZ-1);
  fd = open(Buff, O_RDONLY | O_BINARY);

  if(fd < 0)
  {
	 return ERRfault(BAD_FILE);
  }
  /* position file*/
  lseek(fd,Start,SEEK_SET);
  /*get handle*/
  MUShandle = MLallocHandle(DRV_WINDOWS);
  if(MUShandle<0)
  {
	 return ERRfault(ERR_BUG);
  }
  /*load music*/
  res=MLloadMUS(MUShandle, fd, 0xFFFF);
  close(fd);
  if(res)
  {
	  return ERRfault(BAD_ENTRY);
  }
  return MLplay(MUShandle);
}





#elif (MUSPLAYER==0)
/*
** Currently playing MIDI data
*/
HMIDIOUT MIDdev=NULL;  /*MIDI device*/
GLOBALHANDLE MIDdtaH=NULL;
GLOBALHANDLE MIDhdrH=NULL;
LPMIDIHDR    MIDhdr=NULL;

void MUSinit(void)
{ return;
}
/*
** Stop MIDI
*/
Int16 MUSstop(void)
{ Int16 res;

  if(MIDdev!=NULL)
  { /*stop MIDI play*/
	 res=midiOutReset(MIDdev);
	 if(res!=0) return ERR_BUG;
	 if(MIDhdrH!=NULL)
	 {
		/*unlink MIDI header*/
		res= midiOutUnprepareHeader(MIDdev,MIDhdr,sizeof(MIDIHDR));
		if(res!=0) return ERR_BUG;
	 }
	 /*close device*/
	 midiOutClose(MIDdev);
	 MIDdev=NULL;
  }
  if(MIDhdrH!=NULL) GlobalFree(MIDhdrH);
  MIDhdrH=NULL;
  if(MIDdtaH!=NULL) GlobalFree(MIDdtaH);
  MIDdtaH=NULL;
  return 1;
}
/*
** MUS lib
*/
#define MIDI_PERC	9	/* standard MIDI percussion channel */
#define MIDI_CONTROL	0xB0	// control change, <controller>, <value>
#define CTRL_VOLUME  7
#define MIDI_SYSEX	0xF0	// start of System Exclusive sequence
#define MIDI_SYSEX2	0xF7	// System Exclusive sequence continue
Int16 MIDsendMsg(Int16 command, Int16 par1, Int16 par2)
{
	/* UInt8 event = command & MIDI_EVENT_MASK;*/
	return midiOutShortMsg(MIDdev,
	  (BYTE)command
	  | ((WORD)((BYTE)par1) << 8)
	  | ((DWORD)((BYTE)par2) << 16));
}
/*
** Play a MIDI file
*/
Int16 MUSplay(pInt8 File,Int32 Start,Int32 LmpSz)
{
  pInt8 Mid,Dta;
  Int32 MidSz;
  Int16 NbDevs;
  pInt8 Lmp;
  Int16 MidiOffs=0x68;
  /*
  ** Exit if no MIDI devices
  */
  NbDevs=midiOutGetNumDevs();
  if(NbDevs<1) return ERR_BUG; /*no midi device*/
  /*
  ** Clear MIDI data
  */
  MUSstop();
  /*
  ** read Lmp
  */
  Lmp=Malloc(LmpSz);
  if(Lmp==NULL) return ERR_MEM;
  if(FILEreadData(Lmp,Start,LmpSz,File)<0) return BAD_FILE;
  /*
  ** Get MIDI data
  */
  Mid = qmus2mid(&MidSz, Lmp, LmpSz, 0, 0, 0 ) ;
  Free(Lmp);
  if( Mid==NULL ) return BAD_ENTRY;
  /*
  ** Allocate shared MIDI data
  */
  MIDdtaH = GlobalAlloc(GMEM_MOVEABLE|GMEM_SHARE,MidSz);
  if(MIDdtaH==NULL) return  ERR_MEM;
  Dta = GlobalLock(MIDdtaH);
  if(Dta==NULL) return  ERR_MEM;
  /*
  ** Copy MIDI data
  */
  Memcpy(Dta,&Mid[MidiOffs],MidSz-MidiOffs);
  Free(Mid);
  /*
  ** Allocate shared MIDI header
  */
  MIDhdrH= GlobalAlloc(GMEM_MOVEABLE|GMEM_SHARE,sizeof(MIDIHDR));
  if(MIDhdrH==NULL) return  ERR_MEM;
  MIDhdr = (LPMIDIHDR)GlobalLock(MIDhdrH);
  if(MIDhdr==NULL) return  ERR_MEM;
  /*
  ** open a device: MIDI_MAPPER
  */
  midiOutOpen(&MIDdev,MIDI_MAPPER,NULL,NULL,0);
  /*
  ** prepare MIDI header
  */
  MIDhdr->lpData = (LPSTR)Dta;
  MIDhdr->dwBufferLength = MidSz;
  midiOutPrepareHeader(MIDdev,MIDhdr,sizeof(MIDIHDR));
  /*
  ** play
  */
  MIDsendMsg(MIDI_PERC|MIDI_CONTROL,CTRL_VOLUME,127);
  midiOutLongMsg(MIDdev,MIDhdr,sizeof(MIDIHDR));
  return 1;
}
#else
static pInt8 MUSdta=NULL;
void MUSinit(void)
{
  return;
}
/*
** Stop MIDI
*/
Int16 MUSstop(void)
{
  sndPlaySound(NULL,0);
  if(MUSdta!=NULL) Free(MUSdta);
  MUSdta=NULL;
  return 1;
}

/*
** Play a MIDI file
*/
Int16 MUSplay(pInt8 File,Int32 Start,Int32 LmpSz)
{
  pInt8 Mid;
  Int32 MidSz;
  pInt8 Lmp;
  /*
  ** Clear MIDI data
  */
  MUSstop();
  /*
  ** read Lmp
  */
  Lmp=Malloc(LmpSz);
  if(Lmp==NULL) return ERR_MEM;
  if(FILEreadData(Lmp,Start,LmpSz,File)<0) return BAD_FILE;
  /*
  ** Get MIDI data
  */
  Mid = qmus2mid(&MidSz, Lmp, LmpSz, 0, 0, 0 ) ;
  Free(Lmp);
  if( Mid==NULL ) return BAD_ENTRY;
  /*dangerous*/
  if(!sndPlaySound((LPSTR)Mid,SND_ASYNC|SND_MEMORY))
  { ERRfault(BAD_DATA);}
  /*forget Mid*/
  MUSdta=Mid;
  return 1;
}
#endif /*MUSPLAY*/

#endif /*DLLFORDOOM*/
