/*
** Color palettes in WADs or PODs: RGB[256]
*/
typedef struct { Int8 R; Int8 G; Int8 B;} RGB;
typedef RGB PTR *pRGB;
/*
** Big Endian Little Endian
*/
Int16 SwapInt16(Int16 Val);
Int32 SwapInt32(Int32 Val);
float SwapFloat(float Val);
#if defined(__MSDOS__) || defined(Windows)
/* WARNING: actually i486 is Little Endian, not big endian. this is my mistake */
#define Int32BE(a)  (a)
#define Int16BE(a) (a)
#define FloatBE(a) (a)
#define Int32LE(a)  SwapInt32(a)
#define Int16LE(a) SwapInt16(a)
#define FloatLE(a) SwapFloat(a)
#else
#error "Only Little Endian processors"
#endif
/*
** Common Error Types
*/
#define FINISHED   -1
#define ERR_SURE   -2
#define ERR_BUG    -3
#define ERR_MEM    -4
#define ERR_OBJREF -5
#define BAD_PARM   -6
#define BAD_SIZE   -7
#define BAD_FILE   -8
#define BAD_HEAD   -9
#define BAD_ENTRY  -10
#define BAD_DATA   -11
#define BAD_WIN    -12
#define BAD_WIN1   -13
#define BAD_WIN2   -14
#define BAD_PICSZ  -15
#define BAD_NBIT   -16
#define BAD_HDRBMP -17
#define BAD_DIBBMP -18
#define BAD_DIBPAL -19
#define BAD_NORGB  -20
#define BAD_EXTENS -21
#define ERR_BADFMT  -22
#define ERR_NOT8BIT -23
#define ERR_NOTMONO -24
#define ERR_NOTSRAW -25
#define ERR_BADSND  -26
#define ERR_BADVOC  -27
#define ERR_STRUCT  -28
#define ERR_VERSION -29
/*
** ErrorHandling (this sucks, I know)
*/
	 /*
	 ** ordinary error macro
	 */
#define ERRfault(a) ERRfaultC(__LINE__,a,WINTEXMODULE)
	 /*
	 ** To be used only by the error macro.
	 */
Int16 ERRfaultC(Int16 line,Int16 type, Int8 Module);
	 /*
	 ** Control error reporting
	 ** ok = if TRUE, stop error report
	 **      if FALSE, report errors
	 */
void ERRquiet(Int16 ok);
	 /*
	 ** To be used only by error handlers
	 */
Int16 ERRdeclare(Int8 **Txt,Int16 type,Int16 line, Int8 module);
	 /*
	 ** To be used only by GetThis()
	 */
void ERRsetWnd(Int32 Wnd);
/*
** This string is used as a single temp name buffer
** in every function of WinTex. Don't rely on the
** contents of Path.
*/
#define MAXBUFFSZ (256)
extern Int8 Buff[MAXBUFFSZ];

/*
** Memory Handling
*/
	 /*
	 ** Malloc (GlobalAlloc, Locked)
	 */
pVoid Malloc(Int32 Size);
	 /*
	 ** Malloc for sndPlaySound
	 */
pVoid MallocSpecial(Int32 Size);
	 /*
	 ** Calloc (GlobalAlloc, Fixed, Cleared)
	 */
pVoid Calloc(Int32 Nb, Int32 Size);
	 /*
	 ** Realloc (GlobalRealloc, Fixed)
	 */
pVoid Realloc(pVoid Data,Int32 Size);
	 /*
	 ** Free (GlobalFree)
	 */
void Free(pVoid Data);
	 /*
	 ** Get the size of the memory object
	 */
Int32 Memsize(pVoid Data);
	 /*
	 ** Unlock memory, so that it can be swapped
	 ** (can be a dummy function, on real O/S)
	 */
Int32 Unlock(pVoid Data);
	 /*
	 ** Lock memory, so that it can be swapped
	 ** (can be a dummy function, on real O/S)
	 */
pVoid Lock(Int32 DataH);
	 /*
	 ** Copy memory (MUST NOT BE OVERLAPPING)
	 */
Int16 Memcpy(pVoid Data,pVoid Src,Int32 Size);
	 /*
	 ** Set Memory
	 */
Int16 Memset(pVoid Data,Int8 Src,Int32 Size);
	 /*
	 ** Set Memory, 4 bytes at the time
	 */
Int16 MemsetL(pVoid Data,Int8 Src,Int32 Size);
/*
** String handling
*/
	 /*
	 ** String matching, case insensitive
	 **   Size = max lenght compared
	 ** returns >0 if start of Data is like Match
	 */
Int16 Strmatch(pInt8 Data,pInt8 Match,Int16 Size);
	 /*
	 ** String comparison, case insensitive
	 **   Size= max length compared
	 ** returns >0 if strings Data and Match are the same
	 */
Int16 Strncmpi(pInt8 Data,pInt8 Match,Int16 Size);
	 /*
	 ** String comparison, case sensitive
	 **   Size= max length compared
	 ** returns >0 if strings Data and Match are the same
	 */
Int16 Strncmp(pInt8 Data,pInt8 Match,Int16 Size);
	 /*
	 ** Copy string, of fixed length
	 **  Dest = Buffer
	 **  Src = Source string
	 **  Size = size of buffer, INCLUDES ending '\0'
	 */
pInt8 Strncpy(pInt8 Dest, pInt8 Src, Int16 Size);
	 /*
	 ** Copy string
	 */
pInt8 Strcpy(pInt8 Dest, pInt8 Src);
	 /*
	 ** Append string
	 */
pInt8 Strcat(pInt8 Dest, pInt8 Src);
	 /*
	 ** Append Number
	 */
pInt8 StrcatNum(pInt8 Dest, Int32 Nb, Int16 Base);
	 /*
	 ** Length of string
	 **  Max = max length tolerated.
	 */
Int16 Strlen(pInt8 Src, Int16 Max);
/*
** Normalise text entries
*/
	 /*
	 ** Cleanup a name, remove spaces and non-printables
	 ** Pad with zeroes, return size
	 **  Dest[NORMALISELEN]
	 */
Int16 Normalize(pInt8 Dest);
Int16 Normalise(pInt8 Dest,pInt8 Src);
	 /*
	 ** Cleanup name
	 ** Pad with white space, return size
	 ** Dest[NORMALISELEN+2]
	 */
Int16 NormalizeS(pInt8 Dest,pInt8 Src);
	 /*
	 ** print a 4-digit number, space padded, return size
	 ** Dest[4+1]
	 */
Int16 NormalizeN(pInt8 Dest,Int16 nb);


/*
** FILE functions
*/
	/*
	** if not Dir return >0 if file exists
	** if Dir return >0 if directory exist
	*/
Bool FILEexist(pInt8 File, Bool Dir);
	/*
   ** Open a file, ONE at the time, for reading
   */
Int16 FILEopen(pInt8 File,Int16 Mode);
#define FCREATE (0) /*Mode*/
#define FMODIFY (1) /*Mode*/
#define FREAD   (2) /*Mode*/
   /*
   ** Read data from opened file to buffer
   **  Data = buffer
   **  Start = position (-1 means last position)
   **  Size = size of buffer
	*/
Int32 FILEread(pInt8 Data,Int32 Start,Int32 Size);
	/*
	** Write data from buffer to opened file
	**  Data = buffer
	**  Start = position (-1 means last position)
	**  Size = size of buffer
	*/
Int32 FILEwrite(pInt8 Data,Int32 Start,Int32 Size);
	/*
	** close file
	*/
Int16 FILEclose(void);
	/*
	** atomic read: open file, read data, close
	*/
Int32 FILEreadData(pInt8 Data,Int32 Start,Int32 Size, pInt8  File);
Int32 FILEreadText(pInt8 Data,Int32 Start,Int32 Size, pInt8  File);	/*
	** atomic write: open file, write data, close
	*/
Int32 FILEwriteData(pInt8 Data,Int32 Start,Int32 Size, pInt8  File);
Int32 FILEwriteText(pInt8 Data,Int32 Start,Int32 Size, pInt8  File);
	/*
	** Get the file time stamp.
	*/
Int32 FILEgetTime(pInt8  File);
	/*
	** Set the file time stamp.
	*/
void FILEsetTime(pInt8  File, Int32 Time);
	/*
	** Get the size of the file
	*/
Int32 FILEgetSize(pInt8  File);
	/*
	** Set the size of the file
	*/
Int16 FILEsetSize(pInt8  File, Int32 Size);







