// specials.c
// (c) Luc Cluitmans 1995

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "wadentry.h"
#include "opcode.h"
#include "specials.h"
#include "goutput.h"

typedef struct tagSpecial
{
    WORD    wId;
    char    *szName;
    char    *szType; // can be NULL
} Special;

Special _specials[] =
{
    {0, "No_Op", "00000"},
    {1, "Polyobj_StartLine", "00n00"},
    {2, "Polyobj_RotateLeft", "00000"},
    {3, "Polyobj_RotateRight", "00000"},
    {4, "Polyobj_Move", "00000"},
    {5, "Polyobj_ExplicitLine", "00000"},
    {6, "Polyobj_MoveTimes8", "00000"},
    {7, "Polyobj_DoorSwing", "00000"},
    {8, "Polyobj_DoorSlide", "00000"},

    {10, "Door_Close", "00000"},
    {11, "Door_Open", "00000"},
    {12, "Door_Raise", "00000"},
    {13, "Door_LockedRaise", "000k0"},

    {20, "Floor_LowerByValue", "00000"},
    {21, "Floor_LowerToLowest", "00000"},
    {22, "Floor_LowerToNearest", "00000"},
    {23, "Floor_RaiseByValue", "00000"},
    {24, "Floor_RaiseToHighest", "00000"},
    {25, "Floor_RaiseToNearest", "00000"},
    {26, "Stairs_BuildDown", "00000"},
    {27, "Stairs_BuildUp", "00000"},
    {28, "Floor_RaiseAndCrush", "00000"},
    {29, "Pillar_Build", "00000"},
    {30, "Pillar_Open", "00000"},
    {31, "Stairs_BuildDownSync", "00000"},
    {32, "Stairs_BuildUpSync", "00000"},

    {35, "Floor_RaiseByValueTimes8", "00000"},
    {36, "Floor_LowerByValueTimes8", "00000"},

    {40, "Ceiling_LowerByValue", "00000"},
    {41, "Ceiling_RaiseByValue", "00000"},
    {42, "Ceiling_CrushAndRaise", "00000"},
    {43, "Ceiling_LowerAndCrush", "00000"},
    {44, "Ceiling_CrushStop", "00000"},
    {45, "Ceiling_CrushRaiseAndStay", "00000"},
    {46, "Floor_CrushStop", "00000"},

    {60, "Plat_PerpetualRaise", "00000"},
    {61, "Plat_Stop", "00000"},
    {62, "Plat_DownWaitUpStay", "00000"},
    {63, "Plat_DownByValue", "00000"},
    {64, "Plat_UpWaitDownStay", "00000"},
    {65, "Plat_UpByValue", "00000"},
    {66, "Floor_LowerInstant", "00000"},
    {67, "Floor_RaiseInstant", "00000"},
    {68, "Floor_MoveToValueTimes8", "000B0"},
    {69, "Ceiling_MoveToValueTimes8", "000B0"},
    {70, "Teleport", "T0000"},
    {71, "Teleport_NoFog", "T0000"},
    {72, "ThrustThing", "00000"},
    {73, "DamageThing", "00000"},
    {74, "Teleport_NewMap", "m0000"},
    {75, "Teleport_EndGame", "00000"},

    {80, "ACS_Execute", "0m000"},
    {81, "ACS_Suspend", "0m000"},
    {82, "ACS_Terminate", "0m000"},
    {83, "ACS_LockedExecute", "0m00k"},

    {90, "Polyobj_OR_RotateLeft", "00000"},
    {91, "Polyobj_OR_RotateRight", "00000"},
    {92, "Polyobj_OR_Move", "00000"},
    {93, "Polyobj_OR_MoveTimes8", "00000"},
    {94, "Pillar_BuildAndCrush", "00000"},
    {95, "FloorAndCeiling_LowerByValue", "00000"},
    {96, "FloorAndCeiling_RaiseByValue", "00000"},

    {100, "Scroll_Texture_Left", "00000"},
    {101, "Scroll_Texture_Right", "00000"},
    {102, "Scroll_Texture_Up", "00000"},
    {103, "Scroll_Texture_Down", "00000"},

    {109, "Light_ForceLightning", "00000"},
    {110, "Light_RaiseByValue", "00000"},
    {111, "Light_LowerByValue", "00000"},
    {112, "Light_ChangeToValue", "00000"},
    {113, "Light_Fade", "00000"},
    {114, "Light_Glow", "00000"},
    {115, "Light_Flicker", "00000"},
    {116, "Light_Strobe", "00000"},

    {120, "Radius_Quake", "0000T"},
    {121, "Line_SetIdentification", "00000"},

    {129, "UsePuzzleItem", "p0000"},
    {130, "Thing_Activate", "T0000"},
    {131, "Thing_Deactivate", "T0000"},
    {132, "Thing_Remove", "T0000"},
    {133, "Thing_Destroy", "T0000"},
    {134, "Thing_Projectile", "Tt000"},
    {135, "Thing_Spawn", "Tt000"},
    {136, "Thing_ProjectileGravity", "Tt000"},
    {137, "Thing_SpawnNoFog", "Tt000"},
    {138, "Floor_Waggle", "00000"},

    {140, "Sector_ChangeSound", "0n000"}
};

#define CNT_SPECIAL (sizeof(_specials)/sizeof(_specials[0]))

static int spidxinit = 0; // FALSE
static int spidx[256]; // initialized by InitSpecial()

static void InitSpecial(void)
{
    WORD w;

    if(!spidxinit)
    {
        for(w=0; w<256; w++)
        {
            spidx[w] = -1; // mark as invalid
        }
        for(w=0; w<CNT_SPECIAL; w++)
        {
            spidx[_specials[w].wId] = w;
        }
        spidxinit = 1;
    }
}

char *SpecialName(WORD wSpc)
  // returns NULL on failure
  // and puts errorstring in Goutput buffer
{
    if(!spidxinit) InitSpecial();
    if(wSpc>256 || spidx[wSpc]==-1)
    {
        ClearStringBuffer();
        AccumulateString("FATAL: invalid special index %d", wSpc);
        return(NULL);
    }
    return(_specials[spidx[wSpc]].szName);
}

char *SpecialArgs(WORD wSpc)
  // returns NULL on failure
{
    if(!spidxinit) InitSpecial();
    if(wSpc>256 || spidx[wSpc]==-1)
    {
        return(NULL);
    }
    return(_specials[spidx[wSpc]].szType);
}

// EOF
