VERSION 2.00
Begin Form EdtTextu 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Texture"
   ClientHeight    =   6765
   ClientLeft      =   360
   ClientTop       =   390
   ClientWidth     =   8505
   ClipControls    =   0   'False
   Height          =   7140
   HelpContextID   =   400
   Icon            =   EDTTEXTU.FRX:0000
   Left            =   315
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   6765
   ScaleWidth      =   8505
   Top             =   60
   Width           =   8595
   Begin CommandButton CmdOk 
      Caption         =   "Save"
      Height          =   315
      Left            =   3120
      TabIndex        =   41
      Top             =   2460
      Width           =   735
   End
   Begin TextBox TexuFile 
      Height          =   285
      Left            =   180
      TabIndex        =   35
      Text            =   "NEWTEX"
      Top             =   6360
      Width           =   1515
   End
   Begin CommandButton CmdDelete 
      Caption         =   "Delete Tex"
      Height          =   315
      Left            =   1800
      TabIndex        =   33
      Top             =   5580
      Width           =   1095
   End
   Begin CommandButton CmdEditTex 
      Caption         =   "Edit File"
      Height          =   315
      Left            =   1800
      TabIndex        =   6
      Top             =   6360
      Width           =   1095
   End
   Begin CommandButton CmdOld 
      Caption         =   "Import Tex"
      Height          =   315
      Left            =   1800
      TabIndex        =   7
      Top             =   4860
      Width           =   1095
   End
   Begin SSFrame PatchFrame 
      Alignment       =   1  'Right Justify
      Caption         =   "Patches in Texture"
      Font3D          =   0  'None
      ForeColor       =   &H00000000&
      Height          =   2175
      Left            =   3060
      TabIndex        =   22
      Top             =   2880
      Width           =   3315
      Begin CommandButton CmdMove 
         Caption         =   "Move"
         Height          =   315
         Index           =   6
         Left            =   780
         TabIndex        =   44
         Top             =   1440
         Width           =   795
      End
      Begin SSCheck ChkSpeed 
         Caption         =   "+16"
         Font3D          =   0  'None
         Height          =   255
         Left            =   1020
         TabIndex        =   43
         Top             =   780
         Width           =   615
      End
      Begin ListBox LPatches 
         BackColor       =   &H00C0C0C0&
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   1710
         Left            =   1740
         TabIndex        =   28
         Top             =   360
         Width           =   1395
      End
      Begin CommandButton CmdMove 
         Caption         =   "Bring in Front"
         Height          =   315
         Index           =   4
         Left            =   120
         TabIndex        =   21
         Top             =   1080
         Width           =   1455
      End
      Begin CommandButton CmdMove 
         Caption         =   "Delete"
         Height          =   315
         Index           =   5
         Left            =   780
         TabIndex        =   27
         Top             =   1800
         Width           =   795
      End
      Begin CommandButton CmdMove 
         Caption         =   "Dn"
         Height          =   315
         Index           =   1
         Left            =   540
         TabIndex        =   26
         Top             =   720
         Width           =   435
      End
      Begin CommandButton CmdMove 
         Caption         =   "Lft"
         Height          =   315
         Index           =   2
         Left            =   120
         TabIndex        =   25
         Top             =   420
         Width           =   435
      End
      Begin CommandButton CmdMove 
         Caption         =   "Rgt"
         Height          =   315
         Index           =   3
         Left            =   960
         TabIndex        =   24
         Top             =   420
         Width           =   435
      End
      Begin CommandButton CmdMove 
         Caption         =   "Up"
         Height          =   315
         Index           =   0
         Left            =   540
         TabIndex        =   23
         Top             =   120
         Width           =   435
      End
      Begin Image PCenter 
         BorderStyle     =   1  'Fixed Single
         Height          =   510
         Left            =   180
         Picture         =   EDTTEXTU.FRX:0302
         Top             =   1560
         Width           =   510
      End
   End
   Begin SSFrame TexuFrame 
      Caption         =   "Textures in File"
      Font3D          =   0  'None
      ForeColor       =   &H00000000&
      Height          =   1575
      Left            =   3060
      TabIndex        =   9
      Top             =   5100
      Width           =   3315
      Begin ListBox TexuNew 
         BackColor       =   &H00C0C0C0&
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "Courier"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H00000000&
         Height          =   1200
         Left            =   180
         TabIndex        =   10
         Top             =   300
         Width           =   2955
      End
   End
   Begin SSFrame TexOFrame 
      Caption         =   "Old Texture"
      Font3D          =   0  'None
      ForeColor       =   &H00000000&
      Height          =   1515
      Left            =   120
      TabIndex        =   15
      Top             =   2880
      Width           =   2835
      Begin ListBox TexuOld 
         BackColor       =   &H00808080&
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "Courier"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   1200
         Left            =   120
         TabIndex        =   20
         Top             =   240
         Width           =   2595
      End
   End
   Begin SSFrame StockFrame 
      Font3D          =   0  'None
      ForeColor       =   &H00000000&
      Height          =   3795
      Left            =   6480
      TabIndex        =   29
      Top             =   2880
      Width           =   1995
      Begin ListBox EntryName 
         BackColor       =   &H00808080&
         Height          =   1590
         HelpContextID   =   700
         Left            =   180
         TabIndex        =   31
         Top             =   2100
         Width           =   1635
      End
      Begin FileListBox Patches 
         BackColor       =   &H00808080&
         Height          =   1395
         HelpContextID   =   700
         Left            =   180
         Pattern         =   "*.bmp"
         TabIndex        =   30
         Top             =   360
         Width           =   1635
      End
      Begin Label Info 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         Caption         =   "Redefined Patches"
         ForeColor       =   &H00800000&
         Height          =   195
         Index           =   3
         Left            =   120
         TabIndex        =   38
         Top             =   120
         Width           =   1815
      End
      Begin Label Info 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         Caption         =   "Patches in main WAD"
         ForeColor       =   &H00800000&
         Height          =   195
         Index           =   5
         Left            =   60
         TabIndex        =   32
         Top             =   1860
         Width           =   1875
      End
   End
   Begin SSFrame TexVisu 
      Caption         =   "Texture"
      Font3D          =   0  'None
      ForeColor       =   &H00000000&
      Height          =   2835
      Left            =   120
      TabIndex        =   14
      Top             =   0
      Width           =   8355
      Begin Frame PicFrame 
         BackColor       =   &H00C0C0C0&
         ClipControls    =   0   'False
         Height          =   1935
         Left            =   180
         TabIndex        =   45
         Top             =   480
         Width           =   7695
         Begin PictureBox TexuB 
            AutoRedraw      =   -1  'True
            BackColor       =   &H00FFFF00&
            BorderStyle     =   0  'None
            Height          =   1935
            Left            =   0
            MousePointer    =   2  'Cross
            ScaleHeight     =   1935
            ScaleWidth      =   7710
            TabIndex        =   46
            Top             =   0
            Width           =   7710
            Begin PictureBox PicB 
               BackColor       =   &H00FFFF00&
               BorderStyle     =   0  'None
               DrawStyle       =   5  'Transparent
               Enabled         =   0   'False
               Height          =   1935
               Left            =   3600
               ScaleHeight     =   1935
               ScaleWidth      =   4155
               TabIndex        =   47
               Top             =   0
               Visible         =   0   'False
               Width           =   4155
            End
         End
      End
      Begin HScrollBar TexOfs 
         Height          =   240
         Left            =   1020
         Max             =   -512
         TabIndex        =   42
         Top             =   180
         Visible         =   0   'False
         Width           =   1755
      End
      Begin CommandButton CmdNewTex 
         Caption         =   "New"
         Height          =   315
         Left            =   2160
         TabIndex        =   40
         Top             =   2460
         Width           =   735
      End
      Begin ComboBox Ident 
         Height          =   300
         Left            =   4500
         TabIndex        =   36
         TabStop         =   0   'False
         Text            =   "HELP Ident"
         Top             =   2460
         Width           =   3735
      End
      Begin VScrollBar TexuHeight 
         Height          =   1935
         LargeChange     =   16
         Left            =   7980
         Max             =   128
         Min             =   8
         TabIndex        =   3
         Top             =   480
         Value           =   128
         Width           =   240
      End
      Begin HScrollBar TexuWidth 
         Height          =   240
         LargeChange     =   2
         Left            =   4980
         Max             =   11
         Min             =   2
         TabIndex        =   8
         Top             =   180
         Value           =   9
         Width           =   1770
      End
      Begin Label Info 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         Caption         =   "Composing Textures"
         ForeColor       =   &H00800000&
         Height          =   255
         Index           =   4
         Left            =   180
         TabIndex        =   39
         Top             =   2520
         Width           =   1815
      End
      Begin Label Info 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         Caption         =   "Name"
         ForeColor       =   &H00800000&
         Height          =   195
         Index           =   2
         Left            =   3840
         TabIndex        =   37
         Top             =   2520
         Width           =   615
      End
      Begin Label TxHeight1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "128"
         ForeColor       =   &H00000000&
         Height          =   255
         Left            =   7620
         TabIndex        =   12
         Top             =   180
         Width           =   600
      End
      Begin Label Info 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         Caption         =   "x"
         ForeColor       =   &H00000000&
         Height          =   255
         Index           =   1
         Left            =   7440
         TabIndex        =   18
         Top             =   180
         Width           =   195
      End
      Begin Label TxWidth1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "512"
         ForeColor       =   &H00000000&
         Height          =   255
         Left            =   6840
         TabIndex        =   17
         Top             =   180
         Width           =   600
      End
      Begin Label TexPos 
         Alignment       =   2  'Center
         BackColor       =   &H00808080&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "0,0"
         ForeColor       =   &H00000000&
         Height          =   255
         Left            =   3120
         TabIndex        =   16
         Top             =   180
         Width           =   1245
      End
   End
   Begin CommandButton CmdSave 
      Caption         =   "Save File"
      Height          =   315
      Left            =   1800
      TabIndex        =   5
      Top             =   6000
      Width           =   1095
   End
   Begin CommandButton CmdAdd 
      Caption         =   "Read File"
      Height          =   315
      Left            =   1800
      TabIndex        =   11
      Top             =   5220
      Width           =   1095
   End
   Begin CommandButton CmdLoadO 
      Caption         =   "Load Old"
      Height          =   315
      Left            =   1800
      TabIndex        =   4
      Top             =   4500
      Width           =   1095
   End
   Begin CommandButton Exit 
      BackColor       =   &H00808080&
      Caption         =   "Quit"
      Height          =   315
      Left            =   300
      TabIndex        =   0
      Top             =   4500
      Width           =   1215
   End
   Begin ListBox TexuLst 
      Height          =   1200
      Left            =   180
      TabIndex        =   19
      Top             =   5100
      Width           =   1515
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   4
      Index           =   4
      X1              =   720
      X2              =   720
      Y1              =   6480
      Y2              =   6120
   End
   Begin Label Info 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Texture Files"
      ForeColor       =   &H00800000&
      Height          =   195
      Index           =   0
      Left            =   300
      TabIndex        =   34
      Top             =   4860
      Width           =   1215
   End
   Begin Label Which 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      BackStyle       =   0  'Transparent
      Caption         =   "0"
      ForeColor       =   &H000000FF&
      Height          =   195
      Left            =   1440
      TabIndex        =   13
      Top             =   4860
      Visible         =   0   'False
      Width           =   255
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   4
      Index           =   12
      X1              =   3180
      X2              =   2100
      Y1              =   5760
      Y2              =   5760
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   4
      Index           =   9
      X1              =   3180
      X2              =   2340
      Y1              =   5400
      Y2              =   5400
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   4
      Index           =   7
      X1              =   3180
      X2              =   720
      Y1              =   6540
      Y2              =   6540
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   4
      Index           =   5
      X1              =   2340
      X2              =   2340
      Y1              =   5460
      Y2              =   4020
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   4
      Index           =   1
      X1              =   3180
      X2              =   2820
      Y1              =   6180
      Y2              =   6180
   End
   Begin Label WadInfo 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      BackStyle       =   0  'Transparent
      Caption         =   "wadinfo.txt"
      ForeColor       =   &H000000FF&
      Height          =   195
      Left            =   120
      TabIndex        =   2
      Top             =   4740
      Visible         =   0   'False
      Width           =   915
   End
   Begin Label WorkDirec 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      BackStyle       =   0  'Transparent
      Caption         =   "work dir"
      ForeColor       =   &H000000FF&
      Height          =   195
      Left            =   960
      TabIndex        =   1
      Top             =   4740
      Visible         =   0   'False
      Width           =   915
   End
End
Option Explicit
Dim ListDirty As Integer ' list of texture files
Dim TexuDirty As Integer ' list of texture
Dim PatDirty As Integer  ' list of patches in texture
Dim TexFileNew As String
Dim TexSection As String
'
Dim PatchNam As String    'name of the patch that's moving
Dim PatchList As String   'list of patches
'List of patches composing textures of TexuOld
Dim TexuOldP() As String
  'TexuOld.ListCount < Ubound(TexuOldP)
'List of patches composing textures of TexuNew
Dim TexuNewP() As String
  'TexuNew.ListCount < Ubound(TexuNewP)
'format: PATCH___ofsXofsYPATCH___ofsXofsY ...

'Texture size
Dim TexWidth As Integer  'width of texture displayed
Dim TexHeight As Integer 'heigth of texture displayed
Dim TexRedraw As Integer 'can redraw texture?
'Bmp Name
Dim BMPnam As String
Dim BMPfile As String   'file name of the bitmap moving
Dim BMPcentX As Single  'bitmap decenter: percent X
Dim BMPcentY As Single  'bitmap decenter: percent Y

Sub CmdAdd_Click ()
  If Not Tutor("read textures from a file and add them to the list.") Then Exit Sub
   Dim file As String
   file = ChooseFile(".", "*.txt", True, "Select a file to import textures from")
   If DIRexistFile(file) Then
     Call TexuNLoad(file)   'add to current tex
   End If
End Sub

Sub CmdDelete_Click ()
  If Not Tutor("delete the selected texture") Then Exit Sub
  TexuNDelete (TexuNew.ListIndex)
End Sub

Sub CmdEditTex_Click ()
  'If Not Tutor("open a texture file to edit the textures inside.") Then Exit Sub
  If TexuDirty Then
    If QueryOk("Save file " & TexFileNew & " ?") Then
      Dim file$
      file = MakeFileName(WorkDirec.Caption, TexFileNew)
      TexuNSave (file)
    End If
  End If
   '
   ' load new texture file
   '
   TexuDirty = False
   If Len(TexuFile.Text) = 0 Then Exit Sub
   TexFileNew = Trim$(Left$(TexuFile.Text, 8))
   Dim i%
   i = InStr(TexFileNew, ".")
   If i > 0 Then TexFileNew = Left$(TexFileNew, i - 1)
   TexFileNew = TexFileNew & ".txt"

   file = MakeFileName(WorkDirec.Caption, TexFileNew)
   Call TexuNClear
   Call TexuNLoad(file)
End Sub

Sub CmdLoadO_Click ()
  '
  ' load old texture in list box
  Call TexuOLoad(Val(which.Caption))
End Sub

Sub CmdMove_Click (Index As Integer)
    If LPatches.ListIndex < 0 Then
      Call Crash("Please select a patch in the list")
      Exit Sub
    End If
    Dim PatchIndex As Integer
    PatchIndex = LPatches.ListIndex
    'speed
    Dim stp%
    stp% = 1
    If ChkSpeed.Value Then stp% = 16
    'execute order
    Dim ofsX%, ofsY%, nam$
    Select Case Index
      Case 0      'move UP
	nam = PatchGet(ofsX, ofsY, PatchIndex)
	If Len(nam) < 0 Then Exit Sub
	ofsY = ofsY - stp%
	Call PatchSet(nam, ofsX, ofsY, PatchIndex)
	PatDirty = True
      Case 1     'move DOWN
	nam = PatchGet(ofsX, ofsY, PatchIndex)
	If Len(nam) < 0 Then Exit Sub
	ofsY = ofsY + stp%
	Call PatchSet(nam, ofsX, ofsY, PatchIndex)
	PatDirty = True
      Case 2     'move LEFT
	nam = PatchGet(ofsX, ofsY, PatchIndex)
	If Len(nam) < 0 Then Exit Sub
	ofsX = ofsX - stp%
	Call PatchSet(nam, ofsX, ofsY, PatchIndex)
	PatDirty = True
      Case 3    'move RIGHT
	nam = PatchGet(ofsX, ofsY, PatchIndex)
	If Len(nam) < 0 Then Exit Sub
	ofsX = ofsX + stp%
	Call PatchSet(nam, ofsX, ofsY, PatchIndex)
	PatDirty = True
      Case 4    'bring in FRONT
	Call PatchBringFront(PatchIndex)
      Case 5    'Delete
	Call PatchDelete(PatchIndex)
      Case 6    'Move patch
	Call FloatingSet(LPatches.Text)
	Call PatchDelete(PatchIndex)
    End Select
    Call PatchRedraw
    Call LPatches_Click
End Sub

Sub CmdNewTex_Click ()
  If Not Tutor("start a new texture from scratch") Then Exit Sub
  '
  ' save currently edited texture
  '
  Call TexuNPreserve
  '
  ' declare new texture
  '
  Dim texu$
  texu$ = HelpGetName(Ident, False)
  Select Case Left$(texu$, 1)
    Case "-", "?"
    texu$ = InputBox$("Texture name?", "New Texture", "new")
  End Select
  Dim patl$
  patl$ = ""
  Dim texW, TexH As Integer
  texW = 128
  TexH = 128
  Call PatchSetAll(Trim$(Left$(texu$, 8)), texW, TexH, patl$)
  Call PatchRedraw
  'Call HelpMatch(Ident, texu$)
  Ident.Text = texu$
  TexuDirty = True 'file is modified
  PatDirty = False 'no patch modified
End Sub

Sub CmdOk_Click ()
  If Not Tutor("save the modifications of the current texture") Then Exit Sub
  '
  ' save currently edited texture
  '
  Call TexuNPreserve
End Sub

Sub CmdOld_Click ()
   If Not Tutor("import an texture from main WAD, to modify it (please avoid this).") Then Exit Sub
   If TexuOld.ListIndex < 0 Then Exit Sub
   Dim texu$, patl$
   texu$ = TexuOld.Text
   patl$ = TexuOldP(TexuOld.ListIndex)
   Call TexuNReplace(texu$, patl$)
End Sub

Sub CmdSave_Click ()
  If Not Tutor("save the modifications of all the textures") Then Exit Sub
  '
  ' save all textures in file
  '
  Dim file$
  file = MakeFileName(WorkDirec.Caption, TexFileNew)
  TexuNSave (file)
End Sub

Sub EntryName_Click ()
   If EntryName.ListIndex < 0 Then Exit Sub
   Call FloatingSet(EntryName.Text)
End Sub

Sub EntryName_KeyPress (KeyAscii As Integer)
  KeyAscii = WADnameSeek(EntryName, KeyAscii)
End Sub

Sub Exit_Click ()
  Unload Me
End Sub

Sub FloatingDrop ()
   'returns the (X,Y) position of moving picture
   'doesn't return the name

   'return position BEFORE CLEARING PIC
   Dim X%, Y%
   'X = (PicB.Left + TexOfs.Value) / Screen.TwipsPerPixelX
   X = Int(PicB.Left / Screen.TwipsPerPixelX)
   Y = Int(PicB.Top / Screen.TwipsPerPixelY)
   'clear the moving picture
   PicB.Visible = False
   Call PatchNewP(PatchNam, X, Y)
   Call PatchRedraw
   PatDirty = True
End Sub

Sub FloatingMove (X As Integer, Y As Integer)
   Dim XX, YY As Integer
   If PicB.Visible Then
      XX = X - Int(BMPcentX * PicB.Width)
      YY = Y - Int(BMPcentY * PicB.Height)
      PicB.Move XX, YY
   Else
     XX = X
     YY = Y
   End If
   XX = Int(XX / Screen.TwipsPerPixelX) '- TexOfs.Value
   YY = Int(YY / Screen.TwipsPerPixelY)
   TexPos.Caption = XX & "," & YY
End Sub

Sub FloatingSet (ByVal entry$)
   PatchNam = Trim$(Left$(entry$, 8))
   Call WADpatchShow(PicB, PatchNam)
End Sub

Sub Form_Load ()
 ' first event called when frame up
 ' nothing is initialised. don't put init calls here.
 'set default arrays
 ReDim TexuOldP(1)
 ReDim TexuNewP(1)

 'nothing
 ListDirty = False
 TexuDirty = False
 PatDirty = False
 ' pictures are grabbed by center
 BMPcentX = .5
 BMPcentY = .5
End Sub

Sub Form_Unload (Cancel As Integer)
  If TexuDirty Then
    If QueryOk("Save file " & TexFileNew & " ?") Then
      Dim file$
      file = MakeFileName(WorkDirec.Caption, TexFileNew)
      TexuNSave (file)
    End If
  End If
  If ListDirty Then
    If QueryOk("Update list of texture files?") Then
       '            list of files    wadinfo       TEXTURE1,2
       Call SectionWrite(TexuLst, WadInfo.Caption, TexSection)
    End If
  End If
End Sub

Sub Ident_Change ()
  Call HelpCheckSelect(Ident)
  'PatDirty = True 'don't do this
End Sub

Sub Ident_Click ()
  PatDirty = True
End Sub

Sub Ident_KeyDown (KeyCode As Integer, Shift As Integer)
   If KeyCode = KEY_DELETE Then KeyCode = 0
End Sub

Sub Ident_KeyPress (KeyAscii As Integer)
  'KeyAscii = HelpKeyPress(Ident, KeyAscii)
  ' replace key according to a pattern
  Dim s As Integer
  s = Ident.SelStart + 1
  If KeyAscii = KEY_BACK Or s < 1 Or s > 8 Then
    'cancel key
    KeyAscii = 0
    Ident.SelLength = 0
    Exit Sub
  End If
  'accept key
  Ident.SelLength = 1
  PatDirty = True
End Sub

Sub Info_Click (Index As Integer)
   Select Case Index
     Case 0
       Call Infos("These are the files where one or many of your textures will be stored. Avoid duplications.")
     Case 1
     Case 2
       Call Infos("Give a name to your texture. The two first letters should characterize all your textures (so that it is possible to join your levels with other levels with custom textures.)")
     Case 3
       Call Infos("These are your custom patches. Go to the Edit Patch window to edit them.")
     Case 4
       Call Infos("Select a patch in the patch list. Move it with mouse. Click to drop it on Texture. Right Click to discard it.")
       Call Infos("Don't leave any completely void column in your texture, or the game will crash")
     Case 5
       Call Infos("These are the pictures in the main WAD that you may safely reuse as patch. Browse the list or type a name.")
   End Select
End Sub

Sub LPatches_Click ()
  Dim ofsX%, ofsY%, nam$
  If LPatches.ListIndex < 0 Then Exit Sub
  nam = PatchGet(ofsX, ofsY, LPatches.ListIndex)
  TexPos.Caption = ofsX & "," & ofsY
End Sub

Sub LPatches_DblClick ()
  If LPatches.ListIndex < 0 Then Exit Sub
  'DUPLICATE
  Call FloatingSet(LPatches.Text)
End Sub

Sub LPatches_KeyDown (KeyCode As Integer, Shift As Integer)
  If LPatches.ListIndex >= 0 Then
    Select Case KeyCode
      Case KEY_DELETE    'delete
	Call PatchDelete(LPatches.ListIndex)
	Call PatchRedraw
      Case KEY_SPACE     'bring front
	Call PatchBringFront(LPatches.ListIndex)
	Call PatchRedraw
    End Select
  End If
End Sub

Sub PatchBringFront (ByVal Index As Integer)
   'bring patch to front
   Dim Patch$
   Patch = Mid$(PatchList, Index * 16 + 1, 16)
   Call PatchDelete(Index)
   Call PatchNew(Patch)
End Sub

Sub PatchDelete (ByVal Index As Integer)
'delete patch
  'exit if out of bounds
  If Index >= LPatches.ListCount Then Exit Sub
  'remove patch from list
  Dim Rgt$
  Rgt$ = Mid$(PatchList, 16 * (Index + 1) + 1)
  PatchList = Left$(PatchList, 16 * (Index)) & Rgt$
  LPatches.RemoveItem (Index)
  PatDirty = True
  Index = Index - 1
  If Index < 0 Then Index = 0
  If Index < LPatches.ListCount Then LPatches.ListIndex = Index
End Sub

Sub Patches_Click ()
  If patches.ListIndex < 0 Then Exit Sub
  Dim nam$
  nam = patches.List(patches.ListIndex)
  Dim i As Integer
  i = InStr(nam, ".")
  If i > 1 Then nam = Left$(nam, i - 1)
  Call FloatingSet(nam)
End Sub

Sub Patches_DblClick ()
  patches.Refresh
End Sub

Sub Patches_KeyDown (KeyCode As Integer, Shift As Integer)
  If KeyCode <> KEY_DELETE Then Exit Sub
  If patches.ListIndex < 0 Then Exit Sub
  Dim file$
  file$ = MakeFileName(patches.Path, patches.FileName)
  EditDeleteFile (file$)
  patches.Refresh
End Sub

Sub PatchFrame_DblClick ()
    Call Infos("This pannel shows the patches composing the currently edited texture. Left Click in list to get the same patch.")
End Sub

Function PatchGet (ofsX%, ofsY%, ByVal Index%) As String
   PatchGet = ""
   If Index >= LPatches.ListCount Then Exit Function
   Dim Patch$
   Patch = Mid$(PatchList, Index * 16 + 1, 16)
   ofsX = Val(Mid$(Patch, 8 + 1, 4))
   ofsY = Val(Mid$(Patch, 12 + 1, 4))
   PatchGet = Trim$(Mid$(Patch, 1, 8))
End Function

Function PatchGetAll (Tex$, texW%, TexH%) As String
  'get the patches of the current texture
  'and also the name and width/height
  'name
  Tex$ = HelpGetName(Ident, False)
  'texture name is "-" means deleted. see TexNdelete
  If Left$(Tex$, 1) = "-" Then Tex$ = ""
  'Width
  texW% = 2 ^ TexuWidth.Value
  'Height
  TexH% = TexuHeight.Value
  'list of Patches
  PatchGetAll = PatchList
End Function

Sub PatchNew (ByVal pat$)
  If Len(pat$) < 16 Then Exit Sub
  'declare a new patch
  LPatches.AddItem (Trim$(Left$(pat$, 8)))
  PatchList = PatchList & Left$(pat$, 16)
  LPatches.ListIndex = LPatches.NewIndex
End Sub

Sub PatchNewP (ByVal nam$, ByVal ofsX, ByVal ofsY)
  Static Patch As String * 17
  Dim PatLen%
  PatLen = TEXTpatchMake(Patch, nam$, ofsX, ofsY)
  If PatLen > 0 Then PatchNew (Left$(Patch, PatLen))
End Sub

Sub PatchRedraw ()
   Call WADtexuShow(TexuB, PatchList)
End Sub

Sub PatchSet (ByVal nam$, ByVal ofsX%, ByVal ofsY%, ByVal Index%)
   If Index >= LPatches.ListCount Then Exit Sub
   Static Patch As String * 32
   Dim res%
   res = TEXTpatchMake(Patch$, nam$, ofsX, ofsY)
   If res < 0 Then Exit Sub
   Mid$(PatchList, Index * 16 + 1, 16) = Left$(Patch, res)
End Sub

Sub PatchSetAll (ByVal Tex$, ByVal texW%, ByVal TexH%, ByVal patches$)
  'set the current texture and it's list of patches
  ' tex$  name of tex
  ' texW% width of tex
  ' texH% height of tex
  ' s     list of patches, format  PATCH___ofsXofsYPATCH___ofsXofsY...
  'Texture Name
  Ident.Text = UCase$(Trim$(Tex$))
  'reset the patches list before texture resize
  LPatches.Clear
  PatchList = ""
  ' disable text redraw
  TexRedraw = False
  'set Texture Height --> Patch Redraw
  If TexH < 8 Then TexH% = 8
  If TexH% > 128 Then TexH = 128
  TexuHeight.Value = TexH%
  'set Texture Width  --> Patch Redraw
  Dim nb As Integer
  For nb = 2 To 11
    If 2 ^ nb >= texW% Then Exit For
  Next nb
  TexuWidth.Value = nb
  'enable texture redraw
  TexRedraw = True
  'add new patches
  PatchList = patches
  Dim pos As Integer
  Dim pat$
  For pos = 0 To Len(patches) - 1 Step 16
    pat$ = Mid$(patches, pos + 1, 16)
    LPatches.AddItem (Trim$(Left$(pat$, 8)))
  Next pos
  Call PatchTexuResize(True)
End Sub

Sub PatchTexuResize (ByVal resize%)
   '
   ' resize texture.
   ' if resize = true, then show the resized texture,
   ' else display nothing
   'set moving picture at a visible place
   PicB.Move 0, 0
   PicB.Visible = False
   If Not TexRedraw Then Exit Sub
   Dim W, H As Integer
   W = 2 ^ TexuWidth.Value
   H = TexuHeight.Value
   'change size
   Call WADtexuInit(TexuB, W, H, patches.Path, resize%)
   'redraw texture
   If resize% Then Call PatchRedraw
   'PatDirty = True  'don't do this
End Sub

Sub PCenter_DblClick ()
   Call Infos("Click here to chose a grabing point to move your patches.")
End Sub

Sub PCenter_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
   BMPcentX = X / PCenter.Width
   BMPcentY = Y / PCenter.Height
End Sub

Sub StockFrame_DblClick ()
   Call Infos("These are patches for your texture. Go to the Edit Patch window, if you want to change them.")
End Sub

Sub TexOfs_Change ()
   TexuB.Move (TexOfs.Value * Screen.TwipsPerPixelX), 0
End Sub

Sub TexuB_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
  'PASTE if left click
  'discard if righ click
  If PicB.Visible Then
    If Button And LEFT_BUTTON Then
     'left click: paste picture
     Call FloatingDrop
    Else
     'right click: discard
      PicB.Visible = False
    End If
  End If
End Sub

Sub TexuB_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
  'move Floating image
  Call FloatingMove(Int(X), Int(Y))
End Sub

Sub TexuFile_DblClick ()
   Call Infos("Select here a new name for a texture file")
End Sub

Sub TexuFile_KeyPress (KeyAscii As Integer)
   If KeyAscii <> KEY_RETURN Then Exit Sub
   TexuFile.Text = UCase$(Trim$(Left$(TexuFile.Text, 8)))
   TexuLst.AddItem (TexuFile.Text)
   ListDirty = True
End Sub

Sub TexuFrame_DblClick ()
   Call Infos("This pannel shows the textures in the currently edited file")
End Sub

Sub TexuHeight_Change ()
   TxHeight1.Caption = Str$(TexuHeight.Value)
   Call PatchTexuResize(True)
End Sub

Sub TexuHeight_Scroll ()
  TxHeight1.Caption = Str$(TexuHeight.Value)
 PatDirty = True
End Sub

Sub TexuLst_Click ()
  If TexuLst.ListIndex < 0 Then Exit Sub
  TexuFile.Text = UCase$(Trim$(Left$(TexuLst.Text, 8)))
End Sub

Sub TexuLst_DblClick ()
  Dim file$
  file$ = LCase$(TexuFile.Text & ".txt")
  If Not Tutor("edit the texture file " & file$) Then Exit Sub
  file$ = MakeFileName(WorkDirec.Caption, file$)
  If DIRexistFile(file$) Then EditTextFile (file$)
End Sub

Sub TexuLst_KeyDown (KeyCode As Integer, Shift As Integer)
   If TexuLst.ListIndex < 0 Then Exit Sub
   If KeyCode <> KEY_DELETE Then Exit Sub
   TexuLst.RemoveItem (TexuLst.ListIndex)
   ListDirty = True
End Sub

Function TexuMake (ByVal nam$, ByVal szx%, ByVal szy%) As String
' make a texture as a string
' NAMENAME_xxxx_yyyy
'
  Static entry As String * 31
  TexuMake = ""
  Dim res%
  res = TEXTentryMake(entry, nam, szx, szy, " ", False)
  If res > 0 Then TexuMake = Left$(entry, 18) 'namename_xxxx_yyyy
End Function

Sub TexuNClear ()
  TexuNew.Clear
  ReDim TexuNewP(10)   'clear texture list
End Sub

Sub TexuNDelete (ByVal Index%)
  'find a texture and delete it
  If Index < 0 Then Exit Sub
  If Index >= TexuNew.ListCount Then Exit Sub
  Ident.Text = "-"  'delete
  ' NO DOEVENTS HERE! could crash the list!
  Dim n%
  For n = Index + 1 To TexuNew.ListCount - 1
     TexuNewP(n - 1) = TexuNewP(n)
  Next n
  TexuNew.RemoveItem (Index)
  Index = Index - 1
  If Index < 0 Then Index = 0
  If Index < TexuNew.ListCount Then TexuNew.ListIndex = Index
  PatDirty = True
End Sub

Sub TexuNew_Click ()
  If TexuNew.ListIndex < 0 Then Exit Sub
  '
  ' save currently edited texture
  '
  Call TexuNPreserve
  '
  ' declare new texture
  '
  Dim texu$
  texu$ = TexuNew.Text
  Dim patl$
  patl$ = TexuNewP(TexuNew.ListIndex)
  Dim texW, TexH As Integer
  texW = Val(Mid$(texu$, 8 + 1 + 1, 4))
  TexH = Val(Mid$(texu$, 12 + 2 + 1, 4))
  Call PatchSetAll(Trim$(Left$(texu$, 8)), texW, TexH, patl$)
  Call PatchRedraw
End Sub

Sub TexuNew_KeyDown (KeyCode As Integer, Shift As Integer)
   If KeyCode <> KEY_DELETE Then Exit Sub
   If TexuNew.ListIndex < 0 Then Exit Sub
   Call TexuNDelete(TexuNew.ListIndex)
End Sub

Sub TexuNLoad (ByVal file$)
' don't reset file
' Load file$, read textures, read patches
' TexuNew.List TexuNewP
  If Not DIRexistFile(file$) Then Exit Sub
  Static nam As String * 10       'texture name
  Dim szx%
  Dim szy%
  Static PatLst As String * 4096  'list of patches
  Dim PatLen%
  Dim entry$
  If TEXTreadTexuInit(file$) <> True Then Exit Sub
  Do
    PatLen% = TEXTreadTexu(nam$, szx, szy, PatLst, 4096)
    If PatLen% = -1 Then Exit Do 'finished
    If PatLen% < 0 Then
      Call Crash("Can't read TEXTURE" & which)
      Exit Sub
    End If
    'add new texture
    entry$ = TexuMake(Trim$(Left$(nam, 8)), szx, szy)
    Call TexuNNew(entry$, Left$(PatLst, PatLen))
  Loop
End Sub

Sub TexuNNew (ByVal texu$, ByVal patl$)
  'add new texture
   'Dim res%
   TexuNew.AddItem (texu$)
   'res% = SendMessageByString(TexuNew.hWnd, LB_ADDSTRING, 0, texu$)
   If TexuNew.NewIndex >= UBound(TexuNewP) Then
     ReDim Preserve TexuNewP(TexuNew.NewIndex + 10)
   End If
   TexuNewP(TexuNew.NewIndex) = patl$
   'don't do this: TexuNew.ListIndex = TexuNew.NewIndex
End Sub

Sub TexuNPreserve ()
  Dim Tex As String
  Dim texW As Integer
  Dim TexH As Integer
  Dim patl As String
  patl = PatchGetAll(Tex, texW, TexH)
  If Len(Tex) <= 0 Then Exit Sub
  Dim texu As String
  texu = TexuMake(Tex, texW, TexH)
  Call TexuNReplace(texu, patl)
  PatDirty = False
End Sub

Sub TexuNReplace (ByVal texu$, ByVal patl$)
'try to find a texture and
  If Not PatDirty Then Exit Sub
'match it
  Dim idx%
  idx% = ListFindEx8%(TexuNew, -1, texu$)'match on 8 chars
  TexuDirty = True 'the texture file is changed
  If idx% < 0 Then
    ' not found? it's a new texture. add at the end.
    Call TexuNNew(texu, patl)
    Exit Sub
  End If
  'replace texture
  TexuNew.List(idx%) = texu$
  TexuNewP(idx%) = patl$
  'don't do this: TexuNew.ListIndex = n
End Sub

Sub TexuNSave (ByVal file$)
'
' Load file$, read textures, read patches
' TexuNew.List TexuNewP
  '
  ' save a backup file
  '
  If DIRexistFile(file$) Then
    'rename old file
     If LCase$(Right$(file$, 4)) = ".txt" Then
       Dim file2$
       file2$ = Left$(file$, Len(file$) - 3) & "bak"
       If DIRexistFile(file2$) Then Kill file2$
       Name file$ As file2$
    End If
  End If
  '
  ' update currently edited texture
  ' before saving
  Call TexuNPreserve
  '
  ' Get and save all the textures
  '
  Open file$ For Output As #1
  Dim PatLst As String   'list of patches
  Dim PatLen%
  Dim Patch As String
  Dim n, pos As Integer
  For n = 0 To TexuNew.ListCount - 1
    'print texture
    Print #1, TexuNew.List(n)
    'print patches
    PatLst = TexuNewP(n)
    PatLen = Len(PatLst)
    For pos = 0 To PatLen - 1 Step 16
      Patch = Mid$(PatLst, pos + 1, 16)
      Print #1, "*" & Chr$(9) & Trim$(Left$(Patch, 8)) & Chr$(9) & Val(Mid$(Patch, 8 + 1, 4)) & Chr$(9) & Val(Mid$(Patch, 12 + 1, 4))
    Next pos
  Next n
  'section completely written
  Close #1
  TexuDirty = False
  PatDirty = False
End Sub

Sub TexuOld_Click ()
   If TexuOld.ListCount <= 0 Then
     Call CmdLoadO_Click
     Exit Sub
   End If
   If TexuOld.ListIndex < 0 Then Exit Sub
   Dim texu$, patl$
   Dim W, H As Integer
   'cheat and declare another texture size
   texu$ = TexuOld.Text
   W = Val(Mid$(texu$, 9 + 1, 4))
   H = Val(Mid$(texu$, 14 + 1, 4))
   Call WADtexuInit(TexuB, W, H, patches.Path, True)
   'draw texture
   patl$ = TexuOldP(TexuOld.ListIndex)
   Call WADtexuShow(TexuB, patl$)
   'restore texture size
   PatchTexuResize (False)
End Sub

Sub TexuOLoad (ByVal which%)
' Load TEXTURE1 or TEXTURE2 (which = 1 or 2)
' read textures and patches
' declare new texture
  'clear list
  TexuOld.Clear
  ReDim TexuOldP(10)   'clear texture list
  'read textures
  Static nam As String * 10       'texture name
  Dim szx%
  Dim szy%
  Static PatLst As String * 4096  'list of patches
  Dim PatLen%
  Dim entry$
  Do
    PatLen = IWADtexuRead(nam$, szx, szy, PatLst, 4096, which)
    If PatLen% = -1 Then Exit Do 'finished
    If PatLen% < 0 Then
      Call Crash("Can't read TEXTURE" & which)
      Exit Sub
    End If
    'add new texture
    entry$ = TexuMake(Trim$(Left$(nam, 8)), szx, szy)
    TexuOld.AddItem (entry$)
    If TexuOld.NewIndex >= UBound(TexuOldP) Then
      ReDim Preserve TexuOldP(TexuOld.NewIndex + 10)
    End If
    TexuOldP(TexuOld.NewIndex) = Left$(PatLst, PatLen)
    DoEvents
  Loop
End Sub

Sub TexuWidth_Change ()
 TxWidth1.Caption = Str$(2 ^ TexuWidth.Value)
 TexOfs.Value = 0
 If TexuWidth.Value > 9 Then
   TexOfs.Visible = True
   TexOfs.Max = 512 - 2 ^ TexuWidth.Value
 Else
   TexOfs.Visible = False
 End If
 Call PatchTexuResize(True)
End Sub

Sub TexuWidth_Scroll ()
  TxWidth1.Caption = Str$(2 ^ TexuWidth.Value)
  PatDirty = True
End Sub

Sub TexVisu_DblClick ()
   Call Infos("This is the texture being composed. You can set it's name, width and height.")
End Sub

Sub WadInfo_Change ()
   'ident
   'doom
  Call HelpD(Ident, "-", "New Texture")
  Select Case typeIWAD()
   Case 10, 11 'doom
   Call HelpD(Ident, "BLODGR1", "Anim1 Start")
   Call HelpD(Ident, "BLODGR4", "Anim1 End")
   Call HelpD(Ident, "BLODRIP1", "Anim2 Start")
   Call HelpD(Ident, "BLODRIP4", "Anim2 End")
   Call HelpD(Ident, "FIREBLU1", "Anim3 Start")
   Call HelpD(Ident, "FIREBLU2", "Anim3 End")
   Call HelpD(Ident, "FIRELAV3", "Anim4 Start")
   Call HelpD(Ident, "FIRELAVA", "Anim4 End")
   Call HelpD(Ident, "FIREWALA", "Anim5 Start")
   Call HelpD(Ident, "FIREWALL", "Anim5 End")
   Call HelpD(Ident, "FIREMAG1", "Anim6 Start")
   Call HelpD(Ident, "FIREMAG3", "Anim6 End")
   Call HelpD(Ident, "GSTFONT1", "Anim7 Start")
   Call HelpD(Ident, "GSTFONT3", "Anim7 End")
   Call HelpD(Ident, "ROCKRED1", "Anim8 Start")
   Call HelpD(Ident, "ROCKRED3", "Anim8 End")
   Call HelpD(Ident, "SLADRIP1", "Anim9 Start")
   Call HelpD(Ident, "SLADRIP3", "Anim9 End")
   Case 20, 21, 22'heretic
   Call HelpD(Ident, "LAVAFL1", "Anim1 Start")
   Call HelpD(Ident, "LAVAFL3", "Anim1 End")
   Call HelpD(Ident, "WATRWAL1", "Anim2 Start")
   Call HelpD(Ident, "WATRWAL3", "Anim2 End")
  End Select
  Select Case typeIWAD()
   Case 12 'doom2
   Call HelpD(Ident, "BFALL1", "Anim10 Start")
   Call HelpD(Ident, "BFALL4", "Anim10 End")
   Call HelpD(Ident, "SFALL1", "Anim11 Start")
   Call HelpD(Ident, "SFALL4", "Anim11 End")
   Call HelpD(Ident, "WFALL1", "Anim12 Start")
   Call HelpD(Ident, "WFALL4", "Anim12 End")
   Call HelpD(Ident, "DBRAIN1", "Anim13 Start")
   Call HelpD(Ident, "DBRAIN4", "Anim13 End")
  End Select
  Select Case typeIWAD()
   Case 10, 11, 20, 21'doom, heretic
    Call HelpD(Ident, "SK1", "Sky for Episode 1")
    Call HelpD(Ident, "SK2", "Sky for Episode 2")
    Call HelpD(Ident, "SK3", "Sky for Episode 3")
   Case 12, 22'doom2
    Call HelpD(Ident, "SK1", "Sky for Level 1-11")
    Call HelpD(Ident, "SK2", "Sky for Level 12-22")
    Call HelpD(Ident, "SK3", "Sky for Level 23-32")
  End Select
  Call HelpD(Ident, "????????", "Any Texture")
  Ident.Text = Ident.List(0)
   
   'Read section  7 = no   X Y offset, repeat, name
  TexuB.Cls
  Call SectionRead(TexuLst, WadInfo.Caption, TexSection, 7)
  If TexuLst.ListCount = 0 Then
   TexuFile.Text = "TEXTURE1"
   TexuLst.AddItem TexuFile.Text
   ListDirty = True
  End If
  TexuLst.ListIndex = 0
  Call CmdEditTex_Click
End Sub

Sub Which_Change ()
  which.Caption = Left$(which.Caption, 1)
  TexSection = "TEXTURE" & which.Caption
  TexFileNew = TexSection & ".TXT"
  TexuFile.Text = TexSection
End Sub

Sub WorkDirec_Change ()
  Dim Direc As String
  'new patches
  Direc = WorkDirec.Caption & "\..\patches"
  If DIRexistDir(Direc) Then
    patches.Enabled = True
    patches.Path = Direc
  Else
    patches.Enabled = False
    patches.Path = "."
  End If
  TexRedraw = True
  Call PatchTexuResize(True)
End Sub

