VERSION 2.00
Begin Form EdtSound 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Edit Sounds"
   ClientHeight    =   4680
   ClientLeft      =   630
   ClientTop       =   1605
   ClientWidth     =   8370
   ClipControls    =   0   'False
   Height          =   5055
   HelpContextID   =   300
   Icon            =   EDTSOUND.FRX:0000
   Left            =   585
   LinkTopic       =   "Form1"
   ScaleHeight     =   4680
   ScaleWidth      =   8370
   Top             =   1275
   Width           =   8460
   Begin CommandButton Cmd 
      Caption         =   "Add"
      Height          =   315
      HelpContextID   =   4020
      Index           =   0
      Left            =   3420
      TabIndex        =   16
      Top             =   3360
      Width           =   1155
   End
   Begin CommandButton Cmd 
      Caption         =   "Rename"
      Height          =   315
      HelpContextID   =   4050
      Index           =   1
      Left            =   3420
      TabIndex        =   15
      Top             =   3780
      Width           =   1155
   End
   Begin CommandButton Cmd 
      Caption         =   "Edit"
      Height          =   315
      Index           =   3
      Left            =   2040
      TabIndex        =   14
      Top             =   840
      Width           =   1155
   End
   Begin SSCheck ERepeat 
      Caption         =   "Repeat previous entry"
      Font3D          =   0  'None
      Height          =   255
      HelpContextID   =   4000
      Left            =   3600
      TabIndex        =   13
      Top             =   900
      Width           =   2175
   End
   Begin ComboBox Ident 
      Height          =   300
      HelpContextID   =   4060
      Left            =   1920
      TabIndex        =   12
      Text            =   "HELP"
      Top             =   4260
      Width           =   3975
   End
   Begin ListBox SoundLst 
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Courier"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   1980
      Left            =   1980
      TabIndex        =   11
      Top             =   1260
      Width           =   3795
   End
   Begin ListBox EntryName 
      BackColor       =   &H00808080&
      Height          =   3540
      HelpContextID   =   4045
      Left            =   120
      TabIndex        =   10
      Top             =   1020
      Width           =   1635
   End
   Begin CommandButton Cmd 
      Caption         =   "Import"
      Height          =   315
      HelpContextID   =   4040
      Index           =   2
      Left            =   2040
      TabIndex        =   9
      Top             =   3780
      Width           =   1155
   End
   Begin CommandButton CmdSave 
      BackColor       =   &H00808080&
      Caption         =   "Save"
      Height          =   315
      HelpContextID   =   4070
      Left            =   360
      TabIndex        =   8
      Top             =   540
      Width           =   1155
   End
   Begin SSFrame FramePC 
      Caption         =   "PC Sounds"
      Font3D          =   0  'None
      ForeColor       =   &H00000000&
      Height          =   4515
      Left            =   6060
      TabIndex        =   2
      Top             =   60
      Width           =   2115
      Begin CommandButton Cmd 
         Caption         =   "New PC sound"
         Height          =   315
         Index           =   4
         Left            =   180
         TabIndex        =   4
         Top             =   3960
         Width           =   1815
      End
      Begin ListBox PcLst 
         Height          =   2175
         Left            =   120
         TabIndex        =   3
         Top             =   1620
         Width           =   1875
      End
      Begin Label Info 
         Alignment       =   2  'Center
         Caption         =   "Format used for PC sounds: list of numbers (0 to 255) representing the inverse of frequency."
         Height          =   1035
         Index           =   1
         Left            =   180
         TabIndex        =   7
         Top             =   420
         Width           =   1815
      End
      Begin Line Line 
         BorderColor     =   &H00808080&
         BorderWidth     =   3
         Index           =   10
         X1              =   1080
         X2              =   1080
         Y1              =   3540
         Y2              =   4080
      End
   End
   Begin CommandButton Exit 
      BackColor       =   &H00808080&
      Caption         =   "Quit"
      Height          =   315
      Left            =   360
      TabIndex        =   0
      Top             =   120
      Width           =   1155
   End
   Begin Image CmdForget 
      Height          =   480
      Left            =   5100
      Picture         =   EDTSOUND.FRX:0302
      Top             =   3420
      Width           =   480
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   0
      X1              =   2640
      X2              =   2640
      Y1              =   3120
      Y2              =   4020
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   9
      X1              =   2580
      X2              =   2580
      Y1              =   1620
      Y2              =   1140
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   8
      X1              =   3960
      X2              =   3960
      Y1              =   3180
      Y2              =   4320
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   13
      X1              =   2700
      X2              =   2640
      Y1              =   3660
      Y2              =   3480
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   12
      X1              =   2580
      X2              =   2640
      Y1              =   3660
      Y2              =   3480
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   6
      X1              =   1740
      X2              =   2640
      Y1              =   3960
      Y2              =   3960
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   2
      X1              =   5340
      X2              =   5340
      Y1              =   3060
      Y2              =   3600
   End
   Begin Label Info 
      Alignment       =   2  'Center
      Caption         =   "Sound Samples: 11025 sample per second, 8 bit per sample, no compression, duration should be less than around 10 seconds."
      Height          =   675
      Index           =   0
      Left            =   1920
      TabIndex        =   6
      Top             =   60
      Width           =   3795
   End
   Begin Label WorkDirec 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      BackStyle       =   0  'Transparent
      Caption         =   "work dir"
      ForeColor       =   &H00000080&
      Height          =   195
      Left            =   1860
      TabIndex        =   1
      Top             =   3360
      Visible         =   0   'False
      Width           =   675
   End
   Begin Label WadInfo 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      BackStyle       =   0  'Transparent
      Caption         =   "wadinfo.txt"
      ForeColor       =   &H00000080&
      Height          =   195
      Left            =   4680
      TabIndex        =   5
      Top             =   4020
      Visible         =   0   'False
      Width           =   1215
   End
End
Option Explicit

Dim ListDirty As Integer
Dim CmdMusStr As String
Dim CmdMidiStr As String

Sub Cmd_Click (Index As Integer)
  Dim file$, file2$
  Dim entry$, nam$
  Dim X%, Y%, repeat%
  Select Case Index
    Case 0  'new sound
      If Not Tutor("add a new sound to the list. The entry name is taken from the drop box.") Then Exit Sub
      entry = HelpGetName(Ident, True)
      If Len(entry) <= 0 Then Exit Sub
      If entry Like "DP*" Then Exit Sub
      file = ChooseFile(".", "*.wav", True, "Select a new sound file (.WAV)")
      If Not DIRexistFile(file) Then Exit Sub
      nam = FileName(file)
      file2 = MakeFileName(WorkDirec.Caption, nam)
      Call EditCopyFile(file, file2)
      nam = FileRoot(file)
      nam = EntryMake(entry, INVALID, INVALID, nam, False)
      If Len(nam) <= 0 Then Exit Sub
      SoundLst.ListIndex = ListInsert(SoundLst, nam$)
      ListDirty = True
    Case 1  'rename sound
      If Not Tutor("rename a sound using a name taken from the drop box.") Then Exit Sub
      If SoundLst.ListIndex < 0 Then Exit Sub
      entry = EntryGet(X, Y, nam, repeat, SoundLst.Text)
      entry = HelpGetName(Ident, True)
      If Len(entry) <= 0 Then Exit Sub
      nam = EntryMake(entry, INVALID, INVALID, nam, False)
      If Len(nam) <= 0 Then Exit Sub
      SoundLst.List(SoundLst.ListIndex) = nam
      ListDirty = True
    Case 2 'import
      If EntryName.ListIndex < 0 Then Exit Sub
      entry$ = EntryName.Text
      Dim ofx%, ofy%
      If Not WADexportName(WorkDirec.Caption, entry$, ofx%, ofy%) Then Exit Sub
      nam = EntryMake(entry$, INVALID, INVALID, entry$, False)
      If Len(nam) <= 0 Then Exit Sub
      SoundLst.ListIndex = ListInsert(SoundLst, nam$)
      ListDirty = True
    Case 3  'edit sound
      If Not Tutor("edit a sound file.") Then Exit Sub
      If SoundLst.ListIndex < 0 Then Exit Sub
      entry = EntryGet(X, Y, nam, repeat, SoundLst.Text)
      If repeat Then Exit Sub
      file = MakeFileName(WorkDirec.Caption, nam & ".wav")
      EditWavFile (file)
    Case 4  'new PC sound
      If Not Tutor("add a new PC sound.") Then Exit Sub
      file = ChooseFile(".", "dp*.txt", True, "Select a new PC sound file (.TXT)")
      If Not DIRexistFile(file) Then Exit Sub
      entry = FileRoot(file)
      If Len(entry) <= 0 Then Exit Sub
      If Not entry Like "DP*" Then Exit Sub
      nam = FileName(file)
      file2 = MakeFileName(WorkDirec.Caption, nam)
      Call EditCopyFile(file, file2)
      nam = FileRoot(file)
      nam = EntryMake(entry, INVALID, INVALID, nam, False)
      If Len(nam) <= 0 Then Exit Sub
      PcLst.ListIndex = ListInsert(PcLst, nam$)
      ListDirty = True
  End Select
End Sub

Sub CmdForget_Click ()
   Call EntryDelete(SoundLst, WorkDirec.Caption, ".WAV")
   ListDirty = True
End Sub

Sub CmdSave_Click ()
  If Not Tutor("save the modifications") Then Exit Sub
  If Not ListDirty Then Exit Sub
  Dim n As Integer
  For n = PcLst.ListCount - 1 To 0 Step -1
    SoundLst.AddItem (PcLst.List(n))
  Next n
  Call SectionWrite(SoundLst, WadInfo.Caption, "SOUNDS")
  ListDirty = False
End Sub

Sub EntryName_Click ()
   If EntryName.ListIndex < 0 Then Exit Sub
   Call WADshowName(SoundLst, EntryName.Text)
   Call HelpMatch(Ident, EntryName.Text)
End Sub

Sub EntryName_KeyPress (KeyAscii As Integer)
  KeyAscii = WADnameSeek(EntryName, KeyAscii)
End Sub

Sub ERepeat_Click (Value As Integer)
  If SoundLst.ListIndex <= 0 Then Exit Sub
  Dim nam$, entry$
  Dim X%, Y%, repeat%
  entry = EntryGet(X, Y, nam, repeat, SoundLst.Text)
  If repeat = Value Then Exit Sub
  repeat = Value
  SoundLst.List(SoundLst.ListIndex) = EntryMake(entry, X, Y, nam, repeat)
  ListDirty = True
End Sub

Sub Exit_Click ()
  Unload Me
End Sub

Sub Form_Load ()
 ListDirty = False
End Sub

Sub Form_Unload (Cancel As Integer)
  If Not ListDirty Then Exit Sub
  If QueryOk("Save file " & WadInfo.Caption & " ?") Then Call CmdSave_Click
End Sub

Sub FramePC_DblClick ()
    Call Infos("The PC sounds are those noisy sound that play on the PC speaker in DOOM.")
End Sub

Sub Ident_Change ()
   Call HelpCheckSelect(Ident)
End Sub

Sub Ident_KeyDown (KeyCode As Integer, Shift As Integer)
   If KeyCode = KEY_DELETE Then KeyCode = 0
End Sub

Sub Ident_KeyPress (KeyAscii As Integer)
   KeyAscii = HelpKeyPress(Ident, KeyAscii)
End Sub

Sub LoadHelpSound ()
  Dim DoomSnd
  Select Case typeIWAD()
   Case 10, 11, 12'doom, doom2
      HelpD Ident, "DSPISTOL", "Pistol firing"
      HelpD Ident, "DSSGCOCK", "Shotgun cocking"
      HelpD Ident, "DSSHOTGN", "Shotgun firing"
      HelpD Ident, "DSSAWUP", "Chainsaw start"
      HelpD Ident, "DSSAWIDL", "Chainsaw idle"
      HelpD Ident, "DSSAWFUL", "Chainsaw triggered"
      HelpD Ident, "DSSAWHIT", "Chainsaw hits"
      HelpD Ident, "DSRLAUNC", "Firing Rocket"
      HelpD Ident, "DSBAREXP", "Rocket explodes"
      HelpD Ident, "DSFIRSHT", "Fireballs passing"
      HelpD Ident, "DSFIRXPL", "Fireball hits"
      HelpD Ident, "DSPUNCH", "Player punching"
      HelpD Ident, "DSPLASMA", "Plasma firing"
      HelpD Ident, "DSFIRXPL", "Plasma hits"
      HelpD Ident, "DSBFG", "BFG9000 firing"
      HelpD Ident, "DSRXPLOD", "BFG9000 hitd"
      HelpD Ident, "DSPSTART", "Lift starts"
      HelpD Ident, "DSPSTOP", "Lift stops"
      HelpD Ident, "DSSTNMOV", "Ceilings moving"
      HelpD Ident, "DSDOROPN", "Door opens"
      HelpD Ident, "DSDORCLS", "Door closes"
      HelpD Ident, "DSBDOPN", "Fast Door Opens"
      HelpD Ident, "DSBDCLS", "Fast Door Closes"
      HelpD Ident, "DSSWTCHN", "Switch on"
      HelpD Ident, "DSSWTCHX", "Switch on"
      HelpD Ident, "DSTELEPT", "Teleport"
      HelpD Ident, "DSSLOP", "guts"
      HelpD Ident, "DSITMBK", "respawn"
      HelpD Ident, "DSBAREXP", "Barrel explodes"
      HelpD Ident, "DSSKLDTH", "Push on wall"
      HelpD Ident, "DSNOWAY", "Blocked by wall"
      HelpD Ident, "DSOOF", "Hitting ground"
      HelpD Ident, "DSWPNUP", "Weapon pickup"
      HelpD Ident, "DSITEMUP", "Item pickup"
      HelpD Ident, "DSGETPOW", "Power up"
      HelpD Ident, "DSPLPAIN", "Player injured"
      HelpD Ident, "DSPLDETH", "Player death moan"
      HelpD Ident, "DSPDIEHI", "Player death yell"
      HelpD Ident, "DSPOSACT", "Soldier breathing"
      HelpD Ident, "DSPOSIT1", "Soldier sees Player"
      HelpD Ident, "DSPOSIT2", "Soldier sees Player"
      HelpD Ident, "DSPOSIT3", "Soldier sees Player"
      HelpD Ident, "DSPOPAIN", "Soldier injured"
      HelpD Ident, "DSPODTH1", "Soldier dying"
      HelpD Ident, "DSPODTH2", "Soldier dying"
      HelpD Ident, "DSPODTH3", "Soldier dying"
      HelpD Ident, "DSBGACT", "Imps nearby"
      HelpD Ident, "DSBGSIT1", "Imp sees Player"
      HelpD Ident, "DSBGSIT2", "Imp sees Player"
      HelpD Ident, "DSCLAW", "Imp clawing"
      HelpD Ident, "DSPOPAIN", "Imp injured"
      HelpD Ident, "DSBGDTH1", "Imp dying"
      HelpD Ident, "DSBGDTH2", "Imp dying"
      HelpD Ident, "DSSGTSIT", "Demon Player"
      HelpD Ident, "DSDMACT", "Demon nearby"
      HelpD Ident, "DSSGTATK", "Demon chewing"
      HelpD Ident, "DSDMPAIN", "Demon injured"
      HelpD Ident, "DSSGTDTH", "Demon dying"
      HelpD Ident, "DSCACSIT", "Caco sees player"
      HelpD Ident, "DSDMACT", "Caco nearby"
      HelpD Ident, "DSDMPAIN", "Caco injured"
      HelpD Ident, "DSCACDTH", "Caco dying"
      HelpD Ident, "DSBRSSIT", "Baron sees Player"
      HelpD Ident, "DSDMACT", "Baron nearby"
      HelpD Ident, "DSCLAW", "Baron clawing"
      HelpD Ident, "DSDMPAIN", "Baron injured"
      HelpD Ident, "DSBRSDTH", "Baron dying"
      HelpD Ident, "DSSKLATK", "LSoul attacking"
      HelpD Ident, "DSDMACT", "LSoul nearby"
      HelpD Ident, "DSDMPAIN", "LSoul injured"
      HelpD Ident, "DSFIRXPL", "LSoul dying"
      HelpD Ident, "DSSPISIT", "Spider sees Player"
      HelpD Ident, "DSMETAL", "Spider walking"
      HelpD Ident, "DSSPIDTH", "Spider dying"
      HelpD Ident, "DSCYBSIT", "Cyber sees Player"
      HelpD Ident, "DSHOOF", "Cyber walking"
      HelpD Ident, "DSCYBDTH", "Cyber dying"
      HelpD Ident, "DSTINK", "Modem Play"
  End Select
  Select Case typeIWAD()
   Case 12'doom
      HelpD Ident, "DSDBOPN", "Open S-Shotgun"
      HelpD Ident, "DSDBCLS", "Close S-Shotgun"
      HelpD Ident, "DSDBLOAD", "Reload S-Shotgun"
      HelpD Ident, "DSDSHTGN", "Fire S-Shotgun"
      HelpD Ident, "DSSKESIT", "Revenant sees Player"
      HelpD Ident, "DSSKEACT", "Revenant nearby"
      HelpD Ident, "DSSKEATK", "Revenant fires missile"
      HelpD Ident, "DSSKESWG", "Revenant swings"
      HelpD Ident, "DSSKEPCH", "Revenant punches"
      HelpD Ident, "DSSKEDTH", "Revenant dying"
      HelpD Ident, "DSMANSIT", "Mancubis sees Player"
      HelpD Ident, "DSMANATK", "Mancubis attacks"
      HelpD Ident, "DSMNPAIN", "Mancubis injured"
      HelpD Ident, "DSMANDTH", "Mancubis dying"
      HelpD Ident, "DSPESIT", "Pain-E sees Player"
      HelpD Ident, "DSPEPAIN", "Pain-E injured"
      HelpD Ident, "DSPEDTH", "Pain-E dying"
      HelpD Ident, "DSBSPSIT", "BabSpider sees Player"
      HelpD Ident, "DSBSPWLK", "BabSpider walking"
      HelpD Ident, "DSBSPACT", "BabSpider nearby"
      HelpD Ident, "DSBSPDTH", "BabSpider dying"
      HelpD Ident, "DSKNTSIT", "HellKnight sees Player"
      HelpD Ident, "DSDMACT", "HellKnight nearby"
      HelpD Ident, "DSCLAW", "Knight clawing"
      HelpD Ident, "DSDMPAIN", "Knight injured"
      HelpD Ident, "DSKNTDTH", "Knight dying"
      HelpD Ident, "DSVILSIT", "Vile sees Player"
      HelpD Ident, "DSVILACT", "Vile nearby"
      HelpD Ident, "DSVILATK", "Vile attacks"
      HelpD Ident, "DSFLAMST", "Vile Flames"
      HelpD Ident, "DSFLAME", "Vile Flames"
      HelpD Ident, "DSVIPAIN", "Vile injured"
      HelpD Ident, "DSVILDTH", "Vile dying"
      HelpD Ident, "DSBOSSIT", "EndBoss greetings"
      HelpD Ident, "DSBOSPIT", "EndBoss Cube"
      HelpD Ident, "DSBOSCUB", "Cube Lands"
      HelpD Ident, "DSBOSPN", "EndBoss injured"
      HelpD Ident, "DSBOSDTH", "EndBoss dying"
      HelpD Ident, "DSSSSIT", "SS shouts"
      HelpD Ident, "DSSSDTH", "SS dying"
      HelpD Ident, "DSKEENPN", "Keen injured"
      HelpD Ident, "DSKEENDT", "Keen dying"
      HelpD Ident, "DSRADIO", "Phone Sound"
   Case 20, 21, 22
      HelpD Ident, "STFHIT", "staff hit"
      HelpD Ident, "GLDHIT", "Elf wand hit"
      HelpD Ident, "STFPOW", "staff hit+"
      HelpD Ident, "STFCRK", "staff ++"
      HelpD Ident, "GNTACT", "gauntlet"
      HelpD Ident, "GNTFUL", "gaunt ++"
      HelpD Ident, "GNTHIT", "gaunt hit"
      HelpD Ident, "GNTPOW", "gaunt hit+"
      HelpD Ident, "GNTUSE", "gaunt used"
      HelpD Ident, "BOWSHT", "Crossbow"
      HelpD Ident, "HRNHIT", "HellStf hit"
      HelpD Ident, "HRNSHT", "HellStf shot"
      HelpD Ident, "HRNPOW", "HellStf shot+"
      HelpD Ident, "RAMPHIT", "HellStf hit+"
      HelpD Ident, "RAMRAIN", "HellStf rains"
      HelpD Ident, "PHOHIT", "Phoenix hits"
      HelpD Ident, "PHOSHT", "Phoenix shot"
      HelpD Ident, "PHOPOW", "Phoenix shot+"
      HelpD Ident, "LOBSHT", "Mace shot"
      HelpD Ident, "LOBHIT", "Mace hit"
      HelpD Ident, "LOBPOW", "Mace hit+"
      HelpD Ident, "BOUNCE", "Ball bounces"
      HelpD Ident, "NEWPOD", "Gas Pod"
      HelpD Ident, "PODEXP", "Pod Explodes"
      HelpD Ident, "IMPSIT", "Gargoyle sees Player"
      HelpD Ident, "IMPAT1", "Garg. attacks"
      HelpD Ident, "IMPAT2", "Garg. attacks"
      HelpD Ident, "IMPDTH", "Garg. dying"
      HelpD Ident, "IMPPAI", "Garg. injured"
      HelpD Ident, "MUMSIT", "Golem sees Player"
      HelpD Ident, "MUMAT1", "Golem attacks"
      HelpD Ident, "MUMAT2", "Golem attacks"
      HelpD Ident, "MUMDTH", "Golem dying"
      HelpD Ident, "MUMPAI", "Golem injured"
      HelpD Ident, "MUMHE", "NitroGolem"
      HelpD Ident, "BLSSHT", "Skull shot"
      HelpD Ident, "BLSHIT", "Skull hit"
      HelpD Ident, "KGTSIT", "Knight sees Player"
      HelpD Ident, "KGTATK", "Knight attacks"
      HelpD Ident, "KGTAT2", "Knight attacks"
      HelpD Ident, "KGTDTH", "Knight dying"
      HelpD Ident, "KGTPAI", "Knight injured"
      HelpD Ident, "WIZSIT", "Wizard sees Player"
      HelpD Ident, "WIZATK", "Wizard attacks"
      HelpD Ident, "WIZDTH", "Wizard dying"
      HelpD Ident, "WIZACT", "Wizard"
      HelpD Ident, "WIZPAI", "Wizard injured"
      HelpD Ident, "HEDSIT", "Head attacks"
      HelpD Ident, "HEDAT1", "Head attacks"
      HelpD Ident, "HEDAT2", "Head attacks"
      HelpD Ident, "HEDDTH", "Head dying"
      HelpD Ident, "HEDACT", "Head"
      HelpD Ident, "HEDPAI", "Head injured"
      HelpD Ident, "BSTACT", "WereDragon"
      HelpD Ident, "BSTSIT", "WereD sees player"
      HelpD Ident, "BSTATK", "WereD attacks"
      HelpD Ident, "BSTDT", "WereD dying"
      HelpD Ident, "BSTPAI", "WereD injujed"
      HelpD Ident, "CLKACT", "SabreClaw"
      HelpD Ident, "CLKSIT", "SabreC sees player"
      HelpD Ident, "CLKATK", "SabreC attacks"
      HelpD Ident, "CLKDTH", "SabreC dying"
      HelpD Ident, "CLKPAI", "SabreC injured"
      HelpD Ident, "SNKACT", "Ophidian"
      HelpD Ident, "SNKSIT", "Ophd sees player"
      HelpD Ident, "SNKATK", "Ophd attacks"
      HelpD Ident, "SNKDTH", "Ophd dying"
      HelpD Ident, "SNKPAI", "Ophd injured"
      HelpD Ident, "MINACT", "Minautor"
      HelpD Ident, "MINSIT", "Min. sees player"
      HelpD Ident, "MINAT1", "Min. attacks"
      HelpD Ident, "MINAT2", "Min. attacks"
      HelpD Ident, "MINDTH", "Min. dying"
      HelpD Ident, "MINPAI", "Min. injured"
      HelpD Ident, "SORACT", "Sorcerer"
      HelpD Ident, "SORZAP", "Sorc. teleport"
      HelpD Ident, "SORRISE", "Sorc. appears"
      HelpD Ident, "SORSIT", "Sorc. sees Player"
      HelpD Ident, "SORATK", "Sorc. attacks"
      HelpD Ident, "SORPAI", "Sorc. injured"
      HelpD Ident, "SORDSPH", "Sorc. Dying"
      HelpD Ident, "SORDEXP", "Sorc. Explodes"
      HelpD Ident, "SORDBON", "Bones drop"
      HelpD Ident, "SBTACT", "Dragon"
      HelpD Ident, "SBTDTH", "Dragon dying"
      HelpD Ident, "SBTPAI", "Dragon injured"
      HelpD Ident, "PLROOF", "Player lands"
      HelpD Ident, "PLRPAI", "Player injured"
      HelpD Ident, "PLRDTH", "Player dying"
      HelpD Ident, "PLRWDTH", "Player dying"
      HelpD Ident, "PLRCDTH", "Player dying"
      HelpD Ident, "CHICPAI", "Bird injured"
      HelpD Ident, "CHICATK", "Bird attacks"
      HelpD Ident, "CHICDTH", "Bird dying"
      HelpD Ident, "CHICACT", "Bird"
      HelpD Ident, "CHICPK1", "Bird peaks"
      HelpD Ident, "CHICPK2", "Bird peaks"
      HelpD Ident, "CHICPK2", "Bird peaks"
      HelpD Ident, "GIBDTH", "Gib death"
      HelpD Ident, "KEYUP", "take Key"
      HelpD Ident, "ITEMUP", "take Item"
      HelpD Ident, "RESPAWN", "Item regenerated"
      HelpD Ident, "WPNUP", "take Weapon"
      HelpD Ident, "ARTIUP", "take Artifact"
      HelpD Ident, "CHAT", "Modem Chat"
      HelpD Ident, "GFRAG", "Frag Count"
      HelpD Ident, "ARTIUSE", "use artifact"
      HelpD Ident, "SWITCH", "switch"
      HelpD Ident, "DOROPN", "Door Open"
      HelpD Ident, "DORCLS", "Door Close"
      HelpD Ident, "DORMOV", "Door Move"
      HelpD Ident, "TELEPT", "Teleport"
      HelpD Ident, "PSTART", "platform start"
      HelpD Ident, "PSTOP", "platform stop"
      HelpD Ident, "STNMOV", "platform move"
      HelpD Ident, "AMB??", "Ambiance [01-15]"
      HelpD Ident, "WATERFL", "Water flowing"
      HelpD Ident, "WIND", "wind blowing"
      HelpD Ident, "RIPSLOP", "squished"
      HelpD Ident, "BURN", "flame"
      HelpD Ident, "GLOOP", "splash"
  End Select

End Sub

Sub PcLst_Click ()
  If PcLst.ListIndex < 0 Then Exit Sub
  Dim entry As String
  Dim nam As String
  Dim X As Integer
  Dim Y As Integer
  Dim repeat As Integer
  entry = EntryGet(X, Y, nam, repeat, PcLst.Text)
End Sub

Sub PcLst_DblClick ()
  'edit TEXT files only
  If PcLst.ListIndex < 0 Then Exit Sub
  Dim entry As String
  Dim nam As String
  Dim X As Integer
  Dim Y As Integer
  Dim repeat As Integer
  entry = EntryGet(X, Y, nam, repeat, PcLst.Text)
  If repeat Then Exit Sub
  Call EditTextFile(MakeFileName(WorkDirec.Caption, nam & ".txt"))
End Sub

Sub PcLst_KeyDown (KeyCode As Integer, Shift As Integer)
  Select Case KeyCode
    Case KEY_DELETE
      Call EntryDelete(PcLst, WorkDirec.Caption, ".TXT")
      ListDirty = True
  End Select
End Sub

Sub SoundLst_Click ()
  If SoundLst.ListIndex < 0 Then Exit Sub
  Dim entry As String
  Dim nam As String
  Dim X As Integer
  Dim Y As Integer
  Dim repeat As Integer
  entry = EntryGet(X, Y, nam, repeat, SoundLst.Text)
  'modify values
  If repeat Then ERepeat.Value = 1 Else ERepeat.Value = 0
  Call HelpMatch(Ident, entry)
End Sub

Sub SoundLst_DblClick ()
  'play WAVE files only
  If SoundLst.ListIndex < 0 Then Exit Sub
  Dim entry$, nam$
  Dim X%, Y%, repeat%
  entry = EntryGet(X, Y, nam, repeat, SoundLst.Text)
  'don't edit sound here
  If repeat Then Exit Sub
  Call PlaySound(MakeFileName(WorkDirec.Caption, nam & ".wav"))
End Sub

Sub SoundLst_KeyDown (KeyCode As Integer, Shift As Integer)
  Select Case KeyCode
    Case KEY_DELETE
      Call EntryDelete(SoundLst, WorkDirec.Caption, ".WAV")
      ListDirty = True
  End Select
End Sub

Sub WadInfo_Change ()
  Call LoadHelpSound
  Ident.ListIndex = 0
  'Init Sound List
  Select Case typeIWAD()
    Case 20, 21, 22
     PcLst.Enabled = False
     Cmd(4).Enabled = False 'new PC sound
  End Select
   ' 5 = no X Y offset, repeat
   Call SectionRead(SoundLst, WadInfo.Caption, "SOUNDS", 5)
   Dim entry As String
   Dim n As Integer
   For n = SoundLst.ListCount - 1 To 0 Step -1
     entry = SoundLst.List(n)
     If entry Like "DP*" Then
       PcLst.AddItem (entry)
       SoundLst.RemoveItem (n)
     ElseIf entry Like "D_*" Then
       SoundLst.RemoveItem (n)
     ElseIf entry Like "MUS*" Then
       SoundLst.RemoveItem (n)
     End If
   Next n
   If SoundLst.ListCount > 0 Then SoundLst.ListIndex = 0
   If PcLst.ListCount > 0 Then PcLst.ListIndex = 0
End Sub

