VERSION 2.00
Begin Form EdtPatch 
   Caption         =   "Edit Patches"
   ClientHeight    =   5730
   ClientLeft      =   1305
   ClientTop       =   900
   ClientWidth     =   6465
   ClipControls    =   0   'False
   Height          =   6105
   HelpContextID   =   700
   Icon            =   EDTPATCH.FRX:0000
   Left            =   1260
   LinkTopic       =   "Form1"
   ScaleHeight     =   382
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   431
   Top             =   570
   Width           =   6555
   Begin Frame PicFrame 
      BackColor       =   &H00C0C0C0&
      ClipControls    =   0   'False
      Height          =   3915
      HelpContextID   =   4010
      Left            =   1980
      TabIndex        =   12
      Top             =   60
      Width           =   4395
      Begin PictureBox PatPic 
         BackColor       =   &H00FFFF00&
         BorderStyle     =   0  'None
         Height          =   3735
         Left            =   60
         ScaleHeight     =   249
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   285
         TabIndex        =   13
         Top             =   120
         Width           =   4275
      End
   End
   Begin TextBox PatName 
      Height          =   315
      Left            =   5040
      TabIndex        =   8
      Text            =   "PATCH"
      Top             =   5220
      Width           =   1335
   End
   Begin FileListBox PatLst 
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   1470
      Left            =   2040
      Pattern         =   "*.bmp"
      TabIndex        =   7
      Top             =   4140
      Width           =   1695
   End
   Begin CommandButton Exit 
      BackColor       =   &H00808080&
      Caption         =   "Quit"
      Height          =   315
      Left            =   360
      TabIndex        =   4
      Top             =   120
      Width           =   1155
   End
   Begin CommandButton Cmd 
      Caption         =   "Rename"
      Height          =   315
      HelpContextID   =   4050
      Index           =   1
      Left            =   3900
      TabIndex        =   3
      Top             =   5220
      Width           =   1035
   End
   Begin CommandButton Cmd 
      Caption         =   "Add"
      Height          =   315
      HelpContextID   =   4020
      Index           =   0
      Left            =   360
      TabIndex        =   2
      Top             =   4620
      Width           =   1155
   End
   Begin CommandButton Cmd 
      Caption         =   "Import"
      Height          =   315
      HelpContextID   =   4040
      Index           =   2
      Left            =   360
      TabIndex        =   1
      Top             =   4140
      Width           =   1155
   End
   Begin ListBox EntryName 
      BackColor       =   &H00808080&
      Height          =   2955
      HelpContextID   =   4045
      Left            =   120
      TabIndex        =   0
      Top             =   1080
      Width           =   1695
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   6
      X1              =   112
      X2              =   124
      Y1              =   284
      Y2              =   288
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   2
      X1              =   124
      X2              =   112
      Y1              =   288
      Y2              =   292
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   5
      X1              =   152
      X2              =   64
      Y1              =   320
      Y2              =   320
   End
   Begin Image CmdForget 
      Height          =   480
      Left            =   600
      Picture         =   EDTPATCH.FRX:0302
      Top             =   5100
      Width           =   480
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   4
      X1              =   148
      X2              =   64
      Y1              =   288
      Y2              =   288
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   0
      X1              =   152
      X2              =   64
      Y1              =   360
      Y2              =   360
   End
   Begin Label Info 
      Alignment       =   2  'Center
      Caption         =   "Warning: If a patch listed here is used in any texture, it will automatically be added to your WAD."
      Height          =   795
      Index           =   2
      Left            =   3900
      TabIndex        =   11
      Top             =   4320
      Width           =   2415
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   3
      X1              =   368
      X2              =   240
      Y1              =   360
      Y2              =   360
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   1
      X1              =   64
      X2              =   64
      Y1              =   248
      Y2              =   288
   End
   Begin Label Info 
      Alignment       =   2  'Center
      Caption         =   "Patches In Main Wad"
      ForeColor       =   &H00800000&
      Height          =   375
      Index           =   1
      Left            =   360
      TabIndex        =   10
      Top             =   600
      Width           =   1275
   End
   Begin Label Info 
      Alignment       =   2  'Center
      Caption         =   "Redefined Patches"
      ForeColor       =   &H00800000&
      Height          =   195
      Index           =   0
      Left            =   3840
      TabIndex        =   9
      Top             =   4020
      Width           =   1755
   End
   Begin Label WadInfo 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      BackStyle       =   0  'Transparent
      Caption         =   "wadinfo.txt"
      ForeColor       =   &H000000FF&
      Height          =   255
      Left            =   1080
      TabIndex        =   6
      Top             =   5100
      Visible         =   0   'False
      Width           =   915
   End
   Begin Label WorkDirec 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      BackStyle       =   0  'Transparent
      Caption         =   "work dir"
      ForeColor       =   &H000000FF&
      Height          =   195
      Left            =   1140
      TabIndex        =   5
      Top             =   5460
      Visible         =   0   'False
      Width           =   855
   End
End
Option Explicit
Dim PatFileNam$  'name of the file displayed

Sub Cmd_Click (Index As Integer)
   Dim file$, file2$
   Dim nam$

  Select Case Index
    Case 0 'new
      If Not Tutor("add a new patch to the list. The entry name corresponds to the file name.") Then Exit Sub
      file = ChooseFile(".", "*.bmp", True, "Select a new graphic file (.BMP)")
      If Not DIRexistFile(file) Then Exit Sub
      nam = FileName(file)
      file2 = MakeFileName(WorkDirec.Caption, nam)
      Call EditCopyFile(file, file2)
      nam = FileRoot(file)
    Case 1 'rename
      If Not Tutor("rename a patch using a name taken from the adjacent text box.") Then Exit Sub
      If PatLst.ListIndex < 0 Then Exit Sub
      nam$ = PatLst.FileName
      file = MakeFileName(PatLst.Path, nam$)
      If Not DIRexistFile(file) Then Exit Sub
      file2 = MakeFileName(PatLst.Path, Trim$(Left$(PatName.Text, 8)) & ".bmp")
      Name file As file2
    Case 2 'import
      If EntryName.ListIndex < 0 Then Exit Sub
      nam$ = EntryName.Text
      Dim ofx%, ofy%
      If Not WADexportName(PatLst.Path, nam$, ofx%, ofy%) Then Exit Sub
  End Select
  PatLst.Refresh
End Sub

Sub CmdForget_Click ()
  If PatLst.ListIndex < 0 Then Exit Sub
  Dim file$
  file$ = MakeFileName(PatLst.Path, PatLst.FileName)
  If DIRexistFile(file$) Then Kill file$
  PatLst.Refresh
End Sub

Sub EntryName_Click ()
   If EntryName.ListIndex < 0 Then Exit Sub
   Call WADshowName(PatPic, EntryName.Text)
End Sub

Sub EntryName_KeyPress (KeyAscii As Integer)
  KeyAscii = WADnameSeek(EntryName, KeyAscii)
End Sub

Sub Exit_Click ()
   Unload Me
End Sub

Sub Info_Click (Index As Integer)
  Select Case Index
    Case 0
      Call Infos("The picture files listed here define your new patches, use in your textures.")
    Case 1
      Call Infos("These are patches existing in the main WAD. Import them, and you can alter them. Warning: that will change all the textures that make use of that patch.")
    End Select
End Sub

Sub PatLst_Click ()
   If PatLst.ListIndex < 0 Then Exit Sub
   'load file if exists
   Dim filenam$
   filenam$ = MakeFileName(PatLst.Path, PatLst.FileName)
   Call Display(PatPic, PatFileNam, filenam$)
End Sub

Sub PatLst_DblClick ()
   If PatLst.ListIndex < 0 Then Exit Sub
   Dim file$
   file$ = MakeFileName(PatLst.Path, PatLst.FileName)
   Call EditBmpFile(file$)
End Sub

Sub PatLst_KeyDown (KeyCode As Integer, Shift As Integer)
 If KeyCode <> KEY_DELETE Then Exit Sub
 Call CmdForget_Click
End Sub

Sub PatName_Change ()
   PatName.Text = UCase$(Trim$(PatName.Text))
End Sub

Sub PatPic_Click ()
    Call EditBmpFile(PatFileNam)
End Sub

Sub WorkDirec_Change ()
   If Not DIRexistDir(WorkDirec.Caption) Then Exit Sub
   PatLst.Path = WorkDirec.Caption
End Sub

