VERSION 2.00
Begin Form EdtMusic 
   Caption         =   "Edit Music"
   ClientHeight    =   4410
   ClientLeft      =   1110
   ClientTop       =   1590
   ClientWidth     =   6255
   ClipControls    =   0   'False
   Height          =   4785
   HelpContextID   =   900
   Icon            =   EDTMUSIC.FRX:0000
   Left            =   1065
   LinkTopic       =   "Form1"
   ScaleHeight     =   4410
   ScaleWidth      =   6255
   Top             =   1260
   Width           =   6345
   Begin CommandButton Cmd 
      Caption         =   "Rename"
      Height          =   315
      HelpContextID   =   4050
      Index           =   1
      Left            =   3480
      TabIndex        =   12
      Top             =   3540
      Width           =   1155
   End
   Begin CommandButton Cmd 
      Caption         =   "convert to MIDI"
      Height          =   315
      Index           =   3
      Left            =   1800
      TabIndex        =   11
      Top             =   600
      Width           =   1515
   End
   Begin ComboBox Ident 
      Height          =   300
      HelpContextID   =   4060
      Left            =   1980
      TabIndex        =   10
      Text            =   "HELP"
      Top             =   4020
      Width           =   4155
   End
   Begin CommandButton Cmd 
      Caption         =   "Import MIDI file"
      Height          =   315
      HelpContextID   =   4020
      Index           =   4
      Left            =   1800
      TabIndex        =   9
      Top             =   180
      Width           =   1515
   End
   Begin CommandButton Cmd 
      Caption         =   "Add"
      Height          =   315
      Index           =   0
      Left            =   3480
      TabIndex        =   8
      Top             =   3120
      Width           =   1155
   End
   Begin ListBox MusLst 
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Courier"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   1980
      Left            =   1920
      TabIndex        =   7
      Top             =   1020
      Width           =   4215
   End
   Begin CommandButton Cmd 
      Caption         =   "Import"
      Height          =   315
      HelpContextID   =   4040
      Index           =   2
      Left            =   1980
      TabIndex        =   6
      Top             =   3540
      Width           =   1155
   End
   Begin ListBox EntryName 
      BackColor       =   &H00808080&
      Height          =   3150
      HelpContextID   =   4045
      Left            =   120
      TabIndex        =   5
      Top             =   1140
      Width           =   1635
   End
   Begin CommandButton CmdSave 
      BackColor       =   &H00808080&
      Caption         =   "Save"
      Height          =   315
      HelpContextID   =   4070
      Left            =   180
      TabIndex        =   4
      Top             =   540
      Width           =   1155
   End
   Begin CommandButton Exit 
      BackColor       =   &H00808080&
      Caption         =   "Quit"
      Height          =   315
      Left            =   180
      TabIndex        =   2
      Top             =   120
      Width           =   1155
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   1
      X1              =   2580
      X2              =   2580
      Y1              =   1260
      Y2              =   300
   End
   Begin Image CmdForget 
      Height          =   480
      Left            =   5340
      Picture         =   EDTMUSIC.FRX:0302
      Top             =   3180
      Width           =   480
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   4
      X1              =   2580
      X2              =   2520
      Y1              =   3420
      Y2              =   3240
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   7
      X1              =   2520
      X2              =   2460
      Y1              =   3240
      Y2              =   3420
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   0
      X1              =   4080
      X2              =   4080
      Y1              =   4200
      Y2              =   2760
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   3
      X1              =   2520
      X2              =   2520
      Y1              =   2760
      Y2              =   3600
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   5
      X1              =   1560
      X2              =   2580
      Y1              =   3720
      Y2              =   3720
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   2
      X1              =   5580
      X2              =   5580
      Y1              =   3300
      Y2              =   2760
   End
   Begin Label info 
      Alignment       =   2  'Center
      Caption         =   "The music files are under a non-standard format (MUS). Conversion to and from MIDI is needed before editing."
      Height          =   795
      Left            =   3540
      TabIndex        =   3
      Top             =   120
      Width           =   2475
   End
   Begin Label WadInfo 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      BackStyle       =   0  'Transparent
      Caption         =   "wadinfo.txt"
      ForeColor       =   &H00000080&
      Height          =   195
      Left            =   5040
      TabIndex        =   1
      Top             =   3720
      Visible         =   0   'False
      Width           =   975
   End
   Begin Label WorkDirec 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      BackStyle       =   0  'Transparent
      Caption         =   "work dir"
      ForeColor       =   &H00000080&
      Height          =   195
      Left            =   1860
      TabIndex        =   0
      Top             =   3120
      Visible         =   0   'False
      Width           =   615
   End
End
Option Explicit
Dim ListDirty As Integer  'changes in list?

Sub Cmd_Click (Index As Integer)
  Dim file$, file2$
  Dim entry$, nam$
  Dim X%, Y%, repeat%
  Select Case Index
    Case 0  'new music
       If Not Tutor("add a new music to the list. The entry name is taken from the drop box.") Then Exit Sub
      entry = HelpGetName(Ident, True)
      If Len(entry) <= 0 Then Exit Sub
      file = ChooseFile(".", "*.mus", True, "Select a new Music file (.MUS)")
      If Not DIRexistFile(file) Then Exit Sub
      nam = FileName(file)
      file2 = MakeFileName(WorkDirec.Caption, nam)
      Call EditCopyFile(file, file2)
      nam = FileRoot(file)
      nam = EntryMake(entry, INVALID, INVALID, nam, False)
      If Len(nam) <= 0 Then Exit Sub
      MusLst.ListIndex = ListInsert(MusLst, nam$)
      ListDirty = True
    Case 1  'rename music
      If Not Tutor("rename a music using a name taken from the drop box.") Then Exit Sub
      If MusLst.ListIndex < 0 Then Exit Sub
      entry = EntryGet(X, Y, nam, repeat, MusLst.Text)
      entry = HelpGetName(Ident, True)
      If Len(entry) <= 0 Then Exit Sub
      nam = EntryMake(entry, INVALID, INVALID, nam, False)
      If Len(nam) <= 0 Then Exit Sub
      MusLst.List(MusLst.ListIndex) = nam
      ListDirty = True
    Case 2 'import
      If EntryName.ListIndex < 0 Then Exit Sub
      entry$ = EntryName.Text
      Dim ofx%, ofy%
      If Not WADexportName(WorkDirec.Caption, entry$, ofx%, ofy%) Then Exit Sub
      nam = EntryMake(entry$, INVALID, INVALID, entry$, False)
      If Len(nam) <= 0 Then Exit Sub
      MusLst.ListIndex = ListInsert(MusLst, nam$)
      ListDirty = True
    Case 3  'mus2midi
      If Not Tutor("convert your music file to MIDI so that it can be played and edited.") Then Exit Sub
      If MusLst.ListIndex < 0 Then Exit Sub
      entry = EntryGet(X, Y, nam, repeat, MusLst.Text)
      file = MakeFileName(WorkDirec.Caption, nam & ".mus")
      Call EditMus2Midi(file)
    Case 4  'New midi
      If Not Tutor("add a new file, taking it as MIDI, and converting it to MUS format.") Then Exit Sub
      entry = HelpGetName(Ident, True)
      If Len(entry) <= 0 Then Exit Sub
      file = ChooseFile(".", "*.mid", True, "Select a new Music file (MIDI)")
      If Not DIRexistFile(file) Then Exit Sub
      nam = FileName(file)
      file2 = MakeFileName(WorkDirec.Caption, nam)
      Call EditCopyFile(file, file2)
      Call EditMidi2Mus(file2)
      nam = FileRoot(file)
      nam = EntryMake(entry, INVALID, INVALID, nam, False)
      If Len(nam) <= 0 Then Exit Sub
      MusLst.ListIndex = ListInsert(MusLst, nam$)
      ListDirty = True
  End Select
End Sub

Sub CmdSave_Click ()
  If Not Tutor("save the modifications") Then Exit Sub
  If Not ListDirty Then Exit Sub
  Call SectionWrite(MusLst, WadInfo.Caption, "MUSICS")
  ListDirty = False
End Sub

Sub EntryName_Click ()
   If EntryName.ListIndex < 0 Then Exit Sub
   Call WADshowName(MusLst, EntryName.Text)
   Call HelpMatch(Ident, Trim$(EntryName.Text))
End Sub

Sub EntryName_KeyPress (KeyAscii As Integer)
   KeyAscii = WADnameSeek(EntryName, KeyAscii)
End Sub

Sub Exit_Click ()
  Unload Me
End Sub

Sub Form_Load ()
 ListDirty = False
End Sub

Sub Form_Unload (Cancel As Integer)
  If Not ListDirty Then Exit Sub
  If QueryOk("Save file " & WadInfo.Caption & " ?") Then Call CmdSave_Click
End Sub

Sub Ident_Change ()
  Call HelpCheckSelect(Ident)
End Sub

Sub Ident_KeyDown (KeyCode As Integer, Shift As Integer)
   If KeyCode = KEY_DELETE Then KeyCode = 0
End Sub

Sub Ident_KeyPress (KeyAscii As Integer)
    KeyAscii = HelpKeyPress(Ident, KeyAscii)
End Sub

Sub LoadHelpMusic ()
  Dim m%
  Select Case typeIWAD()
   Case 10, 11 'doom
      For m = 1 To 9
        HelpD Ident, "D_E1M" & m, "Ep1 mission" & m
      Next m
      For m = 1 To 9
        HelpD Ident, "D_E2M" & m, "Ep2 mission" & m
      Next m
      For m = 1 To 9
        HelpD Ident, "D_E3M" & m, "Ep3 mission" & m
      Next m
   Case 12  'doom2
      HelpD Ident, "RUNNIN", "Level 01"
      HelpD Ident, "STALKS", "Level 02"
      HelpD Ident, "COUNTD", "Level 03"
      HelpD Ident, "BETWEE", "Level 04"
      HelpD Ident, "DOOM", "Level 05"
      HelpD Ident, "THE_DA", "Level 06"
      HelpD Ident, "SHAWN", "Level 07"
      HelpD Ident, "DDTBLU", "Level 08"
      HelpD Ident, "IN_CIT", "Level 09"
      HelpD Ident, "DEAD", "Level 10"
      HelpD Ident, "STLKS2", "Level 11"
      HelpD Ident, "THEDA2", "Level 12"
      HelpD Ident, "DOOM2", "Level 13"
      HelpD Ident, "DDTBL2", "Level 14"
      HelpD Ident, "RUNNI2", "Level 15"
      HelpD Ident, "DEAD2", "Level 16"
      HelpD Ident, "STLKS3", "Level 17"
      HelpD Ident, "ROMERO", "Level 18"
      HelpD Ident, "SHAWN2", "Level 19"
      HelpD Ident, "MESSAG", "Level 20"
      HelpD Ident, "COUNT2", "Level 21"
      HelpD Ident, "DDTBL3", "Level 22"
      HelpD Ident, "AMPIE", "Level 23"
      HelpD Ident, "THEDA3", "Level 24"
      HelpD Ident, "ADRIAN", "Level 25"
      HelpD Ident, "MESSG2", "Level 26"
      HelpD Ident, "ROMER2", "Level 27"
      HelpD Ident, "TENSE", "Level 28"
      HelpD Ident, "SHAWN3", "Level 29"
      HelpD Ident, "OPENIN", "Level 30"
      HelpD Ident, "EVIL", "Level 31 Wolf"
      HelpD Ident, "ULTIMA", "Level 32 Keen"
      HelpD Ident, "READ_M", "Read me"
      HelpD Ident, "DM2TTL", "Title music"
      HelpD Ident, "DM2INT", "Intro music"
   Case 20, 21, 22'heretic
      HelpD Ident, "MUS_TITL", "Title music"
      HelpD Ident, "MUS_INTR", "Intro music"
      HelpD Ident, "MUS_CPTD", "Count down"
      For m = 1 To 9
        HelpD Ident, "MUS_E1M" & m, "Ep1 mission" & m
      Next m
      For m = 1 To 9
        HelpD Ident, "MUS_E2M" & m, "Ep2 mission" & m
      Next m
      HelpD Ident, "MUS_E3M2", "Ep3 mission2"
      HelpD Ident, "MUS_E3M3", "Ep3 mission3"
  End Select
  Ident.ListIndex = 0
End Sub

Sub MusLst_Click ()
  If MusLst.ListIndex < 0 Then Exit Sub
  Dim entry$, nam$
  Dim X%, Y%, repeat%
  entry = EntryGet(X, Y, nam, repeat, MusLst.Text)
  Call HelpMatch(Ident, entry)
End Sub

Sub MusLst_DblClick ()
  'play MIDI files only
  If MusLst.ListIndex < 0 Then Exit Sub
  Dim entry$, nam$
  Dim X%, Y%, repeat%
  entry = EntryGet(X, Y, nam, repeat, MusLst.Text)
  If repeat Then Exit Sub
  Dim file$
  file = MakeFileName(WorkDirec.Caption, nam & ".mid")
  If DIRexistFile(file) Then
    Call PlayMidi(file)
  Else
     file = MakeFileName(WorkDirec.Caption, nam & ".mus")
     If Not DIRexistFile(file) Then
       Call Crash("There is no MUS file " & file)
     Else
       If Not QueryOk("Convert " & nam & " to MIDI?") Then Exit Sub
       Call EditMus2Midi(file)
     End If
  End If
End Sub

Sub MusLst_KeyDown (KeyCode As Integer, Shift As Integer)
  Select Case KeyCode
    Case KEY_DELETE
      Call EntryDelete(MusLst, WorkDirec.Caption, ".MUS")
      ListDirty = True
  End Select
End Sub

Sub WadInfo_Change ()
  'helps
  Call LoadHelpMusic
  Ident.ListIndex = 0
  'Init Sound List
  ' 5 = no X Y offset, repeat
  Call SectionRead(MusLst, WadInfo.Caption, "MUSICS", 5)
  If MusLst.ListCount > 0 Then MusLst.ListIndex = 0
End Sub

