/*
  DEUTEX is Copyright (c) 1994,1995 Olivier Montanuy (montanuy@lannion.cnet.fr)

  Legal stuff:
   You can reuse any part of this copyrighted code in any freeware project you wish.
   However I request that you give me some credit for the code you reuse
   If you want to release a modified version of DeuTex, or a version included in another
   program, I request that you warn me by e-mail, because since I don't have much
   time to improve that program, I'd like to know what happens to it.
   
   You are NOT ALLOWED to make ANY commercial derivative from this code without my written
   consent (which isn't hard to get provided you play fair).
                
  Technical stuff:
   This source is released because I lack time to improve it myself.
   Many many parts could be greatly improved, and some should be entirely rewritten.
   I hope it will at least be usefull for inspiration, if nothing else.
*/
/*
  DeuTex is a sequel to the DOOM editor DEU 5.21 (hence the name)
  Originaly it used lots of code from DEU, and even some DEU modules
  Now it doesn't use anymore DEU modules, but large parts of this
  code are still inspired by the great DEU code, though the style
  is quite different.

  I wrote this code with the intent to limit bug generation and
  propagation to a minimum. That means modules, no global variables,
  a lot of mess in the parameters.
  I deliberately coded very basic functions, not optimised at all.
  Optimisation will come later.
  That means: No hash table, No fast color quantisation...

  If you find that code verbose, you are damn right.
  But I'm quite proud of my coding time/testing time ratio of 5,
  considering that code already works on so many PWADs.

  I would strongly advise *not* to reuse this code, unless you
  like my bugs and take the engagement to treat them well.
  I'm so fond of them now...
*/


#define VERBOSE_COMMENT                TRUE
#define AUTO_BUG_INSERT                TRUE

#include "deutex.h"
#include <ctype.h>
#include "tools.h"
#include "mkwad.h"
#include "merge.h"
#include "extract.h"



/*compile only for DeuTex*/
#if (defined DeuTex)||(defined DeuSF)





/*
**  global variables for commands
*/
char file[128];        /* general use file name*/

static WADTYPE Type;        /*IWAD type*/
static NTRYB Select;

static char *DataDir=NULL;
static char *DoomDir=NULL;
static char MainWAD[128];     /* name of the main wad file */
#if defined DeuTex
static char WadInf[128];     /* name of the wadinfo file */
static Bool WadInfOk;
Int16 HowMuchJunk;           /* junk to add*/
static IMGTYPE Picture;   /*save as GIF or BMP?*/
static SNDTYPE Sound;     /*save as WAV or AU?*/
static Bool fullSND;
static Bool WSafe;
static Bool George;
#endif /*DeuTex*/
char trnR,trnG,trnB;


              /* junk to add */
/*
** commands
*/
void COMhelp(Int16 argc, char **argv);
void COMformat(Int16 argc, char **argv);
/*
** WinTex comand line replaces
** -out
** -v3
** -doom       doom directory
** -dir        data directory
** -sel        select byte
** -colRrGgBb  red = (R-'A')*16+(r-'A')
*/
#if defined DeuTex
void COMwintxn(Int16 argc, char **argv)
{  char *num;
   PrintInit(TRUE);                /*-out*/
   PrintVerbosity(3);                /*-v3*/
   DoomDir=argv[1];                /*doom*/
   DataDir=argv[2];                /*data*/
   MakeFileName(WadInf,DataDir,"","",argv[3],"TXT");
   WadInfOk=TRUE;
   Select|= atoi(argv[4]);        /*select*/
   num = argv[5];                /*color*/
   if(strlen(num)<6) ProgError("Bad Color");
   trnR= (((num[0]&0xF)<<4)+(num[1]&0xF))&0xFF;
   trnG= (((num[2]&0xF)<<4)+(num[3]&0xF))&0xFF;
   trnB= (((num[4]&0xF)<<4)+(num[5]&0xF))&0xFF;
   Info("Transparent color is R=%d G=%d B=%d\n",
    ((int)trnR&0xFF),((int)trnG&0xFF),((int)trnB&0xFF));
   (void)argc;
}
void COMwintxm(Int16 argc, char **argv)
{  PrintInit(TRUE);                /*-out*/
   PrintVerbosity(3);                /*-v3*/
   DoomDir=argv[1];                /*doom*/
   DataDir=".";
   Select|= atoi(argv[2]);        /*select*/
   trnR= 0;trnG= 255;trnB= 255;
   (void)argc;
}
#endif /*DeuTex*/
void COMwintex(Int16 argc, char **argv)
{  PrintInit(TRUE);                /*-out*/
   PrintVerbosity(3);                /*-v3*/
   DoomDir=NULL;
   strncpy(MainWAD,argv[1],128);/*main*/
   DataDir=".";
   Select|= BALL;                /*select*/
   trnR= 0;trnG= 255;trnB= 255;
   (void)argc;
}
void COMverbose(Int16 argc, char **argv)
{  PrintVerbosity(argv[0][2]-'0');
   Info("Verbosity level is %c.\n",argv[0][2]);
   (void)argc;
}
void COMdoom(Int16 argc, char **argv)
{  DoomDir=argv[1];
	Info("Main directory: %s.\n",DoomDir);
	(void)argc;
}
void COMmain(Int16 argc, char **argv)
{  DoomDir=NULL;
	strncpy(MainWAD,argv[1],128);
	Info("Main IWAD file: %s.\n",MainWAD);
	(void)argc;
}
void COMwadir(Int16 argc, char **argv)
{ XTRlistDir(MainWAD,((argc<2)? NULL: argv[1]),Select);
}
void COMadd(Int16 argc, char **argv)
{ ADDallSpriteFloor(argv[2],MainWAD,argv[1],Select);
  (void)argc;
}
void COMapp(Int16 argc, char **argv)
{ ADDappendSpriteFloor(MainWAD,argv[1],Select);
  (void)argc;
}
void COMapps(Int16 argc, char **argv)
{ Select= (BALL) & (~BFLAT); /*no flats*/
  ADDappendSpriteFloor(MainWAD,argv[1],Select);
  (void)argc;
}
void COMappf(Int16 argc, char **argv)
{ Select= (BALL) & (~BSPRITE); /*no sprites*/
  ADDappendSpriteFloor(MainWAD,argv[1],Select);
  (void)argc;
}
void COMjoin(Int16 argc, char **argv)
{ ADDjoinWads(MainWAD,argv[1],argv[2],Select);
  (void)argc;
}
void COMmerge(Int16 argc, char **argv)
{ Select     = BALL;
  PSTmergeWAD(MainWAD,argv[1],Select);
  (void)argc;
}
void COMrestor(Int16 argc, char **argv)
{ HDRrestoreWAD((argc>=2)? argv[1]:MainWAD);
}


#if defined DeuSF
/*
** Selections
*/
void COMsprit(Int16 argc, char **argv)
{ Select&= ~BFLAT;
  Info("Select SPRITES\n");
  (void)argc;(void)argv;
}
void COMflat(Int16 argc, char **argv)
{ Select&= ~BSPRITE;
  Info("Select FLATS\n");
  (void)argc;(void)argv;
}
#endif /*DeuSF*/
#if defined DeuTex
/*
** Selections
*/
void COMsprit(Int16 argc, char **argv)
{ Select|=BSPRITE;
  Info("Select SPRITES\n");
  (void)argc;(void)argv;
}
void COMflat(Int16 argc, char **argv)
{ Select|=BFLAT;
  Info("Select FLATS\n");
  (void)argc;(void)argv;
}
void COMlevel(Int16 argc, char **argv)
{ Select|=BLEVEL;
  Info("Select LEVELS\n");
  (void)argc;(void)argv;
}
void COMlump(Int16 argc, char **argv)
{ Select|=BLUMP;
  Info("Select LUMPS\n");
  (void)argc;(void)argv;
}
void COMtextur(Int16 argc, char **argv)
{ Select|=BTEXTUR;
  Info("Select TEXTURES\n");
  (void)argc;(void)argv;
}
void COMsound(Int16 argc, char **argv)
{ Select|=BSOUND;
  Info("Select SOUNDS\n");
  (void)argc;(void)argv;
}
void COMmusic(Int16 argc, char **argv)
{ Select|=BMUSIC;
  Info("Select MUSICS\n");
  (void)argc;(void)argv;
}
void COMgraphic(Int16 argc, char **argv)
{ Select|=BGRAPHIC;
  Info("Select GRAPHICS\n");
  (void)argc;(void)argv;
}
void COMpatch(Int16 argc, char **argv)
{ Select|=BPATCH;
  Info("Select PATCHES\n");
  (void)argc;(void)argv;
}
void COMgeorge(Int16 argc, char **argv)
{ George=TRUE;
  Info("Use S_END for sprites.\n");
  (void)argc;(void)argv;
}


void PicDebug(char *file,char *DataDir,char *name);


void COMdebug(Int16 argc, char **argv)
{
#if 1
#include "color.h"
#include "picture.h"
 static struct WADINFO iwad;
	Int16 pnm;
	char huge *Colors; Int32 Pnamsz=0;
	iwad.ok=0;
	WADRopenR(&iwad,MainWAD);
	pnm=WADRfindEntry(&iwad,"PLAYPAL");
	if(pnm<0) ProgError("Can't find PLAYPAL in Main WAD");
	Colors=WADRreadEntry(&iwad,pnm,&Pnamsz);
	COLinit(trnR,trnG,trnB,Colors,(Int16)Pnamsz);
	Free(Colors);
	WADRclose(&iwad);
	PicDebug(file,DataDir,(argc<2)? "test":argv[1]);
	COLfree();
#endif
	(void)argc;(void)argv;
}
void COMdeu(Int16 argc, char **argv)
{  HowMuchJunk=MAXJUNK64;
	Info("Some junk will be added at end of WAD, for DEU 5.21.\n");
	(void)argc;(void)argv;
}
void COMdir(Int16 argc, char **argv)
{  DataDir=argv[1];
	Info("Files will be saved in directory %s.\n",DataDir);
	(void)argc;
}
void COMfullsnd(Int16 argc, char **argv)
{  fullSND=TRUE;
   Info("Saving complete sounds.\n");
   (void)argc;(void)argv;
}
void COMstroy(Int16 argc, char **argv)
{  WSafe=FALSE;
   Info("Overwrite existing files.\n");
   if(argc)(void)argv;
}
void COMgif(Int16 argc, char **argv)
{  Picture=PICGIF;
   Info("Saving pictures as GIF\n");
   (void)argc;(void)argv;
}
void COMbmp(Int16 argc, char **argv)
{  Picture=PICBMP;
   Info("Saving pictures as BMP\n");
   (void)argc;(void)argv;
}
void COMppm(Int16 argc, char **argv)
{  Picture=PICPPM;
   Info("Saving pictures as BMP\n");
   (void)argc;(void)argv;
}
void COMau(Int16 argc, char **argv)
{  Sound=SNDAU;
	Info("Save sounds as Sun AUDIO\n");
	(void)argc;(void)argv;
}
void COMwave(Int16 argc, char **argv)
{  Sound=SNDWAV;
	Info("Save sounds as WAVE\n");
	(void)argc;(void)argv;
}
void COMvoc(Int16 argc, char **argv)
{  Sound=SNDVOC;
	Info("Save sounds as VOC\n");
	(void)argc;(void)argv;
}
void COMrgb(Int16 argc, char **argv)
{ trnR=(char)(atoi(argv[1])&0xFF);
  trnG=(char)(atoi(argv[2])&0xFF);
  trnB=(char)(atoi(argv[3])&0xFF);
  Info("Transparent color is R=%d G=%d B=%d\n",
  ((int)trnR&0xFF),((int)trnG&0xFF),((int)trnB&0xFF));
  (void)argc;
}

/*
** Build an IWAD
**
*/
void COMiwad(Int16 argc, char **argv)
{ Type=IWAD;
  Info("Build an IWAD file.\n");
  (void)argc;(void)argv;
}
/*
** Main Commands
**
*/

void COMmake(Int16 argc, char **argv)
{ char *wadinf,*wadout;
  if(WadInfOk==FALSE)
  { MakeFileName(WadInf,DataDir,"","","WADINFO","TXT");
  }
  if(argc<=2){wadinf=WadInf;wadout=argv[1];}
  else       {wadinf=argv[1];wadout=argv[2];}
  CMPOmakePWAD(MainWAD,Type,wadout,DataDir,wadinf,Select,trnR,trnG,trnB,George);
  (void)argc;
}
void COMxtra(Int16 argc, char **argv)
{ char *wadinf, *wadin;
  if(WadInfOk==FALSE)
  { MakeFileName(WadInf,DataDir,"","","WADINFO","TXT");
  }
  if(argc<=1){wadin=MainWAD;}else{wadin=argv[1];}
  if(argc<=2){wadinf=WadInf;}else{wadinf=argv[2];}
  XTRextractWAD(MainWAD,DataDir,wadin,wadinf,Picture,Sound,fullSND,Select,trnR,trnG,trnB,WSafe);
}
void COMget(Int16 argc, char **argv)
{ XTRgetEntry(MainWAD,DataDir,((argc<3)? MainWAD: argv[2]),argv[1],Picture,Sound,fullSND,trnR,trnG,trnB);
}
void COMpackNorm(Int16 argc, char **argv)
{ XTRcompakWAD(DataDir,(argc>1)? argv[1]: MainWAD,(argc>2)? argv[2]:NULL,FALSE);
}
void COMpackGfx(Int16 argc, char **argv)
{ XTRcompakWAD(DataDir,(argc>1)? argv[1]: MainWAD,(argc>2)? argv[2]:NULL,TRUE);
}
void COMvoid(Int16 argc, char **argv)
{  XTRvoidSpacesInWAD(argv[1]);
	(void)argc;
}
void COMusedtex(Int16 argc, char **argv)
{ XTRtextureUsed((argc>1)? argv[1]: MainWAD);
}
#endif /*DeuTex*/

void COMcheck(Int16 argc, char **argv)
{ XTRstructureTest(MainWAD,argv[1]);
  (void)argc;
}


typedef Int16 COMTYPE;
#define END        1
#define NOTHING        2
#define OPTION        3
#define IWADOP        4
static struct
{ COMTYPE type; Int16 argc; char *com; void (*exec)(Int16 argc, char **argv); char *use; char *help;}
Com[]=
{
 {NOTHING,1,        "syn",        COMformat,"tax","print the syntax of WAD creation directives"},
#if defined DeuTex
 {OPTION, 1+5,        "win",        COMwintxn," <doom> <data> <info> <select> <color>","WinTex shortcut"},
 {OPTION, 1+2,        "wim",        COMwintxm," <doom> <select>","WinTex shortcut"},
 {IWADOP, 1,        "debug",COMdebug,"",NULL},
 {OPTION, 1,        "o",        COMstroy,"verwrite","overwrite all"},
#endif /*DeuTex*/
 {OPTION, 1+1,        "wtx",        COMwintex," <iwad> ","WinTex shortcut"},
 {OPTION, 1+1,        "doo",        COMdoom,"m <dir>","indicate the directory of DOOM"},
 {OPTION, 1+1,        "her",        COMdoom,"etic <dir>","indicate the directory of HERETIC"},
 {NOTHING,1,        "h",        COMhelp,"elp","print the command list"},
#if defined DeuTex
 {OPTION, 1+1,        "dir",         COMdir," <dir>","indicate the working directory"},
 {OPTION, 1,        "deu",         COMdeu,"","add 64k junk to compensate a bug of DEU 5.21"},

 {OPTION, 1+3,        "rgb",         COMrgb,"<R> <G> <B>","declare the transparent color (default CYAN)"},
 {OPTION, 1,        "gif",         COMgif,"","save pictures as GIF"},
 {OPTION, 1,        "bmp",         COMbmp,"","save pictures as BMP"},
 {OPTION, 1,        "ppm",         COMppm,"","save pictures as PPM"},
 {OPTION, 1,        "au",         COMau,"","save sound as AUDIO"},
 {OPTION, 1,        "wav",         COMwave,"","save sound as WAVE"},
 {OPTION, 1,        "voc",         COMvoc,"","save sound as VOC"},
 {OPTION, 1,        "ful",         COMfullsnd,"lsnd","save sound entry, beyond declared length"},

 {OPTION, 1,        "lev",         COMlevel,"els","select levels"},
 {OPTION, 1,        "lum",         COMlump ,"ps","select lumps"},
 {OPTION, 1,        "sou",         COMsound,"nds","select sounds"},
 {OPTION, 1,        "mus",         COMmusic,"ics","select musics"},
 {OPTION, 1,        "tex",         COMtextur,"tures","select textures"},
 {OPTION, 1,        "gra",         COMgraphic,"phics","select graphics"},
 /*by request from George Hamlin*/
 {OPTION, 1,        "s_end", COMgeorge,"","use S_END for sprites, not SS_END"},
 {OPTION, 1,        "george",COMgeorge,"",NULL},
#endif /*DeuTex*/
 {OPTION, 1,        "spr",         COMsprit,"ites","select sprites"},
#if defined DeuTex
 {OPTION, 1,        "pat",         COMpatch,"chs","select patches"},
#endif /*DeuTex*/
 {OPTION, 1,        "fla",         COMflat,"ts","select flats"},
 {OPTION, 1,        "v",        COMverbose,"@","set verbose level to @ [0-5]"},

#if defined DeuTex
 {OPTION, 1,        "iwa",        COMiwad,"d","compose IWAD, not PWAD"},

 {IWADOP, 1+1,        "mak",         COMmake,"e [Dirctivs.txt] <Out.wad>","make a PWAD, from the creation directives"},
 {IWADOP, 1+1,        "bui",         COMmake,"ld [Dirctivs.txt] <Out.wad>",NULL},
 {IWADOP, 1+1,        "cre",         COMmake,"ate [Dirctivs.txt] <Out.wad>",NULL},
#endif /*DeuTex*/

#if defined DeuSF
 {OPTION, 1+1,        "mai",        COMmain,"n","Indicate main wad"},
#endif
 {IWADOP, 1,        "wad",        COMwadir,"ir <In.wad>","list and identify entries in a WAD"},
 {IWADOP, 1+1,        "che",        COMcheck,"ck <In.WAD>","check the textures"},
 {IWADOP, 1+1,        "tes",        COMcheck,"t <In.WAD>",NULL},
#if defined DeuTex
 {IWADOP, 1,        "use",        COMusedtex,"dtex <In.WAD>","list textures used in all levels"},
 {NOTHING, 1+1,        "unu",        COMvoid,"sed <In.wad>","find unused spaces in a WAD"},
 {IWADOP, 1,        "xtr",        COMxtra,"act <In.wad> [Directivs.txt]","extract some/all entries from a WAD"},
 {IWADOP, 1,        "ext",        COMxtra,"ract <In.wad> [Directivs.txt]",NULL},
 {IWADOP, 1+1,        "get",        COMget," <entry> [In.wad]","get a WAD entry from main WAD or In.WAD"},
 {IWADOP, 1+1,        "pkn",        COMpackNorm,"ormal In.wad [Out.txt]","Detect identical normal"},
 {IWADOP, 1+1,        "pkg",        COMpackGfx,"rahix In.wad [Out.txt]","Detect identical graphic"},
#endif /*DeuTex*/

 {IWADOP, 1+2,        "add",        COMadd," <Incomplete.wad> <Out.wad>","add sprites&flats of a PWAD to those of DOOM"},
 {IWADOP, 1+1,        "app",        COMapp,"end <Incomplete.wad>","append sprites&flats of DOOM to a PWAD"},
 {IWADOP, 1+2,        "joi",        COMjoin,"n <Incomplete.wad> <In.wad>","append sprites&flats of DOOM to a PWAD"},
 {IWADOP, 1+1,        "mer",        COMmerge,"ge <In.wad>","merge DOOM.WAD and a PWAD"},
 {IWADOP, 1,        "res",        COMrestor,"tor","restore DOOM.WAD and the PWAD"},
 {IWADOP, 1+1,        "as",        COMapps," <Sprite.wad>","append all Sprites to the WAD."},
 {IWADOP, 1+1,        "af",        COMappf," <Flats.wad>","append all Floors/Ceilings to the WAD."},
 {END,    0,        "",        COMhelp,"",""}
};

int main( int argc, char **argv)
{  Int16 com,i;
	char c;
	FILE *fp;
	/*
	** default parameters
	*/
#if defined DeuTex
	WadInfOk=FALSE;
	George=FALSE;
#if defined __MSDOS__
	Picture    = PICBMP;
	Sound      = SNDWAV;
#elif defined __OS2__
	Picture    = PICBMP;
	Sound      = SNDWAV;
#else   /*Unix*/
	Picture    = PICGIF;
	Sound      = SNDAU;
#endif
	trnR=0;trnG=255;trnB=255;
	fullSND    = FALSE;
	WSafe      = TRUE;
	HowMuchJunk= 0;
	Select     = 0;
#endif /*DeuTex*/
#if defined DeuSF
	Select     = BALL;
#endif /*DeuSF*/
	Type       = PWAD;

   ProgErrorCancel();/*no error handler defined*/

#if defined __OS2__ || defined (__GNUC__)
   /*setbuf(stdout,(char *)NULL);*/
   setvbuf(stdout,NULL,_IOLBF,BUFSIZ);
#endif   /*OS2*/
   /*
   ** print on screen or file?
   */
   PrintInit(FALSE);
   PrintVerbosity(2);
   /*
   ** copyright notice
   */
   PrintCopyright();
   /*
   ** directories
   */
   DataDir     = ".";  /*work directory*/
   DoomDir    = getenv("DOOMWADDIR");
   if(DoomDir == NULL)
     DoomDir    = ".";
   else
     Phase("Doom directory is %.128s\n",DoomDir);
   /*
   ** Command line
   */
   argc--;argv++;
   if(argc>30) ProgError("too many arguments");
   while(argc>0)
   { c=argv[0][0];
     if((c!='-')&&(c!='/'))
        ProgError("%s is not a command",argv[0]);
     for(com=0;Com[com].type!=END;com++)
     {  for(i=0;Com[com].com[i]!='\0';i++)
        { c=argv[0][i+1];
          if(isupper(c)) c=c+('a'-'A');
          if(c!=Com[com].com[i]) break;
        }
        if(Com[com].com[i]=='\0')break;
     }
     if(argc<Com[com].argc)
       ProgError("Usage: %s%s",Com[com].com,Com[com].use);
     switch(Com[com].type)
     { case END:
         ProgError("Command %s is not defined.",argv[0]);
         PrintExit();
         return 0;
       case NOTHING:
         Com[com].exec((Int16)argc,argv);
         PrintExit();
         return 0;
       case OPTION:
         Com[com].exec((Int16)argc,argv);
         break;
       case IWADOP:
         /*find DOOM,HERETIC*/
         if(DoomDir==NULL)
         { /*
           ** check if file exists
           */
           fp=fopen(MainWAD,FOPEN_RB);
           fclose(fp);
           if(fp==NULL) DoomDir=".";
         }
         if(DoomDir!=NULL)
         { /*
           ** look for main wad
           */
           if(MakeFileName(MainWAD,DoomDir,"","","DOOM","WAD")!=TRUE)
             if(MakeFileName(MainWAD,DoomDir,"","","DOOM2","WAD")!=TRUE)
               if(MakeFileName(MainWAD,DoomDir,"","","HERETIC","WAD")!=TRUE)
                 if(MakeFileName(MainWAD,DoomDir,"","","HEXEN","WAD")!=TRUE)
                   if(MakeFileName(MainWAD,".","","","DOOM","WAD")!=TRUE)
                     if(MakeFileName(MainWAD,".","","","DOOM2","WAD")!=TRUE)
                       if(MakeFileName(MainWAD,".","","","HERETIC","WAD")!=TRUE)
                         if(MakeFileName(MainWAD,".","","","HEXEN","WAD")!=TRUE)
                            ProgError("Can't find doom.wad, doom2.wad or heretic.wad");
         }
         /*selection bytes*/
#if defined DeuTex
         if(!(Select&BALL))  Select = BALL;
#endif /*DeuTex*/
         Com[com].exec((Int16)argc,argv);
         PrintExit();
         return 0;
     }
   argv+=Com[com].argc;argc-=Com[com].argc;
   }
   NoCommandGiven();
   PrintExit();
   return -1;
}




/*
** Print Help
*/
void COMhelp(Int16 argc, char **argv)
{ Int16 com;
  Output("Help for %s:\n",DEUTEXNAME);
  for(com=0;Com[com].type!=END;com++)
  { if(Com[com].help!=NULL)
    {  Output("-%s%s\t%s\n",Com[com].com,Com[com].use,(Com[com].type==OPTION)?"(Optional)":"");
       Output("  To %s.\n",Com[com].help);
    }
  }
  (void)argc;(void)argv;
}
#if defined DeuTex
static char *Format[] =
{ "* Format of PWAD creation directives *",
  "This format is conform to MS-Windows .INI Files.",
  "Sections are named [LEVELS] [LUMPS] [SOUNDS]",
  "[MUSICS] [TEXTURE1] [TEXTURE2] [GRAPHICS]",
  "[SPRITES] [PATCHES] and [FLATS]",
  "Entries have format:",
  "{name}= {filename} {offsetX} {offsetY}",
  "A '*' at the end of the definition means that the",
  "entry will be exactly the same as the previous one.",
  NULL
};
#endif /*DeuTex*/
#if defined DeuSF
static char *Format[] =
{ "To work with this progam, your PWAD must respect this format:",
  "- Either S_START or SS_START before the first SPRITE entry",
  "- Either S_END or SS_END after the last SPRITE entry",
  "- Either F_START or FF_START before the first FLAT entry",
  "- Either F_END or FF_END after the last FLAT entry",
  "This format has been found compatible with DMADDS 1.0.",
  "Warning:",
  "Flats declared in PWAD will be put at the end of the FLAT list.",
  "You can completely replace an animation of FLATs, but you cannot",
  "replace only part of an animation.",
  NULL
};
#endif /*DeuSF*/
void COMformat(Int16 argc, char **argv)
{ Int16 i;
  for(i=0;Format[i]!=NULL;i++)
  { Output("%s\n",Format[i]);
  }
  (void)argc;(void)argv;
}

#endif /*DeuTex and DeuSF*/
