program DEMON;  {DooM's Effective Movie Organizer's Nameless}

{$M $8000, $16000, $16000}
{$A+} {$B-} {$D-} {$E-} {$G+} {$L-} {$N+}

uses
  ui,
  data,
  DOS,
  Crt;

var
  m: TMenue;
  sel: Byte;
  info: TGlobal;
  dir: String;


function HomeDir: String;
var d: DirStr; n: NameStr; e: ExtStr;
begin
  FSplit(FExpand(ParamStr(0)), d, n, e);
  HomeDir:=d;
end;

function path(fname: String): String;
var d: DirStr; n: NameStr; e: ExtStr;
begin
  FSplit(FExpand(fname), d, n, e);
  path:=d;
end;

function filename(fname: String): String;
var d: DirStr; n: NameStr; e: ExtStr;
begin
  FSplit(FExpand(fname), d, n, e);
  filename:=n + e;
end;

function name(fname: String): String;
var d: DirStr; n: NameStr; e: ExtStr;
begin
  FSplit(FExpand(fname), d, n, e);
  name:=n;
end;

function ext(fname: String): String;
var d: DirStr; n: NameStr; e: ExtStr;
begin
  FSplit(FExpand(fname), d, n, e);
  ext:=e;
end;

function FileExists(fname: String): Boolean;
begin
  FileExists:=(FSearch(filename(fname), path(fname)) <> '');
end;

function PathExists(path: String): Boolean;
var old: String;
begin
  old:=FExpand('.\');
  {$I-} ChDir(path) {$I+};
  pathExists:=IOResult = 0;
  ChDir(old);
end;

procedure delFile(fname: String);
var f: File;
begin
  if FileExists(fname) then begin
    assign(f, fname);
    erase(f);
  end;
end;

procedure copyFile(src, dest: String; var ok: Byte);
var f1, f2: File;
    buffer: PBuf64K;
    NumRead, NumWritten: Word;
    newFile: File;
begin
  if FileExists(src) then begin
    new(buffer);
    assign(f1, src);
    {$I-} reset(f1, 1) {$I+};
    assign(f2, dest);
    {$I-} rewrite(f2, 1) {$I+};
    ok:=IOResult;
    if ok = 0 then begin
      repeat
        BlockRead(f1, buffer^, SizeOf(buffer^), NumRead);
        BlockWrite(f2, buffer^, NumRead, NumWritten);
      until (NumRead = 0) or (NumWritten <> NumRead);
      if NumWritten <> NumRead then ok:=IO_WRTERR;
      close(f2);
    end;
    close(f1);
    dispose(buffer);
  end;
end;

procedure EditInfoFile(fname: String);
var s, txt: String;
    ok: Byte;
begin
  s:=FSearch('edit.com', GetEnv('PATH'));
  if FileExists(fname) and (s <> '') then begin
    txt:=path(fname) + name(fname) + '.txt';
    if not FileExists(txt) then copyFile(HomeDir + 'template.txt', txt, ok);
    swapvectors;
    exec(s, txt);
    swapvectors;
  end;
end;

procedure ShowTXT(fname: String);
var t: TTextView;
begin
  if FileExists(fname) then begin
    t.init(2, 2, 79, 24, name(fname));
    t.getListFromFile(fname);
    t.show;
    t.ClearList;
  end;
end;

procedure runDooM(vt: TVType; game: TGame);
begin
  if vt = Multi then begin
    swapvectors;
    exec('ipxsetup.exe', '@demon.rsp');
    swapvectors;
  end else if game = Doom1 then begin
    swapvectors;
    exec('doom.exe', '@demon.rsp');
    swapvectors;
  end else begin
    swapvectors;
    exec('doom2.exe', '@demon.rsp');
    swapvectors;
  end;
end;

procedure play(info: TGlobal);
var t: Text;
    ok: Byte;
    path: String;
begin
  with info, local[game] do begin
    if vidname <> '' then begin
      path:='lmp\' + TypeStr[vidtype].path;
      if vidtype = DHT then begin
        ok:=IO_OK;
        swapvectors;
        exec(pkzip + 'pkunzip.exe', path + zipname + ' ' + filename(vidname) + ' > nul');
        exec(pkzip + 'pkunzip.exe', path + zipname + ' ' + name(zipname) + '.txt > nul');
        swapvectors;
      end else copyFile(path + filename(vidname), filename(vidname), ok);
      if ok = IO_OK then begin
        assign(t, 'demon.rsp');
        {$I-} rewrite(t) {$I+};
        if IOResult = 0 then begin
          if FLAG_TIMEDEMO = (flags and FLAG_TIMEDEMO) then
               WriteLn(t, '-timedemo ', name(vidname))
          else WriteLn(t, '-playdemo ', name(vidname));
          if (vidtype in [PWAD, Multi]) and (wadname <> '') then WriteLn(t, '-file ', wadname);
          if vidtype = Multi then WriteLn(t, '-nodes 1');
          close(t);
          if vidtype = DHT then ShowTXT(name(zipname) + '.txt')
          else if FileExists(path + name(vidname) + '.txt') then ShowTXT(path + name(vidname) + '.txt');

          runDoom(vidtype, game);
        end;
        delFile('demon.rsp');
        delFile(filename(vidname));
      end;
      if vidtype = DHT then delFile(name(zipname) + '.txt');
    end;
  end;
end;

procedure recordLMP(info: TGlobal);
var t: Text;
    ok: Byte;
begin
  assign(t, 'demon.rsp');
  {$I-} rewrite(t) {$I+};
  with info, local[game] do begin
    WriteLn(t, '-record ', name(vidname));
    if vidtype = Multi then begin
      case mode of
        DeathMatch: WriteLn(t, '-deathmatch');
          AltDeath: WriteLn(t, '-altdeath');
      end;
      WriteLn(t, '-maxdemo ', buffer * players);
      WriteLn(t, '-nodes ', players);
      if FLAG_NOMONSTERS = (flags and FLAG_NOMONSTERS) then WriteLn(t, '-nomonsters');
    end else WriteLn(t, '-maxdemo ', buffer);
    if (vidtype in [Multi, PWAD]) and (wadname <> '') then WriteLn(t, '-file ', wadname);
    if game = Doom1 then WriteLn(t, '-warp ', episode, ' ', level)
                    else WriteLn(t, '-warp ', level);
    WriteLn(t, '-skill ', skill);
    if FLAG_FAST = (flags and FLAG_FAST) then WriteLn(t, '-fast');
    if FLAG_RESPAWN = (flags and FLAG_RESPAWN) then WriteLn(t, '-respawn');
    close(t);

    runDoom(vidtype, game);
    delFile('demon.rsp');
    copyFile(filename(vidname), 'lmp\' + TypeStr[vidtype].path + filename(vidname), ok);
    if ok = IO_OK then delFile(filename(vidname));
  end;
end;


procedure chGame(var info: TGlobal);
var s: String;
    g: TGame;
    l: TListBox;
begin
  s:='';
  l.init(14, 9, 54, 14, 'Change game');
  for g:=Doom1 to Plutonia do
    s:=s + (chr(ord(g) + 49)) + ') ' + GameTitles[g].full + '#';
  l.GetListFromString(s, '#');
  repeat
    g:=info.game;
    if l.selected <> '' then g:=TGame(l.index - 1);
  until info.paths[g] <> '';
  info.game:=g;
  ChDir(info.paths[g]);
end;

procedure WriteScrInfo(game: TGame; local: TLocal);
begin
  GotoXY(79 - length(GameTitles[game].short), 1);
  Write(GameTitles[game].short);
  with local do begin
    if (vidtype in [Multi, PWAD]) and (wadname <> '') then begin
      GotoXY(15, 23);
      Write('Loaded .WAD: ', FExpand(wadname));
    end;
    GotoXY(15, 24);
    if vidname <> '' then begin
      Write('Loaded .LMP: ', filename(vidname));
      if vidtype = DHT then Write(' in exam ', name(zipname));
      Write(' <', TypeStr[vidtype].full, '>');
    end else if (vidtype = DHT) and (zipname <> '') then begin
      Write('Loaded exam: ', name(zipname));
      Write(' <', TypeStr[vidtype].full, '>');
    end;
  end;
end;


  procedure m_paths(var info: TGlobal);
  var m: TMenue;
      sel: Byte;
      e: TEditBox;

      procedure CreaTree(path: String);
      begin
        MkDir(path + 'lmp');
        MkDir(path + 'lmp\dht');
        MkDir(path + 'lmp\levels');
        MkDir(path + 'lmp\misc');
        MkDir(path + 'lmp\multi');
        MkDir(path + 'lmp\pwad');
      end;

  begin
    m.init('Add/remove games#1) ' + GameTitles[Doom1].full + '#2) '+ GameTitles[Doom2].full +
           '#3) ' + GameTitles[TNT].full + '#4) ' + GameTitles[Plutonia].full + '#5) Back#', '#');
    repeat
      ClrScr;
      WriteScrInfo(info.game, info.local[info.game]);
      m.show(sel);
      e.init(6 + (sel - 1) * 2);
      case sel of
        1: begin
             e.prompt(info.paths[Doom1]);
             if info.paths[Doom1][length(info.paths[Doom1])] <> '\' then
                insert('\', info.paths[Doom1], length(info.paths[Doom1])+1);
             if FSearch('doom.exe', info.paths[Doom1]) = '' then
                info.paths[Doom1]:=''
             else if not PathExists(info.paths[Doom1] + 'lmp\') then
                CreaTree(info.paths[Doom1]);
           end;
        2: begin
             e.prompt(info.paths[Doom2]);
             if info.paths[Doom2][length(info.paths[Doom2])] <> '\' then
                insert('\', info.paths[Doom2], length(info.paths[Doom2])+1);
             if FSearch('doom2.exe', info.paths[Doom2]) = '' then
                info.paths[Doom2]:=''
             else if not PathExists(info.paths[Doom2] + 'lmp\') then
                CreaTree(info.paths[Doom2]);
           end;
        3: begin
             e.prompt(info.paths[TNT]);
             if info.paths[TNT][length(info.paths[TNT])] <> '\' then
                insert('\', info.paths[TNT], length(info.paths[TNT])+1);
             if FSearch('doom2.exe', info.paths[TNT]) = '' then
                info.paths[TNT]:=''
             else if not PathExists(info.paths[TNT] + 'lmp\') then
                CreaTree(info.paths[TNT]);
           end;
        4: begin
             e.prompt(info.paths[Plutonia]);
             if info.paths[Plutonia][length(info.paths[Plutonia])] <> '\' then
                insert('\', info.paths[Plutonia], length(info.paths[Plutonia])+1);
             if FSearch('doom2.exe', info.paths[Plutonia]) = '' then
                info.paths[Plutonia]:=''
             else if not PathExists(info.paths[Plutonia] + 'lmp\') then
                CreaTree(info.paths[Plutonia]);
           end;
      end;
      if not ((info.paths[Doom1] <> '') or (info.paths[Doom2] <> '') or
              (info.paths[TNT] <> '') or (info.paths[Plutonia] <> '')) then
      begin
        WriteLn; WriteLn(' Error: No games'); WriteLn;
        halt(1);
      end;
    until (sel in [5, 0]);
    m.done;
  end;

procedure m_setup(var info: TGlobal);
var m: TMenue;
    sel: Byte;
    e: TEditBox;
begin
  m.init('Setup#1) Toggle fast playback#2) Add/remove game#3) Set path to PKUNZIP#4) Back#', '#');
  repeat
    ClrScr;
    WriteScrInfo(info.game, info.local[info.game]);
    GotoXY(49, 6);
    if FLAG_TIMEDEMO = (info.local[info.game].flags and FLAG_TIMEDEMO)
      then Write('[X] Fast playback')
      else Write('[ ] Fast playback');
    m.show(sel);
    case sel of
      1: with info, local[game] do
           if FLAG_TIMEDEMO = (flags and FLAG_TIMEDEMO) then
             flags:=flags and not FLAG_TIMEDEMO
           else flags:=flags or FLAG_TIMEDEMO;
      2: m_paths(info);
      3: begin
           e.init(10);
           e.prompt(info.pkzip);
           if info.pkzip[length(info.pkzip)] <> '\' then insert('\', info.pkzip, length(info.pkzip)+1);
           if not PathExists(info.pkzip) or not FileExists(info.pkzip + 'pkunzip.exe')
              then info.pkzip:='';
         end;
    end;
  until sel in [4, 0];
  m.done;
end;

    procedure WriteRecParms(info: TGlobal);
    begin
      with info, local[game] do begin
        GotoXY(40, 6); Write('<', TypeStr[vidtype].full, '>');
        if game=Doom1 then begin
          GotoXY(40,  8); Write(EpisodeStr[episode]);
          GotoXY(40, 10); Write('E', episode, 'M', level);
        end else begin
          GotoXY(40, 10); Write('Map ', level);
        end;
        GotoXY(40, 12); Write(SkillStr[skill]);
        GotoXY(40, 14); Write('[ ] FAST  [ ] RESPAWN');
        if vidtype = Multi then Write('  [ ] NO MONSTERS');
        if FLAG_FAST = (flags and FLAG_FAST) then begin
          GotoXY(41, 14); Write('X'); end;
        if FLAG_RESPAWN = (flags and FLAG_RESPAWN) then begin
          GotoXY(51, 14); Write('X'); end;
        if (vidtype = Multi) then begin
          if (FLAG_NOMONSTERS = (flags and FLAG_NOMONSTERS)) then begin
            GotoXY(64, 14); Write('X'); end;
          GotoXY(40, 16); Write(players, ' playing ', ModeStr[mode]);
          GotoXY(40, 18); Write(buffer, ' kb/player, ', buffer * players, ' kb total');
        end else begin
          GotoXY(40, 18); Write(buffer, ' kb');
        end;
      end;
    end;

    procedure m_mplayer(var info: TGlobal);
    var m: TMenue;
        sel: Byte;
        lb: TListBox;
    begin
      with info, local[game] do begin
        m.init('Multiplayer#1) Change no. of players#2) Change type of game#3) Back#', '#');
        repeat
          ClrScr;
          WriteScrInfo(game, local[game]);
          WriteRecParms(info);
          m.show(sel);
          case sel of
            1: begin
                 lb.init(39, 5, 51, 10, 'Players');
                 lb.GetListFromString('1 Player#2 Players#3 Players#4 Players#', '#');
                 if lb.selected <> '' then players:=lb.index;
                 lb.ClearList;
               end;
            2: begin
                 lb.init(39, 7, 55, 11, 'Mode');
                 lb.GetListFromString('1) ' + ModeStr[Coop] + '#2) ' + ModeStr[DeathMatch]
                                      + '#3) ' + ModeStr[AltDeath] + '#', '#');
                 lb.selected;
                 mode:=TMode(lb.index - 1);
               end;
          end;
        until sel in [3, 0];
        m.done;
      end;
    end;

    procedure m_flags(var info: TGlobal);
    var m: TMenue;
        sel: Byte;
    begin
      with info, local[game] do begin
        m.init('Flags#1) Toggle fast monsters#2) Toggle Respawn-flag#3) Toggle NoMonsters#4) Back#', '#');
        repeat
          ClrScr;
          WriteScrInfo(game, local[game]);
          WriteRecParms(info);
          m.show(sel);
          case sel of
            1: if FLAG_FAST = (flags and FLAG_FAST) then
                 flags:=flags and not FLAG_FAST
               else flags:=flags or FLAG_FAST;
            2: if FLAG_RESPAWN = (flags and FLAG_RESPAWN) then
                 flags:=flags and not FLAG_RESPAWN
               else flags:=flags or FLAG_RESPAWN;
            3: if vidtype in [Misc, Multi] then
                 if FLAG_NOMONSTERS = (flags and FLAG_NOMONSTERS) then
                   flags:=flags and not FLAG_NOMONSTERS
                 else flags:=flags or FLAG_NOMONSTERS;
          end;
        until sel in [4, 0];
        m.done;
      end;
    end;

  procedure m_record(var info: TGlobal);
  var m: TMenue;
      sel: Byte;
      lb: TListBox;
      e: TEditBox;
      s: String;
  begin
    with info, local[game] do begin
      if vidtype=DHT then begin
        if zipname <> '' then delFile(name(zipname) + '.lst');
        vidtype:=Misc;  vidname:='';  zipname:='';
      end;
      m.init('Record#1) Category#2) Episode#3) Level#4) Skill#5) Flags#' +
             '6) Multiplayer#7) Buffer size#8) START#', '#');
      repeat
        ClrScr;
        WriteScrInfo(game, local[game]);
        WriteRecParms(info);
        m.show(sel);
        case sel of
          1: begin
               lb.init(39, 5, 51, 10, 'Category');
               lb.GetListFromString(TypeStr[Levels].full + '#' + TypeStr[Misc].full + '#' +
                                    TypeStr[Multi].full + '#' + TypeStr[PWAD].full + '#', '#');
               lb.selected;
               vidtype:=TVType(lb.index - 1);
               lb.ClearList;
             end;
          2: begin
               if game = Doom1 then begin
                 lb.init(39, 7, 65, 12, 'Episode');
                 lb.GetListFromString('1) ' + EpisodeStr[1] + '#2) ' + EpisodeStr[2] + '#3) '
                                      + EpisodeStr[3] + '#4) ' + EpisodeStr[4] + '#', '#');
                 if lb.selected <> '' then episode:=lb.index;
                 lb.ClearList;
               end;
             end;
          3: begin
               lb.init(39, 9, 69, 19, 'Level');
               lb.GetListFromPassage(HomeDir + 'levels.lst', chr(ord(game)+49) + chr(episode+48));
               if lb.selected <> '' then level:=lb.index;
               lb.ClearList;
             end;
          4: begin
               lb.init(39, 11, 66, 17, 'Skill');
               lb.GetListFromString('S1: ' + SkillStr[1] + '#S2: ' + SkillStr[2] +
                                    '#S3: ' + SkillStr[3] + '#S4: ' + SkillStr[4] +
                                    '#S5: ' + SkillStr[5] + '#', '#');
               if lb.selected <> '' then skill:=lb.index;
               lb.ClearList;
             end;
          5: m_flags(info);
          6: if vidtype = Multi then m_mplayer(info);
          7: begin
               lb.init(39, 17, 54, 19, 'Buffer size');
               lb.GetListFromString('1) 128 kb#2) 256 kb#3) 512 kb#4) 1024 kb#5) 2048 kb#', '#');
               if lb.selected <> '' then begin
                 buffer:=128;
                 buffer:=buffer shl (lb.index - 1);
               end;
               lb.ClearList;
             end;
          8: begin
               s:=vidname;
               e.init(8);
               e.prompt(s);
               if (length(s) <= 12) and (length(s) > 0) then begin
                 vidname:=name(s) + '.LMP';
                 recordLMP(info);
               end;
             end;
        end;
      until sel in [8, 0];
      m.done;
    end;
  end;

  procedure m_load(var info: TGlobal);
  var m: TMenue;
      sel: Byte;
      lb: TListBox;
  begin
    m.init('Load files#1) Levels#2) Miscellaneous#3) Multiplayer#4) PWAD#' +
           '5) DHT-exams#6) File from exam#7) Load PWAD#8) Back#', '#');
    repeat
      ClrScr;
      with info, local[game] do begin
        WriteScrInfo(game, local[game]);
        m.show(sel);
        case sel of
          1..3: begin
                  vidtype:=TVType(sel - 1);
                  if zipname <> '' then begin
                    delFile(name(zipname) + '.lst');
                    zipname:='';
                  end;
                  if vidtype <> Multi then wadname:='';
                  lb.init(60, 6, 76, 18, TypeStr[vidtype].full);
                  lb.GetListFromDir('lmp\' + TypeStr[vidtype].path, '*.lmp');
                  vidname:=lb.selected;
                  lb.ClearList;
                end;
             4: begin
                  vidtype:=PWAD;
                  if zipname <> '' then begin
                    delFile(name(zipname) + '.lst');
                    zipname:='';
                  end;
                  lb.init(60, 6, 76, 18, TypeStr[vidtype].full);
                  lb.GetListFromDir('lmp\' + TypeStr[vidtype].path, '*.lmp');
                  vidname:=lb.selected;
                  lb.ClearList;
                  if (vidname <> '') and (wadname = '') then begin
                     lb.init(60, 6, 78, 18, 'WADs available');
                     lb.GetListFromDir('wads\', '*.wad');
                     repeat
                       wadname:='wads\' + lb.selected;
                     until wadname <> 'wads\';
                     lb.ClearList;
                  end else if (vidname <> '') then wadname:='';
                end;
             5: begin
                  vidtype:=DHT;
                  vidname:='';
                  if zipname <> '' then begin
                    delFile(name(zipname) + '.lst');
                    zipname:='';
                  end;
                  wadname:='';
                  lb.init(60, 6, 76, 18, TypeStr[vidtype].full);
                  lb.GetListFromDir('lmp\' + TypeStr[vidtype].path, '*.zip');
                  zipname:=lb.selected;
                  lb.ClearList;
                  if zipname <> '' then begin
                    swapvectors;
                    exec(info.pkzip + 'pkunzip.exe', 'lmp\' + TypeStr[vidtype].path + zipname + ' -@' + name(zipname)
                                                   + '.lst *.lmp > nul');
                    swapvectors;
                  end;
                end;
             6: begin
                  if zipname <> '' then begin
                    lb.init(60, 6, 76, 18, 'Exam ' + name(zipname));
                    lb.GetListFromFile(name(zipname) + '.lst');
                    vidname:=lb.selected;
                    lb.ClearList;
                  end;
                end;
             7: begin
                  if (vidtype in [Multi, PWAD]) or (vidname = '') then begin
                    lb.init(60, 6, 78, 18, 'WADs available');
                    lb.GetListFromDir('wads\', '*.wad');
                    repeat
                      wadname:=lb.selected;
                    until (wadname <> '') or ((vidtype <> PWAD) and (vidname <> ''));
                    if wadname <> '' then wadname:=concat('wads\', wadname);
                    lb.ClearList;
                  end;
                end;
        end;
      end;
    until sel in [8, 0];
    m.done;
  end;

procedure m_video(var info: TGlobal);
var m: TMenue;
    sel: Byte;
begin
  m.init('Video Menu#1) Load#2) Play#3) Record#4) Delete#5) Edit info file#6) Back#', '#');
  repeat
    ClrScr;
    WriteScrInfo(info.game, info.local[info.game]);
    m.show(sel);
    case sel of
      1: m_load(info);
      2: play(info);
      3: m_record(info);
      4: with info, local[game] do
           if vidtype <> DHT then begin
             delFile('lmp\' + TypeStr[vidtype].path + vidname);
             delFile('lmp\' + TypeStr[vidtype].path + name(vidname) + '.txt');
             vidname:='';
           end;
      5: with info, local[game] do
           EditInfoFile('lmp\' + TypeStr[vidtype].path + vidname);
    end;
  until sel in [6, 0];
  m.done;
end;



procedure ReadCfg(fname: String; var info: TGlobal);
var f: TIniFile;
    x: TIniCnt;
begin
  assign(f, fname);
  {$I-} reset(f) {$I+};
  if IOResult = 0 then begin
    if filesize(f) > 0 then begin
      read(f, x);
      info:=x.info;
    end;
    close(f);
  end;
end;

procedure WriteCfg(fname: String; var info: TGlobal);
var f: TIniFile;
    x: TIniCnt;
begin
  assign(f, fname);
  {$I-} rewrite(f) {$I+};
  if IOResult = 0 then begin
    x.msg:=DONTMODIFYMSG;
    x.info:=info;
    write(f, x);
    close(f);
  end;
end;



procedure InitInfo(var info: TGlobal);

    procedure SetToDefault(var info: TGlobal);
    var g: TGame;
    begin
      with info do begin
        pkzip:='';
        buffer:=256;
        game:=Doom1;
        for g:=Doom1 to Plutonia do begin
          paths[g]:='';
          with local[g] do begin
            vidname:=''; wadname:=''; zipname:='';
            vidtype:=Misc;
            episode:=1; level:=1; skill:=4;
            flags:=0;
            mode:=AltDeath;
            players:=4;
          end;
        end;
      end;
    end;

begin
  SetToDefault(info);
  ChDir(HomeDir);
  if FileExists(HomeDir + CfgName) then
    ReadCfg(HomeDir + CfgName, info)
  else m_paths(info);
  ChDir(info.paths[info.game]);
end;

begin
  ClrScr;
  dir:=FExpand('.\');
  InitInfo(info);

  m.init('Main menu#1) Video#2) Setup#3) Change game#4) Read me!#5) Quit :(#', '#');
  repeat
    ClrScr;
    WriteScrInfo(info.game, info.local[info.game]);
    m.show(sel);
    case sel of
       1: m_video(info);
       2: m_setup(info);
       3: chGame(info);
       4: ShowTXT(HomeDir + 'demon.txt');
    end;
  until sel in [5, 0];

  m.done;
  WriteCfg(HomeDir + CFGNAME, info);
  ChDir(dir);

  ClrScr;
  WriteLn;
  WriteLn(' Bang the head that does not bang!');
  WriteLn;
end.
