unit List;

interface

type TListBase   = String;
     TListPtr    = ^TListEntry;
     TListEntry  = record
                     info: TListBase;
                     prev, next: TListPtr;
                   end;
     TList       = object
                     dummy, _current: TListPtr;
                     constructor create;
                     destructor destruct;
                     procedure reset;
                     procedure next;
                     procedure prev;
                     procedure ende;
                     procedure insertAfter(x: TListBase);
                     procedure insertBefore(x: TListBase);
                     procedure update(x: TListBase);
                     procedure show(var x: TListBase);
                     procedure delete; virtual;
                     function  empty: Boolean;
                     function  first: Boolean;
                     function  last: Boolean;
                     function  current: TListBase;
                   end;
     TSortedList = object(TList)
                     _size: Word;
                     constructor create;
                     destructor destruct; virtual;
                     procedure delete; virtual;
                     procedure insert(x: TListBase);
                     function  size: Word;
                   end;

implementation

{*** TList ***}

constructor TList.create;
begin
  new(dummy);
  dummy^.prev:=dummy;
  dummy^.next:=dummy;
  _current:=dummy;
end;

destructor TList.destruct;
begin
  while not empty do delete;
  dispose(dummy);
end;

procedure TList.reset;
begin
  _current:=dummy^.next;
end;

procedure TList.next;
begin
  if not last then _current:=_current^.next;
end;

procedure TList.prev;
begin
  if not first then _current:=_current^.prev;
end;

procedure TList.ende;
begin
  _current:=dummy^.prev;
end;

procedure TList.insertAfter(x: TListBase);
var add: TListPtr;
begin
  new(add);
  add^.info:=x;
  add^.next:=_current^.next;
  add^.prev:=_current;
  add^.prev^.next:=add;
  add^.next^.prev:=add;
  _current:=add;
end;

procedure TList.insertBefore(x: TListBase);
var add: TListPtr;
begin
  new(add);
  add^.info:=x;
  add^.prev:=_current^.prev;
  add^.next:=_current;
  add^.next^.prev:=add;
  add^.prev^.next:=add;
  _current:=add;
end;

procedure TList.update(x: TListBase);
begin
  if not empty then _current^.info:=x;
end;

procedure TList.show(var x: TListBase);
begin
  if not empty then x:=_current^.info;
end;

procedure TList.delete;
var junk: TListPtr;
begin
  if not empty then begin
    junk:=_current;
    _current^.prev^.next:=_current^.next;
    _current^.next^.prev:=_current^.prev;
    if last then _current:=_current^.prev
            else _current:=_current^.next;
    dispose(junk);
  end;
end;

function TList.empty: Boolean;
begin
  empty:=(dummy^.next=dummy);
end;

function TList.first: Boolean;
begin
  first:=(_current=dummy^.next);
end;

function TList.last: Boolean;
begin
  last:=(_current^.next=dummy);
end;

function TList.current: TListBase;
begin
  if not empty then current:=_current^.info;
end;

{*** TSortedList ***}

constructor TSortedList.create;
begin
{ new(dummy);
  dummy^.prev:=dummy;
  dummy^.next:=dummy;
  dummy^.info:='';
  _current:=dummy;
}
  TList.create;
  _size:=0;
end;

procedure TSortedList.insert(x: TListBase);
begin
  if empty then insertAfter(x)
  else begin
    reset;
    while (current < x) and not last do next;
    if last and (current < x) then insertAfter(x) else insertBefore(x);
  end;
  inc(_size);
end;

procedure TSortedList.delete;
begin
  TList.delete;
  dec(_size);
end;

destructor TSortedList.destruct;
begin
  _size:=0;
  TList.destruct;
end;

function TSortedList.size: Word;
begin
  size:=_size;
end;

end.
