unit data;

interface

uses
  DOS, list;

const
  VERSION         = 'DEMON 1.0';
  CFGNAME         = 'demon.cfg';
  DONTMODIFYMSG   = '## This file was generated by ' + VERSION + '. Do not modify! ##';
  CRLF            = #10#13;
  FLAG_FAST       = 1;
  FLAG_RESPAWN    = 2;
  FLAG_NOMONSTERS = 4;
  FLAG_TIMEDEMO   = 8;
  BUFFERMIN       = 128;
  BUFFERMAX       = 8192;
  IO_OK           = 0;
  IO_NOFILE       = 1;
  IO_WRTERR       = 2;

type
  TBuf64K     = array[1..65535] of Byte;
  PBuf64K     = ^TBuf64K;

  Str8        = String[8];
  Str12       = String[12];
  Str24       = String[24];
  Str40       = String[40];

  TGame       = (Doom1, Doom2, TNT, Plutonia);
  TGameTitle  = record
                  short: Str8;
                  full : Str40;
                end;
  TGameTitles = array[TGame] of TGameTitle;

  TMode       = (Coop, DeathMatch, AltDeath);
  TModeNames  = array[TMode] of Str24;

  TEpisode    = 1..4;
  TEpiNames   = array[TEpisode] of Str24;

  TLevel      = 1..32;

  TSkill      = 1..5;
  TSkillNames = array[TSkill] of Str24;

  TBufferRange= BUFFERMIN..BUFFERMAX;

  TPlayers    = 1..4;

  TVType      = (Levels, Misc, Multi, PWAD, DHT);
  TVTypeNames = array[TVType] of record
                                   path,
                                   full: Str12;
                                 end;

  TLocal      = record
                  vidname: Str12;
                  wadname: Str24;
                  zipname: Str12;
                  vidtype: TVType;
                  episode: TEpisode;
                  level: TLevel;
                  skill: TSkill;
                  flags: Byte;
                  players: TPlayers;
                  mode: TMode;
                end;
  TLocals     = array[TGame] of TLocal;
  TGlobal     = record
                  pkzip: String;
                  paths: array[TGame] of String;
                  game: TGame;
                  local: TLocals;
                  buffer: TBufferRange;
                end;
  TINICnt     = record
                  msg: String;
                  info: TGlobal;
                end;
  TINIFile    = File of TINICnt;

const GameTitles: TGameTitles =
                  ((short: 'Doom I'  ; full: 'Ultimate DooM'),
                   (short: 'Doom II' ; full: 'DooM ][ - Hell on Earth'),
                   (short: 'TNT'     ; full: 'Final DooM: TNT - Evilution'),
                   (short: 'Plutonia'; full: 'Final DooM: The Plutonia Experiment'));

      EpisodeStr: TEpiNames   =
                   ('Knee-deep in the Dead',
                    'The shores of Hell',
                    'Inferno',
                    'Thy flesh consumed');

      SkillStr  : TSkillNames =
                   ('I''m too young to die!',
                    'Hey, not too rough!',
                    'Hurt me plenty!',
                    'Ultra-Violence',
                    'NIGHTMARE!');

      ModeStr   : TModeNames =
                   ('Cooperative', 'DeathMatch', 'AltDeath');

      TypeStr   : TVTypeNames =
                  ((path: 'levels\'  ; full: 'Levels'),
                   (path: 'misc\'    ; full: 'Misc.'),
                   (path: 'multiplr\'; full: 'Multiplayer'),
                   (path: 'pwad\'    ; full: 'PWAD'),
                   (path: 'dht\'     ; full: 'DHT-exams'));

implementation

end.
