/*
	DooM INFO.c processor, by Frans P. de Vries.

Derived from:

	DooM MaP StaTistics, by Frans P. de Vries.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	THINGS.H - Thing type and flag definitions.
*/

#ifndef THINGS_H
#define THINGS_H

/*
	the global function prototypes
*/
void InitStrifeThings( void);


/* Strife Things */

/* Starting points */
#define THING_PLAYER5S        5
#define THING_PLAYER6S        6
#define THING_PLAYER7S        7
#define THING_PLAYER8S        8

/* Enemies */
#define THING_ACOLYTE1TAN     3002
#define THING_ACOLYTE2RED     142
#define THING_ACOLYTE3RUST    143
#define THING_ACOLYTE4GRAY    146
#define THING_ACOLYTE5DGREEN  147
#define THING_ACOLYTE6GOLD    148
#define THING_ACOLYTE7LGREEN  232
#define THING_ACOLYTE8BLUE    231
#define THING_SHADOWACOLYTE   58
#define THING_BECOMACOLYTE    201
#define THING_STALKER2        186
#define THING_SENTINEL        3006
#define THING_CEILTURRET      27
#define THING_REAVER          3001
#define THING_TEMPLAR         3003
#define THING_CRUSADER        3005
#define THING_BISHOP          187
#define THING_ORACLE          199
#define THING_MACIL1          64
#define THING_MACIL2SP        200
#define THING_LOREMASTER      12
#define THING_INQUISITOR      16
#define THING_PROGRAMMER      71
#define THING_SPECTREPROGR    129
#define THING_SPECTREBISHOP   75
#define THING_SPECTREORACLE   76
#define THING_SPECTREMACIL    167
#define THING_SPECTRELOREM    168
#define THING_ENTITY          128
#define THING_ENTITYNEST      26
#define THING_ENTITYPOD       198

/* Other characters */
#define THING_ARMORER         73
#define THING_BARKEEP         72
#define THING_MEDIC           74
#define THING_WEAPONSMITH     116
#define THING_REBEL1          9
#define THING_REBEL2          144
#define THING_REBEL3          145
#define THING_REBEL4          149
#define THING_REBEL5          150
#define THING_REBEL6          151
#define THING_BEGGAR1         141
#define THING_BEGGAR2         155
#define THING_BEGGAR3         156
#define THING_BEGGAR4         157
#define THING_BEGGAR5         158
#define THING_KNEELGUY        204
#define THING_ZOMBIE          169
#define THING_ZOMBIESPAWN     170
#define THING_PEASANTBLUE     181
#define THING_PEASANTDGRN1    172
#define THING_PEASANTDGRN2    173
#define THING_PEASANTDGRN3    174
#define THING_PEASANTGOLD1    178
#define THING_PEASANTGOLD2    179
#define THING_PEASANTGOLD3    180
#define THING_PEASANTGRAY1    66
#define THING_PEASANTGRAY2    134
#define THING_PEASANTGRAY3    135
#define THING_PEASANTLGRN1    175
#define THING_PEASANTLGRN2    176
#define THING_PEASANTLGRN3    177
#define THING_PEASANTRED1     65
#define THING_PEASANTRED2     132
#define THING_PEASANTRED3     133
#define THING_PEASANTRUST1    67
#define THING_PEASANTRUST2    136
#define THING_PEASANTRUST3    137
#define THING_PEASANTTAN1     3004
#define THING_PEASANTTAN2     130
#define THING_PEASANTTAN3     131

/* Weapons & ammo */
#define THING_CROSSBOW2       2001
#define THING_ASSAULTRIFLE    2002
#define THING_ASSAULTRIFLE2   2006
#define THING_MINIMSLAUNCH    2003
#define THING_GRENADELAUNCH   154
#define THING_FLAMETHROW      2005
#define THING_MAULER          2004
#define THING_SIGIL1          77
#define THING_SIGIL2          78
#define THING_SIGIL3          79
#define THING_SIGIL4          80
#define THING_SIGIL5          81
#define THING_ELECBOLTS       114
#define THING_POISBOLTS       115
#define THING_BULLETCLIP      2007
#define THING_BULLETSBOX      2048
#define THING_MISSILES        2010
#define THING_MISSILECRATE    2046
//#define THING_GASGRENADE      84    /* unused */
#define THING_HEGRENADE       152
#define THING_PHOSPHGRENADE   153
#define THING_ENERGYPOD       2047
#define THING_ENERGYPACK      17

/* Enhancements & bonuses */
#define THING_MEDPATCH        2011
#define THING_MEDICALKIT      2012
#define THING_SURGERYKIT      83
#define THING_LEATHERARMOR    2018
#define THING_METALARMOR      2019
#define THING_AMMOSATCHEL     183
#define THING_COMMUNICATOR    206
#define THING_ENVIRONSUIT     2025
#define THING_MAPSTRIFE       2026
#define THING_SCANNER         2027
#define THING_SHADOWARMOR     2024
#define THING_TARGETER        207
#define THING_TELEPBEACON     10

/* Quest items */
#define THING_GOLDCOIN        93
#define THING_GOLD10          138
#define THING_GOLD25          139
#define THING_GOLD50          140
#define THING_BRKNPWRCOUPL    226
#define THING_POWERCOUPL      220
#define THING_DEGNINORE       59
#define THING_FFIELDGUARD     25
#define THING_GATEPISTON      45
#define THING_OFFICERUNIF     52
#define THING_GUARDUNIF       90
#define THING_POWERCRYSTAL    92
#define THING_OFFERCHALICE1   205
#define THING_COMPUTER        182

/* Keys */
#define THING_IDBADGE         184
#define THING_IDCARD          13
#define THING_BASEKEY         230
#define THING_BLUECRYSKEY     193
#define THING_BRASSKEY        39
#define THING_CHAPELKEY       195
#define THING_COREKEY         236
#define THING_FACTORYKEY      234
#define THING_GOLDKEY         40
#define THING_MAULERKEY       233
#define THING_MINEKEY         235
#define THING_ORACLEKEY       61
#define THING_ORDERKEY        86
#define THING_PASSCARD        185
#define THING_REDCRYSKEY      192
#define THING_SEVEREDHAND     91
#define THING_SILVERKEY2      38
#define THING_WAREHOUSEKEY    166

/* Obstacles */
#define THING_TREESTUB        33
#define THING_SHORTBUSH       60
#define THING_TALLBUSH        62
#define THING_PALMTREE        51
#define THING_BIGTREE         202
#define THING_POTTEDTREE      203
#define THING_CANDELABRA      35
#define THING_MEDIUMTORCH     111
#define THING_LARGETORCH      47
#define THING_HUGETORCH       50
#define THING_OUTSIDELAMP     43
#define THING_POLELANTERN     46
#define THING_GLOBELIGHT      2028
#define THING_SILVERTLAMP     196
#define THING_BRASSTLAMP      197
#define THING_ALIENSPLIGHT    225
#define THING_CHIMNEYSTACK    63
#define THING_BARRCOLUMN      69
#define THING_TECHPILLAR      48
#define THING_AZTECPILLAR     54
#define THING_DAMGDAZPILLAR   55
#define THING_RUINDAZPILLAR   56
#define THING_HUGETCHPILLAR   57
#define THING_HUGEALNPILLAR   227
#define THING_ALIENBCOLUMN    221
#define THING_ALIENFLOORB     222
#define THING_ALIENCEILB      223
#define THING_ALIENASPCL      224
#define THING_STATUE          110
#define THING_RUINEDSTAT      44
#define THING_POT             165
#define THING_PITCHER         188
#define THING_STOOL           189
#define THING_ANVIL           194
#define THING_TRAY            68
#define THING_AMMOFILLER      228
#define THING_BURNINGBARREL   70
#define THING_BURNINGBOWL     105
#define THING_BURNINGBRAZR    106
#define THING_HEARTSINTANK    113
#define THING_SURGERYCRAB     117
#define THING_HUGETANK1       209
#define THING_HUGETANK2       210
#define THING_HUGETANK3       211
#define THING_TANK4           213
#define THING_TANK5           214
#define THING_TANK6           229
#define THING_CAVEPLRTOP      159
#define THING_CAVEPLRBOT      162
#define THING_STALACTLRG      98
#define THING_STALAGMLRG      160
#define THING_STALACTSML      161
#define THING_STALAGMSML      163
#define THING_BARRELSTRIFE    94
#define THING_WOODENBARREL    82

/* Decorations */
#define THING_DEADPLAYER      15
#define THING_DEADPEASANT     18
#define THING_DEADREBEL       19
#define THING_DEADREAVER      20
#define THING_DEADACOLYTE     21
#define THING_DEADCRUSADER    22
#define THING_KLAXONWLIGHT    24
#define THING_CAGELIGHT       28
#define THING_CANDLE          34
#define THING_SMLBURNTORCH    107
#define THING_SMLUNLITTORCH   108
#define THING_SILVRFLUORLIT   95
#define THING_BRASSFLUORLIT   96
#define THING_GOLDFLUORLIT    97
#define THING_RUBBLE1         29
#define THING_RUBBLE2         30
#define THING_RUBBLE3         31
#define THING_RUBBLE4         32
#define THING_RUBBLE5         36
#define THING_RUBBLE6         37
#define THING_RUBBLE7         41
#define THING_RUBBLE8         42
#define THING_ROCK1           99
#define THING_ROCK2           100
#define THING_ROCK3           101
#define THING_ROCK4           102
#define THING_CEILWTRDRIP     53
#define THING_FLOORWTRDRIP    103
#define THING_WATERFSPLASH    104
#define THING_WATERFOUNTAIN   112
#define THING_STICKINWATER    215
#define THING_MUG             164
#define THING_METALPOT        190
#define THING_TUB             191
#define THING_WATERBOTTLE     2014
#define THING_REBELBOOTS      217
#define THING_REBELHELMET     218
#define THING_REBELSHIRT      219
#define THING_CEILINGCHAIN    109
#define THING_SACRIFGUY       212
#define THING_SIGILBANNER     216

/* Specials */
#define THING_TELEPSWIRL      23
#define THING_PRACTTARGET     208
#define THING_RATBUDDY        85

/* Veteran Ed. */
#define THING_ORESPAWNER      7975
#define THING_OFFERCHALICE2   7970
#define THING_REDTALIS        7966
#define THING_GREENTALIS      7967
#define THING_BLUETALIS       7968
#define THING_TEAMBLUE        5080
#define THING_TEAMRED         5081
#define THING_FLAGBLUE        5130
#define THING_FLAGRED         5131

#endif /* THINGS_H */

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
