/*
	DooM INFO.c processor, by Frans P. de Vries.

Derived from:

	DooM MaP StaTistics, by Frans P. de Vries.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	THINGS.C - Thing routines.
*/

#include "things.h"
#include "../common/things.h"


/*
	initialize Strife thing classes and items
*/
void InitStrifeThings( void)
{
	/* initialize class headers */
	AppendClass( ThClassMnst, "Enemies", "Monster#Strife", NULL);
	AppendClass( ThClassChar, "Other characters", ":Category:Strife_characters", NULL);
	AppendClass( ThClassWeap, "Weapons", "Weapon#Strife", NULL);
	AppendClass( ThClassAmmo, "Ammunition", "Ammo#Strife", NULL);
	AppendClass( ThClassHlAr, "Health & Armor", "Item#Strife", NULL);
	AppendClass( ThClassItem, "Items", "Item#Strife", NULL);
	AppendClass( ThClassKeys, "Keys & Quest items", "Strife keys",
	                          "[[Strife keys|Keys]] & [[Item#Quest Items|Quest items]]");
	AppendClass( ThClassObst, "Obstacles", NULL, NULL);
	AppendClass( ThClassDeco, "Decorations", NULL, NULL);
	AppendClass( ThClassMisc, "Other", NULL, NULL);
	AppendClass( ThClassSnds, "Veteran Edition", "Strife: Veteran Edition", NULL);

	/* initialize enemies w/ hitpoints */
	AppendItem( ThClassMnst, THING_ACOLYTE8BLUE, "Acolyte (blue)", "Acolyte"); // 60
	AppendItem( ThClassMnst, THING_ACOLYTE5DGREEN, "Acolyte (dark green)", "Acolyte"); // 70
	AppendItem( ThClassMnst, THING_ACOLYTE6GOLD, "Acolyte (gold)", "Acolyte"); // 70
	AppendItem( ThClassMnst, THING_ACOLYTE4GRAY, "Acolyte (gray)", "Acolyte"); // 70
	AppendItem( ThClassMnst, THING_ACOLYTE7LGREEN, "Acolyte (light green)", "Acolyte"); // 60
	AppendItem( ThClassMnst, THING_ACOLYTE2RED, "Acolyte (red)", "Acolyte"); // 70
	AppendItem( ThClassMnst, THING_ACOLYTE3RUST, "Acolyte (rust)", "Acolyte"); // 70
	AppendItem( ThClassMnst, THING_ACOLYTE1TAN, "Acolyte (tan)", "Acolyte"); // 70
	AppendItem( ThClassMnst, THING_SHADOWACOLYTE, "Shadow Acolyte", "Acolyte"); // 70
	AppendItem( ThClassMnst, THING_BECOMACOLYTE, "Becoming Acolyte", NULL); // 70
	AppendItem( ThClassMnst, THING_STALKER2, "Stalker", "Stalker (Strife)"); // 80
	AppendItem( ThClassMnst, THING_SENTINEL, "Sentinel", ""); // 100
	AppendItem( ThClassMnst, THING_CEILTURRET, "Ceiling turret", ""); // 125
	AppendItem( ThClassMnst, THING_REAVER, "Reaver", ""); // 150
	AppendItem( ThClassMnst, THING_TEMPLAR, "Templar", ""); // 300
	AppendItem( ThClassMnst, THING_CRUSADER, "Crusader", ""); // 400
	AppendItem( ThClassMnst, THING_BISHOP, "Bishop", ""); // 500
	AppendItem( ThClassMnst, THING_ORACLE, "Oracle", ""); // 1
	AppendItem( ThClassMnst, THING_MACIL1, "Macil", ""); // 95
	AppendItem( ThClassMnst, THING_MACIL2SP, "Macil Spectre", "Macil"); // 95
	AppendItem( ThClassMnst, THING_LOREMASTER, "Loremaster", ""); // 800
	AppendItem( ThClassMnst, THING_INQUISITOR, "Inquisitor", ""); // 1000
	AppendItem( ThClassMnst, THING_PROGRAMMER, "Programmer", ""); // 1100
	AppendItem( ThClassMnst, THING_SPECTREPROGR, "Spectre (Programmer)", "Spectre (Strife)"); // 1000
	AppendItem( ThClassMnst, THING_SPECTREBISHOP, "Spectre (Bishop)", "Spectre (Strife)"); // 1200
	AppendItem( ThClassMnst, THING_SPECTREORACLE, "Spectre (Oracle)", "Spectre (Strife)"); // 1500
	AppendItem( ThClassMnst, THING_SPECTREMACIL, "Spectre (Macil)", "Spectre (Strife)"); // 1700
	AppendItem( ThClassMnst, THING_SPECTRELOREM, "Spectre (Loremaster)", "Spectre (Strife)"); // 2000
	AppendItem( ThClassMnst, THING_ENTITY, "Entity", ""); // 2500
	AppendItem( ThClassMnst, THING_ENTITYNEST, "Entity nest", "Entity"); // 1000
	AppendItem( ThClassMnst, THING_ENTITYPOD, "Entity pod", "Entity"); // 1000

	/* initialize other characters */
	AppendItem( ThClassChar, THING_ARMORER, "Armorer", "Merchant");
	AppendItem( ThClassChar, THING_BARKEEP, "Barkeep", "Merchant");
	AppendItem( ThClassChar, THING_MEDIC, "Medic", "Merchant");
	AppendItem( ThClassChar, THING_WEAPONSMITH, "Weapon smith", "Merchant");
	AppendItem( ThClassChar, THING_REBEL1, "Rebel 1", "Rebel");
	AppendItem( ThClassChar, THING_REBEL2, "Rebel 2", "Rebel");
	AppendItem( ThClassChar, THING_REBEL3, "Rebel 3", "Rebel");
	AppendItem( ThClassChar, THING_REBEL4, "Rebel 4", "Rebel");
	AppendItem( ThClassChar, THING_REBEL5, "Rebel 5", "Rebel");
	AppendItem( ThClassChar, THING_REBEL6, "Rebel 6", "Rebel");
	AppendItem( ThClassChar, THING_BEGGAR1, "Beggar 1", "Beggar");
	AppendItem( ThClassChar, THING_BEGGAR2, "Beggar 2", "Beggar");
	AppendItem( ThClassChar, THING_BEGGAR3, "Beggar 3", "Beggar");
	AppendItem( ThClassChar, THING_BEGGAR4, "Beggar 4", "Beggar");
	AppendItem( ThClassChar, THING_BEGGAR5, "Beggar 5", "Beggar");
	AppendItem( ThClassChar, THING_PEASANTBLUE, "Peasant Blue", "Peasant");
	AppendItem( ThClassChar, THING_PEASANTDGRN1, "Peasant Dark Green 1", "Peasant");
	AppendItem( ThClassChar, THING_PEASANTDGRN2, "Peasant Dark Green 2", "Peasant");
	AppendItem( ThClassChar, THING_PEASANTDGRN3, "Peasant Dark Green 3", "Peasant");
	AppendItem( ThClassChar, THING_PEASANTGOLD1, "Peasant Gold 1", "Peasant");
	AppendItem( ThClassChar, THING_PEASANTGOLD2, "Peasant Gold 2", "Peasant");
	AppendItem( ThClassChar, THING_PEASANTGOLD3, "Peasant Gold 3", "Peasant");
	AppendItem( ThClassChar, THING_PEASANTGRAY1, "Peasant Gray 1", "Peasant");
	AppendItem( ThClassChar, THING_PEASANTGRAY2, "Peasant Gray 2", "Peasant");
	AppendItem( ThClassChar, THING_PEASANTGRAY3, "Peasant Gray 3", "Peasant");
	AppendItem( ThClassChar, THING_PEASANTLGRN1, "Peasant Light Green 1", "Peasant");
	AppendItem( ThClassChar, THING_PEASANTLGRN2, "Peasant Light Green 2", "Peasant");
	AppendItem( ThClassChar, THING_PEASANTLGRN3, "Peasant Light Green 3", "Peasant");
	AppendItem( ThClassChar, THING_PEASANTRED1, "Peasant Red 1", "Peasant");
	AppendItem( ThClassChar, THING_PEASANTRED2, "Peasant Red 2", "Peasant");
	AppendItem( ThClassChar, THING_PEASANTRED3, "Peasant Red 3", "Peasant");
	AppendItem( ThClassChar, THING_PEASANTRUST1, "Peasant Rust 1", "Peasant");
	AppendItem( ThClassChar, THING_PEASANTRUST2, "Peasant Rust 2", "Peasant");
	AppendItem( ThClassChar, THING_PEASANTRUST3, "Peasant Rust 3", "Peasant");
	AppendItem( ThClassChar, THING_PEASANTTAN1, "Peasant Tan 1", "Peasant");
	AppendItem( ThClassChar, THING_PEASANTTAN2, "Peasant Tan 2", "Peasant");
	AppendItem( ThClassChar, THING_PEASANTTAN3, "Peasant Tan 3", "Peasant");
	AppendItem( ThClassChar, THING_KNEELGUY, "Kneeling Guy", "");
	AppendItem( ThClassChar, THING_ZOMBIE, "Zombie", "Peasant#Related_actors");
	AppendItem( ThClassChar, THING_ZOMBIESPAWN, "Zombie spawner", NULL);

	/* initialize weapons */
	AppendItem( ThClassWeap, THING_CROSSBOW2, "Crossbow", "");
	AppendItem( ThClassWeap, THING_ASSAULTRIFLE, "Assault rifle (lying)", "Assault rifle");
	AppendItem( ThClassWeap, THING_ASSAULTRIFLE2, "Assault rifle (standing)", "Assault rifle");
	AppendItem( ThClassWeap, THING_MINIMSLAUNCH, "Mini-missile launcher", "");
	AppendItem( ThClassWeap, THING_GRENADELAUNCH, "Grenade launcher", "");
	AppendItem( ThClassWeap, THING_FLAMETHROW, "Flamethrower", "");
	AppendItem( ThClassWeap, THING_MAULER, "Mauler", "");
	AppendItem( ThClassWeap, THING_SIGIL1, "Sigil 1 (Lightning)", "The Sigil of the One God");
	AppendItem( ThClassWeap, THING_SIGIL2, "Sigil 2 (Rail)", "The Sigil of the One God");
	AppendItem( ThClassWeap, THING_SIGIL3, "Sigil 3 (Spread)", "The Sigil of the One God");
	AppendItem( ThClassWeap, THING_SIGIL4, "Sigil 4 (Column)", "The Sigil of the One God");
	AppendItem( ThClassWeap, THING_SIGIL5, "Sigil 5 (Blast)", "The Sigil of the One God");

	/* initialize ammo */
	AppendItem( ThClassAmmo, THING_ELECBOLTS, "Electric bolt", "");
	AppendItem( ThClassAmmo, THING_POISBOLTS, "Poison bolt", "");
	AppendItem( ThClassAmmo, THING_BULLETCLIP, "Bullet clip", "");
	AppendItem( ThClassAmmo, THING_BULLETSBOX, "Box of bullets", "Box of bullets (Strife)");
	AppendItem( ThClassAmmo, THING_MISSILES, "Mini-missile", "");
	AppendItem( ThClassAmmo, THING_MISSILECRATE, "Crate of missiles", "");
	//AppendItem( ThClassAmmo, THING_GASGRENADE, "Gas grenade", ""); // unused
	AppendItem( ThClassAmmo, THING_HEGRENADE, "HE grenade", "");
	AppendItem( ThClassAmmo, THING_PHOSPHGRENADE, "Phosphorous grenade", "");
	AppendItem( ThClassAmmo, THING_ENERGYPOD, "Energy pod", "");
	AppendItem( ThClassAmmo, THING_ENERGYPACK, "Energy pack", "");

	/* initialize health/armor */
	AppendItem( ThClassHlAr, THING_MEDPATCH, "Med patch", "");
	AppendItem( ThClassHlAr, THING_MEDICALKIT, "Medical kit", "");
	AppendItem( ThClassHlAr, THING_SURGERYKIT, "Surgery kit", "");
	AppendItem( ThClassHlAr, THING_LEATHERARMOR, "Leather armor", "");
	AppendItem( ThClassHlAr, THING_METALARMOR, "Metal armor", "");

	/* initialize powerups/items */
	AppendItem( ThClassItem, THING_AMMOSATCHEL, "Ammo satchel", "");
	AppendItem( ThClassItem, THING_COMMUNICATOR, "Communicator", "");
	AppendItem( ThClassItem, THING_ENVIRONSUIT, "Environmental suit", "");
	AppendItem( ThClassItem, THING_GOLDCOIN, "Gold coin", "Gold");
	AppendItem( ThClassItem, THING_GOLD10, "10 Gold", "Gold");
	AppendItem( ThClassItem, THING_GOLD25, "25 Gold", "Gold");
	AppendItem( ThClassItem, THING_GOLD50, "50 Gold", "Gold");
	AppendItem( ThClassItem, THING_MAPSTRIFE, "Map", "Map (Strife)");
	AppendItem( ThClassItem, THING_SCANNER, "Scanner", "");
	AppendItem( ThClassItem, THING_SHADOWARMOR, "Shadow armor", "");
	AppendItem( ThClassItem, THING_TARGETER, "Targeter", "");
	AppendItem( ThClassItem, THING_TELEPBEACON, "Teleporter beacon", "");

	/* initialize keys */
	AppendItem( ThClassKeys, THING_IDBADGE, "ID badge", NULL);
	AppendItem( ThClassKeys, THING_IDCARD, "ID card", NULL);
	AppendItem( ThClassKeys, THING_BASEKEY, "Base key", NULL);
	AppendItem( ThClassKeys, THING_BLUECRYSKEY, "Blue crystal key", NULL);
	AppendItem( ThClassKeys, THING_BRASSKEY, "Brass key", NULL);
	AppendItem( ThClassKeys, THING_CHAPELKEY, "Chapel key", NULL);
	AppendItem( ThClassKeys, THING_COREKEY, "Core key", NULL);
	AppendItem( ThClassKeys, THING_FACTORYKEY, "Factory key", NULL);
	AppendItem( ThClassKeys, THING_GOLDKEY, "Gold key", NULL);
	AppendItem( ThClassKeys, THING_MAULERKEY, "Mauler key", NULL);
	AppendItem( ThClassKeys, THING_MINEKEY, "Mine key", NULL);
	AppendItem( ThClassKeys, THING_ORACLEKEY, "Oracle key", NULL);
	AppendItem( ThClassKeys, THING_ORDERKEY, "Order key", NULL);
	AppendItem( ThClassKeys, THING_PASSCARD, "Pass card", NULL);
	AppendItem( ThClassKeys, THING_REDCRYSKEY, "Red crystal key", NULL);
	AppendItem( ThClassKeys, THING_SEVEREDHAND, "Severed hand", NULL);
	AppendItem( ThClassKeys, THING_SILVERKEY2, "Silver key", NULL);
	AppendItem( ThClassKeys, THING_WAREHOUSEKEY, "Warehouse key", NULL);

	/* initialize quest items */
	AppendItem( ThClassKeys, THING_BRKNPWRCOUPL, "Broken power coupling", "Strife quest items#Broken power coupling");
	AppendItem( ThClassKeys, THING_POWERCOUPL, "Power coupling", NULL);
	AppendItem( ThClassKeys, THING_DEGNINORE, "Degnin ore", "Strife quest items#Degnin ore");
	AppendItem( ThClassKeys, THING_FFIELDGUARD, "Force field guard", "Force field");
	AppendItem( ThClassKeys, THING_GATEPISTON, "Gate piston", "Strife technology#Gate control");
	AppendItem( ThClassKeys, THING_OFFICERUNIF, "Officer uniform", "Strife quest items#Officer uniform");
	AppendItem( ThClassKeys, THING_GUARDUNIF, "Guard uniform", "Strife quest items#Guard uniform");
	AppendItem( ThClassKeys, THING_POWERCRYSTAL, "Power crystal", "Strife technology#Power crystal");
	AppendItem( ThClassKeys, THING_OFFERCHALICE1, "Offering chalice", "");
	AppendItem( ThClassKeys, THING_COMPUTER, "Computer", "Strife technology#Computer");

	/* initialize obstacles */
	AppendItem( ThClassObst, THING_TREESTUB, "Tree stub", NULL);
	AppendItem( ThClassObst, THING_SHORTBUSH, "Short bush", NULL);
	AppendItem( ThClassObst, THING_TALLBUSH, "Tall bush", NULL);
	AppendItem( ThClassObst, THING_PALMTREE, "Palm tree", NULL);
	AppendItem( ThClassObst, THING_BIGTREE, "Big tree", NULL);
	AppendItem( ThClassObst, THING_POTTEDTREE, "Potted tree", NULL);
	AppendItem( ThClassObst, THING_CANDELABRA, "Candelabra", NULL);
	AppendItem( ThClassObst, THING_MEDIUMTORCH, "Medium torch", NULL);
	AppendItem( ThClassObst, THING_LARGETORCH, "Large torch", NULL);
	AppendItem( ThClassObst, THING_HUGETORCH, "Huge torch", NULL);
	AppendItem( ThClassObst, THING_OUTSIDELAMP, "Outside lamp", NULL);
	AppendItem( ThClassObst, THING_POLELANTERN, "Pole lantern", NULL);
	AppendItem( ThClassObst, THING_GLOBELIGHT, "Globe light", NULL);
	AppendItem( ThClassObst, THING_SILVERTLAMP, "Silver tech lamp", NULL);
	AppendItem( ThClassObst, THING_BRASSTLAMP, "Brass tech lamp", NULL);
	AppendItem( ThClassObst, THING_ALIENSPLIGHT, "Alien spider light", NULL);
	AppendItem( ThClassObst, THING_CHIMNEYSTACK, "Chimneystack", NULL);
	AppendItem( ThClassObst, THING_BARRCOLUMN, "Barricade column", NULL);
	AppendItem( ThClassObst, THING_TECHPILLAR, "Tech pillar", NULL);
	AppendItem( ThClassObst, THING_AZTECPILLAR, "Aztec pillar", NULL);
	AppendItem( ThClassObst, THING_DAMGDAZPILLAR, "Damaged aztec pillar", NULL);
	AppendItem( ThClassObst, THING_RUINDAZPILLAR, "Ruined aztec pillar", NULL);
	AppendItem( ThClassObst, THING_HUGETCHPILLAR, "Huge tech pillar", NULL);
	AppendItem( ThClassObst, THING_HUGEALNPILLAR, "Huge alien pillar", NULL);
	AppendItem( ThClassObst, THING_ALIENBCOLUMN, "Alien bubble column", NULL);
	AppendItem( ThClassObst, THING_ALIENFLOORB, "Alien floor bubble", NULL);
	AppendItem( ThClassObst, THING_ALIENCEILB, "Alien ceiling bubble", NULL);
	AppendItem( ThClassObst, THING_ALIENASPCL, "Alien asp climber", NULL);
	AppendItem( ThClassObst, THING_STATUE, "Statue", NULL);
	AppendItem( ThClassObst, THING_RUINEDSTAT, "Ruined statue", NULL);
	AppendItem( ThClassObst, THING_POT, "Pot", NULL);
	AppendItem( ThClassObst, THING_PITCHER, "Pitcher", NULL);
	AppendItem( ThClassObst, THING_STOOL, "Stool", NULL);
	AppendItem( ThClassObst, THING_ANVIL, "Anvil", NULL);
	AppendItem( ThClassObst, THING_TRAY, "Tray", NULL);
	AppendItem( ThClassObst, THING_AMMOFILLER, "Ammo filler", NULL);
	AppendItem( ThClassObst, THING_BURNINGBARREL, "Burning barrel", "Barrel (Strife)");
	AppendItem( ThClassObst, THING_BURNINGBOWL, "Burning bowl", NULL);
	AppendItem( ThClassObst, THING_BURNINGBRAZR, "Burning brazier", NULL);
	AppendItem( ThClassObst, THING_HEARTSINTANK, "Hearts in tank", NULL);
	AppendItem( ThClassObst, THING_SURGERYCRAB, "Surgery crab", NULL);
	AppendItem( ThClassObst, THING_HUGETANK1, "Huge tank 1 with skeleton", NULL);
	AppendItem( ThClassObst, THING_HUGETANK2, "Huge tank 2", NULL);
	AppendItem( ThClassObst, THING_HUGETANK3, "Huge tank 3", NULL);
	AppendItem( ThClassObst, THING_TANK4, "Tank 4 spine with organs", NULL);
	AppendItem( ThClassObst, THING_TANK5, "Tank 5 stumpy the acolyte", NULL);
	AppendItem( ThClassObst, THING_TANK6, "Tank 6 spectre", NULL);
	AppendItem( ThClassObst, THING_CAVEPLRTOP, "Cave pillar top", NULL);
	AppendItem( ThClassObst, THING_CAVEPLRBOT, "Cave pillar bottom", NULL);
	AppendItem( ThClassObst, THING_STALACTLRG, "Stalactite (large)", NULL);
	AppendItem( ThClassObst, THING_STALAGMLRG, "Stalagmite (large)", NULL);
	AppendItem( ThClassObst, THING_STALACTSML, "Stalactite (small)", NULL);
	AppendItem( ThClassObst, THING_STALAGMSML, "Stalagmite (small)", NULL);
	AppendItem( ThClassObst, THING_BARRELSTRIFE, "Exploding barrel", "Barrel (Strife)");
	AppendItem( ThClassObst, THING_WOODENBARREL, "Wooden barrel", "Barrel (Strife)");

	/* initialize decorations */
	AppendItem( ThClassDeco, THING_DEADPLAYER, "Dead player (disappears)", NULL);
	AppendItem( ThClassDeco, THING_DEADPEASANT, "Dead peasant (disappears)", NULL);
	AppendItem( ThClassDeco, THING_DEADREBEL, "Dead rebel", NULL);
	AppendItem( ThClassDeco, THING_DEADREAVER, "Dead reaver", NULL);
	AppendItem( ThClassDeco, THING_DEADACOLYTE, "Dead acolyte (disappears)", NULL);
	AppendItem( ThClassDeco, THING_DEADCRUSADER, "Dead crusader", NULL);
	AppendItem( ThClassDeco, THING_KLAXONWLIGHT, "Klaxon warning light", NULL);
	AppendItem( ThClassDeco, THING_CAGELIGHT, "Cage light", NULL);
	AppendItem( ThClassDeco, THING_CANDLE, "Candle", NULL);
	AppendItem( ThClassDeco, THING_SMLBURNTORCH, "Small torch (lit)", NULL);
	AppendItem( ThClassDeco, THING_SMLUNLITTORCH, "Small torch (unlit)", NULL);
	AppendItem( ThClassDeco, THING_SILVRFLUORLIT, "Silver fluorescent light", NULL);
	AppendItem( ThClassDeco, THING_BRASSFLUORLIT, "Brass fluorescent light", NULL);
	AppendItem( ThClassDeco, THING_GOLDFLUORLIT, "Gold fluorescent light", NULL);
	AppendItem( ThClassDeco, THING_RUBBLE1, "Rubble 1", NULL);
	AppendItem( ThClassDeco, THING_RUBBLE2, "Rubble 2", NULL);
	AppendItem( ThClassDeco, THING_RUBBLE3, "Rubble 3", NULL);
	AppendItem( ThClassDeco, THING_RUBBLE4, "Rubble 4", NULL);
	AppendItem( ThClassDeco, THING_RUBBLE5, "Rubble 5", NULL);
	AppendItem( ThClassDeco, THING_RUBBLE6, "Rubble 6", NULL);
	AppendItem( ThClassDeco, THING_RUBBLE7, "Rubble 7", NULL);
	AppendItem( ThClassDeco, THING_RUBBLE8, "Rubble 8", NULL);
	AppendItem( ThClassDeco, THING_ROCK1, "Rock 1", NULL);
	AppendItem( ThClassDeco, THING_ROCK2, "Rock 2", NULL);
	AppendItem( ThClassDeco, THING_ROCK3, "Rock 3", NULL);
	AppendItem( ThClassDeco, THING_ROCK4, "Rock 4", NULL);
	AppendItem( ThClassDeco, THING_CEILWTRDRIP, "Ceiling water drip", NULL);
	AppendItem( ThClassDeco, THING_FLOORWTRDRIP, "Floor water drip", NULL);
	AppendItem( ThClassDeco, THING_WATERFSPLASH, "Waterfall splash", NULL);
	AppendItem( ThClassDeco, THING_WATERFOUNTAIN, "Water fountain", NULL);
	AppendItem( ThClassDeco, THING_STICKINWATER, "Stick in water", NULL);
	AppendItem( ThClassDeco, THING_MUG, "Mug", NULL);
	AppendItem( ThClassDeco, THING_METALPOT, "Metal pot", NULL);
	AppendItem( ThClassDeco, THING_TUB, "Tub", NULL);
	AppendItem( ThClassDeco, THING_WATERBOTTLE, "Water bottle", NULL);
	AppendItem( ThClassDeco, THING_REBELBOOTS, "Rebel boots", NULL);
	AppendItem( ThClassDeco, THING_REBELHELMET, "Rebel helmet", NULL);
	AppendItem( ThClassDeco, THING_REBELSHIRT, "Rebel shirt", NULL);
	AppendItem( ThClassDeco, THING_CEILINGCHAIN, "Ceiling chain", NULL);
	AppendItem( ThClassDeco, THING_SACRIFGUY, "Sacrificed guy", NULL);
	AppendItem( ThClassDeco, THING_SIGILBANNER, "Sigil banner", NULL);

	/* initialize miscellaneous */
	AppendItem( ThClassMisc, THING_PLAYER1, "Player 1 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER2, "Player 2 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER3, "Player 3 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER4, "Player 4 start", "Player");
	AppendItem( ThClassMisc, THING_DEATHMATCH, "Deathmatch start", "");
	AppendItem( ThClassMisc, THING_TELEPORT, "Teleport landing", "Teleporter");
	AppendItem( ThClassMisc, THING_TELEPSWIRL, "Teleport swirl", NULL);
	AppendItem( ThClassMisc, THING_PRACTTARGET, "Practice target", NULL);
	AppendItem( ThClassMisc, THING_RATBUDDY, "Rat buddy", NULL);

	/* initialize Veteran Ed. */
	AppendItem( ThClassSnds, THING_ORESPAWNER, "Ore spawner", "Strife quest items#Degnin ore");
	AppendItem( ThClassSnds, THING_OFFERCHALICE2, "Blue chalice", "Offering chalice#Veteran Edition");
	AppendItem( ThClassSnds, THING_REDTALIS, "Red talisman", "Talisman");
	AppendItem( ThClassSnds, THING_GREENTALIS, "Green talisman", "Talisman");
	AppendItem( ThClassSnds, THING_BLUETALIS, "Blue talisman", "Talisman");
	AppendItem( ThClassSnds, THING_TEAMBLUE, "Team Blue start", "Capture the Chalice");
	AppendItem( ThClassSnds, THING_TEAMRED, "Team Red start", "Capture the Chalice");
	AppendItem( ThClassSnds, THING_FLAGBLUE, "Blue flag spot", "Capture the Chalice");
	AppendItem( ThClassSnds, THING_FLAGRED, "Red flag spot", "Capture the Chalice");
}

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
