/*
	HereTic INFO.c processor, by Frans P. de Vries.

Derived from:

	DooM MaP StaTistics, by Frans P. de Vries.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	THINGS.C - Thing routines.
*/

#include "things.h"
#include "../common/things.h"


/*
	initialize Heretic thing classes and items
*/
void InitHereticThings( void)
{
	/* initialize class headers */
	AppendClass( ThClassMnst, "Monsters", "Monster#Heretic", NULL);
	AppendClass( ThClassWeap, "Weapons", "Weapon#Heretic", NULL);
	AppendClass( ThClassAmmo, "Ammunition", "Ammo#Heretic", NULL);
	AppendClass( ThClassHlAr, "Health & Armor", "Item#Heretic", NULL);
	AppendClass( ThClassItem, "Items", "Item#Heretic", NULL);
	AppendClass( ThClassKeys, "Keys", "Heretic keys", NULL);
	AppendClass( ThClassObst, "Obstacles", NULL, NULL);
	AppendClass( ThClassDeco, "Decorations", NULL, NULL);
	AppendClass( ThClassSnds, "Ambient sounds", "Heretic ambient sound things", NULL);
	AppendClass( ThClassMisc, "Other", NULL, NULL);

	/* initialize monsters w/ hitpoints */
	AppendItem( ThClassMnst, THING_GARGOYLE, "Gargoyle", ""); // 50
	AppendItem( ThClassMnst, THING_FRGARGOYLE, "Fire gargoyle", "Gargoyle"); // 80
	AppendItem( ThClassMnst, THING_GOLEM, "Golem", ""); // 80
	AppendItem( ThClassMnst, THING_GOLEMGH, "Golem ghost", "Golem"); // 80
	AppendItem( ThClassMnst, THING_NTGOLEM, "Nitrogolem", "Golem"); // 100
	AppendItem( ThClassMnst, THING_NTGOLEMGH, "Nitrogolem ghost", "Golem"); // 100
	AppendItem( ThClassMnst, THING_SABRECLAW, "Sabreclaw", ""); // 150
	AppendItem( ThClassMnst, THING_DISCIPLE, "Disciple of D'Sparil", ""); // 180
	AppendItem( ThClassMnst, THING_WARRIOR, "Undead warrior", ""); // 200
	AppendItem( ThClassMnst, THING_WARRIORGH, "Undead warrior ghost", ""); // 200
	AppendItem( ThClassMnst, THING_WEREDRAGON, "Weredragon", ""); // 220
	AppendItem( ThClassMnst, THING_OPHIDIAN, "Ophidian", ""); // 280
	AppendItem( ThClassMnst, THING_IRONLICH, "Iron lich", ""); // 700
	AppendItem( ThClassMnst, THING_MAULOTAUR, "Maulotaur", ""); // 3000
	AppendItem( ThClassMnst, THING_DSPARIL, "D'Sparil", ""); // 5500

	/* initialize weapons */
	AppendItem( ThClassWeap, THING_GAUNTLETS, "Gauntlets of the Necromancer", "");
	AppendItem( ThClassWeap, THING_CROSSBOW, "Ethereal crossbow", "");
	AppendItem( ThClassWeap, THING_DRAGONCLAW, "Dragon claw", "");
	AppendItem( ThClassWeap, THING_HELLSTAFF, "Hellstaff", "");
	AppendItem( ThClassWeap, THING_PHOENIXROD, "Phoenix rod", "");
	AppendItem( ThClassWeap, THING_FIREMACE, "Firemace", "");

	/* initialize ammo */
	AppendItem( ThClassAmmo, THING_CRYSTAL, "Wand crystal", "");
	AppendItem( ThClassAmmo, THING_CRGEODE, "Crystal geode", "");
	AppendItem( ThClassAmmo, THING_ARROWS, "Ethereal arrows", "");
	AppendItem( ThClassAmmo, THING_ARQUIVER, "Quiver of ethereal arrows", "");
	AppendItem( ThClassAmmo, THING_CLAWORB, "Claw orb", "");
	AppendItem( ThClassAmmo, THING_ENERGYORB, "Energy orb", "");
	AppendItem( ThClassAmmo, THING_RUNESSML, "Lesser runes", "");
	AppendItem( ThClassAmmo, THING_RUNESLRG, "Greater runes", "");
	AppendItem( ThClassAmmo, THING_FLAMEORBSML, "Flame orb", "");
	AppendItem( ThClassAmmo, THING_FLAMEORBLRG, "Inferno orb", "");
	AppendItem( ThClassAmmo, THING_MACESPHSML, "Mace spheres", "");
	AppendItem( ThClassAmmo, THING_MACESPHLRG, "Pile of mace spheres", "");

	/* initialize health/armor */
	AppendItem( ThClassHlAr, THING_CRYSTALVIAL, "Crystal vial", "");
	AppendItem( ThClassHlAr, THING_ENCHSHIELD, "Enchanted shield", "");
	AppendItem( ThClassHlAr, THING_SILVSHIELD, "Silver shield", "");

	/* initialize powerups/items */
	AppendItem( ThClassItem, THING_BAGHOLDING, "Bag of Holding", "");
	AppendItem( ThClassItem, THING_CHAOSDEV, "Chaos Device", "");
	AppendItem( ThClassItem, THING_MAPSCROLL, "Map scroll", "");
	AppendItem( ThClassItem, THING_MORPHOVUM, "Morph Ovum", "");
	AppendItem( ThClassItem, THING_MYSTICURN, "Mystic urn", "");
	AppendItem( ThClassItem, THING_QUARTZFLASK, "Quartz flask", "");
	AppendItem( ThClassItem, THING_RINGINVULN, "Ring of Invincibility", "");
	AppendItem( ThClassItem, THING_SHADOWSPHR, "Shadowsphere", "");
	AppendItem( ThClassItem, THING_TIMEBOMB, "Time Bomb of the Ancients", "");
	AppendItem( ThClassItem, THING_TOMEPOWER, "Tome of Power", "");
	AppendItem( ThClassItem, THING_TORCH, "Torch", "");
	AppendItem( ThClassItem, THING_WINGS, "Wings of Wrath", "");

	/* initialize keys */
	AppendItem( ThClassKeys, THING_BLUEKEY, "Blue key", "Blue key (Heretic)");
	AppendItem( ThClassKeys, THING_GREENKEY, "Green key", "Green key (Heretic)");
	AppendItem( ThClassKeys, THING_YELLOWKEY, "Yellow key", "Yellow key (Heretic)");

	/* initialize obstacles */
	AppendItem( ThClassObst, THING_BROWNBARREL, "Barrel", NULL);
	AppendItem( ThClassObst, THING_TBROWNPILLAR, "Tall brown pillar", NULL);
	AppendItem( ThClassObst, THING_SGREYPILLAR, "Short grey pillar", NULL);
	AppendItem( ThClassObst, THING_SERPENTTORCH, "Serpent torch", NULL);
	AppendItem( ThClassObst, THING_FIREBRAZIER, "Fire brazier", NULL);
	AppendItem( ThClassObst, THING_HANGINGCORPSE, "Hanging corpse", NULL);
	AppendItem( ThClassObst, THING_STALACTSMALL, "Small stalactite", NULL);
	AppendItem( ThClassObst, THING_STALACTLARGE, "Large stalactite", NULL);
	AppendItem( ThClassObst, THING_STALAGMSMALL, "Small stalagmite", NULL);
	AppendItem( ThClassObst, THING_STALAGMLARGE, "Large stalagmite", NULL);

	/* initialize decorations */
	AppendItem( ThClassDeco, THING_CHANDELIER, "Chandelier", NULL);
	AppendItem( ThClassDeco, THING_WALLTORCH, "Wall torch", NULL);
	AppendItem( ThClassDeco, THING_MOSS1STR, "Moss 1 string", NULL);
	AppendItem( ThClassDeco, THING_MOSS3STR, "Moss 2 strings", NULL);
	AppendItem( ThClassDeco, THING_HANGINGSKULL4, "Hanging skull (long rope)", NULL);
	AppendItem( ThClassDeco, THING_HANGINGSKULL3, "Hanging skull (medium rope)", NULL);
	AppendItem( ThClassDeco, THING_HANGINGSKULL2, "Hanging skull (short rope)", NULL);
	AppendItem( ThClassDeco, THING_HANGINGSKULL1, "Hanging skull (shortest rope)", NULL);

	/* initialize ambient sounds */
	AppendItem( ThClassSnds, THING_SNDBELSS, "Bells", NULL);
	AppendItem( ThClassSnds, THING_SNDDROPS, "Drops", NULL);
	AppendItem( ThClassSnds, THING_SNDFASTFOOT, "Fast footsteps", NULL);
	AppendItem( ThClassSnds, THING_SNDGROWL, "Growl", NULL);
	AppendItem( ThClassSnds, THING_SNDHEARTBEAT, "Heart beat", NULL);
	AppendItem( ThClassSnds, THING_SNDLAUGHTER, "Laughter", NULL);
	AppendItem( ThClassSnds, THING_SNDMAGIC, "Magic", NULL);
	AppendItem( ThClassSnds, THING_SNDSCREAM, "Scream", NULL);
	AppendItem( ThClassSnds, THING_SNDSLOWFOOT, "Slow footsteps", NULL);
	AppendItem( ThClassSnds, THING_SNDSQUISH, "Squish", NULL);
	AppendItem( ThClassSnds, THING_SNDWATERFALL, "Waterfall", NULL);
	AppendItem( ThClassSnds, THING_SNDWIND, "Wind", NULL);

	/* initialize miscellaneous */
	AppendItem( ThClassMisc, THING_PLAYER1, "Player 1 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER2, "Player 2 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER3, "Player 3 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER4, "Player 4 start", "Player");
	AppendItem( ThClassMisc, THING_DEATHMATCH, "Deathmatch start", "");
	AppendItem( ThClassMisc, THING_DSPARILSPOT, "D'Sparil teleport spot", "D'Sparil");
	AppendItem( ThClassMisc, THING_KEYGIZMOBLUE, "Key gizmo (blue)", "Heretic keys#Key gizmos");
	AppendItem( ThClassMisc, THING_KEYGIZMOGREEN, "Key gizmo (green)", "Heretic keys#Key gizmos");
	AppendItem( ThClassMisc, THING_KEYGIZMOYELLOW, "Key gizmo (yellow)", "Heretic keys#Key gizmos");
	AppendItem( ThClassMisc, THING_POD, "Pod", "");
	AppendItem( ThClassMisc, THING_PODGENERATOR, "Pod generator", "Pod");
	AppendItem( ThClassMisc, THING_VOLCANO, "Volcano", "");
	AppendItem( ThClassMisc, THING_GLITTELEEXIT, "Teleport glitter (blue)", NULL);
	AppendItem( ThClassMisc, THING_GLITTELEPORT, "Teleport glitter (red)", NULL);
	AppendItem( ThClassMisc, THING_TELEPORT, "Teleport landing", "Teleporter");
}

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
