/*
	DooM INFO.c processor, by Frans P. de Vries.

Derived from:

	DooM MaP StaTistics, by Frans P. de Vries.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	THINGS.C - Thing routines.
*/

#include "things.h"
#include "../common/things.h"


/*
	initialize Doom thing classes and items
*/
void InitDoomThings( void)
{
	/* initialize class headers */
	AppendClass( ThClassMnst, "Monsters", "Monster", NULL);
	AppendClass( ThClassWeap, "Weapons", "Weapon", NULL);
	AppendClass( ThClassAmmo, "Ammunition", "Ammo", NULL);
	AppendClass( ThClassItem, "Artifact items", "Item#Doom games", NULL);
	AppendClass( ThClassHlAr, "Powerups", "Item#Doom games", NULL);
	AppendClass( ThClassKeys, "Keys", "Key", NULL);
	AppendClass( ThClassObst, "Obstacles", NULL, NULL);
	AppendClass( ThClassDeco, "Decorations", NULL, NULL);
	AppendClass( ThClassMisc, "Other", NULL, NULL);

	/* initialize monsters w/ hitpoints */
	AppendItem( ThClassMnst, THING_HUMAN, "Zombieman", ""); // 20
	AppendItem( ThClassMnst, THING_SERGEANT, "Shotgun guy", ""); // 30
	AppendItem( ThClassMnst, THING_COMMANDO, "Heavy weapon dude", ""); // 70
	AppendItem( ThClassMnst, THING_IMP, "Imp", ""); // 60
//	AppendItem( ThClassMnst, THING_NIGHTMAREIMP, "Nightmare imp", ""); // 60, Doom 64
	AppendItem( ThClassMnst, THING_LOSTSOUL, "Lost soul", ""); // 100
	AppendItem( ThClassMnst, THING_DEMON, "Demon", ""); // 150
	AppendItem( ThClassMnst, THING_SPECTRE, "Spectre", ""); // 150
	AppendItem( ThClassMnst, THING_REVENANT, "Revenant", ""); // 300
	AppendItem( ThClassMnst, THING_CACODEMON, "Cacodemon", ""); // 400
	AppendItem( ThClassMnst, THING_PAINELEM, "Pain elemental", ""); // 400
	AppendItem( ThClassMnst, THING_KNIGHT, "Hell knight", ""); // 500
	AppendItem( ThClassMnst, THING_BARON, "Baron of Hell", ""); // 1000
	AppendItem( ThClassMnst, THING_ARACHNO, "Arachnotron", ""); // 500
	AppendItem( ThClassMnst, THING_MANCUBUS, "Mancubus", ""); // 600
	AppendItem( ThClassMnst, THING_ARCHVILE, "Arch-vile", ""); // 700
	AppendItem( ThClassMnst, THING_SPIDERBOSS, "Spiderdemon", ""); // 3000
	AppendItem( ThClassMnst, THING_CYBERDEMON, "Cyberdemon", ""); // 4000
//	AppendItem( ThClassMnst, THING_RESURRECTOR, "Mother demon", ""); // 5000, Doom 64
	AppendItem( ThClassMnst, THING_WOLF3DSS, "Wolfenstein SS", ""); // 50
	AppendItem( ThClassMnst, THING_KEEN, "Commander Keen", ""); // 100
	AppendItem( ThClassMisc, THING_BOSSBRAIN, "Romero's head", ""); // 250
	AppendItem( ThClassMisc, THING_BOSSSHOOT, "Monster spawner", "");
	AppendItem( ThClassMisc, THING_SPAWNSPOT, "Spawn spot", "");

	/* initialize weapons */
	AppendItem( ThClassWeap, THING_CHAINSAW, "Chainsaw", "");
	AppendItem( ThClassWeap, THING_SHOTGUN, "Shotgun", "");
	AppendItem( ThClassWeap, THING_COMBATGUN, "Super shotgun", "");
	AppendItem( ThClassWeap, THING_CHAINGUN, "Chaingun", "");
	AppendItem( ThClassWeap, THING_LAUNCHER, "Rocket launcher", "");
	AppendItem( ThClassWeap, THING_PLASMAGUN, "Plasma gun", "");
	AppendItem( ThClassWeap, THING_BFG9000, "BFG9000", "");
//	AppendItem( ThClassWeap, THING_64_LASER, "Unmaker", ""); // Doom 64

	/* initialize ammo */
	AppendItem( ThClassAmmo, THING_AMMOCLIP, "Clip", "");
	AppendItem( ThClassAmmo, THING_AMMOBOX, "Box of bullets", "");
	AppendItem( ThClassAmmo, THING_SHELLS, "4 shotgun shells", "");
	AppendItem( ThClassAmmo, THING_SHELLBOX, "Box of shotgun shells", "");
	AppendItem( ThClassAmmo, THING_ROCKET, "Rocket", "");
	AppendItem( ThClassAmmo, THING_ROCKETBOX, "Box of rockets", "");
	AppendItem( ThClassAmmo, THING_ENERGYCELL, "Energy cell", "Energy cell (Doom)");
	AppendItem( ThClassAmmo, THING_ENERGYPACK, "Energy cell pack", "");

	/* initialize health/armor */
	AppendItem( ThClassHlAr, THING_STIMPACK, "Stimpack", "");
	AppendItem( ThClassHlAr, THING_MEDIKIT, "Medikit", "");
	AppendItem( ThClassHlAr, THING_GREENARMOR, "Armor", "");
	AppendItem( ThClassHlAr, THING_BLUEARMOR, "Megaarmor", "");

	/* initialize powerups/items */
	AppendItem( ThClassItem, THING_ARMBONUS1, "Armor bonus", "");
	AppendItem( ThClassItem, THING_HLTBONUS1, "Health bonus", "");
	AppendItem( ThClassItem, THING_SOULSPHERE, "Supercharge", "");
	AppendItem( ThClassItem, THING_MEGASPHERE, "Megasphere", "");
	AppendItem( ThClassHlAr, THING_BACKPACK, "Backpack", "");
	AppendItem( ThClassItem, THING_BERSERK, "Berserk", "");
	AppendItem( ThClassItem, THING_COMPMAP, "Computer area map", "");
	AppendItem( ThClassItem, THING_INVULN, "Invulnerability", "");
	AppendItem( ThClassItem, THING_LITEAMP, "Light amplification visor", "");
	AppendItem( ThClassItem, THING_BLURSPHERE, "Partial invisibility", "");
	AppendItem( ThClassHlAr, THING_RADSUIT, "Radiation shielding suit", "");
//	AppendItem( ThClassItem, THING_ARTIFACT1, "Orange demon key", "Demon Key"); // Doom 64
//	AppendItem( ThClassItem, THING_ARTIFACT2, "Cyan demon key", "Demon Key"); // Doom 64
//	AppendItem( ThClassItem, THING_ARTIFACT3, "Purple demon key", "Demon Key"); // Doom 64

	/* initialize keys */
	AppendItem( ThClassKeys, THING_BLUECARD, "Blue keycard", "");
	AppendItem( ThClassKeys, THING_BLUESKULLKEY, "Blue skull key", "");
	AppendItem( ThClassKeys, THING_REDCARD, "Red keycard", "");
	AppendItem( ThClassKeys, THING_REDSKULLKEY, "Red skull key", "");
	AppendItem( ThClassKeys, THING_YELLOWCARD, "Yellow keycard", "");
	AppendItem( ThClassKeys, THING_YELLOWSKULLKEY, "Yellow skull key", "");

	/* initialize obstacles */
	AppendItem( ThClassObst, THING_BARREL, "Exploding barrel", "Barrel");
	AppendItem( ThClassObst, THING_FLAMECAN, "Burning barrel", "Barrel");
	AppendItem( ThClassObst, THING_GREYTREE, "Burnt tree", NULL);
	AppendItem( ThClassObst, THING_CANDELABRA, "Candelabra", NULL);
	AppendItem( ThClassObst, THING_EYEINSYMBOL, "Evil eye", NULL);
	AppendItem( ThClassObst, THING_HEADSKEWER, "Five skulls \"shish kebab\"", NULL);
	AppendItem( ThClassObst, THING_SKULLSINFLAMES, "Floating skull", NULL);
	AppendItem( ThClassObst, THING_LAMP, "Floor lamp", NULL);
	AppendItem( ThClassObst, THING_HANGINGLEG, "Hanging leg", NULL);
	AppendItem( ThClassObst, THING_HANGINGTORSO, "Hanging pair of legs", NULL);
	AppendItem( ThClassObst, THING_HANGINGTORSO4, "Hanging torso, brain removed", NULL);
	AppendItem( ThClassObst, THING_HANGINGLOOKDN, "Hanging torso, looking down", NULL);
	AppendItem( ThClassObst, THING_HANGINGLOOKUP, "Hanging torso, looking up", NULL);
	AppendItem( ThClassObst, THING_HANGINGTORSO3, "Hanging torso, open skull", NULL);
	AppendItem( ThClassObst, THING_HANGINGARMSOUT, "Hanging victim, arms out", NULL);
	AppendItem( ThClassObst, THING_HANGINGNOGUTS2, "Hanging victim, guts and brain removed", NULL);
	AppendItem( ThClassObst, THING_HANGINGNOGUTS, "Hanging victim, guts removed", NULL);
	AppendItem( ThClassObst, THING_HANGINGONELEG, "Hanging victim, one-legged", NULL);
	AppendItem( ThClassObst, THING_HANGINGSWAYING, "Hanging victim, twitching", NULL);
	AppendItem( ThClassObst, THING_IMPALEDBODY, "Impaled human", NULL);
	AppendItem( ThClassObst, THING_BROWNTREE, "Large brown tree", NULL);
	AppendItem( ThClassObst, THING_PILEOFSKULLS, "Pile of skulls and candles", NULL);
	AppendItem( ThClassObst, THING_SBLUETORCH, "Short blue firestick", NULL);
	AppendItem( ThClassObst, THING_SGREENTORCH, "Short green firestick", NULL);
	AppendItem( ThClassObst, THING_SGREENPILLAR, "Short green pillar", NULL);
	AppendItem( ThClassObst, THING_PILLARHEART, "Short green pillar with beating heart", NULL);
	AppendItem( ThClassObst, THING_SREDTORCH, "Short red firestick", NULL);
	AppendItem( ThClassObst, THING_SREDPILLAR, "Short red pillar", NULL);
	AppendItem( ThClassObst, THING_PILLARSKULL, "Short red pillar with skull", NULL);
	AppendItem( ThClassObst, THING_SHORTLAMP, "Short techno floor lamp", NULL);
	AppendItem( ThClassObst, THING_SKULLTOPPOLE, "Skull on a pole", NULL);
	AppendItem( ThClassObst, THING_BROWNSTUB, "Brown stump", NULL);
	AppendItem( ThClassObst, THING_TBLUETORCH, "Tall blue firestick", NULL);
	AppendItem( ThClassObst, THING_TGREENTORCH, "Tall green firestick", NULL);
	AppendItem( ThClassObst, THING_TGREENPILLAR, "Tall green pillar", NULL);
	AppendItem( ThClassObst, THING_TREDTORCH, "Tall red firestick", NULL);
	AppendItem( ThClassObst, THING_TREDPILLAR, "Tall red pillar", NULL);
	AppendItem( ThClassObst, THING_TALLLAMP, "Tall techno floor lamp", NULL);
	AppendItem( ThClassObst, THING_TECHCOLUMN, "Tall techno column", NULL);
	AppendItem( ThClassObst, THING_IMPALEDBODY2, "Twitching impaled human", NULL);

	/* initialize decorations */
	AppendItem( ThClassDeco, THING_BONES, "Bloody mess", NULL);
	AppendItem( ThClassDeco, THING_BONES2, "Bloody mess 2", NULL);
	AppendItem( ThClassDeco, THING_CANDLE, "Candle", NULL);
	AppendItem( ThClassDeco, THING_DEADCACODEMON, "Dead cacodemon", NULL);
	AppendItem( ThClassDeco, THING_DEADDEMON, "Dead demon", NULL);
	AppendItem( ThClassDeco, THING_DEADHUMAN, "Dead former human", NULL);
	AppendItem( ThClassDeco, THING_DEADSERGEANT, "Dead former sergeant", NULL);
	AppendItem( ThClassDeco, THING_DEADIMP, "Dead imp", NULL);
	AppendItem( ThClassDeco, THING_DEADLOSTSOUL, "Dead lost soul (invisible)", NULL);
	AppendItem( ThClassDeco, THING_DEADPLAYER, "Dead player", NULL);
	AppendItem( ThClassDeco, THING_HANGINGLEG2, "Hanging leg", NULL);
	AppendItem( ThClassDeco, THING_HANGINGTORSO2, "Hanging pair of legs", NULL);
	AppendItem( ThClassDeco, THING_HANGINGARMSOUT2, "Hanging victim, arms out", NULL);
	AppendItem( ThClassDeco, THING_HANGINGONELEG2, "Hanging victim, one-legged", NULL);
	AppendItem( ThClassDeco, THING_HANGINGSWAYING2, "Hanging victim, twitching", NULL);
	AppendItem( ThClassDeco, THING_POOLOFBLOOD2, "Pool of blood", NULL);
	AppendItem( ThClassDeco, THING_POOLOFBLOOD3, "Pool of blood", NULL);
	AppendItem( ThClassDeco, THING_POOLOFBLOOD, "Pool of blood and flesh", NULL);
	AppendItem( ThClassDeco, THING_POOLOFBRAINS, "Pool of brains", NULL);

	/* initialize miscellaneous */
	AppendItem( ThClassMisc, THING_PLAYER1, "Player 1 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER2, "Player 2 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER3, "Player 3 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER4, "Player 4 start", "Player");
	AppendItem( ThClassMisc, THING_DEATHMATCH, "Deathmatch start", "");
	AppendItem( ThClassMisc, THING_TELEPORT, "Teleport landing", "Teleporter");
}

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
