/*
	DooM/HereTic/HeXen/StriFe INFO.c processors, by Frans P. de Vries.

Derived from:

	DooM MaP StaTistics, by Frans P. de Vries.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	LEVELS.H - Level data definitions.
*/

#ifndef LEVELS_H
#define LEVELS_H

#include "common.h"
#include "wstructs.h"
#include "wads.h"


/*
	the global variables
*/
extern UBCINT NumThings;   /* number of things */
extern TPtr      Things;   /* things data */
extern UBCINT NumLineDefs; /* number of line defs */
extern LDPtr     LineDefs; /* line defs data */
extern UBCINT NumSideDefs; /* number of side defs */
extern SDPtr     SideDefs; /* side defs data */
extern BCLNG  TotVertexes; /* total number of vertexes */
extern BCLNG  NumVertexes; /* number of used vertexes */
extern VPtr      Vertexes; /* vertex data */
/* extern UBCINT NumSegs;     /* number of segments */
/* extern SEPtr     Segs;     /* list of segments */
/* extern UBCINT NumSSectors; /* number of subsectors */
/* extern SSPtr     SSectors; /* list of subsectors */
extern UBCINT NumSectors;  /* number of sectors */
extern SPtr      Sectors;  /* sectors data */

/*
	the global function prototypes
*/
void ReadLevelData( WadPtr, char *);
void ForgetLevelData( void);
Bool SearchLevels( WadPtr, char *, UBCINT);
Bool FindThingInLevel( WadPtr, UBCINT);

#endif /* LEVELS_H */

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
