// Emacs style mode select   -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// $Id: info.c,v 1.44 1998/05/12 12:46:36 phares Exp $
//
// Copyright (C) 1993-1996 by id Software, Inc.
//
// This source is available for distribution and/or modification
// only under the terms of the DOOM Source Code License as
// published by id Software. All rights reserved.
//
// The source is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// FITNESS FOR A PARTICULAR PURPOSE. See the DOOM Source Code License
// for more details.
//
//
// DESCRIPTION:
//  Thing frame/state LUT,
//  generated by multigen utilitiy.
//  This one is the original DOOM version, preserved.
//  BOOM changes include commenting and addition of predefined lumps
//  for providing things that aren't in the IWAD without sending a
//  separate must-use wad file around with the EXE.
//
//-----------------------------------------------------------------------------

static const char
rcsid[] = "$Id: info.c,v 1.44 1998/05/12 12:46:36 phares Exp $";

#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "doomdef.h"
#include "sounds.h"
#include "m_fixed.h"
#include "p_mobj.h"
#include "w_wad.h"

#ifdef __GNUG__
#pragma implementation "info.h"
#endif
#include "info.h"


//XMAS:Weapons frame changes/additions, etc. Deh type stuff; however, why
//bother including a patch and complicating things...


// ********************************************************************
// Sprite names
// ********************************************************************
// This is the list of sprite 4-character prefixes.  They are searched
// through, with a NULL entry terminating the list.  In DOOM originally
// this NULL entry was missing, and coincidentally the next thing in
// memory was the dummy state_t[] entry that started with zero bytes.
// killough 1/17/98: add an explicit NULL entry.
// NUMSPRITES is an enum from info.h where all these are listed
// as SPR_xxxx

char *sprnames[NUMSPRITES+1] = {
  "TROO","SHTG","PUNG","PISG","PISF","SHTF","SHT2","CHGG","CHGF","MISG",
  "MISF","SAWG","PLSG","PLSF","BFGG","BFGF","BLUD","PUFF","BAL1","BAL2",
  "PLSS","PLSE","MISL","BFS1","BFE1","BFE2","TFOG","IFOG","PLAY","POSS",
  "SPOS","VILE","FIRE","FATB","FBXP","SKEL","MANF","FATT","CPOS","SARG",
  "HEAD","BAL7","BOSS","BOS2","SKUL","SPID","BSPI","APLS","APBX","CYBR",
  "PAIN","SSWV","KEEN","BBRN","BOSF","ARM1","ARM2","BAR1","BEXP","FCAN",
  "BON1","BON2","BKEY","RKEY","YKEY","BSKU","RSKU","YSKU","STIM","MEDI",
  "SOUL","PINV","PSTR","PINS","MEGA","SUIT","PMAP","PVIS","CLIP","AMMO",
  "ROCK","BROK","CELL","CELP","SHEL","SBOX","BPAK","BFUG","MGUN","CSAW",
  "LAUN","PLAS","SHOT","SGN2","COLU","SMT2","GOR1","POL2","POL5","POL4",
  "POL3","POL1","POL6","GOR2","GOR3","GOR4","GOR5","SMIT","COL1","COL2",
  "COL3","COL4","CAND","CBRA","COL6","TRE1","TRE2","ELEC","CEYE","FSKU",
  "COL5","TBLU","TGRN","TRED","SMBT","SMGT","SMRT","HDB1","HDB2","HDB3",
  "HDB4","HDB5","HDB6","POB1","POB2","BRS1","TLMP","TLP2",
  "TNT1", // invisible sprite                                 phares 3/9/98
  NULL
};

// ********************************************************************
// Function addresses or Code Pointers
// ********************************************************************
// These function addresses are the Code Pointers that have been
// modified for years by Dehacked enthusiasts.  The new BEX format
// allows more extensive changes (see d_deh.c)

// Doesn't work with g++, needs actionf_p1
void A_Light0();
void A_WeaponReady();
void A_Lower();
void A_Raise();
void A_Punch();
void A_ReFire();
void A_FirePistol();
void A_Light1();
void A_FireShotgun();
void A_Light2();
void A_FireShotgun2();
void A_CheckReload();
void A_OpenShotgun2();
void A_LoadShotgun2();
void A_CloseShotgun2();
void A_FireCGun();
void A_GunFlash();
void A_FireMissile();
void A_Saw();
void A_FirePlasma();
void A_BFGsound();
void A_FireBFG();
void A_BFGSpray();
void A_Explode();
void A_Pain();
void A_PlayerScream();
void A_Fall();
void A_XScream();
void A_Look();
void A_Chase();
void A_FaceTarget();
void A_PosAttack();
void A_Scream();
void A_SPosAttack();
void A_VileChase();
void A_VileStart();
void A_VileTarget();
void A_VileAttack();
void A_StartFire();
void A_Fire();
void A_FireCrackle();
void A_Tracer();
void A_SkelWhoosh();
void A_SkelFist();
void A_SkelMissile();
void A_FatRaise();
void A_FatAttack1();
void A_FatAttack2();
void A_FatAttack3();
void A_BossDeath();
void A_CPosAttack();
void A_CPosRefire();
void A_TroopAttack();
void A_SargAttack();
void A_HeadAttack();
void A_BruisAttack();
void A_SkullAttack();
void A_Metal();
void A_SpidRefire();
void A_BabyMetal();
void A_BspiAttack();
void A_Hoof();
void A_CyberAttack();
void A_PainAttack();
void A_PainDie();
void A_KeenDie();
void A_BrainPain();
void A_BrainScream();
void A_BrainDie();
void A_BrainAwake();
void A_BrainSpit();
void A_SpawnSound();
void A_SpawnFly();
void A_BrainExplode();

// ********************************************************************
// State or "frame" information
// ********************************************************************
// Each of the states, otherwise known as "frames", is outlined
// here.  The data in each element of the array is the way it is
// initialized, with sprite names identified by their enumerator
// value such as SPR_SHTG.  These correlate to the above sprite
// array so don't change them around unless you understand what
// you're doing.
//
// The commented name beginning with S_ at the end of each line
// is there to help figure out where the next-frame pointer is
// pointing.  These are also additionally identified in info.h
// as enumerated values.  From a change-and-recompile point of
// view this is fairly workable, but it adds a lot to the effort
// when trying to change things externally.  See also the d_deh.c
// parts where frame rewiring is done for more details and the
// extended way a BEX file can handle this.

state_t states[NUMSTATES] = {
  {SPR_TROO,0,-1,{NULL},S_NULL,0,0},  // S_NULL
  {SPR_SHTG,4,0,{A_Light0},S_NULL,0,0}, // S_LIGHTDONE
  {SPR_PUNG,0,1,{A_WeaponReady},S_PUNCH,0,0}, // S_PUNCH
  {SPR_PUNG,0,1,{A_Lower},S_PUNCHDOWN,0,0}, // S_PUNCHDOWN
  {SPR_PUNG,0,1,{A_Raise},S_PUNCHUP,0,0}, // S_PUNCHUP
  {SPR_PUNG,1,4,{NULL},S_PUNCH2,0,0},   // S_PUNCH1
  {SPR_PUNG,2,4,{A_Punch},S_PUNCH3,0,0},  // S_PUNCH2
  {SPR_PUNG,3,5,{NULL},S_PUNCH4,0,0},   // S_PUNCH3
  {SPR_PUNG,2,4,{NULL},S_PUNCH5,0,0},   // S_PUNCH4
  {SPR_PUNG,1,5,{A_ReFire},S_PUNCH,0,0},  // S_PUNCH5
  {SPR_PISG,0,1,{A_WeaponReady},S_PISTOL,0,0},// S_PISTOL
  {SPR_PISG,0,1,{A_Lower},S_PISTOLDOWN,0,0},  // S_PISTOLDOWN
  {SPR_PISG,0,1,{A_Raise},S_PISTOLUP,0,0},  // S_PISTOLUP
  {SPR_PISG,0,4,{NULL},S_PISTOL2,0,0},  // S_PISTOL1
  {SPR_PISG,1,6,{A_FirePistol},S_PISTOL3,0,0},// S_PISTOL2
  {SPR_PISG,1,0,{NULL},S_PISTOL4,0,0},  // S_PISTOL3
  {SPR_PISG,1,5,{A_ReFire},S_PISTOL,0,0}, // S_PISTOL4
  {SPR_PISF,32768,7,{A_Light1},S_LIGHTDONE,0,0},  // S_PISTOLFLASH
  {SPR_SHTG,0,1,{A_WeaponReady},S_SGUN,0,0},  // S_SGUN
  {SPR_SHTG,0,1,{A_Lower},S_SGUNDOWN,0,0},  // S_SGUNDOWN
  {SPR_SHTG,0,1,{A_Raise},S_SGUNUP,0,0},  // S_SGUNUP
  {SPR_SHTG,0,3,{NULL},S_SGUN2,0,0},  // S_SGUN1
  {SPR_SHTG,1,4,{A_FireShotgun},S_SGUN3,0,0}, // S_SGUN2
  {SPR_SHTG,2,3,{NULL},S_SGUN4,0,0},  // S_SGUN3
  {SPR_SHTG,3,5,{A_OpenShotgun2},S_SGUN5,0,0},  // S_SGUN4
  {SPR_SHTG,4,10,{A_LoadShotgun2},S_SGUN6,0,0},  // S_SGUN5
  {SPR_SHTG,3,3,{NULL},S_SGUN7,0,0},  // S_SGUN6
  {SPR_SHTG,0,3,{NULL},S_SGUN8,0,0},  // S_SGUN7
  {SPR_SHTG,0,3,{NULL},S_SGUN9,0,0},  // S_SGUN8
  {SPR_SHTG,0,7,{A_ReFire},S_SGUN,0,0}, // S_SGUN9
  {SPR_SHTF,32768,4,{A_Light1},S_SGUNFLASH2,0,0}, // S_SGUNFLASH1
  {SPR_SHTF,32769,3,{A_Light2},S_LIGHTDONE,0,0},  // S_SGUNFLASH2
  {SPR_SHT2,0,1,{A_WeaponReady},S_DSGUN,0,0}, // S_DSGUN
  {SPR_SHT2,0,1,{A_Lower},S_DSGUNDOWN,0,0}, // S_DSGUNDOWN
  {SPR_SHT2,0,1,{A_Raise},S_DSGUNUP,0,0}, // S_DSGUNUP
  {SPR_SHT2,0,3,{NULL},S_DSGUN2,0,0}, // S_DSGUN1
  {SPR_SHT2,1,4,{A_FireShotgun2},S_DSGUN3,0,0}, // S_DSGUN2
  {SPR_SHT2,2,4,{A_CheckReload},S_DSGUN4,0,0}, // S_DSGUN3
  {SPR_SHT2,3,7,{A_OpenShotgun2},S_DSGUN5,0,0},  // S_DSGUN4
  {SPR_SHT2,4,15,{A_LoadShotgun2},S_DSGUN6,0,0}, // S_DSGUN5
  {SPR_SHT2,3,5,{NULL},S_DSGUN7,0,0}, // S_DSGUN6
  {SPR_SHT2,0,4,{NULL},S_DSGUN8,0,0}, // S_DSGUN7
  {SPR_SHT2,0,4,{NULL},S_DSGUN9,0,0}, // S_DSGUN8
  {SPR_SHT2,0,0,{NULL},S_DSGUN10,0,0}, // S_DSGUN9
  {SPR_SHT2,0,7,{A_ReFire},S_DSGUN,0,0},  // S_DSGUN10
  {SPR_SHT2,1,7,{NULL},S_DSNR2,0,0},  // S_DSNR1
  {SPR_SHT2,0,3,{NULL},S_DSGUNDOWN,0,0},  // S_DSNR2
  {SPR_SHT2,32776,5,{A_Light1},S_DSGUNFLASH2,0,0},  // S_DSGUNFLASH1
  {SPR_SHT2,32777,4,{A_Light2},S_LIGHTDONE,0,0},  // S_DSGUNFLASH2
  {SPR_CHGG,0,1,{A_WeaponReady},S_CHAIN,0,0}, // S_CHAIN
  {SPR_CHGG,0,1,{A_Lower},S_CHAINDOWN,0,0}, // S_CHAINDOWN
  {SPR_CHGG,0,1,{A_Raise},S_CHAINUP,0,0}, // S_CHAINUP
  {SPR_CHGG,0,2,{A_FireCGun},S_CHAIN2,0,0}, // S_CHAIN1             CHANGED
  {SPR_CHGG,1,2,{A_FireCGun},S_CHAIN3,0,0}, // S_CHAIN2             CHANGED
  {SPR_CHGG,1,0,{A_ReFire},S_CHAIN,0,0},  // S_CHAIN3
  {SPR_CHGF,32768,5,{A_Light1},S_LIGHTDONE,0,0},  // S_CHAINFLASH1
  {SPR_CHGF,32769,5,{A_Light2},S_LIGHTDONE,0,0},  // S_CHAINFLASH2
  {SPR_MISG,0,1,{A_WeaponReady},S_MISSILE,0,0}, // S_MISSILE
  {SPR_MISG,0,1,{A_Lower},S_MISSILEDOWN,0,0}, // S_MISSILEDOWN
  {SPR_MISG,0,1,{A_Raise},S_MISSILEUP,0,0}, // S_MISSILEUP
  {SPR_MISG,1,8,{A_GunFlash},S_MISSILE2,0,0}, // S_MISSILE1
  {SPR_MISG,1,12,{A_FireMissile},S_MISSILE3,0,0}, // S_MISSILE2
  {SPR_MISG,1,0,{A_ReFire},S_MISSILE,0,0},  // S_MISSILE3
  {SPR_MISF,32768,3,{A_Light1},S_MISSILEFLASH2,0,0},  // S_MISSILEFLASH1
  {SPR_MISF,32769,4,{NULL},S_MISSILEFLASH3,0,0},  // S_MISSILEFLASH2
  {SPR_MISF,32770,4,{A_Light2},S_MISSILEFLASH4,0,0},  // S_MISSILEFLASH3
  {SPR_MISF,32771,4,{A_Light2},S_LIGHTDONE,0,0},  // S_MISSILEFLASH4
  {SPR_SAWG,2,4,{A_WeaponReady},S_SAWB,0,0},  // S_SAW
  {SPR_SAWG,3,4,{A_WeaponReady},S_SAW,0,0}, // S_SAWB
  {SPR_SAWG,2,1,{A_Lower},S_SAWDOWN,0,0}, // S_SAWDOWN
  {SPR_SAWG,2,1,{A_Raise},S_SAWUP,0,0}, // S_SAWUP
  {SPR_SAWG,0,4,{A_Saw},S_SAW2,0,0}, // S_SAW1
  {SPR_SAWG,1,4,{A_Saw},S_SAW3,0,0},  // S_SAW2
  {SPR_SAWG,1,0,{A_ReFire},S_SAW,0,0},  // S_SAW3
  {SPR_PLSG,0,1,{A_WeaponReady},S_PLASMA,0,0},  // S_PLASMA
  {SPR_PLSG,0,1,{A_Lower},S_PLASMADOWN,0,0},  // S_PLASMADOWN
  {SPR_PLSG,0,1,{A_Raise},S_PLASMAUP,0,0},  // S_PLASMAUP
  {SPR_PLSG,0,4,{A_FirePlasma},S_PLASMA2,0,0},  // S_PLASMA1        CHANGED
  {SPR_PLSG,1,2,{A_ReFire},S_PLASMA,0,0},  // S_PLASMA2             CHANGED
  {SPR_PLSF,32768,4,{A_Light1},S_LIGHTDONE,0,0},  // S_PLASMAFLASH1
  {SPR_PLSF,32769,4,{A_Light1},S_LIGHTDONE,0,0},  // S_PLASMAFLASH2
  {SPR_BFGG,0,1,{A_WeaponReady},S_BFG,0,0}, // S_BFG
  {SPR_BFGG,0,1,{A_Lower},S_BFGDOWN,0,0}, // S_BFGDOWN
  {SPR_BFGG,0,1,{A_Raise},S_BFGUP,0,0}, // S_BFGUP
  {SPR_BFGG,0,2,{A_BFGsound},S_BFG2,0,0},  // S_BFG1
  {SPR_BFGG,1,5,{A_FireBFG},S_BFG3,0,0},  // S_BFG2                CHANGED
  {SPR_BFGG,2,6,{NULL},S_BFG4,0,0}, // S_BFG3                      CHANGED
  {SPR_BFGG,1,5,{A_ReFire},S_BFG,0,0}, // S_BFG4
  {SPR_BFGF,32768,11,{A_Light1},S_BFGFLASH2,0,0}, // S_BFGFLASH1
  {SPR_BFGF,32769,6,{A_Light2},S_LIGHTDONE,0,0},  // S_BFGFLASH2
  {SPR_BLUD,2,8,{NULL},S_BLOOD2,0,0}, // S_BLOOD1
  {SPR_BLUD,1,8,{NULL},S_BLOOD3,0,0}, // S_BLOOD2
  {SPR_BLUD,0,8,{NULL},S_NULL,0,0}, // S_BLOOD3
  {SPR_PUFF,32768,4,{NULL},S_PUFF2,0,0},  // S_PUFF1
  {SPR_PUFF,1,4,{NULL},S_PUFF3,0,0},  // S_PUFF2
  {SPR_PUFF,2,4,{NULL},S_PUFF4,0,0},  // S_PUFF3
  {SPR_PUFF,3,4,{NULL},S_NULL,0,0}, // S_PUFF4
  {SPR_BAL1,32768,4,{NULL},S_TBALL2,0,0}, // S_TBALL1
  {SPR_BAL1,32769,4,{NULL},S_TBALL1,0,0}, // S_TBALL2
  {SPR_BAL1,32770,6,{NULL},S_TBALLX2,0,0},  // S_TBALLX1
  {SPR_BAL1,32771,6,{NULL},S_TBALLX3,0,0},  // S_TBALLX2
  {SPR_BAL1,32772,6,{NULL},S_NULL,0,0}, // S_TBALLX3
  {SPR_BAL2,32768,4,{NULL},S_RBALL2,0,0}, // S_RBALL1
  {SPR_BAL2,32769,4,{NULL},S_RBALL1,0,0}, // S_RBALL2
  {SPR_BAL2,32770,6,{NULL},S_RBALLX2,0,0},  // S_RBALLX1
  {SPR_BAL2,32771,6,{NULL},S_RBALLX3,0,0},  // S_RBALLX2
  {SPR_BAL2,32772,6,{NULL},S_NULL,0,0}, // S_RBALLX3
  {SPR_PLSS,32768,6,{NULL},S_PLASBALL2,0,0},  // S_PLASBALL
  {SPR_PLSS,32769,6,{NULL},S_PLASBALL,0,0}, // S_PLASBALL2
  {SPR_PLSE,32768,4,{NULL},S_PLASEXP2,0,0}, // S_PLASEXP
  {SPR_PLSE,32769,4,{NULL},S_PLASEXP3,0,0}, // S_PLASEXP2
  {SPR_PLSE,32770,4,{NULL},S_PLASEXP4,0,0}, // S_PLASEXP3
  {SPR_PLSE,32771,4,{NULL},S_PLASEXP5,0,0}, // S_PLASEXP4
  {SPR_PLSE,32772,4,{NULL},S_NULL,0,0}, // S_PLASEXP5
  {SPR_MISL,32768,1,{NULL},S_ROCKET,0,0}, // S_ROCKET
  {SPR_BFS1,32768,4,{NULL},S_BFGSHOT2,0,0}, // S_BFGSHOT
  {SPR_BFS1,32769,4,{NULL},S_BFGSHOT,0,0},  // S_BFGSHOT2
  {SPR_BFE1,32768,8,{NULL},S_BFGLAND2,0,0}, // S_BFGLAND
  {SPR_BFE1,32769,8,{NULL},S_BFGLAND3,0,0}, // S_BFGLAND2
  {SPR_BFE1,32770,8,{A_BFGSpray},S_BFGLAND4,0,0}, // S_BFGLAND3
  {SPR_BFE1,32771,8,{NULL},S_BFGLAND5,0,0}, // S_BFGLAND4
  {SPR_BFE1,32772,8,{NULL},S_BFGLAND6,0,0}, // S_BFGLAND5
  {SPR_BFE1,32773,8,{NULL},S_NULL,0,0}, // S_BFGLAND6
  {SPR_BFE2,32768,8,{NULL},S_BFGEXP2,0,0},  // S_BFGEXP
  {SPR_BFE2,32769,8,{NULL},S_BFGEXP3,0,0},  // S_BFGEXP2
  {SPR_BFE2,32770,8,{NULL},S_BFGEXP4,0,0},  // S_BFGEXP3
  {SPR_BFE2,32771,8,{NULL},S_NULL,0,0}, // S_BFGEXP4
  {SPR_MISL,32769,8,{A_Explode},S_EXPLODE2,0,0},  // S_EXPLODE1
  {SPR_MISL,32770,6,{NULL},S_EXPLODE3,0,0}, // S_EXPLODE2
  {SPR_MISL,32771,4,{NULL},S_NULL,0,0}, // S_EXPLODE3
  {SPR_TFOG,32768,6,{NULL},S_TFOG01,0,0}, // S_TFOG
  {SPR_TFOG,32769,6,{NULL},S_TFOG02,0,0}, // S_TFOG01
  {SPR_TFOG,32768,6,{NULL},S_TFOG2,0,0},  // S_TFOG02
  {SPR_TFOG,32769,6,{NULL},S_TFOG3,0,0},  // S_TFOG2
  {SPR_TFOG,32770,6,{NULL},S_TFOG4,0,0},  // S_TFOG3
  {SPR_TFOG,32771,6,{NULL},S_TFOG5,0,0},  // S_TFOG4
  {SPR_TFOG,32772,6,{NULL},S_TFOG6,0,0},  // S_TFOG5
  {SPR_TFOG,32773,6,{NULL},S_TFOG7,0,0},  // S_TFOG6
  {SPR_TFOG,32774,6,{NULL},S_TFOG8,0,0},  // S_TFOG7
  {SPR_TFOG,32775,6,{NULL},S_TFOG9,0,0},  // S_TFOG8
  {SPR_TFOG,32776,6,{NULL},S_TFOG10,0,0}, // S_TFOG9
  {SPR_TFOG,32777,6,{NULL},S_NULL,0,0}, // S_TFOG10
  {SPR_IFOG,32768,6,{NULL},S_IFOG01,0,0}, // S_IFOG
  {SPR_IFOG,32769,6,{NULL},S_IFOG02,0,0}, // S_IFOG01
  {SPR_IFOG,32768,6,{NULL},S_IFOG2,0,0},  // S_IFOG02
  {SPR_IFOG,32769,6,{NULL},S_IFOG3,0,0},  // S_IFOG2
  {SPR_IFOG,32770,6,{NULL},S_IFOG4,0,0},  // S_IFOG3
  {SPR_IFOG,32771,6,{NULL},S_IFOG5,0,0},  // S_IFOG4
  {SPR_IFOG,32772,6,{NULL},S_NULL,0,0}, // S_IFOG5
  {SPR_PLAY,0,-1,{NULL},S_NULL,0,0},  // S_PLAY
  {SPR_PLAY,0,4,{NULL},S_PLAY_RUN2,0,0},  // S_PLAY_RUN1
  {SPR_PLAY,1,4,{NULL},S_PLAY_RUN3,0,0},  // S_PLAY_RUN2
  {SPR_PLAY,2,4,{NULL},S_PLAY_RUN4,0,0},  // S_PLAY_RUN3
  {SPR_PLAY,3,4,{NULL},S_PLAY_RUN1,0,0},  // S_PLAY_RUN4
  {SPR_PLAY,4,12,{NULL},S_PLAY,0,0},  // S_PLAY_ATK1
  {SPR_PLAY,32773,6,{NULL},S_PLAY_ATK1,0,0},  // S_PLAY_ATK2
  {SPR_PLAY,6,4,{NULL},S_PLAY_PAIN2,0,0}, // S_PLAY_PAIN
  {SPR_PLAY,6,4,{A_Pain},S_PLAY,0,0}, // S_PLAY_PAIN2
  {SPR_PLAY,7,10,{NULL},S_PLAY_DIE2,0,0}, // S_PLAY_DIE1
  {SPR_PLAY,8,10,{A_PlayerScream},S_PLAY_DIE3,0,0}, // S_PLAY_DIE2
  {SPR_PLAY,9,10,{A_Fall},S_PLAY_DIE4,0,0}, // S_PLAY_DIE3
  {SPR_PLAY,10,10,{NULL},S_PLAY_DIE5,0,0},  // S_PLAY_DIE4
  {SPR_PLAY,11,10,{NULL},S_PLAY_DIE6,0,0},  // S_PLAY_DIE5
  {SPR_PLAY,12,10,{NULL},S_PLAY_DIE7,0,0},  // S_PLAY_DIE6
  {SPR_PLAY,13,-1,{NULL},S_NULL,0,0}, // S_PLAY_DIE7
  {SPR_PLAY,14,5,{NULL},S_PLAY_XDIE2,0,0},  // S_PLAY_XDIE1
  {SPR_PLAY,15,5,{A_XScream},S_PLAY_XDIE3,0,0}, // S_PLAY_XDIE2
  {SPR_PLAY,16,5,{A_Fall},S_PLAY_XDIE4,0,0},  // S_PLAY_XDIE3
  {SPR_PLAY,17,5,{NULL},S_PLAY_XDIE5,0,0},  // S_PLAY_XDIE4
  {SPR_PLAY,18,5,{NULL},S_PLAY_XDIE6,0,0},  // S_PLAY_XDIE5
  {SPR_PLAY,19,5,{NULL},S_PLAY_XDIE7,0,0},  // S_PLAY_XDIE6
  {SPR_PLAY,20,5,{NULL},S_PLAY_XDIE8,0,0},  // S_PLAY_XDIE7
  {SPR_PLAY,21,5,{NULL},S_PLAY_XDIE9,0,0},  // S_PLAY_XDIE8
  {SPR_PLAY,22,-1,{NULL},S_NULL,0,0}, // S_PLAY_XDIE9
  {SPR_POSS,0,10,{A_Look},S_POSS_STND2,0,0},  // S_POSS_STND
  {SPR_POSS,1,10,{A_Look},S_POSS_STND,0,0}, // S_POSS_STND2
  {SPR_POSS,0,4,{A_Chase},S_POSS_RUN2,0,0}, // S_POSS_RUN1
  {SPR_POSS,0,4,{A_Chase},S_POSS_RUN3,0,0}, // S_POSS_RUN2
  {SPR_POSS,1,4,{A_Chase},S_POSS_RUN4,0,0}, // S_POSS_RUN3
  {SPR_POSS,1,4,{A_Chase},S_POSS_RUN5,0,0}, // S_POSS_RUN4
  {SPR_POSS,2,4,{A_Chase},S_POSS_RUN6,0,0}, // S_POSS_RUN5
  {SPR_POSS,2,4,{A_Chase},S_POSS_RUN7,0,0}, // S_POSS_RUN6
  {SPR_POSS,3,4,{A_Chase},S_POSS_RUN8,0,0}, // S_POSS_RUN7
  {SPR_POSS,3,4,{A_Chase},S_POSS_RUN1,0,0}, // S_POSS_RUN8
  {SPR_POSS,4,10,{A_FaceTarget},S_POSS_ATK2,0,0}, // S_POSS_ATK1
  {SPR_POSS,5,8,{A_PosAttack},S_POSS_ATK3,0,0}, // S_POSS_ATK2
  {SPR_POSS,4,8,{NULL},S_POSS_RUN1,0,0},  // S_POSS_ATK3
  {SPR_POSS,6,3,{NULL},S_POSS_PAIN2,0,0}, // S_POSS_PAIN
  {SPR_POSS,6,3,{A_Pain},S_POSS_RUN1,0,0},  // S_POSS_PAIN2
  {SPR_POSS,7,5,{NULL},S_POSS_DIE2,0,0},  // S_POSS_DIE1
  {SPR_POSS,8,5,{A_Scream},S_POSS_DIE3,0,0},  // S_POSS_DIE2
  {SPR_POSS,9,5,{A_Fall},S_POSS_DIE4,0,0},  // S_POSS_DIE3
  {SPR_POSS,10,5,{NULL},S_POSS_DIE5,0,0}, // S_POSS_DIE4
  {SPR_POSS,11,-1,{NULL},S_NULL,0,0}, // S_POSS_DIE5
  {SPR_POSS,12,5,{NULL},S_POSS_XDIE2,0,0},  // S_POSS_XDIE1
  {SPR_POSS,13,5,{A_XScream},S_POSS_XDIE3,0,0}, // S_POSS_XDIE2
  {SPR_POSS,14,5,{A_Fall},S_POSS_XDIE4,0,0},  // S_POSS_XDIE3
  {SPR_POSS,15,5,{NULL},S_POSS_XDIE5,0,0},  // S_POSS_XDIE4
  {SPR_POSS,16,5,{NULL},S_POSS_XDIE6,0,0},  // S_POSS_XDIE5
  {SPR_POSS,17,5,{NULL},S_POSS_XDIE7,0,0},  // S_POSS_XDIE6
  {SPR_POSS,18,5,{NULL},S_POSS_XDIE8,0,0},  // S_POSS_XDIE7
  {SPR_POSS,19,5,{NULL},S_POSS_XDIE9,0,0},  // S_POSS_XDIE8
  {SPR_POSS,20,-1,{NULL},S_NULL,0,0}, // S_POSS_XDIE9
  {SPR_POSS,10,5,{NULL},S_POSS_RAISE2,0,0}, // S_POSS_RAISE1
  {SPR_POSS,9,5,{NULL},S_POSS_RAISE3,0,0},  // S_POSS_RAISE2
  {SPR_POSS,8,5,{NULL},S_POSS_RAISE4,0,0},  // S_POSS_RAISE3
  {SPR_POSS,7,5,{NULL},S_POSS_RUN1,0,0},  // S_POSS_RAISE4
  {SPR_SPOS,0,10,{A_Look},S_SPOS_STND2,0,0},  // S_SPOS_STND
  {SPR_SPOS,1,10,{A_Look},S_SPOS_STND,0,0}, // S_SPOS_STND2
  {SPR_SPOS,0,3,{A_Chase},S_SPOS_RUN2,0,0}, // S_SPOS_RUN1
  {SPR_SPOS,0,3,{A_Chase},S_SPOS_RUN3,0,0}, // S_SPOS_RUN2
  {SPR_SPOS,1,3,{A_Chase},S_SPOS_RUN4,0,0}, // S_SPOS_RUN3
  {SPR_SPOS,1,3,{A_Chase},S_SPOS_RUN5,0,0}, // S_SPOS_RUN4
  {SPR_SPOS,2,3,{A_Chase},S_SPOS_RUN6,0,0}, // S_SPOS_RUN5
  {SPR_SPOS,2,3,{A_Chase},S_SPOS_RUN7,0,0}, // S_SPOS_RUN6
  {SPR_SPOS,3,3,{A_Chase},S_SPOS_RUN8,0,0}, // S_SPOS_RUN7
  {SPR_SPOS,3,3,{A_Chase},S_SPOS_RUN1,0,0}, // S_SPOS_RUN8
  {SPR_SPOS,4,10,{A_FaceTarget},S_SPOS_ATK2,0,0}, // S_SPOS_ATK1
  {SPR_SPOS,32773,10,{A_SPosAttack},S_SPOS_ATK3,0,0}, // S_SPOS_ATK2
  {SPR_SPOS,4,10,{NULL},S_SPOS_RUN1,0,0}, // S_SPOS_ATK3
  {SPR_SPOS,6,3,{NULL},S_SPOS_PAIN2,0,0}, // S_SPOS_PAIN
  {SPR_SPOS,6,3,{A_Pain},S_SPOS_RUN1,0,0},  // S_SPOS_PAIN2
  {SPR_SPOS,7,5,{NULL},S_SPOS_DIE2,0,0},  // S_SPOS_DIE1
  {SPR_SPOS,8,5,{A_Scream},S_SPOS_DIE3,0,0},  // S_SPOS_DIE2
  {SPR_SPOS,9,5,{A_Fall},S_SPOS_DIE4,0,0},  // S_SPOS_DIE3
  {SPR_SPOS,10,5,{NULL},S_SPOS_DIE5,0,0}, // S_SPOS_DIE4
  {SPR_SPOS,11,-1,{NULL},S_NULL,0,0}, // S_SPOS_DIE5
  {SPR_SPOS,12,5,{NULL},S_SPOS_XDIE2,0,0},  // S_SPOS_XDIE1
  {SPR_SPOS,13,5,{A_XScream},S_SPOS_XDIE3,0,0}, // S_SPOS_XDIE2
  {SPR_SPOS,14,5,{A_Fall},S_SPOS_XDIE4,0,0},  // S_SPOS_XDIE3
  {SPR_SPOS,15,5,{NULL},S_SPOS_XDIE5,0,0},  // S_SPOS_XDIE4
  {SPR_SPOS,16,5,{NULL},S_SPOS_XDIE6,0,0},  // S_SPOS_XDIE5
  {SPR_SPOS,17,5,{NULL},S_SPOS_XDIE7,0,0},  // S_SPOS_XDIE6
  {SPR_SPOS,18,5,{NULL},S_SPOS_XDIE8,0,0},  // S_SPOS_XDIE7
  {SPR_SPOS,19,5,{NULL},S_SPOS_XDIE9,0,0},  // S_SPOS_XDIE8
  {SPR_SPOS,20,-1,{NULL},S_NULL,0,0}, // S_SPOS_XDIE9
  {SPR_SPOS,11,5,{NULL},S_SPOS_RAISE2,0,0}, // S_SPOS_RAISE1
  {SPR_SPOS,10,5,{NULL},S_SPOS_RAISE3,0,0}, // S_SPOS_RAISE2
  {SPR_SPOS,9,5,{NULL},S_SPOS_RAISE4,0,0},  // S_SPOS_RAISE3
  {SPR_SPOS,8,5,{NULL},S_SPOS_RAISE5,0,0},  // S_SPOS_RAISE4
  {SPR_SPOS,7,5,{NULL},S_SPOS_RUN1,0,0},  // S_SPOS_RAISE5
  {SPR_VILE,0,10,{A_Look},S_VILE_STND2,0,0},  // S_VILE_STND
  {SPR_VILE,1,10,{A_Look},S_VILE_STND,0,0}, // S_VILE_STND2
  {SPR_VILE,0,2,{A_VileChase},S_VILE_RUN2,0,0}, // S_VILE_RUN1
  {SPR_VILE,0,2,{A_VileChase},S_VILE_RUN3,0,0}, // S_VILE_RUN2
  {SPR_VILE,1,2,{A_VileChase},S_VILE_RUN4,0,0}, // S_VILE_RUN3
  {SPR_VILE,1,2,{A_VileChase},S_VILE_RUN5,0,0}, // S_VILE_RUN4
  {SPR_VILE,2,2,{A_VileChase},S_VILE_RUN6,0,0}, // S_VILE_RUN5
  {SPR_VILE,2,2,{A_VileChase},S_VILE_RUN7,0,0}, // S_VILE_RUN6
  {SPR_VILE,3,2,{A_VileChase},S_VILE_RUN8,0,0}, // S_VILE_RUN7
  {SPR_VILE,3,2,{A_VileChase},S_VILE_RUN9,0,0}, // S_VILE_RUN8
  {SPR_VILE,4,2,{A_VileChase},S_VILE_RUN10,0,0},  // S_VILE_RUN9
  {SPR_VILE,4,2,{A_VileChase},S_VILE_RUN11,0,0},  // S_VILE_RUN10
  {SPR_VILE,5,2,{A_VileChase},S_VILE_RUN12,0,0},  // S_VILE_RUN11
  {SPR_VILE,5,2,{A_VileChase},S_VILE_RUN1,0,0}, // S_VILE_RUN12
  {SPR_VILE,32774,0,{A_VileStart},S_VILE_ATK2,0,0}, // S_VILE_ATK1
  {SPR_VILE,32774,10,{A_FaceTarget},S_VILE_ATK3,0,0}, // S_VILE_ATK2
  {SPR_VILE,32775,8,{A_VileTarget},S_VILE_ATK4,0,0},  // S_VILE_ATK3
  {SPR_VILE,32776,8,{A_FaceTarget},S_VILE_ATK5,0,0},  // S_VILE_ATK4
  {SPR_VILE,32777,8,{A_FaceTarget},S_VILE_ATK6,0,0},  // S_VILE_ATK5
  {SPR_VILE,32778,8,{A_FaceTarget},S_VILE_ATK7,0,0},  // S_VILE_ATK6
  {SPR_VILE,32779,8,{A_FaceTarget},S_VILE_ATK8,0,0},  // S_VILE_ATK7
  {SPR_VILE,32780,8,{A_FaceTarget},S_VILE_ATK9,0,0},  // S_VILE_ATK8
  {SPR_VILE,32781,8,{A_FaceTarget},S_VILE_ATK10,0,0}, // S_VILE_ATK9
  {SPR_VILE,32782,8,{A_VileAttack},S_VILE_ATK11,0,0}, // S_VILE_ATK10
  {SPR_VILE,32783,20,{NULL},S_VILE_RUN1,0,0}, // S_VILE_ATK11
  {SPR_VILE,32794,10,{NULL},S_VILE_HEAL2,0,0},  // S_VILE_HEAL1
  {SPR_VILE,32795,10,{NULL},S_VILE_HEAL3,0,0},  // S_VILE_HEAL2
  {SPR_VILE,32796,10,{NULL},S_VILE_RUN1,0,0}, // S_VILE_HEAL3
  {SPR_VILE,16,5,{NULL},S_VILE_PAIN2,0,0},  // S_VILE_PAIN
  {SPR_VILE,16,5,{A_Pain},S_VILE_RUN1,0,0}, // S_VILE_PAIN2
  {SPR_VILE,16,7,{NULL},S_VILE_DIE2,0,0}, // S_VILE_DIE1
  {SPR_VILE,17,7,{A_Scream},S_VILE_DIE3,0,0},  // S_VILE_DIE2
  {SPR_VILE,18,7,{A_Fall},S_VILE_DIE4,0,0}, // S_VILE_DIE3
  {SPR_VILE,19,7,{NULL},S_VILE_DIE5,0,0}, // S_VILE_DIE4
  {SPR_VILE,20,7,{NULL},S_VILE_DIE6,0,0}, // S_VILE_DIE5
  {SPR_VILE,21,7,{NULL},S_VILE_DIE7,0,0}, // S_VILE_DIE6
  {SPR_VILE,22,7,{NULL},S_VILE_DIE8,0,0}, // S_VILE_DIE7
  {SPR_VILE,23,5,{NULL},S_VILE_DIE9,0,0}, // S_VILE_DIE8
  {SPR_VILE,24,5,{NULL},S_VILE_DIE10,0,0},  // S_VILE_DIE9
  {SPR_VILE,25,-1,{NULL},S_NULL,0,0}, // S_VILE_DIE10
  {SPR_FIRE,32768,2,{A_StartFire},S_FIRE2,0,0}, // S_FIRE1
  {SPR_FIRE,32769,2,{A_Fire},S_FIRE3,0,0},  // S_FIRE2
  {SPR_FIRE,32768,2,{A_Fire},S_FIRE4,0,0},  // S_FIRE3
  {SPR_FIRE,32769,2,{A_Fire},S_FIRE5,0,0},  // S_FIRE4
  {SPR_FIRE,32770,2,{A_FireCrackle},S_FIRE6,0,0}, // S_FIRE5
  {SPR_FIRE,32769,2,{A_Fire},S_FIRE7,0,0},  // S_FIRE6
  {SPR_FIRE,32770,2,{A_Fire},S_FIRE8,0,0},  // S_FIRE7
  {SPR_FIRE,32769,2,{A_Fire},S_FIRE9,0,0},  // S_FIRE8
  {SPR_FIRE,32770,2,{A_Fire},S_FIRE10,0,0}, // S_FIRE9
  {SPR_FIRE,32771,2,{A_Fire},S_FIRE11,0,0}, // S_FIRE10
  {SPR_FIRE,32770,2,{A_Fire},S_FIRE12,0,0}, // S_FIRE11
  {SPR_FIRE,32771,2,{A_Fire},S_FIRE13,0,0}, // S_FIRE12
  {SPR_FIRE,32770,2,{A_Fire},S_FIRE14,0,0}, // S_FIRE13
  {SPR_FIRE,32771,2,{A_Fire},S_FIRE15,0,0}, // S_FIRE14
  {SPR_FIRE,32772,2,{A_Fire},S_FIRE16,0,0}, // S_FIRE15
  {SPR_FIRE,32771,2,{A_Fire},S_FIRE17,0,0}, // S_FIRE16
  {SPR_FIRE,32772,2,{A_Fire},S_FIRE18,0,0}, // S_FIRE17
  {SPR_FIRE,32771,2,{A_Fire},S_FIRE19,0,0}, // S_FIRE18
  {SPR_FIRE,32772,2,{A_FireCrackle},S_FIRE20,0,0},  // S_FIRE19
  {SPR_FIRE,32773,2,{A_Fire},S_FIRE21,0,0}, // S_FIRE20
  {SPR_FIRE,32772,2,{A_Fire},S_FIRE22,0,0}, // S_FIRE21
  {SPR_FIRE,32773,2,{A_Fire},S_FIRE23,0,0}, // S_FIRE22
  {SPR_FIRE,32772,2,{A_Fire},S_FIRE24,0,0}, // S_FIRE23
  {SPR_FIRE,32773,2,{A_Fire},S_FIRE25,0,0}, // S_FIRE24
  {SPR_FIRE,32774,2,{A_Fire},S_FIRE26,0,0}, // S_FIRE25
  {SPR_FIRE,32775,2,{A_Fire},S_FIRE27,0,0}, // S_FIRE26
  {SPR_FIRE,32774,2,{A_Fire},S_FIRE28,0,0}, // S_FIRE27
  {SPR_FIRE,32775,2,{A_Fire},S_FIRE29,0,0}, // S_FIRE28
  {SPR_FIRE,32774,2,{A_Fire},S_FIRE30,0,0}, // S_FIRE29
  {SPR_FIRE,32775,2,{A_Fire},S_NULL,0,0}, // S_FIRE30
  {SPR_PUFF,1,4,{NULL},S_SMOKE2,0,0}, // S_SMOKE1
  {SPR_PUFF,2,4,{NULL},S_SMOKE3,0,0}, // S_SMOKE2
  {SPR_PUFF,1,4,{NULL},S_SMOKE4,0,0}, // S_SMOKE3
  {SPR_PUFF,2,4,{NULL},S_SMOKE5,0,0}, // S_SMOKE4
  {SPR_PUFF,3,4,{NULL},S_NULL,0,0}, // S_SMOKE5
  {SPR_FATB,32768,2,{A_Tracer},S_TRACER2,0,0},  // S_TRACER
  {SPR_FATB,32769,2,{A_Tracer},S_TRACER,0,0}, // S_TRACER2
  {SPR_FBXP,32768,8,{NULL},S_TRACEEXP2,0,0},  // S_TRACEEXP1
  {SPR_FBXP,32769,6,{NULL},S_TRACEEXP3,0,0},  // S_TRACEEXP2
  {SPR_FBXP,32770,4,{NULL},S_NULL,0,0}, // S_TRACEEXP3
  {SPR_SKEL,0,10,{A_Look},S_SKEL_STND2,0,0},  // S_SKEL_STND
  {SPR_SKEL,1,10,{A_Look},S_SKEL_STND,0,0}, // S_SKEL_STND2
  {SPR_SKEL,0,2,{A_Chase},S_SKEL_RUN2,0,0}, // S_SKEL_RUN1
  {SPR_SKEL,0,2,{A_Chase},S_SKEL_RUN3,0,0}, // S_SKEL_RUN2
  {SPR_SKEL,1,2,{A_Chase},S_SKEL_RUN4,0,0}, // S_SKEL_RUN3
  {SPR_SKEL,1,2,{A_Chase},S_SKEL_RUN5,0,0}, // S_SKEL_RUN4
  {SPR_SKEL,2,2,{A_Chase},S_SKEL_RUN6,0,0}, // S_SKEL_RUN5
  {SPR_SKEL,2,2,{A_Chase},S_SKEL_RUN7,0,0}, // S_SKEL_RUN6
  {SPR_SKEL,3,2,{A_Chase},S_SKEL_RUN8,0,0}, // S_SKEL_RUN7
  {SPR_SKEL,3,2,{A_Chase},S_SKEL_RUN9,0,0}, // S_SKEL_RUN8
  {SPR_SKEL,4,2,{A_Chase},S_SKEL_RUN10,0,0},  // S_SKEL_RUN9
  {SPR_SKEL,4,2,{A_Chase},S_SKEL_RUN11,0,0},  // S_SKEL_RUN10
  {SPR_SKEL,5,2,{A_Chase},S_SKEL_RUN12,0,0},  // S_SKEL_RUN11
  {SPR_SKEL,5,2,{A_Chase},S_SKEL_RUN1,0,0}, // S_SKEL_RUN12
  {SPR_SKEL,6,0,{A_FaceTarget},S_SKEL_FIST2,0,0}, // S_SKEL_FIST1
  {SPR_SKEL,6,6,{A_SkelWhoosh},S_SKEL_FIST3,0,0}, // S_SKEL_FIST2
  {SPR_SKEL,7,6,{A_FaceTarget},S_SKEL_FIST4,0,0}, // S_SKEL_FIST3
  {SPR_SKEL,8,6,{A_SkelFist},S_SKEL_RUN1,0,0},  // S_SKEL_FIST4
  {SPR_SKEL,32777,0,{A_FaceTarget},S_SKEL_MISS2,0,0}, // S_SKEL_MISS1
  {SPR_SKEL,32777,10,{A_FaceTarget},S_SKEL_MISS3,0,0},  // S_SKEL_MISS2
  {SPR_SKEL,10,10,{A_SkelMissile},S_SKEL_MISS4,0,0},  // S_SKEL_MISS3
  {SPR_SKEL,10,10,{A_FaceTarget},S_SKEL_RUN1,0,0},  // S_SKEL_MISS4
  {SPR_SKEL,11,5,{NULL},S_SKEL_PAIN2,0,0},  // S_SKEL_PAIN
  {SPR_SKEL,11,5,{A_Pain},S_SKEL_RUN1,0,0}, // S_SKEL_PAIN2
  {SPR_SKEL,11,7,{NULL},S_SKEL_DIE2,0,0}, // S_SKEL_DIE1
  {SPR_SKEL,12,7,{NULL},S_SKEL_DIE3,0,0}, // S_SKEL_DIE2
  {SPR_SKEL,13,7,{A_Scream},S_SKEL_DIE4,0,0}, // S_SKEL_DIE3
  {SPR_SKEL,14,7,{A_Fall},S_SKEL_DIE5,0,0}, // S_SKEL_DIE4
  {SPR_SKEL,15,7,{NULL},S_SKEL_DIE6,0,0}, // S_SKEL_DIE5
  {SPR_SKEL,16,-1,{NULL},S_NULL,0,0}, // S_SKEL_DIE6
  {SPR_SKEL,16,5,{NULL},S_SKEL_RAISE2,0,0}, // S_SKEL_RAISE1
  {SPR_SKEL,15,5,{NULL},S_SKEL_RAISE3,0,0}, // S_SKEL_RAISE2
  {SPR_SKEL,14,5,{NULL},S_SKEL_RAISE4,0,0}, // S_SKEL_RAISE3
  {SPR_SKEL,13,5,{NULL},S_SKEL_RAISE5,0,0}, // S_SKEL_RAISE4
  {SPR_SKEL,12,5,{NULL},S_SKEL_RAISE6,0,0}, // S_SKEL_RAISE5
  {SPR_SKEL,11,5,{NULL},S_SKEL_RUN1,0,0}, // S_SKEL_RAISE6
  {SPR_MANF,32768,4,{NULL},S_FATSHOT2,0,0}, // S_FATSHOT1
  {SPR_MANF,32769,4,{NULL},S_FATSHOT1,0,0}, // S_FATSHOT2
  {SPR_MISL,32769,8,{NULL},S_FATSHOTX2,0,0},  // S_FATSHOTX1
  {SPR_MISL,32770,6,{NULL},S_FATSHOTX3,0,0},  // S_FATSHOTX2
  {SPR_MISL,32771,4,{NULL},S_NULL,0,0}, // S_FATSHOTX3
  {SPR_FATT,0,15,{A_Look},S_FATT_STND2,0,0},  // S_FATT_STND
  {SPR_FATT,1,15,{A_Look},S_FATT_STND,0,0}, // S_FATT_STND2
  {SPR_FATT,0,4,{A_Chase},S_FATT_RUN2,0,0}, // S_FATT_RUN1
  {SPR_FATT,0,4,{A_Chase},S_FATT_RUN3,0,0}, // S_FATT_RUN2
  {SPR_FATT,1,4,{A_Chase},S_FATT_RUN4,0,0}, // S_FATT_RUN3
  {SPR_FATT,1,4,{A_Chase},S_FATT_RUN5,0,0}, // S_FATT_RUN4
  {SPR_FATT,2,4,{A_Chase},S_FATT_RUN6,0,0}, // S_FATT_RUN5
  {SPR_FATT,2,4,{A_Chase},S_FATT_RUN7,0,0}, // S_FATT_RUN6
  {SPR_FATT,3,4,{A_Chase},S_FATT_RUN8,0,0}, // S_FATT_RUN7
  {SPR_FATT,3,4,{A_Chase},S_FATT_RUN9,0,0}, // S_FATT_RUN8
  {SPR_FATT,4,4,{A_Chase},S_FATT_RUN10,0,0},  // S_FATT_RUN9
  {SPR_FATT,4,4,{A_Chase},S_FATT_RUN11,0,0},  // S_FATT_RUN10
  {SPR_FATT,5,4,{A_Chase},S_FATT_RUN12,0,0},  // S_FATT_RUN11
  {SPR_FATT,5,4,{A_Chase},S_FATT_RUN1,0,0}, // S_FATT_RUN12
  {SPR_FATT,6,20,{A_FatRaise},S_FATT_ATK2,0,0}, // S_FATT_ATK1
  {SPR_FATT,32775,10,{A_FatAttack1},S_FATT_ATK3,0,0}, // S_FATT_ATK2
  {SPR_FATT,8,5,{A_FaceTarget},S_FATT_ATK4,0,0},  // S_FATT_ATK3
  {SPR_FATT,6,5,{A_FaceTarget},S_FATT_ATK5,0,0},  // S_FATT_ATK4
  {SPR_FATT,32775,10,{A_FatAttack2},S_FATT_ATK6,0,0}, // S_FATT_ATK5
  {SPR_FATT,8,5,{A_FaceTarget},S_FATT_ATK7,0,0},  // S_FATT_ATK6
  {SPR_FATT,6,5,{A_FaceTarget},S_FATT_ATK8,0,0},  // S_FATT_ATK7
  {SPR_FATT,32775,10,{A_FatAttack3},S_FATT_ATK9,0,0}, // S_FATT_ATK8
  {SPR_FATT,8,5,{A_FaceTarget},S_FATT_ATK10,0,0}, // S_FATT_ATK9
  {SPR_FATT,6,5,{A_FaceTarget},S_FATT_RUN1,0,0},  // S_FATT_ATK10
  {SPR_FATT,9,3,{NULL},S_FATT_PAIN2,0,0}, // S_FATT_PAIN
  {SPR_FATT,9,3,{A_Pain},S_FATT_RUN1,0,0},  // S_FATT_PAIN2
  {SPR_FATT,10,6,{NULL},S_FATT_DIE2,0,0}, // S_FATT_DIE1
  {SPR_FATT,11,6,{A_Scream},S_FATT_DIE3,0,0}, // S_FATT_DIE2
  {SPR_FATT,12,6,{A_Fall},S_FATT_DIE4,0,0}, // S_FATT_DIE3
  {SPR_FATT,13,6,{NULL},S_FATT_DIE5,0,0}, // S_FATT_DIE4
  {SPR_FATT,14,6,{NULL},S_FATT_DIE6,0,0}, // S_FATT_DIE5
  {SPR_FATT,15,6,{NULL},S_FATT_DIE7,0,0}, // S_FATT_DIE6
  {SPR_FATT,16,6,{NULL},S_FATT_DIE8,0,0}, // S_FATT_DIE7
  {SPR_FATT,17,6,{NULL},S_FATT_DIE9,0,0}, // S_FATT_DIE8
  {SPR_FATT,18,6,{NULL},S_FATT_DIE10,0,0},  // S_FATT_DIE9
  {SPR_FATT,19,-1,{A_BossDeath},S_NULL,0,0},  // S_FATT_DIE10
  {SPR_FATT,17,5,{NULL},S_FATT_RAISE2,0,0}, // S_FATT_RAISE1
  {SPR_FATT,16,5,{NULL},S_FATT_RAISE3,0,0}, // S_FATT_RAISE2
  {SPR_FATT,15,5,{NULL},S_FATT_RAISE4,0,0}, // S_FATT_RAISE3
  {SPR_FATT,14,5,{NULL},S_FATT_RAISE5,0,0}, // S_FATT_RAISE4
  {SPR_FATT,13,5,{NULL},S_FATT_RAISE6,0,0}, // S_FATT_RAISE5
  {SPR_FATT,12,5,{NULL},S_FATT_RAISE7,0,0}, // S_FATT_RAISE6
  {SPR_FATT,11,5,{NULL},S_FATT_RAISE8,0,0}, // S_FATT_RAISE7
  {SPR_FATT,10,5,{NULL},S_FATT_RUN1,0,0}, // S_FATT_RAISE8
  {SPR_CPOS,0,10,{A_Look},S_CPOS_STND2,0,0},  // S_CPOS_STND
  {SPR_CPOS,1,10,{A_Look},S_CPOS_STND,0,0}, // S_CPOS_STND2
  {SPR_CPOS,0,3,{A_Chase},S_CPOS_RUN2,0,0}, // S_CPOS_RUN1
  {SPR_CPOS,0,3,{A_Chase},S_CPOS_RUN3,0,0}, // S_CPOS_RUN2
  {SPR_CPOS,1,3,{A_Chase},S_CPOS_RUN4,0,0}, // S_CPOS_RUN3
  {SPR_CPOS,1,3,{A_Chase},S_CPOS_RUN5,0,0}, // S_CPOS_RUN4
  {SPR_CPOS,2,3,{A_Chase},S_CPOS_RUN6,0,0}, // S_CPOS_RUN5
  {SPR_CPOS,2,3,{A_Chase},S_CPOS_RUN7,0,0}, // S_CPOS_RUN6
  {SPR_CPOS,3,3,{A_Chase},S_CPOS_RUN8,0,0}, // S_CPOS_RUN7
  {SPR_CPOS,3,3,{A_Chase},S_CPOS_RUN1,0,0}, // S_CPOS_RUN8
  {SPR_CPOS,4,10,{A_FaceTarget},S_CPOS_ATK2,0,0}, // S_CPOS_ATK1
  {SPR_CPOS,32773,4,{A_CPosAttack},S_CPOS_ATK3,0,0},  // S_CPOS_ATK2
  {SPR_CPOS,32772,4,{A_CPosAttack},S_CPOS_ATK4,0,0},  // S_CPOS_ATK3
  {SPR_CPOS,5,1,{A_CPosRefire},S_CPOS_ATK2,0,0},  // S_CPOS_ATK4
  {SPR_CPOS,6,3,{NULL},S_CPOS_PAIN2,0,0}, // S_CPOS_PAIN
  {SPR_CPOS,6,3,{A_Pain},S_CPOS_RUN1,0,0},  // S_CPOS_PAIN2
  {SPR_CPOS,7,5,{NULL},S_CPOS_DIE2,0,0},  // S_CPOS_DIE1
  {SPR_CPOS,8,5,{A_Scream},S_CPOS_DIE3,0,0},  // S_CPOS_DIE2
  {SPR_CPOS,9,5,{A_Fall},S_CPOS_DIE4,0,0},  // S_CPOS_DIE3
  {SPR_CPOS,10,5,{NULL},S_CPOS_DIE5,0,0}, // S_CPOS_DIE4
  {SPR_CPOS,11,5,{NULL},S_CPOS_DIE6,0,0}, // S_CPOS_DIE5
  {SPR_CPOS,12,5,{NULL},S_CPOS_DIE7,0,0}, // S_CPOS_DIE6
  {SPR_CPOS,13,-1,{NULL},S_NULL,0,0}, // S_CPOS_DIE7
  {SPR_CPOS,14,5,{NULL},S_CPOS_XDIE2,0,0},  // S_CPOS_XDIE1
  {SPR_CPOS,15,5,{A_XScream},S_CPOS_XDIE3,0,0}, // S_CPOS_XDIE2
  {SPR_CPOS,16,5,{A_Fall},S_CPOS_XDIE4,0,0},  // S_CPOS_XDIE3
  {SPR_CPOS,17,5,{NULL},S_CPOS_XDIE5,0,0},  // S_CPOS_XDIE4
  {SPR_CPOS,18,5,{NULL},S_CPOS_XDIE6,0,0},  // S_CPOS_XDIE5
  {SPR_CPOS,19,-1,{NULL},S_NULL,0,0}, // S_CPOS_XDIE6
  {SPR_CPOS,13,5,{NULL},S_CPOS_RAISE2,0,0}, // S_CPOS_RAISE1
  {SPR_CPOS,12,5,{NULL},S_CPOS_RAISE3,0,0}, // S_CPOS_RAISE2
  {SPR_CPOS,11,5,{NULL},S_CPOS_RAISE4,0,0}, // S_CPOS_RAISE3
  {SPR_CPOS,10,5,{NULL},S_CPOS_RAISE5,0,0}, // S_CPOS_RAISE4
  {SPR_CPOS,9,5,{NULL},S_CPOS_RAISE6,0,0},  // S_CPOS_RAISE5
  {SPR_CPOS,8,5,{NULL},S_CPOS_RAISE7,0,0},  // S_CPOS_RAISE6
  {SPR_CPOS,7,5,{NULL},S_CPOS_RUN1,0,0},  // S_CPOS_RAISE7
  {SPR_TROO,0,10,{A_Look},S_TROO_STND2,0,0},  // S_TROO_STND
  {SPR_TROO,1,10,{A_Look},S_TROO_STND,0,0}, // S_TROO_STND2
  {SPR_TROO,0,3,{A_Chase},S_TROO_RUN2,0,0}, // S_TROO_RUN1
  {SPR_TROO,0,3,{A_Chase},S_TROO_RUN3,0,0}, // S_TROO_RUN2
  {SPR_TROO,1,3,{A_Chase},S_TROO_RUN4,0,0}, // S_TROO_RUN3
  {SPR_TROO,1,3,{A_Chase},S_TROO_RUN5,0,0}, // S_TROO_RUN4
  {SPR_TROO,2,3,{A_Chase},S_TROO_RUN6,0,0}, // S_TROO_RUN5
  {SPR_TROO,2,3,{A_Chase},S_TROO_RUN7,0,0}, // S_TROO_RUN6
  {SPR_TROO,3,3,{A_Chase},S_TROO_RUN8,0,0}, // S_TROO_RUN7
  {SPR_TROO,3,3,{A_Chase},S_TROO_RUN1,0,0}, // S_TROO_RUN8
  {SPR_TROO,4,8,{A_FaceTarget},S_TROO_ATK2,0,0},  // S_TROO_ATK1
  {SPR_TROO,5,8,{A_FaceTarget},S_TROO_ATK3,0,0},  // S_TROO_ATK2
  {SPR_TROO,6,6,{A_TroopAttack},S_TROO_RUN1,0,0}, // S_TROO_ATK3
  {SPR_TROO,7,2,{NULL},S_TROO_PAIN2,0,0}, // S_TROO_PAIN
  {SPR_TROO,7,2,{A_Pain},S_TROO_RUN1,0,0},  // S_TROO_PAIN2
  {SPR_TROO,8,8,{NULL},S_TROO_DIE2,0,0},  // S_TROO_DIE1
  {SPR_TROO,9,8,{A_Scream},S_TROO_DIE3,0,0},  // S_TROO_DIE2
  {SPR_TROO,10,6,{NULL},S_TROO_DIE4,0,0}, // S_TROO_DIE3
  {SPR_TROO,11,6,{A_Fall},S_TROO_DIE5,0,0}, // S_TROO_DIE4
  {SPR_TROO,12,-1,{NULL},S_NULL,0,0}, // S_TROO_DIE5
  {SPR_TROO,13,5,{NULL},S_TROO_XDIE2,0,0},  // S_TROO_XDIE1
  {SPR_TROO,14,5,{A_XScream},S_TROO_XDIE3,0,0}, // S_TROO_XDIE2
  {SPR_TROO,15,5,{NULL},S_TROO_XDIE4,0,0},  // S_TROO_XDIE3
  {SPR_TROO,16,5,{A_Fall},S_TROO_XDIE5,0,0},  // S_TROO_XDIE4
  {SPR_TROO,17,5,{NULL},S_TROO_XDIE6,0,0},  // S_TROO_XDIE5
  {SPR_TROO,18,5,{NULL},S_TROO_XDIE7,0,0},  // S_TROO_XDIE6
  {SPR_TROO,19,5,{NULL},S_TROO_XDIE8,0,0},  // S_TROO_XDIE7
  {SPR_TROO,20,-1,{NULL},S_NULL,0,0}, // S_TROO_XDIE8
  {SPR_TROO,12,8,{NULL},S_TROO_RAISE2,0,0}, // S_TROO_RAISE1
  {SPR_TROO,11,8,{NULL},S_TROO_RAISE3,0,0}, // S_TROO_RAISE2
  {SPR_TROO,10,6,{NULL},S_TROO_RAISE4,0,0}, // S_TROO_RAISE3
  {SPR_TROO,9,6,{NULL},S_TROO_RAISE5,0,0},  // S_TROO_RAISE4
  {SPR_TROO,8,6,{NULL},S_TROO_RUN1,0,0},  // S_TROO_RAISE5
  {SPR_SARG,0,10,{A_Look},S_SARG_STND2,0,0},  // S_SARG_STND
  {SPR_SARG,1,10,{A_Look},S_SARG_STND,0,0}, // S_SARG_STND2
  {SPR_SARG,0,2,{A_Chase},S_SARG_RUN2,0,0}, // S_SARG_RUN1
  {SPR_SARG,0,2,{A_Chase},S_SARG_RUN3,0,0}, // S_SARG_RUN2
  {SPR_SARG,1,2,{A_Chase},S_SARG_RUN4,0,0}, // S_SARG_RUN3
  {SPR_SARG,1,2,{A_Chase},S_SARG_RUN5,0,0}, // S_SARG_RUN4
  {SPR_SARG,2,2,{A_Chase},S_SARG_RUN6,0,0}, // S_SARG_RUN5
  {SPR_SARG,2,2,{A_Chase},S_SARG_RUN7,0,0}, // S_SARG_RUN6
  {SPR_SARG,3,2,{A_Chase},S_SARG_RUN8,0,0}, // S_SARG_RUN7
  {SPR_SARG,3,2,{A_Chase},S_SARG_RUN1,0,0}, // S_SARG_RUN8
  {SPR_SARG,4,8,{A_FaceTarget},S_SARG_ATK2,0,0},  // S_SARG_ATK1
  {SPR_SARG,5,8,{A_FaceTarget},S_SARG_ATK3,0,0},  // S_SARG_ATK2
  {SPR_SARG,6,8,{A_SargAttack},S_SARG_RUN1,0,0},  // S_SARG_ATK3
  {SPR_SARG,7,2,{NULL},S_SARG_PAIN2,0,0}, // S_SARG_PAIN
  {SPR_SARG,7,2,{A_Pain},S_SARG_RUN1,0,0},  // S_SARG_PAIN2
  {SPR_SARG,8,8,{NULL},S_SARG_DIE2,0,0},  // S_SARG_DIE1
  {SPR_SARG,9,8,{A_Scream},S_SARG_DIE3,0,0},  // S_SARG_DIE2
  {SPR_SARG,10,4,{NULL},S_SARG_DIE4,0,0}, // S_SARG_DIE3
  {SPR_SARG,11,4,{A_Fall},S_SARG_DIE5,0,0}, // S_SARG_DIE4
  {SPR_SARG,12,4,{NULL},S_SARG_DIE6,0,0}, // S_SARG_DIE5
  {SPR_SARG,13,-1,{NULL},S_NULL,0,0}, // S_SARG_DIE6
  {SPR_SARG,13,5,{NULL},S_SARG_RAISE2,0,0}, // S_SARG_RAISE1
  {SPR_SARG,12,5,{NULL},S_SARG_RAISE3,0,0}, // S_SARG_RAISE2
  {SPR_SARG,11,5,{NULL},S_SARG_RAISE4,0,0}, // S_SARG_RAISE3
  {SPR_SARG,10,5,{NULL},S_SARG_RAISE5,0,0}, // S_SARG_RAISE4
  {SPR_SARG,9,5,{NULL},S_SARG_RAISE6,0,0},  // S_SARG_RAISE5
  {SPR_SARG,8,5,{NULL},S_SARG_RUN1,0,0},  // S_SARG_RAISE6
  {SPR_HEAD,0,10,{A_Look},S_HEAD_STND,0,0}, // S_HEAD_STND
  {SPR_HEAD,0,3,{A_Chase},S_HEAD_RUN1,0,0}, // S_HEAD_RUN1
  {SPR_HEAD,1,5,{A_FaceTarget},S_HEAD_ATK2,0,0},  // S_HEAD_ATK1
  {SPR_HEAD,2,5,{A_FaceTarget},S_HEAD_ATK3,0,0},  // S_HEAD_ATK2
  {SPR_HEAD,32771,5,{A_HeadAttack},S_HEAD_RUN1,0,0},  // S_HEAD_ATK3
  {SPR_HEAD,4,3,{NULL},S_HEAD_PAIN2,0,0}, // S_HEAD_PAIN
  {SPR_HEAD,4,3,{A_Pain},S_HEAD_PAIN3,0,0}, // S_HEAD_PAIN2
  {SPR_HEAD,5,6,{NULL},S_HEAD_RUN1,0,0},  // S_HEAD_PAIN3
  {SPR_HEAD,6,8,{NULL},S_HEAD_DIE2,0,0},  // S_HEAD_DIE1
  {SPR_HEAD,7,8,{A_Scream},S_HEAD_DIE3,0,0},  // S_HEAD_DIE2
  {SPR_HEAD,8,8,{NULL},S_HEAD_DIE4,0,0},  // S_HEAD_DIE3
  {SPR_HEAD,9,8,{NULL},S_HEAD_DIE5,0,0},  // S_HEAD_DIE4
  {SPR_HEAD,10,8,{A_Fall},S_HEAD_DIE6,0,0}, // S_HEAD_DIE5
  {SPR_HEAD,11,-1,{NULL},S_NULL,0,0}, // S_HEAD_DIE6
  {SPR_HEAD,11,8,{NULL},S_HEAD_RAISE2,0,0}, // S_HEAD_RAISE1
  {SPR_HEAD,10,8,{NULL},S_HEAD_RAISE3,0,0}, // S_HEAD_RAISE2
  {SPR_HEAD,9,8,{NULL},S_HEAD_RAISE4,0,0},  // S_HEAD_RAISE3
  {SPR_HEAD,8,8,{NULL},S_HEAD_RAISE5,0,0},  // S_HEAD_RAISE4
  {SPR_HEAD,7,8,{NULL},S_HEAD_RAISE6,0,0},  // S_HEAD_RAISE5
  {SPR_HEAD,6,8,{NULL},S_HEAD_RUN1,0,0},  // S_HEAD_RAISE6
  {SPR_BAL7,32768,4,{NULL},S_BRBALL2,0,0},  // S_BRBALL1
  {SPR_BAL7,32769,4,{NULL},S_BRBALL1,0,0},  // S_BRBALL2
  {SPR_BAL7,32770,6,{NULL},S_BRBALLX2,0,0}, // S_BRBALLX1
  {SPR_BAL7,32771,6,{NULL},S_BRBALLX3,0,0}, // S_BRBALLX2
  {SPR_BAL7,32772,6,{NULL},S_NULL,0,0}, // S_BRBALLX3
  {SPR_BOSS,0,10,{A_Look},S_BOSS_STND2,0,0},  // S_BOSS_STND
  {SPR_BOSS,1,10,{A_Look},S_BOSS_STND,0,0}, // S_BOSS_STND2
  {SPR_BOSS,0,3,{A_Chase},S_BOSS_RUN2,0,0}, // S_BOSS_RUN1
  {SPR_BOSS,0,3,{A_Chase},S_BOSS_RUN3,0,0}, // S_BOSS_RUN2
  {SPR_BOSS,1,3,{A_Chase},S_BOSS_RUN4,0,0}, // S_BOSS_RUN3
  {SPR_BOSS,1,3,{A_Chase},S_BOSS_RUN5,0,0}, // S_BOSS_RUN4
  {SPR_BOSS,2,3,{A_Chase},S_BOSS_RUN6,0,0}, // S_BOSS_RUN5
  {SPR_BOSS,2,3,{A_Chase},S_BOSS_RUN7,0,0}, // S_BOSS_RUN6
  {SPR_BOSS,3,3,{A_Chase},S_BOSS_RUN8,0,0}, // S_BOSS_RUN7
  {SPR_BOSS,3,3,{A_Chase},S_BOSS_RUN1,0,0}, // S_BOSS_RUN8
  {SPR_BOSS,4,8,{A_FaceTarget},S_BOSS_ATK2,0,0},  // S_BOSS_ATK1
  {SPR_BOSS,5,8,{A_FaceTarget},S_BOSS_ATK3,0,0},  // S_BOSS_ATK2
  {SPR_BOSS,6,8,{A_BruisAttack},S_BOSS_RUN1,0,0}, // S_BOSS_ATK3
  {SPR_BOSS,7,2,{NULL},S_BOSS_PAIN2,0,0}, // S_BOSS_PAIN
  {SPR_BOSS,7,2,{A_Pain},S_BOSS_RUN1,0,0},  // S_BOSS_PAIN2
  {SPR_BOSS,8,8,{NULL},S_BOSS_DIE2,0,0},  // S_BOSS_DIE1
  {SPR_BOSS,9,8,{A_Scream},S_BOSS_DIE3,0,0},  // S_BOSS_DIE2
  {SPR_BOSS,10,8,{NULL},S_BOSS_DIE4,0,0}, // S_BOSS_DIE3
  {SPR_BOSS,11,8,{A_Fall},S_BOSS_DIE5,0,0}, // S_BOSS_DIE4
  {SPR_BOSS,12,8,{NULL},S_BOSS_DIE6,0,0}, // S_BOSS_DIE5
  {SPR_BOSS,13,8,{NULL},S_BOSS_DIE7,0,0}, // S_BOSS_DIE6
  {SPR_BOSS,14,-1,{A_BossDeath},S_NULL,0,0},  // S_BOSS_DIE7
  {SPR_BOSS,14,8,{NULL},S_BOSS_RAISE2,0,0}, // S_BOSS_RAISE1
  {SPR_BOSS,13,8,{NULL},S_BOSS_RAISE3,0,0}, // S_BOSS_RAISE2
  {SPR_BOSS,12,8,{NULL},S_BOSS_RAISE4,0,0}, // S_BOSS_RAISE3
  {SPR_BOSS,11,8,{NULL},S_BOSS_RAISE5,0,0}, // S_BOSS_RAISE4
  {SPR_BOSS,10,8,{NULL},S_BOSS_RAISE6,0,0}, // S_BOSS_RAISE5
  {SPR_BOSS,9,8,{NULL},S_BOSS_RAISE7,0,0},  // S_BOSS_RAISE6
  {SPR_BOSS,8,8,{NULL},S_BOSS_RUN1,0,0},  // S_BOSS_RAISE7
  {SPR_BOS2,0,10,{A_Look},S_BOS2_STND2,0,0},  // S_BOS2_STND
  {SPR_BOS2,1,10,{A_Look},S_BOS2_STND,0,0}, // S_BOS2_STND2
  {SPR_BOS2,0,3,{A_Chase},S_BOS2_RUN2,0,0}, // S_BOS2_RUN1
  {SPR_BOS2,0,3,{A_Chase},S_BOS2_RUN3,0,0}, // S_BOS2_RUN2
  {SPR_BOS2,1,3,{A_Chase},S_BOS2_RUN4,0,0}, // S_BOS2_RUN3
  {SPR_BOS2,1,3,{A_Chase},S_BOS2_RUN5,0,0}, // S_BOS2_RUN4
  {SPR_BOS2,2,3,{A_Chase},S_BOS2_RUN6,0,0}, // S_BOS2_RUN5
  {SPR_BOS2,2,3,{A_Chase},S_BOS2_RUN7,0,0}, // S_BOS2_RUN6
  {SPR_BOS2,3,3,{A_Chase},S_BOS2_RUN8,0,0}, // S_BOS2_RUN7
  {SPR_BOS2,3,3,{A_Chase},S_BOS2_RUN1,0,0}, // S_BOS2_RUN8
  {SPR_BOS2,4,8,{A_FaceTarget},S_BOS2_ATK2,0,0},  // S_BOS2_ATK1
  {SPR_BOS2,5,8,{A_FaceTarget},S_BOS2_ATK3,0,0},  // S_BOS2_ATK2
  {SPR_BOS2,6,8,{A_BruisAttack},S_BOS2_RUN1,0,0}, // S_BOS2_ATK3
  {SPR_BOS2,7,2,{NULL},S_BOS2_PAIN2,0,0}, // S_BOS2_PAIN
  {SPR_BOS2,7,2,{A_Pain},S_BOS2_RUN1,0,0},  // S_BOS2_PAIN2
  {SPR_BOS2,8,8,{NULL},S_BOS2_DIE2,0,0},  // S_BOS2_DIE1
  {SPR_BOS2,9,8,{A_Scream},S_BOS2_DIE3,0,0},  // S_BOS2_DIE2
  {SPR_BOS2,10,8,{NULL},S_BOS2_DIE4,0,0}, // S_BOS2_DIE3
  {SPR_BOS2,11,8,{A_Fall},S_BOS2_DIE5,0,0}, // S_BOS2_DIE4
  {SPR_BOS2,12,8,{NULL},S_BOS2_DIE6,0,0}, // S_BOS2_DIE5
  {SPR_BOS2,13,8,{NULL},S_BOS2_DIE7,0,0}, // S_BOS2_DIE6
  {SPR_BOS2,14,-1,{NULL},S_NULL,0,0}, // S_BOS2_DIE7
  {SPR_BOS2,14,8,{NULL},S_BOS2_RAISE2,0,0}, // S_BOS2_RAISE1
  {SPR_BOS2,13,8,{NULL},S_BOS2_RAISE3,0,0}, // S_BOS2_RAISE2
  {SPR_BOS2,12,8,{NULL},S_BOS2_RAISE4,0,0}, // S_BOS2_RAISE3
  {SPR_BOS2,11,8,{NULL},S_BOS2_RAISE5,0,0}, // S_BOS2_RAISE4
  {SPR_BOS2,10,8,{NULL},S_BOS2_RAISE6,0,0}, // S_BOS2_RAISE5
  {SPR_BOS2,9,8,{NULL},S_BOS2_RAISE7,0,0},  // S_BOS2_RAISE6
  {SPR_BOS2,8,8,{NULL},S_BOS2_RUN1,0,0},  // S_BOS2_RAISE7
  {SPR_SKUL,32768,10,{A_Look},S_SKULL_STND2,0,0}, // S_SKULL_STND
  {SPR_SKUL,32769,10,{A_Look},S_SKULL_STND,0,0},  // S_SKULL_STND2
  {SPR_SKUL,32768,6,{A_Chase},S_SKULL_RUN2,0,0},  // S_SKULL_RUN1
  {SPR_SKUL,32769,6,{A_Chase},S_SKULL_RUN1,0,0},  // S_SKULL_RUN2
  {SPR_SKUL,32770,10,{A_FaceTarget},S_SKULL_ATK2,0,0},  // S_SKULL_ATK1
  {SPR_SKUL,32771,4,{A_SkullAttack},S_SKULL_ATK3,0,0},  // S_SKULL_ATK2
  {SPR_SKUL,32770,4,{NULL},S_SKULL_ATK4,0,0}, // S_SKULL_ATK3
  {SPR_SKUL,32771,4,{NULL},S_SKULL_ATK3,0,0}, // S_SKULL_ATK4
  {SPR_SKUL,32772,3,{NULL},S_SKULL_PAIN2,0,0},  // S_SKULL_PAIN
  {SPR_SKUL,32772,3,{A_Pain},S_SKULL_RUN1,0,0}, // S_SKULL_PAIN2
  {SPR_SKUL,32773,6,{NULL},S_SKULL_DIE2,0,0}, // S_SKULL_DIE1
  {SPR_SKUL,32774,6,{A_Scream},S_SKULL_DIE3,0,0}, // S_SKULL_DIE2
  {SPR_SKUL,32775,6,{NULL},S_SKULL_DIE4,0,0}, // S_SKULL_DIE3
  {SPR_SKUL,32776,6,{A_Fall},S_SKULL_DIE5,0,0}, // S_SKULL_DIE4
  {SPR_SKUL,9,6,{NULL},S_SKULL_DIE6,0,0}, // S_SKULL_DIE5
  {SPR_SKUL,10,6,{NULL},S_NULL,0,0},  // S_SKULL_DIE6
  {SPR_SPID,0,10,{A_Look},S_SPID_STND2,0,0},  // S_SPID_STND
  {SPR_SPID,1,10,{A_Look},S_SPID_STND,0,0}, // S_SPID_STND2
  {SPR_SPID,0,3,{A_Metal},S_SPID_RUN2,0,0}, // S_SPID_RUN1
  {SPR_SPID,0,3,{A_Chase},S_SPID_RUN3,0,0}, // S_SPID_RUN2
  {SPR_SPID,1,3,{A_Chase},S_SPID_RUN4,0,0}, // S_SPID_RUN3
  {SPR_SPID,1,3,{A_Chase},S_SPID_RUN5,0,0}, // S_SPID_RUN4
  {SPR_SPID,2,3,{A_Metal},S_SPID_RUN6,0,0}, // S_SPID_RUN5
  {SPR_SPID,2,3,{A_Chase},S_SPID_RUN7,0,0}, // S_SPID_RUN6
  {SPR_SPID,3,3,{A_Chase},S_SPID_RUN8,0,0}, // S_SPID_RUN7
  {SPR_SPID,3,3,{A_Chase},S_SPID_RUN9,0,0}, // S_SPID_RUN8
  {SPR_SPID,4,3,{A_Metal},S_SPID_RUN10,0,0},  // S_SPID_RUN9
  {SPR_SPID,4,3,{A_Chase},S_SPID_RUN11,0,0},  // S_SPID_RUN10
  {SPR_SPID,5,3,{A_Chase},S_SPID_RUN12,0,0},  // S_SPID_RUN11
  {SPR_SPID,5,3,{A_Chase},S_SPID_RUN1,0,0}, // S_SPID_RUN12
  {SPR_SPID,32768,20,{A_FaceTarget},S_SPID_ATK2,0,0}, // S_SPID_ATK1
  {SPR_SPID,32774,4,{A_SPosAttack},S_SPID_ATK3,0,0},  // S_SPID_ATK2
  {SPR_SPID,32775,4,{A_SPosAttack},S_SPID_ATK4,0,0},  // S_SPID_ATK3
  {SPR_SPID,32775,1,{A_SpidRefire},S_SPID_ATK2,0,0},  // S_SPID_ATK4
  {SPR_SPID,8,3,{NULL},S_SPID_PAIN2,0,0}, // S_SPID_PAIN
  {SPR_SPID,8,3,{A_Pain},S_SPID_RUN1,0,0},  // S_SPID_PAIN2
  {SPR_SPID,9,20,{A_Scream},S_SPID_DIE2,0,0}, // S_SPID_DIE1
  {SPR_SPID,10,10,{A_Fall},S_SPID_DIE3,0,0},  // S_SPID_DIE2
  {SPR_SPID,11,10,{NULL},S_SPID_DIE4,0,0},  // S_SPID_DIE3
  {SPR_SPID,12,10,{NULL},S_SPID_DIE5,0,0},  // S_SPID_DIE4
  {SPR_SPID,13,10,{NULL},S_SPID_DIE6,0,0},  // S_SPID_DIE5
  {SPR_SPID,14,10,{NULL},S_SPID_DIE7,0,0},  // S_SPID_DIE6
  {SPR_SPID,15,10,{NULL},S_SPID_DIE8,0,0},  // S_SPID_DIE7
  {SPR_SPID,16,10,{NULL},S_SPID_DIE9,0,0},  // S_SPID_DIE8
  {SPR_SPID,17,10,{NULL},S_SPID_DIE10,0,0}, // S_SPID_DIE9
  {SPR_SPID,18,30,{NULL},S_SPID_DIE11,0,0}, // S_SPID_DIE10
  {SPR_SPID,18,-1,{A_BossDeath},S_NULL,0,0},  // S_SPID_DIE11
  {SPR_BSPI,0,10,{A_Look},S_BSPI_STND2,0,0},  // S_BSPI_STND
  {SPR_BSPI,1,10,{A_Look},S_BSPI_STND,0,0}, // S_BSPI_STND2
  {SPR_BSPI,0,20,{NULL},S_BSPI_RUN1,0,0}, // S_BSPI_SIGHT
  {SPR_BSPI,0,3,{A_BabyMetal},S_BSPI_RUN2,0,0}, // S_BSPI_RUN1
  {SPR_BSPI,0,3,{A_Chase},S_BSPI_RUN3,0,0}, // S_BSPI_RUN2
  {SPR_BSPI,1,3,{A_Chase},S_BSPI_RUN4,0,0}, // S_BSPI_RUN3
  {SPR_BSPI,1,3,{A_Chase},S_BSPI_RUN5,0,0}, // S_BSPI_RUN4
  {SPR_BSPI,2,3,{A_Chase},S_BSPI_RUN6,0,0}, // S_BSPI_RUN5
  {SPR_BSPI,2,3,{A_Chase},S_BSPI_RUN7,0,0}, // S_BSPI_RUN6
  {SPR_BSPI,3,3,{A_BabyMetal},S_BSPI_RUN8,0,0}, // S_BSPI_RUN7
  {SPR_BSPI,3,3,{A_Chase},S_BSPI_RUN9,0,0}, // S_BSPI_RUN8
  {SPR_BSPI,4,3,{A_Chase},S_BSPI_RUN10,0,0},  // S_BSPI_RUN9
  {SPR_BSPI,4,3,{A_Chase},S_BSPI_RUN11,0,0},  // S_BSPI_RUN10
  {SPR_BSPI,5,3,{A_Chase},S_BSPI_RUN12,0,0},  // S_BSPI_RUN11
  {SPR_BSPI,5,3,{A_Chase},S_BSPI_RUN1,0,0}, // S_BSPI_RUN12
  {SPR_BSPI,32768,20,{A_FaceTarget},S_BSPI_ATK2,0,0}, // S_BSPI_ATK1
  {SPR_BSPI,32774,4,{A_BspiAttack},S_BSPI_ATK3,0,0},  // S_BSPI_ATK2
  {SPR_BSPI,32775,4,{NULL},S_BSPI_ATK4,0,0},  // S_BSPI_ATK3
  {SPR_BSPI,32775,1,{A_SpidRefire},S_BSPI_ATK2,0,0},  // S_BSPI_ATK4
  {SPR_BSPI,8,3,{NULL},S_BSPI_PAIN2,0,0}, // S_BSPI_PAIN
  {SPR_BSPI,8,3,{A_Pain},S_BSPI_RUN1,0,0},  // S_BSPI_PAIN2
  {SPR_BSPI,9,20,{A_Scream},S_BSPI_DIE2,0,0}, // S_BSPI_DIE1
  {SPR_BSPI,10,7,{A_Fall},S_BSPI_DIE3,0,0}, // S_BSPI_DIE2
  {SPR_BSPI,11,7,{NULL},S_BSPI_DIE4,0,0}, // S_BSPI_DIE3
  {SPR_BSPI,12,7,{NULL},S_BSPI_DIE5,0,0}, // S_BSPI_DIE4
  {SPR_BSPI,13,7,{NULL},S_BSPI_DIE6,0,0}, // S_BSPI_DIE5
  {SPR_BSPI,14,7,{NULL},S_BSPI_DIE7,0,0}, // S_BSPI_DIE6
  {SPR_BSPI,15,-1,{A_BossDeath},S_NULL,0,0},  // S_BSPI_DIE7
  {SPR_BSPI,15,5,{NULL},S_BSPI_RAISE2,0,0}, // S_BSPI_RAISE1
  {SPR_BSPI,14,5,{NULL},S_BSPI_RAISE3,0,0}, // S_BSPI_RAISE2
  {SPR_BSPI,13,5,{NULL},S_BSPI_RAISE4,0,0}, // S_BSPI_RAISE3
  {SPR_BSPI,12,5,{NULL},S_BSPI_RAISE5,0,0}, // S_BSPI_RAISE4
  {SPR_BSPI,11,5,{NULL},S_BSPI_RAISE6,0,0}, // S_BSPI_RAISE5
  {SPR_BSPI,10,5,{NULL},S_BSPI_RAISE7,0,0}, // S_BSPI_RAISE6
  {SPR_BSPI,9,5,{NULL},S_BSPI_RUN1,0,0},  // S_BSPI_RAISE7
  {SPR_APLS,32768,5,{NULL},S_ARACH_PLAZ2,0,0},  // S_ARACH_PLAZ
  {SPR_APLS,32769,5,{NULL},S_ARACH_PLAZ,0,0}, // S_ARACH_PLAZ2
  {SPR_APBX,32768,5,{NULL},S_ARACH_PLEX2,0,0},  // S_ARACH_PLEX
  {SPR_APBX,32769,5,{NULL},S_ARACH_PLEX3,0,0},  // S_ARACH_PLEX2
  {SPR_APBX,32770,5,{NULL},S_ARACH_PLEX4,0,0},  // S_ARACH_PLEX3
  {SPR_APBX,32771,5,{NULL},S_ARACH_PLEX5,0,0},  // S_ARACH_PLEX4
  {SPR_APBX,32772,5,{NULL},S_NULL,0,0}, // S_ARACH_PLEX5
  {SPR_CYBR,0,10,{A_Look},S_CYBER_STND2,0,0}, // S_CYBER_STND
  {SPR_CYBR,1,10,{A_Look},S_CYBER_STND,0,0},  // S_CYBER_STND2
  {SPR_CYBR,0,3,{A_Hoof},S_CYBER_RUN2,0,0}, // S_CYBER_RUN1
  {SPR_CYBR,0,3,{A_Chase},S_CYBER_RUN3,0,0},  // S_CYBER_RUN2
  {SPR_CYBR,1,3,{A_Chase},S_CYBER_RUN4,0,0},  // S_CYBER_RUN3
  {SPR_CYBR,1,3,{A_Chase},S_CYBER_RUN5,0,0},  // S_CYBER_RUN4
  {SPR_CYBR,2,3,{A_Chase},S_CYBER_RUN6,0,0},  // S_CYBER_RUN5
  {SPR_CYBR,2,3,{A_Chase},S_CYBER_RUN7,0,0},  // S_CYBER_RUN6
  {SPR_CYBR,3,3,{A_Metal},S_CYBER_RUN8,0,0},  // S_CYBER_RUN7
  {SPR_CYBR,3,3,{A_Chase},S_CYBER_RUN1,0,0},  // S_CYBER_RUN8
  {SPR_CYBR,4,6,{A_FaceTarget},S_CYBER_ATK2,0,0}, // S_CYBER_ATK1
  {SPR_CYBR,5,12,{A_CyberAttack},S_CYBER_ATK3,0,0}, // S_CYBER_ATK2
  {SPR_CYBR,4,12,{A_FaceTarget},S_CYBER_ATK4,0,0},  // S_CYBER_ATK3
  {SPR_CYBR,5,12,{A_CyberAttack},S_CYBER_ATK5,0,0}, // S_CYBER_ATK4
  {SPR_CYBR,4,12,{A_FaceTarget},S_CYBER_ATK6,0,0},  // S_CYBER_ATK5
  {SPR_CYBR,5,12,{A_CyberAttack},S_CYBER_RUN1,0,0}, // S_CYBER_ATK6
  {SPR_CYBR,6,10,{A_Pain},S_CYBER_RUN1,0,0},  // S_CYBER_PAIN
  {SPR_CYBR,7,10,{NULL},S_CYBER_DIE2,0,0},  // S_CYBER_DIE1
  {SPR_CYBR,8,10,{A_Scream},S_CYBER_DIE3,0,0},  // S_CYBER_DIE2
  {SPR_CYBR,9,10,{NULL},S_CYBER_DIE4,0,0},  // S_CYBER_DIE3
  {SPR_CYBR,10,10,{NULL},S_CYBER_DIE5,0,0}, // S_CYBER_DIE4
  {SPR_CYBR,11,10,{NULL},S_CYBER_DIE6,0,0}, // S_CYBER_DIE5
  {SPR_CYBR,12,10,{A_Fall},S_CYBER_DIE7,0,0}, // S_CYBER_DIE6
  {SPR_CYBR,13,10,{NULL},S_CYBER_DIE8,0,0}, // S_CYBER_DIE7
  {SPR_CYBR,14,10,{NULL},S_CYBER_DIE9,0,0}, // S_CYBER_DIE8
  {SPR_CYBR,15,30,{NULL},S_CYBER_DIE10,0,0},  // S_CYBER_DIE9
  {SPR_CYBR,15,-1,{A_BossDeath},S_NULL,0,0},  // S_CYBER_DIE10
  {SPR_PAIN,0,10,{A_Look},S_PAIN_STND,0,0}, // S_PAIN_STND
  {SPR_PAIN,0,3,{A_Chase},S_PAIN_RUN2,0,0}, // S_PAIN_RUN1
  {SPR_PAIN,0,3,{A_Chase},S_PAIN_RUN3,0,0}, // S_PAIN_RUN2
  {SPR_PAIN,1,3,{A_Chase},S_PAIN_RUN4,0,0}, // S_PAIN_RUN3
  {SPR_PAIN,1,3,{A_Chase},S_PAIN_RUN5,0,0}, // S_PAIN_RUN4
  {SPR_PAIN,2,3,{A_Chase},S_PAIN_RUN6,0,0}, // S_PAIN_RUN5
  {SPR_PAIN,2,3,{A_Chase},S_PAIN_RUN1,0,0}, // S_PAIN_RUN6
  {SPR_PAIN,3,5,{A_FaceTarget},S_PAIN_ATK2,0,0},  // S_PAIN_ATK1
  {SPR_PAIN,4,5,{A_FaceTarget},S_PAIN_ATK3,0,0},  // S_PAIN_ATK2
  {SPR_PAIN,32773,5,{A_FaceTarget},S_PAIN_ATK4,0,0},  // S_PAIN_ATK3
  {SPR_PAIN,32773,0,{A_PainAttack},S_PAIN_RUN1,0,0},  // S_PAIN_ATK4
  {SPR_PAIN,6,6,{NULL},S_PAIN_PAIN2,0,0}, // S_PAIN_PAIN
  {SPR_PAIN,6,6,{A_Pain},S_PAIN_RUN1,0,0},  // S_PAIN_PAIN2
  {SPR_PAIN,32775,8,{NULL},S_PAIN_DIE2,0,0},  // S_PAIN_DIE1
  {SPR_PAIN,32776,8,{A_Scream},S_PAIN_DIE3,0,0},  // S_PAIN_DIE2
  {SPR_PAIN,32777,8,{NULL},S_PAIN_DIE4,0,0},  // S_PAIN_DIE3
  {SPR_PAIN,32778,8,{NULL},S_PAIN_DIE5,0,0},  // S_PAIN_DIE4
  {SPR_PAIN,32779,8,{A_PainDie},S_PAIN_DIE6,0,0}, // S_PAIN_DIE5
  {SPR_PAIN,32780,8,{NULL},S_NULL,0,0}, // S_PAIN_DIE6
  {SPR_PAIN,12,8,{NULL},S_PAIN_RAISE2,0,0}, // S_PAIN_RAISE1
  {SPR_PAIN,11,8,{NULL},S_PAIN_RAISE3,0,0}, // S_PAIN_RAISE2
  {SPR_PAIN,10,8,{NULL},S_PAIN_RAISE4,0,0}, // S_PAIN_RAISE3
  {SPR_PAIN,9,8,{NULL},S_PAIN_RAISE5,0,0},  // S_PAIN_RAISE4
  {SPR_PAIN,8,8,{NULL},S_PAIN_RAISE6,0,0},  // S_PAIN_RAISE5
  {SPR_PAIN,7,8,{NULL},S_PAIN_RUN1,0,0},  // S_PAIN_RAISE6
  {SPR_SSWV,0,10,{A_Look},S_SSWV_STND2,0,0},  // S_SSWV_STND
  {SPR_SSWV,1,10,{A_Look},S_SSWV_STND,0,0}, // S_SSWV_STND2
  {SPR_SSWV,0,3,{A_Chase},S_SSWV_RUN2,0,0}, // S_SSWV_RUN1
  {SPR_SSWV,0,3,{A_Chase},S_SSWV_RUN3,0,0}, // S_SSWV_RUN2
  {SPR_SSWV,1,3,{A_Chase},S_SSWV_RUN4,0,0}, // S_SSWV_RUN3
  {SPR_SSWV,1,3,{A_Chase},S_SSWV_RUN5,0,0}, // S_SSWV_RUN4
  {SPR_SSWV,2,3,{A_Chase},S_SSWV_RUN6,0,0}, // S_SSWV_RUN5
  {SPR_SSWV,2,3,{A_Chase},S_SSWV_RUN7,0,0}, // S_SSWV_RUN6
  {SPR_SSWV,3,3,{A_Chase},S_SSWV_RUN8,0,0}, // S_SSWV_RUN7
  {SPR_SSWV,3,3,{A_Chase},S_SSWV_RUN1,0,0}, // S_SSWV_RUN8
  {SPR_SSWV,4,10,{A_FaceTarget},S_SSWV_ATK2,0,0}, // S_SSWV_ATK1
  {SPR_SSWV,5,10,{A_FaceTarget},S_SSWV_ATK3,0,0}, // S_SSWV_ATK2
  {SPR_SSWV,32774,4,{A_CPosAttack},S_SSWV_ATK4,0,0},  // S_SSWV_ATK3
  {SPR_SSWV,5,6,{A_FaceTarget},S_SSWV_ATK5,0,0},  // S_SSWV_ATK4
  {SPR_SSWV,32774,4,{A_CPosAttack},S_SSWV_ATK6,0,0},  // S_SSWV_ATK5
  {SPR_SSWV,5,1,{A_CPosRefire},S_SSWV_ATK2,0,0},  // S_SSWV_ATK6
  {SPR_SSWV,7,3,{NULL},S_SSWV_PAIN2,0,0}, // S_SSWV_PAIN
  {SPR_SSWV,7,3,{A_Pain},S_SSWV_RUN1,0,0},  // S_SSWV_PAIN2
  {SPR_SSWV,8,5,{NULL},S_SSWV_DIE2,0,0},  // S_SSWV_DIE1
  {SPR_SSWV,9,5,{A_Scream},S_SSWV_DIE3,0,0},  // S_SSWV_DIE2
  {SPR_SSWV,10,5,{A_Fall},S_SSWV_DIE4,0,0}, // S_SSWV_DIE3
  {SPR_SSWV,11,5,{NULL},S_SSWV_DIE5,0,0}, // S_SSWV_DIE4
  {SPR_SSWV,12,-1,{NULL},S_NULL,0,0}, // S_SSWV_DIE5
  {SPR_SSWV,13,5,{NULL},S_SSWV_XDIE2,0,0},  // S_SSWV_XDIE1
  {SPR_SSWV,14,5,{A_XScream},S_SSWV_XDIE3,0,0}, // S_SSWV_XDIE2
  {SPR_SSWV,15,5,{A_Fall},S_SSWV_XDIE4,0,0},  // S_SSWV_XDIE3
  {SPR_SSWV,16,5,{NULL},S_SSWV_XDIE5,0,0},  // S_SSWV_XDIE4
  {SPR_SSWV,17,5,{NULL},S_SSWV_XDIE6,0,0},  // S_SSWV_XDIE5
  {SPR_SSWV,18,5,{NULL},S_SSWV_XDIE7,0,0},  // S_SSWV_XDIE6
  {SPR_SSWV,19,5,{NULL},S_SSWV_XDIE8,0,0},  // S_SSWV_XDIE7
  {SPR_SSWV,20,5,{NULL},S_SSWV_XDIE9,0,0},  // S_SSWV_XDIE8
  {SPR_SSWV,21,-1,{NULL},S_NULL,0,0}, // S_SSWV_XDIE9
  {SPR_SSWV,12,5,{NULL},S_SSWV_RAISE2,0,0}, // S_SSWV_RAISE1
  {SPR_SSWV,11,5,{NULL},S_SSWV_RAISE3,0,0}, // S_SSWV_RAISE2
  {SPR_SSWV,10,5,{NULL},S_SSWV_RAISE4,0,0}, // S_SSWV_RAISE3
  {SPR_SSWV,9,5,{NULL},S_SSWV_RAISE5,0,0},  // S_SSWV_RAISE4
  {SPR_SSWV,8,5,{NULL},S_SSWV_RUN1,0,0},  // S_SSWV_RAISE5
  {SPR_KEEN,0,-1,{NULL},S_KEENSTND,0,0},  // S_KEENSTND
  {SPR_KEEN,0,6,{NULL},S_COMMKEEN2,0,0},  // S_COMMKEEN
  {SPR_KEEN,1,6,{NULL},S_COMMKEEN3,0,0},  // S_COMMKEEN2
  {SPR_KEEN,2,6,{A_Scream},S_COMMKEEN4,0,0},  // S_COMMKEEN3
  {SPR_KEEN,3,6,{NULL},S_COMMKEEN5,0,0},  // S_COMMKEEN4
  {SPR_KEEN,4,6,{NULL},S_COMMKEEN6,0,0},  // S_COMMKEEN5
  {SPR_KEEN,5,6,{NULL},S_COMMKEEN7,0,0},  // S_COMMKEEN6
  {SPR_KEEN,6,6,{NULL},S_COMMKEEN8,0,0},  // S_COMMKEEN7
  {SPR_KEEN,7,6,{NULL},S_COMMKEEN9,0,0},  // S_COMMKEEN8
  {SPR_KEEN,8,6,{NULL},S_COMMKEEN10,0,0}, // S_COMMKEEN9
  {SPR_KEEN,9,6,{NULL},S_COMMKEEN11,0,0}, // S_COMMKEEN10
  {SPR_KEEN,10,6,{A_KeenDie},S_COMMKEEN12,0,0},// S_COMMKEEN11
  {SPR_KEEN,11,-1,{NULL},S_NULL,0,0},   // S_COMMKEEN12
  {SPR_KEEN,12,4,{NULL},S_KEENPAIN2,0,0}, // S_KEENPAIN
  {SPR_KEEN,12,8,{A_Pain},S_KEENSTND,0,0},  // S_KEENPAIN2
  {SPR_BBRN,0,-1,{NULL},S_NULL,0,0},    // S_BRAIN
  {SPR_BBRN,1,36,{A_BrainPain},S_BRAIN,0,0},  // S_BRAIN_PAIN
  {SPR_BBRN,0,100,{A_BrainScream},S_BRAIN_DIE2,0,0},  // S_BRAIN_DIE1
  {SPR_BBRN,0,10,{NULL},S_BRAIN_DIE3,0,0},  // S_BRAIN_DIE2
  {SPR_BBRN,0,10,{NULL},S_BRAIN_DIE4,0,0},  // S_BRAIN_DIE3
  {SPR_BBRN,0,-1,{A_BrainDie},S_NULL,0,0},  // S_BRAIN_DIE4
  {SPR_SSWV,0,10,{A_Look},S_BRAINEYE,0,0},  // S_BRAINEYE
  {SPR_SSWV,0,181,{A_BrainAwake},S_BRAINEYE1,0,0},  // S_BRAINEYESEE
  {SPR_SSWV,0,150,{A_BrainSpit},S_BRAINEYE1,0,0}, // S_BRAINEYE1
  {SPR_BOSF,32768,3,{A_SpawnSound},S_SPAWN2,0,0}, // S_SPAWN1
  {SPR_BOSF,32769,3,{A_SpawnFly},S_SPAWN3,0,0}, // S_SPAWN2
  {SPR_BOSF,32770,3,{A_SpawnFly},S_SPAWN4,0,0}, // S_SPAWN3
  {SPR_BOSF,32771,3,{A_SpawnFly},S_SPAWN1,0,0}, // S_SPAWN4
  {SPR_FIRE,32768,4,{A_Fire},S_SPAWNFIRE2,0,0}, // S_SPAWNFIRE1
  {SPR_FIRE,32769,4,{A_Fire},S_SPAWNFIRE3,0,0}, // S_SPAWNFIRE2
  {SPR_FIRE,32770,4,{A_Fire},S_SPAWNFIRE4,0,0}, // S_SPAWNFIRE3
  {SPR_FIRE,32771,4,{A_Fire},S_SPAWNFIRE5,0,0}, // S_SPAWNFIRE4
  {SPR_FIRE,32772,4,{A_Fire},S_SPAWNFIRE6,0,0}, // S_SPAWNFIRE5
  {SPR_FIRE,32773,4,{A_Fire},S_SPAWNFIRE7,0,0}, // S_SPAWNFIRE6
  {SPR_FIRE,32774,4,{A_Fire},S_SPAWNFIRE8,0,0}, // S_SPAWNFIRE7
  {SPR_FIRE,32775,4,{A_Fire},S_NULL,0,0},   // S_SPAWNFIRE8
  {SPR_MISL,32769,10,{NULL},S_BRAINEXPLODE2,0,0}, // S_BRAINEXPLODE1
  {SPR_MISL,32770,10,{NULL},S_BRAINEXPLODE3,0,0}, // S_BRAINEXPLODE2
  {SPR_MISL,32771,10,{A_BrainExplode},S_NULL,0,0},  // S_BRAINEXPLODE3
  {SPR_ARM1,0,6,{NULL},S_ARM1A,0,0},  // S_ARM1
  {SPR_ARM1,32769,7,{NULL},S_ARM1,0,0}, // S_ARM1A
  {SPR_ARM2,0,6,{NULL},S_ARM2A,0,0},  // S_ARM2
  {SPR_ARM2,32769,6,{NULL},S_ARM2,0,0}, // S_ARM2A
  {SPR_BAR1,0,6,{NULL},S_BAR2,0,0}, // S_BAR1
  {SPR_BAR1,1,6,{NULL},S_BAR1,0,0}, // S_BAR2
  {SPR_BEXP,32768,5,{NULL},S_BEXP2,0,0},  // S_BEXP
  {SPR_BEXP,32769,5,{A_Scream},S_BEXP3,0,0},  // S_BEXP2
  {SPR_BEXP,32770,5,{NULL},S_BEXP4,0,0},  // S_BEXP3
  {SPR_BEXP,32771,10,{A_Explode},S_BEXP5,0,0},  // S_BEXP4
  {SPR_BEXP,32772,10,{NULL},S_NULL,0,0},  // S_BEXP5
  {SPR_FCAN,32768,4,{NULL},S_BBAR2,0,0},  // S_BBAR1
  {SPR_FCAN,32769,4,{NULL},S_BBAR3,0,0},  // S_BBAR2
  {SPR_FCAN,32770,4,{NULL},S_BBAR1,0,0},  // S_BBAR3
  {SPR_BON1,0,6,{NULL},S_BON1A,0,0},  // S_BON1
  {SPR_BON1,1,6,{NULL},S_BON1B,0,0},  // S_BON1A
  {SPR_BON1,2,6,{NULL},S_BON1C,0,0},  // S_BON1B
  {SPR_BON1,3,6,{NULL},S_BON1D,0,0},  // S_BON1C
  {SPR_BON1,2,6,{NULL},S_BON1E,0,0},  // S_BON1D
  {SPR_BON1,1,6,{NULL},S_BON1,0,0}, // S_BON1E
  {SPR_BON2,0,6,{NULL},S_BON2A,0,0},  // S_BON2
  {SPR_BON2,1,6,{NULL},S_BON2B,0,0},  // S_BON2A
  {SPR_BON2,2,6,{NULL},S_BON2C,0,0},  // S_BON2B
  {SPR_BON2,3,6,{NULL},S_BON2D,0,0},  // S_BON2C
  {SPR_BON2,2,6,{NULL},S_BON2E,0,0},  // S_BON2D
  {SPR_BON2,1,6,{NULL},S_BON2,0,0}, // S_BON2E
  {SPR_BKEY,0,10,{NULL},S_BKEY2,0,0}, // S_BKEY
  {SPR_BKEY,32769,10,{NULL},S_BKEY,0,0},  // S_BKEY2
  {SPR_RKEY,0,10,{NULL},S_RKEY2,0,0}, // S_RKEY
  {SPR_RKEY,32769,10,{NULL},S_RKEY,0,0},  // S_RKEY2
  {SPR_YKEY,0,10,{NULL},S_YKEY2,0,0}, // S_YKEY
  {SPR_YKEY,32769,10,{NULL},S_YKEY,0,0},  // S_YKEY2
  {SPR_BSKU,0,10,{NULL},S_BSKULL2,0,0}, // S_BSKULL
  {SPR_BSKU,32769,10,{NULL},S_BSKULL,0,0},  // S_BSKULL2
  {SPR_RSKU,0,10,{NULL},S_RSKULL2,0,0}, // S_RSKULL
  {SPR_RSKU,32769,10,{NULL},S_RSKULL,0,0},  // S_RSKULL2
  {SPR_YSKU,0,10,{NULL},S_YSKULL2,0,0}, // S_YSKULL
  {SPR_YSKU,32769,10,{NULL},S_YSKULL,0,0},  // S_YSKULL2
  {SPR_STIM,0,-1,{NULL},S_NULL,0,0},  // S_STIM
  {SPR_MEDI,0,-1,{NULL},S_NULL,0,0},  // S_MEDI
  {SPR_SOUL,32768,6,{NULL},S_SOUL2,0,0},  // S_SOUL
  {SPR_SOUL,32769,6,{NULL},S_SOUL3,0,0},  // S_SOUL2
  {SPR_SOUL,32770,6,{NULL},S_SOUL4,0,0},  // S_SOUL3
  {SPR_SOUL,32771,6,{NULL},S_SOUL5,0,0},  // S_SOUL4
  {SPR_SOUL,32770,6,{NULL},S_SOUL6,0,0},  // S_SOUL5
  {SPR_SOUL,32769,6,{NULL},S_SOUL,0,0}, // S_SOUL6
  {SPR_PINV,32768,6,{NULL},S_PINV2,0,0},  // S_PINV
  {SPR_PINV,32769,6,{NULL},S_PINV3,0,0},  // S_PINV2
  {SPR_PINV,32770,6,{NULL},S_PINV4,0,0},  // S_PINV3
  {SPR_PINV,32771,6,{NULL},S_PINV,0,0}, // S_PINV4
  {SPR_PSTR,32768,-1,{NULL},S_NULL,0,0},  // S_PSTR
  {SPR_PINS,32768,6,{NULL},S_PINS2,0,0},  // S_PINS
  {SPR_PINS,32769,6,{NULL},S_PINS3,0,0},  // S_PINS2
  {SPR_PINS,32770,6,{NULL},S_PINS4,0,0},  // S_PINS3
  {SPR_PINS,32771,6,{NULL},S_PINS,0,0}, // S_PINS4
  {SPR_MEGA,32768,6,{NULL},S_MEGA2,0,0},  // S_MEGA
  {SPR_MEGA,32769,6,{NULL},S_MEGA3,0,0},  // S_MEGA2
  {SPR_MEGA,32770,6,{NULL},S_MEGA4,0,0},  // S_MEGA3
  {SPR_MEGA,32771,6,{NULL},S_MEGA,0,0}, // S_MEGA4
  {SPR_SUIT,32768,-1,{NULL},S_NULL,0,0},  // S_SUIT
  {SPR_PMAP,32768,6,{NULL},S_PMAP2,0,0},  // S_PMAP
  {SPR_PMAP,32769,6,{NULL},S_PMAP3,0,0},  // S_PMAP2
  {SPR_PMAP,32770,6,{NULL},S_PMAP4,0,0},  // S_PMAP3
  {SPR_PMAP,32771,6,{NULL},S_PMAP5,0,0},  // S_PMAP4
  {SPR_PMAP,32770,6,{NULL},S_PMAP6,0,0},  // S_PMAP5
  {SPR_PMAP,32769,6,{NULL},S_PMAP,0,0}, // S_PMAP6
  {SPR_PVIS,32768,6,{NULL},S_PVIS2,0,0},  // S_PVIS
  {SPR_PVIS,1,6,{NULL},S_PVIS,0,0}, // S_PVIS2
  {SPR_CLIP,0,-1,{NULL},S_NULL,0,0},  // S_CLIP
  {SPR_AMMO,0,-1,{NULL},S_NULL,0,0},  // S_AMMO
  {SPR_ROCK,0,-1,{NULL},S_NULL,0,0},  // S_ROCK
  {SPR_BROK,0,-1,{NULL},S_NULL,0,0},  // S_BROK
  {SPR_CELL,0,-1,{NULL},S_NULL,0,0},  // S_CELL
  {SPR_CELP,0,-1,{NULL},S_NULL,0,0},  // S_CELP
  {SPR_SHEL,0,-1,{NULL},S_NULL,0,0},  // S_SHEL
  {SPR_SBOX,0,-1,{NULL},S_NULL,0,0},  // S_SBOX
  {SPR_BPAK,0,-1,{NULL},S_NULL,0,0},  // S_BPAK
  {SPR_BFUG,0,-1,{NULL},S_NULL,0,0},  // S_BFUG
  {SPR_MGUN,0,-1,{NULL},S_NULL,0,0},  // S_MGUN
  {SPR_CSAW,0,-1,{NULL},S_NULL,0,0},  // S_CSAW
  {SPR_LAUN,0,-1,{NULL},S_NULL,0,0},  // S_LAUN
  {SPR_PLAS,0,-1,{NULL},S_NULL,0,0},  // S_PLAS
  {SPR_SHOT,0,-1,{NULL},S_NULL,0,0},  // S_SHOT
  {SPR_SGN2,0,-1,{NULL},S_NULL,0,0},  // S_SHOT2
  {SPR_COLU,32768,-1,{NULL},S_NULL,0,0},  // S_COLU
  {SPR_SMT2,0,-1,{NULL},S_NULL,0,0},  // S_STALAG
  {SPR_GOR1,0,10,{NULL},S_BLOODYTWITCH2,0,0}, // S_BLOODYTWITCH
  {SPR_GOR1,1,15,{NULL},S_BLOODYTWITCH3,0,0}, // S_BLOODYTWITCH2
  {SPR_GOR1,2,8,{NULL},S_BLOODYTWITCH4,0,0},  // S_BLOODYTWITCH3
  {SPR_GOR1,1,6,{NULL},S_BLOODYTWITCH,0,0}, // S_BLOODYTWITCH4
  {SPR_PLAY,13,-1,{NULL},S_NULL,0,0}, // S_DEADTORSO
  {SPR_PLAY,18,-1,{NULL},S_NULL,0,0}, // S_DEADBOTTOM
  {SPR_POL2,0,-1,{NULL},S_NULL,0,0},  // S_HEADSONSTICK
  {SPR_POL5,0,-1,{NULL},S_NULL,0,0},  // S_GIBS
  {SPR_POL4,0,-1,{NULL},S_NULL,0,0},  // S_HEADONASTICK
  {SPR_POL3,32768,6,{NULL},S_HEADCANDLES2,0,0}, // S_HEADCANDLES
  {SPR_POL3,32769,6,{NULL},S_HEADCANDLES,0,0},  // S_HEADCANDLES2
  {SPR_POL1,0,-1,{NULL},S_NULL,0,0},  // S_DEADSTICK
  {SPR_POL6,0,6,{NULL},S_LIVESTICK2,0,0}, // S_LIVESTICK
  {SPR_POL6,1,8,{NULL},S_LIVESTICK,0,0},  // S_LIVESTICK2
  {SPR_GOR2,0,-1,{NULL},S_NULL,0,0},  // S_MEAT2
  {SPR_GOR3,0,-1,{NULL},S_NULL,0,0},  // S_MEAT3
  {SPR_GOR4,0,-1,{NULL},S_NULL,0,0},  // S_MEAT4
  {SPR_GOR5,0,-1,{NULL},S_NULL,0,0},  // S_MEAT5
  {SPR_SMIT,0,-1,{NULL},S_NULL,0,0},  // S_STALAGTITE
  {SPR_COL1,0,-1,{NULL},S_NULL,0,0},  // S_TALLGRNCOL
  {SPR_COL2,0,-1,{NULL},S_NULL,0,0},  // S_SHRTGRNCOL
  {SPR_COL3,0,-1,{NULL},S_NULL,0,0},  // S_TALLREDCOL
  {SPR_COL4,0,-1,{NULL},S_NULL,0,0},  // S_SHRTREDCOL
  {SPR_CAND,32768,-1,{NULL},S_NULL,0,0},  // S_CANDLESTIK
  {SPR_CBRA,32768,-1,{NULL},S_NULL,0,0},  // S_CANDELABRA
  {SPR_COL6,0,-1,{NULL},S_NULL,0,0},  // S_SKULLCOL
  {SPR_TRE1,0,-1,{NULL},S_NULL,0,0},  // S_TORCHTREE
  {SPR_TRE2,0,-1,{NULL},S_NULL,0,0},  // S_BIGTREE
  {SPR_ELEC,0,-1,{NULL},S_NULL,0,0},  // S_TECHPILLAR
  {SPR_CEYE,32768,6,{NULL},S_EVILEYE2,0,0}, // S_EVILEYE
  {SPR_CEYE,32769,6,{NULL},S_EVILEYE3,0,0}, // S_EVILEYE2
  {SPR_CEYE,32770,6,{NULL},S_EVILEYE4,0,0}, // S_EVILEYE3
  {SPR_CEYE,32769,6,{NULL},S_EVILEYE,0,0},  // S_EVILEYE4
  {SPR_FSKU,32768,6,{NULL},S_FLOATSKULL2,0,0},  // S_FLOATSKULL
  {SPR_FSKU,32769,6,{NULL},S_FLOATSKULL3,0,0},  // S_FLOATSKULL2
  {SPR_FSKU,32770,6,{NULL},S_FLOATSKULL,0,0}, // S_FLOATSKULL3
  {SPR_COL5,0,14,{NULL},S_HEARTCOL2,0,0}, // S_HEARTCOL
  {SPR_COL5,1,14,{NULL},S_HEARTCOL,0,0},  // S_HEARTCOL2
  {SPR_TBLU,32768,4,{NULL},S_BLUETORCH2,0,0}, // S_BLUETORCH
  {SPR_TBLU,32769,4,{NULL},S_BLUETORCH3,0,0}, // S_BLUETORCH2
  {SPR_TBLU,32770,4,{NULL},S_BLUETORCH4,0,0}, // S_BLUETORCH3
  {SPR_TBLU,32771,4,{NULL},S_BLUETORCH,0,0},  // S_BLUETORCH4
  {SPR_TGRN,32768,4,{NULL},S_GREENTORCH2,0,0},  // S_GREENTORCH
  {SPR_TGRN,32769,4,{NULL},S_GREENTORCH3,0,0},  // S_GREENTORCH2
  {SPR_TGRN,32770,4,{NULL},S_GREENTORCH4,0,0},  // S_GREENTORCH3
  {SPR_TGRN,32771,4,{NULL},S_GREENTORCH,0,0}, // S_GREENTORCH4
  {SPR_TRED,32768,4,{NULL},S_REDTORCH2,0,0},  // S_REDTORCH
  {SPR_TRED,32769,4,{NULL},S_REDTORCH3,0,0},  // S_REDTORCH2
  {SPR_TRED,32770,4,{NULL},S_REDTORCH4,0,0},  // S_REDTORCH3
  {SPR_TRED,32771,4,{NULL},S_REDTORCH,0,0}, // S_REDTORCH4
  {SPR_SMBT,32768,4,{NULL},S_BTORCHSHRT2,0,0},  // S_BTORCHSHRT
  {SPR_SMBT,32769,4,{NULL},S_BTORCHSHRT3,0,0},  // S_BTORCHSHRT2
  {SPR_SMBT,32770,4,{NULL},S_BTORCHSHRT4,0,0},  // S_BTORCHSHRT3
  {SPR_SMBT,32771,4,{NULL},S_BTORCHSHRT,0,0}, // S_BTORCHSHRT4
  {SPR_SMGT,32768,4,{NULL},S_GTORCHSHRT2,0,0},  // S_GTORCHSHRT
  {SPR_SMGT,32769,4,{NULL},S_GTORCHSHRT3,0,0},  // S_GTORCHSHRT2
  {SPR_SMGT,32770,4,{NULL},S_GTORCHSHRT4,0,0},  // S_GTORCHSHRT3
  {SPR_SMGT,32771,4,{NULL},S_GTORCHSHRT,0,0}, // S_GTORCHSHRT4
  {SPR_SMRT,32768,4,{NULL},S_RTORCHSHRT2,0,0},  // S_RTORCHSHRT
  {SPR_SMRT,32769,4,{NULL},S_RTORCHSHRT3,0,0},  // S_RTORCHSHRT2
  {SPR_SMRT,32770,4,{NULL},S_RTORCHSHRT4,0,0},  // S_RTORCHSHRT3
  {SPR_SMRT,32771,4,{NULL},S_RTORCHSHRT,0,0}, // S_RTORCHSHRT4
  {SPR_HDB1,0,-1,{NULL},S_NULL,0,0},  // S_HANGNOGUTS
  {SPR_HDB2,0,-1,{NULL},S_NULL,0,0},  // S_HANGBNOBRAIN
  {SPR_HDB3,0,-1,{NULL},S_NULL,0,0},  // S_HANGTLOOKDN
  {SPR_HDB4,0,-1,{NULL},S_NULL,0,0},  // S_HANGTSKULL
  {SPR_HDB5,0,-1,{NULL},S_NULL,0,0},  // S_HANGTLOOKUP
  {SPR_HDB6,0,-1,{NULL},S_NULL,0,0},  // S_HANGTNOBRAIN
  {SPR_POB1,0,-1,{NULL},S_NULL,0,0},  // S_COLONGIBS
  {SPR_POB2,0,-1,{NULL},S_NULL,0,0},  // S_SMALLPOOL
  {SPR_BRS1,0,-1,{NULL},S_NULL,0,0},    // S_BRAINSTEM
  {SPR_TLMP,32768,4,{NULL},S_TECHLAMP2,0,0},  // S_TECHLAMP
  {SPR_TLMP,32769,4,{NULL},S_TECHLAMP3,0,0},  // S_TECHLAMP2
  {SPR_TLMP,32770,4,{NULL},S_TECHLAMP4,0,0},  // S_TECHLAMP3
  {SPR_TLMP,32771,4,{NULL},S_TECHLAMP,0,0},   // S_TECHLAMP4
  {SPR_TLP2,32768,4,{NULL},S_TECH2LAMP2,0,0}, // S_TECH2LAMP
  {SPR_TLP2,32769,4,{NULL},S_TECH2LAMP3,0,0}, // S_TECH2LAMP2
  {SPR_TLP2,32770,4,{NULL},S_TECH2LAMP4,0,0}, // S_TECH2LAMP3
  {SPR_TLP2,32771,4,{NULL},S_TECH2LAMP,0,0},  // S_TECH2LAMP4
  {SPR_TNT1,0,-1,{NULL},S_TNT1,0,0},          // S_TNT1    // phares 3/8/98
};

// ********************************************************************
// Object "Thing" definitions
// ********************************************************************
// Now we get to the actual objects and their characteristics.  If
// you've seen Dehacked, much of this is where the Bits are set,
// commented below as "flags", as well as where you wire in which
// frames are the beginning frames for near and far attack, death,
// and such.  Sounds are hooked in here too, as well as how much
// mass, speed and so forth a Thing has.  Everything you ever wanted
// to know...
//
// Like all this other stuff, the MT_* entries are enumerated in info.h
//
// Note that these are all just indices of the elements involved, and
// not real pointers to them.  For example, the player's death sequence
// is S_PLAY_DIE1, which just evaluates to the index in the states[]
// array above, which actually knows what happens then and what the
// sprite looks like, if it makes noise or not, etc.
//
// Additional comments about each of the entries are located in info.h
// next to the mobjinfo_t structure definition.
//
// This goes on for the next 3000+ lines...

mobjinfo_t mobjinfo[NUMMOBJTYPES] = {
  {   // MT_PLAYER
    -1,   // doomednum
    S_PLAY,   // spawnstate
    100,    // spawnhealth
    S_PLAY_RUN1,    // seestate
    sfx_None,   // seesound
    0,    // reactiontime
    sfx_None,   // attacksound
    S_PLAY_PAIN,    // painstate
    255,    // painchance
    sfx_plpain,   // painsound
    S_NULL,   // meleestate
    S_PLAY_ATK1,    // missilestate
    S_PLAY_DIE1,    // deathstate
    S_PLAY_XDIE1,   // xdeathstate
    sfx_pldeth,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_DROPOFF|MF_PICKUP|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_POSSESSED
    3004,   // doomednum
    S_POSS_STND,    // spawnstate
    20,   // spawnhealth
    S_POSS_RUN1,    // seestate
    sfx_posit1,   // seesound
    8,    // reactiontime
    sfx_pistol,   // attacksound
    S_POSS_PAIN,    // painstate
    200,    // painchance
    sfx_popain,   // painsound
    0,    // meleestate
    S_POSS_ATK1,    // missilestate
    S_POSS_DIE1,    // deathstate
    S_POSS_XDIE1,   // xdeathstate
    sfx_podth1,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_posact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_POSS_RAISE1   // raisestate
  },
  
  {   // MT_SHOTGUY
    9,    // doomednum
    S_SPOS_STND,    // spawnstate
    30,   // spawnhealth
    S_SPOS_RUN1,    // seestate
    sfx_posit2,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_SPOS_PAIN,    // painstate
    170,    // painchance
    sfx_popain,   // painsound
    0,    // meleestate
    S_SPOS_ATK1,    // missilestate
    S_SPOS_DIE1,    // deathstate
    S_SPOS_XDIE1,   // xdeathstate
    sfx_podth2,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_posact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_SPOS_RAISE1   // raisestate
  },
  
  {   // MT_VILE
    64,   // doomednum
    S_VILE_STND,    // spawnstate
    700,    // spawnhealth
    S_VILE_RUN1,    // seestate
    sfx_vilsit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_VILE_PAIN,    // painstate
    10,   // painchance
    sfx_vipain,   // painsound
    0,    // meleestate
    S_VILE_ATK1,    // missilestate
    S_VILE_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_vildth,   // deathsound
    15,   // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    500,    // mass
    0,    // damage
    sfx_vilact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_FIRE
    -1,   // doomednum
    S_FIRE1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT,   // flags  // killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_UNDEAD
    66,   // doomednum
    S_SKEL_STND,    // spawnstate
    300,    // spawnhealth
    S_SKEL_RUN1,    // seestate
    sfx_skesit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_SKEL_PAIN,    // painstate
    100,    // painchance
    sfx_popain,   // painsound
    S_SKEL_FIST1,   // meleestate
    S_SKEL_MISS1,   // missilestate
    S_SKEL_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_skedth,   // deathsound
    10,   // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    500,    // mass
    0,    // damage
    sfx_skeact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_SKEL_RAISE1   // raisestate
  },
  
  {   // MT_TRACER
    -1,   // doomednum
    S_TRACER,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_skeatk,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_TRACEEXP1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_barexp,   // deathsound
    10*FRACUNIT,    // speed
    11*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    10,   // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_SMOKE
    -1,   // doomednum
    S_SMOKE1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT,   // flags             // phares
    S_NULL    // raisestate
  },
  
  {   // MT_FATSO
    67,   // doomednum
    S_FATT_STND,    // spawnstate
    600,    // spawnhealth
    S_FATT_RUN1,    // seestate
    sfx_mansit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_FATT_PAIN,    // painstate
    80,   // painchance
    sfx_mnpain,   // painsound
    0,    // meleestate
    S_FATT_ATK1,    // missilestate
    S_FATT_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_mandth,   // deathsound
    8,    // speed
    48*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    1000,   // mass
    0,    // damage
    sfx_posact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_FATT_RAISE1   // raisestate
  },
  
  {   // MT_FATSHOT
    -1,   // doomednum
    S_FATSHOT1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_firsht,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_FATSHOTX1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    20*FRACUNIT,    // speed
    6*FRACUNIT,   // radius
    8*FRACUNIT,   // height
    100,    // mass
    8,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT,   // flags \\ killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_CHAINGUY
    65,   // doomednum
    S_CPOS_STND,    // spawnstate
    70,   // spawnhealth
    S_CPOS_RUN1,    // seestate
    sfx_posit2,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_CPOS_PAIN,    // painstate
    170,    // painchance
    sfx_popain,   // painsound
    0,    // meleestate
    S_CPOS_ATK1,    // missilestate
    S_CPOS_DIE1,    // deathstate
    S_CPOS_XDIE1,   // xdeathstate
    sfx_podth2,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_posact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_CPOS_RAISE1   // raisestate
  },
  
  {   // MT_TROOP
    3001,   // doomednum
    S_TROO_STND,    // spawnstate
    60,   // spawnhealth
    S_TROO_RUN1,    // seestate
    sfx_bgsit1,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_TROO_PAIN,    // painstate
    200,    // painchance
    sfx_popain,   // painsound
    S_TROO_ATK1,    // meleestate
    S_TROO_ATK1,    // missilestate
    S_TROO_DIE1,    // deathstate
    S_TROO_XDIE1,   // xdeathstate
    sfx_bgdth1,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_bgact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL, // killough |MF_TRANSLUCENT,   // flags     // phares
    S_TROO_RAISE1   // raisestate
  },
  
  {   // MT_SERGEANT
    3002,   // doomednum
    S_SARG_STND,    // spawnstate
    150,    // spawnhealth
    S_SARG_RUN1,    // seestate
    sfx_sgtsit,   // seesound
    8,    // reactiontime
    sfx_sgtatk,   // attacksound
    S_SARG_PAIN,    // painstate
    180,    // painchance
    sfx_dmpain,   // painsound
    S_SARG_ATK1,    // meleestate
    0,    // missilestate
    S_SARG_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_sgtdth,   // deathsound
    10,   // speed
    30*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_SARG_RAISE1   // raisestate
  },
  
  {   // MT_SHADOWS
    58,   // doomednum
    S_SARG_STND,    // spawnstate
    150,    // spawnhealth
    S_SARG_RUN1,    // seestate
    sfx_sgtsit,   // seesound
    8,    // reactiontime
    sfx_sgtatk,   // attacksound
    S_SARG_PAIN,    // painstate
    180,    // painchance
    sfx_dmpain,   // painsound
    S_SARG_ATK1,    // meleestate
    0,    // missilestate
    S_SARG_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_sgtdth,   // deathsound
    10,   // speed
    30*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_SHADOW|MF_COUNTKILL,   // flags
    S_SARG_RAISE1   // raisestate
  },
  
  {   // MT_HEAD
    3005,   // doomednum
    S_HEAD_STND,    // spawnstate
    400,    // spawnhealth
    S_HEAD_RUN1,    // seestate
    sfx_cacsit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_HEAD_PAIN,    // painstate
    128,    // painchance
    sfx_dmpain,   // painsound
    0,    // meleestate
    S_HEAD_ATK1,    // missilestate
    S_HEAD_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_cacdth,   // deathsound
    8,    // speed
    31*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_FLOAT|MF_NOGRAVITY|MF_COUNTKILL,   // flags
    S_HEAD_RAISE1   // raisestate
  },
  
  {   // MT_BRUISER
    3003,   // doomednum
    S_BOSS_STND,    // spawnstate
    1000,   // spawnhealth
    S_BOSS_RUN1,    // seestate
    sfx_brssit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_BOSS_PAIN,    // painstate
    50,   // painchance
    sfx_dmpain,   // painsound
    S_BOSS_ATK1,    // meleestate
    S_BOSS_ATK1,    // missilestate
    S_BOSS_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_brsdth,   // deathsound
    8,    // speed
    24*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    1000,   // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_BOSS_RAISE1   // raisestate
  },
  
  {   // MT_BRUISERSHOT
    -1,   // doomednum
    S_BRBALL1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_firsht,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_BRBALLX1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    15*FRACUNIT,   // speed
    6*FRACUNIT,   // radius
    8*FRACUNIT,   // height
    100,    // mass
    8,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT,   // flags  killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_KNIGHT
    69,   // doomednum
    S_BOS2_STND,    // spawnstate
    500,    // spawnhealth
    S_BOS2_RUN1,    // seestate
    sfx_kntsit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_BOS2_PAIN,    // painstate
    50,   // painchance
    sfx_dmpain,   // painsound
    S_BOS2_ATK1,    // meleestate
    S_BOS2_ATK1,    // missilestate
    S_BOS2_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_kntdth,   // deathsound
    8,    // speed
    24*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    1000,   // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_BOS2_RAISE1   // raisestate
  },
  
  {   // MT_SKULL
    3006,   // doomednum
    S_SKULL_STND,   // spawnstate
    100,    // spawnhealth
    S_SKULL_RUN1,   // seestate
    0,    // seesound
    8,    // reactiontime
    sfx_sklatk,   // attacksound
    S_SKULL_PAIN,   // painstate
    256,    // painchance
    sfx_dmpain,   // painsound
    0,    // meleestate
    S_SKULL_ATK1,   // missilestate
    S_SKULL_DIE1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    8,    // speed
    16*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    50,   // mass
    3,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_FLOAT|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_SPIDER
    7,    // doomednum
    S_SPID_STND,    // spawnstate
    3000,   // spawnhealth
    S_SPID_RUN1,    // seestate
    sfx_spisit,   // seesound
    8,    // reactiontime
    sfx_shotgn,   // attacksound
    S_SPID_PAIN,    // painstate
    40,   // painchance
    sfx_dmpain,   // painsound
    0,    // meleestate
    S_SPID_ATK1,    // missilestate
    S_SPID_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_spidth,   // deathsound
    12,   // speed
    128*FRACUNIT,   // radius
    100*FRACUNIT,   // height
    1000,   // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_BABY
    68,   // doomednum
    S_BSPI_STND,    // spawnstate
    500,    // spawnhealth
    S_BSPI_SIGHT,   // seestate
    sfx_bspsit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_BSPI_PAIN,    // painstate
    128,    // painchance
    sfx_dmpain,   // painsound
    0,    // meleestate
    S_BSPI_ATK1,    // missilestate
    S_BSPI_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_bspdth,   // deathsound
    12,   // speed
    64*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    600,    // mass
    0,    // damage
    sfx_bspact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_BSPI_RAISE1   // raisestate
  },
  
  {   // MT_CYBORG
    16,   // doomednum
    S_CYBER_STND,   // spawnstate
    4000,   // spawnhealth
    S_CYBER_RUN1,   // seestate
    sfx_cybsit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_CYBER_PAIN,   // painstate
    20,   // painchance
    sfx_dmpain,   // painsound
    0,    // meleestate
    S_CYBER_ATK1,   // missilestate
    S_CYBER_DIE1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_cybdth,   // deathsound
    16,   // speed
    40*FRACUNIT,    // radius
    110*FRACUNIT,   // height
    1000,   // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_PAIN
    71,   // doomednum
    S_PAIN_STND,    // spawnstate
    400,    // spawnhealth
    S_PAIN_RUN1,    // seestate
    sfx_pesit,    // seesound
    8,    // reactiontime
    0,    // attacksound
    S_PAIN_PAIN,    // painstate
    128,    // painchance
    sfx_pepain,   // painsound
    0,    // meleestate
    S_PAIN_ATK1,    // missilestate
    S_PAIN_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_pedth,    // deathsound
    8,    // speed
    31*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_FLOAT|MF_NOGRAVITY|MF_COUNTKILL,   // flags
    S_PAIN_RAISE1   // raisestate
  },
  
  {   // MT_WOLFSS
    84,   // doomednum
    S_SSWV_STND,    // spawnstate
    50,   // spawnhealth
    S_SSWV_RUN1,    // seestate
    sfx_sssit,    // seesound
    8,    // reactiontime
    0,    // attacksound
    S_SSWV_PAIN,    // painstate
    170,    // painchance
    sfx_popain,   // painsound
    0,    // meleestate
    S_SSWV_ATK1,    // missilestate
    S_SSWV_DIE1,    // deathstate
    S_SSWV_XDIE1,   // xdeathstate
    sfx_ssdth,    // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_posact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_SSWV_RAISE1   // raisestate
  },
  
  {   // MT_KEEN
    72,   // doomednum
    S_KEENSTND,   // spawnstate
    100,    // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_KEENPAIN,   // painstate
    256,    // painchance
    sfx_keenpn,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_COMMKEEN,   // deathstate
    S_NULL,   // xdeathstate
    sfx_keendt,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    72*FRACUNIT,    // height
    10000000,   // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY|MF_SHOOTABLE|MF_COUNTKILL,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_BOSSBRAIN
    88,   // doomednum
    S_BRAIN,    // spawnstate
    250,    // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_BRAIN_PAIN,   // painstate
    255,    // painchance
    sfx_bospn,    // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_BRAIN_DIE1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_bosdth,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    10000000,   // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_BOSSSPIT
    89,   // doomednum
    S_BRAINEYE,   // spawnstate
    1000,   // spawnhealth
    S_BRAINEYESEE,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    32*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOSECTOR,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_BOSSTARGET
    87,   // doomednum
    S_NULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    32*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOSECTOR,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_SPAWNSHOT
    -1,   // doomednum
    S_SPAWN1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_bospit,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    10*FRACUNIT,    // speed
    6*FRACUNIT,   // radius
    32*FRACUNIT,    // height
    100,    // mass
    3,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_NOCLIP,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_SPAWNFIRE
    -1,   // doomednum
    S_SPAWNFIRE1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT,   // flags             // phares
    S_NULL    // raisestate
  },
  
  {   // MT_BARREL
    2035,   // doomednum
    S_BAR1,   // spawnstate
    20,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_BEXP,   // deathstate
    S_NULL,   // xdeathstate
    sfx_barexp,   // deathsound
    0,    // speed
    10*FRACUNIT,    // radius
    42*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_NOBLOOD,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_TROOPSHOT
    -1,   // doomednum
    S_TBALL1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_firsht,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_TBALLX1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    10*FRACUNIT,    // speed
    6*FRACUNIT,   // radius
    8*FRACUNIT,   // height
    100,    // mass
    3,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_HEADSHOT
    -1,   // doomednum
    S_RBALL1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_firsht,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_RBALLX1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    10*FRACUNIT,    // speed
    6*FRACUNIT,   // radius
    8*FRACUNIT,   // height
    100,    // mass
    5,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_ROCKET
    -1,   // doomednum
    S_ROCKET,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_rlaunc,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_EXPLODE1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_barexp,   // deathsound
    20*FRACUNIT,    // speed
    11*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    20,   // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },

  {   // MT_PLASMA
    -1,   // doomednum
    S_PLASBALL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_plasma,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_PLASEXP,    // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    25*FRACUNIT,    // speed
    13*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    10,    // mass
    2,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },

  {   // MT_BFG
    -1,   // doomednum
    S_BFGSHOT,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    0,    // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_BFGLAND,    // deathstate
    S_NULL,   // xdeathstate
    sfx_rxplod,   // deathsound
    25*FRACUNIT,    // speed
    13*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    16,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_ARACHPLAZ
    -1,   // doomednum
    S_ARACH_PLAZ,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_plasma,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_ARACH_PLEX,   // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    25*FRACUNIT,    // speed
    13*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    5,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_PUFF
    -1,   // doomednum
    S_PUFF1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_BLOOD
    -1,   // doomednum
    S_BLOOD1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_TFOG
    -1,   // doomednum
    S_TFOG,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_IFOG
    -1,   // doomednum
    S_IFOG,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_TELEPORTMAN
    14,   // doomednum
    S_NULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOSECTOR,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_EXTRABFG
    -1,   // doomednum
    S_BFGEXP,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC0
    2018,   // doomednum
    S_ARM1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC1
    2019,   // doomednum
    S_ARM2,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC2
    2014,   // doomednum
    S_BON1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC3
    2015,   // doomednum
    S_BON2,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC4
    5,    // doomednum
    S_BKEY,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC5
    13,   // doomednum
    S_RKEY,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC6
    6,    // doomednum
    S_YKEY,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC7
    39,   // doomednum
    S_YSKULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC8
    38,   // doomednum
    S_RSKULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC9
    40,   // doomednum
    S_BSKULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC10
    2011,   // doomednum
    S_STIM,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC11
    2012,   // doomednum
    S_MEDI,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC12
    2013,   // doomednum
    S_SOUL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM|MF_TRANSLUCENT,    // flags   // killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_INV
    2022,   // doomednum
    S_PINV,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM|MF_TRANSLUCENT,    // flags // killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_MISC13
    2023,   // doomednum
    S_PSTR,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_INS
    2024,   // doomednum
    S_PINS,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM|MF_TRANSLUCENT,    // flags // killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_MISC14
    2025,   // doomednum
    S_SUIT,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC15
    2026,   // doomednum
    S_PMAP,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC16
    2045,   // doomednum
    S_PVIS,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MEGA
    83,   // doomednum
    S_MEGA,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM|MF_TRANSLUCENT,    // flags // killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_CLIP
    2007,   // doomednum
    S_CLIP,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC17
    2048,   // doomednum
    S_AMMO,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC18
    2010,   // doomednum
    S_ROCK,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC19
    2046,   // doomednum
    S_BROK,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC20
    2047,   // doomednum
    S_CELL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC21
    17,   // doomednum
    S_CELP,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC22
    2008,   // doomednum
    S_SHEL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC23
    2049,   // doomednum
    S_SBOX,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC24
    8,    // doomednum
    S_BPAK,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC25
    2006,   // doomednum
    S_BFUG,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_CHAINGUN
    2002,   // doomednum
    S_MGUN,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC26
    2005,   // doomednum
    S_CSAW,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC27
    2003,   // doomednum
    S_LAUN,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC28
    2004,   // doomednum
    S_PLAS,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_SHOTGUN
    2001,   // doomednum
    S_SHOT,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_SUPERSHOTGUN
    82,   // doomednum
    S_SHOT2,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC29
    85,   // doomednum
    S_TECHLAMP,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC30
    86,   // doomednum
    S_TECH2LAMP,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC31
    2028,   // doomednum
    S_COLU,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC32
    30,   // doomednum
    S_TALLGRNCOL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC33
    31,   // doomednum
    S_SHRTGRNCOL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC34
    32,   // doomednum
    S_TALLREDCOL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC35
    33,   // doomednum
    S_SHRTREDCOL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC36
    37,   // doomednum
    S_SKULLCOL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC37
    36,   // doomednum
    S_HEARTCOL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC38
    41,   // doomednum
    S_EVILEYE,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC39
    42,   // doomednum
    S_FLOATSKULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC40
    43,   // doomednum
    S_TORCHTREE,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC41
    44,   // doomednum
    S_BLUETORCH,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC42
    45,   // doomednum
    S_GREENTORCH,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC43
    46,   // doomednum
    S_REDTORCH,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC44
    55,   // doomednum
    S_BTORCHSHRT,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC45
    56,   // doomednum
    S_GTORCHSHRT,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC46
    57,   // doomednum
    S_RTORCHSHRT,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC47
    47,   // doomednum
    S_STALAGTITE,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC48
    48,   // doomednum
    S_TECHPILLAR,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC49
    34,   // doomednum
    S_CANDLESTIK,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC50
    35,   // doomednum
    S_CANDELABRA,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC51
    49,   // doomednum
    S_BLOODYTWITCH,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    68*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC52
    50,   // doomednum
    S_MEAT2,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    84*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC53
    51,   // doomednum
    S_MEAT3,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    84*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC54
    52,   // doomednum
    S_MEAT4,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    68*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC55
    53,   // doomednum
    S_MEAT5,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    52*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC56
    59,   // doomednum
    S_MEAT2,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    84*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC57
    60,   // doomednum
    S_MEAT4,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    68*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC58
    61,   // doomednum
    S_MEAT3,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    52*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC59
    62,   // doomednum
    S_MEAT5,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    52*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC60
    63,   // doomednum
    S_BLOODYTWITCH,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    68*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC61
    22,   // doomednum
    S_HEAD_DIE6,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC62
    15,   // doomednum
    S_PLAY_DIE7,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC63
    18,   // doomednum
    S_POSS_DIE5,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC64
    21,   // doomednum
    S_SARG_DIE6,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC65
    23,   // doomednum
    S_SKULL_DIE6,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC66
    20,   // doomednum
    S_TROO_DIE5,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC67
    19,   // doomednum
    S_SPOS_DIE5,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC68
    10,   // doomednum
    S_PLAY_XDIE9,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC69
    12,   // doomednum
    S_PLAY_XDIE9,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC70
    28,   // doomednum
    S_HEADSONSTICK,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC71
    24,   // doomednum
    S_GIBS,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC72
    27,   // doomednum
    S_HEADONASTICK,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC73
    29,   // doomednum
    S_HEADCANDLES,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC74
    25,   // doomednum
    S_DEADSTICK,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC75
    26,   // doomednum
    S_LIVESTICK,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC76
    54,   // doomednum
    S_BIGTREE,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    32*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC77
    70,   // doomednum
    S_BBAR1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC78
    73,   // doomednum
    S_HANGNOGUTS,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    88*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC79
    74,   // doomednum
    S_HANGBNOBRAIN,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    88*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC80
    75,   // doomednum
    S_HANGTLOOKDN,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC81
    76,   // doomednum
    S_HANGTSKULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC82
    77,   // doomednum
    S_HANGTLOOKUP,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC83
    78,   // doomednum
    S_HANGTNOBRAIN,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC84
    79,   // doomednum
    S_COLONGIBS,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC85
    80,   // doomednum
    S_SMALLPOOL,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC86
    81,   // doomednum
    S_BRAINSTEM,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,    // flags
    S_NULL    // raisestate
  },

  // For use with wind and current effects
  {   // MT_PUSH                       // phares
    5001,           // doomednum       //   |      //jff 5/11/98 deconflict
    S_TNT1,         // spawnstate      //   V      // with DOSDoom        
    1000,           // spawnhealth                              
    S_NULL,         // seestate                                 
    sfx_None,       // seesound                                 
    8,              // reactiontime                             
    sfx_None,       // attacksound                              
    S_NULL,         // painstate                                
    0,              // painchance                               
    sfx_None,       // painsound                                
    S_NULL,         // meleestate                               
    S_NULL,         // missilestate                             
    S_NULL,         // deathstate                               
    S_NULL,         // xdeathstate                              
    sfx_None,       // deathsound                               
    0,              // speed                                    
    8,              // radius                                   
    8,              // height                                   
    10,             // mass                                     
    0,              // damage                                   
    sfx_None,       // activesound                              
    MF_NOBLOCKMAP,  // flags
    S_NULL          // raisestate                                   
  },

  // For use with wind and current effects
  {   // MT_PULL
    5002,           // doomednum                   //jff 5/11/98 deconflict            
    S_TNT1,         // spawnstate                  // with DOSDoom        
    1000,           // spawnhealth                              
    S_NULL,         // seestate                                 
    sfx_None,       // seesound                                 
    8,              // reactiontime                             
    sfx_None,       // attacksound                              
    S_NULL,         // painstate                                
    0,              // painchance                               
    sfx_None,       // painsound                                
    S_NULL,         // meleestate                               
    S_NULL,         // missilestate                             
    S_NULL,         // deathstate                               
    S_NULL,         // xdeathstate                              
    sfx_None,       // deathsound                               
    0,              // speed                                    
    8,              // radius                                   
    8,              // height                                   
    10,             // mass                                     
    0,              // damage                                   
    sfx_None,       // activesound                              
    MF_NOBLOCKMAP,  // flags
    S_NULL          // raisestate                                   
  }
};


// ********************************************************************
// Predefined lumps
// ********************************************************************
// These are internally defined lumps, which can be overwritten in 
// a PWAD.  There were several things that needed these, such 
// as new menus, font characters, color maps, etc. and this
// is an easy way of incorporating them directly into the EXE rather
// than requiring that an ancillary file be carried around with it.
//
// Near the end of this section there is the actual list where the lumps
// are incorporated, and there it's easy to see explanations in context.

// killough 1/31/98: predefined lumps used to make up for wad deficiencies

// Horizontal Sensitivity menu
static const char m_horsen[]={
0,1,16,0,0,0,0,0,8,4,0,0,25,4,0,0,42,4,0,0,59,4,0,0,76,4,0,0,93,4,0,0,110,4,0,
0,119,4,0,0,128,4,0,0,137,4,0,0,154,4,0,0,171,4,0,0,188,4,0,0,205,4,0,0,222,4,
0,0,239,4,0,0,252,4,0,0,11,5,0,0,26,5,0,0,43,5,0,0,60,5,0,0,77,5,0,0,94,5,0,0,
111,5,0,0,128,5,0,0,145,5,0,0,162,5,0,0,179,5,0,0,194,5,0,0,209,5,0,0,222,5,0,
0,239,5,0,0,0,6,0,0,17,6,0,0,34,6,0,0,51,6,0,0,68,6,0,0,81,6,0,0,94,6,0,0,107,
6,0,0,124,6,0,0,141,6,0,0,158,6,0,0,175,6,0,0,191,6,0,0,208,6,0,0,225,6,0,0,
242,6,0,0,3,7,0,0,20,7,0,0,37,7,0,0,54,7,0,0,72,7,0,0,91,7,0,0,110,7,0,0,130,7,
0,0,150,7,0,0,167,7,0,0,184,7,0,0,201,7,0,0,218,7,0,0,235,7,0,0,255,7,0,0,19,8,
0,0,38,8,0,0,57,8,0,0,75,8,0,0,92,8,0,0,105,8,0,0,120,8,0,0,135,8,0,0,152,8,0,
0,169,8,0,0,186,8,0,0,203,8,0,0,220,8,0,0,237,8,0,0,254,8,0,0,15,9,0,0,32,9,0,
0,47,9,0,0,62,9,0,0,75,9,0,0,91,9,0,0,108,9,0,0,125,9,0,0,142,9,0,0,158,9,0,0,
170,9,0,0,182,9,0,0,194,9,0,0,205,9,0,0,222,9,0,0,239,9,0,0,0,10,0,0,17,10,0,0,
33,10,0,0,48,10,0,0,57,10,0,0,66,10,0,0,75,10,0,0,92,10,0,0,109,10,0,0,126,10,
0,0,143,10,0,0,160,10,0,0,177,10,0,0,186,10,0,0,195,10,0,0,204,10,0,0,214,10,0,
0,226,10,0,0,240,10,0,0,255,10,0,0,13,11,0,0,25,11,0,0,38,11,0,0,51,11,0,0,68,
11,0,0,85,11,0,0,102,11,0,0,119,11,0,0,135,11,0,0,150,11,0,0,165,11,0,0,181,11,
0,0,197,11,0,0,214,11,0,0,231,11,0,0,248,11,0,0,1,12,0,0,10,12,0,0,19,12,0,0,
28,12,0,0,37,12,0,0,38,12,0,0,39,12,0,0,40,12,0,0,41,12,0,0,42,12,0,0,43,12,0,
0,44,12,0,0,45,12,0,0,46,12,0,0,47,12,0,0,48,12,0,0,49,12,0,0,50,12,0,0,51,12,
0,0,52,12,0,0,53,12,0,0,54,12,0,0,55,12,0,0,56,12,0,0,57,12,0,0,58,12,0,0,59,
12,0,0,60,12,0,0,61,12,0,0,62,12,0,0,63,12,0,0,64,12,0,0,65,12,0,0,66,12,0,0,
67,12,0,0,68,12,0,0,69,12,0,0,70,12,0,0,71,12,0,0,72,12,0,0,73,12,0,0,74,12,0,
0,75,12,0,0,76,12,0,0,77,12,0,0,78,12,0,0,79,12,0,0,80,12,0,0,81,12,0,0,82,12,
0,0,83,12,0,0,84,12,0,0,85,12,0,0,86,12,0,0,87,12,0,0,88,12,0,0,89,12,0,0,90,
12,0,0,91,12,0,0,92,12,0,0,93,12,0,0,94,12,0,0,95,12,0,0,96,12,0,0,97,12,0,0,
98,12,0,0,99,12,0,0,100,12,0,0,101,12,0,0,102,12,0,0,103,12,0,0,104,12,0,0,105,
12,0,0,106,12,0,0,107,12,0,0,108,12,0,0,109,12,0,0,110,12,0,0,111,12,0,0,112,
12,0,0,113,12,0,0,114,12,0,0,115,12,0,0,116,12,0,0,117,12,0,0,118,12,0,0,119,
12,0,0,120,12,0,0,121,12,0,0,122,12,0,0,123,12,0,0,124,12,0,0,125,12,0,0,126,
12,0,0,127,12,0,0,128,12,0,0,129,12,0,0,130,12,0,0,131,12,0,0,132,12,0,0,133,
12,0,0,134,12,0,0,135,12,0,0,136,12,0,0,137,12,0,0,138,12,0,0,139,12,0,0,140,
12,0,0,141,12,0,0,142,12,0,0,143,12,0,0,144,12,0,0,145,12,0,0,146,12,0,0,147,
12,0,0,148,12,0,0,149,12,0,0,150,12,0,0,151,12,0,0,152,12,0,0,153,12,0,0,154,
12,0,0,155,12,0,0,156,12,0,0,157,12,0,0,158,12,0,0,0,12,47,47,47,47,47,47,47,
47,47,47,47,47,47,47,255,0,12,47,47,184,186,186,186,186,186,185,185,185,186,47,
47,255,0,12,47,47,180,185,184,184,184,183,182,181,182,185,47,47,255,0,12,47,47,
180,184,184,184,184,183,183,182,183,185,47,47,255,0,12,47,47,183,184,185,185,
184,186,186,186,185,187,47,47,255,0,12,47,47,47,47,47,47,182,186,47,47,47,47,
47,47,255,4,4,47,47,180,186,47,47,255,4,4,47,47,178,185,47,47,255,4,4,47,47,
178,185,47,47,255,0,12,47,47,47,47,47,47,179,185,47,47,47,47,47,47,255,0,12,47,
47,183,184,184,184,182,185,185,185,184,186,47,47,255,0,12,47,47,178,182,181,
181,181,181,180,180,179,184,47,47,255,0,12,47,47,178,181,180,178,178,178,178,
178,179,183,47,47,255,0,12,47,47,183,186,185,185,183,183,183,183,183,186,47,47,
255,0,12,47,47,47,47,47,47,47,47,47,47,47,47,47,47,255,2,8,47,47,47,47,47,47,
47,47,47,47,255,1,10,47,47,187,178,180,180,180,180,178,187,47,47,255,1,10,47,
47,177,179,181,181,180,179,178,183,47,47,255,0,12,47,47,185,181,181,184,184,
184,182,179,178,185,47,47,255,0,12,47,47,179,181,187,47,47,47,47,181,181,185,
47,47,255,0,4,47,47,177,184,47,47,8,4,47,47,177,184,47,47,255,0,4,47,47,177,
184,47,47,8,4,47,47,177,183,47,47,255,0,4,47,47,177,187,47,47,8,4,47,47,177,
185,47,47,255,0,4,47,47,177,187,47,47,8,4,47,47,179,188,47,47,255,0,4,47,47,
177,186,47,47,8,4,47,47,180,186,47,47,255,0,12,47,47,180,182,188,47,47,47,47,
182,184,187,47,47,255,0,12,47,47,185,183,183,185,185,185,186,185,186,187,47,47,
255,1,10,47,47,184,184,184,186,187,187,186,184,47,47,255,1,10,47,47,187,181,
182,185,187,187,186,188,47,47,255,2,8,47,47,47,47,47,47,47,47,47,47,255,0,12,
47,47,47,47,47,47,47,47,47,47,47,47,47,47,255,0,12,47,47,184,186,47,47,183,184,
183,182,182,185,47,47,255,0,12,47,47,177,184,47,47,178,180,180,181,181,186,47,
47,255,0,12,47,47,178,185,47,47,177,182,181,180,180,186,47,47,255,0,12,47,47,
177,184,47,47,177,182,181,182,182,185,47,47,255,0,12,47,47,177,185,47,47,177,
184,47,47,47,47,47,47,255,0,8,47,47,177,185,47,47,177,186,47,47,255,0,8,47,47,
177,185,47,47,177,186,47,47,255,0,8,47,47,177,184,47,47,179,185,47,47,255,0,12,
47,47,178,183,47,47,178,183,186,47,47,47,47,47,255,0,12,47,47,178,183,184,184,
179,179,178,178,179,184,47,47,255,0,12,47,47,178,180,181,180,179,179,179,179,
178,186,47,47,255,0,12,47,47,186,178,179,181,181,180,180,179,178,185,47,47,255,
1,11,47,47,186,182,184,47,47,183,184,182,185,47,47,255,2,3,47,47,47,47,47,7,5,
47,47,47,47,47,47,47,255,0,12,47,47,47,47,47,47,47,47,47,47,47,47,47,47,255,0,
12,47,47,183,185,184,185,185,185,184,184,184,186,47,47,255,0,12,47,47,179,185,
186,186,186,187,185,183,181,185,47,47,255,0,12,47,47,179,184,184,186,185,185,
187,185,184,186,47,47,255,0,12,47,47,184,187,186,186,186,187,187,186,185,186,
47,47,255,0,12,47,47,47,47,47,47,47,47,47,47,47,47,47,47,255,0,4,47,47,47,47,
47,47,7,5,47,47,47,47,47,47,47,255,0,4,47,47,181,185,47,47,6,6,47,47,183,182,
182,185,47,47,255,0,4,47,47,177,184,47,47,6,6,47,47,177,179,178,185,47,47,255,
0,4,47,47,177,183,47,47,5,7,47,47,180,180,179,178,183,47,47,255,0,4,47,47,177,
184,47,47,5,7,47,47,178,180,181,179,184,47,47,255,0,12,47,47,178,185,47,47,180,
179,180,179,181,184,47,47,255,0,12,47,47,177,184,47,47,177,178,178,47,178,184,
47,47,255,0,12,47,47,177,182,47,180,180,180,186,47,177,183,47,47,255,0,12,47,
47,177,177,179,178,181,179,47,47,177,182,47,47,255,0,12,47,47,177,181,181,181,
182,186,47,47,177,184,47,47,255,0,7,47,47,178,181,181,181,183,47,47,8,4,47,47,
178,185,47,47,255,0,7,47,47,177,180,180,180,186,47,47,8,4,47,47,177,184,47,47,
255,0,6,47,47,178,180,180,179,47,47,8,4,47,47,177,183,47,47,255,0,6,47,47,178,
182,180,186,47,47,8,4,47,47,177,185,47,47,255,0,5,47,47,183,184,182,47,47,8,4,
47,47,181,188,47,47,255,0,4,47,47,47,47,47,47,8,4,47,47,47,47,47,47,255,2,8,47,
47,47,47,47,47,47,47,47,47,255,1,10,47,47,187,178,180,180,180,180,178,187,47,
47,255,1,10,47,47,177,179,181,181,180,179,178,183,47,47,255,0,12,47,47,185,181,
181,184,184,184,182,179,178,185,47,47,255,0,12,47,47,179,181,187,47,47,47,47,
181,181,185,47,47,255,0,4,47,47,177,184,47,47,8,4,47,47,177,184,47,47,255,0,4,
47,47,177,184,47,47,8,4,47,47,177,183,47,47,255,0,4,47,47,177,187,47,47,8,4,47,
47,177,185,47,47,255,0,4,47,47,177,187,47,47,8,4,47,47,179,188,47,47,255,0,4,
47,47,177,186,47,47,8,4,47,47,180,186,47,47,255,0,12,47,47,180,182,188,47,47,
47,47,182,184,187,47,47,255,0,12,47,47,185,183,183,185,185,185,186,185,186,187,
47,47,255,1,10,47,47,184,184,184,186,187,187,186,184,47,47,255,1,10,47,47,187,
181,182,185,187,187,186,188,47,47,255,2,8,47,47,47,47,47,47,47,47,47,47,255,1,
11,47,47,47,47,47,47,47,47,47,47,47,47,47,255,0,12,47,47,177,180,182,181,182,
182,182,181,181,185,47,47,255,0,12,47,47,177,181,181,181,182,181,180,179,179,
184,47,47,255,0,12,47,47,186,180,181,180,182,180,183,184,184,186,47,47,255,1,
11,47,47,186,182,182,182,182,47,47,47,47,47,47,255,2,7,47,47,186,182,182,182,
186,47,47,255,3,7,47,47,186,182,180,178,186,47,47,255,4,7,47,47,186,178,178,
178,186,47,47,255,5,6,47,47,186,180,181,179,47,47,255,0,12,47,47,47,47,47,47,
47,47,180,180,178,186,47,47,255,0,12,47,47,184,182,182,183,183,182,178,178,178,
184,47,47,255,0,12,47,47,176,176,176,176,176,176,176,176,176,182,47,47,255,0,
12,47,47,177,180,181,180,179,179,179,179,178,184,47,47,255,0,11,47,47,184,184,
185,185,185,185,185,185,187,47,47,255,0,10,47,47,47,47,47,47,47,47,47,47,47,47,
255,0,4,47,47,47,47,47,47,255,0,4,47,47,184,187,47,47,255,0,4,47,47,178,187,47,
47,255,0,12,47,47,177,182,47,47,47,47,47,47,47,47,47,47,255,0,12,47,47,177,182,
181,181,181,181,181,181,182,185,47,47,255,0,12,47,47,177,177,178,179,177,177,
178,179,179,184,47,47,255,0,12,47,47,177,179,179,182,181,181,180,179,179,184,
47,47,255,0,12,47,47,178,182,183,182,184,184,184,183,182,185,47,47,255,0,12,47,
47,178,185,47,47,47,47,47,47,47,47,47,47,255,0,4,47,47,178,187,47,47,255,0,4,
47,47,181,187,47,47,255,0,4,47,47,47,47,47,47,255,7,5,47,47,47,47,47,47,47,255,
5,7,47,47,47,186,183,181,184,47,47,255,3,9,47,47,47,186,184,181,178,178,183,47,
47,255,2,10,47,47,186,184,181,181,180,179,186,47,47,47,255,1,9,47,47,187,184,
182,181,182,186,47,47,47,255,1,7,47,47,184,182,183,186,47,47,47,255,0,8,47,47,
183,185,186,47,47,47,47,47,255,0,8,47,47,182,184,47,47,180,185,47,47,255,0,12,
47,47,178,186,47,47,180,187,47,47,47,47,47,47,255,0,12,47,47,178,187,185,185,
183,185,185,186,186,187,47,47,255,0,12,47,47,179,181,182,182,182,182,183,183,
183,186,47,47,255,0,12,47,47,186,183,183,184,183,184,183,182,181,185,47,47,255,
1,11,47,47,188,186,185,186,186,185,186,186,187,47,47,255,2,10,47,47,47,47,47,
47,47,47,47,47,47,47,255,0,10,47,47,47,47,47,47,47,47,47,47,47,47,255,0,11,47,
47,186,188,187,187,187,186,185,185,47,47,47,255,0,11,47,47,180,185,186,187,184,
184,182,182,184,47,47,255,0,12,47,47,178,182,186,186,185,184,185,184,185,187,
47,47,255,0,12,47,47,183,187,187,187,186,185,187,187,185,187,47,47,255,0,12,47,
47,47,47,47,47,47,47,47,185,178,183,47,47,255,8,4,47,47,179,185,47,47,255,8,4,
47,47,180,185,47,47,255,8,4,47,47,179,184,47,47,255,8,4,47,47,182,185,47,47,
255,8,4,47,47,47,47,47,47,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};

// Vertical Sensitivity menu
static const char m_versen[]={
128,0,16,0,0,0,0,0,8,2,0,0,18,2,0,0,30,2,0,0,44,2,0,0,60,2,0,0,77,2,0,0,91,2,0,
0,103,2,0,0,115,2,0,0,129,2,0,0,146,2,0,0,162,2,0,0,176,2,0,0,188,2,0,0,198,2,
0,0,207,2,0,0,220,2,0,0,235,2,0,0,250,2,0,0,11,3,0,0,28,3,0,0,45,3,0,0,62,3,0,
0,79,3,0,0,96,3,0,0,113,3,0,0,130,3,0,0,147,3,0,0,164,3,0,0,181,3,0,0,198,3,0,
0,215,3,0,0,232,3,0,0,249,3,0,0,10,4,0,0,23,4,0,0,36,4,0,0,49,4,0,0,66,4,0,0,
83,4,0,0,100,4,0,0,117,4,0,0,133,4,0,0,150,4,0,0,159,4,0,0,168,4,0,0,177,4,0,0,
194,4,0,0,211,4,0,0,228,4,0,0,245,4,0,0,6,5,0,0,23,5,0,0,32,5,0,0,41,5,0,0,50,
5,0,0,67,5,0,0,84,5,0,0,101,5,0,0,118,5,0,0,135,5,0,0,152,5,0,0,165,5,0,0,180,
5,0,0,195,5,0,0,212,5,0,0,229,5,0,0,246,5,0,0,7,6,0,0,24,6,0,0,41,6,0,0,58,6,0,
0,75,6,0,0,92,6,0,0,109,6,0,0,119,6,0,0,131,6,0,0,145,6,0,0,160,6,0,0,174,6,0,
0,186,6,0,0,199,6,0,0,212,6,0,0,229,6,0,0,246,6,0,0,7,7,0,0,24,7,0,0,40,7,0,0,
55,7,0,0,70,7,0,0,86,7,0,0,102,7,0,0,119,7,0,0,136,7,0,0,153,7,0,0,162,7,0,0,
171,7,0,0,180,7,0,0,189,7,0,0,198,7,0,0,199,7,0,0,200,7,0,0,201,7,0,0,202,7,0,
0,203,7,0,0,204,7,0,0,205,7,0,0,206,7,0,0,207,7,0,0,208,7,0,0,209,7,0,0,210,7,
0,0,211,7,0,0,212,7,0,0,213,7,0,0,214,7,0,0,215,7,0,0,216,7,0,0,217,7,0,0,218,
7,0,0,219,7,0,0,220,7,0,0,221,7,0,0,222,7,0,0,223,7,0,0,224,7,0,0,225,7,0,0,
226,7,0,0,0,5,47,47,47,47,47,47,47,255,0,7,47,47,177,180,182,184,47,47,47,255,
0,9,47,47,177,181,181,181,182,184,47,47,47,255,0,11,47,47,182,183,181,180,182,
180,180,184,47,47,47,255,0,12,47,47,47,47,185,184,182,182,181,180,180,185,47,
47,255,3,9,47,47,47,185,182,181,182,182,187,47,47,255,5,7,47,47,185,178,180,
183,187,47,47,255,5,7,47,47,185,178,178,180,188,47,47,255,3,9,47,47,47,184,179,
180,181,179,184,47,47,255,0,12,47,47,47,47,184,182,181,181,180,180,178,183,47,
47,255,0,11,47,47,182,182,179,180,180,178,178,184,47,47,47,255,0,9,47,47,178,
180,181,181,179,184,47,47,47,255,0,7,47,47,177,180,181,184,47,47,47,255,0,5,47,
47,47,47,47,47,47,255,4,4,47,47,47,47,47,47,255,2,8,47,47,47,186,185,185,186,
47,47,47,255,1,10,47,47,188,185,182,182,182,181,183,188,47,47,255,1,10,47,47,
183,181,181,181,182,181,178,185,47,47,255,0,12,47,47,185,182,181,181,181,181,
180,179,179,186,47,47,255,0,12,47,47,180,182,185,185,181,182,185,185,181,184,
47,47,255,0,12,47,47,182,186,47,47,181,186,47,47,179,185,47,47,255,0,12,47,47,
179,187,47,47,180,188,47,47,178,185,47,47,255,0,12,47,47,179,186,47,47,180,187,
47,47,178,186,47,47,255,0,12,47,47,180,188,47,47,180,188,47,47,178,185,47,47,
255,0,12,47,47,180,188,47,47,178,186,47,47,179,186,47,47,255,0,12,47,47,179,
185,47,47,178,185,47,47,180,186,47,47,255,0,12,47,47,184,187,47,47,185,187,47,
47,183,186,47,47,255,0,12,47,47,47,47,47,47,47,47,47,47,47,47,47,47,255,0,12,
47,47,47,47,47,47,47,47,47,47,47,47,47,47,255,0,12,47,47,184,186,47,47,183,184,
183,182,182,185,47,47,255,0,12,47,47,177,184,47,47,178,180,180,181,181,186,47,
47,255,0,12,47,47,178,185,47,47,177,182,181,180,180,186,47,47,255,0,12,47,47,
177,184,47,47,177,182,181,182,182,185,47,47,255,0,12,47,47,177,185,47,47,177,
184,47,47,47,47,47,47,255,0,8,47,47,177,185,47,47,177,186,47,47,255,0,8,47,47,
177,185,47,47,177,186,47,47,255,0,8,47,47,177,184,47,47,179,185,47,47,255,0,12,
47,47,178,183,47,47,178,183,186,47,47,47,47,47,255,0,12,47,47,178,183,184,184,
179,179,178,178,179,184,47,47,255,0,12,47,47,178,180,181,180,179,179,179,179,
178,186,47,47,255,0,12,47,47,186,178,179,181,181,180,180,179,178,185,47,47,255,
1,11,47,47,186,182,184,47,47,183,184,182,185,47,47,255,2,3,47,47,47,47,47,7,5,
47,47,47,47,47,47,47,255,0,4,47,47,47,47,47,47,255,0,4,47,47,184,187,47,47,255,
0,4,47,47,178,187,47,47,255,0,12,47,47,177,182,47,47,47,47,47,47,47,47,47,47,
255,0,12,47,47,177,182,181,181,181,181,181,181,182,185,47,47,255,0,12,47,47,
177,177,178,179,177,177,178,179,179,184,47,47,255,0,12,47,47,177,179,179,182,
181,181,180,179,179,184,47,47,255,0,12,47,47,178,182,183,182,184,184,184,183,
182,185,47,47,255,0,12,47,47,178,185,47,47,47,47,47,47,47,47,47,47,255,0,4,47,
47,178,187,47,47,255,0,4,47,47,181,187,47,47,255,0,4,47,47,47,47,47,47,255,0,
12,47,47,47,47,47,47,47,47,47,47,47,47,47,47,255,0,12,47,47,183,185,184,185,
185,185,184,184,184,186,47,47,255,0,12,47,47,179,185,186,186,186,187,185,183,
181,185,47,47,255,0,12,47,47,179,184,184,186,185,185,187,185,184,186,47,47,255,
0,12,47,47,184,187,186,186,186,187,187,186,185,186,47,47,255,0,12,47,47,47,47,
47,47,47,47,47,47,47,47,47,47,255,2,8,47,47,47,47,47,47,47,47,47,47,255,1,10,
47,47,187,184,184,184,184,184,184,188,47,47,255,1,10,47,47,182,185,185,186,186,
187,187,187,47,47,255,0,12,47,47,187,188,188,188,188,187,188,188,188,47,47,47,
255,0,12,47,47,184,188,189,47,47,47,47,184,187,187,47,47,255,0,4,47,47,184,188,
47,47,8,4,47,47,180,187,47,47,255,0,4,47,47,182,188,47,47,8,4,47,47,178,184,47,
47,255,0,4,47,47,178,184,47,47,8,4,47,47,180,187,47,47,255,0,4,47,47,178,186,
47,47,8,4,47,47,178,186,47,47,255,0,4,47,47,178,184,47,47,8,4,47,47,179,186,47,
47,255,0,4,47,47,178,185,47,47,8,4,47,47,178,186,47,47,255,0,4,47,47,182,186,
47,47,8,4,47,47,182,185,47,47,255,0,4,47,47,47,47,47,47,8,4,47,47,47,47,47,47,
255,7,5,47,47,47,47,47,47,47,255,5,7,47,47,47,186,183,181,184,47,47,255,3,9,47,
47,47,186,184,181,178,178,183,47,47,255,2,10,47,47,186,184,181,181,180,179,186,
47,47,47,255,1,9,47,47,187,184,182,181,182,186,47,47,47,255,1,7,47,47,184,182,
183,186,47,47,47,255,0,8,47,47,183,185,186,47,47,47,47,47,255,0,8,47,47,182,
184,47,47,180,185,47,47,255,0,12,47,47,178,186,47,47,180,187,47,47,47,47,47,47,
255,0,12,47,47,178,187,185,185,183,185,185,186,186,187,47,47,255,0,12,47,47,
179,181,182,182,182,182,183,183,183,186,47,47,255,0,12,47,47,186,183,183,184,
183,184,183,182,181,185,47,47,255,1,11,47,47,188,186,185,186,186,185,186,186,
187,47,47,255,2,10,47,47,47,47,47,47,47,47,47,47,47,47,255,0,10,47,47,47,47,47,
47,47,47,47,47,47,47,255,0,11,47,47,186,188,187,187,187,186,185,185,47,47,47,
255,0,11,47,47,180,185,186,187,184,184,182,182,184,47,47,255,0,12,47,47,178,
182,186,186,185,184,185,184,185,187,47,47,255,0,12,47,47,183,187,187,187,186,
185,187,187,185,187,47,47,255,0,12,47,47,47,47,47,47,47,47,47,185,178,183,47,
47,255,8,4,47,47,179,185,47,47,255,8,4,47,47,180,185,47,47,255,8,4,47,47,179,
184,47,47,255,8,4,47,47,182,185,47,47,255,8,4,47,47,47,47,47,47,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255};


//jff 02/16/98 HUD bargraph patches
// The HUD uses vertical stripe characters to make up the bars in
// view during play, and those are made up here at various stages
// of "fullness".  Note that all HUD elements can be recolored
// dynamically in the code, so only the shapes are defined here.

static const char stbr123[]=  // full
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 52,  0,  0,  0, 53,  0,  0,  0, 65,  0,  0,  0,
   66,  0,  0,  0, 78,  0,  0,  0, 79,  0,  0,  0, 91,  0,  0,  0,
    0,  7,  0, 47,185,180,176,180,185, 47,  0,255,255,  0,  7,  0,
   47,185,180,176,180,185, 47,  0,255,255,  0,  7,  0, 47,185,180,
  176,180,185, 47,  0,255,255,  0,  7,  0, 47,185,180,176,180,185,
   47,  0,255,255,
};

static const char stbr124[]=  // 3/4 full
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 52,  0,  0,  0, 53,  0,  0,  0, 65,  0,  0,  0,
   66,  0,  0,  0, 78,  0,  0,  0, 79,  0,  0,  0, 80,  0,  0,  0,
    0,  7,  0, 47,185,180,176,180,185, 47,  0,255,255,  0,  7,  0,
   47,185,180,176,180,185, 47,  0,255,255,  0,  7,  0, 47,185,180,
  176,180,185, 47,  0,255,255,255,255,
};

static const char stbr125[]=  // half full
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 52,  0,  0,  0, 53,  0,  0,  0, 65,  0,  0,  0,
   66,  0,  0,  0, 67,  0,  0,  0, 68,  0,  0,  0, 69,  0,  0,  0,
    0,  7,  0, 47,185,180,176,180,185, 47,  0,255,255,  0,  7,  0,
   47,185,180,176,180,185, 47,  0,255,255,255,255,255,255,
};

static const char stbr126[]=  // quarter full
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 52,  0,  0,  0, 53,  0,  0,  0, 54,  0,  0,  0,
   55,  0,  0,  0, 56,  0,  0,  0, 57,  0,  0,  0, 58,  0,  0,  0,
    0,  7,  0, 47,185,180,176,180,185, 47,  0,255,255,255,255,255,
  255,255,255,
};

static const char stbr127[]=  // empty block
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 41,  0,  0,  0, 42,  0,  0,  0, 43,  0,  0,  0,
   44,  0,  0,  0, 45,  0,  0,  0, 46,  0,  0,  0, 47,  0,  0,  0,
  255,255,255,255,255,255,255,255,
};

// The digits themselves that are used in the HUD

static const char dig0[]=  // zero
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 62,  0,  0,  0,
   73,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,  0,  0,176,  0,  0,255,  1,  2,  0,176,  0,  0,  5,
    2,  0,176,  0,  0,255,  1,  6,  0,176,176,176,176,176,  0,  0,
  255,  2,  5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const char dig1[]=  // one
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 34,  0,  0,  0, 46,  0,  0,  0, 57,  0,  0,  0,
   67,  0,  0,  0,  5,  1,  0,176,  0,255,  1,  1,  0,176,  0,  5,
    2,  0,176,  0,  0,255,  1,  6,  0,176,176,176,176,176,  0,  0,
  255,  2,  5,  0,  0,  0,  0,176,  0,  0,255,  4,  3,  0,  0,  0,
    0,  0,255,
};

static const char dig2[]=  // two
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 41,  0,  0,  0, 52,  0,  0,  0, 63,  0,  0,  0,
   74,  0,  0,  0,  1,  1,  0,176,  0,  3,  3,  0,176,176,176,  0,
  255,  1,  6,  0,176,  0,176,  0,176,  0,  0,255,  1,  6,  0,176,
    0,176,  0,176,  0,  0,255,  1,  6,  0,176,176,176,  0,176,  0,
    0,255,  2,  3,  0,  0,  0,  0,  0,  6,  1,  0,  0,  0,255,
};

static const char dig3[]=  // three
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 41,  0,  0,  0, 55,  0,  0,  0, 69,  0,  0,  0,
   80,  0,  0,  0,  1,  2,  0,176,176,  0,  4,  2,  0,176,176,  0,
  255,  1,  3,  0,176,  0,  0,  0,  5,  2,  0,176,  0,  0,255,  1,
    3,  0,176,  0,176,  0,  5,  2,  0,176,  0,  0,255,  1,  6,  0,
  176,176,176,176,176,  0,  0,255,  2,  5,  0,  0,  0,  0,  0,  0,
    0,255,
};

static const char dig4[]=  // four
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 37,  0,  0,  0, 46,  0,  0,  0, 57,  0,  0,  0,
   67,  0,  0,  0,  1,  4,  0,176,176,176,176,  0,255,  2,  4,  0,
    0,  0,176,  0,  0,255,  1,  6,  0,176,176,176,176,176,  0,  0,
  255,  2,  5,  0,  0,  0,176,  0,  0,  0,255,  4,  2,  0,  0,  0,
    0,255,
};

static const char dig45[]=  // minus '-'
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 29,  0,  0,  0, 35,  0,  0,  0, 42,  0,  0,  0,
   49,  0,  0,  0,255,  3,  1,  0,176,  0,255,  3,  2,  0,176,  0,
    0,255,  3,  2,  0,176,  0,  0,255,  4,  1,  0,  0,  0,255,
};


static const char dig47[]=  // slash '/'
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 29,  0,  0,  0, 36,  0,  0,  0, 43,  0,  0,  0,
   50,  0,  0,  0,255,  4,  2,  0,176,  0,  0,255,  3,  2,  0,176,
    0,  0,255,  2,  2,  0,176,  0,  0,255,255,
};

static const char dig5[]=  // five
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 41,  0,  0,  0, 52,  0,  0,  0, 63,  0,  0,  0,
   74,  0,  0,  0,  1,  3,  0,176,176,176,  0,  5,  1,  0,176,  0,
  255,  1,  6,  0,176,  0,176,  0,176,  0,  0,255,  1,  6,  0,176,
    0,176,  0,176,  0,  0,255,  1,  6,  0,176,  0,176,176,176,  0,
    0,255,  2,  5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const char dig58[]=  // colon ':'
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 29,  0,  0,  0, 30,  0,  0,  0, 41,  0,  0,  0,
   52,  0,  0,  0,255,255,  2,  1,  0,176,  0,  4,  1,  0,176,  0,
  255,  3,  1,  0,  0,  0,  5,  1,  0,  0,  0,255,255,
};

static const char dig6[]=  // six
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 60,  0,  0,  0,
   71,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,176,  0,176,  0,  0,255,  1,  6,  0,176,  0,176,  0,
  176,  0,  0,255,  1,  6,  0,176,  0,176,176,176,  0,  0,255,  2,
    5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const char dig7[]=  // seven
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 34,  0,  0,  0, 41,  0,  0,  0, 51,  0,  0,  0,
   62,  0,  0,  0,  1,  1,  0,176,  0,255,  1,  2,  0,176,  0,  0,
  255,  1,  5,  0,176,  0,176,176,176,  0,255,  1,  6,  0,176,176,
    0,  0,  0,  0,  0,255,  2,  2,  0,  0,  0,  0,255,
};

static const char dig8[]=  // eight
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 60,  0,  0,  0,
   71,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,176,  0,176,  0,  0,255,  1,  6,  0,176,  0,176,  0,
  176,  0,  0,255,  1,  6,  0,176,176,176,176,176,  0,  0,255,  2,
    5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const char dig9[]=  // nine
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 41,  0,  0,  0, 52,  0,  0,  0, 63,  0,  0,  0,
   74,  0,  0,  0,  1,  3,  0,176,176,176,  0,  5,  1,  0,176,  0,
  255,  1,  6,  0,176,  0,176,  0,176,  0,  0,255,  1,  6,  0,176,
    0,176,  0,176,  0,  0,255,  1,  6,  0,176,176,176,176,176,  0,
    0,255,  2,  5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const char dig91[]=  // open bracket '['
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 29,  0,  0,  0, 39,  0,  0,  0, 50,  0,  0,  0,
   61,  0,  0,  0,255,  1,  5,  0,176,176,176,176,176,  0,255,  1,
    6,  0,176,  0,  0,  0,176,  0,  0,255,  2,  1,  0,  0,  0,  6,
    1,  0,  0,  0,255,255,
};

static const char dig93[]=  // close bracket ']'
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 29,  0,  0,  0, 40,  0,  0,  0, 51,  0,  0,  0,
   61,  0,  0,  0,255,  1,  1,  0,176,  0,  5,  1,  0,176,  0,255,
    1,  6,  0,176,176,176,176,176,  0,  0,255,  2,  5,  0,  0,  0,
    0,  0,  0,  0,255,255,
};

static const char diga[]=  // these are the letters A-Z
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 58,  0,  0,  0,
   68,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,176,  0,  0,  0,  0,255,  1,  4,  0,176,  0,176,  0,
    0,255,  1,  5,  0,176,176,176,176,176,  0,255,  2,  5,  0,  0,
    0,  0,  0,  0,  0,255,
};

static const char digb[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 60,  0,  0,  0,
   70,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,176,  0,176,  0,  0,255,  1,  6,  0,176,176,176,  0,
  176,  0,  0,255,  2,  5,  0,  0,176,176,176,  0,  0,255,  3,  4,
    0,  0,  0,  0,  0,  0,255,
};

static const char digc[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 62,  0,  0,  0,
   75,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,  0,  0,176,  0,  0,255,  1,  2,  0,176,  0,  0,  5,
    2,  0,176,  0,  0,255,  1,  2,  0,176,  0,  0,  5,  2,  0,176,
    0,  0,255,  2,  1,  0,  0,  0,  6,  1,  0,  0,  0,255,
};

static const char digd[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 62,  0,  0,  0,
   72,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,  0,  0,176,  0,  0,255,  1,  2,  0,176,  0,  0,  5,
    2,  0,176,  0,  0,255,  2,  5,  0,176,176,176,  0,  0,  0,255,
    3,  3,  0,  0,  0,  0,  0,255,
};

static const char dige[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 60,  0,  0,  0,
   74,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,176,  0,176,  0,  0,255,  1,  6,  0,176,  0,176,  0,
  176,  0,  0,255,  1,  2,  0,176,  0,  0,  4,  3,  0,  0,176,  0,
    0,255,  2,  1,  0,  0,  0,  6,  1,  0,  0,  0,255,
};

static const char digf[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 58,  0,  0,  0,
   70,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,176,  0,  0,  0,  0,255,  1,  4,  0,176,  0,176,  0,
    0,255,  1,  2,  0,176,  0,  0,  4,  1,  0,  0,  0,255,  2,  1,
    0,  0,  0,255,
};

static const char digg[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 63,  0,  0,  0,
   74,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,  0,  0,176,  0,  0,255,  1,  3,  0,176,  0,176,  0,
    5,  2,  0,176,  0,  0,255,  1,  6,  0,176,  0,176,176,176,  0,
    0,255,  2,  1,  0,  0,  0,  4,  3,  0,  0,  0,  0,  0,255,
};

static const char digh[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 48,  0,  0,  0, 55,  0,  0,  0,
   65,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  2,  5,
    0,  0,176,  0,  0,  0,  0,255,  3,  2,  0,176,  0,  0,255,  1,
    5,  0,176,176,176,176,176,  0,255,  2,  5,  0,  0,  0,  0,  0,
    0,  0,255,
};

static const char digi[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 29,  0,  0,  0, 40,  0,  0,  0, 51,  0,  0,  0,
   62,  0,  0,  0,255,  1,  1,  0,176,  0,  5,  1,  0,176,  0,255,
    1,  6,  0,176,176,176,176,176,  0,  0,255,  1,  6,  0,176,  0,
    0,  0,176,  0,  0,255,  5,  2,  0,  0,  0,  0,255,
};

static const char digj[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 40,  0,  0,  0, 53,  0,  0,  0, 64,  0,  0,  0,
   75,  0,  0,  0,  1,  1,  0,176,  0,  4,  2,  0,176,176,  0,255,
    1,  2,  0,176,  0,  0,  5,  2,  0,176,  0,  0,255,  1,  6,  0,
  176,176,176,176,176,  0,  0,255,  1,  6,  0,176,  0,  0,  0,  0,
    0,  0,255,  2,  1,  0,  0,  0,255,
};

static const char digk[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 48,  0,  0,  0, 57,  0,  0,  0,
   68,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  2,  5,
    0,  0,176,  0,  0,  0,  0,255,  1,  4,  0,176,176,176,  0,  0,
  255,  1,  6,  0,176,  0,176,176,176,  0,  0,255,  2,  1,  0,  0,
    0,  4,  3,  0,  0,  0,  0,  0,255,
};

static const char digl[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 48,  0,  0,  0, 55,  0,  0,  0,
   62,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  2,  5,
    0,  0,  0,  0,176,  0,  0,255,  5,  2,  0,176,  0,  0,255,  5,
    2,  0,176,  0,  0,255,  6,  1,  0,  0,  0,255,
};

static const char digm[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 48,  0,  0,  0, 56,  0,  0,  0,
   66,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  2,  5,
    0,176,176,  0,  0,  0,  0,255,  2,  3,  0,176,176,  0,  0,255,
    1,  5,  0,176,176,176,176,176,  0,255,  2,  5,  0,  0,  0,  0,
    0,  0,  0,255,
};

static const char dign[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 48,  0,  0,  0, 55,  0,  0,  0,
   65,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  2,  5,
    0,176,176,  0,  0,  0,  0,255,  3,  2,  0,176,176,  0,255,  1,
    5,  0,176,176,176,176,176,  0,255,  2,  5,  0,  0,  0,  0,  0,
    0,  0,255,
};

static const char digo[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 62,  0,  0,  0,
   73,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,  0,  0,176,  0,  0,255,  1,  2,  0,176,  0,  0,  5,
    2,  0,176,  0,  0,255,  1,  6,  0,176,176,176,176,176,  0,  0,
  255,  2,  5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const char digp[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 58,  0,  0,  0,
   67,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,176,  0,  0,  0,  0,255,  1,  4,  0,176,  0,176,  0,
    0,255,  1,  4,  0,176,176,176,  0,  0,255,  2,  3,  0,  0,  0,
    0,  0,255,
};

static const char digq[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 63,  0,  0,  0,
   74,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,  0,176,176,  0,  0,255,  1,  2,  0,176,  0,  0,  4,
    3,  0,  0,176,176,  0,255,  1,  6,  0,176,176,176,176,176,  0,
    0,255,  2,  5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const char digr[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 58,  0,  0,  0,
   67,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,176,  0,  0,  0,  0,255,  1,  4,  0,176,176,176,  0,
    0,255,  2,  4,  0,  0,176,176,176,  0,255,  3,  4,  0,  0,  0,
    0,  0,  0,255,
};

static const char digs[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 41,  0,  0,  0, 52,  0,  0,  0, 63,  0,  0,  0,
   74,  0,  0,  0,  1,  3,  0,176,176,176,  0,  5,  1,  0,176,  0,
  255,  1,  6,  0,176,  0,176,  0,176,  0,  0,255,  1,  6,  0,176,
    0,176,  0,176,  0,  0,255,  1,  6,  0,176,  0,176,176,176,  0,
    0,255,  2,  5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const char digt[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 34,  0,  0,  0, 41,  0,  0,  0, 51,  0,  0,  0,
   62,  0,  0,  0,  1,  1,  0,176,  0,255,  1,  2,  0,176,  0,  0,
  255,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,  0,176,  0,
    0,  0,  0,  0,  0,255,  2,  1,  0,  0,  0,255,
};

static const char digu[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 48,  0,  0,  0, 55,  0,  0,  0,
   66,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  2,  5,
    0,  0,  0,  0,176,  0,  0,255,  5,  2,  0,176,  0,  0,255,  1,
    6,  0,176,176,176,176,176,  0,  0,255,  2,  5,  0,  0,  0,  0,
    0,  0,  0,255,
};

static const char digv[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 36,  0,  0,  0, 45,  0,  0,  0, 53,  0,  0,  0,
   64,  0,  0,  0,  1,  3,  0,176,176,176,  0,255,  2,  4,  0,  0,
    0,176,176,  0,255,  4,  3,  0,176,176,  0,  0,255,  1,  6,  0,
  176,176,176,  0,  0,  0,  0,255,  2,  3,  0,  0,  0,  0,  0,255,
};

static const char digw[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 47,  0,  0,  0, 56,  0,  0,  0,
   67,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  3,  4,
    0,176,176,  0,  0,  0,255,  3,  4,  0,176,176,  0,  0,  0,255,
    1,  6,  0,176,176,176,176,176,  0,  0,255,  2,  5,  0,  0,  0,
    0,  0,  0,  0,255,
};

static const char digx[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 41,  0,  0,  0, 51,  0,  0,  0, 60,  0,  0,  0,
   71,  0,  0,  0,  1,  2,  0,176,176,  0,  4,  2,  0,176,176,  0,
  255,  2,  5,  0,176,176,176,  0,  0,  0,255,  2,  4,  0,176,176,
  176,  0,  0,255,  1,  6,  0,176,176,  0,176,176,  0,  0,255,  2,
    5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const char digy[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 42,  0,  0,  0, 52,  0,  0,  0, 61,  0,  0,  0,
   72,  0,  0,  0,  1,  3,  0,176,176,176,  0,  5,  2,  0,176,  0,
    0,255,  2,  5,  0,  0,176,  0,176,  0,  0,255,  3,  4,  0,176,
    0,176,  0,  0,255,  1,  6,  0,176,176,176,176,176,  0,  0,255,
    2,  5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const char digz[]=  // end of letters A-Z
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 40,  0,  0,  0, 51,  0,  0,  0, 62,  0,  0,  0,
   73,  0,  0,  0,  1,  1,  0,176,  0,  4,  2,  0,176,176,  0,255,
    1,  6,  0,176,  0,176,176,176,  0,  0,255,  1,  6,  0,176,176,
  176,  0,176,  0,  0,255,  1,  6,  0,176,176,  0,  0,176,  0,  0,
  255,  2,  2,  0,  0,  0,  0,  6,  1,  0,  0,  0,255,
};

static const char stkeys6[]=  // show both blue keys on stat bar
{
    7,  0,  7,  0,  0,  0,  0,  0,
   36,  0,  0,  0, 43,  0,  0,  0, 51,  0,  0,  0, 62,  0,  0,  0,
   74,  0,  0,  0, 86,  0,  0,  0, 96,  0,  0,  0,  1,  2,  0,198,
  200,  0,255,  0,  3,  0,198,202,203,  0,255,  0,  6,  0,198,  0,
  202,204,199,197,  0,255,  0,  7,  0,198,202,202,198,207,199,203,
    0,255,  0,  7,  0,200,  0,201,199,200,207,202,  0,255,  2,  5,
    0,202,199,207,199,202,  0,255,  3,  3,  0,204,199,197,  0,255,
};

static const char stkeys7[]=  // show both yellow keys on stat bar
{
    7,  0,  7,  0,  0,  0,  0,  0,
   36,  0,  0,  0, 43,  0,  0,  0, 51,  0,  0,  0, 62,  0,  0,  0,
   74,  0,  0,  0, 86,  0,  0,  0, 96,  0,  0,  0,  1,  2,  0,161,
  161,  0,255,  0,  3,  0,161,163,163,  0,255,  0,  6,  0,161,  0,
  163,220,162,235,  0,255,  0,  7,  0,161,163,217,162,246,214,221,
    0,255,  0,  7,  0,161,  0,214,213,214,246,218,  0,255,  2,  5,
    0,217,162,246,214,221,  0,255,  3,  3,  0,220,162,235,  0,255,
};

static const char stkeys8[]=  // show both red keys on stat bar
{
    7,  0,  7,  0,  0,  0,  0,  0,
   36,  0,  0,  0, 43,  0,  0,  0, 51,  0,  0,  0, 62,  0,  0,  0,
   74,  0,  0,  0, 86,  0,  0,  0, 96,  0,  0,  0,  1,  2,  0,174,
  176,  0,255,  0,  3,  0,174,179,179,  0,255,  0,  6,  0,176,  0,
  179,184,174,174,  0,255,  0,  7,  0,176,179,185,175,246,185,182,
    0,255,  0,  7,  0,176,  0,183,177,176,246,179,  0,255,  2,  5,
    0,185,177,246,185,182,  0,255,  3,  3,  0,185,175,174,  0,255,
};

// Background characters for the message review when enabled
// Makes a general purpose background box, could be used for other
// purposes as well
//
//  ul uc ur
//  cl cc cr
//  ll lc lr
//

static const char boxcc[]=  // message background characters
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 53,  0,  0,  0, 66,  0,  0,  0, 79,  0,  0,  0,
   92,  0,  0,  0,105,  0,  0,  0,118,  0,  0,  0,131,  0,  0,  0,
    0,  8,  0,151,151,151, 77, 77, 77, 78, 77,  0,255,  0,  8,  0,
   77, 77, 78, 77, 77, 77, 77, 78,  0,255,  0,  8,  0, 78,151, 77,
   78, 78, 77, 78, 77,  0,255,  0,  8,  0, 77, 77, 78, 77, 77, 77,
   77,151,  0,255,  0,  8,  0,151, 77, 77,151, 77, 78, 77, 77,  0,
  255,  0,  8,  0, 77, 78, 77, 77, 77, 77,151, 78,  0,255,  0,  8,
    0, 78, 77, 77,151, 77, 78, 77, 77,  0,255,  0,  8,  0, 77, 78,
   77, 77, 77,151,151,151,  0,255,
};

static const char boxcl[]=
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 53,  0,  0,  0, 66,  0,  0,  0, 79,  0,  0,  0,
   92,  0,  0,  0,105,  0,  0,  0,118,  0,  0,  0,131,  0,  0,  0,
    0,  8,  0, 10, 10,  9, 10,  9,  9, 10,  9,  0,255,  0,  8,  0,
   11,126,126,126,126, 11,126,126,  0,255,  0,  8,  0,238,238,238,
  238,238,238,238,238,  0,255,  0,  8,  0,151,151, 76, 77,151,151,
  151,151,  0,255,  0,  8,  0,151, 76,151,151,151, 77,151,151,  0,
  255,  0,  8,  0,151,151,151, 77, 77,151, 78,151,  0,255,  0,  8,
    0, 77, 78, 77, 77, 78, 77,151, 77,  0,255,  0,  8,  0,151,151,
   77, 77, 77, 77, 78, 78,  0,255,
};

static const char boxcr[]=
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 53,  0,  0,  0, 66,  0,  0,  0, 79,  0,  0,  0,
   92,  0,  0,  0,105,  0,  0,  0,118,  0,  0,  0,131,  0,  0,  0,
    0,  8,  0, 78, 78, 77,151,151, 77,151,151,  0,255,  0,  8,  0,
   77,151, 77,151, 77, 77, 78, 77,  0,255,  0,  8,  0,151, 78,151,
   76,151,151,151,151,  0,255,  0,  8,  0,151,151, 77, 76, 76,151,
   76,151,  0,255,  0,  8,  0,151,151,151,151, 76, 76,151,151,  0,
  255,  0,  8,  0,238,238,238,238,238,238,238,238,  0,255,  0,  8,
    0, 11,126,126,126,126, 11,126,126,  0,255,  0,  8,  0, 10, 10,
    9, 10,  9,  9, 10,  9,  0,255,
};

static const char boxlc[]=
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 53,  0,  0,  0, 66,  0,  0,  0, 79,  0,  0,  0,
   92,  0,  0,  0,105,  0,  0,  0,118,  0,  0,  0,131,  0,  0,  0,
    0,  8,  0, 77, 77, 77, 78, 77,  9,  9, 11,  0,255,  0,  8,  0,
   77, 77, 77, 77, 78,159, 10,126,  0,255,  0,  8,  0, 78, 78, 77,
   78, 77,  9,  9,126,  0,255,  0,  8,  0, 77, 77, 77, 77,151,159,
   10, 11,  0,255,  0,  8,  0,151, 77, 78, 77, 77,  9, 10,126,  0,
  255,  0,  8,  0, 77, 77, 77,151, 78,  9,  9,126,  0,255,  0,  8,
    0,151, 77, 78, 77, 77,159, 10,126,  0,255,  0,  8,  0, 77, 77,
  151,151,151,159,  9,126,  0,255,
};

static const char boxll[]=
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 53,  0,  0,  0, 66,  0,  0,  0, 79,  0,  0,  0,
   92,  0,  0,  0,105,  0,  0,  0,118,  0,  0,  0,131,  0,  0,  0,
    0,  8,  0, 10,  9,  9, 10,  9, 10,  9, 10,  0,255,  0,  8,  0,
  126,126, 11,126,126,126, 10, 11,  0,255,  0,  8,  0,238,238,238,
  238,238, 10, 10,126,  0,255,  0,  8,  0, 77,151,151,151,151,159,
   10, 11,  0,255,  0,  8,  0,151,151, 77,151,151,  9, 10,126,  0,
  255,  0,  8,  0, 77, 77,151, 78,151,  9,  9,126,  0,255,  0,  8,
    0, 77, 78, 77,151, 77,159, 10,126,  0,255,  0,  8,  0, 77, 77,
   77, 78, 78,159,  9,126,  0,255,
};

static const char boxlr[]=
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 53,  0,  0,  0, 66,  0,  0,  0, 79,  0,  0,  0,
   92,  0,  0,  0,105,  0,  0,  0,118,  0,  0,  0,131,  0,  0,  0,
    0,  8,  0,151,151, 77,151,151,  9,  9, 11,  0,255,  0,  8,  0,
  151, 77, 77, 78, 77,159, 10,126,  0,255,  0,  8,  0, 76,151,151,
  151,151,  9,  9,126,  0,255,  0,  8,  0, 76, 76,151, 76,151,159,
   10,126,  0,255,  0,  8,  0,151, 76, 76,151,151,  9,  9,126,  0,
  255,  0,  8,  0,238,238,238,238,238,  9, 10,126,  0,255,  0,  8,
    0,126,126, 11,126,126,126, 10, 11,  0,255,  0,  8,  0, 10,  9,
    9, 10,  9, 10,  9, 10,  0,255,
};

static const char boxuc[]=
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 53,  0,  0,  0, 66,  0,  0,  0, 79,  0,  0,  0,
   92,  0,  0,  0,105,  0,  0,  0,118,  0,  0,  0,131,  0,  0,  0,
    0,  8,  0,  9, 11,239,151,151,151, 77, 77,  0,255,  0,  8,  0,
   10,126,239, 77, 77, 78, 77, 77,  0,255,  0,  8,  0,  9,126,239,
   78,151, 77, 78, 78,  0,255,  0,  8,  0, 10, 11,239, 77, 77, 78,
   77, 77,  0,255,  0,  8,  0, 10,126,239,151, 77, 77,151, 77,  0,
  255,  0,  8,  0,  9,126,239, 77, 78, 77, 77, 77,  0,255,  0,  8,
    0, 10,126,239, 78, 77, 77,151, 77,  0,255,  0,  8,  0,  9,126,
  239, 77, 78, 77, 77, 77,  0,255,
};

static const char boxul[]=
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 53,  0,  0,  0, 66,  0,  0,  0, 79,  0,  0,  0,
   92,  0,  0,  0,105,  0,  0,  0,118,  0,  0,  0,131,  0,  0,  0,
    0,  8,  0,159, 10, 10, 10, 10,  9, 10,  9,  0,255,  0,  8,  0,
   10, 11,126, 11,126,126,126,126,  0,255,  0,  8,  0, 10,126,239,
  238,238,238,238,238,  0,255,  0,  8,  0, 10, 11,239,151,151, 76,
   77,151,  0,255,  0,  8,  0, 10,126,239,151, 76,151,151,151,  0,
  255,  0,  8,  0,  9,126,239,151,151,151, 77, 77,  0,255,  0,  8,
    0, 10,126,239, 77, 78, 77, 77, 78,  0,255,  0,  8,  0,  9,126,
  239,151,151, 77, 77, 77,  0,255,
};

static const char boxur[]=  // end message background characters
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 53,  0,  0,  0, 66,  0,  0,  0, 79,  0,  0,  0,
   92,  0,  0,  0,105,  0,  0,  0,118,  0,  0,  0,131,  0,  0,  0,
    0,  8,  0,  9, 11,239, 78, 78, 77,151,151,  0,255,  0,  8,  0,
   10,126,239, 77,151, 77,151, 77,  0,255,  0,  8,  0,  9,126,239,
  151, 78,151, 76,151,  0,255,  0,  8,  0, 10,126,239,151,151, 77,
   76, 76,  0,255,  0,  8,  0,  9,126,239,151,151,151,151, 76,  0,
  255,  0,  8,  0, 10,126,239,238,238,238,238,238,  0,255,  0,  8,
    0, 10, 11,126, 11,126,126,126,126,  0,255,  0,  8,  0,159, 10,
   10, 10, 10,  9, 10,  9,  0,255,
};

static const char sttminus[]=  // minus on status bar
{
    8,  0,  6,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 50,  0,  0,  0, 61,  0,  0,  0, 72,  0,  0,  0,
   83,  0,  0,  0, 94,  0,  0,  0,105,  0,  0,  0,116,  0,  0,  0,
    0,  5,  0,191,191,191,191,191,  0,255,  0,  6,  0,191,180,182,
  186,191,109,  0,255,  0,  6,  0,191,177,183,186,191,109,  0,255,
    0,  6,  0,191,177,181,186,191,109,  0,255,  0,  6,  0,191,177,
  183,187,191,109,  0,255,  0,  6,  0,191,182,184,185,191,109,  0,
  255,  0,  6,  0,191,191,191,191,191,109,  0,255,  1,  5,  0,109,
  109,109,109,109,  0,255,
};

// This is like the ENDOOM lump in regular DOOM but the name has
// been changed so that standard DOOM/DOOM2 wads won't overwrite
// it

//jff 5/12/98 add maintenance 1 ENDBOOM lmp, with new URL

static const char endboom[] = {  // Ty 05/12/98 - changed url to teamtnt.com
    0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,
    0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,
    0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,
    0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,
    0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,
    0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,
    0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,
    0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,
    0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,
    0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,
    0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,
    0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,
    0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,
    0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,
    0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,
    0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,
    0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,
    0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,
    0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,
    0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,
    0x20,0x1e,0xda,0x1e,0xc4,0x1e,0xc4,0x1e,
    0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,
    0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,
    0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,
    0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,
    0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,
    0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,
    0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,
    0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,
    0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,
    0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,
    0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,
    0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,
    0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,
    0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,
    0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,
    0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,
    0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,
    0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,0xc4,0x1e,
    0xb7,0x1e,0x20,0x1e,0x20,0x10,0x20,0x10,
    0x20,0x1e,0xb3,0x1e,0x20,0x1e,0x20,0x40,
    0x20,0x40,0x20,0x40,0x20,0x40,0x20,0x40,
    0x20,0x40,0x20,0x40,0x20,0x40,0x20,0x40,
    0x20,0x40,0x20,0x40,0x20,0x40,0x20,0x40,
    0x20,0x40,0x20,0x40,0x20,0x40,0x20,0x40,
    0x20,0x40,0x42,0x4f,0x20,0x4f,0x4f,0x4f,
    0x20,0x4f,0x4f,0x4f,0x20,0x4f,0x4d,0x4f,
    0x20,0x4f,0x2d,0x4f,0x20,0x4f,0x61,0x4f,
    0x20,0x4f,0x44,0x4f,0x4f,0x4f,0x4f,0x4f,
    0x4d,0x4f,0x20,0x4f,0x65,0x4f,0x6e,0x4f,
    0x67,0x4f,0x69,0x4f,0x6e,0x4f,0x65,0x4f,
    0x20,0x4f,0x6d,0x4f,0x6f,0x4f,0x64,0x4f,
    0x69,0x4f,0x66,0x4f,0x69,0x4f,0x63,0x4f,
    0x61,0x4f,0x74,0x4f,0x69,0x4f,0x6f,0x4f,
    0x6e,0x4f,0x20,0x40,0x20,0x40,0x20,0x40,
    0x20,0x40,0x20,0x40,0x20,0x40,0x20,0x40,
    0x20,0x40,0x20,0x40,0x20,0x40,0x20,0x40,
    0x20,0x40,0x20,0x40,0x20,0x40,0x20,0x40,
    0x20,0x40,0x20,0x40,0x20,0x40,0x20,0x1e,
    0xba,0x1e,0xc4,0x10,0xb7,0x10,0x20,0x1e,
    0x20,0x1e,0xb3,0x1e,0x20,0x1e,0x20,0x40,
    0x20,0x40,0x20,0x40,0x20,0x40,0x20,0x40,
    0x20,0x40,0x20,0x40,0x20,0x40,0x20,0x40,
    0x20,0x40,0x44,0x4b,0x65,0x4b,0x73,0x4b,
    0x69,0x4b,0x67,0x4b,0x6e,0x4b,0x65,0x4b,
    0x64,0x4b,0x2c,0x4b,0x20,0x4b,0x69,0x4b,
    0x6d,0x4b,0x70,0x4b,0x6c,0x4b,0x65,0x4b,
    0x6d,0x4b,0x65,0x4b,0x6e,0x4b,0x74,0x4b,
    0x65,0x4b,0x64,0x4b,0x20,0x4b,0x61,0x4b,
    0x6e,0x4b,0x64,0x4b,0x20,0x4b,0x70,0x4b,
    0x72,0x4b,0x65,0x4b,0x73,0x4b,0x65,0x4b,
    0x6e,0x4b,0x74,0x4b,0x65,0x4b,0x64,0x4b,
    0x20,0x4b,0x74,0x4b,0x6f,0x4b,0x20,0x4b,
    0x79,0x4b,0x6f,0x4b,0x75,0x4b,0x20,0x4b,
    0x62,0x4b,0x79,0x4b,0x20,0x4b,0x54,0x4b,
    0x65,0x4b,0x61,0x4b,0x6d,0x4b,0x54,0x4b,
    0x4e,0x4b,0x54,0x4b,0x20,0x4b,0x20,0x40,
    0x20,0x40,0x20,0x40,0x20,0x40,0x20,0x40,
    0x20,0x40,0x20,0x40,0x20,0x40,0x20,0x1e,
    0xba,0x1e,0x20,0x10,0xba,0x10,0x20,0x10,
    0x20,0x1e,0xc6,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xb9,0x1e,0x20,0x10,0xba,0x10,0x20,0x10,
    0x20,0x1e,0xb3,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0xba,0x1e,0x20,0x10,0xba,0x10,0x20,0x1e,
    0x20,0x1e,0xb3,0x1e,0x20,0x1e,0x54,0x1e,
    0x68,0x1e,0x69,0x1e,0x73,0x1e,0x20,0x1e,
    0x69,0x1e,0x73,0x1e,0x20,0x1e,0x74,0x1e,
    0x68,0x1e,0x65,0x1e,0x20,0x1e,0x50,0x1e,
    0x68,0x1e,0x61,0x1e,0x73,0x1e,0x65,0x1e,
    0x20,0x1e,0x49,0x1e,0x20,0x1e,0x72,0x1e,
    0x65,0x1e,0x6c,0x1e,0x65,0x1e,0x61,0x1e,
    0x73,0x1e,0x65,0x1e,0x20,0x1e,0x6f,0x1e,
    0x66,0x1e,0x20,0x1e,0x74,0x1e,0x68,0x1e,
    0x65,0x1e,0x20,0x1e,0x42,0x1e,0x4f,0x1e,
    0x4f,0x1e,0x4d,0x1e,0x20,0x1e,0x65,0x1e,
    0x78,0x1e,0x65,0x1e,0x63,0x1e,0x75,0x1e,
    0x74,0x1e,0x61,0x1e,0x62,0x1e,0x6c,0x1e,
    0x65,0x1e,0x2c,0x1e,0x20,0x1e,0x61,0x1e,
    0x20,0x1e,0x44,0x1e,0x4f,0x1e,0x4f,0x1e,
    0x4d,0x1e,0x20,0x1e,0x73,0x1e,0x6f,0x1e,
    0x75,0x1e,0x72,0x1e,0x63,0x1e,0x65,0x1e,
    0x20,0x1e,0x63,0x1e,0x6f,0x1e,0x64,0x1e,
    0x65,0x1e,0x20,0x10,0x20,0x1e,0x20,0x1e,
    0xba,0x1e,0xcd,0x10,0xb9,0x10,0x20,0x1e,
    0x20,0x1e,0xb3,0x1e,0x20,0x1e,0x6d,0x1e,
    0x6f,0x1e,0x64,0x1e,0x69,0x1e,0x66,0x1e,
    0x69,0x1e,0x63,0x1e,0x61,0x1e,0x74,0x1e,
    0x69,0x1e,0x6f,0x1e,0x6e,0x1e,0x20,0x1e,
    0x62,0x1e,0x79,0x1e,0x20,0x1e,0x54,0x1e,
    0x65,0x1e,0x61,0x1e,0x6d,0x1e,0x54,0x1e,
    0x4e,0x1e,0x54,0x1e,0x2e,0x1e,0x20,0x1e,
    0x20,0x1e,0x50,0x1e,0x6c,0x1e,0x65,0x1e,
    0x61,0x1e,0x73,0x1e,0x65,0x1e,0x20,0x1e,
    0x72,0x1e,0x65,0x1e,0x76,0x1e,0x69,0x1e,
    0x65,0x1e,0x77,0x1e,0x20,0x1e,0x74,0x1e,
    0x68,0x1e,0x65,0x1e,0x20,0x1e,0x74,0x1e,
    0x65,0x1e,0x78,0x1e,0x74,0x1e,0x20,0x1e,
    0x66,0x1e,0x69,0x1e,0x6c,0x1e,0x65,0x1e,
    0x73,0x1e,0x20,0x1e,0x66,0x1e,0x6f,0x1e,
    0x72,0x1e,0x20,0x1e,0x69,0x1e,0x6e,0x1e,
    0x66,0x1e,0x6f,0x1e,0x72,0x1e,0x6d,0x1e,
    0x61,0x1e,0x74,0x1e,0x69,0x1e,0x6f,0x1e,
    0x6e,0x1e,0x20,0x10,0x20,0x1e,0x20,0x1e,
    0xba,0x1e,0x20,0x10,0xba,0x10,0x20,0x1e,
    0x20,0x1e,0xb3,0x1e,0x20,0x1e,0x61,0x1e,
    0x62,0x1e,0x6f,0x1e,0x75,0x1e,0x74,0x1e,
    0x20,0x1e,0x68,0x1e,0x6f,0x1e,0x77,0x1e,
    0x20,0x1e,0x74,0x1e,0x6f,0x1e,0x20,0x1e,
    0x70,0x1e,0x6c,0x1e,0x61,0x1e,0x79,0x1e,
    0x20,0x1e,0x77,0x1e,0x69,0x1e,0x74,0x1e,
    0x68,0x1e,0x20,0x1e,0x61,0x1e,0x6e,0x1e,
    0x64,0x1e,0x20,0x1e,0x65,0x1e,0x64,0x1e,
    0x69,0x1e,0x74,0x1e,0x20,0x1e,0x66,0x1e,
    0x6f,0x1e,0x72,0x1e,0x20,0x1e,0x74,0x1e,
    0x68,0x1e,0x65,0x1e,0x20,0x1e,0x6e,0x1e,
    0x65,0x1e,0x77,0x1e,0x20,0x1e,0x65,0x1e,
    0x6e,0x1e,0x67,0x1e,0x69,0x1e,0x6e,0x1e,
    0x65,0x1e,0x20,0x1e,0x66,0x1e,0x65,0x1e,
    0x61,0x1e,0x74,0x1e,0x75,0x1e,0x72,0x1e,
    0x65,0x1e,0x73,0x1e,0x2e,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0xba,0x1e,0x20,0x10,0xba,0x10,0x20,0x1e,
    0x20,0x1e,0xb3,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0xba,0x1e,0x20,0x10,0xba,0x10,0x20,0x1e,
    0x20,0x1e,0xb3,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x0e,0x28,0x0e,
    0x43,0x0e,0x29,0x0e,0x20,0x0e,0x43,0x0e,
    0x6f,0x0e,0x70,0x0e,0x79,0x0e,0x72,0x0e,
    0x69,0x0e,0x67,0x0e,0x68,0x0e,0x74,0x0e,
    0x20,0x0e,0x31,0x0e,0x39,0x0e,0x39,0x0e,
    0x38,0x0e,0x2c,0x0e,0x20,0x0e,0x54,0x0e,
    0x65,0x0e,0x61,0x0e,0x6d,0x0e,0x54,0x0e,
    0x4e,0x0e,0x54,0x0e,0x20,0x0e,0x2d,0x0e,
    0x20,0x0e,0x41,0x0e,0x6c,0x0e,0x6c,0x0e,
    0x20,0x0e,0x72,0x0e,0x69,0x0e,0x67,0x0e,
    0x68,0x0e,0x74,0x0e,0x73,0x0e,0x20,0x0e,
    0x72,0x0e,0x65,0x0e,0x73,0x0e,0x65,0x0e,
    0x72,0x0e,0x76,0x0e,0x65,0x0e,0x64,0x0e,
    0x20,0x0e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1c,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0xba,0x1e,0x20,0x10,0xba,0x10,0x20,0x1e,
    0x20,0x1e,0xb3,0x1e,0x20,0x1e,0xda,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xbf,0x10,0x20,0x1e,
    0xba,0x1e,0x20,0x10,0xba,0x10,0x20,0x1e,
    0x20,0x1e,0xb3,0x1e,0x20,0x1e,0xb3,0x10,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x10,0x20,0x1e,0xb3,0x10,0x20,0x1e,
    0xba,0x1e,0x20,0x10,0xba,0x10,0x20,0x1e,
    0x20,0x1e,0xb3,0x1e,0x20,0x1e,0xb3,0x10,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x54,0x1a,
    0x68,0x1a,0x61,0x1a,0x6e,0x1a,0x6b,0x1a,
    0x73,0x1a,0x20,0x1a,0x66,0x1a,0x6f,0x1a,
    0x72,0x1a,0x20,0x1a,0x70,0x1a,0x6c,0x1a,
    0x61,0x1a,0x79,0x1a,0x69,0x1a,0x6e,0x1a,
    0x67,0x1a,0x21,0x1a,0x20,0x1a,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x10,0x20,0x1e,0xb3,0x10,0x20,0x1e,
    0xba,0x1e,0x20,0x10,0xba,0x10,0x20,0x1e,
    0x20,0x1e,0xb3,0x1e,0x20,0x1e,0xb3,0x10,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x10,0x20,0x1e,0xb3,0x10,0x20,0x1e,
    0xba,0x1e,0x20,0x10,0xba,0x10,0x20,0x1e,
    0x20,0x1e,0xb3,0x1e,0x20,0x1e,0xc0,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xc4,0x10,0xc4,0x10,
    0xc4,0x10,0xc4,0x10,0xd9,0x10,0x20,0x1e,
    0xba,0x1e,0x20,0x10,0xba,0x10,0x20,0x1e,
    0x20,0x1e,0xb3,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x44,0x1e,0x4f,0x1e,
    0x4f,0x1e,0x4d,0x1e,0x20,0x1e,0x69,0x1e,
    0x73,0x1e,0x20,0x1e,0x43,0x1e,0x6f,0x1e,
    0x70,0x1e,0x79,0x1e,0x72,0x1e,0x69,0x1e,
    0x67,0x1e,0x68,0x1e,0x74,0x1e,0x20,0x1e,
    0x28,0x1e,0x43,0x1e,0x29,0x1e,0x20,0x1e,
    0x69,0x1e,0x64,0x1e,0x20,0x1e,0x53,0x1e,
    0x6f,0x1e,0x66,0x1e,0x74,0x1e,0x77,0x1e,
    0x61,0x1e,0x72,0x1e,0x65,0x1e,0x20,0x1e,
    0x61,0x1e,0x6e,0x1e,0x64,0x1e,0x20,0x1e,
    0x74,0x1e,0x68,0x1e,0x65,0x1e,0x20,0x1e,
    0x73,0x1e,0x6f,0x1e,0x75,0x1e,0x72,0x1e,
    0x63,0x1e,0x65,0x1e,0x20,0x1e,0x69,0x1e,
    0x73,0x1e,0x20,0x1e,0x6d,0x1e,0x6f,0x1e,
    0x64,0x1e,0x69,0x1e,0x66,0x1e,0x69,0x1e,
    0x65,0x1e,0x64,0x1e,0x20,0x1e,0x77,0x1e,
    0x69,0x1e,0x74,0x1e,0x68,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0xba,0x1e,0x20,0x10,0xba,0x10,0x20,0x1e,
    0x20,0x1e,0xb3,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x74,0x1e,0x68,0x1e,0x65,0x1e,0x69,0x1e,
    0x72,0x1e,0x20,0x1e,0x70,0x1e,0x65,0x1e,
    0x72,0x1e,0x6d,0x1e,0x69,0x1e,0x73,0x1e,
    0x73,0x1e,0x69,0x1e,0x6f,0x1e,0x6e,0x1e,
    0x20,0x1e,0x62,0x1e,0x61,0x1e,0x73,0x1e,
    0x65,0x1e,0x64,0x1e,0x20,0x1e,0x6f,0x1e,
    0x6e,0x1e,0x20,0x1e,0x74,0x1e,0x68,0x1e,
    0x65,0x1e,0x20,0x1e,0x70,0x1e,0x75,0x1e,
    0x62,0x1e,0x6c,0x1e,0x69,0x1e,0x63,0x1e,
    0x20,0x1e,0x72,0x1e,0x65,0x1e,0x6c,0x1e,
    0x65,0x1e,0x61,0x1e,0x73,0x1e,0x65,0x1e,
    0x20,0x1e,0x69,0x1e,0x6e,0x1e,0x20,0x1e,
    0x44,0x1e,0x65,0x1e,0x63,0x1e,0x65,0x1e,
    0x6d,0x1e,0x62,0x1e,0x65,0x1e,0x72,0x1e,
    0x20,0x1e,0x31,0x1e,0x39,0x1e,0x39,0x1e,
    0x37,0x1e,0x2e,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0xba,0x1e,0x20,0x10,0xba,0x10,0x20,0x1e,
    0x20,0x1e,0xb3,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0xba,0x1e,0x20,0x10,0xba,0x10,0x20,0x1e,
    0x20,0x1e,0xb3,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x0e,
    0x20,0x0e,0x4b,0x0e,0x65,0x0e,0x65,0x0e,
    0x70,0x0e,0x20,0x0e,0x75,0x0e,0x70,0x0e,
    0x20,0x0e,0x77,0x0e,0x69,0x0e,0x74,0x0e,
    0x68,0x0e,0x20,0x0e,0x54,0x0e,0x65,0x0e,
    0x61,0x0e,0x6d,0x0e,0x54,0x0e,0x4e,0x0e,
    0x54,0x0e,0x20,0x0e,0x67,0x0e,0x6f,0x0e,
    0x69,0x0e,0x6e,0x0e,0x67,0x0e,0x73,0x0e,
    0x20,0x0e,0x6f,0x0e,0x6e,0x0e,0x2e,0x0e,
    0x20,0x0e,0x20,0x0e,0x53,0x0e,0x65,0x0e,
    0x65,0x0e,0x20,0x0e,0x6f,0x0e,0x75,0x0e,
    0x72,0x0e,0x20,0x0e,0x77,0x0e,0x65,0x0e,
    0x62,0x0e,0x20,0x0e,0x70,0x0e,0x61,0x0e,
    0x67,0x0e,0x65,0x0e,0x20,0x0e,0x61,0x0e,
    0x74,0x0e,0x3a,0x0e,0x20,0x0e,0x20,0x0e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0xba,0x1e,0x20,0x10,0xba,0x10,0x20,0x1e,
    0x20,0x1e,0xb3,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x0e,
    0x20,0x0e,0x20,0x0e,0x20,0x0e,0x20,0x0e,
    0x20,0x0e,0x20,0x0e,0x20,0x0e,0x20,0x0e,
    0x20,0x0e,0x20,0x0e,0x20,0x0e,0x20,0x0e,
    0x20,0x0e,0x20,0x0e,0x20,0x0e,0x3c,0x0e,
    0x68,0x0e,0x74,0x0e,0x74,0x0e,0x70,0x0e,
    0x3a,0x0e,0x2f,0x0e,0x2f,0x0e,0x77,0x0e,
    0x77,0x0e,0x77,0x0e,0x2e,0x0e,0x74,0x0e,
    0x65,0x0e,0x61,0x0e,0x6d,0x0e,0x74,0x0e,
    0x6e,0x0e,0x74,0x0e,0x2e,0x0e,0x63,0x0e,
    0x6f,0x0e,0x6d,0x0e,0x3e,0x0e,0x20,0x0e,
    0x20,0x0e,0x20,0x0e,0x20,0x0e,0x20,0x0e,
    0x20,0x0e,0x20,0x0e,0x20,0x0e,0x20,0x0e,
    0x20,0x0e,0x20,0x0e,0x20,0x0e,0x20,0x0e,
    0x20,0x0e,0x20,0x0e,0x20,0x0e,0x20,0x0e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0x20,0x1e,
    0xba,0x1e,0x20,0x10,0xba,0x10,0x20,0x1e,
    0x20,0x1f,0xb3,0x1e,0x20,0x1f,0x20,0x1f,
    0x20,0x1f,0x20,0x1f,0x20,0x1f,0x20,0x1f,
    0x20,0x1f,0x20,0x1f,0x20,0x1f,0x20,0x1f,
    0x20,0x1f,0x20,0x1f,0x20,0x1f,0x20,0x1f,
    0x20,0x1f,0x20,0x1f,0x20,0x1f,0x20,0x1f,
    0x20,0x1f,0x20,0x1f,0x20,0x1f,0x20,0x1f,
    0x20,0x1f,0x20,0x1f,0x20,0x1f,0x20,0x1f,
    0x20,0x1f,0x20,0x1f,0x20,0x1f,0x20,0x1f,
    0x20,0x1f,0x20,0x1f,0x20,0x1f,0x20,0x1f,
    0x20,0x1f,0x20,0x1f,0x20,0x1f,0x20,0x1f,
    0x20,0x1f,0x20,0x1f,0x20,0x1f,0x20,0x1f,
    0x20,0x1f,0x20,0x1f,0x20,0x1f,0x20,0x1f,
    0x20,0x1f,0x20,0x1f,0x20,0x1f,0x20,0x1f,
    0x20,0x1f,0x20,0x1f,0x20,0x1f,0x20,0x1f,
    0x20,0x1f,0x20,0x1f,0x20,0x1f,0x20,0x1f,
    0x20,0x1f,0x20,0x1f,0x20,0x1f,0x20,0x1f,
    0x20,0x1f,0x20,0x1f,0x20,0x1f,0x20,0x1f,
    0x20,0x1f,0x20,0x1f,0x20,0x1f,0x20,0x1f,
    0x20,0x1f,0x20,0x1f,0x20,0x1f,0x20,0x1f,
    0xba,0x1e,0x20,0x10,0xba,0x10,0x20,0x1f,
    0x20,0x1e,0xd4,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,0xcd,0x1e,
    0xbc,0x1e,0x20,0x10,0xba,0x10,0x20,0x1e,
    0x20,0x1e,0x20,0x1e,0x20,0x1e,0xd4,0x10,
    0xcd,0x10,0xcd,0x10,0xcd,0x10,0xcd,0x10,
    0xcd,0x10,0xcd,0x10,0xcd,0x10,0xcd,0x10,
    0xcd,0x10,0xcd,0x10,0xcd,0x10,0xcd,0x10,
    0xcd,0x10,0xcd,0x10,0xcd,0x10,0xcd,0x10,
    0xcd,0x10,0xcd,0x10,0xcd,0x10,0xcd,0x10,
    0xcd,0x10,0xcd,0x10,0xcd,0x10,0xcd,0x10,
    0xcd,0x10,0xcd,0x10,0xcd,0x10,0xcd,0x10,
    0xcd,0x10,0xcd,0x10,0xcd,0x10,0xcd,0x10,
    0xcd,0x10,0xcd,0x10,0xcd,0x10,0xcd,0x10,
    0xcd,0x10,0xcd,0x10,0xcd,0x10,0xcd,0x10,
    0xcd,0x10,0xcd,0x10,0xcd,0x10,0xcd,0x10,
    0xcd,0x10,0xcd,0x10,0xcd,0x10,0xcd,0x10,
    0xcd,0x10,0xcd,0x10,0xcd,0x10,0xcd,0x10,
    0xcd,0x10,0xcd,0x10,0xcd,0x10,0xcd,0x10,
    0xcd,0x10,0xcd,0x10,0xcd,0x10,0xcd,0x10,
    0xcd,0x10,0xcd,0x10,0xcd,0x10,0xcd,0x10,
    0xcd,0x10,0xcd,0x10,0xcd,0x10,0xcd,0x10,
    0xcd,0x10,0xcd,0x10,0xcd,0x10,0xcd,0x10,
    0xcd,0x10,0xcd,0x10,0xbc,0x10,0x20,0x1e,
    0x20,0x07,0x20,0x07,0x20,0x07,0x20,0x07,
    0x20,0x07,0x20,0x07,0x20,0x07,0x20,0x07,
    0x20,0x07,0x20,0x07,0x20,0x07,0x20,0x07,
    0x20,0x07,0x20,0x07,0x20,0x07,0x20,0x07,
    0x20,0x07,0x20,0x07,0x20,0x07,0x20,0x07,
    0x20,0x07,0x20,0x07,0x20,0x07,0x20,0x07,
    0x20,0x07,0x20,0x07,0x20,0x07,0x20,0x07,
    0x20,0x07,0x20,0x07,0x20,0x07,0x20,0x07,
    0x20,0x07,0x20,0x07,0x20,0x07,0x20,0x07,
    0x20,0x07,0x20,0x07,0x20,0x07,0x20,0x07,
    0x20,0x07,0x20,0x07,0x20,0x07,0x20,0x07,
    0x20,0x07,0x20,0x07,0x20,0x07,0x20,0x07,
    0x20,0x07,0x20,0x07,0x20,0x07,0x20,0x07,
    0x20,0x07,0x20,0x07,0x20,0x07,0x20,0x07,
    0x20,0x07,0x20,0x07,0x20,0x07,0x20,0x07,
    0x20,0x07,0x20,0x07,0x20,0x07,0x20,0x07,
    0x20,0x07,0x20,0x07,0x20,0x07,0x20,0x07,
    0x20,0x07,0x20,0x07,0x20,0x07,0x20,0x07,
    0x20,0x07,0x20,0x07,0x20,0x07,0x20,0x07,
    0x20,0x07,0x20,0x07,0x20,0x07,0x20,0x07};

// An invisible sprite, used for the TNT1 sprite for point wind
static const char invis_sprite[]=
{
    1,  0,  1,  0,  0,  0,  0,  0,
   12,  0,  0,  0,255,
};

// A new setup menu was added in BOOM, and the various menu graphic
// text strings etc. are included here.

// phares 3/31/98
//
// Lumps for menus

static const char m_keybnd[]= // "Key Bindings" 
{
  152,  0, 15,  0,  0,  0,  0,  0,
  104,  2,  0,  0,124,  2,  0,  0,144,  2,  0,  0,164,  2,  0,  0,
  184,  2,  0,  0,204,  2,  0,  0,224,  2,  0,  0,234,  2,  0,  0,
  246,  2,  0,  0,  4,  3,  0,  0, 20,  3,  0,  0, 38,  3,  0,  0,
   61,  3,  0,  0, 82,  3,  0,  0,101,  3,  0,  0,118,  3,  0,  0,
  139,  3,  0,  0,160,  3,  0,  0,176,  3,  0,  0,191,  3,  0,  0,
  208,  3,  0,  0,225,  3,  0,  0,242,  3,  0,  0,  3,  4,  0,  0,
   20,  4,  0,  0, 37,  4,  0,  0, 54,  4,  0,  0, 71,  4,  0,  0,
   88,  4,  0,  0,105,  4,  0,  0,114,  4,  0,  0,124,  4,  0,  0,
  135,  4,  0,  0,147,  4,  0,  0,163,  4,  0,  0,178,  4,  0,  0,
  192,  4,  0,  0,206,  4,  0,  0,221,  4,  0,  0,237,  4,  0,  0,
  249,  4,  0,  0,  4,  5,  0,  0, 14,  5,  0,  0, 23,  5,  0,  0,
   31,  5,  0,  0, 32,  5,  0,  0, 33,  5,  0,  0, 34,  5,  0,  0,
   35,  5,  0,  0, 36,  5,  0,  0, 37,  5,  0,  0, 38,  5,  0,  0,
   39,  5,  0,  0, 40,  5,  0,  0, 60,  5,  0,  0, 80,  5,  0,  0,
  100,  5,  0,  0,120,  5,  0,  0,140,  5,  0,  0,160,  5,  0,  0,
  183,  5,  0,  0,206,  5,  0,  0,229,  5,  0,  0,252,  5,  0,  0,
   16,  6,  0,  0, 36,  6,  0,  0, 54,  6,  0,  0, 72,  6,  0,  0,
   88,  6,  0,  0,105,  6,  0,  0,122,  6,  0,  0,139,  6,  0,  0,
  156,  6,  0,  0,173,  6,  0,  0,190,  6,  0,  0,206,  6,  0,  0,
  223,  6,  0,  0,240,  6,  0,  0,  1,  7,  0,  0, 17,  7,  0,  0,
   29,  7,  0,  0, 41,  7,  0,  0, 53,  7,  0,  0, 64,  7,  0,  0,
   81,  7,  0,  0, 98,  7,  0,  0,115,  7,  0,  0,132,  7,  0,  0,
  148,  7,  0,  0,165,  7,  0,  0,182,  7,  0,  0,199,  7,  0,  0,
  216,  7,  0,  0,233,  7,  0,  0,250,  7,  0,  0, 11,  8,  0,  0,
   28,  8,  0,  0, 45,  8,  0,  0, 62,  8,  0,  0, 79,  8,  0,  0,
   94,  8,  0,  0,109,  8,  0,  0,122,  8,  0,  0,139,  8,  0,  0,
  156,  8,  0,  0,173,  8,  0,  0,190,  8,  0,  0,207,  8,  0,  0,
  224,  8,  0,  0,240,  8,  0,  0,  1,  9,  0,  0, 18,  9,  0,  0,
   35,  9,  0,  0, 51,  9,  0,  0, 63,  9,  0,  0, 75,  9,  0,  0,
   87,  9,  0,  0, 98,  9,  0,  0,115,  9,  0,  0,132,  9,  0,  0,
  149,  9,  0,  0,166,  9,  0,  0,182,  9,  0,  0,197,  9,  0,  0,
  210,  9,  0,  0,225,  9,  0,  0,240,  9,  0,  0,  1, 10,  0,  0,
   18, 10,  0,  0, 35, 10,  0,  0, 52, 10,  0,  0, 69, 10,  0,  0,
   86, 10,  0,  0,106, 10,  0,  0,126, 10,  0,  0,146, 10,  0,  0,
  166, 10,  0,  0,186, 10,  0,  0,203, 10,  0,  0,222, 10,  0,  0,
  239, 10,  0,  0,  0, 11,  0,  0, 17, 11,  0,  0, 34, 11,  0,  0,
   51, 11,  0,  0, 68, 11,  0,  0, 85, 11,  0,  0,102, 11,  0,  0,
  119, 11,  0,  0,136, 11,  0,  0,153, 11,  0,  0,172, 11,  0,  0,
    0, 15,  0,191,191,191,191,191,191,191,191,191,191,191,191,191,
  191,191,  0,255,  0, 15,  0,191,184,185,185,186,185,185,185,185,
  185,185,184,184,185,189,  0,255,  0, 15,  0,191,181,187,186,186,
  186,187,187,187,185,185,183,182,185,191,  0,255,  0, 15,  0,191,
  181,188,187,186,187,189,189,189,187,186,185,185,187,191,  0,255,
    0, 15,  0,191,185,189,189,189,187,188, 46, 44,186,186,186,188,
   45,191,  0,255,  0, 15,  0,191,191,191,191,191,191,187,187,187,
  191,191,191,191,191,191,  0,255,  5,  5,  0,191,183,188,187,191,
    0,255,  4,  7,  0,191,182,187,187,187,189,191,  0,255,  3,  9,
    0,191,182,185,186,187,187,185,187,191,  0,255,  2, 11,  0,191,
  180,181,182,185,186,187,187,187,188,191,  0,255,  1, 13,  0,191,
  182,184,181,183,187,191,182,186,186,185,187,191,  0,255,  0,  7,
    0,191,180,186,185,184,186,191,  0,  8,  7,  0,191,180,183,183,
  183,188,191,  0,255,  0,  6,  0,191,181,185,185,187,191,  0,  9,
    6,  0,191,182,185,184,185,191,  0,255,  0,  5,  0,191,181,189,
  189,191,  0, 10,  5,  0,191,180,183,186,191,  0,255,  0,  4,  0,
  191,180,188,191,  0, 11,  4,  0,191,182,187,191,  0,255,  0,  3,
    0,191,184,191,  0,  6,  9,  0, 47, 47, 47, 47, 47, 47,191,185,
  191,  0,255,  0,  2,  0,191,191,  0,  5, 10,  0,191,191,186,185,
  185,186,191,191, 47, 47,  0,255,  4, 11,  0,191,188,185,182,182,
  182,181,183,188,191, 47,  0,255,  4, 10,  0,191,183,181,181,181,
  182,181,178,185,191,  0,255,  3, 12,  0,191,185,182,181,181,181,
  181,180,179,179,186,191,  0,255,  3, 12,  0,191,180,182,185,185,
  181,182,185,185,181,184,191,  0,255,  3, 12,  0,191,182,186,191,
  191,181,186,191,191,179,185,191,  0,255,  3, 12,  0,191,179,187,
  191,191,180,188,191,191,178,185,191,  0,255,  3, 12,  0,191,179,
  186,191,191,180,187,191,191,178,186,191,  0,255,  3, 12,  0,191,
  180,188,191,191,180,188,191,191,178,185,191,  0,255,  3, 12,  0,
  191,180,188,191,191,178,186,191,191,179,186,191,  0,255,  3, 12,
    0,191,179,185,191,191,178,185,191,191,180,186,191,  0,255,  3,
   12,  0,191,184,187,191,191,185,187,191,191,183,186,191,  0,255,
    3, 12,  0,191,191,191, 47, 47, 47, 47, 47, 47, 47, 47, 47,  0,
  255,  3,  4,  0,191,180,187,191,  0,255,  3,  5,  0,191,180,185,
  186,191,  0,255,  3,  6,  0,191,177,181,183,186,191,  0,255,  3,
    7,  0,191,177,178,180,182,186,191,  0,255,  4, 11,  0,191,179,
  179,178,178,184,191,191,191,191,191,  0,255,  5, 10,  0,191,179,
  181,183,183,185,186,187,187,191,  0,255,  6,  9,  0,191,177,182,
  182,182,182,184,186,191,  0,255,  6,  9,  0,191,177,182,182,182,
  181,181,185,191,  0,255,  5, 10,  0,191,179,181,182,181,183,182,
  182,185,191,  0,255,  4, 11,  0,191,178,181,180,182,184,191,191,
  191,191,191,  0,255,  3,  7,  0,191,178,181,182,182,185,191,  0,
  255,  3,  6,  0,191,178,180,181,185,191,  0,255,  3,  5,  0,191,
  177,181,185,191,  0,255,  3,  4,  0,191,178,185,191,  0,255,  3,
    3,  0,191,191,191,  0,255,255,255,255,255,255,255,255,255,255,
    0, 15,  0,191,191,191,191,191,191,191,191,191,191,191,191,191,
  191,191,  0,255,  0, 15,  0,191,182,184,186,191,191,186,186,185,
  185,185,186,186,186,191,  0,255,  0, 15,  0,191,179,183,186,191,
  191,180,184,184,183,182,183,183,184,191,  0,255,  0, 15,  0,191,
  180,184,186,191,191,180,184,184,183,183,183,184,185,191,  0,255,
    0, 15,  0,191,180,183,186,191,191,180,183,184,185,185,184,183,
  185,191,  0,255,  0, 15,  0,191,177,181,185,191,191,180,187,191,
   47,191,177,181,185,191,  0,255,  0,  9,  0,191,177,182,184,191,
  191,177,187,191,  0, 10,  5,  0, 47,177,182,185,191,  0,255,  0,
    9,  0,191,177,182,185,191,191,178,185,191,  0, 10,  5,  0, 47,
  177,182,185,191,  0,255,  0,  9,  0,191,178,183,185,191,191,179,
  185, 45,  0, 10,  5,  0, 47,177,183,185,191,  0,255,  0,  9,  0,
  191,180,183,185,191,191,180,187, 47,  0, 10,  5,  0,191,177,183,
  185,191,  0,255,  0, 15,  0,191,181,184,186,191,191,180,182,187,
   47,181,184,184,185,191,  0,255,  0, 15,  0,191,182,185,184,186,
  186,181,181,181,181,182,184,185,185,191,  0,255,  1, 13,  0,191,
  183,184,183,181,180,178,178,178,183,184,183,191,  0,255,  1, 13,
    0,191,187,183,183,184,182,182,182,179,183,183,187,191,  0,255,
    2, 11,  0,191,187,184,184,187, 47,187,184,184,187,191,  0,255,
    3, 12,  0,191,191,191,191,191,191,191,191,191,191,191,191,  0,
  255,  3, 12,  0,191,183,185,184,185,185,185,184,184,184,186,191,
    0,255,  3, 12,  0,191,179,185,186,186,186,187,185,183,181,185,
  191,  0,255,  3, 12,  0,191,179,184,184,186,185,185,187,185,184,
  186,191,  0,255,  3, 12,  0,191,184,187,186,186,186,187,187,186,
  185,186,191,  0,255,  3, 12,  0,191,191,191,191,191,191,191,191,
  191,191,191,191,  0,255,  4, 11,  0,191,184,185,185,186,186,186,
  186,187,187,191,  0,255,  3, 12,  0,191,177,180,182,181,182,182,
  182,181,181,185,191,  0,255,  3, 12,  0,191,177,181,181,181,182,
  181,180,179,179,184,191,  0,255,  3, 12,  0,191,186,180,181,180,
  182,180,183,184,184,186,191,  0,255,  4, 11,  0,191,186,182,182,
  182,182,191,191,191,191,191,  0,255,  5,  7,  0,191,186,182,182,
  182,186,191,  0,255,  6,  7,  0,191,186,182,180,178,186,191,  0,
  255,  7,  7,  0,191,186,178,178,178,186,191,  0,255,  8,  6,  0,
  191,186,180,181,179,191,  0,255,  3, 12,  0,191,191,191,191,191,
  191,191,180,180,178,186,191,  0,255,  3, 12,  0,191,184,182,182,
  183,183,182,178,178,178,184,191,  0,255,  3, 12,  0,191,176,176,
  176,176,176,176,176,176,176,182,191,  0,255,  3, 12,  0,191,177,
  180,181,180,179,179,179,179,178,184,191,  0,255,  3, 11,  0,191,
  184,184,185,185,185,185,185,185,187,191,  0,255,  3, 12,  0,191,
   45, 47,191,191,191,191,191,191,191,191,191,  0,255,  3, 12,  0,
  191,184,187,191,191,184,185,184,184,184,186,191,  0,255,  3, 12,
    0,191,178,186,191,191,181,183,183,182,183,185,191,  0,255,  3,
   12,  0,191,178,185,191,191,181,184,183,182,181,185,191,  0,255,
    3, 12,  0,191,178,185,191,191,184,185,185,184,180,184,191,  0,
  255,  3, 12,  0,191,178,185,191,191,191,191,191,191,178,184,191,
    0,255,  3,  4,  0,191,177,184,191,  0, 11,  4,  0,191,177,184,
  191,  0,255,  3,  4,  0,191,177,184,191,  0, 11,  4,  0,191,177,
  184,191,  0,255,  3,  4,  0,191,178,185,191,  0, 11,  4,  0,191,
  180,185,191,  0,255,  3, 12,  0,191,180,182,185,191,191,191,191,
  180,181,185,191,  0,255,  3, 12,  0,191,186,182,181,181,181,181,
  180,180,179,186,191,  0,255,  4, 10,  0,191,181,180,178,178,178,
  178,178,183,191,  0,255,  4, 10,  0,191,187,182,182,180,179,179,
  183,187,191,  0,255,  5,  8,  0,191,191,187,185,185,187,191,191,
    0,255,  3, 12,  0,191,191,191,191,191,191,191,191,191,191,191,
  191,  0,255,  3, 12,  0,191,183,185,184,185,185,185,184,184,184,
  186,191,  0,255,  3, 12,  0,191,179,185,186,186,186,187,185,183,
  181,185,191,  0,255,  3, 12,  0,191,179,184,184,186,185,185,187,
  185,184,186,191,  0,255,  3, 12,  0,191,184,187,186,186,186,187,
  187,186,185,186,191,  0,255,  3, 12,  0,191,191,191,191,191,191,
  191,191,191,191,191,191,  0,255,  4, 11,  0,191,184,185,185,186,
  186,186,186,187,187,191,  0,255,  3, 12,  0,191,177,180,182,181,
  182,182,182,181,181,185,191,  0,255,  3, 12,  0,191,177,181,181,
  181,182,181,180,179,179,184,191,  0,255,  3, 12,  0,191,186,180,
  181,180,182,180,183,184,184,186,191,  0,255,  4, 11,  0,191,186,
  182,182,182,182,191,191,191,191,191,  0,255,  5,  7,  0,191,186,
  182,182,182,186,191,  0,255,  6,  7,  0,191,186,182,180,178,186,
  191,  0,255,  7,  7,  0,191,186,178,178,178,186,191,  0,255,  8,
    6,  0,191,186,180,181,179,191,  0,255,  3, 12,  0,191,191,191,
  191,191,191,191,180,180,178,186,191,  0,255,  3, 12,  0,191,184,
  182,182,183,183,182,178,178,178,184,191,  0,255,  3, 12,  0,191,
  176,176,176,176,176,176,176,176,176,182,191,  0,255,  3, 12,  0,
  191,177,180,181,180,179,179,179,179,178,184,191,  0,255,  3, 11,
    0,191,184,184,185,185,185,185,185,185,187,191,  0,255,  3, 10,
    0,191, 45, 47,191,191,191,191,191,191, 47,  0,255,  5,  8,  0,
  191,191,187,186,186,186,191,191,  0,255,  4, 10,  0,191,188,182,
  183,184,184,181,179,188,191,  0,255,  4, 10,  0,191,184,184,184,
  184,184,184,184,183,191,  0,255,  3, 12,  0,191,187,185,185,185,
  186,186,187,187,187,189,191,  0,255,  3, 12,  0,191,184,188,188,
  191,191,191,191,188,188, 44,191,  0,255,  3,  4,  0,191,184,189,
  191,  0, 11,  4,  0,191,183,187,191,  0,255,  3,  4,  0,191,181,
  188,191,  0, 11,  4,  0,191,178,187,191,  0,255,  3,  4,  0,191,
  180,188,191,  0, 11,  4,  0,191,177,184,191,  0,255,  3,  4,  0,
  191,178,184,191,  0, 11,  4,  0,191,178,187,191,  0,255,  3,  4,
    0,191,178,186,191,  0,  8,  7,  0,191,191,191,191,179,186,191,
    0,255,  3,  4,  0,191,178,184,191,  0,  8,  7,  0,191,182,184,
  185,184,186,191,  0,255,  3,  4,  0,191,178,185,191,  0,  8,  7,
    0,191,177,178,178,178,183,191,  0,255,  3,  4,  0,191,180,185,
  191,  0,  8,  7,  0,191,177,177,177,177,183,191,  0,255,  3,  4,
    0,191,185,187,191,  0,  8,  7,  0,191,184,185,185,185,186,191,
    0,255,  3, 12,  0, 47, 47,191,191,191,191, 47, 47,191,191,191,
  191,  0,255,  4,  6,  0,191,187,185,185,187,191,  0, 11,  4,  0,
  191,184,186,191,  0,255,  3, 12,  0,191,182,180,180,180,180,186,
  191,191,178,186,191,  0,255,  3, 12,  0,191,179,180,180,179,180,
  188,191,191,177,185,191,  0,255,  3, 12,  0,191,178,184,184,184,
  183,186,191,191,177,186,191,  0,255,  3, 12,  0,191,178,187,191,
  191,179,188,191,191,179,188,191,  0,255,  3, 12,  0,191,178,188,
  191,191,178,186,191,191,178,186,191,  0,255,  3, 12,  0,191,178,
  187,191,191,178,185,191,191,179,187,191,  0,255,  3, 12,  0,191,
  180,186,191,191,178,186,191,191,182,186,191,  0,255,  3, 12,  0,
  191,182,186,191,191,180,188,191,191,181,185,191,  0,255,  3, 12,
    0,191,180,186,191,191,180,188,188,187,182,185,191,  0,255,  3,
   12,  0,191,183,189,191,191,182,184,184,184,184,186,191,  0,255,
    3, 12,  0,191,185, 45,191,191,186,184,185,185,184,188,191,  0,
  255,  3,  4,  0,191,186,188,191,  0,  8,  6,  0,191,187,186,186,
  187,191,  0,255,  3,  4,  0,191,191,191,191,  0,  9,  4,  0,191,
  191,191,191,  0,255,
};

static const char m_setup[]=  // "Setup" 
{
   67,  0, 15,  0,  0,  0,  0,  0,
   20,  1,  0,  0, 29,  1,  0,  0, 49,  1,  0,  0, 71,  1,  0,  0,
   90,  1,  0,  0,110,  1,  0,  0,130,  1,  0,  0,150,  1,  0,  0,
  170,  1,  0,  0,190,  1,  0,  0,210,  1,  0,  0,230,  1,  0,  0,
  250,  1,  0,  0, 13,  2,  0,  0, 35,  2,  0,  0, 55,  2,  0,  0,
   65,  2,  0,  0, 78,  2,  0,  0, 93,  2,  0,  0,108,  2,  0,  0,
  125,  2,  0,  0,142,  2,  0,  0,159,  2,  0,  0,176,  2,  0,  0,
  193,  2,  0,  0,210,  2,  0,  0,227,  2,  0,  0,244,  2,  0,  0,
    5,  3,  0,  0, 22,  3,  0,  0, 31,  3,  0,  0, 40,  3,  0,  0,
   57,  3,  0,  0, 74,  3,  0,  0, 91,  3,  0,  0,108,  3,  0,  0,
  125,  3,  0,  0,142,  3,  0,  0,151,  3,  0,  0,164,  3,  0,  0,
  179,  3,  0,  0,195,  3,  0,  0,211,  3,  0,  0,228,  3,  0,  0,
  245,  3,  0,  0,254,  3,  0,  0,  7,  4,  0,  0, 16,  4,  0,  0,
   25,  4,  0,  0, 42,  4,  0,  0, 59,  4,  0,  0, 75,  4,  0,  0,
   91,  4,  0,  0,106,  4,  0,  0,123,  4,  0,  0,140,  4,  0,  0,
  157,  4,  0,  0,174,  4,  0,  0,191,  4,  0,  0,208,  4,  0,  0,
  221,  4,  0,  0,234,  4,  0,  0,247,  4,  0,  0,  4,  5,  0,  0,
   17,  5,  0,  0, 30,  5,  0,  0, 41,  5,  0,  0,  3,  4,  0,191,
  191,191,191,  0,255,  2,  6,  0,191,186,184,184,186,191,  0, 10,
    5,  0,191,191,191,191,191,  0,255,  1,  8,  0,191,186,181,181,
  180,182,186,191,  0, 10,  5,  0,191,182,184,185,191,  0,255,  1,
   14,  0,188,185,184,183,182,181,181,187,191,191,177,178,183,191,
    0,255,  0, 15,  0,191,183,186,184,186,186,181,181,185,191,191,
  177,179,183,191,  0,255,  0, 15,  0,191,182,184,187,191,191,180,
  182,185,191,191,177,181,184,191,  0,255,  0, 15,  0,191,180,184,
  186,191,191,179,183,186,191,191,177,181,185,191,  0,255,  0, 15,
    0,191,180,182,186,191,191,178,186,188,191,191,177,181,185,191,
    0,255,  0, 15,  0,191,178,183,186,191,191,177,186,187,191,191,
  179,184,186,191,  0,255,  0, 15,  0,191,179,186,187,191,191,178,
  185,187,191,191,180,184,185,191,  0,255,  0, 15,  0,191,179,185,
  187,191,191,178,183,185,191,191,185,184,186,191,  0,255,  0, 15,
    0,191,179,183,187,191,191,180,182,182,186,186,183,183,187,191,
    0,255,  0, 14,  0,191,183,185,185,191,191,186,184,183,184,183,
  182,181,186,  0,255,  0,  5,  0,191,185,186,187,191,  0,  6,  8,
    0,191,186,184,184,183,184,186,191,  0,255,  0,  5,  0,191,191,
  191,191,191,  0,  7,  6,  0,191,186,182,182,186,191,  0,255,  7,
    5,  0,191,191,191,191, 47,  0,255,  5,  8,  0,191,191,186,185,
  185,186,191,191,  0,255,  4, 10,  0,191,188,185,182,182,182,181,
  183,188,191,  0,255,  4, 10,  0,191,183,181,181,181,182,181,178,
  185,191,  0,255,  3, 12,  0,191,185,182,181,181,181,181,180,179,
  179,186,191,  0,255,  3, 12,  0,191,180,182,185,185,181,182,185,
  185,181,184,191,  0,255,  3, 12,  0,191,182,186,191,191,181,186,
  191,191,179,185,191,  0,255,  3, 12,  0,191,179,187,191,191,180,
  188,191,191,178,185,191,  0,255,  3, 12,  0,191,179,186,191,191,
  180,187,191,191,178,186,191,  0,255,  3, 12,  0,191,180,188,191,
  191,180,188,191,191,178,185,191,  0,255,  3, 12,  0,191,180,188,
  191,191,178,186,191,191,179,186,191,  0,255,  3, 12,  0,191,179,
  185,191,191,178,185,191,191,180,186,191,  0,255,  3, 12,  0,191,
  184,187,191,191,185,187,191,191,183,186,191,  0,255,  3, 12,  0,
  191,191,191,191,191,191,191,191,191,191,191,191,  0,255,  3,  4,
    0,191,184,187,191,  0,255,  3,  4,  0,191,178,187,191,  0,255,
    3, 12,  0,191,177,182,191,191,191,191,191,191,191,191,191,  0,
  255,  3, 12,  0,191,177,182,181,181,181,181,181,181,182,185,191,
    0,255,  3, 12,  0,191,177,177,178,179,177,177,178,179,179,184,
  191,  0,255,  3, 12,  0,191,177,179,179,182,181,181,180,179,179,
  184,191,  0,255,  3, 12,  0,191,178,182,183,182,184,184,184,183,
  182,185,191,  0,255,  3, 12,  0,191,178,185,191,191,191,191,191,
  191,191,191,191,  0,255,  3,  4,  0,191,178,187,191,  0,255,  3,
    8,  0,191,191,191,191,191,191,191,191,  0,255,  3, 10,  0,191,
  183,186,187,187,188,188,187,191,191,  0,255,  3, 11,  0,191,178,
  187,187,187,187,187,187,187,189,191,  0,255,  3, 11,  0,191,178,
  187,187,187,186,186,186,186,184,191,  0,255,  3, 12,  0,191,185,
  187,186,186,186,185,184,182,184,188,191,  0,255,  3, 12,  0,191,
  191,191,191,191,191,191,191,180,178,186,191,  0,255, 11,  4,  0,
  191,177,186,191,  0,255, 11,  4,  0,191,178,187,191,  0,255, 11,
    4,  0,191,180,189,191,  0,255, 11,  4,  0,191,180,188,191,  0,
  255,  3, 12,  0,191,191,191,191,191,191,191,191,186,184,185,191,
    0,255,  3, 12,  0,191,184,186,185,185,187,187,187,185,183,188,
  191,  0,255,  3, 11,  0,191,180,185,183,184,186,187,186,184,182,
  191,  0,255,  3, 11,  0,191,178,181,183,184,186,186,185,184,188,
  191,  0,255,  3, 10,  0,191,182,182,183,184,185,185,187,191,191,
    0,255,  3, 12,  0,191,191,191,191,191,191,191,191,191,191,191,
  191,  0,255,  3, 12,  0,191,183,186,191,191,183,185,186,185,186,
  187,191,  0,255,  3, 12,  0,191,178,188,191,191,178,183,186,186,
  184,188,191,  0,255,  3, 12,  0,191,178,185,191,191,177,177,179,
  180,181,187,191,  0,255,  3, 12,  0,191,178,185,191,191,177,178,
  177,179,180,185,191,  0,255,  3, 12,  0,191,177,182,191,191,178,
  185,191,191,191,191,191,  0,255,  3,  8,  0,191,177,184,191,191,
  177,182,191,  0,255,  3,  8,  0,191,177,182,191,191,177,182,191,
    0,255,  3,  8,  0,191,177,184,191,191,179,185,191,  0,255,  3,
    8,  0,191,180,182,180,179,181,185,191,  0,255,  3,  8,  0,191,
  182,182,179,179,179,183,191,  0,255,  3,  8,  0,191,186,181,180,
  181,179,186,191,  0,255,  4,  6,  0,191,186,182,182,186,191,  0,
  255,  5,  4,  0,191,191,191,191,  0,255,
};

static const char m_auto[]=  // "Automap"
{
  102,  0, 15,  0,  0,  0,  0,  0,
  160,  1,  0,  0,168,  1,  0,  0,178,  1,  0,  0,190,  1,  0,  0,
  204,  1,  0,  0,220,  1,  0,  0,237,  1,  0,  0,253,  1,  0,  0,
   12,  2,  0,  0, 25,  2,  0,  0, 41,  2,  0,  0, 60,  2,  0,  0,
   78,  2,  0,  0, 98,  2,  0,  0,118,  2,  0,  0,137,  2,  0,  0,
  156,  2,  0,  0,174,  2,  0,  0,191,  2,  0,  0,206,  2,  0,  0,
  222,  2,  0,  0,238,  2,  0,  0,255,  2,  0,  0, 16,  3,  0,  0,
   25,  3,  0,  0, 34,  3,  0,  0, 43,  3,  0,  0, 52,  3,  0,  0,
   69,  3,  0,  0, 86,  3,  0,  0,102,  3,  0,  0,118,  3,  0,  0,
  133,  3,  0,  0,147,  3,  0,  0,156,  3,  0,  0,165,  3,  0,  0,
  182,  3,  0,  0,199,  3,  0,  0,216,  3,  0,  0,233,  3,  0,  0,
  250,  3,  0,  0, 11,  4,  0,  0, 20,  4,  0,  0, 29,  4,  0,  0,
   42,  4,  0,  0, 55,  4,  0,  0, 70,  4,  0,  0, 85,  4,  0,  0,
  102,  4,  0,  0,119,  4,  0,  0,136,  4,  0,  0,153,  4,  0,  0,
  170,  4,  0,  0,187,  4,  0,  0,204,  4,  0,  0,221,  4,  0,  0,
  238,  4,  0,  0,253,  4,  0,  0, 12,  5,  0,  0, 25,  5,  0,  0,
   40,  5,  0,  0, 56,  5,  0,  0, 73,  5,  0,  0, 90,  5,  0,  0,
  107,  5,  0,  0,123,  5,  0,  0,135,  5,  0,  0,147,  5,  0,  0,
  159,  5,  0,  0,171,  5,  0,  0,187,  5,  0,  0,204,  5,  0,  0,
  221,  5,  0,  0,238,  5,  0,  0,254,  5,  0,  0, 13,  6,  0,  0,
   23,  6,  0,  0, 35,  6,  0,  0, 49,  6,  0,  0, 64,  6,  0,  0,
   78,  6,  0,  0, 90,  6,  0,  0,103,  6,  0,  0,116,  6,  0,  0,
  133,  6,  0,  0,150,  6,  0,  0,167,  6,  0,  0,184,  6,  0,  0,
  200,  6,  0,  0,217,  6,  0,  0,234,  6,  0,  0,251,  6,  0,  0,
   12,  7,  0,  0, 29,  7,  0,  0, 46,  7,  0,  0, 59,  7,  0,  0,
   72,  7,  0,  0, 85,  7,  0,  0, 98,  7,  0,  0,111,  7,  0,  0,
  124,  7,  0,  0,135,  7,  0,  0, 12,  3,  0,191,191,191,  0,255,
   10,  5,  0,191,191,188,187,191,  0,255,  8,  7,  0,191,191,187,
  187,187,187,191,  0,255,  6,  9,  0,191,191,186,186,186,186,185,
  187,191,  0,255,  4, 11,  0,191,191,187,188,187,187,186,187,186,
  187,191,  0,255,  3, 12,  0,191,187,185,185,185,187,187,186,186,
  185,191,191,  0,255,  2, 11,  0,191,182,184,184,182,182,183,185,
  185,191,191,  0,255,  1, 10,  0,191,181,185,184,183,182,185,185,
  191,191,  0,255,  1,  8,  0,189,182,184,184,183,184,191,191,  0,
  255,  0, 11,  0,191,181,183,181,185,188,191,191,191,191,191,  0,
  255,  0,  6,  0,191,179,183,185,191,191,  0,  7,  4,  0,191,178,
  185,191,  0,255,  0,  5,  0,191,179,182,185,191,  0,  7,  4,  0,
  191,178,185,191,  0,255,  0, 15,  0,191,179,182,185,191,191,191,
  191,179,185,191,191,191,191,191,  0,255,  0, 15,  0,191,181,181,
  183,185,185,186,186,181,184,184,185,185,188,191,  0,255,  1, 14,
    0,189,182,181,181,180,180,181,181,181,181,182,181,187,191,  0,
  255,  1, 14,  0,191,187,182,183,183,183,183,183,183,184,184,184,
  187,191,  0,255,  2, 13,  0,191,189,187,185,185,185,185,185,185,
  185,185,187,191,  0,255,  3, 12,  0,191,191, 47, 47, 47, 47, 47,
   47, 47, 47, 47, 47,  0,255,  3, 10,  0,191,183,186,187,187,188,
  188,187,191,191,  0,255,  3, 11,  0,191,178,187,187,187,187,187,
  187,187,189,191,  0,255,  3, 11,  0,191,178,187,187,187,186,186,
  186,186,184,191,  0,255,  3, 12,  0,191,185,187,186,186,186,185,
  184,182,184,188,191,  0,255,  3, 12,  0,191,191,191,191,191,191,
  191,191,180,178,186,191,  0,255, 11,  4,  0,191,177,186,191,  0,
  255, 11,  4,  0,191,178,187,191,  0,255, 11,  4,  0,191,180,189,
  191,  0,255, 11,  4,  0,191,180,188,191,  0,255,  3, 12,  0,191,
  191,191,191,191,191,191,191,186,184,185,191,  0,255,  3, 12,  0,
  191,184,186,185,185,187,187,187,185,183,188,191,  0,255,  3, 11,
    0,191,180,185,183,184,186,187,186,184,182,191,  0,255,  3, 11,
    0,191,178,181,183,184,186,186,185,184,188,191,  0,255,  3, 10,
    0,191,182,182,183,184,185,185,187,191,191,  0,255,  3,  9,  0,
  191,191,191, 47, 47, 47, 47, 47, 47,  0,255,  3,  4,  0,191,184,
  187,191,  0,255,  3,  4,  0,191,178,187,191,  0,255,  3, 12,  0,
  191,177,182,191,191,191,191,191,191,191,191,191,  0,255,  3, 12,
    0,191,177,182,181,181,181,181,181,181,182,185,191,  0,255,  3,
   12,  0,191,177,177,178,179,177,177,178,179,179,184,191,  0,255,
    3, 12,  0,191,177,179,179,182,181,181,180,179,179,184,191,  0,
  255,  3, 12,  0,191,178,182,183,182,184,184,184,183,182,185,191,
    0,255,  3, 12,  0,191,178,185,191,191,191,191,191,191,191,191,
  191,  0,255,  3,  4,  0,191,178,187,191,  0,255,  3,  4,  0,191,
  181,187,191,  0,255,  3,  8,  0,191,191, 47,191,191,191,191,191,
    0,255,  5,  8,  0,191,191,186,184,184,184,191,191,  0,255,  4,
   10,  0,191,187,178,180,180,180,180,178,187,191,  0,255,  4, 10,
    0,191,177,179,181,181,180,179,178,183,191,  0,255,  3, 12,  0,
  191,185,181,181,184,184,184,182,179,178,185,191,  0,255,  3, 12,
    0,191,179,181,187,191,191,191,191,181,181,185,191,  0,255,  3,
    4,  0,191,177,184,191,  0, 11,  4,  0,191,177,184,191,  0,255,
    3,  4,  0,191,177,184,191,  0, 11,  4,  0,191,177,183,191,  0,
  255,  3,  4,  0,191,177,187,191,  0, 11,  4,  0,191,177,185,191,
    0,255,  3,  4,  0,191,177,187,191,  0, 11,  4,  0,191,179,188,
  191,  0,255,  3,  4,  0,191,177,186,191,  0, 11,  4,  0,191,180,
  186,191,  0,255,  3, 12,  0,191,180,182,188,191,191,191,191,182,
  184,187,191,  0,255,  3, 12,  0,191,185,183,183,185,185,185,186,
  185,186,187,191,  0,255,  4, 10,  0,191,184,184,184,186,187,187,
  186,184,191,  0,255,  4, 10,  0,191,187,181,182,185,187,187,186,
  188,191,  0,255,  5,  8,  0,191,191,186,186,186,186,191,191,  0,
  255,  5, 10,  0,191,191,191,191,191,191,191,191,191,191,  0,255,
    4, 11,  0,191,184,183,184,182,182,182,181,181,184,191,  0,255,
    3, 12,  0,191,181,178,179,179,179,179,180,180,179,184,191,  0,
  255,  3, 12,  0,191,177,177,179,181,181,180,179,180,179,184,191,
    0,255,  3, 12,  0,191,182,181,182,184,182,183,184,183,183,185,
  191,  0,255,  4, 11,  0,191,182,187,187,188,188,191,191,191,191,
  191,  0,255,  5,  7,  0,191,183,187,187,187,188,191,  0,255,  6,
    7,  0,191,180,186,186,186,186,191,  0,255,  6,  7,  0,191,180,
  185,184,182,185,191,  0,255,  5,  7,  0,191,179,181,181,182,185,
  191,  0,255,  4, 11,  0,191,181,185,183,182,181,191,191,191,191,
  191,  0,255,  3, 12,  0,191,180,184,183,181,180,179,183,184,184,
  186,191,  0,255,  3, 12,  0,191,177,180,182,183,184,186,186,186,
  187,188,191,  0,255,  3, 12,  0,191,179,182,184,184,186,186,187,
  186,185,187,191,  0,255,  4, 11,  0,191,184,187,187,188, 42,187,
  187,185,186,191,  0,255,  5, 10,  0, 47, 47, 47, 47, 47, 47, 47,
   47, 47, 47,  0,255, 10,  5,  0,191,191,184,184,191,  0,255,  8,
    7,  0,191,191,186,183,181,184,191,  0,255,  6,  9,  0,191,191,
  186,184,181,178,178,183,191,  0,255,  5, 10,  0,191,186,184,181,
  181,180,179,186,191,191,  0,255,  4,  9,  0,191,187,184,182,181,
  182,186,191,191,  0,255,  4,  7,  0,191,184,182,183,186,191,191,
    0,255,  3,  8,  0,191,183,185,186,191,191,191,191,  0,255,  3,
    8,  0,191,182,184,191,191,180,185,191,  0,255,  3, 12,  0,191,
  178,186,191,191,180,187,191,191,191,191,191,  0,255,  3, 12,  0,
  191,178,187,185,185,183,185,185,186,186,187,191,  0,255,  3, 12,
    0,191,179,181,182,182,182,182,183,183,183,186,191,  0,255,  3,
   12,  0,191,186,183,183,184,183,184,183,182,181,185,191,  0,255,
    4, 11,  0,191,188,186,185,186,186,185,186,186,187,191,  0,255,
    3, 12,  0,191,191,191,191,191,191,191,191,191,191,191,191,  0,
  255,  3, 12,  0,191,183,186,191,191,183,185,186,185,186,187,191,
    0,255,  3, 12,  0,191,178,188,191,191,178,183,186,186,184,188,
  191,  0,255,  3, 12,  0,191,178,185,191,191,177,177,179,180,181,
  187,191,  0,255,  3, 12,  0,191,178,185,191,191,177,178,177,179,
  180,185,191,  0,255,  3, 12,  0,191,177,182,191,191,178,185,191,
  191,191,191,191,  0,255,  3,  8,  0,191,177,184,191,191,177,182,
  191,  0,255,  3,  8,  0,191,177,182,191,191,177,182,191,  0,255,
    3,  8,  0,191,177,184,191,191,179,185,191,  0,255,  3,  8,  0,
  191,180,182,180,179,181,185,191,  0,255,  3,  8,  0,191,182,182,
  179,179,179,183,191,  0,255,  3,  8,  0,191,186,181,180,181,179,
  186,191,  0,255,  4,  6,  0,191,186,182,182,186,191,  0,255,  5,
    4,  0,191,191,191,191,  0,255,
};

static const char m_chat[]=  // "Chat Strings"
{
  154,  0, 15,  0,  0,  0,  0,  0,
  112,  2,  0,  0,124,  2,  0,  0,140,  2,  0,  0,158,  2,  0,  0,
  176,  2,  0,  0,196,  2,  0,  0,216,  2,  0,  0,237,  2,  0,  0,
    0,  3,  0,  0, 19,  3,  0,  0, 38,  3,  0,  0, 57,  3,  0,  0,
   78,  3,  0,  0, 99,  3,  0,  0,118,  3,  0,  0,137,  3,  0,  0,
  154,  3,  0,  0,171,  3,  0,  0,188,  3,  0,  0,205,  3,  0,  0,
  222,  3,  0,  0,239,  3,  0,  0,  0,  4,  0,  0,  9,  4,  0,  0,
   18,  4,  0,  0, 27,  4,  0,  0, 44,  4,  0,  0, 61,  4,  0,  0,
   78,  4,  0,  0, 95,  4,  0,  0,112,  4,  0,  0,129,  4,  0,  0,
  139,  4,  0,  0,151,  4,  0,  0,165,  4,  0,  0,180,  4,  0,  0,
  194,  4,  0,  0,206,  4,  0,  0,219,  4,  0,  0,232,  4,  0,  0,
  249,  4,  0,  0, 10,  5,  0,  0, 27,  5,  0,  0, 44,  5,  0,  0,
   60,  5,  0,  0, 77,  5,  0,  0, 86,  5,  0,  0, 95,  5,  0,  0,
  112,  5,  0,  0,129,  5,  0,  0,146,  5,  0,  0,163,  5,  0,  0,
  180,  5,  0,  0,197,  5,  0,  0,206,  5,  0,  0,215,  5,  0,  0,
  224,  5,  0,  0,225,  5,  0,  0,226,  5,  0,  0,227,  5,  0,  0,
  228,  5,  0,  0,229,  5,  0,  0,230,  5,  0,  0,231,  5,  0,  0,
  232,  5,  0,  0,233,  5,  0,  0,242,  5,  0,  0,  6,  6,  0,  0,
   28,  6,  0,  0, 47,  6,  0,  0, 67,  6,  0,  0, 87,  6,  0,  0,
  107,  6,  0,  0,127,  6,  0,  0,147,  6,  0,  0,167,  6,  0,  0,
  187,  6,  0,  0,207,  6,  0,  0,226,  6,  0,  0,248,  6,  0,  0,
   12,  7,  0,  0, 29,  7,  0,  0, 38,  7,  0,  0, 55,  7,  0,  0,
   72,  7,  0,  0, 89,  7,  0,  0,106,  7,  0,  0,123,  7,  0,  0,
  140,  7,  0,  0,149,  7,  0,  0,158,  7,  0,  0,175,  7,  0,  0,
  192,  7,  0,  0,209,  7,  0,  0,226,  7,  0,  0,243,  7,  0,  0,
    4,  8,  0,  0, 17,  8,  0,  0, 30,  8,  0,  0, 43,  8,  0,  0,
   60,  8,  0,  0, 77,  8,  0,  0, 94,  8,  0,  0,111,  8,  0,  0,
  127,  8,  0,  0,144,  8,  0,  0,161,  8,  0,  0,178,  8,  0,  0,
  195,  8,  0,  0,212,  8,  0,  0,229,  8,  0,  0,245,  8,  0,  0,
    6,  9,  0,  0, 23,  9,  0,  0, 40,  9,  0,  0, 56,  9,  0,  0,
   68,  9,  0,  0, 80,  9,  0,  0, 92,  9,  0,  0,103,  9,  0,  0,
  120,  9,  0,  0,137,  9,  0,  0,154,  9,  0,  0,171,  9,  0,  0,
  187,  9,  0,  0,202,  9,  0,  0,215,  9,  0,  0,230,  9,  0,  0,
  245,  9,  0,  0,  6, 10,  0,  0, 23, 10,  0,  0, 40, 10,  0,  0,
   57, 10,  0,  0, 74, 10,  0,  0, 91, 10,  0,  0,111, 10,  0,  0,
  131, 10,  0,  0,151, 10,  0,  0,171, 10,  0,  0,191, 10,  0,  0,
  206, 10,  0,  0,225, 10,  0,  0,242, 10,  0,  0,  3, 11,  0,  0,
   20, 11,  0,  0, 37, 11,  0,  0, 54, 11,  0,  0, 71, 11,  0,  0,
   88, 11,  0,  0,105, 11,  0,  0,122, 11,  0,  0,139, 11,  0,  0,
  156, 11,  0,  0,175, 11,  0,  0,  4,  7,  0,191,191,191,191,191,
  191,191,  0,255,  2, 11,  0,191,191,189,187,189,189,189,187,189,
  191,191,  0,255,  1, 13,  0,191,189,189,189,187,188, 46, 44,186,
  186,186,189,191,  0,255,  1, 13,  0,191,186,190,187,189,188,189,
  188,188,187,187,185,191,  0,255,  0, 15,  0,191,186,187,188,189,
  189,188,188,188,187,186,186,187,188,191,  0,255,  0, 15,  0,191,
  185,188,187,188,188,191,191,191,189,188,188,188,187,191,  0,255,
    0,  6,  0,191,183,187,186,188,191,  0,  9,  6,  0,191,184,189,
  188,188,191,  0,255,  0,  5,  0,191,182,186,188,191,  0, 10,  5,
    0,191,184,186,188,191,  0,255,  0,  5,  0,191,182,185,188,191,
    0, 10,  5,  0,191,181,186,188,191,  0,255,  0,  5,  0,191,181,
  186,188,191,  0, 10,  5,  0,191,182,185,188,191,  0,255,  0,  5,
    0,191,181,186,188,191,  0, 10,  5,  0,191,183,183,188,191,  0,
  255,  0,  6,  0,191,183,185,185,186,191,  0,  9,  6,  0,191,184,
  185,184,187,191,  0,255,  0,  6,  0,191,185,189,188,188,191,  0,
    9,  6,  0,191,184,183,183,188,191,  0,255,  1,  5,  0,191,186,
  188,189,191,  0,  9,  5,  0,191,185,186,185,191,  0,255,  1,  5,
    0,191,186,187,188,191,  0,  9,  5,  0,191,185,186,188,191,  0,
  255,  2,  4,  0,191,185,186,191,  0,  9,  4,  0,191,185,188,191,
    0,255,  3, 12,  0,191,191,191,191,191,191,191,191,191,191,191,
  191,  0,255,  3, 12,  0,191,184,186,186,186,186,186,185,185,185,
  186, 45,  0,255,  3, 12,  0,191,180,185,184,184,184,183,182,181,
  182,185,191,  0,255,  3, 12,  0,191,180,184,184,184,184,183,183,
  182,183,185,191,  0,255,  3, 12,  0,191,183,184,185,185,184,186,
  186,186,185,187, 45,  0,255,  3, 12,  0,191,191,191,191,191,182,
  186,191,191,191,191,191,  0,255,  7,  4,  0,191,180,186,191,  0,
  255,  7,  4,  0,191,178,185,191,  0,255,  7,  4,  0,191,178,185,
  191,  0,255,  3, 12,  0,191,191,191,191,191,179,185,191,191,191,
  191,191,  0,255,  3, 12,  0,191,183,184,184,184,182,185,185,185,
  184,186,191,  0,255,  3, 12,  0,191,178,182,181,181,181,181,180,
  180,179,184,191,  0,255,  3, 12,  0,191,178,181,180,178,178,178,
  178,178,179,183,191,  0,255,  3, 12,  0,191,183,186,185,185,183,
  183,183,183,183,186,191,  0,255,  3, 12,  0,191,191,191,191,191,
  191,191,191,191,191,191,191,  0,255, 10,  5,  0,191,191,184,184,
  191,  0,255,  8,  7,  0,191,191,186,183,181,184,191,  0,255,  6,
    9,  0,191,191,186,184,181,178,178,183,191,  0,255,  5, 10,  0,
  191,186,184,181,181,180,179,186,191,191,  0,255,  4,  9,  0,191,
  187,184,182,181,182,186,191,191,  0,255,  4,  7,  0,191,184,182,
  183,186,191,191,  0,255,  3,  8,  0,191,183,185,186,191,191,191,
  191,  0,255,  3,  8,  0,191,182,184,191,191,180,185,191,  0,255,
    3, 12,  0,191,178,186,191,191,180,187,191,191,191,191,191,  0,
  255,  3, 12,  0,191,178,187,185,185,183,185,185,186,186,187,191,
    0,255,  3, 12,  0,191,179,181,182,182,182,182,183,183,183,186,
  191,  0,255,  3, 12,  0,191,186,183,183,184,183,184,183,182,181,
  185,191,  0,255,  4, 11,  0,191,188,186,185,186,186,185,186,186,
  187,191,  0,255,  3, 12,  0,191,191,191,191,191,191,191,191,191,
  191,191,191,  0,255,  3,  4,  0,191,184,187,191,  0,255,  3,  4,
    0,191,178,187,191,  0,255,  3, 12,  0,191,177,182,191,191,191,
  191,191,191,191,191,191,  0,255,  3, 12,  0,191,177,182,181,181,
  181,181,181,181,182,185,191,  0,255,  3, 12,  0,191,177,177,178,
  179,177,177,178,179,179,184,191,  0,255,  3, 12,  0,191,177,179,
  179,182,181,181,180,179,179,184,191,  0,255,  3, 12,  0,191,178,
  182,183,182,184,184,184,183,182,185,191,  0,255,  3, 12,  0,191,
  178,185,191,191,191,191,191,191,191,191,191,  0,255,  3,  4,  0,
  191,178,187,191,  0,255,  3,  4,  0,191,181,187,191,  0,255,  3,
    4,  0,191,191, 47,191,  0,255,255,255,255,255,255,255,255,255,
  255,  3,  4,  0,191,191,191,191,  0,255,  2,  6,  0,191,186,184,
  184,186,191,  0, 10,  5,  0,191,191,191,191,191,  0,255,  1,  8,
    0,191,186,181,181,180,182,186,191,  0, 10,  5,  0,191,182,184,
  185,191,  0,255,  1, 14,  0,188,185,184,183,182,181,181,187,191,
  191,177,178,183,191,  0,255,  0, 15,  0,191,183,186,184,186,186,
  181,181,185,191,191,177,179,183,191,  0,255,  0, 15,  0,191,182,
  184,187,191,191,180,182,185,191,191,177,181,184,191,  0,255,  0,
   15,  0,191,180,184,186,191,191,179,183,186,191,191,177,181,185,
  191,  0,255,  0, 15,  0,191,180,182,186,191,191,178,186,188,191,
  191,177,181,185,191,  0,255,  0, 15,  0,191,178,183,186,191,191,
  177,186,187,191,191,179,184,186,191,  0,255,  0, 15,  0,191,179,
  186,187,191,191,178,185,187,191,191,180,184,185,191,  0,255,  0,
   15,  0,191,179,185,187,191,191,178,183,185,191,191,185,184,186,
  191,  0,255,  0, 15,  0,191,179,183,187,191,191,180,182,182,186,
  186,183,183,187,191,  0,255,  0, 14,  0,191,183,185,185,191,191,
  186,184,183,184,183,182,181,186,  0,255,  0,  5,  0,191,185,186,
  187,191,  0,  6,  8,  0,191,186,184,184,183,184,186,191,  0,255,
    0,  5,  0,191,191,191,191,191,  0,  7,  6,  0,191,186,182,182,
  186,191,  0,255,  3,  4,  0,191,184,187,191,  0,  8,  4,  0, 47,
   47, 47, 47,  0,255,  3,  4,  0,191,178,187,191,  0,255,  3, 12,
    0,191,177,182,191,191,191,191,191,191,191,191,191,  0,255,  3,
   12,  0,191,177,182,181,181,181,181,181,181,182,185,191,  0,255,
    3, 12,  0,191,177,177,178,179,177,177,178,179,179,184,191,  0,
  255,  3, 12,  0,191,177,179,179,182,181,181,180,179,179,184,191,
    0,255,  3, 12,  0,191,178,182,183,182,184,184,184,183,182,185,
  191,  0,255,  3, 12,  0,191,178,185,191,191,191,191,191,191,191,
  191,191,  0,255,  3,  4,  0,191,178,187,191,  0,255,  3,  4,  0,
  191,181,187,191,  0,255,  3, 12,  0,191,191,191,191,191,191,191,
  191,191,191,191,191,  0,255,  3, 12,  0,191,184,186,191,191,183,
  184,183,182,182,185,191,  0,255,  3, 12,  0,191,177,184,191,191,
  178,180,180,181,181,186,191,  0,255,  3, 12,  0,191,178,185,191,
  191,177,182,181,180,180,186,191,  0,255,  3, 12,  0,191,177,184,
  191,191,177,182,181,182,182,185,191,  0,255,  3, 12,  0,191,177,
  185,191,191,177,184,191,191,191,191,191,  0,255,  3,  8,  0,191,
  177,185,191,191,177,186,191,  0,255,  3,  8,  0,191,177,185,191,
  191,177,186,191,  0,255,  3,  8,  0,191,177,184,191,191,179,185,
  191,  0,255,  3, 12,  0,191,178,183,191,191,178,183,186,191,191,
  191,191,  0,255,  3, 12,  0,191,178,183,184,184,179,179,178,178,
  179,184,191,  0,255,  3, 12,  0,191,178,180,181,180,179,179,179,
  179,178,186,191,  0,255,  3, 12,  0,191,186,178,179,181,181,180,
  180,179,178,185,191,  0,255,  4, 11,  0,191,186,182,184,191,191,
  183,184,182,185,191,  0,255,  3, 12,  0,191,191,191,191,191,191,
  191,191,191,191,191,191,  0,255,  3, 12,  0,191,183,185,184,185,
  185,185,184,184,184,186,191,  0,255,  3, 12,  0,191,179,185,186,
  186,186,187,185,183,181,185,191,  0,255,  3, 12,  0,191,179,184,
  184,186,185,185,187,185,184,186,191,  0,255,  3, 12,  0,191,184,
  187,186,186,186,187,187,186,185,186,191,  0,255,  3, 12,  0,191,
  191,191,191,191,191,191,191,191,191,191,191,  0,255,  4, 11,  0,
  191,184,185,185,186,186,186,186,187,187,191,  0,255,  3, 12,  0,
  191,177,180,182,181,182,182,182,181,181,185,191,  0,255,  3, 12,
    0,191,177,181,181,181,182,181,180,179,179,184,191,  0,255,  3,
   12,  0,191,186,180,181,180,182,180,183,184,184,186,191,  0,255,
    4, 11,  0,191,186,182,182,182,182,191,191,191,191,191,  0,255,
    5,  7,  0,191,186,182,182,182,186,191,  0,255,  6,  7,  0,191,
  186,182,180,178,186,191,  0,255,  7,  7,  0,191,186,178,178,178,
  186,191,  0,255,  8,  6,  0,191,186,180,181,179,191,  0,255,  3,
   12,  0,191,191,191,191,191,191,191,180,180,178,186,191,  0,255,
    3, 12,  0,191,184,182,182,183,183,182,178,178,178,184,191,  0,
  255,  3, 12,  0,191,176,176,176,176,176,176,176,176,176,182,191,
    0,255,  3, 12,  0,191,177,180,181,180,179,179,179,179,178,184,
  191,  0,255,  3, 11,  0,191,184,184,185,185,185,185,185,185,187,
  191,  0,255,  3, 10,  0, 47, 47, 47, 47,191,191,191,191, 47, 47,
    0,255,  5,  8,  0,191,191,187,186,186,186,191,191,  0,255,  4,
   10,  0,191,188,182,183,184,184,181,179,188,191,  0,255,  4, 10,
    0,191,184,184,184,184,184,184,184,183,191,  0,255,  3, 12,  0,
  191,187,185,185,185,186,186,187,187,187,189,191,  0,255,  3, 12,
    0,191,184,188,188,191,191,191,191,188,188, 44,191,  0,255,  3,
    4,  0,191,184,189,191,  0, 11,  4,  0,191,183,187,191,  0,255,
    3,  4,  0,191,181,188,191,  0, 11,  4,  0,191,178,187,191,  0,
  255,  3,  4,  0,191,180,188,191,  0, 11,  4,  0,191,177,184,191,
    0,255,  3,  4,  0,191,178,184,191,  0, 11,  4,  0,191,178,187,
  191,  0,255,  3,  4,  0,191,178,186,191,  0,  8,  7,  0,191,191,
  191,191,179,186,191,  0,255,  3,  4,  0,191,178,184,191,  0,  8,
    7,  0,191,182,184,185,184,186,191,  0,255,  3,  4,  0,191,178,
  185,191,  0,  8,  7,  0,191,177,178,178,178,183,191,  0,255,  3,
    4,  0,191,180,185,191,  0,  8,  7,  0,191,177,177,177,177,183,
  191,  0,255,  3,  4,  0,191,185,187,191,  0,  8,  7,  0,191,184,
  185,185,185,186,191,  0,255,  5, 10,  0,191,191,191,191,191,191,
  191,191,191,191,  0,255,  4,  6,  0,191,187,185,185,187,191,  0,
   11,  4,  0,191,184,186,191,  0,255,  3, 12,  0,191,182,180,180,
  180,180,186,191,191,178,186,191,  0,255,  3, 12,  0,191,179,180,
  180,179,180,188,191,191,177,185,191,  0,255,  3, 12,  0,191,178,
  184,184,184,183,186,191,191,177,186,191,  0,255,  3, 12,  0,191,
  178,187,191,191,179,188,191,191,179,188,191,  0,255,  3, 12,  0,
  191,178,188,191,191,178,186,191,191,178,186,191,  0,255,  3, 12,
    0,191,178,187,191,191,178,185,191,191,179,187,191,  0,255,  3,
   12,  0,191,180,186,191,191,178,186,191,191,182,186,191,  0,255,
    3, 12,  0,191,182,186,191,191,180,188,191,191,181,185,191,  0,
  255,  3, 12,  0,191,180,186,191,191,180,188,188,187,182,185,191,
    0,255,  3, 12,  0,191,183,189,191,191,182,184,184,184,184,186,
  191,  0,255,  3, 12,  0,191,185, 45,191,191,186,184,185,185,184,
  188,191,  0,255,  3,  4,  0,191,186,188,191,  0,  8,  6,  0,191,
  187,186,186,187,191,  0,255,  3,  4,  0,191,191,191,191,  0,  9,
    4,  0,191,191,191,191,  0,255,
};

static const char m_enem[]=  // "Enemies"
{
   91,  0, 15,  0,  0,  0,  0,  0,
  116,  1,  0,  0,128,  1,  0,  0,144,  1,  0,  0,162,  1,  0,  0,
  180,  1,  0,  0,200,  1,  0,  0,220,  1,  0,  0,240,  1,  0,  0,
    4,  2,  0,  0, 24,  2,  0,  0, 44,  2,  0,  0, 63,  2,  0,  0,
   82,  2,  0,  0,101,  2,  0,  0,120,  2,  0,  0,139,  2,  0,  0,
  159,  2,  0,  0,175,  2,  0,  0,192,  2,  0,  0,209,  2,  0,  0,
  226,  2,  0,  0,242,  2,  0,  0,254,  2,  0,  0, 10,  3,  0,  0,
   22,  3,  0,  0, 33,  3,  0,  0, 50,  3,  0,  0, 67,  3,  0,  0,
   84,  3,  0,  0,101,  3,  0,  0,118,  3,  0,  0,133,  3,  0,  0,
  146,  3,  0,  0,161,  3,  0,  0,176,  3,  0,  0,193,  3,  0,  0,
  210,  3,  0,  0,227,  3,  0,  0,244,  3,  0,  0,  5,  4,  0,  0,
   22,  4,  0,  0, 39,  4,  0,  0, 56,  4,  0,  0, 73,  4,  0,  0,
   90,  4,  0,  0,106,  4,  0,  0,123,  4,  0,  0,140,  4,  0,  0,
  157,  4,  0,  0,173,  4,  0,  0,185,  4,  0,  0,197,  4,  0,  0,
  209,  4,  0,  0,221,  4,  0,  0,237,  4,  0,  0,254,  4,  0,  0,
   15,  5,  0,  0, 32,  5,  0,  0, 48,  5,  0,  0, 65,  5,  0,  0,
   82,  5,  0,  0, 99,  5,  0,  0,116,  5,  0,  0,133,  5,  0,  0,
  150,  5,  0,  0,163,  5,  0,  0,178,  5,  0,  0,193,  5,  0,  0,
  210,  5,  0,  0,227,  5,  0,  0,244,  5,  0,  0,  5,  6,  0,  0,
   22,  6,  0,  0, 39,  6,  0,  0, 56,  6,  0,  0, 73,  6,  0,  0,
   90,  6,  0,  0,107,  6,  0,  0,126,  6,  0,  0,143,  6,  0,  0,
  160,  6,  0,  0,177,  6,  0,  0,194,  6,  0,  0,211,  6,  0,  0,
  228,  6,  0,  0,245,  6,  0,  0,  6,  7,  0,  0, 23,  7,  0,  0,
   40,  7,  0,  0, 57,  7,  0,  0, 76,  7,  0,  0,  4,  7,  0,191,
  191,191,191,191,191,191,  0,255,  2, 11,  0,191,191,187,185,185,
  185,185,185,188,191,191,  0,255,  1, 13,  0,191,188,184,184,183,
  181,181,181,182,181,184,188,191,  0,255,  1, 13,  0,191,184,181,
  180,180,179,179,178,178,178,179,184,191,  0,255,  0, 15,  0,191,
  187,183,181,181,181,181,181,182,181,181,181,181,187,191,  0,255,
    0, 15,  0,191,181,182,187,191,191,180,182,185,191,191,180,182,
  187,191,  0,255,  0, 15,  0,191,180,182,187,191,191,178,182,187,
  191,191,180,182,187,191,  0,255,  0, 15,  0,191,178,181,187,191,
  191,178,181,187,191,191,179,182,187,191,  0,255,  0, 15,  0,191,
  178,182,187,191,191,180,181,187,191,191,177,181,187,191,  0,255,
    0, 15,  0,191,178,182,187,191,191,191,191,191,191,191,177,182,
  187,191,  0,255,  0,  5,  0,191,179,183,187,191,  0, 10,  5,  0,
  191,177,182,187,191,  0,255,  0,  5,  0,191,179,183,187,191,  0,
   10,  5,  0,191,178,182,187,191,  0,255,  0,  5,  0,191,179,185,
  187,191,  0, 10,  5,  0,191,179,182,187,191,  0,255,  0,  5,  0,
  191,181,186,187,191,  0, 10,  5,  0,191,180,182,187,191,  0,255,
    0,  5,  0,191,185,186,187,191,  0, 10,  5,  0,191,182,184,187,
  191,  0,255,  0, 15,  0,191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,  0,255,  4, 11,  0,191,184,185,185,186,186,
  186,186,187,187,191,  0,255,  3, 12,  0,191,177,180,182,181,182,
  182,182,181,181,185,191,  0,255,  3, 12,  0,191,177,181,181,181,
  182,181,180,179,179,184,191,  0,255,  3, 12,  0,191,186,180,181,
  180,182,180,183,184,184,186,191,  0,255,  4, 11,  0,191,186,182,
  182,182,182,191,191,191,191,191,  0,255,  5,  7,  0,191,186,182,
  182,182,186,191,  0,255,  6,  7,  0,191,186,182,180,178,186,191,
    0,255,  7,  7,  0,191,186,178,178,178,186,191,  0,255,  8,  6,
    0,191,186,180,181,179,191,  0,255,  3, 12,  0,191,191,191,191,
  191,191,191,180,180,178,186,191,  0,255,  3, 12,  0,191,184,182,
  182,183,183,182,178,178,178,184,191,  0,255,  3, 12,  0,191,176,
  176,176,176,176,176,176,176,176,182,191,  0,255,  3, 12,  0,191,
  177,180,181,180,179,179,179,179,178,184,191,  0,255,  3, 12,  0,
  191,184,184,185,185,185,185,185,185,187,191, 47,  0,255,  3, 10,
    0, 47, 47,191,191,191,191,191,191,191,191,  0,255,  5,  8,  0,
  191,191,186,185,185,186,191,191,  0,255,  4, 10,  0,191,188,185,
  182,182,182,181,183,188,191,  0,255,  4, 10,  0,191,183,181,181,
  181,182,181,178,185,191,  0,255,  3, 12,  0,191,185,182,181,181,
  181,181,180,179,179,186,191,  0,255,  3, 12,  0,191,180,182,185,
  185,181,182,185,185,181,184,191,  0,255,  3, 12,  0,191,182,186,
  191,191,181,186,191,191,179,185,191,  0,255,  3, 12,  0,191,179,
  187,191,191,180,188,191,191,178,185,191,  0,255,  3, 12,  0,191,
  179,186,191,191,180,187,191,191,178,186,191,  0,255,  3, 12,  0,
  191,180,188,191,191,180,188,191,191,178,185,191,  0,255,  3, 12,
    0,191,180,188,191,191,178,186,191,191,179,186,191,  0,255,  3,
   12,  0,191,179,185,191,191,178,185,191,191,180,186,191,  0,255,
    3, 12,  0,191,184,187,191,191,185,187,191,191,183,186,191,  0,
  255,  3, 12,  0, 47, 47,191,191,191,191,191,191,191,191,191,191,
    0,255,  4, 11,  0,191,184,183,184,182,182,182,181,181,184,191,
    0,255,  3, 12,  0,191,181,178,179,179,179,179,180,180,179,184,
  191,  0,255,  3, 12,  0,191,177,177,179,181,181,180,179,180,179,
  184,191,  0,255,  3, 12,  0,191,182,181,182,184,182,183,184,183,
  183,185,191,  0,255,  4, 11,  0,191,182,187,187,188,188,191,191,
  191,191,191,  0,255,  5,  7,  0,191,183,187,187,187,188,191,  0,
  255,  6,  7,  0,191,180,186,186,186,186,191,  0,255,  6,  7,  0,
  191,180,185,184,182,185,191,  0,255,  5,  7,  0,191,179,181,181,
  182,185,191,  0,255,  4, 11,  0,191,181,185,183,182,181,191,191,
  191,191,191,  0,255,  3, 12,  0,191,180,184,183,181,180,179,183,
  184,184,186,191,  0,255,  3, 12,  0,191,177,180,182,183,184,186,
  186,186,187,188,191,  0,255,  3, 12,  0,191,179,182,184,184,186,
  186,187,186,185,187,191,  0,255,  4, 11,  0,191,184,187,187,188,
   42,187,187,185,186,191,  0,255,  3, 12,  0,191,191,191,191,191,
  191,191,191,191,191,191,191,  0,255,  3, 12,  0,191,183,185,184,
  185,185,185,184,184,184,186,191,  0,255,  3, 12,  0,191,179,185,
  186,186,186,187,185,183,181,185,191,  0,255,  3, 12,  0,191,179,
  184,184,186,185,185,187,185,184,186,191,  0,255,  3, 12,  0,191,
  184,187,186,186,186,187,187,186,185,186,191,  0,255,  3, 12,  0,
  191,191,191,191,191,191,191,191,191,191,191,191,  0,255,  5,  8,
    0,191,191,186,185,185,186,191,191,  0,255,  4, 10,  0,191,188,
  185,182,182,182,181,183,188,191,  0,255,  4, 10,  0,191,183,181,
  181,181,182,181,178,185,191,  0,255,  3, 12,  0,191,185,182,181,
  181,181,181,180,179,179,186,191,  0,255,  3, 12,  0,191,180,182,
  185,185,181,182,185,185,181,184,191,  0,255,  3, 12,  0,191,182,
  186,191,191,181,186,191,191,179,185,191,  0,255,  3, 12,  0,191,
  179,187,191,191,180,188,191,191,178,185,191,  0,255,  3, 12,  0,
  191,179,186,191,191,180,187,191,191,178,186,191,  0,255,  3, 12,
    0,191,180,188,191,191,180,188,191,191,178,185,191,  0,255,  3,
   12,  0,191,180,188,191,191,178,186,191,191,179,186,191,  0,255,
    3, 12,  0,191,179,185,191,191,178,185,191,191,180,186,191,  0,
  255,  3, 12,  0,191,184,187,191,191,185,187,191,191,183,186,191,
    0,255,  3, 12,  0,191,191,191,191,191,191,191,191,191,191,191,
  191,  0,255,  4,  6,  0,191,187,185,185,187,191,  0, 11,  4,  0,
  191,184,186,191,  0,255,  3, 12,  0,191,182,180,180,180,180,186,
  191,191,178,186,191,  0,255,  3, 12,  0,191,179,180,180,179,180,
  188,191,191,177,185,191,  0,255,  3, 12,  0,191,178,184,184,184,
  183,186,191,191,177,186,191,  0,255,  3, 12,  0,191,178,187,191,
  191,179,188,191,191,179,188,191,  0,255,  3, 12,  0,191,178,188,
  191,191,178,186,191,191,178,186,191,  0,255,  3, 12,  0,191,178,
  187,191,191,178,185,191,191,179,187,191,  0,255,  3, 12,  0,191,
  180,186,191,191,178,186,191,191,182,186,191,  0,255,  3, 12,  0,
  191,182,186,191,191,180,188,191,191,181,185,191,  0,255,  3, 12,
    0,191,180,186,191,191,180,188,188,187,182,185,191,  0,255,  3,
   12,  0,191,183,189,191,191,182,184,184,184,184,186,191,  0,255,
    3, 12,  0,191,185, 45,191,191,186,184,185,185,184,188,191,  0,
  255,  3,  4,  0,191,186,188,191,  0,  8,  6,  0,191,187,186,186,
  187,191,  0,255,  3,  4,  0,191,191,191,191,  0,  9,  4,  0,191,
  191,191,191,  0,255,
};

static const char m_stat[]=  // "Status Bar / HUD"
{
  202,  0, 15,  0,  0,  0,  0,  0,
   48,  3,  0,  0, 57,  3,  0,  0, 77,  3,  0,  0, 99,  3,  0,  0,
  118,  3,  0,  0,138,  3,  0,  0,158,  3,  0,  0,178,  3,  0,  0,
  198,  3,  0,  0,218,  3,  0,  0,238,  3,  0,  0,  2,  4,  0,  0,
   22,  4,  0,  0, 41,  4,  0,  0, 63,  4,  0,  0, 83,  4,  0,  0,
  100,  4,  0,  0,109,  4,  0,  0,118,  4,  0,  0,135,  4,  0,  0,
  152,  4,  0,  0,169,  4,  0,  0,186,  4,  0,  0,203,  4,  0,  0,
  220,  4,  0,  0,237,  4,  0,  0,255,  4,  0,  0, 19,  5,  0,  0,
   33,  5,  0,  0, 48,  5,  0,  0, 62,  5,  0,  0, 74,  5,  0,  0,
   87,  5,  0,  0,100,  5,  0,  0,117,  5,  0,  0,134,  5,  0,  0,
  151,  5,  0,  0,168,  5,  0,  0,184,  5,  0,  0,201,  5,  0,  0,
  210,  5,  0,  0,219,  5,  0,  0,236,  5,  0,  0,253,  5,  0,  0,
   14,  6,  0,  0, 31,  6,  0,  0, 48,  6,  0,  0, 65,  6,  0,  0,
   74,  6,  0,  0, 83,  6,  0,  0, 96,  6,  0,  0,111,  6,  0,  0,
  127,  6,  0,  0,143,  6,  0,  0,160,  6,  0,  0,177,  6,  0,  0,
  186,  6,  0,  0,195,  6,  0,  0,204,  6,  0,  0,213,  6,  0,  0,
  230,  6,  0,  0,247,  6,  0,  0,  7,  7,  0,  0, 23,  7,  0,  0,
   38,  7,  0,  0, 55,  7,  0,  0, 74,  7,  0,  0, 91,  7,  0,  0,
  108,  7,  0,  0,125,  7,  0,  0,142,  7,  0,  0,159,  7,  0,  0,
  176,  7,  0,  0,193,  7,  0,  0,210,  7,  0,  0,227,  7,  0,  0,
  244,  7,  0,  0,  5,  8,  0,  0, 24,  8,  0,  0, 41,  8,  0,  0,
   42,  8,  0,  0, 43,  8,  0,  0, 44,  8,  0,  0, 45,  8,  0,  0,
   46,  8,  0,  0, 47,  8,  0,  0, 48,  8,  0,  0, 49,  8,  0,  0,
   50,  8,  0,  0, 70,  8,  0,  0, 90,  8,  0,  0,110,  8,  0,  0,
  130,  8,  0,  0,150,  8,  0,  0,170,  8,  0,  0,193,  8,  0,  0,
  216,  8,  0,  0,239,  8,  0,  0,  6,  9,  0,  0, 26,  9,  0,  0,
   46,  9,  0,  0, 64,  9,  0,  0, 82,  9,  0,  0, 98,  9,  0,  0,
  118,  9,  0,  0,128,  9,  0,  0,140,  9,  0,  0,154,  9,  0,  0,
  169,  9,  0,  0,183,  9,  0,  0,195,  9,  0,  0,208,  9,  0,  0,
  221,  9,  0,  0,238,  9,  0,  0,255,  9,  0,  0, 16, 10,  0,  0,
   33, 10,  0,  0, 49, 10,  0,  0, 66, 10,  0,  0, 83, 10,  0,  0,
  100, 10,  0,  0,117, 10,  0,  0,134, 10,  0,  0,151, 10,  0,  0,
  164, 10,  0,  0,177, 10,  0,  0,190, 10,  0,  0,207, 10,  0,  0,
  224, 10,  0,  0,241, 10,  0,  0,  2, 11,  0,  0, 18, 11,  0,  0,
   35, 11,  0,  0, 36, 11,  0,  0, 37, 11,  0,  0, 38, 11,  0,  0,
   39, 11,  0,  0, 47, 11,  0,  0, 56, 11,  0,  0, 66, 11,  0,  0,
   77, 11,  0,  0, 88, 11,  0,  0, 99, 11,  0,  0,110, 11,  0,  0,
  121, 11,  0,  0,132, 11,  0,  0,143, 11,  0,  0,154, 11,  0,  0,
  165, 11,  0,  0,176, 11,  0,  0,186, 11,  0,  0,195, 11,  0,  0,
  203, 11,  0,  0,204, 11,  0,  0,205, 11,  0,  0,206, 11,  0,  0,
  207, 11,  0,  0,227, 11,  0,  0,247, 11,  0,  0, 11, 12,  0,  0,
   31, 12,  0,  0, 51, 12,  0,  0, 71, 12,  0,  0, 81, 12,  0,  0,
   91, 12,  0,  0,101, 12,  0,  0,111, 12,  0,  0,131, 12,  0,  0,
  151, 12,  0,  0,171, 12,  0,  0,191, 12,  0,  0,211, 12,  0,  0,
  231, 12,  0,  0,249, 12,  0,  0, 12, 13,  0,  0, 31, 13,  0,  0,
   51, 13,  0,  0, 71, 13,  0,  0, 81, 13,  0,  0, 91, 13,  0,  0,
  101, 13,  0,  0,111, 13,  0,  0,131, 13,  0,  0,151, 13,  0,  0,
  170, 13,  0,  0,189, 13,  0,  0,207, 13,  0,  0,227, 13,  0,  0,
  247, 13,  0,  0, 11, 14,  0,  0, 31, 14,  0,  0, 51, 14,  0,  0,
   71, 14,  0,  0, 90, 14,  0,  0,109, 14,  0,  0,128, 14,  0,  0,
  149, 14,  0,  0,169, 14,  0,  0,189, 14,  0,  0,207, 14,  0,  0,
  225, 14,  0,  0,241, 14,  0,  0,  3,  4,  0,191,191,191,191,  0,
  255,  2,  6,  0,191,186,184,184,186,191,  0, 10,  5,  0,191,191,
  191,191,191,  0,255,  1,  8,  0,191,186,181,181,180,182,186,191,
    0, 10,  5,  0,191,182,184,185,191,  0,255,  1, 14,  0,188,185,
  184,183,182,181,181,187,191,191,177,178,183,191,  0,255,  0, 15,
    0,191,183,186,184,186,186,181,181,185,191,191,177,179,183,191,
    0,255,  0, 15,  0,191,182,184,187,191,191,180,182,185,191,191,
  177,181,184,191,  0,255,  0, 15,  0,191,180,184,186,191,191,179,
  183,186,191,191,177,181,185,191,  0,255,  0, 15,  0,191,180,182,
  186,191,191,178,186,188,191,191,177,181,185,191,  0,255,  0, 15,
    0,191,178,183,186,191,191,177,186,187,191,191,179,184,186,191,
    0,255,  0, 15,  0,191,179,186,187,191,191,178,185,187,191,191,
  180,184,185,191,  0,255,  0, 15,  0,191,179,185,187,191,191,178,
  183,185,191,191,185,184,186,191,  0,255,  0, 15,  0,191,179,183,
  187,191,191,180,182,182,186,186,183,183,187,191,  0,255,  0, 14,
    0,191,183,185,185,191,191,186,184,183,184,183,182,181,186,  0,
  255,  0,  5,  0,191,185,186,187,191,  0,  6,  8,  0,191,186,184,
  184,183,184,186,191,  0,255,  0,  5,  0,191,191,191,191,191,  0,
    7,  6,  0,191,186,182,182,186,191,  0,255,  3,  4,  0,191,191,
  191,191,  0,  8,  4,  0,191, 47, 47, 47,  0,255,  3,  4,  0,191,
  184,187,191,  0,255,  3,  4,  0,191,178,187,191,  0,255,  3, 12,
    0,191,177,182,191,191,191,191,191,191,191,191,191,  0,255,  3,
   12,  0,191,177,182,181,181,181,181,181,181,182,185,191,  0,255,
    3, 12,  0,191,177,177,178,179,177,177,178,179,179,184,191,  0,
  255,  3, 12,  0,191,177,179,179,182,181,181,180,179,179,184,191,
    0,255,  3, 12,  0,191,178,182,183,182,184,184,184,183,182,185,
  191,  0,255,  3, 12,  0,191,178,185,191,191,191,191,191,191,191,
  191,191,  0,255,  3,  4,  0,191,178,187,191,  0, 11,  4,  0,191,
  191,191,191,  0,255,  3,  4,  0,191,181,187,191,  0, 10,  5,  0,
  191,191,184,184,191,  0,255,  3,  4,  0,191,191,191,191,  0,  8,
    7,  0,191,191,186,183,181,184,191,  0,255,  6,  9,  0,191,191,
  186,184,181,178,178,183,191,  0,255,  5, 10,  0,191,186,184,181,
  181,180,179,186,191,191,  0,255,  4,  9,  0,191,187,184,182,181,
  182,186,191,191,  0,255,  4,  7,  0,191,184,182,183,186,191,191,
    0,255,  3,  8,  0,191,183,185,186,191,191,191,191,  0,255,  3,
    8,  0,191,182,184,191,191,180,185,191,  0,255,  3, 12,  0,191,
  178,186,191,191,180,187,191,191,191,191,191,  0,255,  3, 12,  0,
  191,178,187,185,185,183,185,185,186,186,187,191,  0,255,  3, 12,
    0,191,179,181,182,182,182,182,183,183,183,186,191,  0,255,  3,
   12,  0,191,186,183,183,184,183,184,183,182,181,185,191,  0,255,
    4, 11,  0,191,188,186,185,186,186,185,186,186,187,191,  0,255,
    3, 12,  0,191,191,191,191, 47, 47, 47, 47, 47, 47, 47, 47,  0,
  255,  3,  4,  0,191,184,187,191,  0,255,  3,  4,  0,191,178,187,
  191,  0,255,  3, 12,  0,191,177,182,191,191,191,191,191,191,191,
  191,191,  0,255,  3, 12,  0,191,177,182,181,181,181,181,181,181,
  182,185,191,  0,255,  3, 12,  0,191,177,177,178,179,177,177,178,
  179,179,184,191,  0,255,  3, 12,  0,191,177,179,179,182,181,181,
  180,179,179,184,191,  0,255,  3, 12,  0,191,178,182,183,182,184,
  184,184,183,182,185,191,  0,255,  3, 12,  0,191,178,185,191,191,
  191,191,191,191,191,191,191,  0,255,  3,  4,  0,191,178,187,191,
    0,255,  3,  4,  0,191,181,187,191,  0,255,  3,  8,  0,191,191,
  191,191,191,191,191,191,  0,255,  3, 10,  0,191,183,186,187,187,
  188,188,187,191,191,  0,255,  3, 11,  0,191,178,187,187,187,187,
  187,187,187,189,191,  0,255,  3, 11,  0,191,178,187,187,187,186,
  186,186,186,184,191,  0,255,  3, 12,  0,191,185,187,186,186,186,
  185,184,182,184,188,191,  0,255,  3, 12,  0,191,191,191,191,191,
  191,191,191,180,178,186,191,  0,255, 11,  4,  0,191,177,186,191,
    0,255, 11,  4,  0,191,178,187,191,  0,255, 11,  4,  0,191,180,
  189,191,  0,255, 11,  4,  0,191,180,188,191,  0,255,  3, 12,  0,
  191,191,191,191,191,191,191,191,186,184,185,191,  0,255,  3, 12,
    0,191,184,186,185,185,187,187,187,185,183,188,191,  0,255,  3,
   11,  0,191,180,185,183,184,186,187,186,184,182,191,  0,255,  3,
   11,  0,191,178,181,183,184,186,186,185,184,188,191,  0,255,  3,
   10,  0,191,182,182,183,184,185,185,187,191,191,  0,255,  3, 12,
    0,191,191,191,191,191,191,191,191,191,191,191,191,  0,255,  4,
    6,  0,191,187,185,185,187,191,  0, 11,  4,  0,191,184,186,191,
    0,255,  3, 12,  0,191,182,180,180,180,180,186,191,191,178,186,
  191,  0,255,  3, 12,  0,191,179,180,180,179,180,188,191,191,177,
  185,191,  0,255,  3, 12,  0,191,178,184,184,184,183,186,191,191,
  177,186,191,  0,255,  3, 12,  0,191,178,187,191,191,179,188,191,
  191,179,188,191,  0,255,  3, 12,  0,191,178,188,191,191,178,186,
  191,191,178,186,191,  0,255,  3, 12,  0,191,178,187,191,191,178,
  185,191,191,179,187,191,  0,255,  3, 12,  0,191,180,186,191,191,
  178,186,191,191,182,186,191,  0,255,  3, 12,  0,191,182,186,191,
  191,180,188,191,191,181,185,191,  0,255,  3, 12,  0,191,180,186,
  191,191,180,188,188,187,182,185,191,  0,255,  3, 12,  0,191,183,
  189,191,191,182,184,184,184,184,186,191,  0,255,  3, 12,  0,191,
  185, 45,191,191,186,184,185,185,184,188,191,  0,255,  3,  4,  0,
  191,186,188,191,  0,  8,  6,  0,191,187,186,186,187,191,  0,255,
    3,  4,  0,191,191,191,191,  0,  9,  4,  0,191,191,191,191,  0,
  255,255,255,255,255,255,255,255,255,255,  0, 15,  0, 47, 47, 47,
   47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47,  0,255,  0, 15,
    0, 47,179,182,183, 47, 47,184,183,182,183,182,183,184,183, 47,
    0,255,  0, 15,  0, 47,178,181,183, 47, 47,179,182,181,180,179,
  180,181,182, 47,  0,255,  0, 15,  0, 47,179,182,183, 47, 47,178,
  181,182,181,180,181,182,183, 47,  0,255,  0, 15,  0, 47,178,181,
  184, 47, 47,179,180,181,182,183,182,181,182, 47,  0,255,  0, 15,
    0, 47,177,180,183, 47, 47,178,184, 47, 47, 47,177,180,183, 47,
    0,255,  0,  9,  0, 47,177,179,182, 47, 47,175,184, 47,  0, 10,
    5,  0, 47,177,179,182, 47,  0,255,  0,  9,  0, 47,177,180,183,
   47, 47,178,183, 47,  0, 10,  5,  0, 47,177,180,182, 47,  0,255,
    0,  9,  0, 47,177,181,182, 47, 47,177,182, 47,  0, 10,  5,  0,
   47,177,181,182, 47,  0,255,  0,  9,  0, 47,179,180,183, 47, 47,
  178,184, 47,  0, 10,  5,  0, 47,177,180,183, 47,  0,255,  0, 15,
    0, 47,180,181,183, 47, 47,179,180,183, 41,179,182,181,182, 47,
    0,255,  0, 15,  0, 47,180,182,181,184,183,180,179,180,179,180,
  181,182,183, 47,  0,255,  1, 13,  0, 47,181,182,181,179,179,178,
  177,177,181,182,181, 47,  0,255,  1, 13,  0, 47,184,181,180,181,
  180,179,180,177,180,181,184, 47,  0,255,  2, 11,  0, 47,184,181,
  182,183, 47,183,182,181,184, 47,  0,255,  3,  4,  0, 47, 47, 47,
   47,  0,  8,  7,  0, 47, 47, 47, 47, 47, 47, 47,  0,255, 10,  5,
    0,191,191,184,184,191,  0,255,  8,  7,  0,191,191,186,183,181,
  184,191,  0,255,  6,  9,  0,191,191,186,184,181,178,178,183,191,
    0,255,  5, 10,  0,191,186,184,181,181,180,179,186,191,191,  0,
  255,  4,  9,  0,191,187,184,182,181,182,186,191,191,  0,255,  4,
    7,  0,191,184,182,183,186,191,191,  0,255,  3,  8,  0,191,183,
  185,186,191,191,191,191,  0,255,  3,  8,  0,191,182,184,191,191,
  180,185,191,  0,255,  3, 12,  0,191,178,186,191,191,180,187,191,
  191,191,191,191,  0,255,  3, 12,  0,191,178,187,185,185,183,185,
  185,186,186,187,191,  0,255,  3, 12,  0,191,179,181,182,182,182,
  182,183,183,183,186,191,  0,255,  3, 12,  0,191,186,183,183,184,
  183,184,183,182,181,185,191,  0,255,  4, 11,  0,191,188,186,185,
  186,186,185,186,186,187,191,  0,255,  3, 12,  0,191,191,191,191,
  191,191,191,191,191,191,191,191,  0,255,  3, 12,  0,191,184,186,
  191,191,183,184,183,182,182,185,191,  0,255,  3, 12,  0,191,177,
  184,191,191,178,180,180,181,181,186,191,  0,255,  3, 12,  0,191,
  178,185,191,191,177,182,181,180,180,186,191,  0,255,  3, 12,  0,
  191,177,184,191,191,177,182,181,182,182,185,191,  0,255,  3, 12,
    0,191,177,185,191,191,177,184,191,191,191,191,191,  0,255,  3,
    8,  0,191,177,185,191,191,177,186,191,  0,255,  3,  8,  0,191,
  177,185,191,191,177,186,191,  0,255,  3,  8,  0,191,177,184,191,
  191,179,185,191,  0,255,  3, 12,  0,191,178,183,191,191,178,183,
  186,191,191,191,191,  0,255,  3, 12,  0,191,178,183,184,184,179,
  179,178,178,179,184,191,  0,255,  3, 12,  0,191,178,180,181,180,
  179,179,179,179,178,186,191,  0,255,  3, 12,  0,191,186,178,179,
  181,181,180,180,179,178,185,191,  0,255,  4, 11,  0,191,186,182,
  184,191,191,183,184,182,185,191,  0,255,  5,  3,  0,191,191,191,
    0, 10,  5,  0,191,191,191,191,191,  0,255,255,255,255,255, 12,
    3,  0,191,191,191,  0,255, 11,  4,  0,191,177,183,191,  0,255,
   10,  5,  0,191,177,182,181,191,  0,255,  9,  6,  0,191,181,184,
  184,184,191,  0,255,  8,  6,  0,191,181,184,186,188,191,  0,255,
    7,  6,  0,191,177,186,184,188,191,  0,255,  6,  6,  0,191,181,
  184, 42, 43,191,  0,255,  5,  6,  0,191,181,184,186,189,191,  0,
  255,  4,  6,  0,191,181,186,184,188,191,  0,255,  3,  6,  0,191,
  181,189, 42, 43,191,  0,255,  2,  6,  0,191,181,185,186,189,191,
    0,255,  1,  6,  0,191,181,185,185,188,191,  0,255,  0,  6,  0,
  191,181,182,182,188,191,  0,255,  0,  5,  0,191,178,178,184,191,
    0,255,  0,  4,  0,191,179,184,191,  0,255,  0,  3,  0,191,191,
  191,  0,255,255,255,255,255,  0, 15,  0,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,  0,255,  0, 15,  0,191,185,
  186,186,185,185,185,185,185,185,184,183,183,186,191,  0,255,  0,
   15,  0,191,178,182,183,183,184,182,181,181,181,181,181,181,184,
  191,  0,255,  0, 15,  0,191,177,182,183,183,184,182,181,182,181,
  181,181,179,184,191,  0,255,  0, 15,  0,191,182,185,186,186,186,
  185,183,183,185,185,184,183,186,191,  0,255,  0, 15,  0,191,191,
  191,191,191,191,182,184,186,191,191,191,191,191,191,  0,255,  5,
    5,  0,191,180,184,186,191,  0,255,  5,  5,  0,191,178,184,186,
  191,  0,255,  5,  5,  0,191,178,185,187,191,  0,255,  5,  5,  0,
  191,183,185,188,191,  0,255,  0, 15,  0,191,191,191,191,191,191,
  183,186,188,191,191,191,191,191,191,  0,255,  0, 15,  0,191,183,
  186,186,186,187,187,186,187,188,188,188,188, 44,191,  0,255,  0,
   15,  0,191,179,183,184,185,186,187,187,187,187,187,187,187,189,
  191,  0,255,  0, 15,  0,191,179,184,184,185,185,187,187,186,186,
  186,186,185,187,191,  0,255,  0, 15,  0,191,184,185,185,186,186,
  186,188,188,188,187,188,187,188,191,  0,255,  0, 15,  0,191,191,
  191,191,191,191,191,191,191, 47, 47, 47, 47, 47, 47,  0,255,  0,
   13,  0,191,183,183,184,184,183,183,184,184,184,186,191,191,  0,
  255,  0, 14,  0,191,180,183,183,183,182,182,183,184,184,181,179,
  186,191,  0,255,  0, 14,  0,191,181,185,184,184,184,184,184,184,
  184,184,184,183,191,  0,255,  0, 15,  0,191,183,185,185,185,185,
  185,185,186,186,187,187,187,189,191,  0,255,  0, 15,  0,191,191,
  191,191,191,191,191,191,191,191,184,188,188, 44,191,  0,255, 10,
    5,  0,191,183,187,187,191,  0,255, 10,  5,  0,191,177,183,187,
  191,  0,255, 10,  5,  0,191,177,180,184,191,  0,255, 10,  5,  0,
  191,179,183,187,191,  0,255,  0, 15,  0,191,191,191,191,191,191,
  191,191,191,191,183,180,181,186,191,  0,255,  0, 15,  0,191,182,
  183,184,184,183,183,183,183,184,181,183,184,189,191,  0,255,  0,
   14,  0,191,179,181,182,182,182,182,181,181,181,181,182,182,191,
    0,255,  0, 14,  0,191,180,183,183,182,181,182,182,182,182,181,
  181,186,191,  0,255,  0, 13,  0,191,183,184,185,185,184,184,184,
  185,184,187,191,191,  0,255,  0, 15,  0,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,  0,255,  0, 15,  0,191,185,
  186,187,191,191,184,185,185,185,184,183,183,186,191,  0,255,  0,
   15,  0,191,183,186,187,191,191,178,181,181,181,181,181,181,187,
  191,  0,255,  0, 15,  0,191,181,185,187,191,191,178,181,182,181,
  181,181,179,187,191,  0,255,  0, 15,  0,191,181,186,187,191,191,
  181,184,184,184,184,181,180,187,191,  0,255,  0, 15,  0,191,181,
  186,187,191,191,191,191,191,191,191,181,180,187,191,  0,255,  0,
    5,  0,191,181,185,188,191,  0, 10,  5,  0,191,178,180,187,191,
    0,255,  0,  5,  0,191,179,185,188,191,  0, 10,  5,  0,191,178,
  180,187,191,  0,255,  0,  5,  0,191,179,186,188,191,  0, 10,  5,
    0,191,178,180,187,191,  0,255,  0,  6,  0,191,181,185,186,188,
  191,  0,  9,  6,  0,191,187,183,183,187,191,  0,255,  0, 15,  0,
  191,184,185,185,186,188,191,191,191,187,184,186,186,187,191,  0,
  255,  0, 15,  0,191,187,184,185,184,186,185,184,184,185,186,188,
  188,187,191,  0,255,  1, 13,  0,191,186,184,185,186,187,187,187,
  187,187,187,188,191,  0,255,  1, 13,  0,191,189,184,185,185,187,
  187,186,186,186,187,189,191,  0,255,  2, 11,  0,191,191,187,184,
  185,188,187,187,189,191,191,  0,255,  4,  7,  0,191,191,191,191,
  191,191,191,  0,255,
};



static const char m_weap[]=  // "Weapons"
{
  101,  0, 15,  0,  0,  0,  0,  0,
  156,  1,  0,  0,174,  1,  0,  0,193,  1,  0,  0,213,  1,  0,  0,
  233,  1,  0,  0,253,  1,  0,  0,  9,  2,  0,  0, 21,  2,  0,  0,
   33,  2,  0,  0, 45,  2,  0,  0, 57,  2,  0,  0, 69,  2,  0,  0,
   89,  2,  0,  0,109,  2,  0,  0,129,  2,  0,  0,148,  2,  0,  0,
  166,  2,  0,  0,179,  2,  0,  0,194,  2,  0,  0,209,  2,  0,  0,
  226,  2,  0,  0,243,  2,  0,  0,  4,  3,  0,  0, 21,  3,  0,  0,
   38,  3,  0,  0, 55,  3,  0,  0, 72,  3,  0,  0, 89,  3,  0,  0,
  106,  3,  0,  0,123,  3,  0,  0,133,  3,  0,  0,145,  3,  0,  0,
  159,  3,  0,  0,174,  3,  0,  0,188,  3,  0,  0,200,  3,  0,  0,
  213,  3,  0,  0,226,  3,  0,  0,243,  3,  0,  0,  4,  4,  0,  0,
   21,  4,  0,  0, 38,  4,  0,  0, 54,  4,  0,  0, 71,  4,  0,  0,
   88,  4,  0,  0,105,  4,  0,  0,122,  4,  0,  0,139,  4,  0,  0,
  156,  4,  0,  0,169,  4,  0,  0,182,  4,  0,  0,195,  4,  0,  0,
  208,  4,  0,  0,221,  4,  0,  0,234,  4,  0,  0,245,  4,  0,  0,
    1,  5,  0,  0, 14,  5,  0,  0, 29,  5,  0,  0, 44,  5,  0,  0,
   61,  5,  0,  0, 78,  5,  0,  0, 95,  5,  0,  0,112,  5,  0,  0,
  129,  5,  0,  0,146,  5,  0,  0,163,  5,  0,  0,180,  5,  0,  0,
  197,  5,  0,  0,212,  5,  0,  0,227,  5,  0,  0,240,  5,  0,  0,
  255,  5,  0,  0, 15,  6,  0,  0, 32,  6,  0,  0, 49,  6,  0,  0,
   66,  6,  0,  0, 82,  6,  0,  0, 94,  6,  0,  0,106,  6,  0,  0,
  118,  6,  0,  0,129,  6,  0,  0,146,  6,  0,  0,163,  6,  0,  0,
  180,  6,  0,  0,197,  6,  0,  0,213,  6,  0,  0,230,  6,  0,  0,
  249,  6,  0,  0, 10,  7,  0,  0, 27,  7,  0,  0, 44,  7,  0,  0,
   61,  7,  0,  0, 78,  7,  0,  0, 95,  7,  0,  0,112,  7,  0,  0,
  129,  7,  0,  0,146,  7,  0,  0,163,  7,  0,  0,180,  7,  0,  0,
  199,  7,  0,  0,  0, 13,  0,191,191,191,191,191,191,191,191,191,
  191,191,191,191,  0,255,  0, 14,  0,191,183,185,186,186,186,185,
  185,185,184,183,184,186,191,  0,255,  0, 15,  0,191,179,182,181,
  181,180,182,182,182,182,181,177,176,182,191,  0,255,  0, 15,  0,
  191,184,186,185,185,184,184,184,184,179,177,176,176,182,191,  0,
  255,  0, 15,  0,191,191,191,191,191,191,191,191,191,179,180,179,
  179,188,191,  0,255,  7,  7,  0,191,179,182,181,182,185,191,  0,
  255,  6,  7,  0,191,180,184,184,182,185,191,  0,255,  5,  7,  0,
  191,181,186,186,187,185,191,  0,255,  5,  7,  0,191,181,186,185,
  185,187,191,  0,255,  6,  7,  0,191,180,185,187,187,188,191,  0,
  255,  7,  7,  0,191,180,183,183,185,188,191,  0,255,  0, 15,  0,
  191,191,191,191,191,191,191,191,191,180,183,183,183,188,191,  0,
  255,  0, 15,  0,191,185,186,184,185,185,185,185,185,184,183,182,
  181,185,191,  0,255,  0, 15,  0,191,180,185,184,182,182,183,183,
  184,184,183,184,184,186,191,  0,255,  0, 14,  0,191,183,186,185,
  183,183,184,184,185,185,185,186,187,191,  0,255,  0, 13,  0,191,
  191,191,191,191,191,191,191,191,191,191,191,191,  0,255,  5,  8,
    0,191,191,186,185,185,186,191,191,  0,255,  4, 10,  0,191,188,
  185,182,182,182,181,183,188,191,  0,255,  4, 10,  0,191,183,181,
  181,181,182,181,178,185,191,  0,255,  3, 12,  0,191,185,182,181,
  181,181,181,180,179,179,186,191,  0,255,  3, 12,  0,191,180,182,
  185,185,181,182,185,185,181,184,191,  0,255,  3, 12,  0,191,182,
  186,191,191,181,186,191,191,179,185,191,  0,255,  3, 12,  0,191,
  179,187,191,191,180,188,191,191,178,185,191,  0,255,  3, 12,  0,
  191,179,186,191,191,180,187,191,191,178,186,191,  0,255,  3, 12,
    0,191,180,188,191,191,180,188,191,191,178,185,191,  0,255,  3,
   12,  0,191,180,188,191,191,178,186,191,191,179,186,191,  0,255,
    3, 12,  0,191,179,185,191,191,178,185,191,191,180,186,191,  0,
  255,  3, 12,  0,191,184,187,191,191,185,187,191,191,183,186,191,
    0,255,  3, 12,  0,191,191,191,191,191,191,191,191,191,191,191,
  191,  0,255, 10,  5,  0,191,191,184,184,191,  0,255,  8,  7,  0,
  191,191,186,183,181,184,191,  0,255,  6,  9,  0,191,191,186,184,
  181,178,178,183,191,  0,255,  5, 10,  0,191,186,184,181,181,180,
  179,186,191,191,  0,255,  4,  9,  0,191,187,184,182,181,182,186,
  191,191,  0,255,  4,  7,  0,191,184,182,183,186,191,191,  0,255,
    3,  8,  0,191,183,185,186,191,191,191,191,  0,255,  3,  8,  0,
  191,182,184,191,191,180,185,191,  0,255,  3, 12,  0,191,178,186,
  191,191,180,187,191,191,191,191,191,  0,255,  3, 12,  0,191,178,
  187,185,185,183,185,185,186,186,187,191,  0,255,  3, 12,  0,191,
  179,181,182,182,182,182,183,183,183,186,191,  0,255,  3, 12,  0,
  191,186,183,183,184,183,184,183,182,181,185,191,  0,255,  4, 11,
    0,191,188,186,185,186,186,185,186,186,187,191,  0,255,  3, 12,
    0,191,191,191,191,191,191,191,191,191,191,191,191,  0,255,  3,
   12,  0,191,183,186,191,191,183,185,186,185,186,187,191,  0,255,
    3, 12,  0,191,178,188,191,191,178,183,186,186,184,188,191,  0,
  255,  3, 12,  0,191,178,185,191,191,177,177,179,180,181,187,191,
    0,255,  3, 12,  0,191,178,185,191,191,177,178,177,179,180,185,
  191,  0,255,  3, 12,  0,191,177,182,191,191,178,185,191,191,191,
  191,191,  0,255,  3,  8,  0,191,177,184,191,191,177,182,191,  0,
  255,  3,  8,  0,191,177,182,191,191,177,182,191,  0,255,  3,  8,
    0,191,177,184,191,191,179,185,191,  0,255,  3,  8,  0,191,180,
  182,180,179,181,185,191,  0,255,  3,  8,  0,191,182,182,179,179,
  179,183,191,  0,255,  3,  8,  0,191,186,181,180,181,179,186,191,
    0,255,  4,  6,  0,191,186,182,182,186,191,  0,255,  5,  7,  0,
  191,191,191,191,191,191,191,  0,255,  5,  8,  0,191,191,186,184,
  184,184,191,191,  0,255,  4, 10,  0,191,187,178,180,180,180,180,
  178,187,191,  0,255,  4, 10,  0,191,177,179,181,181,180,179,178,
  183,191,  0,255,  3, 12,  0,191,185,181,181,184,184,184,182,179,
  178,185,191,  0,255,  3, 12,  0,191,179,181,187,191,191,191,191,
  181,181,185,191,  0,255,  3,  4,  0,191,177,184,191,  0, 11,  4,
    0,191,177,184,191,  0,255,  3,  4,  0,191,177,184,191,  0, 11,
    4,  0,191,177,183,191,  0,255,  3,  4,  0,191,177,187,191,  0,
   11,  4,  0,191,177,185,191,  0,255,  3,  4,  0,191,177,187,191,
    0, 11,  4,  0,191,179,188,191,  0,255,  3,  4,  0,191,177,186,
  191,  0, 11,  4,  0,191,180,186,191,  0,255,  3, 12,  0,191,180,
  182,188,191,191,191,191,182,184,187,191,  0,255,  3, 12,  0,191,
  185,183,183,185,185,185,186,185,186,187,191,  0,255,  4, 10,  0,
  191,184,184,184,186,187,187,186,184,191,  0,255,  4, 10,  0,191,
  187,181,182,185,187,187,186,188,191,  0,255,  5,  8,  0,191,191,
  186,186,186,186,191,191,  0,255,  5, 10,  0,191,191,191,191,191,
  191,191,191,191,191,  0,255,  4, 11,  0,191,184,185,185,186,186,
  186,186,187,187,191,  0,255,  3, 12,  0,191,177,180,182,181,182,
  182,182,181,181,185,191,  0,255,  3, 12,  0,191,177,181,181,181,
  182,181,180,179,179,184,191,  0,255,  3, 12,  0,191,186,180,181,
  180,182,180,183,184,184,186,191,  0,255,  4, 11,  0,191,186,182,
  182,182,182,191,191,191,191,191,  0,255,  5,  7,  0,191,186,182,
  182,182,186,191,  0,255,  6,  7,  0,191,186,182,180,178,186,191,
    0,255,  7,  7,  0,191,186,178,178,178,186,191,  0,255,  8,  6,
    0,191,186,180,181,179,191,  0,255,  3, 12,  0,191,191,191,191,
  191,191,191,180,180,178,186,191,  0,255,  3, 12,  0,191,184,182,
  182,183,183,182,178,178,178,184,191,  0,255,  3, 12,  0,191,176,
  176,176,176,176,176,176,176,176,182,191,  0,255,  3, 12,  0,191,
  177,180,181,180,179,179,179,179,178,184,191,  0,255,  3, 11,  0,
  191,184,184,185,185,185,185,185,185,187,191,  0,255,  3, 12,  0,
  191,191,191,191,191,191,191,191,191,191,191,191,  0,255,  4,  6,
    0,191,187,185,185,187,191,  0, 11,  4,  0,191,184,186,191,  0,
  255,  3, 12,  0,191,182,180,180,180,180,186,191,191,178,186,191,
    0,255,  3, 12,  0,191,179,180,180,179,180,188,191,191,177,185,
  191,  0,255,  3, 12,  0,191,178,184,184,184,183,186,191,191,177,
  186,191,  0,255,  3, 12,  0,191,178,187,191,191,179,188,191,191,
  179,188,191,  0,255,  3, 12,  0,191,178,188,191,191,178,186,191,
  191,178,186,191,  0,255,  3, 12,  0,191,178,187,191,191,178,185,
  191,191,179,187,191,  0,255,  3, 12,  0,191,180,186,191,191,178,
  186,191,191,182,186,191,  0,255,  3, 12,  0,191,182,186,191,191,
  180,188,191,191,181,185,191,  0,255,  3, 12,  0,191,180,186,191,
  191,180,188,188,187,182,185,191,  0,255,  3, 12,  0,191,183,189,
  191,191,182,184,184,184,184,186,191,  0,255,  3, 12,  0,191,185,
   45,191,191,186,184,185,185,184,188,191,  0,255,  3,  4,  0,191,
  186,188,191,  0,  8,  6,  0,191,187,186,186,187,191,  0,255,  3,
    4,  0,191,191,191,191,  0,  9,  4,  0,191,191,191,191,  0,255,
};

static const char m_mess[]=  // "Messages"
{
  113,  0, 15,  0,  0,  0,  0,  0,
  204,  1,  0,  0,222,  1,  0,  0,241,  1,  0,  0,  5,  2,  0,  0,
   25,  2,  0,  0, 44,  2,  0,  0, 63,  2,  0,  0, 75,  2,  0,  0,
   87,  2,  0,  0, 99,  2,  0,  0,111,  2,  0,  0,130,  2,  0,  0,
  149,  2,  0,  0,169,  2,  0,  0,189,  2,  0,  0,208,  2,  0,  0,
  226,  2,  0,  0,239,  2,  0,  0,254,  2,  0,  0, 13,  3,  0,  0,
   30,  3,  0,  0, 47,  3,  0,  0, 64,  3,  0,  0, 81,  3,  0,  0,
   98,  3,  0,  0,115,  3,  0,  0,132,  3,  0,  0,149,  3,  0,  0,
  166,  3,  0,  0,183,  3,  0,  0,202,  3,  0,  0,219,  3,  0,  0,
  236,  3,  0,  0,253,  3,  0,  0, 14,  4,  0,  0, 31,  4,  0,  0,
   48,  4,  0,  0, 65,  4,  0,  0, 82,  4,  0,  0, 99,  4,  0,  0,
  116,  4,  0,  0,133,  4,  0,  0,152,  4,  0,  0,169,  4,  0,  0,
  188,  4,  0,  0,205,  4,  0,  0,222,  4,  0,  0,239,  4,  0,  0,
    0,  5,  0,  0, 17,  5,  0,  0, 34,  5,  0,  0, 51,  5,  0,  0,
   68,  5,  0,  0, 85,  5,  0,  0,102,  5,  0,  0,119,  5,  0,  0,
  138,  5,  0,  0,157,  5,  0,  0,167,  5,  0,  0,179,  5,  0,  0,
  193,  5,  0,  0,208,  5,  0,  0,222,  5,  0,  0,234,  5,  0,  0,
  247,  5,  0,  0,  4,  6,  0,  0, 21,  6,  0,  0, 38,  6,  0,  0,
   55,  6,  0,  0, 72,  6,  0,  0, 88,  6,  0,  0,103,  6,  0,  0,
  116,  6,  0,  0,131,  6,  0,  0,146,  6,  0,  0,163,  6,  0,  0,
  180,  6,  0,  0,197,  6,  0,  0,214,  6,  0,  0,231,  6,  0,  0,
  248,  6,  0,  0, 12,  7,  0,  0, 32,  7,  0,  0, 52,  7,  0,  0,
   72,  7,  0,  0, 92,  7,  0,  0,109,  7,  0,  0,122,  7,  0,  0,
  137,  7,  0,  0,152,  7,  0,  0,169,  7,  0,  0,186,  7,  0,  0,
  203,  7,  0,  0,220,  7,  0,  0,237,  7,  0,  0,254,  7,  0,  0,
   15,  8,  0,  0, 32,  8,  0,  0, 49,  8,  0,  0, 66,  8,  0,  0,
   85,  8,  0,  0,102,  8,  0,  0,119,  8,  0,  0,136,  8,  0,  0,
  153,  8,  0,  0,170,  8,  0,  0,187,  8,  0,  0,204,  8,  0,  0,
  221,  8,  0,  0,238,  8,  0,  0,255,  8,  0,  0, 16,  9,  0,  0,
   35,  9,  0,  0,  2, 13,  0,191,191,191,191,191,191,191,191,191,
  191,191,191,191,  0,255,  1, 14,  0,191,187,186,186,185,185,185,
  185,185,185,185,185,187,191,  0,255,  0, 15,  0,191,181,184,184,
  184,183,181,181,181,182,181,181,181,184,191,  0,255,  0, 15,  0,
  191,182,183,181,182,181,181,181,180,180,180,180,181,185,191,  0,
  255,  1, 14,  0,191,177,177,177,177,177,177,177,177,179,179,179,
  184,191,  0,255,  1, 14,  0,191,180,182,182,182,182,191,191,191,
  191,191,191,191,191,  0,255,  2,  7,  0,191,177,180,181,181,185,
  191,  0,255,  3,  7,  0,191,177,180,181,181,185,191,  0,255,  3,
    7,  0,191,177,179,179,181,185,191,  0,255,  2,  7,  0,191,180,
  183,183,183,186, 47,  0,255,  1, 14,  0,191,180,184,183,184,184,
  191,191,191,191,191,191,191,191,  0,255,  1, 14,  0,191,181,184,
  184,184,185,186,187,186,186,186,186,187,191,  0,255,  0, 15,  0,
  191,182,185,184,185,186,187,186,187,187,189,189,190, 46,191,  0,
  255,  0, 15,  0,191,181,178,178,178,180,180,181,181,184,184,184,
  184,184,191,  0,255,  1, 14,  0,191,188,186,186,186,186,186,186,
  187,186,186,187,188,191,  0,255,  2, 13,  0,191,191,191,191,191,
  191,191,191,191,191,191,191,191,  0,255,  5,  8,  0,191,191,186,
  185,185,186,191,191,  0,255,  4, 10,  0,191,188,185,182,182,182,
  181,183,188,191,  0,255,  4, 10,  0,191,183,181,181,181,182,181,
  178,185,191,  0,255,  3, 12,  0,191,185,182,181,181,181,181,180,
  179,179,186,191,  0,255,  3, 12,  0,191,180,182,185,185,181,182,
  185,185,181,184,191,  0,255,  3, 12,  0,191,182,186,191,191,181,
  186,191,191,179,185,191,  0,255,  3, 12,  0,191,179,187,191,191,
  180,188,191,191,178,185,191,  0,255,  3, 12,  0,191,179,186,191,
  191,180,187,191,191,178,186,191,  0,255,  3, 12,  0,191,180,188,
  191,191,180,188,191,191,178,185,191,  0,255,  3, 12,  0,191,180,
  188,191,191,178,186,191,191,179,186,191,  0,255,  3, 12,  0,191,
  179,185,191,191,178,185,191,191,180,186,191,  0,255,  3, 12,  0,
  191,184,187,191,191,185,187,191,191,183,186,191,  0,255,  3, 12,
    0,191,191,191,191,191,191,191,191,191,191,191,191,  0,255,  4,
    6,  0,191,187,185,185,187,191,  0, 11,  4,  0,191,184,186,191,
    0,255,  3, 12,  0,191,182,180,180,180,180,186,191,191,178,186,
  191,  0,255,  3, 12,  0,191,179,180,180,179,180,188,191,191,177,
  185,191,  0,255,  3, 12,  0,191,178,184,184,184,183,186,191,191,
  177,186,191,  0,255,  3, 12,  0,191,178,187,191,191,179,188,191,
  191,179,188,191,  0,255,  3, 12,  0,191,178,188,191,191,178,186,
  191,191,178,186,191,  0,255,  3, 12,  0,191,178,187,191,191,178,
  185,191,191,179,187,191,  0,255,  3, 12,  0,191,180,186,191,191,
  178,186,191,191,182,186,191,  0,255,  3, 12,  0,191,182,186,191,
  191,180,188,191,191,181,185,191,  0,255,  3, 12,  0,191,180,186,
  191,191,180,188,188,187,182,185,191,  0,255,  3, 12,  0,191,183,
  189,191,191,182,184,184,184,184,186,191,  0,255,  3, 12,  0,191,
  185, 45,191,191,186,184,185,185,184,188,191,  0,255,  3,  4,  0,
  191,186,188,191,  0,  8,  6,  0,191,187,186,186,187,191,  0,255,
    3, 12,  0,191,191,191,191,191,191,191,191,191,191,191,191,  0,
  255,  4,  6,  0,191,187,185,185,187,191,  0, 11,  4,  0,191,184,
  186,191,  0,255,  3, 12,  0,191,182,180,180,180,180,186,191,191,
  178,186,191,  0,255,  3, 12,  0,191,179,180,180,179,180,188,191,
  191,177,185,191,  0,255,  3, 12,  0,191,178,184,184,184,183,186,
  191,191,177,186,191,  0,255,  3, 12,  0,191,178,187,191,191,179,
  188,191,191,179,188,191,  0,255,  3, 12,  0,191,178,188,191,191,
  178,186,191,191,178,186,191,  0,255,  3, 12,  0,191,178,187,191,
  191,178,185,191,191,179,187,191,  0,255,  3, 12,  0,191,180,186,
  191,191,178,186,191,191,182,186,191,  0,255,  3, 12,  0,191,182,
  186,191,191,180,188,191,191,181,185,191,  0,255,  3, 12,  0,191,
  180,186,191,191,180,188,188,187,182,185,191,  0,255,  3, 12,  0,
  191,183,189,191,191,182,184,184,184,184,186,191,  0,255,  3, 12,
    0,191,185, 45,191,191,186,184,185,185,184,188,191,  0,255,  3,
    4,  0,191,186,188,191,  0,  8,  6,  0,191,187,186,186,187,191,
    0,255,  3,  4,  0,191,191,191,191,  0,  9,  6,  0,191,191,191,
  191,191,191,  0,255, 10,  5,  0,191,191,184,184,191,  0,255,  8,
    7,  0,191,191,186,183,181,184,191,  0,255,  6,  9,  0,191,191,
  186,184,181,178,178,183,191,  0,255,  5, 10,  0,191,186,184,181,
  181,180,179,186,191,191,  0,255,  4,  9,  0,191,187,184,182,181,
  182,186,191,191,  0,255,  4,  7,  0,191,184,182,183,186,191,191,
    0,255,  3,  8,  0,191,183,185,186,191,191,191,191,  0,255,  3,
    8,  0,191,182,184,191,191,180,185,191,  0,255,  3, 12,  0,191,
  178,186,191,191,180,187,191,191,191,191,191,  0,255,  3, 12,  0,
  191,178,187,185,185,183,185,185,186,186,187,191,  0,255,  3, 12,
    0,191,179,181,182,182,182,182,183,183,183,186,191,  0,255,  3,
   12,  0,191,186,183,183,184,183,184,183,182,181,185,191,  0,255,
    4, 11,  0,191,188,186,185,186,186,185,186,186,187,191,  0,255,
    5, 10,  0,191,191,191,191,191,191,191,191,191,191,  0,255,  5,
    8,  0,191,191,187,186,186,186,191,191,  0,255,  4, 10,  0,191,
  188,182,183,184,184,181,179,188,191,  0,255,  4, 10,  0,191,184,
  184,184,184,184,184,184,183,191,  0,255,  3, 12,  0,191,187,185,
  185,185,186,186,187,187,187,189,191,  0,255,  3, 12,  0,191,184,
  188,188,191,191,191,191,188,188, 44,191,  0,255,  3,  4,  0,191,
  184,189,191,  0, 11,  4,  0,191,183,187,191,  0,255,  3,  4,  0,
  191,181,188,191,  0, 11,  4,  0,191,178,187,191,  0,255,  3,  4,
    0,191,180,188,191,  0, 11,  4,  0,191,177,184,191,  0,255,  3,
    4,  0,191,178,184,191,  0, 11,  4,  0,191,178,187,191,  0,255,
    3,  4,  0,191,178,186,191,  0,  8,  7,  0,191,191,191,191,179,
  186,191,  0,255,  3,  4,  0,191,178,184,191,  0,  8,  7,  0,191,
  182,184,185,184,186,191,  0,255,  3,  4,  0,191,178,185,191,  0,
    8,  7,  0,191,177,178,178,178,183,191,  0,255,  3,  4,  0,191,
  180,185,191,  0,  8,  7,  0,191,177,177,177,177,183,191,  0,255,
    3,  4,  0,191,185,187,191,  0,  8,  7,  0,191,184,185,185,185,
  186,191,  0,255,  3, 12,  0,191,191,191,191,191,191,191,191,191,
  191,191,191,  0,255,  5,  8,  0,191,191,186,185,185,186,191,191,
    0,255,  4, 10,  0,191,188,185,182,182,182,181,183,188,191,  0,
  255,  4, 10,  0,191,183,181,181,181,182,181,178,185,191,  0,255,
    3, 12,  0,191,185,182,181,181,181,181,180,179,179,186,191,  0,
  255,  3, 12,  0,191,180,182,185,185,181,182,185,185,181,184,191,
    0,255,  3, 12,  0,191,182,186,191,191,181,186,191,191,179,185,
  191,  0,255,  3, 12,  0,191,179,187,191,191,180,188,191,191,178,
  185,191,  0,255,  3, 12,  0,191,179,186,191,191,180,187,191,191,
  178,186,191,  0,255,  3, 12,  0,191,180,188,191,191,180,188,191,
  191,178,185,191,  0,255,  3, 12,  0,191,180,188,191,191,178,186,
  191,191,179,186,191,  0,255,  3, 12,  0,191,179,185,191,191,178,
  185,191,191,180,186,191,  0,255,  3, 12,  0,191,184,187,191,191,
  185,187,191,191,183,186,191,  0,255,  3, 12,  0,191,191,191,191,
  191,191,191,191,191,191,191,191,  0,255,  4,  6,  0,191,187,185,
  185,187,191,  0, 11,  4,  0,191,184,186,191,  0,255,  3, 12,  0,
  191,182,180,180,180,180,186,191,191,178,186,191,  0,255,  3, 12,
    0,191,179,180,180,179,180,188,191,191,177,185,191,  0,255,  3,
   12,  0,191,178,184,184,184,183,186,191,191,177,186,191,  0,255,
    3, 12,  0,191,178,187,191,191,179,188,191,191,179,188,191,  0,
  255,  3, 12,  0,191,178,188,191,191,178,186,191,191,178,186,191,
    0,255,  3, 12,  0,191,178,187,191,191,178,185,191,191,179,187,
  191,  0,255,  3, 12,  0,191,180,186,191,191,178,186,191,191,182,
  186,191,  0,255,  3, 12,  0,191,182,186,191,191,180,188,191,191,
  181,185,191,  0,255,  3, 12,  0,191,180,186,191,191,180,188,188,
  187,182,185,191,  0,255,  3, 12,  0,191,183,189,191,191,182,184,
  184,184,184,186,191,  0,255,  3, 12,  0,191,185, 45,191,191,186,
  184,185,185,184,188,191,  0,255,  3,  4,  0,191,186,188,191,  0,
    8,  6,  0,191,187,186,186,187,191,  0,255,  3,  4,  0,191,191,
  191,191,  0,  9,  4,  0,191,191,191,191,  0,255,
};


static const char m_colors[]=  // Palette for color selection
{
  137,  0,137,  0,  0,  0,  0,  0,
   44,  2,  0,  0,186,  2,  0,  0, 72,  3,  0,  0,214,  3,  0,  0,
  100,  4,  0,  0,242,  4,  0,  0,128,  5,  0,  0, 14,  6,  0,  0,
  156,  6,  0,  0, 42,  7,  0,  0,184,  7,  0,  0, 70,  8,  0,  0,
  212,  8,  0,  0, 98,  9,  0,  0,240,  9,  0,  0,126, 10,  0,  0,
   12, 11,  0,  0,154, 11,  0,  0, 40, 12,  0,  0,182, 12,  0,  0,
   68, 13,  0,  0,210, 13,  0,  0, 96, 14,  0,  0,238, 14,  0,  0,
  124, 15,  0,  0, 10, 16,  0,  0,152, 16,  0,  0, 38, 17,  0,  0,
  180, 17,  0,  0, 66, 18,  0,  0,208, 18,  0,  0, 94, 19,  0,  0,
  236, 19,  0,  0,122, 20,  0,  0,  8, 21,  0,  0,150, 21,  0,  0,
   36, 22,  0,  0,178, 22,  0,  0, 64, 23,  0,  0,206, 23,  0,  0,
   92, 24,  0,  0,234, 24,  0,  0,120, 25,  0,  0,  6, 26,  0,  0,
  148, 26,  0,  0, 34, 27,  0,  0,176, 27,  0,  0, 62, 28,  0,  0,
  204, 28,  0,  0, 90, 29,  0,  0,232, 29,  0,  0,118, 30,  0,  0,
    4, 31,  0,  0,146, 31,  0,  0, 32, 32,  0,  0,174, 32,  0,  0,
   60, 33,  0,  0,202, 33,  0,  0, 88, 34,  0,  0,230, 34,  0,  0,
  116, 35,  0,  0,  2, 36,  0,  0,144, 36,  0,  0, 30, 37,  0,  0,
  172, 37,  0,  0, 58, 38,  0,  0,200, 38,  0,  0, 86, 39,  0,  0,
  228, 39,  0,  0,114, 40,  0,  0,  0, 41,  0,  0,142, 41,  0,  0,
   28, 42,  0,  0,170, 42,  0,  0, 56, 43,  0,  0,198, 43,  0,  0,
   84, 44,  0,  0,226, 44,  0,  0,112, 45,  0,  0,254, 45,  0,  0,
  140, 46,  0,  0, 26, 47,  0,  0,168, 47,  0,  0, 54, 48,  0,  0,
  196, 48,  0,  0, 82, 49,  0,  0,224, 49,  0,  0,110, 50,  0,  0,
  252, 50,  0,  0,138, 51,  0,  0, 24, 52,  0,  0,166, 52,  0,  0,
   52, 53,  0,  0,194, 53,  0,  0, 80, 54,  0,  0,222, 54,  0,  0,
  108, 55,  0,  0,250, 55,  0,  0,136, 56,  0,  0, 22, 57,  0,  0,
  164, 57,  0,  0, 50, 58,  0,  0,192, 58,  0,  0, 78, 59,  0,  0,
  220, 59,  0,  0,106, 60,  0,  0,248, 60,  0,  0,134, 61,  0,  0,
   20, 62,  0,  0,162, 62,  0,  0, 48, 63,  0,  0,190, 63,  0,  0,
   76, 64,  0,  0,218, 64,  0,  0,104, 65,  0,  0,246, 65,  0,  0,
  132, 66,  0,  0, 18, 67,  0,  0,160, 67,  0,  0, 46, 68,  0,  0,
  188, 68,  0,  0, 74, 69,  0,  0,216, 69,  0,  0,102, 70,  0,  0,
  244, 70,  0,  0,130, 71,  0,  0, 16, 72,  0,  0,158, 72,  0,  0,
   44, 73,  0,  0,186, 73,  0,  0, 72, 74,  0,  0,214, 74,  0,  0,
  100, 75,  0,  0,242, 75,  0,  0,128, 76,  0,  0, 14, 77,  0,  0,
  156, 77,  0,  0,  0,137,  0, 91, 91, 91, 94, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 98,
    0,255,  0,137,  0, 91, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,105,  0,255,
    0,137,  0, 91, 98,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105, 94, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  4,  0,  0,  0,  0,  0,  4,  0, 16, 16, 16, 16, 16, 16,
   16,  0, 32, 32, 32, 32, 32, 32, 32,  0, 48, 48, 48, 48, 48, 48,
   48,  0, 64, 64, 64, 64, 64, 64, 64,  0, 80, 80, 80, 80, 80, 80,
   80,  0, 96, 96, 96, 96, 96, 96, 96,  0,112,112,112,112,112,112,
  112,  0,128,128,128,128,128,128,128,  0,144,144,144,144,144,144,
  144,  0,160,160,160,160,160,160,160,  0,176,176,176,176,176,176,
  176,  0,192,192,192,192,192,192,192,  0,255,255,255,255,255,255,
  255,  0,255,255,255,255,255,255,255,  0,207,207,207,207,207,207,
  207,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    0,  4,  0,  0,  0,  4,  0,  0, 16, 16, 16, 16, 16, 16, 16,  0,
   32, 32, 32, 32, 32, 32, 32,  0, 48, 48, 48, 48, 48, 48, 48,  0,
   64, 64, 64, 64, 64, 64, 64,  0, 80, 80, 80, 80, 80, 80, 80,  0,
   96, 96, 96, 96, 96, 96, 96,  0,112,112,112,112,112,112,112,  0,
  128,128,128,128,128,128,128,  0,144,144,144,144,144,144,144,  0,
  160,160,160,160,160,160,160,  0,176,176,176,176,176,176,176,  0,
  192,192,192,192,192,192,192,  0,255,255,255,255,255,255,255,  0,
  255,255,255,255,255,255,255,  0,207,207,207,207,207,207,207,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  0,  0,
    4,  0,  4,  0,  0,  0, 16, 16, 16, 16, 16, 16, 16,  0, 32, 32,
   32, 32, 32, 32, 32,  0, 48, 48, 48, 48, 48, 48, 48,  0, 64, 64,
   64, 64, 64, 64, 64,  0, 80, 80, 80, 80, 80, 80, 80,  0, 96, 96,
   96, 96, 96, 96, 96,  0,112,112,112,112,112,112,112,  0,128,128,
  128,128,128,128,128,  0,144,144,144,144,144,144,144,  0,160,160,
  160,160,160,160,160,  0,176,176,176,176,176,176,176,  0,192,192,
  192,192,192,192,192,  0,255,255,255,255,255,255,255,  0,255,255,
  255,255,255,255,255,  0,207,207,207,207,207,207,207,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  0,  0,  0,  4,
    0,  0,  0,  0, 16, 16, 16, 16, 16, 16, 16,  0, 32, 32, 32, 32,
   32, 32, 32,  0, 48, 48, 48, 48, 48, 48, 48,  0, 64, 64, 64, 64,
   64, 64, 64,  0, 80, 80, 80, 80, 80, 80, 80,  0, 96, 96, 96, 96,
   96, 96, 96,  0,112,112,112,112,112,112,112,  0,128,128,128,128,
  128,128,128,  0,144,144,144,144,144,144,144,  0,160,160,160,160,
  160,160,160,  0,176,176,176,176,176,176,176,  0,192,192,192,192,
  192,192,192,  0,255,255,255,255,255,255,255,  0,255,255,255,255,
  255,255,255,  0,207,207,207,207,207,207,207,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  0,  0,  4,  0,  4,  0,
    0,  0, 16, 16, 16, 16, 16, 16, 16,  0, 32, 32, 32, 32, 32, 32,
   32,  0, 48, 48, 48, 48, 48, 48, 48,  0, 64, 64, 64, 64, 64, 64,
   64,  0, 80, 80, 80, 80, 80, 80, 80,  0, 96, 96, 96, 96, 96, 96,
   96,  0,112,112,112,112,112,112,112,  0,128,128,128,128,128,128,
  128,  0,144,144,144,144,144,144,144,  0,160,160,160,160,160,160,
  160,  0,176,176,176,176,176,176,176,  0,192,192,192,192,192,192,
  192,  0,255,255,255,255,255,255,255,  0,255,255,255,255,255,255,
  255,  0,207,207,207,207,207,207,207,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  0,  4,  0,  0,  0,  4,  0,  0,
   16, 16, 16, 16, 16, 16, 16,  0, 32, 32, 32, 32, 32, 32, 32,  0,
   48, 48, 48, 48, 48, 48, 48,  0, 64, 64, 64, 64, 64, 64, 64,  0,
   80, 80, 80, 80, 80, 80, 80,  0, 96, 96, 96, 96, 96, 96, 96,  0,
  112,112,112,112,112,112,112,  0,128,128,128,128,128,128,128,  0,
  144,144,144,144,144,144,144,  0,160,160,160,160,160,160,160,  0,
  176,176,176,176,176,176,176,  0,192,192,192,192,192,192,192,  0,
  255,255,255,255,255,255,255,  0,255,255,255,255,255,255,255,  0,
  207,207,207,207,207,207,207,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  4,  0,  0,  0,  0,  0,  4,  0, 16, 16,
   16, 16, 16, 16, 16,  0, 32, 32, 32, 32, 32, 32, 32,  0, 48, 48,
   48, 48, 48, 48, 48,  0, 64, 64, 64, 64, 64, 64, 64,  0, 80, 80,
   80, 80, 80, 80, 80,  0, 96, 96, 96, 96, 96, 96, 96,  0,112,112,
  112,112,112,112,112,  0,128,128,128,128,128,128,128,  0,144,144,
  144,144,144,144,144,  0,160,160,160,160,160,160,160,  0,176,176,
  176,176,176,176,176,  0,192,192,192,192,192,192,192,  0,255,255,
  255,255,255,255,255,  0,255,255,255,255,255,255,255,  0,207,207,
  207,207,207,207,207,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  1,  1,  1,  1,  1,  1,  1,  0, 17, 17, 17, 17, 17, 17,
   17,  0, 33, 33, 33, 33, 33, 33, 33,  0, 49, 49, 49, 49, 49, 49,
   49,  0, 65, 65, 65, 65, 65, 65, 65,  0, 81, 81, 81, 81, 81, 81,
   81,  0, 97, 97, 97, 97, 97, 97, 97,  0,113,113,113,113,113,113,
  113,  0,129,129,129,129,129,129,129,  0,145,145,145,145,145,145,
  145,  0,161,161,161,161,161,161,161,  0,177,177,177,177,177,177,
  177,  0,193,193,193,193,193,193,193,  0,209,209,209,209,209,209,
  209,  0,225,225,225,225,225,225,225,  0,241,241,241,241,241,241,
  241,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    1,  1,  1,  1,  1,  1,  1,  0, 17, 17, 17, 17, 17, 17, 17,  0,
   33, 33, 33, 33, 33, 33, 33,  0, 49, 49, 49, 49, 49, 49, 49,  0,
   65, 65, 65, 65, 65, 65, 65,  0, 81, 81, 81, 81, 81, 81, 81,  0,
   97, 97, 97, 97, 97, 97, 97,  0,113,113,113,113,113,113,113,  0,
  129,129,129,129,129,129,129,  0,145,145,145,145,145,145,145,  0,
  161,161,161,161,161,161,161,  0,177,177,177,177,177,177,177,  0,
  193,193,193,193,193,193,193,  0,209,209,209,209,209,209,209,  0,
  225,225,225,225,225,225,225,  0,241,241,241,241,241,241,241,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  1,  1,
    1,  1,  1,  1,  1,  0, 17, 17, 17, 17, 17, 17, 17,  0, 33, 33,
   33, 33, 33, 33, 33,  0, 49, 49, 49, 49, 49, 49, 49,  0, 65, 65,
   65, 65, 65, 65, 65,  0, 81, 81, 81, 81, 81, 81, 81,  0, 97, 97,
   97, 97, 97, 97, 97,  0,113,113,113,113,113,113,113,  0,129,129,
  129,129,129,129,129,  0,145,145,145,145,145,145,145,  0,161,161,
  161,161,161,161,161,  0,177,177,177,177,177,177,177,  0,193,193,
  193,193,193,193,193,  0,209,209,209,209,209,209,209,  0,225,225,
  225,225,225,225,225,  0,241,241,241,241,241,241,241,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  1,  1,  1,  1,
    1,  1,  1,  0, 17, 17, 17, 17, 17, 17, 17,  0, 33, 33, 33, 33,
   33, 33, 33,  0, 49, 49, 49, 49, 49, 49, 49,  0, 65, 65, 65, 65,
   65, 65, 65,  0, 81, 81, 81, 81, 81, 81, 81,  0, 97, 97, 97, 97,
   97, 97, 97,  0,113,113,113,113,113,113,113,  0,129,129,129,129,
  129,129,129,  0,145,145,145,145,145,145,145,  0,161,161,161,161,
  161,161,161,  0,177,177,177,177,177,177,177,  0,193,193,193,193,
  193,193,193,  0,209,209,209,209,209,209,209,  0,225,225,225,225,
  225,225,225,  0,241,241,241,241,241,241,241,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  1,  1,  1,  1,  1,  1,
    1,  0, 17, 17, 17, 17, 17, 17, 17,  0, 33, 33, 33, 33, 33, 33,
   33,  0, 49, 49, 49, 49, 49, 49, 49,  0, 65, 65, 65, 65, 65, 65,
   65,  0, 81, 81, 81, 81, 81, 81, 81,  0, 97, 97, 97, 97, 97, 97,
   97,  0,113,113,113,113,113,113,113,  0,129,129,129,129,129,129,
  129,  0,145,145,145,145,145,145,145,  0,161,161,161,161,161,161,
  161,  0,177,177,177,177,177,177,177,  0,193,193,193,193,193,193,
  193,  0,209,209,209,209,209,209,209,  0,225,225,225,225,225,225,
  225,  0,241,241,241,241,241,241,241,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  1,  1,  1,  1,  1,  1,  1,  0,
   17, 17, 17, 17, 17, 17, 17,  0, 33, 33, 33, 33, 33, 33, 33,  0,
   49, 49, 49, 49, 49, 49, 49,  0, 65, 65, 65, 65, 65, 65, 65,  0,
   81, 81, 81, 81, 81, 81, 81,  0, 97, 97, 97, 97, 97, 97, 97,  0,
  113,113,113,113,113,113,113,  0,129,129,129,129,129,129,129,  0,
  145,145,145,145,145,145,145,  0,161,161,161,161,161,161,161,  0,
  177,177,177,177,177,177,177,  0,193,193,193,193,193,193,193,  0,
  209,209,209,209,209,209,209,  0,225,225,225,225,225,225,225,  0,
  241,241,241,241,241,241,241,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  1,  1,  1,  1,  1,  1,  1,  0, 17, 17,
   17, 17, 17, 17, 17,  0, 33, 33, 33, 33, 33, 33, 33,  0, 49, 49,
   49, 49, 49, 49, 49,  0, 65, 65, 65, 65, 65, 65, 65,  0, 81, 81,
   81, 81, 81, 81, 81,  0, 97, 97, 97, 97, 97, 97, 97,  0,113,113,
  113,113,113,113,113,  0,129,129,129,129,129,129,129,  0,145,145,
  145,145,145,145,145,  0,161,161,161,161,161,161,161,  0,177,177,
  177,177,177,177,177,  0,193,193,193,193,193,193,193,  0,209,209,
  209,209,209,209,209,  0,225,225,225,225,225,225,225,  0,241,241,
  241,241,241,241,241,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  2,  2,  2,  2,  2,  2,  2,  0, 18, 18, 18, 18, 18, 18,
   18,  0, 34, 34, 34, 34, 34, 34, 34,  0, 50, 50, 50, 50, 50, 50,
   50,  0, 66, 66, 66, 66, 66, 66, 66,  0, 82, 82, 82, 82, 82, 82,
   82,  0, 98, 98, 98, 98, 98, 98, 98,  0,114,114,114,114,114,114,
  114,  0,130,130,130,130,130,130,130,  0,146,146,146,146,146,146,
  146,  0,162,162,162,162,162,162,162,  0,178,178,178,178,178,178,
  178,  0,194,194,194,194,194,194,194,  0,210,210,210,210,210,210,
  210,  0,226,226,226,226,226,226,226,  0,242,242,242,242,242,242,
  242,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    2,  2,  2,  2,  2,  2,  2,  0, 18, 18, 18, 18, 18, 18, 18,  0,
   34, 34, 34, 34, 34, 34, 34,  0, 50, 50, 50, 50, 50, 50, 50,  0,
   66, 66, 66, 66, 66, 66, 66,  0, 82, 82, 82, 82, 82, 82, 82,  0,
   98, 98, 98, 98, 98, 98, 98,  0,114,114,114,114,114,114,114,  0,
  130,130,130,130,130,130,130,  0,146,146,146,146,146,146,146,  0,
  162,162,162,162,162,162,162,  0,178,178,178,178,178,178,178,  0,
  194,194,194,194,194,194,194,  0,210,210,210,210,210,210,210,  0,
  226,226,226,226,226,226,226,  0,242,242,242,242,242,242,242,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  2,  2,
    2,  2,  2,  2,  2,  0, 18, 18, 18, 18, 18, 18, 18,  0, 34, 34,
   34, 34, 34, 34, 34,  0, 50, 50, 50, 50, 50, 50, 50,  0, 66, 66,
   66, 66, 66, 66, 66,  0, 82, 82, 82, 82, 82, 82, 82,  0, 98, 98,
   98, 98, 98, 98, 98,  0,114,114,114,114,114,114,114,  0,130,130,
  130,130,130,130,130,  0,146,146,146,146,146,146,146,  0,162,162,
  162,162,162,162,162,  0,178,178,178,178,178,178,178,  0,194,194,
  194,194,194,194,194,  0,210,210,210,210,210,210,210,  0,226,226,
  226,226,226,226,226,  0,242,242,242,242,242,242,242,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  2,  2,  2,  2,
    2,  2,  2,  0, 18, 18, 18, 18, 18, 18, 18,  0, 34, 34, 34, 34,
   34, 34, 34,  0, 50, 50, 50, 50, 50, 50, 50,  0, 66, 66, 66, 66,
   66, 66, 66,  0, 82, 82, 82, 82, 82, 82, 82,  0, 98, 98, 98, 98,
   98, 98, 98,  0,114,114,114,114,114,114,114,  0,130,130,130,130,
  130,130,130,  0,146,146,146,146,146,146,146,  0,162,162,162,162,
  162,162,162,  0,178,178,178,178,178,178,178,  0,194,194,194,194,
  194,194,194,  0,210,210,210,210,210,210,210,  0,226,226,226,226,
  226,226,226,  0,242,242,242,242,242,242,242,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  2,  2,  2,  2,  2,  2,
    2,  0, 18, 18, 18, 18, 18, 18, 18,  0, 34, 34, 34, 34, 34, 34,
   34,  0, 50, 50, 50, 50, 50, 50, 50,  0, 66, 66, 66, 66, 66, 66,
   66,  0, 82, 82, 82, 82, 82, 82, 82,  0, 98, 98, 98, 98, 98, 98,
   98,  0,114,114,114,114,114,114,114,  0,130,130,130,130,130,130,
  130,  0,146,146,146,146,146,146,146,  0,162,162,162,162,162,162,
  162,  0,178,178,178,178,178,178,178,  0,194,194,194,194,194,194,
  194,  0,210,210,210,210,210,210,210,  0,226,226,226,226,226,226,
  226,  0,242,242,242,242,242,242,242,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  2,  2,  2,  2,  2,  2,  2,  0,
   18, 18, 18, 18, 18, 18, 18,  0, 34, 34, 34, 34, 34, 34, 34,  0,
   50, 50, 50, 50, 50, 50, 50,  0, 66, 66, 66, 66, 66, 66, 66,  0,
   82, 82, 82, 82, 82, 82, 82,  0, 98, 98, 98, 98, 98, 98, 98,  0,
  114,114,114,114,114,114,114,  0,130,130,130,130,130,130,130,  0,
  146,146,146,146,146,146,146,  0,162,162,162,162,162,162,162,  0,
  178,178,178,178,178,178,178,  0,194,194,194,194,194,194,194,  0,
  210,210,210,210,210,210,210,  0,226,226,226,226,226,226,226,  0,
  242,242,242,242,242,242,242,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  2,  2,  2,  2,  2,  2,  2,  0, 18, 18,
   18, 18, 18, 18, 18,  0, 34, 34, 34, 34, 34, 34, 34,  0, 50, 50,
   50, 50, 50, 50, 50,  0, 66, 66, 66, 66, 66, 66, 66,  0, 82, 82,
   82, 82, 82, 82, 82,  0, 98, 98, 98, 98, 98, 98, 98,  0,114,114,
  114,114,114,114,114,  0,130,130,130,130,130,130,130,  0,146,146,
  146,146,146,146,146,  0,162,162,162,162,162,162,162,  0,178,178,
  178,178,178,178,178,  0,194,194,194,194,194,194,194,  0,210,210,
  210,210,210,210,210,  0,226,226,226,226,226,226,226,  0,242,242,
  242,242,242,242,242,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  3,  3,  3,  3,  3,  3,  3,  0, 19, 19, 19, 19, 19, 19,
   19,  0, 35, 35, 35, 35, 35, 35, 35,  0, 51, 51, 51, 51, 51, 51,
   51,  0, 67, 67, 67, 67, 67, 67, 67,  0, 83, 83, 83, 83, 83, 83,
   83,  0, 99, 99, 99, 99, 99, 99, 99,  0,115,115,115,115,115,115,
  115,  0,131,131,131,131,131,131,131,  0,147,147,147,147,147,147,
  147,  0,163,163,163,163,163,163,163,  0,179,179,179,179,179,179,
  179,  0,195,195,195,195,195,195,195,  0,211,211,211,211,211,211,
  211,  0,227,227,227,227,227,227,227,  0,243,243,243,243,243,243,
  243,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    3,  3,  3,  3,  3,  3,  3,  0, 19, 19, 19, 19, 19, 19, 19,  0,
   35, 35, 35, 35, 35, 35, 35,  0, 51, 51, 51, 51, 51, 51, 51,  0,
   67, 67, 67, 67, 67, 67, 67,  0, 83, 83, 83, 83, 83, 83, 83,  0,
   99, 99, 99, 99, 99, 99, 99,  0,115,115,115,115,115,115,115,  0,
  131,131,131,131,131,131,131,  0,147,147,147,147,147,147,147,  0,
  163,163,163,163,163,163,163,  0,179,179,179,179,179,179,179,  0,
  195,195,195,195,195,195,195,  0,211,211,211,211,211,211,211,  0,
  227,227,227,227,227,227,227,  0,243,243,243,243,243,243,243,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  3,  3,
    3,  3,  3,  3,  3,  0, 19, 19, 19, 19, 19, 19, 19,  0, 35, 35,
   35, 35, 35, 35, 35,  0, 51, 51, 51, 51, 51, 51, 51,  0, 67, 67,
   67, 67, 67, 67, 67,  0, 83, 83, 83, 83, 83, 83, 83,  0, 99, 99,
   99, 99, 99, 99, 99,  0,115,115,115,115,115,115,115,  0,131,131,
  131,131,131,131,131,  0,147,147,147,147,147,147,147,  0,163,163,
  163,163,163,163,163,  0,179,179,179,179,179,179,179,  0,195,195,
  195,195,195,195,195,  0,211,211,211,211,211,211,211,  0,227,227,
  227,227,227,227,227,  0,243,243,243,243,243,243,243,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  3,  3,  3,  3,
    3,  3,  3,  0, 19, 19, 19, 19, 19, 19, 19,  0, 35, 35, 35, 35,
   35, 35, 35,  0, 51, 51, 51, 51, 51, 51, 51,  0, 67, 67, 67, 67,
   67, 67, 67,  0, 83, 83, 83, 83, 83, 83, 83,  0, 99, 99, 99, 99,
   99, 99, 99,  0,115,115,115,115,115,115,115,  0,131,131,131,131,
  131,131,131,  0,147,147,147,147,147,147,147,  0,163,163,163,163,
  163,163,163,  0,179,179,179,179,179,179,179,  0,195,195,195,195,
  195,195,195,  0,211,211,211,211,211,211,211,  0,227,227,227,227,
  227,227,227,  0,243,243,243,243,243,243,243,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  3,  3,  3,  3,  3,  3,
    3,  0, 19, 19, 19, 19, 19, 19, 19,  0, 35, 35, 35, 35, 35, 35,
   35,  0, 51, 51, 51, 51, 51, 51, 51,  0, 67, 67, 67, 67, 67, 67,
   67,  0, 83, 83, 83, 83, 83, 83, 83,  0, 99, 99, 99, 99, 99, 99,
   99,  0,115,115,115,115,115,115,115,  0,131,131,131,131,131,131,
  131,  0,147,147,147,147,147,147,147,  0,163,163,163,163,163,163,
  163,  0,179,179,179,179,179,179,179,  0,195,195,195,195,195,195,
  195,  0,211,211,211,211,211,211,211,  0,227,227,227,227,227,227,
  227,  0,243,243,243,243,243,243,243,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  3,  3,  3,  3,  3,  3,  3,  0,
   19, 19, 19, 19, 19, 19, 19,  0, 35, 35, 35, 35, 35, 35, 35,  0,
   51, 51, 51, 51, 51, 51, 51,  0, 67, 67, 67, 67, 67, 67, 67,  0,
   83, 83, 83, 83, 83, 83, 83,  0, 99, 99, 99, 99, 99, 99, 99,  0,
  115,115,115,115,115,115,115,  0,131,131,131,131,131,131,131,  0,
  147,147,147,147,147,147,147,  0,163,163,163,163,163,163,163,  0,
  179,179,179,179,179,179,179,  0,195,195,195,195,195,195,195,  0,
  211,211,211,211,211,211,211,  0,227,227,227,227,227,227,227,  0,
  243,243,243,243,243,243,243,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  3,  3,  3,  3,  3,  3,  3,  0, 19, 19,
   19, 19, 19, 19, 19,  0, 35, 35, 35, 35, 35, 35, 35,  0, 51, 51,
   51, 51, 51, 51, 51,  0, 67, 67, 67, 67, 67, 67, 67,  0, 83, 83,
   83, 83, 83, 83, 83,  0, 99, 99, 99, 99, 99, 99, 99,  0,115,115,
  115,115,115,115,115,  0,131,131,131,131,131,131,131,  0,147,147,
  147,147,147,147,147,  0,163,163,163,163,163,163,163,  0,179,179,
  179,179,179,179,179,  0,195,195,195,195,195,195,195,  0,211,211,
  211,211,211,211,211,  0,227,227,227,227,227,227,227,  0,243,243,
  243,243,243,243,243,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  4,  4,  4,  4,  4,  4,  4,  0, 20, 20, 20, 20, 20, 20,
   20,  0, 36, 36, 36, 36, 36, 36, 36,  0, 52, 52, 52, 52, 52, 52,
   52,  0, 68, 68, 68, 68, 68, 68, 68,  0, 84, 84, 84, 84, 84, 84,
   84,  0,100,100,100,100,100,100,100,  0,116,116,116,116,116,116,
  116,  0,132,132,132,132,132,132,132,  0,148,148,148,148,148,148,
  148,  0,164,164,164,164,164,164,164,  0,180,180,180,180,180,180,
  180,  0,196,196,196,196,196,196,196,  0,212,212,212,212,212,212,
  212,  0,228,228,228,228,228,228,228,  0,244,244,244,244,244,244,
  244,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    4,  4,  4,  4,  4,  4,  4,  0, 20, 20, 20, 20, 20, 20, 20,  0,
   36, 36, 36, 36, 36, 36, 36,  0, 52, 52, 52, 52, 52, 52, 52,  0,
   68, 68, 68, 68, 68, 68, 68,  0, 84, 84, 84, 84, 84, 84, 84,  0,
  100,100,100,100,100,100,100,  0,116,116,116,116,116,116,116,  0,
  132,132,132,132,132,132,132,  0,148,148,148,148,148,148,148,  0,
  164,164,164,164,164,164,164,  0,180,180,180,180,180,180,180,  0,
  196,196,196,196,196,196,196,  0,212,212,212,212,212,212,212,  0,
  228,228,228,228,228,228,228,  0,244,244,244,244,244,244,244,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  4,  4,
    4,  4,  4,  4,  4,  0, 20, 20, 20, 20, 20, 20, 20,  0, 36, 36,
   36, 36, 36, 36, 36,  0, 52, 52, 52, 52, 52, 52, 52,  0, 68, 68,
   68, 68, 68, 68, 68,  0, 84, 84, 84, 84, 84, 84, 84,  0,100,100,
  100,100,100,100,100,  0,116,116,116,116,116,116,116,  0,132,132,
  132,132,132,132,132,  0,148,148,148,148,148,148,148,  0,164,164,
  164,164,164,164,164,  0,180,180,180,180,180,180,180,  0,196,196,
  196,196,196,196,196,  0,212,212,212,212,212,212,212,  0,228,228,
  228,228,228,228,228,  0,244,244,244,244,244,244,244,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  4,  4,  4,  4,
    4,  4,  4,  0, 20, 20, 20, 20, 20, 20, 20,  0, 36, 36, 36, 36,
   36, 36, 36,  0, 52, 52, 52, 52, 52, 52, 52,  0, 68, 68, 68, 68,
   68, 68, 68,  0, 84, 84, 84, 84, 84, 84, 84,  0,100,100,100,100,
  100,100,100,  0,116,116,116,116,116,116,116,  0,132,132,132,132,
  132,132,132,  0,148,148,148,148,148,148,148,  0,164,164,164,164,
  164,164,164,  0,180,180,180,180,180,180,180,  0,196,196,196,196,
  196,196,196,  0,212,212,212,212,212,212,212,  0,228,228,228,228,
  228,228,228,  0,244,244,244,244,244,244,244,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  4,  4,  4,  4,  4,  4,
    4,  0, 20, 20, 20, 20, 20, 20, 20,  0, 36, 36, 36, 36, 36, 36,
   36,  0, 52, 52, 52, 52, 52, 52, 52,  0, 68, 68, 68, 68, 68, 68,
   68,  0, 84, 84, 84, 84, 84, 84, 84,  0,100,100,100,100,100,100,
  100,  0,116,116,116,116,116,116,116,  0,132,132,132,132,132,132,
  132,  0,148,148,148,148,148,148,148,  0,164,164,164,164,164,164,
  164,  0,180,180,180,180,180,180,180,  0,196,196,196,196,196,196,
  196,  0,212,212,212,212,212,212,212,  0,228,228,228,228,228,228,
  228,  0,244,244,244,244,244,244,244,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  4,  4,  4,  4,  4,  4,  4,  0,
   20, 20, 20, 20, 20, 20, 20,  0, 36, 36, 36, 36, 36, 36, 36,  0,
   52, 52, 52, 52, 52, 52, 52,  0, 68, 68, 68, 68, 68, 68, 68,  0,
   84, 84, 84, 84, 84, 84, 84,  0,100,100,100,100,100,100,100,  0,
  116,116,116,116,116,116,116,  0,132,132,132,132,132,132,132,  0,
  148,148,148,148,148,148,148,  0,164,164,164,164,164,164,164,  0,
  180,180,180,180,180,180,180,  0,196,196,196,196,196,196,196,  0,
  212,212,212,212,212,212,212,  0,228,228,228,228,228,228,228,  0,
  244,244,244,244,244,244,244,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  4,  4,  4,  4,  4,  4,  4,  0, 20, 20,
   20, 20, 20, 20, 20,  0, 36, 36, 36, 36, 36, 36, 36,  0, 52, 52,
   52, 52, 52, 52, 52,  0, 68, 68, 68, 68, 68, 68, 68,  0, 84, 84,
   84, 84, 84, 84, 84,  0,100,100,100,100,100,100,100,  0,116,116,
  116,116,116,116,116,  0,132,132,132,132,132,132,132,  0,148,148,
  148,148,148,148,148,  0,164,164,164,164,164,164,164,  0,180,180,
  180,180,180,180,180,  0,196,196,196,196,196,196,196,  0,212,212,
  212,212,212,212,212,  0,228,228,228,228,228,228,228,  0,244,244,
  244,244,244,244,244,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  5,  5,  5,  5,  5,  5,  5,  0, 21, 21, 21, 21, 21, 21,
   21,  0, 37, 37, 37, 37, 37, 37, 37,  0, 53, 53, 53, 53, 53, 53,
   53,  0, 69, 69, 69, 69, 69, 69, 69,  0, 85, 85, 85, 85, 85, 85,
   85,  0,101,101,101,101,101,101,101,  0,117,117,117,117,117,117,
  117,  0,133,133,133,133,133,133,133,  0,149,149,149,149,149,149,
  149,  0,165,165,165,165,165,165,165,  0,181,181,181,181,181,181,
  181,  0,197,197,197,197,197,197,197,  0,213,213,213,213,213,213,
  213,  0,229,229,229,229,229,229,229,  0,245,245,245,245,245,245,
  245,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    5,  5,  5,  5,  5,  5,  5,  0, 21, 21, 21, 21, 21, 21, 21,  0,
   37, 37, 37, 37, 37, 37, 37,  0, 53, 53, 53, 53, 53, 53, 53,  0,
   69, 69, 69, 69, 69, 69, 69,  0, 85, 85, 85, 85, 85, 85, 85,  0,
  101,101,101,101,101,101,101,  0,117,117,117,117,117,117,117,  0,
  133,133,133,133,133,133,133,  0,149,149,149,149,149,149,149,  0,
  165,165,165,165,165,165,165,  0,181,181,181,181,181,181,181,  0,
  197,197,197,197,197,197,197,  0,213,213,213,213,213,213,213,  0,
  229,229,229,229,229,229,229,  0,245,245,245,245,245,245,245,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  5,  5,
    5,  5,  5,  5,  5,  0, 21, 21, 21, 21, 21, 21, 21,  0, 37, 37,
   37, 37, 37, 37, 37,  0, 53, 53, 53, 53, 53, 53, 53,  0, 69, 69,
   69, 69, 69, 69, 69,  0, 85, 85, 85, 85, 85, 85, 85,  0,101,101,
  101,101,101,101,101,  0,117,117,117,117,117,117,117,  0,133,133,
  133,133,133,133,133,  0,149,149,149,149,149,149,149,  0,165,165,
  165,165,165,165,165,  0,181,181,181,181,181,181,181,  0,197,197,
  197,197,197,197,197,  0,213,213,213,213,213,213,213,  0,229,229,
  229,229,229,229,229,  0,245,245,245,245,245,245,245,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  5,  5,  5,  5,
    5,  5,  5,  0, 21, 21, 21, 21, 21, 21, 21,  0, 37, 37, 37, 37,
   37, 37, 37,  0, 53, 53, 53, 53, 53, 53, 53,  0, 69, 69, 69, 69,
   69, 69, 69,  0, 85, 85, 85, 85, 85, 85, 85,  0,101,101,101,101,
  101,101,101,  0,117,117,117,117,117,117,117,  0,133,133,133,133,
  133,133,133,  0,149,149,149,149,149,149,149,  0,165,165,165,165,
  165,165,165,  0,181,181,181,181,181,181,181,  0,197,197,197,197,
  197,197,197,  0,213,213,213,213,213,213,213,  0,229,229,229,229,
  229,229,229,  0,245,245,245,245,245,245,245,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  5,  5,  5,  5,  5,  5,
    5,  0, 21, 21, 21, 21, 21, 21, 21,  0, 37, 37, 37, 37, 37, 37,
   37,  0, 53, 53, 53, 53, 53, 53, 53,  0, 69, 69, 69, 69, 69, 69,
   69,  0, 85, 85, 85, 85, 85, 85, 85,  0,101,101,101,101,101,101,
  101,  0,117,117,117,117,117,117,117,  0,133,133,133,133,133,133,
  133,  0,149,149,149,149,149,149,149,  0,165,165,165,165,165,165,
  165,  0,181,181,181,181,181,181,181,  0,197,197,197,197,197,197,
  197,  0,213,213,213,213,213,213,213,  0,229,229,229,229,229,229,
  229,  0,245,245,245,245,245,245,245,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  5,  5,  5,  5,  5,  5,  5,  0,
   21, 21, 21, 21, 21, 21, 21,  0, 37, 37, 37, 37, 37, 37, 37,  0,
   53, 53, 53, 53, 53, 53, 53,  0, 69, 69, 69, 69, 69, 69, 69,  0,
   85, 85, 85, 85, 85, 85, 85,  0,101,101,101,101,101,101,101,  0,
  117,117,117,117,117,117,117,  0,133,133,133,133,133,133,133,  0,
  149,149,149,149,149,149,149,  0,165,165,165,165,165,165,165,  0,
  181,181,181,181,181,181,181,  0,197,197,197,197,197,197,197,  0,
  213,213,213,213,213,213,213,  0,229,229,229,229,229,229,229,  0,
  245,245,245,245,245,245,245,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  5,  5,  5,  5,  5,  5,  5,  0, 21, 21,
   21, 21, 21, 21, 21,  0, 37, 37, 37, 37, 37, 37, 37,  0, 53, 53,
   53, 53, 53, 53, 53,  0, 69, 69, 69, 69, 69, 69, 69,  0, 85, 85,
   85, 85, 85, 85, 85,  0,101,101,101,101,101,101,101,  0,117,117,
  117,117,117,117,117,  0,133,133,133,133,133,133,133,  0,149,149,
  149,149,149,149,149,  0,165,165,165,165,165,165,165,  0,181,181,
  181,181,181,181,181,  0,197,197,197,197,197,197,197,  0,213,213,
  213,213,213,213,213,  0,229,229,229,229,229,229,229,  0,245,245,
  245,245,245,245,245,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  6,  6,  6,  6,  6,  6,  6,  0, 22, 22, 22, 22, 22, 22,
   22,  0, 38, 38, 38, 38, 38, 38, 38,  0, 54, 54, 54, 54, 54, 54,
   54,  0, 70, 70, 70, 70, 70, 70, 70,  0, 86, 86, 86, 86, 86, 86,
   86,  0,102,102,102,102,102,102,102,  0,118,118,118,118,118,118,
  118,  0,134,134,134,134,134,134,134,  0,150,150,150,150,150,150,
  150,  0,166,166,166,166,166,166,166,  0,182,182,182,182,182,182,
  182,  0,198,198,198,198,198,198,198,  0,214,214,214,214,214,214,
  214,  0,230,230,230,230,230,230,230,  0,246,246,246,246,246,246,
  246,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    6,  6,  6,  6,  6,  6,  6,  0, 22, 22, 22, 22, 22, 22, 22,  0,
   38, 38, 38, 38, 38, 38, 38,  0, 54, 54, 54, 54, 54, 54, 54,  0,
   70, 70, 70, 70, 70, 70, 70,  0, 86, 86, 86, 86, 86, 86, 86,  0,
  102,102,102,102,102,102,102,  0,118,118,118,118,118,118,118,  0,
  134,134,134,134,134,134,134,  0,150,150,150,150,150,150,150,  0,
  166,166,166,166,166,166,166,  0,182,182,182,182,182,182,182,  0,
  198,198,198,198,198,198,198,  0,214,214,214,214,214,214,214,  0,
  230,230,230,230,230,230,230,  0,246,246,246,246,246,246,246,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  6,  6,
    6,  6,  6,  6,  6,  0, 22, 22, 22, 22, 22, 22, 22,  0, 38, 38,
   38, 38, 38, 38, 38,  0, 54, 54, 54, 54, 54, 54, 54,  0, 70, 70,
   70, 70, 70, 70, 70,  0, 86, 86, 86, 86, 86, 86, 86,  0,102,102,
  102,102,102,102,102,  0,118,118,118,118,118,118,118,  0,134,134,
  134,134,134,134,134,  0,150,150,150,150,150,150,150,  0,166,166,
  166,166,166,166,166,  0,182,182,182,182,182,182,182,  0,198,198,
  198,198,198,198,198,  0,214,214,214,214,214,214,214,  0,230,230,
  230,230,230,230,230,  0,246,246,246,246,246,246,246,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  6,  6,  6,  6,
    6,  6,  6,  0, 22, 22, 22, 22, 22, 22, 22,  0, 38, 38, 38, 38,
   38, 38, 38,  0, 54, 54, 54, 54, 54, 54, 54,  0, 70, 70, 70, 70,
   70, 70, 70,  0, 86, 86, 86, 86, 86, 86, 86,  0,102,102,102,102,
  102,102,102,  0,118,118,118,118,118,118,118,  0,134,134,134,134,
  134,134,134,  0,150,150,150,150,150,150,150,  0,166,166,166,166,
  166,166,166,  0,182,182,182,182,182,182,182,  0,198,198,198,198,
  198,198,198,  0,214,214,214,214,214,214,214,  0,230,230,230,230,
  230,230,230,  0,246,246,246,246,246,246,246,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  6,  6,  6,  6,  6,  6,
    6,  0, 22, 22, 22, 22, 22, 22, 22,  0, 38, 38, 38, 38, 38, 38,
   38,  0, 54, 54, 54, 54, 54, 54, 54,  0, 70, 70, 70, 70, 70, 70,
   70,  0, 86, 86, 86, 86, 86, 86, 86,  0,102,102,102,102,102,102,
  102,  0,118,118,118,118,118,118,118,  0,134,134,134,134,134,134,
  134,  0,150,150,150,150,150,150,150,  0,166,166,166,166,166,166,
  166,  0,182,182,182,182,182,182,182,  0,198,198,198,198,198,198,
  198,  0,214,214,214,214,214,214,214,  0,230,230,230,230,230,230,
  230,  0,246,246,246,246,246,246,246,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  6,  6,  6,  6,  6,  6,  6,  0,
   22, 22, 22, 22, 22, 22, 22,  0, 38, 38, 38, 38, 38, 38, 38,  0,
   54, 54, 54, 54, 54, 54, 54,  0, 70, 70, 70, 70, 70, 70, 70,  0,
   86, 86, 86, 86, 86, 86, 86,  0,102,102,102,102,102,102,102,  0,
  118,118,118,118,118,118,118,  0,134,134,134,134,134,134,134,  0,
  150,150,150,150,150,150,150,  0,166,166,166,166,166,166,166,  0,
  182,182,182,182,182,182,182,  0,198,198,198,198,198,198,198,  0,
  214,214,214,214,214,214,214,  0,230,230,230,230,230,230,230,  0,
  246,246,246,246,246,246,246,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  6,  6,  6,  6,  6,  6,  6,  0, 22, 22,
   22, 22, 22, 22, 22,  0, 38, 38, 38, 38, 38, 38, 38,  0, 54, 54,
   54, 54, 54, 54, 54,  0, 70, 70, 70, 70, 70, 70, 70,  0, 86, 86,
   86, 86, 86, 86, 86,  0,102,102,102,102,102,102,102,  0,118,118,
  118,118,118,118,118,  0,134,134,134,134,134,134,134,  0,150,150,
  150,150,150,150,150,  0,166,166,166,166,166,166,166,  0,182,182,
  182,182,182,182,182,  0,198,198,198,198,198,198,198,  0,214,214,
  214,214,214,214,214,  0,230,230,230,230,230,230,230,  0,246,246,
  246,246,246,246,246,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  7,  7,  7,  7,  7,  7,  7,  0, 23, 23, 23, 23, 23, 23,
   23,  0, 39, 39, 39, 39, 39, 39, 39,  0, 55, 55, 55, 55, 55, 55,
   55,  0, 71, 71, 71, 71, 71, 71, 71,  0, 87, 87, 87, 87, 87, 87,
   87,  0,103,103,103,103,103,103,103,  0,119,119,119,119,119,119,
  119,  0,135,135,135,135,135,135,135,  0,151,151,151,151,151,151,
  151,  0,167,167,167,167,167,167,167,  0,183,183,183,183,183,183,
  183,  0,199,199,199,199,199,199,199,  0,215,215,215,215,215,215,
  215,  0,231,231,231,231,231,231,231,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    7,  7,  7,  7,  7,  7,  7,  0, 23, 23, 23, 23, 23, 23, 23,  0,
   39, 39, 39, 39, 39, 39, 39,  0, 55, 55, 55, 55, 55, 55, 55,  0,
   71, 71, 71, 71, 71, 71, 71,  0, 87, 87, 87, 87, 87, 87, 87,  0,
  103,103,103,103,103,103,103,  0,119,119,119,119,119,119,119,  0,
  135,135,135,135,135,135,135,  0,151,151,151,151,151,151,151,  0,
  167,167,167,167,167,167,167,  0,183,183,183,183,183,183,183,  0,
  199,199,199,199,199,199,199,  0,215,215,215,215,215,215,215,  0,
  231,231,231,231,231,231,231,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  7,  7,
    7,  7,  7,  7,  7,  0, 23, 23, 23, 23, 23, 23, 23,  0, 39, 39,
   39, 39, 39, 39, 39,  0, 55, 55, 55, 55, 55, 55, 55,  0, 71, 71,
   71, 71, 71, 71, 71,  0, 87, 87, 87, 87, 87, 87, 87,  0,103,103,
  103,103,103,103,103,  0,119,119,119,119,119,119,119,  0,135,135,
  135,135,135,135,135,  0,151,151,151,151,151,151,151,  0,167,167,
  167,167,167,167,167,  0,183,183,183,183,183,183,183,  0,199,199,
  199,199,199,199,199,  0,215,215,215,215,215,215,215,  0,231,231,
  231,231,231,231,231,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  7,  7,  7,  7,
    7,  7,  7,  0, 23, 23, 23, 23, 23, 23, 23,  0, 39, 39, 39, 39,
   39, 39, 39,  0, 55, 55, 55, 55, 55, 55, 55,  0, 71, 71, 71, 71,
   71, 71, 71,  0, 87, 87, 87, 87, 87, 87, 87,  0,103,103,103,103,
  103,103,103,  0,119,119,119,119,119,119,119,  0,135,135,135,135,
  135,135,135,  0,151,151,151,151,151,151,151,  0,167,167,167,167,
  167,167,167,  0,183,183,183,183,183,183,183,  0,199,199,199,199,
  199,199,199,  0,215,215,215,215,215,215,215,  0,231,231,231,231,
  231,231,231,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  7,  7,  7,  7,  7,  7,
    7,  0, 23, 23, 23, 23, 23, 23, 23,  0, 39, 39, 39, 39, 39, 39,
   39,  0, 55, 55, 55, 55, 55, 55, 55,  0, 71, 71, 71, 71, 71, 71,
   71,  0, 87, 87, 87, 87, 87, 87, 87,  0,103,103,103,103,103,103,
  103,  0,119,119,119,119,119,119,119,  0,135,135,135,135,135,135,
  135,  0,151,151,151,151,151,151,151,  0,167,167,167,167,167,167,
  167,  0,183,183,183,183,183,183,183,  0,199,199,199,199,199,199,
  199,  0,215,215,215,215,215,215,215,  0,231,231,231,231,231,231,
  231,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  7,  7,  7,  7,  7,  7,  7,  0,
   23, 23, 23, 23, 23, 23, 23,  0, 39, 39, 39, 39, 39, 39, 39,  0,
   55, 55, 55, 55, 55, 55, 55,  0, 71, 71, 71, 71, 71, 71, 71,  0,
   87, 87, 87, 87, 87, 87, 87,  0,103,103,103,103,103,103,103,  0,
  119,119,119,119,119,119,119,  0,135,135,135,135,135,135,135,  0,
  151,151,151,151,151,151,151,  0,167,167,167,167,167,167,167,  0,
  183,183,183,183,183,183,183,  0,199,199,199,199,199,199,199,  0,
  215,215,215,215,215,215,215,  0,231,231,231,231,231,231,231,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  7,  7,  7,  7,  7,  7,  7,  0, 23, 23,
   23, 23, 23, 23, 23,  0, 39, 39, 39, 39, 39, 39, 39,  0, 55, 55,
   55, 55, 55, 55, 55,  0, 71, 71, 71, 71, 71, 71, 71,  0, 87, 87,
   87, 87, 87, 87, 87,  0,103,103,103,103,103,103,103,  0,119,119,
  119,119,119,119,119,  0,135,135,135,135,135,135,135,  0,151,151,
  151,151,151,151,151,  0,167,167,167,167,167,167,167,  0,183,183,
  183,183,183,183,183,  0,199,199,199,199,199,199,199,  0,215,215,
  215,215,215,215,215,  0,231,231,231,231,231,231,231,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  8,  8,  8,  8,  8,  8,  8,  0, 24, 24, 24, 24, 24, 24,
   24,  0, 40, 40, 40, 40, 40, 40, 40,  0, 56, 56, 56, 56, 56, 56,
   56,  0, 72, 72, 72, 72, 72, 72, 72,  0, 88, 88, 88, 88, 88, 88,
   88,  0,104,104,104,104,104,104,104,  0,120,120,120,120,120,120,
  120,  0,136,136,136,136,136,136,136,  0,152,152,152,152,152,152,
  152,  0,255,255,255,255,255,255,255,  0,184,184,184,184,184,184,
  184,  0,200,200,200,200,200,200,200,  0,216,216,216,216,216,216,
  216,  0,232,232,232,232,232,232,232,  0,248,248,248,248,248,248,
  248,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    8,  8,  8,  8,  8,  8,  8,  0, 24, 24, 24, 24, 24, 24, 24,  0,
   40, 40, 40, 40, 40, 40, 40,  0, 56, 56, 56, 56, 56, 56, 56,  0,
   72, 72, 72, 72, 72, 72, 72,  0, 88, 88, 88, 88, 88, 88, 88,  0,
  104,104,104,104,104,104,104,  0,120,120,120,120,120,120,120,  0,
  136,136,136,136,136,136,136,  0,152,152,152,152,152,152,152,  0,
  255,255,255,255,255,255,255,  0,184,184,184,184,184,184,184,  0,
  200,200,200,200,200,200,200,  0,216,216,216,216,216,216,216,  0,
  232,232,232,232,232,232,232,  0,248,248,248,248,248,248,248,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  8,  8,
    8,  8,  8,  8,  8,  0, 24, 24, 24, 24, 24, 24, 24,  0, 40, 40,
   40, 40, 40, 40, 40,  0, 56, 56, 56, 56, 56, 56, 56,  0, 72, 72,
   72, 72, 72, 72, 72,  0, 88, 88, 88, 88, 88, 88, 88,  0,104,104,
  104,104,104,104,104,  0,120,120,120,120,120,120,120,  0,136,136,
  136,136,136,136,136,  0,152,152,152,152,152,152,152,  0,255,255,
  255,255,255,255,255,  0,184,184,184,184,184,184,184,  0,200,200,
  200,200,200,200,200,  0,216,216,216,216,216,216,216,  0,232,232,
  232,232,232,232,232,  0,248,248,248,248,248,248,248,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  8,  8,  8,  8,
    8,  8,  8,  0, 24, 24, 24, 24, 24, 24, 24,  0, 40, 40, 40, 40,
   40, 40, 40,  0, 56, 56, 56, 56, 56, 56, 56,  0, 72, 72, 72, 72,
   72, 72, 72,  0, 88, 88, 88, 88, 88, 88, 88,  0,104,104,104,104,
  104,104,104,  0,120,120,120,120,120,120,120,  0,136,136,136,136,
  136,136,136,  0,152,152,152,152,152,152,152,  0,255,255,255,255,
  255,255,255,  0,184,184,184,184,184,184,184,  0,200,200,200,200,
  200,200,200,  0,216,216,216,216,216,216,216,  0,232,232,232,232,
  232,232,232,  0,248,248,248,248,248,248,248,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  8,  8,  8,  8,  8,  8,
    8,  0, 24, 24, 24, 24, 24, 24, 24,  0, 40, 40, 40, 40, 40, 40,
   40,  0, 56, 56, 56, 56, 56, 56, 56,  0, 72, 72, 72, 72, 72, 72,
   72,  0, 88, 88, 88, 88, 88, 88, 88,  0,104,104,104,104,104,104,
  104,  0,120,120,120,120,120,120,120,  0,136,136,136,136,136,136,
  136,  0,152,152,152,152,152,152,152,  0,255,255,255,255,255,255,
  255,  0,184,184,184,184,184,184,184,  0,200,200,200,200,200,200,
  200,  0,216,216,216,216,216,216,216,  0,232,232,232,232,232,232,
  232,  0,248,248,248,248,248,248,248,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  8,  8,  8,  8,  8,  8,  8,  0,
   24, 24, 24, 24, 24, 24, 24,  0, 40, 40, 40, 40, 40, 40, 40,  0,
   56, 56, 56, 56, 56, 56, 56,  0, 72, 72, 72, 72, 72, 72, 72,  0,
   88, 88, 88, 88, 88, 88, 88,  0,104,104,104,104,104,104,104,  0,
  120,120,120,120,120,120,120,  0,136,136,136,136,136,136,136,  0,
  152,152,152,152,152,152,152,  0,255,255,255,255,255,255,255,  0,
  184,184,184,184,184,184,184,  0,200,200,200,200,200,200,200,  0,
  216,216,216,216,216,216,216,  0,232,232,232,232,232,232,232,  0,
  248,248,248,248,248,248,248,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  8,  8,  8,  8,  8,  8,  8,  0, 24, 24,
   24, 24, 24, 24, 24,  0, 40, 40, 40, 40, 40, 40, 40,  0, 56, 56,
   56, 56, 56, 56, 56,  0, 72, 72, 72, 72, 72, 72, 72,  0, 88, 88,
   88, 88, 88, 88, 88,  0,104,104,104,104,104,104,104,  0,120,120,
  120,120,120,120,120,  0,136,136,136,136,136,136,136,  0,152,152,
  152,152,152,152,152,  0,255,255,255,255,255,255,255,  0,184,184,
  184,184,184,184,184,  0,200,200,200,200,200,200,200,  0,216,216,
  216,216,216,216,216,  0,232,232,232,232,232,232,232,  0,248,248,
  248,248,248,248,248,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  9,  9,  9,  9,  9,  9,  9,  0, 25, 25, 25, 25, 25, 25,
   25,  0, 41, 41, 41, 41, 41, 41, 41,  0, 57, 57, 57, 57, 57, 57,
   57,  0, 73, 73, 73, 73, 73, 73, 73,  0, 89, 89, 89, 89, 89, 89,
   89,  0,105,105,105,105,105,105,105,  0,121,121,121,121,121,121,
  121,  0,137,137,137,137,137,137,137,  0,153,153,153,153,153,153,
  153,  0,169,169,169,169,169,169,169,  0,185,185,185,185,185,185,
  185,  0,201,201,201,201,201,201,201,  0,217,217,217,217,217,217,
  217,  0,233,233,233,233,233,233,233,  0,249,249,249,249,249,249,
  249,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    9,  9,  9,  9,  9,  9,  9,  0, 25, 25, 25, 25, 25, 25, 25,  0,
   41, 41, 41, 41, 41, 41, 41,  0, 57, 57, 57, 57, 57, 57, 57,  0,
   73, 73, 73, 73, 73, 73, 73,  0, 89, 89, 89, 89, 89, 89, 89,  0,
  105,105,105,105,105,105,105,  0,121,121,121,121,121,121,121,  0,
  137,137,137,137,137,137,137,  0,153,153,153,153,153,153,153,  0,
  169,169,169,169,169,169,169,  0,185,185,185,185,185,185,185,  0,
  201,201,201,201,201,201,201,  0,217,217,217,217,217,217,217,  0,
  233,233,233,233,233,233,233,  0,249,249,249,249,249,249,249,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  9,  9,
    9,  9,  9,  9,  9,  0, 25, 25, 25, 25, 25, 25, 25,  0, 41, 41,
   41, 41, 41, 41, 41,  0, 57, 57, 57, 57, 57, 57, 57,  0, 73, 73,
   73, 73, 73, 73, 73,  0, 89, 89, 89, 89, 89, 89, 89,  0,105,105,
  105,105,105,105,105,  0,121,121,121,121,121,121,121,  0,137,137,
  137,137,137,137,137,  0,153,153,153,153,153,153,153,  0,169,169,
  169,169,169,169,169,  0,185,185,185,185,185,185,185,  0,201,201,
  201,201,201,201,201,  0,217,217,217,217,217,217,217,  0,233,233,
  233,233,233,233,233,  0,249,249,249,249,249,249,249,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  9,  9,  9,  9,
    9,  9,  9,  0, 25, 25, 25, 25, 25, 25, 25,  0, 41, 41, 41, 41,
   41, 41, 41,  0, 57, 57, 57, 57, 57, 57, 57,  0, 73, 73, 73, 73,
   73, 73, 73,  0, 89, 89, 89, 89, 89, 89, 89,  0,105,105,105,105,
  105,105,105,  0,121,121,121,121,121,121,121,  0,137,137,137,137,
  137,137,137,  0,153,153,153,153,153,153,153,  0,169,169,169,169,
  169,169,169,  0,185,185,185,185,185,185,185,  0,201,201,201,201,
  201,201,201,  0,217,217,217,217,217,217,217,  0,233,233,233,233,
  233,233,233,  0,249,249,249,249,249,249,249,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  9,  9,  9,  9,  9,  9,
    9,  0, 25, 25, 25, 25, 25, 25, 25,  0, 41, 41, 41, 41, 41, 41,
   41,  0, 57, 57, 57, 57, 57, 57, 57,  0, 73, 73, 73, 73, 73, 73,
   73,  0, 89, 89, 89, 89, 89, 89, 89,  0,105,105,105,105,105,105,
  105,  0,121,121,121,121,121,121,121,  0,137,137,137,137,137,137,
  137,  0,153,153,153,153,153,153,153,  0,169,169,169,169,169,169,
  169,  0,185,185,185,185,185,185,185,  0,201,201,201,201,201,201,
  201,  0,217,217,217,217,217,217,217,  0,233,233,233,233,233,233,
  233,  0,249,249,249,249,249,249,249,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  9,  9,  9,  9,  9,  9,  9,  0,
   25, 25, 25, 25, 25, 25, 25,  0, 41, 41, 41, 41, 41, 41, 41,  0,
   57, 57, 57, 57, 57, 57, 57,  0, 73, 73, 73, 73, 73, 73, 73,  0,
   89, 89, 89, 89, 89, 89, 89,  0,105,105,105,105,105,105,105,  0,
  121,121,121,121,121,121,121,  0,137,137,137,137,137,137,137,  0,
  153,153,153,153,153,153,153,  0,169,169,169,169,169,169,169,  0,
  185,185,185,185,185,185,185,  0,201,201,201,201,201,201,201,  0,
  217,217,217,217,217,217,217,  0,233,233,233,233,233,233,233,  0,
  249,249,249,249,249,249,249,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  9,  9,  9,  9,  9,  9,  9,  0, 25, 25,
   25, 25, 25, 25, 25,  0, 41, 41, 41, 41, 41, 41, 41,  0, 57, 57,
   57, 57, 57, 57, 57,  0, 73, 73, 73, 73, 73, 73, 73,  0, 89, 89,
   89, 89, 89, 89, 89,  0,105,105,105,105,105,105,105,  0,121,121,
  121,121,121,121,121,  0,137,137,137,137,137,137,137,  0,153,153,
  153,153,153,153,153,  0,169,169,169,169,169,169,169,  0,185,185,
  185,185,185,185,185,  0,201,201,201,201,201,201,201,  0,217,217,
  217,217,217,217,217,  0,233,233,233,233,233,233,233,  0,249,249,
  249,249,249,249,249,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0, 10, 10, 10, 10, 10, 10, 10,  0, 26, 26, 26, 26, 26, 26,
   26,  0, 42, 42, 42, 42, 42, 42, 42,  0, 58, 58, 58, 58, 58, 58,
   58,  0, 74, 74, 74, 74, 74, 74, 74,  0, 90, 90, 90, 90, 90, 90,
   90,  0,106,106,106,106,106,106,106,  0,122,122,122,122,122,122,
  122,  0,138,138,138,138,138,138,138,  0,154,154,154,154,154,154,
  154,  0,170,170,170,170,170,170,170,  0,186,186,186,186,186,186,
  186,  0,202,202,202,202,202,202,202,  0,218,218,218,218,218,218,
  218,  0,234,234,234,234,234,234,234,  0,250,250,250,250,250,250,
  250,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
   10, 10, 10, 10, 10, 10, 10,  0, 26, 26, 26, 26, 26, 26, 26,  0,
   42, 42, 42, 42, 42, 42, 42,  0, 58, 58, 58, 58, 58, 58, 58,  0,
   74, 74, 74, 74, 74, 74, 74,  0, 90, 90, 90, 90, 90, 90, 90,  0,
  106,106,106,106,106,106,106,  0,122,122,122,122,122,122,122,  0,
  138,138,138,138,138,138,138,  0,154,154,154,154,154,154,154,  0,
  170,170,170,170,170,170,170,  0,186,186,186,186,186,186,186,  0,
  202,202,202,202,202,202,202,  0,218,218,218,218,218,218,218,  0,
  234,234,234,234,234,234,234,  0,250,250,250,250,250,250,250,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 10, 10,
   10, 10, 10, 10, 10,  0, 26, 26, 26, 26, 26, 26, 26,  0, 42, 42,
   42, 42, 42, 42, 42,  0, 58, 58, 58, 58, 58, 58, 58,  0, 74, 74,
   74, 74, 74, 74, 74,  0, 90, 90, 90, 90, 90, 90, 90,  0,106,106,
  106,106,106,106,106,  0,122,122,122,122,122,122,122,  0,138,138,
  138,138,138,138,138,  0,154,154,154,154,154,154,154,  0,170,170,
  170,170,170,170,170,  0,186,186,186,186,186,186,186,  0,202,202,
  202,202,202,202,202,  0,218,218,218,218,218,218,218,  0,234,234,
  234,234,234,234,234,  0,250,250,250,250,250,250,250,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 10, 10, 10, 10,
   10, 10, 10,  0, 26, 26, 26, 26, 26, 26, 26,  0, 42, 42, 42, 42,
   42, 42, 42,  0, 58, 58, 58, 58, 58, 58, 58,  0, 74, 74, 74, 74,
   74, 74, 74,  0, 90, 90, 90, 90, 90, 90, 90,  0,106,106,106,106,
  106,106,106,  0,122,122,122,122,122,122,122,  0,138,138,138,138,
  138,138,138,  0,154,154,154,154,154,154,154,  0,170,170,170,170,
  170,170,170,  0,186,186,186,186,186,186,186,  0,202,202,202,202,
  202,202,202,  0,218,218,218,218,218,218,218,  0,234,234,234,234,
  234,234,234,  0,250,250,250,250,250,250,250,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0, 10, 10, 10, 10, 10, 10,
   10,  0, 26, 26, 26, 26, 26, 26, 26,  0, 42, 42, 42, 42, 42, 42,
   42,  0, 58, 58, 58, 58, 58, 58, 58,  0, 74, 74, 74, 74, 74, 74,
   74,  0, 90, 90, 90, 90, 90, 90, 90,  0,106,106,106,106,106,106,
  106,  0,122,122,122,122,122,122,122,  0,138,138,138,138,138,138,
  138,  0,154,154,154,154,154,154,154,  0,170,170,170,170,170,170,
  170,  0,186,186,186,186,186,186,186,  0,202,202,202,202,202,202,
  202,  0,218,218,218,218,218,218,218,  0,234,234,234,234,234,234,
  234,  0,250,250,250,250,250,250,250,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0, 10, 10, 10, 10, 10, 10, 10,  0,
   26, 26, 26, 26, 26, 26, 26,  0, 42, 42, 42, 42, 42, 42, 42,  0,
   58, 58, 58, 58, 58, 58, 58,  0, 74, 74, 74, 74, 74, 74, 74,  0,
   90, 90, 90, 90, 90, 90, 90,  0,106,106,106,106,106,106,106,  0,
  122,122,122,122,122,122,122,  0,138,138,138,138,138,138,138,  0,
  154,154,154,154,154,154,154,  0,170,170,170,170,170,170,170,  0,
  186,186,186,186,186,186,186,  0,202,202,202,202,202,202,202,  0,
  218,218,218,218,218,218,218,  0,234,234,234,234,234,234,234,  0,
  250,250,250,250,250,250,250,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0, 10, 10, 10, 10, 10, 10, 10,  0, 26, 26,
   26, 26, 26, 26, 26,  0, 42, 42, 42, 42, 42, 42, 42,  0, 58, 58,
   58, 58, 58, 58, 58,  0, 74, 74, 74, 74, 74, 74, 74,  0, 90, 90,
   90, 90, 90, 90, 90,  0,106,106,106,106,106,106,106,  0,122,122,
  122,122,122,122,122,  0,138,138,138,138,138,138,138,  0,154,154,
  154,154,154,154,154,  0,170,170,170,170,170,170,170,  0,186,186,
  186,186,186,186,186,  0,202,202,202,202,202,202,202,  0,218,218,
  218,218,218,218,218,  0,234,234,234,234,234,234,234,  0,250,250,
  250,250,250,250,250,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0, 11, 11, 11, 11, 11, 11, 11,  0, 27, 27, 27, 27, 27, 27,
   27,  0, 43, 43, 43, 43, 43, 43, 43,  0, 59, 59, 59, 59, 59, 59,
   59,  0, 75, 75, 75, 75, 75, 75, 75,  0, 91, 91, 91, 91, 91, 91,
   91,  0,107,107,107,107,107,107,107,  0,123,123,123,123,123,123,
  123,  0,139,139,139,139,139,139,139,  0,155,155,155,155,155,155,
  155,  0,171,171,171,171,171,171,171,  0,187,187,187,187,187,187,
  187,  0,203,203,203,203,203,203,203,  0,219,219,219,219,219,219,
  219,  0,235,235,235,235,235,235,235,  0,251,251,251,251,251,251,
  251,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
   11, 11, 11, 11, 11, 11, 11,  0, 27, 27, 27, 27, 27, 27, 27,  0,
   43, 43, 43, 43, 43, 43, 43,  0, 59, 59, 59, 59, 59, 59, 59,  0,
   75, 75, 75, 75, 75, 75, 75,  0, 91, 91, 91, 91, 91, 91, 91,  0,
  107,107,107,107,107,107,107,  0,123,123,123,123,123,123,123,  0,
  139,139,139,139,139,139,139,  0,155,155,155,155,155,155,155,  0,
  171,171,171,171,171,171,171,  0,187,187,187,187,187,187,187,  0,
  203,203,203,203,203,203,203,  0,219,219,219,219,219,219,219,  0,
  235,235,235,235,235,235,235,  0,251,251,251,251,251,251,251,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 11, 11,
   11, 11, 11, 11, 11,  0, 27, 27, 27, 27, 27, 27, 27,  0, 43, 43,
   43, 43, 43, 43, 43,  0, 59, 59, 59, 59, 59, 59, 59,  0, 75, 75,
   75, 75, 75, 75, 75,  0, 91, 91, 91, 91, 91, 91, 91,  0,107,107,
  107,107,107,107,107,  0,123,123,123,123,123,123,123,  0,139,139,
  139,139,139,139,139,  0,155,155,155,155,155,155,155,  0,171,171,
  171,171,171,171,171,  0,187,187,187,187,187,187,187,  0,203,203,
  203,203,203,203,203,  0,219,219,219,219,219,219,219,  0,235,235,
  235,235,235,235,235,  0,251,251,251,251,251,251,251,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 11, 11, 11, 11,
   11, 11, 11,  0, 27, 27, 27, 27, 27, 27, 27,  0, 43, 43, 43, 43,
   43, 43, 43,  0, 59, 59, 59, 59, 59, 59, 59,  0, 75, 75, 75, 75,
   75, 75, 75,  0, 91, 91, 91, 91, 91, 91, 91,  0,107,107,107,107,
  107,107,107,  0,123,123,123,123,123,123,123,  0,139,139,139,139,
  139,139,139,  0,155,155,155,155,155,155,155,  0,171,171,171,171,
  171,171,171,  0,187,187,187,187,187,187,187,  0,203,203,203,203,
  203,203,203,  0,219,219,219,219,219,219,219,  0,235,235,235,235,
  235,235,235,  0,251,251,251,251,251,251,251,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0, 11, 11, 11, 11, 11, 11,
   11,  0, 27, 27, 27, 27, 27, 27, 27,  0, 43, 43, 43, 43, 43, 43,
   43,  0, 59, 59, 59, 59, 59, 59, 59,  0, 75, 75, 75, 75, 75, 75,
   75,  0, 91, 91, 91, 91, 91, 91, 91,  0,107,107,107,107,107,107,
  107,  0,123,123,123,123,123,123,123,  0,139,139,139,139,139,139,
  139,  0,155,155,155,155,155,155,155,  0,171,171,171,171,171,171,
  171,  0,187,187,187,187,187,187,187,  0,203,203,203,203,203,203,
  203,  0,219,219,219,219,219,219,219,  0,235,235,235,235,235,235,
  235,  0,251,251,251,251,251,251,251,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0, 11, 11, 11, 11, 11, 11, 11,  0,
   27, 27, 27, 27, 27, 27, 27,  0, 43, 43, 43, 43, 43, 43, 43,  0,
   59, 59, 59, 59, 59, 59, 59,  0, 75, 75, 75, 75, 75, 75, 75,  0,
   91, 91, 91, 91, 91, 91, 91,  0,107,107,107,107,107,107,107,  0,
  123,123,123,123,123,123,123,  0,139,139,139,139,139,139,139,  0,
  155,155,155,155,155,155,155,  0,171,171,171,171,171,171,171,  0,
  187,187,187,187,187,187,187,  0,203,203,203,203,203,203,203,  0,
  219,219,219,219,219,219,219,  0,235,235,235,235,235,235,235,  0,
  251,251,251,251,251,251,251,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0, 11, 11, 11, 11, 11, 11, 11,  0, 27, 27,
   27, 27, 27, 27, 27,  0, 43, 43, 43, 43, 43, 43, 43,  0, 59, 59,
   59, 59, 59, 59, 59,  0, 75, 75, 75, 75, 75, 75, 75,  0, 91, 91,

   91, 91, 91, 91, 91,  0,107,107,107,107,107,107,107,  0,123,123,
  123,123,123,123,123,  0,139,139,139,139,139,139,139,  0,155,155,
  155,155,155,155,155,  0,171,171,171,171,171,171,171,  0,187,187,
  187,187,187,187,187,  0,203,203,203,203,203,203,203,  0,219,219,
  219,219,219,219,219,  0,235,235,235,235,235,235,235,  0,251,251,
  251,251,251,251,251,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0, 12, 12, 12, 12, 12, 12, 12,  0, 28, 28, 28, 28, 28, 28,
   28,  0, 44, 44, 44, 44, 44, 44, 44,  0, 60, 60, 60, 60, 60, 60,
   60,  0, 76, 76, 76, 76, 76, 76, 76,  0, 92, 92, 92, 92, 92, 92,
   92,  0,108,108,108,108,108,108,108,  0,124,124,124,124,124,124,
  124,  0,140,140,140,140,140,140,140,  0,156,156,156,156,156,156,
  156,  0,172,172,172,172,172,172,172,  0,188,188,188,188,188,188,
  188,  0,204,204,204,204,204,204,204,  0,220,220,220,220,220,220,
  220,  0,236,236,236,236,236,236,236,  0,252,252,252,252,252,252,
  252,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
   12, 12, 12, 12, 12, 12, 12,  0, 28, 28, 28, 28, 28, 28, 28,  0,
   44, 44, 44, 44, 44, 44, 44,  0, 60, 60, 60, 60, 60, 60, 60,  0,
   76, 76, 76, 76, 76, 76, 76,  0, 92, 92, 92, 92, 92, 92, 92,  0,
  108,108,108,108,108,108,108,  0,124,124,124,124,124,124,124,  0,
  140,140,140,140,140,140,140,  0,156,156,156,156,156,156,156,  0,
  172,172,172,172,172,172,172,  0,188,188,188,188,188,188,188,  0,
  204,204,204,204,204,204,204,  0,220,220,220,220,220,220,220,  0,
  236,236,236,236,236,236,236,  0,252,252,252,252,252,252,252,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 12, 12,
   12, 12, 12, 12, 12,  0, 28, 28, 28, 28, 28, 28, 28,  0, 44, 44,
   44, 44, 44, 44, 44,  0, 60, 60, 60, 60, 60, 60, 60,  0, 76, 76,
   76, 76, 76, 76, 76,  0, 92, 92, 92, 92, 92, 92, 92,  0,108,108,
  108,108,108,108,108,  0,124,124,124,124,124,124,124,  0,140,140,
  140,140,140,140,140,  0,156,156,156,156,156,156,156,  0,172,172,
  172,172,172,172,172,  0,188,188,188,188,188,188,188,  0,204,204,
  204,204,204,204,204,  0,220,220,220,220,220,220,220,  0,236,236,
  236,236,236,236,236,  0,252,252,252,252,252,252,252,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 12, 12, 12, 12,
   12, 12, 12,  0, 28, 28, 28, 28, 28, 28, 28,  0, 44, 44, 44, 44,
   44, 44, 44,  0, 60, 60, 60, 60, 60, 60, 60,  0, 76, 76, 76, 76,
   76, 76, 76,  0, 92, 92, 92, 92, 92, 92, 92,  0,108,108,108,108,
  108,108,108,  0,124,124,124,124,124,124,124,  0,140,140,140,140,
  140,140,140,  0,156,156,156,156,156,156,156,  0,172,172,172,172,
  172,172,172,  0,188,188,188,188,188,188,188,  0,204,204,204,204,
  204,204,204,  0,220,220,220,220,220,220,220,  0,236,236,236,236,
  236,236,236,  0,252,252,252,252,252,252,252,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0, 12, 12, 12, 12, 12, 12,
   12,  0, 28, 28, 28, 28, 28, 28, 28,  0, 44, 44, 44, 44, 44, 44,
   44,  0, 60, 60, 60, 60, 60, 60, 60,  0, 76, 76, 76, 76, 76, 76,
   76,  0, 92, 92, 92, 92, 92, 92, 92,  0,108,108,108,108,108,108,
  108,  0,124,124,124,124,124,124,124,  0,140,140,140,140,140,140,
  140,  0,156,156,156,156,156,156,156,  0,172,172,172,172,172,172,
  172,  0,188,188,188,188,188,188,188,  0,204,204,204,204,204,204,
  204,  0,220,220,220,220,220,220,220,  0,236,236,236,236,236,236,
  236,  0,252,252,252,252,252,252,252,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0, 12, 12, 12, 12, 12, 12, 12,  0,
   28, 28, 28, 28, 28, 28, 28,  0, 44, 44, 44, 44, 44, 44, 44,  0,
   60, 60, 60, 60, 60, 60, 60,  0, 76, 76, 76, 76, 76, 76, 76,  0,
   92, 92, 92, 92, 92, 92, 92,  0,108,108,108,108,108,108,108,  0,
  124,124,124,124,124,124,124,  0,140,140,140,140,140,140,140,  0,
  156,156,156,156,156,156,156,  0,172,172,172,172,172,172,172,  0,
  188,188,188,188,188,188,188,  0,204,204,204,204,204,204,204,  0,
  220,220,220,220,220,220,220,  0,236,236,236,236,236,236,236,  0,
  252,252,252,252,252,252,252,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0, 12, 12, 12, 12, 12, 12, 12,  0, 28, 28,
   28, 28, 28, 28, 28,  0, 44, 44, 44, 44, 44, 44, 44,  0, 60, 60,
   60, 60, 60, 60, 60,  0, 76, 76, 76, 76, 76, 76, 76,  0, 92, 92,
   92, 92, 92, 92, 92,  0,108,108,108,108,108,108,108,  0,124,124,
  124,124,124,124,124,  0,140,140,140,140,140,140,140,  0,156,156,
  156,156,156,156,156,  0,172,172,172,172,172,172,172,  0,188,188,
  188,188,188,188,188,  0,204,204,204,204,204,204,204,  0,220,220,
  220,220,220,220,220,  0,236,236,236,236,236,236,236,  0,252,252,
  252,252,252,252,252,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0, 13, 13, 13, 13, 13, 13, 13,  0, 29, 29, 29, 29, 29, 29,
   29,  0, 45, 45, 45, 45, 45, 45, 45,  0, 61, 61, 61, 61, 61, 61,
   61,  0, 77, 77, 77, 77, 77, 77, 77,  0, 93, 93, 93, 93, 93, 93,
   93,  0,109,109,109,109,109,109,109,  0,125,125,125,125,125,125,
  125,  0,141,141,141,141,141,141,141,  0,157,157,157,157,157,157,
  157,  0,173,173,173,173,173,173,173,  0,189,189,189,189,189,189,
  189,  0,205,205,205,205,205,205,205,  0,221,221,221,221,221,221,
  221,  0,237,237,237,237,237,237,237,  0,253,253,253,253,253,253,
  253,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
   13, 13, 13, 13, 13, 13, 13,  0, 29, 29, 29, 29, 29, 29, 29,  0,
   45, 45, 45, 45, 45, 45, 45,  0, 61, 61, 61, 61, 61, 61, 61,  0,
   77, 77, 77, 77, 77, 77, 77,  0, 93, 93, 93, 93, 93, 93, 93,  0,
  109,109,109,109,109,109,109,  0,125,125,125,125,125,125,125,  0,
  141,141,141,141,141,141,141,  0,157,157,157,157,157,157,157,  0,
  173,173,173,173,173,173,173,  0,189,189,189,189,189,189,189,  0,
  205,205,205,205,205,205,205,  0,221,221,221,221,221,221,221,  0,
  237,237,237,237,237,237,237,  0,253,253,253,253,253,253,253,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 13, 13,
   13, 13, 13, 13, 13,  0, 29, 29, 29, 29, 29, 29, 29,  0, 45, 45,
   45, 45, 45, 45, 45,  0, 61, 61, 61, 61, 61, 61, 61,  0, 77, 77,
   77, 77, 77, 77, 77,  0, 93, 93, 93, 93, 93, 93, 93,  0,109,109,
  109,109,109,109,109,  0,125,125,125,125,125,125,125,  0,141,141,
  141,141,141,141,141,  0,157,157,157,157,157,157,157,  0,173,173,
  173,173,173,173,173,  0,189,189,189,189,189,189,189,  0,205,205,
  205,205,205,205,205,  0,221,221,221,221,221,221,221,  0,237,237,
  237,237,237,237,237,  0,253,253,253,253,253,253,253,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 13, 13, 13, 13,
   13, 13, 13,  0, 29, 29, 29, 29, 29, 29, 29,  0, 45, 45, 45, 45,
   45, 45, 45,  0, 61, 61, 61, 61, 61, 61, 61,  0, 77, 77, 77, 77,
   77, 77, 77,  0, 93, 93, 93, 93, 93, 93, 93,  0,109,109,109,109,
  109,109,109,  0,125,125,125,125,125,125,125,  0,141,141,141,141,
  141,141,141,  0,157,157,157,157,157,157,157,  0,173,173,173,173,
  173,173,173,  0,189,189,189,189,189,189,189,  0,205,205,205,205,
  205,205,205,  0,221,221,221,221,221,221,221,  0,237,237,237,237,
  237,237,237,  0,253,253,253,253,253,253,253,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0, 13, 13, 13, 13, 13, 13,
   13,  0, 29, 29, 29, 29, 29, 29, 29,  0, 45, 45, 45, 45, 45, 45,
   45,  0, 61, 61, 61, 61, 61, 61, 61,  0, 77, 77, 77, 77, 77, 77,
   77,  0, 93, 93, 93, 93, 93, 93, 93,  0,109,109,109,109,109,109,
  109,  0,125,125,125,125,125,125,125,  0,141,141,141,141,141,141,
  141,  0,157,157,157,157,157,157,157,  0,173,173,173,173,173,173,
  173,  0,189,189,189,189,189,189,189,  0,205,205,205,205,205,205,
  205,  0,221,221,221,221,221,221,221,  0,237,237,237,237,237,237,
  237,  0,253,253,253,253,253,253,253,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0, 13, 13, 13, 13, 13, 13, 13,  0,
   29, 29, 29, 29, 29, 29, 29,  0, 45, 45, 45, 45, 45, 45, 45,  0,
   61, 61, 61, 61, 61, 61, 61,  0, 77, 77, 77, 77, 77, 77, 77,  0,
   93, 93, 93, 93, 93, 93, 93,  0,109,109,109,109,109,109,109,  0,
  125,125,125,125,125,125,125,  0,141,141,141,141,141,141,141,  0,
  157,157,157,157,157,157,157,  0,173,173,173,173,173,173,173,  0,
  189,189,189,189,189,189,189,  0,205,205,205,205,205,205,205,  0,
  221,221,221,221,221,221,221,  0,237,237,237,237,237,237,237,  0,
  253,253,253,253,253,253,253,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0, 13, 13, 13, 13, 13, 13, 13,  0, 29, 29,
   29, 29, 29, 29, 29,  0, 45, 45, 45, 45, 45, 45, 45,  0, 61, 61,
   61, 61, 61, 61, 61,  0, 77, 77, 77, 77, 77, 77, 77,  0, 93, 93,
   93, 93, 93, 93, 93,  0,109,109,109,109,109,109,109,  0,125,125,
  125,125,125,125,125,  0,141,141,141,141,141,141,141,  0,157,157,
  157,157,157,157,157,  0,173,173,173,173,173,173,173,  0,189,189,
  189,189,189,189,189,  0,205,205,205,205,205,205,205,  0,221,221,
  221,221,221,221,221,  0,237,237,237,237,237,237,237,  0,253,253,
  253,253,253,253,253,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0, 14, 14, 14, 14, 14, 14, 14,  0, 30, 30, 30, 30, 30, 30,
   30,  0, 46, 46, 46, 46, 46, 46, 46,  0, 62, 62, 62, 62, 62, 62,
   62,  0, 78, 78, 78, 78, 78, 78, 78,  0, 94, 94, 94, 94, 94, 94,
   94,  0,110,110,110,110,110,110,110,  0,126,126,126,126,126,126,
  126,  0,142,142,142,142,142,142,142,  0,158,158,158,158,158,158,
  158,  0,174,174,174,174,174,174,174,  0, 45, 45, 45, 45, 45, 45,
   45,  0,206,206,206,206,206,206,206,  0,222,222,222,222,222,222,
  222,  0,238,238,238,238,238,238,238,  0,254,254,254,254,254,254,
  254,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
   14, 14, 14, 14, 14, 14, 14,  0, 30, 30, 30, 30, 30, 30, 30,  0,
   46, 46, 46, 46, 46, 46, 46,  0, 62, 62, 62, 62, 62, 62, 62,  0,
   78, 78, 78, 78, 78, 78, 78,  0, 94, 94, 94, 94, 94, 94, 94,  0,
  110,110,110,110,110,110,110,  0,126,126,126,126,126,126,126,  0,
  142,142,142,142,142,142,142,  0,158,158,158,158,158,158,158,  0,
  174,174,174,174,174,174,174,  0, 45, 45, 45, 45, 45, 45, 45,  0,
  206,206,206,206,206,206,206,  0,222,222,222,222,222,222,222,  0,
  238,238,238,238,238,238,238,  0,254,254,254,254,254,254,254,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 14, 14,
   14, 14, 14, 14, 14,  0, 30, 30, 30, 30, 30, 30, 30,  0, 46, 46,
   46, 46, 46, 46, 46,  0, 62, 62, 62, 62, 62, 62, 62,  0, 78, 78,
   78, 78, 78, 78, 78,  0, 94, 94, 94, 94, 94, 94, 94,  0,110,110,
  110,110,110,110,110,  0,126,126,126,126,126,126,126,  0,142,142,
  142,142,142,142,142,  0,158,158,158,158,158,158,158,  0,174,174,
  174,174,174,174,174,  0, 45, 45, 45, 45, 45, 45, 45,  0,206,206,
  206,206,206,206,206,  0,222,222,222,222,222,222,222,  0,238,238,
  238,238,238,238,238,  0,254,254,254,254,254,254,254,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 14, 14, 14, 14,
   14, 14, 14,  0, 30, 30, 30, 30, 30, 30, 30,  0, 46, 46, 46, 46,
   46, 46, 46,  0, 62, 62, 62, 62, 62, 62, 62,  0, 78, 78, 78, 78,
   78, 78, 78,  0, 94, 94, 94, 94, 94, 94, 94,  0,110,110,110,110,
  110,110,110,  0,126,126,126,126,126,126,126,  0,142,142,142,142,
  142,142,142,  0,158,158,158,158,158,158,158,  0,174,174,174,174,
  174,174,174,  0, 45, 45, 45, 45, 45, 45, 45,  0,206,206,206,206,
  206,206,206,  0,222,222,222,222,222,222,222,  0,238,238,238,238,
  238,238,238,  0,254,254,254,254,254,254,254,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0, 14, 14, 14, 14, 14, 14,
   14,  0, 30, 30, 30, 30, 30, 30, 30,  0, 46, 46, 46, 46, 46, 46,
   46,  0, 62, 62, 62, 62, 62, 62, 62,  0, 78, 78, 78, 78, 78, 78,
   78,  0, 94, 94, 94, 94, 94, 94, 94,  0,110,110,110,110,110,110,
  110,  0,126,126,126,126,126,126,126,  0,142,142,142,142,142,142,
  142,  0,158,158,158,158,158,158,158,  0,174,174,174,174,174,174,
  174,  0, 45, 45, 45, 45, 45, 45, 45,  0,206,206,206,206,206,206,
  206,  0,222,222,222,222,222,222,222,  0,238,238,238,238,238,238,
  238,  0,254,254,254,254,254,254,254,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0, 14, 14, 14, 14, 14, 14, 14,  0,
   30, 30, 30, 30, 30, 30, 30,  0, 46, 46, 46, 46, 46, 46, 46,  0,
   62, 62, 62, 62, 62, 62, 62,  0, 78, 78, 78, 78, 78, 78, 78,  0,
   94, 94, 94, 94, 94, 94, 94,  0,110,110,110,110,110,110,110,  0,
  126,126,126,126,126,126,126,  0,142,142,142,142,142,142,142,  0,
  158,158,158,158,158,158,158,  0,174,174,174,174,174,174,174,  0,
   45, 45, 45, 45, 45, 45, 45,  0,206,206,206,206,206,206,206,  0,
  222,222,222,222,222,222,222,  0,238,238,238,238,238,238,238,  0,
  254,254,254,254,254,254,254,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0, 14, 14, 14, 14, 14, 14, 14,  0, 30, 30,
   30, 30, 30, 30, 30,  0, 46, 46, 46, 46, 46, 46, 46,  0, 62, 62,
   62, 62, 62, 62, 62,  0, 78, 78, 78, 78, 78, 78, 78,  0, 94, 94,
   94, 94, 94, 94, 94,  0,110,110,110,110,110,110,110,  0,126,126,
  126,126,126,126,126,  0,142,142,142,142,142,142,142,  0,158,158,
  158,158,158,158,158,  0,174,174,174,174,174,174,174,  0, 45, 45,
   45, 45, 45, 45, 45,  0,206,206,206,206,206,206,206,  0,222,222,
  222,222,222,222,222,  0,238,238,238,238,238,238,238,  0,254,254,
  254,254,254,254,254,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0, 15, 15, 15, 15, 15, 15, 15,  0, 31, 31, 31, 31, 31, 31,
   31,  0, 47, 47, 47, 47, 47, 47, 47,  0, 63, 63, 63, 63, 63, 63,
   63,  0, 79, 79, 79, 79, 79, 79, 79,  0, 95, 95, 95, 95, 95, 95,
   95,  0,111,111,111,111,111,111,111,  0,127,127,127,127,127,127,
  127,  0,143,143,143,143,143,143,143,  0,159,159,159,159,159,159,
  159,  0,175,175,175,175,175,175,175,  0, 47, 47, 47, 47, 47, 47,
   47,  0,207,207,207,207,207,207,207,  0,223,223,223,223,223,223,
  223,  0,239,239,239,239,239,239,239,  0,255,255,255,255,255,255,
  255,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
   15, 15, 15, 15, 15, 15, 15,  0, 31, 31, 31, 31, 31, 31, 31,  0,
   47, 47, 47, 47, 47, 47, 47,  0, 63, 63, 63, 63, 63, 63, 63,  0,
   79, 79, 79, 79, 79, 79, 79,  0, 95, 95, 95, 95, 95, 95, 95,  0,
  111,111,111,111,111,111,111,  0,127,127,127,127,127,127,127,  0,
  143,143,143,143,143,143,143,  0,159,159,159,159,159,159,159,  0,
  175,175,175,175,175,175,175,  0, 47, 47, 47, 47, 47, 47, 47,  0,
  207,207,207,207,207,207,207,  0,223,223,223,223,223,223,223,  0,
  239,239,239,239,239,239,239,  0,255,255,255,255,255,255,255,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 15, 15,
   15, 15, 15, 15, 15,  0, 31, 31, 31, 31, 31, 31, 31,  0, 47, 47,
   47, 47, 47, 47, 47,  0, 63, 63, 63, 63, 63, 63, 63,  0, 79, 79,
   79, 79, 79, 79, 79,  0, 95, 95, 95, 95, 95, 95, 95,  0,111,111,
  111,111,111,111,111,  0,127,127,127,127,127,127,127,  0,143,143,
  143,143,143,143,143,  0,159,159,159,159,159,159,159,  0,175,175,
  175,175,175,175,175,  0, 47, 47, 47, 47, 47, 47, 47,  0,207,207,
  207,207,207,207,207,  0,223,223,223,223,223,223,223,  0,239,239,
  239,239,239,239,239,  0,255,255,255,255,255,255,255,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 15, 15, 15, 15,
   15, 15, 15,  0, 31, 31, 31, 31, 31, 31, 31,  0, 47, 47, 47, 47,
   47, 47, 47,  0, 63, 63, 63, 63, 63, 63, 63,  0, 79, 79, 79, 79,
   79, 79, 79,  0, 95, 95, 95, 95, 95, 95, 95,  0,111,111,111,111,
  111,111,111,  0,127,127,127,127,127,127,127,  0,143,143,143,143,
  143,143,143,  0,159,159,159,159,159,159,159,  0,175,175,175,175,
  175,175,175,  0, 47, 47, 47, 47, 47, 47, 47,  0,207,207,207,207,
  207,207,207,  0,223,223,223,223,223,223,223,  0,239,239,239,239,
  239,239,239,  0,255,255,255,255,255,255,255,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0, 15, 15, 15, 15, 15, 15,
   15,  0, 31, 31, 31, 31, 31, 31, 31,  0, 47, 47, 47, 47, 47, 47,
   47,  0, 63, 63, 63, 63, 63, 63, 63,  0, 79, 79, 79, 79, 79, 79,
   79,  0, 95, 95, 95, 95, 95, 95, 95,  0,111,111,111,111,111,111,
  111,  0,127,127,127,127,127,127,127,  0,143,143,143,143,143,143,
  143,  0,159,159,159,159,159,159,159,  0,175,175,175,175,175,175,
  175,  0, 47, 47, 47, 47, 47, 47, 47,  0,207,207,207,207,207,207,
  207,  0,223,223,223,223,223,223,223,  0,239,239,239,239,239,239,
  239,  0,255,255,255,255,255,255,255,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0, 15, 15, 15, 15, 15, 15, 15,  0,
   31, 31, 31, 31, 31, 31, 31,  0, 47, 47, 47, 47, 47, 47, 47,  0,
   63, 63, 63, 63, 63, 63, 63,  0, 79, 79, 79, 79, 79, 79, 79,  0,
   95, 95, 95, 95, 95, 95, 95,  0,111,111,111,111,111,111,111,  0,
  127,127,127,127,127,127,127,  0,143,143,143,143,143,143,143,  0,
  159,159,159,159,159,159,159,  0,175,175,175,175,175,175,175,  0,
   47, 47, 47, 47, 47, 47, 47,  0,207,207,207,207,207,207,207,  0,
  223,223,223,223,223,223,223,  0,239,239,239,239,239,239,239,  0,
  255,255,255,255,255,255,255,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0, 15, 15, 15, 15, 15, 15, 15,  0, 31, 31,
   31, 31, 31, 31, 31,  0, 47, 47, 47, 47, 47, 47, 47,  0, 63, 63,
   63, 63, 63, 63, 63,  0, 79, 79, 79, 79, 79, 79, 79,  0, 95, 95,
   95, 95, 95, 95, 95,  0,111,111,111,111,111,111,111,  0,127,127,
  127,127,127,127,127,  0,143,143,143,143,143,143,143,  0,159,159,
  159,159,159,159,159,  0,175,175,175,175,175,175,175,  0, 47, 47,
   47, 47, 47, 47, 47,  0,207,207,207,207,207,207,207,  0,223,223,
  223,223,223,223,223,  0,239,239,239,239,239,239,239,  0,255,255,
  255,255,255,255,255,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98, 94, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 98,105,  0,255,  0,137,  0, 91, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98,105,  0,255,  0,137,  0, 98,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
    0,255,
};

static const char m_palno[]=  // Marker to not show this color in automap
{
    7,  0,  7,  0,  0,  0,  0,  0,
   36,  0,  0,  0, 48,  0,  0,  0, 60,  0,  0,  0, 72,  0,  0,  0,
   84,  0,  0,  0, 96,  0,  0,  0,108,  0,  0,  0,  0,  7,  0,  4,
    0,  0,  0,  0,  0,  4,  0,255,  0,  7,  0,  0,  4,  0,  0,  0,
    4,  0,  0,255,  0,  7,  0,  0,  0,  4,  0,  4,  0,  0,  0,255,
    0,  7,  0,  0,  0,  0,  4,  0,  0,  0,  0,255,  0,  7,  0,  0,
    0,  4,  0,  4,  0,  0,  0,255,  0,  7,  0,  0,  4,  0,  0,  0,
    4,  0,  0,255,  0,  7,  0,  4,  0,  0,  0,  0,  0,  4,  0,255,
};

static const char stcfn096[]= // backquote character, never existed
{
    4,  0,  4,  0,  0,  0,  0,  0,
   24,  0,  0,  0, 32,  0,  0,  0, 41,  0,  0,  0, 50,  0,  0,  0,
    0,  3,  0,191,191,191,  0,255,  0,  4,  0,191,179,179,191,  0,
  255,  0,  4,  0,191,181,191,191,  0,255,  0,  3,  0,191,191,191,
    0,255,
};

static const char m_butt1[]=  // Options reset button unlit
{
   15,  0, 15,  0,  0,  0,  0,  0,
   68,  0,  0,  0, 88,  0,  0,  0,108,  0,  0,  0,128,  0,  0,  0,
  148,  0,  0,  0,168,  0,  0,  0,188,  0,  0,  0,208,  0,  0,  0,
  228,  0,  0,  0,248,  0,  0,  0, 12,  1,  0,  0, 32,  1,  0,  0,
   52,  1,  0,  0, 72,  1,  0,  0, 92,  1,  0,  0,  0, 15,  0, 59,
   59, 57, 59, 56, 59, 59, 57, 56, 57, 56, 59, 59, 59, 63,  0,255,
    0, 15,  0, 59, 67, 67, 67, 65, 68, 65, 67, 67, 67, 67, 65, 67,
   67, 73,  0,255,  0, 15,  0, 57, 67, 67, 67, 67, 65, 67, 67, 65,
   67, 67, 65, 67, 67, 75,  0,255,  0, 15,  0, 57, 65, 67,119,120,
  118,119,117,119,118,120,123, 70, 65, 73,  0,255,  0, 15,  0, 57,
   65, 67,119,117,119,119,120,119,119,123,124, 73, 67, 75,  0,255,
    0, 15,  0, 57, 67, 65,118,119, 47, 47, 47, 47, 47,125,126, 73,
   67, 74,  0,255,  0, 15,  0, 57, 67, 67,119,119, 47,188,188,188,
   47,124,125, 73, 65, 74,  0,255,  0, 15,  0, 59, 67, 65,119,119,
   47,188,188,188, 47,125,124, 73, 68, 74,  0,255,  0, 15,  0, 60,
   67, 67,117,120, 47,188,188,188, 47,125,125, 73, 65, 73,  0,255,
    0, 15,  0, 57, 67, 67,119,119, 47, 47, 47, 47, 47,126,125, 73,
   65, 73,  0,255,  0, 15,  0, 59, 65, 67,119,123,125,125,124,125,
  125,125,125, 73, 65, 75,  0,255,  0, 15,  0, 59, 68, 67,123,124,
  126,125,125,125,124,125,125, 73, 68, 73,  0,255,  0, 15,  0, 59,
   67, 65, 70, 73, 73, 73, 73, 73, 73, 73, 73, 73, 67, 74,  0,255,
    0, 15,  0, 59, 67, 67, 65, 67, 67, 65, 68, 67, 67, 67, 67, 67,
   67, 73,  0,255,  0, 15,  0, 64, 73, 73, 75, 73, 73, 75, 74, 74,
   74, 74, 74, 73, 73, 73,  0,255,
};

static const char m_butt2[]=  // Options reset button lit
{
   15,  0, 15,  0,  0,  0,  0,  0,
   68,  0,  0,  0, 88,  0,  0,  0,108,  0,  0,  0,128,  0,  0,  0,
  148,  0,  0,  0,168,  0,  0,  0,188,  0,  0,  0,208,  0,  0,  0,
  228,  0,  0,  0,248,  0,  0,  0, 12,  1,  0,  0, 32,  1,  0,  0,
   52,  1,  0,  0, 72,  1,  0,  0, 92,  1,  0,  0,  0, 15,  0, 59,
   59, 57, 59, 56, 59, 59, 57, 56, 57, 56, 59, 59, 59, 63,  0,255,
    0, 15,  0, 59, 67, 67, 67, 65, 68, 65, 67, 67, 67, 67, 65, 67,
   67, 73,  0,255,  0, 15,  0, 57, 67, 67, 67, 67, 65, 67, 67, 65,
   67, 67, 65, 67, 67, 75,  0,255,  0, 15,  0, 57, 65, 67,119,120,
  118,119,117,119,118,120,123, 70, 65, 73,  0,255,  0, 15,  0, 57,
   65, 67,119,117,119,119,120,119,119,123,124, 73, 67, 75,  0,255,
    0, 15,  0, 57, 67, 65,118,119, 47, 47, 47, 47, 47,125,126, 73,
   67, 74,  0,255,  0, 15,  0, 57, 67, 67,119,119, 47,176,176,176,
   47,124,125, 73, 65, 74,  0,255,  0, 15,  0, 59, 67, 65,119,119,
   47,176,176,176, 47,125,124, 73, 68, 74,  0,255,  0, 15,  0, 60,
   67, 67,117,120, 47,176,176,176, 47,125,125, 73, 65, 73,  0,255,
    0, 15,  0, 57, 67, 67,119,119, 47, 47, 47, 47, 47,126,125, 73,
   65, 73,  0,255,  0, 15,  0, 59, 65, 67,119,123,125,125,124,125,
  125,125,125, 73, 65, 75,  0,255,  0, 15,  0, 59, 68, 67,123,124,
  126,125,125,125,124,125,125, 73, 68, 73,  0,255,  0, 15,  0, 59,
   67, 65, 70, 73, 73, 73, 73, 73, 73, 73, 73, 73, 67, 74,  0,255,
    0, 15,  0, 59, 67, 67, 65, 67, 67, 65, 68, 67, 67, 67, 67, 67,
   67, 73,  0,255,  0, 15,  0, 64, 73, 73, 75, 73, 73, 75, 74, 74,
   74, 74, 74, 73, 73, 73,  0,255,
};

// Animated textures definition lump -- see SWANTBLS.EXE docs
static const char animated[]=
{
    0, 78, 85, 75, 65, 71, 69, 51,  0,  0, 78, 85, 75, 65, 71, 69,
   49,  0,  0,  8,  0,  0,  0,  0, 70, 87, 65, 84, 69, 82, 52,  0,
    0, 70, 87, 65, 84, 69, 82, 49,  0,  0,  8,  0,  0,  0,  0, 83,
   87, 65, 84, 69, 82, 52,  0,  0, 83, 87, 65, 84, 69, 82, 49,  0,
    0,  8,  0,  0,  0,  0, 76, 65, 86, 65, 52,  0,  0,  0,  0, 76,
   65, 86, 65, 49,  0,  0,  0,  0,  8,  0,  0,  0,  0, 66, 76, 79,
   79, 68, 51,  0,  0,  0, 66, 76, 79, 79, 68, 49,  0,  0,  0,  8,
    0,  0,  0,  0, 82, 82, 79, 67, 75, 48, 56,  0,  0, 82, 82, 79,
   67, 75, 48, 53,  0,  0,  8,  0,  0,  0,  0, 83, 76, 73, 77, 69,
   48, 52,  0,  0, 83, 76, 73, 77, 69, 48, 49,  0,  0,  8,  0,  0,
    0,  0, 83, 76, 73, 77, 69, 48, 56,  0,  0, 83, 76, 73, 77, 69,
   48, 53,  0,  0,  8,  0,  0,  0,  0, 83, 76, 73, 77, 69, 49, 50,
    0,  0, 83, 76, 73, 77, 69, 48, 57,  0,  0,  8,  0,  0,  0,  1,
   66, 76, 79, 68, 71, 82, 52,  0,  0, 66, 76, 79, 68, 71, 82, 49,
    0,  0,  8,  0,  0,  0,  1, 83, 76, 65, 68, 82, 73, 80, 51,  0,
   83, 76, 65, 68, 82, 73, 80, 49,  0,  8,  0,  0,  0,  1, 66, 76,
   79, 68, 82, 73, 80, 52,  0, 66, 76, 79, 68, 82, 73, 80, 49,  0,
    8,  0,  0,  0,  1, 70, 73, 82, 69, 87, 65, 76, 76,  0, 70, 73,
   82, 69, 87, 65, 76, 65,  0,  8,  0,  0,  0,  1, 71, 83, 84, 70,
   79, 78, 84, 51,  0, 71, 83, 84, 70, 79, 78, 84, 49,  0,  8,  0,
    0,  0,  1, 70, 73, 82, 69, 76, 65, 86, 65,  0, 70, 73, 82, 69,
   76, 65, 86, 51,  0,  8,  0,  0,  0,  1, 70, 73, 82, 69, 77, 65,
   71, 51,  0, 70, 73, 82, 69, 77, 65, 71, 49,  0,  8,  0,  0,  0,
    1, 70, 73, 82, 69, 66, 76, 85, 50,  0, 70, 73, 82, 69, 66, 76,
   85, 49,  0,  8,  0,  0,  0,  1, 82, 79, 67, 75, 82, 69, 68, 51,
    0, 82, 79, 67, 75, 82, 69, 68, 49,  0,  8,  0,  0,  0,  1, 66,
   70, 65, 76, 76, 52,  0,  0,  0, 66, 70, 65, 76, 76, 49,  0,  0,
    0,  8,  0,  0,  0,  1, 83, 70, 65, 76, 76, 52,  0,  0,  0, 83,
   70, 65, 76, 76, 49,  0,  0,  0,  8,  0,  0,  0,  1, 87, 70, 65,
   76, 76, 52,  0,  0,  0, 87, 70, 65, 76, 76, 49,  0,  0,  0,  8,
    0,  0,  0,  1, 68, 66, 82, 65, 73, 78, 52,  0,  0, 68, 66, 82,
   65, 73, 78, 49,  0,  0,  8,  0,  0,  0,255,255,255,255,
};

// Switch textures definition lump -- see SWANTBLS.EXE docs
static const char switches[]=
{
   83, 87, 49, 66, 82, 67, 79, 77,  0, 83, 87, 50, 66, 82, 67, 79,
   77,  0,  1,  0, 83, 87, 49, 66, 82, 78, 49,  0,  0, 83, 87, 50,
   66, 82, 78, 49,  0,  0,  1,  0, 83, 87, 49, 66, 82, 78, 50,  0,
    0, 83, 87, 50, 66, 82, 78, 50,  0,  0,  1,  0, 83, 87, 49, 66,
   82, 78, 71, 78,  0, 83, 87, 50, 66, 82, 78, 71, 78,  0,  1,  0,
   83, 87, 49, 66, 82, 79, 87, 78,  0, 83, 87, 50, 66, 82, 79, 87,
   78,  0,  1,  0, 83, 87, 49, 67, 79, 77, 77,  0,  0, 83, 87, 50,
   67, 79, 77, 77,  0,  0,  1,  0, 83, 87, 49, 67, 79, 77, 80,  0,
    0, 83, 87, 50, 67, 79, 77, 80,  0,  0,  1,  0, 83, 87, 49, 68,
   73, 82, 84,  0,  0, 83, 87, 50, 68, 73, 82, 84,  0,  0,  1,  0,
   83, 87, 49, 69, 88, 73, 84,  0,  0, 83, 87, 50, 69, 88, 73, 84,
    0,  0,  1,  0, 83, 87, 49, 71, 82, 65, 89,  0,  0, 83, 87, 50,
   71, 82, 65, 89,  0,  0,  1,  0, 83, 87, 49, 71, 82, 65, 89, 49,
    0, 83, 87, 50, 71, 82, 65, 89, 49,  0,  1,  0, 83, 87, 49, 77,
   69, 84, 65, 76,  0, 83, 87, 50, 77, 69, 84, 65, 76,  0,  1,  0,
   83, 87, 49, 80, 73, 80, 69,  0,  0, 83, 87, 50, 80, 73, 80, 69,
    0,  0,  1,  0, 83, 87, 49, 83, 76, 65, 68,  0,  0, 83, 87, 50,
   83, 76, 65, 68,  0,  0,  1,  0, 83, 87, 49, 83, 84, 65, 82, 71,
    0, 83, 87, 50, 83, 84, 65, 82, 71,  0,  1,  0, 83, 87, 49, 83,
   84, 79, 78, 49,  0, 83, 87, 50, 83, 84, 79, 78, 49,  0,  1,  0,
   83, 87, 49, 83, 84, 79, 78, 50,  0, 83, 87, 50, 83, 84, 79, 78,
   50,  0,  1,  0, 83, 87, 49, 83, 84, 79, 78, 69,  0, 83, 87, 50,
   83, 84, 79, 78, 69,  0,  1,  0, 83, 87, 49, 83, 84, 82, 84, 78,
    0, 83, 87, 50, 83, 84, 82, 84, 78,  0,  1,  0, 83, 87, 49, 66,
   76, 85, 69,  0,  0, 83, 87, 50, 66, 76, 85, 69,  0,  0,  2,  0,
   83, 87, 49, 67, 77, 84,  0,  0,  0, 83, 87, 50, 67, 77, 84,  0,
    0,  0,  2,  0, 83, 87, 49, 71, 65, 82, 71,  0,  0, 83, 87, 50,
   71, 65, 82, 71,  0,  0,  2,  0, 83, 87, 49, 71, 83, 84, 79, 78,
    0, 83, 87, 50, 71, 83, 84, 79, 78,  0,  2,  0, 83, 87, 49, 72,
   79, 84,  0,  0,  0, 83, 87, 50, 72, 79, 84,  0,  0,  0,  2,  0,
   83, 87, 49, 76, 73, 79, 78,  0,  0, 83, 87, 50, 76, 73, 79, 78,
    0,  0,  2,  0, 83, 87, 49, 83, 65, 84, 89, 82,  0, 83, 87, 50,
   83, 65, 84, 89, 82,  0,  2,  0, 83, 87, 49, 83, 75, 73, 78,  0,
    0, 83, 87, 50, 83, 75, 73, 78,  0,  0,  2,  0, 83, 87, 49, 86,
   73, 78, 69,  0,  0, 83, 87, 50, 86, 73, 78, 69,  0,  0,  2,  0,
   83, 87, 49, 87, 79, 79, 68,  0,  0, 83, 87, 50, 87, 79, 79, 68,
    0,  0,  2,  0, 83, 87, 49, 80, 65, 78, 69, 76,  0, 83, 87, 50,
   80, 65, 78, 69, 76,  0,  3,  0, 83, 87, 49, 82, 79, 67, 75,  0,
    0, 83, 87, 50, 82, 79, 67, 75,  0,  0,  3,  0, 83, 87, 49, 77,
   69, 84, 50,  0,  0, 83, 87, 50, 77, 69, 84, 50,  0,  0,  3,  0,
   83, 87, 49, 87, 68, 77, 69, 84,  0, 83, 87, 50, 87, 68, 77, 69,
   84,  0,  3,  0, 83, 87, 49, 66, 82, 73, 75,  0,  0, 83, 87, 50,
   66, 82, 73, 75,  0,  0,  3,  0, 83, 87, 49, 77, 79, 68, 49,  0,
    0, 83, 87, 50, 77, 79, 68, 49,  0,  0,  3,  0, 83, 87, 49, 90,
   73, 77,  0,  0,  0, 83, 87, 50, 90, 73, 77,  0,  0,  0,  3,  0,
   83, 87, 49, 83, 84, 79, 78, 54,  0, 83, 87, 50, 83, 84, 79, 78,
   54,  0,  3,  0, 83, 87, 49, 84, 69, 75,  0,  0,  0, 83, 87, 50,
   84, 69, 75,  0,  0,  0,  3,  0, 83, 87, 49, 77, 65, 82, 66,  0,
    0, 83, 87, 50, 77, 65, 82, 66,  0,  0,  3,  0, 83, 87, 49, 83,
   75, 85, 76, 76,  0, 83, 87, 50, 83, 75, 85, 76, 76,  0,  3,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,
};

// colormap for underwater, original default greenish
static const unsigned char watermap[] = {
  0,126,127,103,193,5,6,7,8,123,124,126,12,122,123,124,193,193,194,194,88,90,
  92,93,95,96,98,98,100,101,102,103,3,105,106,107,14,15,15,238,238,239,239,239,
  1,2,2,2,193,193,193,193,193,193,193,86,112,112,112,112,113,114,115,115,115,
  116,117,117,118,118,119,120,121,121,122,122,123,124,124,125,193,193,194,194,
  194,194,194,194,194,194,194,194,194,195,195,195,93,94,95,96,97,98,100,101,
  102,104,104,106,106,108,109,110,112,112,113,113,113,114,115,115,117,119,120,
  121,123,124,125,127,112,112,112,113,114,115,115,116,117,118,118,119,119,121,
  121,122,115,116,117,118,120,121,122,123,115,116,117,118,119,121,121,122,112,
  112,112,114,117,120,122,78,193,193,193,194,91,95,136,34,186,187,187,188,188,
  189,189,45,45,46,47,47,47,47,2,2,193,194,194,195,196,197,198,199,200,200,200,
  200,201,202,204,205,193,193,193,193,112,112,114,116,117,118,118,120,120,120,
  74,75,193,193,193,86,112,112,113,114,75,75,76,77,122,124,125,126,205,206,207,
  241,243,244,246,0,113,112,195,198,198,199,204,96,0,126,127,103,193,5,6,7,8,
  123,124,126,12,122,123,124,193,194,194,88,90,90,93,95,95,96,98,98,100,101,
  103,103,105,105,106,107,14,15,15,238,238,239,239,239,1,2,2,2,193,193,193,193,
  193,193,86,86,112,112,112,113,114,115,115,115,115,117,117,117,118,118,120,
  120,121,121,122,122,123,124,124,125,193,194,194,194,194,194,194,194,194,194,
  194,194,195,195,195,195,94,94,95,97,97,98,101,101,103,104,104,106,106,108,
  109,110,112,112,113,113,113,114,115,115,117,119,120,121,123,124,125,127,112,
  112,113,114,115,115,115,117,117,118,118,119,119,121,122,122,115,116,117,118,
  120,121,122,123,115,116,117,118,119,121,121,122,112,112,112,114,117,120,122,
  78,193,193,193,194,91,95,136,34,186,187,188,188,188,189,189,45,45,46,47,47,
  47,47,2,2,193,194,194,195,196,197,198,199,200,200,200,200,201,202,204,205,
  193,193,193,193,112,112,114,116,118,118,120,120,120,120,75,75,193,193,193,86,
  112,112,113,114,75,75,76,77,122,124,125,126,205,206,207,241,243,244,246,0,
  113,112,195,198,198,199,204,96,0,126,127,104,193,5,6,7,8,123,124,126,12,122,
  123,124,193,194,194,90,90,92,93,95,96,98,98,100,101,102,103,3,105,106,107,14,
  15,15,238,238,239,239,239,1,1,2,2,2,193,193,193,193,193,193,86,112,112,112,
  112,113,114,115,115,115,116,117,117,118,118,119,120,121,121,122,122,123,123,
  124,124,125,194,194,194,194,194,194,194,194,194,194,194,194,195,195,195,93,
  94,95,96,97,98,100,101,102,103,104,104,106,106,108,109,110,112,113,113,113,
  114,115,115,117,119,119,120,121,123,124,125,127,112,112,113,114,115,115,116,
  117,118,118,119,119,121,121,122,122,115,117,118,119,121,121,123,124,116,117,
  118,118,119,121,122,122,112,112,112,114,117,120,122,78,193,193,193,88,91,95,
  136,34,187,187,188,188,189,189,45,45,46,47,47,47,47,2,2,2,194,194,194,195,
  196,197,198,199,200,200,200,200,201,202,204,205,193,193,193,86,112,112,114,
  117,118,118,120,120,120,74,75,75,193,193,193,86,112,112,113,114,75,76,76,77,
  123,124,125,126,205,206,207,241,243,244,246,0,114,112,195,198,198,199,204,96,
  0,126,127,104,193,5,6,7,8,123,124,126,12,123,124,125,194,194,88,90,92,93,95,
  96,98,98,100,100,101,102,3,3,106,106,107,14,15,15,238,238,239,239,1,1,1,2,2,
  2,194,193,193,193,193,194,112,112,112,112,113,114,115,115,115,116,117,117,
  118,118,118,119,121,121,121,122,122,123,123,124,125,125,194,194,194,194,194,
  194,194,194,194,194,194,195,195,195,93,94,95,95,97,98,98,100,102,102,104,104,
  106,106,108,108,110,110,112,113,113,113,114,115,115,117,119,120,121,123,123,
  124,125,127,112,113,114,115,115,116,117,118,118,119,119,119,121,121,122,122,
  116,117,118,119,121,122,123,124,116,117,118,119,121,121,122,123,112,112,114,
  117,117,120,122,78,193,194,194,88,92,95,136,34,187,188,188,189,189,189,45,45,
  46,47,47,47,47,2,2,2,194,194,195,195,196,197,198,199,200,200,200,201,202,202,
  204,206,193,194,193,112,112,113,114,118,118,120,120,120,74,75,75,75,193,193,
  193,86,112,112,113,114,75,76,77,78,123,124,125,126,206,207,207,241,243,244,
  246,0,114,112,195,198,198,199,204,96,0,126,127,104,194,5,6,7,8,123,124,126,
  12,123,124,125,194,88,90,90,93,93,95,96,98,100,100,101,102,103,3,105,106,107,
  14,15,15,15,238,238,239,239,1,1,2,2,2,2,194,194,193,193,194,194,194,112,112,
  113,114,115,115,115,116,116,117,118,118,118,119,120,121,121,121,122,122,123,
  124,124,125,125,194,194,194,194,194,194,194,194,194,194,195,195,195,93,93,95,
  95,96,97,98,100,101,102,103,104,106,106,106,108,109,110,5,113,113,113,114,
  114,115,115,117,119,120,121,123,123,124,125,127,113,113,114,115,116,116,117,
  118,118,119,119,121,121,122,122,122,116,117,118,120,121,122,123,124,116,118,
  118,119,121,121,122,123,112,112,114,117,120,122,78,78,194,194,194,90,93,96,
  136,34,187,188,188,189,189,45,45,46,46,47,47,47,47,2,2,2,194,194,195,196,196,
  197,198,199,200,200,200,201,202,204,205,206,194,194,193,112,112,114,115,118,
  120,120,120,120,74,75,75,75,194,194,193,112,112,112,113,114,76,76,77,78,123,
  124,125,126,206,207,241,241,243,244,246,0,115,112,195,198,199,199,204,117,0,
  127,127,104,194,5,6,7,8,123,124,126,12,123,124,125,194,90,90,93,93,95,96,98,
  98,100,101,102,103,3,105,106,106,14,14,15,15,238,238,239,239,239,1,1,2,2,2,2,
  194,194,194,112,112,112,88,112,113,114,114,115,115,116,117,117,117,118,118,
  119,119,121,121,121,122,122,122,123,124,124,125,126,194,194,194,194,194,194,
  194,194,195,195,195,195,93,94,94,95,96,97,98,100,100,101,103,103,104,106,106,
  108,108,109,110,5,113,113,113,114,115,115,117,117,119,120,121,123,124,125,
  125,127,113,114,115,115,116,117,118,118,119,119,119,121,121,122,122,123,117,
  118,119,120,121,122,123,124,117,118,119,119,121,121,122,123,112,112,114,117,
  120,122,78,78,194,194,194,90,95,98,136,188,188,188,189,189,45,45,45,46,47,47,
  47,47,47,2,2,2,194,194,195,196,197,197,198,200,200,200,200,201,202,204,205,
  206,194,194,112,112,113,115,115,118,120,120,120,74,75,75,75,76,194,194,193,
  112,112,112,112,114,76,77,78,78,123,125,125,126,206,207,241,243,243,244,246,
  0,115,112,195,198,199,204,204,117,0,127,127,106,194,6,6,7,8,124,126,126,12,
  123,124,125,112,90,92,93,95,96,96,98,100,100,102,102,103,3,106,106,14,14,15,
  15,238,238,238,239,239,1,1,2,2,2,2,2,194,194,112,112,112,112,112,113,113,114,
  115,115,116,116,117,117,118,118,119,119,120,121,121,121,122,122,123,123,124,
  124,125,126,194,194,194,194,194,194,194,194,195,195,195,195,93,94,95,96,97,
  97,98,100,101,102,103,104,104,106,106,108,108,109,110,5,113,113,114,114,115,
  115,117,119,120,120,121,123,124,125,127,127,114,115,115,116,117,117,118,118,
  119,119,121,121,121,122,123,123,117,118,119,121,122,122,124,124,117,118,119,
  121,121,122,123,123,112,112,114,117,120,122,78,78,194,194,112,92,96,98,101,
  188,188,189,189,189,45,45,46,46,47,47,47,47,2,2,2,2,194,194,195,196,197,198,
  198,200,200,200,201,201,202,204,205,206,194,194,112,112,114,115,115,120,120,
  120,74,74,75,75,75,76,194,194,112,112,112,112,112,114,76,77,78,78,124,125,
  126,126,206,207,241,243,244,244,246,0,115,112,195,198,199,204,204,118,0,127,
  127,106,194,6,6,7,8,124,126,12,12,124,124,125,112,112,93,96,96,96,96,100,100,
  101,102,103,3,105,106,106,14,14,15,15,238,238,239,239,1,1,2,2,2,2,2,2,194,
  194,112,112,112,112,112,112,114,115,115,115,116,117,117,118,118,118,119,120,
  121,121,121,122,122,122,123,124,124,124,125,126,194,194,194,194,194,194,194,
  195,195,195,93,93,94,95,95,96,98,98,100,101,101,103,104,104,106,106,106,108,
  108,109,5,5,113,113,114,115,115,115,117,119,120,120,121,123,124,125,127,127,
  115,115,116,117,117,118,118,119,119,121,121,121,122,122,123,123,118,119,119,
  121,122,123,124,124,118,118,119,121,121,122,123,123,112,114,114,117,120,122,
  78,78,194,194,112,93,96,100,102,188,188,189,189,45,45,45,46,47,47,47,47,47,2,
  2,2,2,194,194,194,196,197,198,198,200,200,200,201,202,202,204,205,206,194,
  194,112,112,114,115,117,120,120,120,74,75,75,75,76,76,194,194,112,112,112,
  112,112,114,77,78,78,78,124,125,126,126,206,207,241,243,244,244,246,0,115,
  112,90,198,199,204,204,118,0,127,127,106,194,6,7,8,8,124,126,12,12,124,125,
  125,112,112,113,96,96,96,96,100,101,102,103,103,3,106,106,14,14,15,15,238,
  238,238,239,1,1,1,2,2,2,2,2,2,194,112,112,112,112,112,112,112,115,115,115,
  116,117,117,118,118,118,119,120,121,121,121,122,122,122,123,123,124,124,125,
  125,126,194,194,194,194,194,195,195,195,195,93,94,94,95,96,96,97,98,98,100,
  101,102,103,104,104,106,106,108,108,109,110,5,5,113,114,114,115,115,117,119,
  119,120,121,123,123,124,125,127,127,115,115,116,117,118,118,119,119,119,121,
  121,122,122,123,123,124,118,119,121,121,122,123,124,124,118,119,119,121,121,
  122,123,123,112,114,117,118,120,122,78,1,194,112,112,95,98,101,103,189,189,
  189,45,45,45,46,46,47,47,47,47,47,2,2,2,2,194,194,195,196,197,198,200,200,
  200,200,201,202,204,204,205,207,194,194,112,112,115,115,117,120,120,74,75,75,
  75,76,76,77,194,194,112,112,112,112,114,114,78,78,78,239,124,125,126,126,207,
  207,241,243,244,244,246,0,116,114,90,198,199,204,204,118,0,127,127,106,194,6,
  7,8,8,124,126,12,12,124,125,125,112,113,96,96,96,96,100,100,118,103,119,120,
  106,106,14,14,15,15,15,238,238,239,1,1,1,1,2,2,2,2,2,2,194,112,112,112,112,
  112,113,113,115,115,116,117,117,118,118,118,119,120,120,121,121,121,122,122,
  122,123,124,124,124,125,125,126,194,194,194,194,195,195,195,195,93,93,94,95,
  96,96,97,98,100,100,101,102,103,104,104,104,106,106,108,109,109,110,5,5,113,
  114,115,115,115,117,119,120,120,121,123,123,124,125,127,127,115,116,117,118,
  118,118,119,119,121,121,121,122,122,123,123,124,118,119,121,121,122,123,124,
  124,118,119,121,121,122,123,123,123,112,114,117,118,121,122,78,1,194,112,112,
  96,98,101,103,189,189,45,45,45,46,46,47,47,47,47,47,2,2,2,2,2,194,194,195,93,
  197,198,200,200,200,201,201,202,204,205,205,207,194,112,112,113,115,116,117,
  120,120,75,75,75,122,76,76,78,194,112,112,112,112,114,114,114,78,78,78,239,
  124,125,126,126,207,241,241,243,244,244,246,0,117,114,195,198,199,204,204,
  119,0,127,7,106,194,6,7,8,8,124,126,12,12,124,125,125,113,96,96,96,96,96,100,
  118,119,119,120,120,106,106,14,14,15,15,238,238,238,239,1,1,1,2,2,2,2,2,2,2,
  194,112,112,112,113,113,114,115,115,116,117,117,118,118,118,119,119,120,121,
  121,121,122,122,122,123,123,124,124,125,125,126,126,194,194,195,195,195,195,
  195,93,94,94,95,95,96,97,98,98,100,101,102,103,103,104,104,106,106,108,108,
  109,109,110,5,5,114,115,115,115,117,119,119,120,121,121,123,124,124,125,127,
  127,116,117,118,118,118,119,119,119,121,121,121,122,122,123,124,124,119,119,
  121,122,123,123,124,125,119,121,121,121,122,123,123,110,114,114,117,118,121,
  78,78,1,194,194,113,96,100,101,3,189,189,45,45,45,46,47,47,47,47,47,47,2,2,2,
  2,2,194,195,195,94,96,198,200,200,200,201,202,202,204,205,206,207,194,194,
  112,113,116,117,117,120,120,75,122,122,122,76,78,78,194,112,112,112,114,114,
  114,114,78,78,78,239,124,125,126,126,207,241,241,243,244,246,246,0,117,114,
  96,199,199,204,204,119,0,127,7,108,194,6,7,8,8,124,126,127,12,124,125,125,96,
  96,96,96,96,117,118,119,119,120,121,121,121,121,14,15,15,15,238,238,1,1,1,1,
  1,2,2,2,2,2,2,2,194,112,112,113,113,114,115,115,116,117,117,118,118,118,119,
  119,120,121,121,121,121,122,122,122,123,124,124,124,125,125,126,126,194,195,
  195,195,195,93,93,94,95,95,96,96,97,98,98,100,101,101,102,103,104,104,106,
  106,106,108,108,109,110,5,5,5,114,115,115,117,117,119,120,120,121,121,123,
  124,124,125,127,7,117,117,118,118,119,119,119,121,121,122,122,122,123,123,
  124,124,119,121,121,122,123,124,124,125,119,121,121,121,122,123,123,110,114,
  116,118,120,121,78,78,1,194,195,114,96,100,102,105,45,45,45,45,46,46,47,47,
  47,47,47,2,2,2,2,2,2,194,195,93,95,97,200,200,200,200,201,202,204,204,205,
  206,207,194,194,113,115,116,117,120,120,120,75,122,122,122,78,78,78,194,112,
  112,113,114,114,114,117,78,78,78,239,124,125,126,126,207,241,243,243,244,246,
  246,0,117,114,96,199,199,204,204,119,0,127,7,108,194,6,7,8,8,5,126,12,8,124,
  125,125,96,96,96,117,117,118,118,119,120,120,121,121,121,121,15,15,15,238,
  238,239,1,1,1,1,2,2,2,2,2,2,2,2,195,113,113,114,114,115,115,115,116,117,118,
  118,118,119,120,120,121,121,121,121,122,122,122,123,123,124,124,124,125,125,
  126,126,195,195,195,195,93,94,94,95,96,96,97,97,98,100,100,101,102,102,103,
  104,104,106,106,106,108,108,109,109,110,5,5,6,115,115,115,117,119,119,120,
  120,121,123,123,124,125,125,127,8,118,118,118,119,119,119,121,121,121,122,
  122,123,123,124,124,124,119,121,122,122,123,124,124,125,119,121,121,122,123,
  123,124,124,115,116,118,121,121,122,123,1,194,195,115,96,101,103,105,45,45,
  45,46,46,47,47,47,47,47,47,2,2,2,2,2,2,195,195,94,96,98,201,201,201,201,202,
  202,204,204,205,206,241,194,195,114,115,117,118,120,120,122,122,122,122,122,
  78,78,78,194,112,113,115,114,114,117,117,78,78,239,1,124,125,126,127,241,241,
  243,243,244,246,246,0,118,117,96,199,204,204,108,119,0,127,7,108,195,6,7,8,8,
  5,126,12,8,125,125,126,96,116,117,117,118,118,119,119,119,121,121,121,121,
  122,15,15,238,238,238,1,1,1,1,2,2,2,2,2,2,2,2,127,195,114,114,115,115,115,
  116,116,116,118,118,118,119,120,120,121,121,121,121,122,122,122,123,123,124,
  124,125,124,125,126,126,126,195,195,93,93,94,95,95,96,96,97,98,98,100,100,
  101,101,102,103,104,104,104,106,106,106,108,109,109,110,110,5,5,6,115,115,
  117,117,119,120,120,121,121,123,123,124,125,125,127,8,118,118,119,119,119,
  121,121,121,122,122,122,123,123,124,124,124,121,121,122,123,124,124,125,125,
  121,121,121,122,123,123,124,124,116,116,118,121,122,123,124,126,195,195,115,
  117,102,3,106,45,45,46,46,47,47,47,47,47,47,2,2,2,2,2,2,127,195,93,95,97,98,
  201,201,201,201,202,202,204,205,205,207,241,195,195,115,115,117,118,120,120,
  122,122,122,122,78,78,78,78,195,195,114,115,116,117,117,117,78,78,239,1,125,
  125,126,127,241,241,243,244,244,246,246,0,118,117,96,199,204,204,108,121,0,
  127,8,109,195,6,7,8,8,125,126,127,8,125,125,126,116,117,117,118,118,118,119,
  119,121,121,121,121,122,122,123,123,124,238,1,1,1,1,1,2,2,2,2,2,2,2,127,127,
  93,115,115,115,115,116,116,117,117,118,118,119,120,121,121,121,121,122,122,
  122,122,123,123,124,124,124,125,125,125,126,126,127,93,93,94,94,95,96,96,97,
  97,98,98,100,100,101,101,102,103,104,104,106,106,106,106,108,108,109,109,110,
  5,5,6,6,115,117,117,119,119,120,121,121,123,123,124,124,125,127,127,8,118,
  119,119,119,121,121,121,122,122,122,123,123,124,124,124,125,121,122,122,123,
  124,124,125,125,121,121,122,122,123,109,124,5,116,117,120,121,122,123,124,
  126,195,93,116,117,103,105,107,15,46,46,47,47,47,47,47,47,47,2,2,2,2,2,2,127,
  93,95,96,98,100,201,201,201,201,202,204,204,205,206,207,241,195,93,115,116,
  117,118,119,122,122,122,122,78,78,78,78,78,195,195,115,116,116,117,117,117,
  78,239,1,1,125,126,126,127,241,243,243,244,244,246,246,0,119,117,96,199,204,
  204,109,121,0,7,8,109,195,7,7,8,8,126,127,127,8,125,125,126,117,117,118,118,
  119,119,119,121,121,121,122,122,122,122,123,123,124,124,1,1,1,1,2,2,2,2,2,2,
  2,2,127,127,94,95,115,116,116,117,117,117,117,118,118,120,121,121,121,121,
  122,122,122,122,122,123,124,124,124,125,125,125,125,126,126,127,94,94,95,95,
  96,97,97,98,98,98,100,100,101,102,102,103,104,104,104,106,106,106,108,108,
  109,109,110,5,5,5,6,6,117,117,119,119,120,120,121,121,123,123,124,124,125,
  127,127,8,119,119,119,121,121,121,122,122,122,123,123,124,124,124,124,125,
  121,122,123,123,124,124,125,126,121,122,122,123,123,110,124,5,116,118,121,
  121,122,123,125,126,195,95,117,118,119,106,107,15,46,47,47,47,47,47,47,47,2,
  2,2,2,2,2,2,127,94,95,97,98,101,202,202,202,202,202,204,204,205,206,207,241,
  195,94,116,117,118,119,120,122,122,122,78,78,78,78,78,78,195,94,115,116,116,
  117,117,120,239,1,1,1,125,126,126,127,241,243,243,244,244,246,246,0,120,118,
  96,199,204,204,109,121,0,7,8,109,94,7,7,8,8,126,127,127,8,125,126,126,118,
  118,118,119,119,119,121,121,121,121,122,122,122,123,123,124,124,124,125,1,1,
  2,2,2,2,2,2,2,127,127,127,127,95,115,117,117,117,118,118,118,118,118,120,121,
  121,121,121,121,122,122,122,122,123,124,124,124,124,125,125,125,125,126,126,
  127,95,95,96,96,97,98,98,98,100,100,101,101,102,103,103,104,104,104,106,106,
  106,108,108,108,109,110,110,5,5,5,6,6,117,119,119,120,120,121,121,123,123,
  123,124,125,125,127,127,8,119,119,121,121,121,122,122,122,123,123,123,124,
  124,124,125,125,122,122,123,124,124,125,125,126,121,122,122,123,109,110,124,
  5,117,118,121,122,122,123,125,126,94,95,117,118,120,106,14,15,47,47,47,47,47,
  47,47,2,2,2,2,2,2,2,127,127,95,96,98,100,102,202,202,202,202,204,204,205,205,
  206,207,241,94,95,117,118,118,120,121,122,122,78,78,78,78,78,78,239,94,115,
  115,116,117,118,120,120,1,1,1,2,125,126,126,127,241,243,243,244,244,246,246,
  0,121,118,97,204,204,204,110,122,0,7,8,110,95,7,7,8,0,6,127,7,8,125,126,126,
  118,119,119,119,119,121,121,121,122,122,122,122,123,123,124,124,124,125,125,
  125,126,126,126,2,2,2,2,127,127,127,127,127,96,97,117,118,118,118,118,118,
  119,119,120,121,121,121,122,122,122,122,123,123,124,124,124,124,125,125,125,
  125,126,126,127,127,96,97,97,97,98,98,100,100,101,101,102,102,103,104,104,
  104,106,106,106,106,108,108,108,109,109,110,5,5,5,6,6,6,119,119,120,120,120,
  121,121,123,123,124,124,125,125,127,127,8,121,121,121,121,122,122,122,123,
  123,124,124,124,124,125,125,125,122,123,123,124,124,125,126,126,122,122,123,
  123,110,124,5,5,118,120,121,122,123,124,125,126,95,97,118,119,121,14,15,238,
  47,47,47,47,47,47,2,2,2,2,2,2,2,2,127,127,96,98,100,101,103,202,202,202,202,
  204,204,205,206,207,241,243,95,96,118,118,118,121,121,122,78,78,78,78,78,78,
  1,1,95,115,116,117,118,118,120,120,1,1,1,2,125,126,127,127,243,243,244,244,
  246,246,0,0,121,120,98,204,204,204,110,122,0,7,8,110,96,7,8,8,0,6,127,7,8,
  126,126,126,119,119,119,121,121,121,121,122,122,122,123,123,123,124,124,124,
  125,125,125,126,126,126,126,126,126,126,127,127,127,127,127,127,97,98,118,
  118,118,119,119,119,119,120,121,121,122,122,122,122,122,123,123,124,124,124,
  125,125,125,125,125,126,126,126,127,127,97,98,98,98,100,100,101,101,102,102,
  103,103,104,104,104,106,106,106,106,108,108,108,109,109,110,5,5,5,5,6,6,6,
  119,119,120,120,121,121,123,123,124,124,124,125,127,127,7,8,121,121,121,122,
  122,122,123,123,124,124,124,124,110,125,125,5,122,123,124,124,125,125,126,
  126,122,123,123,109,110,5,5,126,118,120,122,122,123,124,126,126,96,98,119,
  119,121,14,15,238,47,47,47,47,47,2,2,2,2,2,2,2,2,127,127,127,97,98,101,102,
  104,204,204,204,204,204,205,205,206,207,241,243,96,97,118,119,120,121,121,78,
  78,78,78,78,78,1,1,1,96,116,116,118,118,121,121,122,1,1,126,2,126,126,127,
  127,243,243,244,244,246,246,0,0,121,121,100,204,204,108,110,123,0,8,8,5,97,7,
  8,8,0,6,127,8,8,126,126,127,119,119,121,121,121,121,122,122,123,123,123,123,
  124,124,125,125,125,125,126,126,126,126,126,126,126,127,127,127,127,127,127,
  127,98,100,119,119,119,119,119,119,121,121,121,121,122,122,122,122,123,124,
  124,124,124,125,125,125,125,125,126,126,126,127,127,127,98,100,100,100,101,
  102,102,102,103,103,104,104,104,106,106,106,106,106,108,108,108,109,109,110,
  110,5,5,5,6,6,6,7,120,120,120,121,121,123,123,123,124,124,125,125,127,127,8,
  8,121,122,122,122,123,123,123,124,124,109,124,125,125,125,5,126,123,124,124,
  124,125,125,126,126,108,123,109,110,5,5,126,6,120,120,122,123,124,125,126,
  126,97,100,119,121,121,15,238,239,47,47,47,47,2,2,2,2,2,2,2,2,2,127,127,127,
  98,101,102,103,104,204,204,204,204,205,205,206,207,207,241,243,97,98,119,119,
  120,121,122,78,78,78,78,78,1,1,1,1,97,117,117,118,120,120,121,122,126,126,
  126,2,126,126,127,127,243,243,244,244,246,246,0,0,122,120,101,204,204,109,5,
  123,0,8,8,5,98,7,8,8,0,6,7,8,8,126,126,127,121,121,121,121,122,122,122,123,
  123,123,124,124,124,125,125,125,126,126,126,126,126,126,126,126,127,127,127,
  127,127,127,127,127,100,101,119,119,119,121,121,121,121,121,122,122,122,122,
  123,123,124,124,124,124,125,125,125,125,125,126,126,126,126,127,127,127,100,
  101,101,102,102,103,103,104,104,104,104,104,106,106,106,106,108,108,108,109,
  109,109,110,110,5,5,5,6,6,6,6,7,120,120,121,121,123,123,123,124,124,124,125,
  125,127,127,8,8,122,122,106,106,123,108,108,124,109,109,110,125,125,5,126,
  126,123,124,124,125,125,126,126,127,123,109,110,110,5,5,126,6,120,121,122,
  123,124,125,126,126,98,101,121,121,122,122,238,239,47,47,2,2,2,2,2,2,2,2,2,2,
  127,127,127,127,100,102,103,104,106,204,204,204,204,205,206,206,207,241,243,
  243,98,101,119,121,121,122,122,78,78,78,123,124,125,1,126,126,98,118,118,120,
  120,120,122,122,126,126,126,126,126,127,127,127,243,244,244,244,246,246,0,0,
  122,122,102,204,204,109,5,124,0,8,8,5,101,7,8,8,0,127,7,8,8,126,127,127,121,
  121,122,122,122,122,123,123,124,124,124,124,125,125,125,126,126,126,126,126,
  126,126,126,126,127,127,127,127,127,127,127,127,102,102,103,121,121,121,121,
  121,122,122,122,122,123,123,124,124,124,124,125,125,125,125,125,125,126,126,
  126,126,127,127,127,7,102,102,103,103,103,104,104,104,104,106,106,106,106,
  106,106,108,108,108,109,109,109,110,5,5,5,5,5,6,6,6,7,7,121,121,121,123,123,
  123,124,124,124,125,125,127,127,127,8,8,106,106,106,108,108,108,109,109,109,
  110,110,125,5,126,126,126,124,124,124,125,126,126,126,127,109,110,110,5,5,5,
  6,6,121,122,123,124,125,126,126,126,101,102,121,122,122,123,238,239,47,2,2,2,
  2,2,2,2,2,2,2,127,127,127,127,127,102,103,104,106,106,205,205,205,205,205,
  206,207,207,241,243,243,101,102,121,121,122,122,123,123,123,124,124,125,125,
  126,126,126,101,118,119,119,121,122,122,122,126,126,126,126,126,127,127,7,
  243,244,244,246,246,246,0,0,122,122,104,204,204,110,5,124,0,8,8,5,102,8,8,0,
  0,7,7,8,8,127,127,127,122,122,122,123,123,123,124,124,124,124,125,125,125,
  125,126,126,126,126,126,126,126,126,127,127,127,127,127,127,127,127,127,127,
  103,104,104,121,121,122,122,122,122,122,123,123,124,124,124,124,124,125,125,
  125,125,125,126,126,126,126,126,126,127,127,127,7,103,104,104,104,104,104,
  106,106,106,106,106,106,108,108,108,108,109,109,109,110,110,5,5,5,5,6,6,6,6,
  6,7,7,121,121,123,123,123,124,124,124,125,125,125,127,127,127,8,8,106,108,
  108,108,109,109,109,110,110,110,5,5,5,126,126,126,124,124,125,125,126,126,
  127,127,110,110,5,5,5,6,6,6,121,122,123,124,125,126,126,127,102,104,122,122,
  123,124,1,1,2,2,2,2,2,2,2,2,2,2,127,127,127,127,127,127,103,104,106,106,108,
  205,205,205,205,206,207,207,241,241,243,244,102,103,121,122,122,123,123,124,
  124,125,125,125,126,126,126,126,102,103,119,121,122,122,122,122,126,126,126,
  126,127,127,127,8,244,244,244,246,246,246,0,0,123,122,104,204,108,110,6,125,
  0,8,8,6,104,8,8,0,0,7,8,8,0,127,127,127,122,123,123,123,123,124,124,124,125,
  125,125,125,126,126,126,126,126,126,126,126,126,127,127,127,127,127,127,127,
  127,127,8,8,104,104,104,122,122,122,122,123,123,123,124,124,124,124,125,125,
  125,125,125,125,126,126,126,126,126,126,126,127,127,127,7,8,104,104,104,106,
  106,106,106,106,106,108,108,108,108,109,109,109,109,110,110,5,5,5,5,5,6,6,6,
  6,6,7,7,7,123,123,123,123,124,124,124,125,125,125,127,127,127,8,8,8,108,108,
  109,109,109,110,110,110,5,5,5,126,126,126,6,127,124,125,125,126,126,126,127,
  127,110,5,5,5,6,6,6,127,122,123,124,124,125,126,126,127,104,104,122,123,124,
  124,1,1,2,2,2,2,2,2,2,2,2,127,127,127,127,127,127,8,104,106,106,108,108,206,
  206,206,206,207,207,241,241,243,243,244,104,104,122,122,123,124,124,125,125,
  125,126,126,126,126,126,126,104,104,121,121,122,122,123,123,126,126,126,127,
  127,127,7,8,244,244,244,246,246,246,0,0,124,123,106,204,109,5,6,110,0,8,8,6,
  104,8,8,0,0,7,8,8,0,127,127,7,123,123,124,124,124,124,125,125,125,125,126,
  126,126,126,126,126,126,126,126,127,127,127,127,127,127,127,127,127,127,8,8,
  8,106,106,106,106,123,123,123,123,124,124,124,124,125,125,125,125,125,125,
  125,126,126,126,126,126,126,127,127,127,127,7,7,8,106,106,106,106,106,106,
  108,108,108,108,108,109,109,109,109,110,110,110,5,5,5,5,5,6,6,6,6,6,7,7,7,7,
  123,123,124,124,124,124,125,125,125,125,127,127,127,8,8,8,109,109,109,110,
  110,110,5,5,5,5,126,126,126,6,127,127,125,125,126,126,126,127,127,127,5,5,5,
  6,6,6,127,7,123,124,124,125,126,126,126,127,104,106,123,124,124,125,126,2,2,
  2,2,2,2,2,2,2,127,127,127,127,127,127,8,8,106,106,108,108,109,207,207,207,
  207,207,241,241,243,243,244,244,104,106,106,123,124,124,125,125,126,126,126,
  126,126,126,126,126,104,106,121,122,123,123,124,124,126,126,127,127,127,127,
  7,8,244,244,246,246,246,246,0,0,124,123,106,109,110,5,6,110,0,8,0,6,106,8,8,
  0,0,7,8,8,0,127,7,7,108,124,109,109,125,125,125,126,126,126,126,126,126,126,
  126,126,126,127,127,127,127,127,127,127,127,127,127,127,8,8,8,8,106,108,108,
  108,108,124,124,124,124,125,125,125,125,125,125,126,126,126,126,126,126,126,
  126,126,127,127,127,127,7,7,8,8,106,106,108,108,108,108,108,109,109,109,109,
  109,110,110,110,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,8,124,124,124,124,125,125,
  125,125,127,127,127,127,7,8,8,0,110,110,110,110,5,5,5,5,126,126,126,6,6,127,
  127,127,5,126,126,126,127,127,127,7,5,6,6,6,6,7,7,7,123,124,124,125,126,126,
  127,127,106,108,108,124,125,125,126,2,2,2,2,2,2,2,127,127,127,127,127,127,
  127,8,8,8,106,108,108,109,110,207,207,207,207,241,241,243,243,243,244,244,
  106,106,108,124,124,125,125,126,126,126,126,126,126,126,126,126,106,106,122,
  123,124,124,124,124,126,127,127,127,127,7,8,8,244,246,246,246,246,0,0,0,125,
  124,108,109,5,5,6,5,0,8,0,7,108,8,8,0,0,8,8,8,0,7,7,8,109,110,110,110,110,
  125,126,126,126,126,126,126,126,126,127,127,127,127,127,127,127,127,127,127,
  127,8,8,8,8,8,8,8,108,108,109,109,109,109,125,125,125,125,125,125,125,126,
  126,126,126,126,126,126,126,127,127,127,127,127,127,7,7,8,8,8,108,108,109,
  109,109,109,109,110,110,110,110,5,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,8,8,
  124,124,125,125,125,125,125,127,127,127,127,127,8,8,8,0,110,5,5,5,5,5,126,
  126,6,6,6,127,127,127,7,7,126,126,126,127,127,127,7,7,6,6,6,6,7,7,7,7,124,
  125,125,126,126,127,127,127,108,108,109,125,126,126,126,2,2,2,2,127,127,127,
  127,127,127,127,127,127,8,8,8,8,108,109,109,110,5,241,241,241,241,241,243,
  243,243,244,244,246,108,108,109,124,125,125,126,126,126,126,126,126,126,126,
  127,127,108,108,123,123,124,124,124,124,127,127,127,127,7,7,8,8,246,246,246,
  246,246,0,0,0,126,124,109,110,5,6,7,126,0,8,0,7,109,8,0,0,0,8,8,0,0,7,8,8,
  110,5,5,5,5,126,126,126,126,126,126,127,127,127,127,127,127,127,127,127,127,
  127,127,8,8,8,8,8,8,8,8,0,109,110,110,110,110,110,125,125,125,125,126,126,
  126,126,126,126,126,126,127,127,127,127,127,127,127,127,7,7,8,8,8,8,109,110,
  110,110,110,110,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,125,125,
  125,125,125,127,127,127,127,127,7,8,8,8,0,0,5,5,5,6,6,6,6,6,6,127,127,127,7,
  7,7,7,6,6,127,127,7,7,8,8,6,6,6,7,7,7,7,8,124,125,126,126,127,127,127,127,
  109,110,110,5,126,126,126,127,127,127,127,127,127,127,127,127,127,127,8,8,8,
  8,8,0,109,110,110,5,5,243,243,243,243,243,243,244,244,244,244,246,109,109,
  110,125,125,126,126,126,126,126,126,127,127,127,127,127,109,109,110,124,124,
  124,124,124,127,127,127,127,7,8,8,8,246,246,246,246,0,0,0,0,126,125,110,5,6,
  6,7,6,0,0,0,7,110,0,0,0,0,8,8,0,0,8,8,8,5,5,126,126,126,126,127,127,127,127,
  127,127,127,127,127,127,127,127,7,8,8,8,8,8,8,8,8,8,8,0,0,0,5,5,5,5,5,5,126,
  126,126,126,126,126,126,127,127,127,127,127,127,127,127,127,127,7,7,7,8,8,8,
  8,8,8,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,125,
  125,127,127,127,127,127,127,7,8,8,8,8,8,0,0,6,6,6,6,6,6,127,7,7,7,7,7,7,7,8,
  8,127,127,7,7,7,8,8,8,7,7,7,7,7,8,8,8,126,126,126,127,127,127,127,8,110,5,5,
  126,126,127,127,127,127,127,127,127,127,127,127,127,8,8,8,8,8,8,0,0,5,5,5,6,
  6,243,243,243,243,244,244,244,244,246,246,246,110,5,5,126,126,126,126,127,
  127,127,127,127,127,127,127,127,110,5,5,126,126,126,126,126,127,127,127,8,8,
  8,8,0,246,246,246,246,0,0,0,0,126,126,5,6,6,7,7,127,0,0,0,8,5,0,0,0,0,8,0,0,
  0,8,8,8,6,6,6,127,127,127,127,127,127,127,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,
  8,0,0,0,0,6,6,6,6,6,6,6,6,127,127,127,127,127,127,127,127,127,127,7,7,7,7,8,
  8,8,8,8,8,8,8,8,0,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,
  8,8,0,127,127,127,127,127,7,7,8,8,8,8,8,8,0,0,0,6,6,7,7,7,7,7,7,7,7,7,8,8,8,
  8,8,7,7,7,8,8,8,8,8,7,7,7,8,8,8,8,8,126,127,127,127,127,8,8,8,5,6,6,6,127,
  127,127,127,127,127,127,8,8,8,8,8,8,8,8,8,0,0,0,0,6,6,6,6,6,244,244,244,244,
  244,244,244,246,246,246,246,5,6,6,6,127,127,127,127,127,127,127,127,127,127,
  127,8,5,6,6,126,126,126,126,12,8,8,8,8,8,8,0,0,246,246,246,0,0,0,0,0,127,127,
  6,6,7,7,8,7,0,0,0,8,6,0,0,0,0,0,0,0,0,8,0,0,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,
  8,8,8,8,8,8,0,0,0,0,0,0,0,0,0,0,6,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,
  8,8,8,8,8,8,0,0,0,0,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,
  0,0,0,0,7,7,8,8,8,8,8,8,8,8,8,0,0,0,0,0,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
  8,8,8,8,8,0,8,8,8,8,8,8,8,0,127,7,7,8,8,8,8,0,6,7,7,7,7,7,8,8,8,8,8,8,8,8,8,
  0,0,0,0,0,0,0,0,0,7,7,7,7,7,246,246,246,246,246,246,246,246,246,246,0,6,6,7,
  7,7,7,7,8,8,8,8,8,8,8,8,8,6,6,7,127,127,127,12,12,8,8,8,0,8,0,0,0,0,0,0,0,0,
  0,0,0,7,127,7,7,8,8,8,8,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,8,8,
  8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
  8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,0,0,0,
  0,0,0,0,0,0,0,0,0,0,8,8,8,8,8,0,0,0,0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,0,0,0,0,
  0,0,0,0,8,8,0,0,0,0,0,0,8,0,0,0,0,0,0,0,8,8,8,8,0,0,0,0,8,8,8,8,8,8,8,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,8,8,8,246,246,246,246,246,246,246,0,0,0,0,8,
  8,8,8,8,8,8,8,8,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,8,8,8,8,8,0,0,8,193,193,193,194,0,193,193,193,193,194,194,193,193,194,194,
  194,108,106,104,103,102,100,98,97,95,94,93,195,195,195,194,194,194,194,194,
  194,194,194,194,194,194,194,194,194,194,193,193,193,7,6,6,5,110,109,108,108,
  106,104,104,102,101,98,97,97,95,94,93,93,195,195,194,194,194,194,194,194,194,
  194,194,194,7,6,5,5,109,108,108,106,104,104,102,101,100,98,97,96,95,94,93,
  195,195,195,194,194,194,194,194,194,194,194,194,194,106,104,102,100,97,95,93,
  195,195,194,194,194,194,194,193,193,102,101,98,97,96,95,94,93,195,195,195,
  194,194,194,194,194,95,93,195,195,194,194,194,194,93,195,195,194,194,194,194,
  194,7,108,104,98,94,195,194,194,0,6,109,104,100,96,93,194,194,194,194,194,
  194,194,194,194,194,194,194,194,194,193,193,193,7,109,104,100,95,195,194,194,
  194,194,194,193,193,193,193,193,0,7,5,109,106,104,101,98,96,95,94,93,195,195,
  194,194,0,0,8,7,7,6,5,5,194,194,194,194,194,194,194,194,193,193,193,193,193,
  193,193,193,103,110,104,195,194,194,194,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,
};

//jff 2/18/98 palette color ranges for translation

static const char cr_brick[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,46,46,46,46,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,46,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,
     176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};

static const char cr_tan[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,78,45,78,78,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,78,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};
    
static const char cr_gray[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,110,110,46,110,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,110,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};
    
static const char cr_green[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,127,127,46,127,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,127,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};
    
static const char cr_brown[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,143,143,46,143,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,143,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};
    
static const char cr_gold[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,167,167,46,167,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,167,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     160,160,161,161,162,162,163,163,164,164,165,165,166,166,167,167,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};
    
static const char cr_red[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,191,191,46,191,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,191,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};

static const char cr_blue[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,203,203,46,203,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,203,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     196,196,197,197,198,198,199,199,200,200,201,201,202,202,203,203,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};

// killough 2/28/98: The blue translation table above looks bad on the
// status bar but a little better on the HUD. So I've created a separate
// translation table for the status bar, which is the same as last week's.

static const char cr_blue2[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,207,207,46,207,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,207,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     200,200,201,201,202,202,203,203,204,204,205,205,206,206,207,207,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};

    
static const char cr_orange[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,223,223,46,223,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,223,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};
    
static const char cr_yellow[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,231,231,46,231,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,231,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     224,224,225,225,226,226,227,227,228,228,229,229,230,230,231,231,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};

// There are some lumps that need to be included in order to use old
// versions of the DOOM IWADs, notably versions 1.1 and 1.2.  These
// are included here.

static const char stbar[] = {  // default status bar
  64,1,32,0,0,0,0,0,8,5,0,0,45,5,0,0,82,5,0,0,119,5,0,0,156,5,0,0,193,5,0,0,
  230,5,0,0,11,6,0,0,48,6,0,0,85,6,0,0,122,6,0,0,159,6,0,0,196,6,0,0,233,6,0,0,
  14,7,0,0,51,7,0,0,88,7,0,0,125,7,0,0,162,7,0,0,199,7,0,0,236,7,0,0,17,8,0,0,
  54,8,0,0,91,8,0,0,128,8,0,0,165,8,0,0,202,8,0,0,239,8,0,0,20,9,0,0,57,9,0,0,
  94,9,0,0,131,9,0,0,168,9,0,0,205,9,0,0,242,9,0,0,23,10,0,0,60,10,0,0,97,10,0,
  0,134,10,0,0,171,10,0,0,208,10,0,0,245,10,0,0,26,11,0,0,63,11,0,0,100,11,0,0,
  137,11,0,0,174,11,0,0,211,11,0,0,248,11,0,0,29,12,0,0,66,12,0,0,103,12,0,0,
  140,12,0,0,177,12,0,0,214,12,0,0,251,12,0,0,32,13,0,0,69,13,0,0,106,13,0,0,
  143,13,0,0,180,13,0,0,217,13,0,0,254,13,0,0,35,14,0,0,72,14,0,0,109,14,0,0,
  146,14,0,0,183,14,0,0,220,14,0,0,1,15,0,0,38,15,0,0,75,15,0,0,112,15,0,0,149,
  15,0,0,186,15,0,0,223,15,0,0,4,16,0,0,41,16,0,0,78,16,0,0,115,16,0,0,152,16,
  0,0,189,16,0,0,226,16,0,0,7,17,0,0,44,17,0,0,81,17,0,0,118,17,0,0,155,17,0,0,
  192,17,0,0,229,17,0,0,10,18,0,0,47,18,0,0,84,18,0,0,121,18,0,0,158,18,0,0,
  195,18,0,0,232,18,0,0,13,19,0,0,50,19,0,0,87,19,0,0,124,19,0,0,161,19,0,0,
  198,19,0,0,235,19,0,0,16,20,0,0,53,20,0,0,90,20,0,0,127,20,0,0,164,20,0,0,
  201,20,0,0,238,20,0,0,19,21,0,0,56,21,0,0,93,21,0,0,130,21,0,0,167,21,0,0,
  204,21,0,0,241,21,0,0,22,22,0,0,59,22,0,0,96,22,0,0,133,22,0,0,170,22,0,0,
  207,22,0,0,244,22,0,0,25,23,0,0,62,23,0,0,99,23,0,0,136,23,0,0,173,23,0,0,
  210,23,0,0,247,23,0,0,28,24,0,0,65,24,0,0,102,24,0,0,139,24,0,0,176,24,0,0,
  213,24,0,0,250,24,0,0,31,25,0,0,68,25,0,0,105,25,0,0,142,25,0,0,179,25,0,0,
  216,25,0,0,253,25,0,0,34,26,0,0,71,26,0,0,108,26,0,0,145,26,0,0,182,26,0,0,
  219,26,0,0,0,27,0,0,37,27,0,0,74,27,0,0,111,27,0,0,148,27,0,0,185,27,0,0,222,
  27,0,0,3,28,0,0,40,28,0,0,77,28,0,0,114,28,0,0,151,28,0,0,188,28,0,0,225,28,
  0,0,6,29,0,0,43,29,0,0,80,29,0,0,117,29,0,0,154,29,0,0,191,29,0,0,228,29,0,0,
  9,30,0,0,46,30,0,0,83,30,0,0,120,30,0,0,157,30,0,0,194,30,0,0,231,30,0,0,12,
  31,0,0,49,31,0,0,86,31,0,0,123,31,0,0,160,31,0,0,197,31,0,0,234,31,0,0,15,32,
  0,0,52,32,0,0,89,32,0,0,126,32,0,0,163,32,0,0,200,32,0,0,237,32,0,0,18,33,0,
  0,55,33,0,0,92,33,0,0,129,33,0,0,166,33,0,0,203,33,0,0,240,33,0,0,21,34,0,0,
  58,34,0,0,95,34,0,0,132,34,0,0,169,34,0,0,206,34,0,0,243,34,0,0,24,35,0,0,61,
  35,0,0,98,35,0,0,135,35,0,0,172,35,0,0,209,35,0,0,246,35,0,0,27,36,0,0,64,36,
  0,0,101,36,0,0,138,36,0,0,175,36,0,0,212,36,0,0,249,36,0,0,30,37,0,0,67,37,0,
  0,104,37,0,0,141,37,0,0,178,37,0,0,215,37,0,0,252,37,0,0,33,38,0,0,70,38,0,0,
  107,38,0,0,144,38,0,0,181,38,0,0,218,38,0,0,255,38,0,0,36,39,0,0,73,39,0,0,
  110,39,0,0,147,39,0,0,184,39,0,0,221,39,0,0,2,40,0,0,39,40,0,0,76,40,0,0,113,
  40,0,0,150,40,0,0,187,40,0,0,224,40,0,0,5,41,0,0,42,41,0,0,79,41,0,0,116,41,
  0,0,153,41,0,0,190,41,0,0,227,41,0,0,8,42,0,0,45,42,0,0,82,42,0,0,119,42,0,0,
  156,42,0,0,193,42,0,0,230,42,0,0,11,43,0,0,48,43,0,0,85,43,0,0,122,43,0,0,
  159,43,0,0,196,43,0,0,233,43,0,0,14,44,0,0,51,44,0,0,88,44,0,0,125,44,0,0,
  162,44,0,0,199,44,0,0,236,44,0,0,17,45,0,0,54,45,0,0,91,45,0,0,128,45,0,0,
  165,45,0,0,202,45,0,0,239,45,0,0,20,46,0,0,57,46,0,0,94,46,0,0,131,46,0,0,
  168,46,0,0,205,46,0,0,242,46,0,0,23,47,0,0,60,47,0,0,97,47,0,0,134,47,0,0,
  171,47,0,0,208,47,0,0,245,47,0,0,26,48,0,0,63,48,0,0,100,48,0,0,137,48,0,0,
  174,48,0,0,211,48,0,0,248,48,0,0,29,49,0,0,66,49,0,0,103,49,0,0,140,49,0,0,
  177,49,0,0,214,49,0,0,251,49,0,0,32,50,0,0,69,50,0,0,106,50,0,0,143,50,0,0,
  180,50,0,0,217,50,0,0,254,50,0,0,35,51,0,0,0,32,93,93,96,96,97,97,96,96,96,
  97,96,96,97,98,97,97,96,96,96,96,95,95,97,96,97,97,97,97,98,98,97,97,101,101,
  255,0,32,96,96,98,98,100,98,98,100,104,100,99,100,100,101,103,101,104,101,99,
  101,103,96,98,100,103,100,102,101,102,102,101,101,108,108,255,0,32,97,97,103,
  101,101,101,100,103,101,100,100,101,103,101,103,103,101,103,103,103,101,101,
  101,101,101,100,100,103,103,101,101,101,107,107,255,0,32,99,99,103,101,98,98,
  101,103,103,101,101,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
  101,103,103,101,103,103,103,108,108,255,0,32,97,97,103,101,103,103,101,101,
  103,104,103,103,103,103,103,103,103,101,103,103,101,101,103,103,103,103,103,
  103,104,103,103,101,109,109,255,0,32,98,98,103,103,103,104,104,103,101,101,
  100,103,103,103,103,103,104,103,103,103,103,103,103,103,101,103,103,103,101,
  103,103,103,108,108,255,0,32,98,98,103,103,103,103,103,104,104,103,103,104,
  104,103,103,103,104,103,103,101,103,101,103,103,103,103,101,103,103,103,103,
  104,109,109,255,0,32,99,99,105,104,104,103,103,103,103,103,103,103,104,102,
  103,102,101,102,102,103,101,101,101,102,104,103,104,104,101,102,104,102,109,
  109,255,0,32,100,100,104,105,105,105,104,104,106,106,103,105,104,106,105,106,
  106,104,104,104,103,103,102,104,106,104,92,90,88,104,104,104,111,111,255,0,
  32,100,100,106,105,107,105,106,104,104,105,102,104,104,105,107,105,105,106,
  105,105,106,104,106,106,104,94,92,90,88,5,104,104,109,109,255,0,32,100,100,
  105,104,104,105,104,104,104,105,106,105,104,105,105,105,104,104,103,104,101,
  104,102,102,96,94,92,111,111,5,108,107,109,109,255,0,32,100,100,104,105,107,
  104,104,104,104,104,104,104,104,105,105,101,104,105,104,102,101,101,102,102,
  96,111,92,5,104,104,105,105,109,109,255,0,32,101,101,105,105,102,105,105,107,
  104,105,104,106,106,107,105,106,106,104,104,103,105,105,106,106,96,94,92,90,
  88,105,104,104,111,111,255,0,32,100,100,105,106,105,105,105,105,108,104,106,
  105,105,105,105,108,104,106,106,104,102,104,104,104,104,94,92,90,88,6,106,
  105,111,111,255,0,32,99,99,105,105,107,106,106,102,105,101,105,106,105,105,
  106,105,105,105,105,105,105,104,104,104,104,111,111,111,111,5,104,108,109,
  109,255,0,32,99,99,104,103,105,105,106,106,103,104,104,104,104,105,105,107,
  106,106,102,102,102,101,104,104,103,94,92,90,88,105,107,107,109,109,255,0,32,
  97,97,104,103,101,104,104,104,103,105,104,103,104,104,103,105,105,106,106,
  106,106,101,101,104,96,94,92,90,88,5,105,105,5,5,255,0,32,99,99,101,103,103,
  101,103,102,104,104,101,102,101,104,103,101,104,104,104,104,104,108,105,102,
  101,94,92,111,111,111,103,104,111,111,255,0,32,100,100,106,104,104,104,103,
  105,104,101,101,104,104,101,103,103,101,103,102,102,102,104,104,105,104,103,
  92,90,108,109,110,110,109,109,255,0,32,100,100,104,104,102,105,104,104,105,
  105,104,105,105,106,104,104,104,103,105,105,105,102,104,105,107,94,92,5,6,
  108,108,107,109,109,255,0,32,100,100,105,105,105,105,106,106,104,104,102,105,
  105,104,104,102,105,104,104,104,104,103,108,108,96,94,92,90,88,104,102,105,
  109,109,255,0,32,97,97,101,104,102,104,104,104,105,105,106,105,105,105,105,
  105,105,106,106,106,106,104,105,108,108,94,92,90,88,111,105,105,109,109,255,
  0,32,101,101,107,102,104,102,104,103,104,104,104,101,101,101,104,102,104,104,
  104,104,104,107,106,108,105,108,6,5,5,5,107,105,109,109,255,0,32,100,100,106,
  105,105,105,105,106,106,106,104,105,102,102,102,104,102,104,103,103,103,103,
  104,101,104,94,92,90,88,107,107,105,5,5,255,0,32,95,95,99,98,102,101,103,101,
  102,98,96,98,101,98,98,100,99,98,101,97,97,99,98,102,96,94,92,90,88,111,100,
  104,107,107,255,0,32,96,96,99,99,103,100,103,101,103,96,98,101,98,98,100,99,
  103,101,100,97,99,99,99,103,100,94,92,111,5,5,98,102,104,104,255,0,32,97,97,
  100,100,100,98,101,104,110,101,98,100,99,98,99,98,100,98,100,101,101,100,100,
  100,98,101,92,90,110,102,98,101,108,108,255,0,32,97,97,104,100,100,101,103,
  101,104,101,106,102,100,99,98,100,101,98,100,101,101,104,100,100,101,94,92,
  111,111,101,103,97,108,108,255,0,32,98,98,105,105,104,104,101,103,101,104,
  102,100,99,99,100,99,101,101,104,102,103,105,105,104,96,94,92,90,88,101,99,
  103,109,109,255,0,32,98,98,103,103,103,104,104,103,103,103,100,103,103,103,
  103,103,103,103,103,103,103,103,103,103,103,94,92,90,88,111,103,103,107,107,
  255,0,32,98,98,103,103,103,103,103,103,104,103,103,103,103,103,101,103,103,
  103,103,100,103,101,103,103,103,103,111,111,111,111,103,104,108,108,255,0,32,
  98,98,103,103,103,103,103,103,103,103,103,103,103,103,103,101,100,101,101,
  103,100,100,100,103,104,94,92,90,101,101,103,101,108,108,255,0,32,99,99,103,
  103,103,103,104,104,104,104,103,103,103,104,103,104,104,103,103,103,103,103,
  103,103,96,94,92,90,88,103,103,103,109,109,255,0,32,98,98,104,103,105,103,
  104,103,103,103,101,103,103,103,105,103,103,104,103,103,104,103,104,104,95,
  111,111,5,88,111,103,103,109,109,255,0,32,99,99,102,103,103,104,104,101,102,
  102,102,101,103,105,104,104,104,104,105,104,107,104,105,106,96,6,105,105,88,
  6,108,105,109,109,255,0,32,98,98,101,102,103,104,103,101,102,103,103,104,104,
  103,104,105,104,104,104,103,104,105,104,101,96,111,104,105,88,5,105,105,107,
  107,255,0,32,96,96,102,102,103,103,103,102,103,103,101,103,104,103,104,102,
  103,103,104,103,104,102,103,104,96,94,92,90,88,111,103,105,105,105,255,0,32,
  96,96,100,102,101,99,101,100,101,101,101,100,98,99,100,101,100,100,98,99,100,
  101,100,101,101,94,92,90,111,111,102,101,106,106,255,0,32,97,97,101,98,98,
  100,101,101,101,101,100,98,99,98,98,100,98,99,100,101,101,99,100,100,101,101,
  111,109,109,100,100,99,107,107,255,0,32,96,96,101,99,101,101,101,99,98,98,
  100,98,100,100,99,99,99,98,98,100,98,98,100,104,102,101,101,100,101,100,100,
  100,107,107,255,0,32,95,95,99,100,101,101,99,100,100,101,100,100,101,103,101,
  101,100,100,99,99,98,97,101,100,101,101,101,101,102,102,101,101,107,107,255,
  0,32,96,96,98,98,100,98,98,100,104,100,99,100,100,101,103,101,104,101,99,101,
  103,96,98,100,103,100,102,101,102,102,101,101,108,108,255,0,32,97,97,103,101,
  101,101,100,103,101,100,100,101,103,101,103,103,101,103,103,103,101,101,101,
  101,101,100,100,103,103,101,101,101,107,107,255,0,32,99,99,103,101,98,98,101,
  103,103,101,101,103,103,103,103,103,103,103,103,103,103,103,103,103,103,101,
  103,103,101,103,103,103,108,108,255,0,32,97,97,103,101,103,103,101,101,103,
  104,103,103,103,103,103,103,103,101,103,103,101,101,103,103,103,103,103,103,
  104,103,103,101,109,109,255,0,32,98,98,103,103,103,104,104,103,101,101,100,
  103,103,103,103,103,104,103,103,103,103,103,103,103,101,103,103,103,101,103,
  103,103,108,108,255,0,32,107,107,111,111,111,111,111,5,5,111,111,5,5,111,111,
  111,5,111,111,111,111,111,111,111,111,111,111,111,111,111,111,5,109,109,255,
  0,32,102,102,105,104,104,103,103,103,103,103,103,103,104,102,103,102,101,102,
  102,103,101,101,101,102,104,103,104,104,101,102,104,102,109,109,255,0,32,94,
  94,96,96,96,96,96,96,96,96,95,96,96,96,96,96,96,96,96,96,95,95,95,96,96,96,
  95,96,96,96,96,96,109,109,255,0,32,100,100,106,105,107,105,106,104,104,105,
  102,104,104,105,107,105,105,106,105,105,106,104,106,106,104,105,106,108,108,
  106,104,104,109,109,255,0,32,100,100,104,105,105,104,104,105,105,105,105,105,
  104,105,105,105,104,105,105,103,103,103,103,103,103,103,105,107,104,105,105,
  105,109,109,255,0,32,100,100,105,105,104,105,104,105,104,104,104,105,105,105,
  104,105,105,104,104,103,105,104,104,104,104,103,104,104,103,105,104,105,108,
  108,255,0,32,99,99,103,105,104,104,103,103,104,103,104,104,104,104,103,104,
  104,104,103,103,103,103,103,103,103,103,104,104,103,105,105,105,109,109,255,
  0,32,98,98,103,101,107,105,105,103,103,103,104,104,104,103,104,104,103,103,
  103,103,103,104,104,103,103,103,103,103,103,103,103,103,109,109,255,0,32,98,
  98,103,103,103,103,103,104,103,104,103,103,103,103,104,104,104,104,103,103,
  103,103,103,103,103,103,103,103,104,104,104,104,109,109,255,0,32,98,98,103,
  104,103,103,100,103,103,103,103,103,103,103,103,103,103,103,103,103,101,101,
  103,103,96,94,92,90,88,101,103,104,108,108,255,0,32,99,99,103,103,103,104,
  103,101,101,101,103,103,103,103,103,103,103,100,101,101,100,103,103,103,96,
  94,92,90,88,111,103,104,107,107,255,0,32,98,98,103,103,104,103,105,104,102,
  102,102,102,102,101,100,102,105,104,102,101,101,101,105,102,103,111,92,111,
  111,111,101,102,107,107,255,0,32,99,99,103,102,102,101,101,101,99,101,101,
  101,102,101,102,100,101,101,102,100,98,101,101,102,102,101,92,111,103,102,
  102,101,105,105,255,0,32,100,100,102,102,102,103,101,102,102,103,103,102,101,
  102,101,101,102,102,100,100,100,102,101,102,99,101,92,111,101,102,105,101,
  108,108,255,0,32,98,98,103,103,103,103,105,105,103,103,104,102,102,102,102,
  102,101,102,101,101,101,101,101,101,96,94,92,90,88,102,103,99,108,108,255,0,
  32,98,98,103,103,103,103,104,105,105,103,105,104,106,106,106,106,105,102,104,
  105,101,101,104,105,95,94,92,90,88,5,102,102,108,108,255,0,32,99,99,103,101,
  105,105,104,104,104,104,104,104,104,102,103,102,102,101,101,101,104,101,102,
  102,102,111,111,111,111,111,103,102,109,109,255,0,32,99,99,105,104,104,104,
  101,104,102,103,103,103,104,102,103,102,101,102,102,103,101,101,101,102,104,
  94,92,90,101,102,104,102,109,109,255,0,32,100,100,104,105,105,105,104,104,
  106,106,103,105,104,106,105,106,106,104,104,104,103,103,102,104,96,94,92,90,
  88,104,104,104,111,111,255,0,32,100,100,106,105,107,105,106,104,104,105,102,
  104,104,105,107,105,105,106,105,105,106,104,106,106,95,5,92,6,88,5,104,104,
  109,109,255,0,32,97,97,101,103,102,103,102,102,102,103,102,102,103,104,103,
  104,102,102,103,103,102,104,108,107,96,6,92,5,88,5,104,107,109,109,255,0,32,
  98,98,103,102,103,103,102,102,103,102,103,103,104,104,103,103,103,104,104,
  104,104,105,105,105,96,5,92,5,88,111,104,105,5,5,255,0,32,99,99,102,102,102,
  102,101,103,102,101,103,103,103,104,103,104,103,105,105,105,103,101,103,101,
  96,6,92,6,88,5,105,105,111,111,255,0,32,100,100,104,104,104,103,104,104,105,
  105,102,104,104,107,105,105,109,106,105,105,105,108,108,107,109,6,108,6,109,
  6,108,110,111,111,255,0,32,100,100,104,105,108,104,103,104,104,104,104,105,
  106,105,106,108,108,105,105,107,108,109,108,106,105,106,92,90,88,109,108,108,
  111,111,255,0,32,97,97,99,104,104,105,102,104,104,105,105,105,104,102,104,
  103,101,106,106,107,107,108,108,108,109,94,92,90,88,6,108,108,111,111,255,0,
  32,97,97,104,104,103,104,101,102,101,104,105,104,104,103,104,104,104,105,105,
  105,104,107,109,108,96,94,92,6,6,6,107,107,5,5,255,0,32,97,97,104,104,102,
  104,104,104,104,104,104,104,101,101,105,104,105,105,105,105,107,109,109,109,
  95,6,92,5,105,105,107,108,111,111,255,0,32,101,101,104,104,105,105,104,104,
  103,105,105,105,104,104,104,104,105,106,107,108,109,108,107,109,96,94,92,90,
  88,108,110,109,111,111,255,0,32,100,100,107,104,103,103,109,108,105,104,105,
  105,105,105,106,105,105,108,108,108,108,105,108,106,106,94,92,90,88,6,109,
  107,5,5,255,0,32,100,100,105,105,105,105,108,104,105,105,105,105,105,106,105,
  106,106,105,108,106,106,106,108,109,107,109,6,6,6,6,107,108,111,111,255,0,32,
  100,100,104,105,105,105,104,104,108,106,105,105,105,105,106,107,108,108,107,
  107,106,108,106,108,95,94,92,90,88,109,109,109,111,111,255,0,32,98,98,101,
  104,105,105,98,105,107,105,106,108,106,105,106,107,107,106,106,106,106,105,
  107,107,96,94,92,90,88,6,106,108,110,110,255,0,32,100,100,105,106,108,103,
  101,108,105,105,106,106,106,106,105,107,106,107,109,109,109,108,109,108,107,
  6,6,6,88,6,109,108,109,109,255,0,32,99,99,104,104,102,101,104,106,104,104,
  104,104,104,104,102,106,104,106,106,104,104,106,106,104,104,106,109,109,88,
  111,106,106,107,107,255,0,32,101,101,104,104,104,102,104,104,104,106,106,104,
  106,104,104,104,104,104,106,106,106,104,106,104,95,106,106,106,106,111,102,
  104,108,108,255,0,32,97,97,104,103,101,101,100,100,101,101,101,106,104,101,
  104,103,103,103,101,104,104,104,101,104,96,111,103,104,103,103,101,101,107,
  107,255,0,32,99,99,106,104,104,103,103,106,103,106,103,103,104,104,103,103,
  101,101,101,101,100,104,103,103,96,94,92,90,88,103,103,103,107,107,255,0,32,
  96,96,100,100,101,103,101,100,101,100,100,100,104,100,100,100,103,103,101,
  100,103,100,101,103,96,94,92,90,88,111,101,101,109,109,255,0,32,98,98,104,
  101,103,100,101,100,103,101,101,103,101,104,101,103,104,100,103,104,103,106,
  106,101,95,111,111,111,111,111,103,101,109,109,255,0,32,98,98,101,103,104,
  103,103,103,103,104,104,104,106,103,103,103,103,103,104,106,106,106,106,106,
  96,5,106,104,106,104,104,104,110,110,255,0,32,100,100,110,108,106,106,106,
  106,107,107,105,105,108,106,105,104,104,103,104,105,104,105,104,107,109,6,
  105,105,105,106,106,105,110,110,255,0,32,100,100,106,106,106,105,105,105,105,
  105,107,106,105,105,105,101,103,104,103,104,106,105,105,105,96,94,92,90,88,
  105,105,106,109,109,255,0,32,100,100,106,106,109,110,103,99,104,104,104,105,
  104,104,105,101,101,108,105,104,103,104,101,106,95,94,92,90,88,111,105,106,
  109,109,255,0,32,99,99,105,105,105,106,105,105,104,104,104,105,104,101,107,
  108,101,105,101,104,104,104,104,104,105,5,92,111,111,5,105,105,109,109,255,0,
  32,97,97,103,104,102,103,104,103,104,105,104,104,105,104,101,104,103,98,98,
  104,105,104,105,106,105,104,92,111,102,104,104,105,109,109,255,0,32,98,98,
  104,104,104,104,101,101,102,101,103,101,102,104,104,104,105,108,105,103,105,
  104,104,104,105,104,92,111,102,104,105,105,109,109,255,0,32,98,98,105,104,
  105,105,104,104,102,102,102,105,102,104,103,104,104,104,101,101,101,102,104,
  104,95,94,92,90,88,105,104,104,109,109,255,0,32,100,100,105,103,104,105,105,
  104,103,103,102,102,104,104,105,105,103,102,104,102,104,104,104,102,96,94,92,
  90,88,111,104,105,109,109,255,0,32,100,100,105,101,104,105,106,104,101,102,
  103,104,101,102,105,105,105,105,101,105,101,101,104,101,99,111,111,111,111,
  111,104,105,108,108,255,0,32,99,99,105,104,104,105,105,104,104,104,102,102,
  103,101,105,105,105,104,105,103,106,106,101,104,103,103,101,104,103,104,104,
  104,109,109,255,0,32,99,99,104,104,101,104,103,101,101,100,102,104,101,104,
  105,103,101,104,104,101,105,106,103,101,103,102,105,105,104,104,104,102,109,
  109,255,0,32,99,99,102,103,103,104,104,101,102,102,102,101,103,105,104,104,
  104,104,105,104,107,104,105,106,108,107,105,105,107,108,108,105,109,109,255,
  0,32,98,98,101,102,103,104,103,101,102,103,103,104,104,103,104,105,104,104,
  104,103,104,105,104,101,105,102,104,105,105,106,105,105,107,107,255,0,32,96,
  96,102,102,103,103,103,102,103,103,101,103,104,103,104,102,103,103,104,103,
  104,102,103,104,104,105,105,105,105,102,103,105,105,105,255,0,32,96,96,100,
  102,101,99,101,100,101,101,101,100,98,99,100,101,100,100,98,99,100,101,100,
  101,101,101,104,104,101,101,102,101,106,106,255,0,32,97,97,101,98,98,100,101,
  101,101,101,100,98,99,98,98,100,98,99,100,101,101,99,100,100,101,101,101,100,
  100,100,100,99,107,107,255,0,32,96,96,101,99,101,101,101,99,98,98,100,98,100,
  100,99,99,99,98,98,100,98,98,100,104,102,101,101,100,101,100,100,100,107,107,
  255,0,32,109,109,109,110,111,111,109,110,110,111,110,110,111,111,111,111,110,
  110,109,109,109,109,111,110,111,111,111,111,111,111,111,111,107,107,255,0,32,
  98,98,98,98,100,98,98,100,104,100,99,100,100,101,103,101,104,101,99,101,103,
  96,98,100,103,100,102,101,102,102,101,101,108,108,255,0,32,88,88,93,95,93,95,
  94,95,95,94,94,95,95,95,95,95,95,95,95,95,95,95,95,95,95,94,94,95,95,95,95,
  95,107,107,255,0,32,93,93,101,103,100,100,103,100,101,101,101,101,103,103,
  101,100,101,101,103,100,103,101,101,101,101,101,100,103,103,103,103,100,108,
  108,255,0,32,97,97,101,100,100,101,104,105,101,103,101,103,101,101,101,105,
  101,101,101,103,100,101,103,101,103,103,103,103,103,100,103,103,109,109,255,
  0,32,98,98,103,103,103,103,103,103,103,103,103,101,101,101,103,103,103,103,
  101,101,103,101,103,103,103,103,103,101,103,103,103,103,108,108,255,0,32,98,
  98,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
  103,103,103,103,104,94,92,90,88,102,103,103,109,109,255,0,32,99,99,106,105,
  105,105,104,105,105,102,104,103,103,103,104,105,105,104,105,105,106,105,105,
  103,96,94,92,90,88,5,105,103,109,109,255,0,32,100,100,101,105,103,105,104,
  101,103,104,105,104,104,105,106,108,107,107,105,106,105,105,105,105,95,5,92,
  6,5,5,105,105,109,109,255,0,32,100,100,106,108,105,105,105,105,104,104,105,
  105,105,106,104,105,104,105,107,105,105,108,105,105,96,6,92,5,105,105,105,
  105,109,109,255,0,32,100,100,105,106,106,106,105,105,104,104,105,104,105,105,
  106,105,105,105,105,106,105,105,105,106,96,5,92,5,107,107,105,106,109,109,
  255,0,32,100,100,101,104,104,104,104,106,106,104,106,103,105,105,104,105,108,
  105,105,105,103,105,106,105,96,6,92,6,107,105,106,105,109,109,255,0,32,101,
  101,106,104,104,106,104,104,105,105,104,105,106,105,104,105,104,108,103,105,
  105,105,104,104,109,6,108,6,105,105,104,104,109,109,255,0,32,100,100,103,101,
  102,105,106,106,107,104,105,103,104,104,106,105,105,105,107,106,105,105,101,
  105,96,101,92,90,88,102,101,105,110,110,255,0,32,99,99,104,103,104,103,105,
  104,103,104,104,103,103,105,106,105,104,104,101,104,104,103,104,104,96,111,
  92,90,88,111,104,104,109,109,255,0,32,99,99,103,103,102,103,102,103,103,102,
  105,104,104,104,104,105,105,104,104,104,104,103,105,104,95,111,92,111,111,
  111,105,104,108,108,255,0,32,97,97,102,101,102,105,101,101,101,101,102,102,
  102,104,104,103,104,107,107,106,101,104,104,101,96,111,92,111,104,105,104,
  101,108,108,255,0,32,99,99,101,101,101,102,101,101,102,102,104,104,104,105,
  105,105,104,104,104,104,105,104,101,101,96,94,92,90,88,102,101,101,109,109,
  255,0,32,100,100,103,103,106,105,107,105,106,103,104,104,101,101,102,102,103,
  104,105,104,105,105,105,104,104,94,111,90,88,111,105,104,109,109,255,0,32,
  100,100,103,101,104,104,102,103,102,104,105,105,105,103,101,102,105,105,104,
  105,103,104,104,102,106,104,111,105,111,111,104,102,109,109,255,0,32,100,100,
  107,108,107,106,105,104,101,102,101,104,105,107,105,103,103,104,105,101,102,
  105,105,106,105,106,92,90,88,109,105,106,109,109,255,0,32,97,97,103,103,103,
  101,103,104,106,106,104,104,103,101,105,104,105,105,102,102,104,104,104,104,
  109,94,92,90,88,6,104,104,107,107,255,0,32,101,101,101,101,100,101,101,101,
  101,101,103,104,105,106,105,105,104,105,106,107,106,106,106,104,96,94,92,6,6,
  6,106,104,109,109,255,0,32,100,100,105,105,104,102,103,103,101,101,104,102,
  101,102,101,101,102,104,104,105,104,106,108,106,95,6,92,5,105,105,108,106,
  109,109,255,0,32,99,99,105,105,104,106,106,106,105,105,104,102,103,101,102,
  103,104,105,101,102,105,104,102,104,96,94,92,90,88,108,102,104,109,109,255,0,
  32,99,99,104,104,104,104,105,104,105,106,105,105,105,105,105,106,105,104,106,
  108,105,105,105,106,106,94,92,90,88,6,105,106,109,109,255,0,32,98,98,101,102,
  103,102,103,101,102,102,103,103,103,103,104,103,103,104,104,104,104,105,104,
  105,107,109,6,6,6,6,101,101,109,109,255,0,32,98,98,103,102,102,101,102,102,
  103,101,103,103,103,102,102,102,104,104,103,104,104,104,103,103,103,94,92,90,
  104,105,101,103,108,108,255,0,32,100,100,103,104,103,105,104,103,103,102,101,
  103,103,104,105,105,103,104,104,104,104,104,104,103,96,94,92,90,88,105,105,
  104,109,109,255,0,32,101,101,105,105,105,105,105,105,105,106,105,104,105,108,
  109,108,107,106,107,106,108,108,107,106,95,111,111,111,88,5,108,106,110,110,
  255,0,32,100,100,104,105,107,108,105,105,108,106,105,107,108,108,109,105,105,
  105,103,106,105,105,105,105,96,111,105,105,88,111,105,105,110,110,255,0,32,
  102,102,104,105,105,104,103,105,105,103,104,107,110,107,105,106,105,105,105,
  106,105,106,105,102,96,111,92,103,88,111,106,108,5,5,255,0,32,101,101,104,
  104,103,103,103,106,107,105,105,105,109,106,102,108,106,106,107,105,105,106,
  106,104,96,111,92,90,88,111,105,108,111,111,255,0,32,100,100,105,105,105,106,
  105,104,105,104,104,105,106,110,102,104,106,106,105,103,105,107,106,107,101,
  111,92,90,111,111,106,107,5,5,255,0,32,99,99,107,109,105,105,101,104,104,103,
  104,105,105,108,105,104,104,106,105,104,104,107,106,105,103,103,111,111,111,
  104,106,106,5,5,255,0,32,99,99,101,105,99,101,105,104,102,104,104,104,105,
  105,102,101,101,101,103,105,104,105,105,106,105,105,104,107,106,105,107,105,
  5,5,255,0,32,101,101,109,106,104,105,105,105,105,106,105,105,104,107,106,105,
  107,105,108,106,105,105,105,105,105,105,102,105,105,105,106,106,5,5,255,0,32,
  98,98,105,102,105,105,105,105,105,105,102,105,105,105,106,106,105,104,105,
  109,108,105,108,105,104,105,107,109,110,109,109,110,5,5,255,0,32,92,92,98,98,
  98,99,99,99,99,99,98,99,99,99,99,99,99,99,99,100,100,99,100,99,99,99,99,100,
  101,100,100,101,5,5,255,0,32,93,93,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
  7,7,7,7,7,7,7,7,7,7,7,255,0,32,93,93,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,255,0,32,91,91,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,32,91,91,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,32,91,91,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,32,91,91,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,32,91,91,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,32,91,91,7,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,32,91,91,7,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,32,91,91,7,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,32,91,91,7,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,32,91,91,7,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,32,91,91,7,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,32,91,91,7,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,32,91,91,7,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,32,91,91,7,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,32,91,91,7,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,32,91,91,7,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,32,91,91,7,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,32,91,91,7,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,32,91,91,7,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,32,91,91,
  7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,32,91,
  91,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,32,
  91,91,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,0,
  32,91,91,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,255,
  0,32,91,91,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  255,0,32,91,91,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,255,0,32,91,91,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,255,0,32,91,91,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,255,0,32,91,91,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,255,0,32,91,91,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,255,0,32,91,91,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,255,0,32,93,93,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,255,0,32,91,91,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,255,0,32,91,91,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
  7,7,7,7,7,7,7,7,7,255,0,32,92,92,94,95,96,96,96,96,95,95,96,96,96,96,96,96,
  96,95,95,96,97,96,95,96,96,96,96,95,94,96,96,96,107,107,255,0,32,94,94,103,
  102,104,104,101,101,101,102,104,101,103,100,102,103,101,103,104,103,105,103,
  102,104,104,101,101,101,101,103,104,104,109,109,255,0,32,94,94,103,101,103,
  102,104,103,100,105,102,104,101,102,102,104,104,103,99,101,102,103,101,103,
  102,104,103,100,102,103,104,101,107,107,255,0,32,96,96,99,97,101,99,98,101,
  98,98,100,102,101,100,98,98,103,107,105,105,103,100,103,101,99,98,101,98,101,
  104,104,104,108,108,255,0,32,97,97,99,99,97,97,97,98,101,99,100,101,100,100,
  98,103,103,99,100,100,98,100,100,96,97,97,98,101,102,104,104,101,109,109,255,
  0,32,97,97,100,99,99,97,97,101,103,99,98,98,99,100,98,101,98,100,100,101,101,
  100,99,99,99,97,101,103,101,98,103,103,108,108,255,0,32,95,95,99,98,102,101,
  103,101,102,98,96,98,101,98,98,100,99,98,101,97,97,99,98,102,101,103,101,102,
  105,104,100,104,107,107,255,0,32,96,96,99,99,103,100,103,101,103,96,98,101,
  98,98,100,99,103,101,100,97,99,99,99,103,100,103,101,103,105,105,98,102,104,
  104,255,0,32,97,97,100,100,100,98,101,104,110,101,98,100,99,98,99,98,100,98,
  100,101,101,100,100,100,98,101,104,110,110,102,98,101,108,108,255,0,32,97,97,
  104,100,100,101,103,101,104,101,106,102,100,99,98,100,101,98,100,101,101,104,
  100,100,101,103,104,101,104,101,103,97,108,108,255,0,32,98,98,105,105,104,
  104,101,103,101,104,102,100,99,99,100,99,101,101,104,102,103,105,105,104,104,
  101,92,90,88,101,99,103,109,109,255,0,32,98,98,103,103,103,104,104,103,103,
  103,100,103,103,103,103,103,103,103,103,103,103,103,103,103,103,94,92,90,88,
  111,103,103,107,107,255,0,32,98,98,103,103,103,103,103,103,104,103,103,103,
  103,103,101,103,103,103,103,100,103,101,103,103,96,94,92,111,111,111,103,104,
  108,108,255,0,32,98,98,103,103,103,103,103,103,103,103,103,103,103,103,103,
  101,100,101,101,103,100,100,100,103,96,111,92,111,101,101,103,101,108,108,
  255,0,32,99,99,103,103,103,103,104,104,104,104,103,103,103,104,103,104,104,
  103,103,103,103,103,103,103,95,94,92,90,88,103,103,103,109,109,255,0,32,98,
  98,104,103,105,103,104,103,103,103,101,103,103,103,105,103,103,104,103,103,
  104,103,104,104,103,94,92,90,88,111,103,103,109,109,255,0,32,99,99,102,103,
  103,104,104,101,102,102,102,101,103,105,104,104,104,104,105,104,107,104,105,
  106,108,107,5,5,6,6,108,105,109,109,255,0,32,98,98,101,102,103,104,103,101,
  102,103,103,104,104,103,104,105,104,104,104,103,104,105,104,101,96,102,92,90,
  88,106,105,105,107,107,255,0,32,96,96,102,102,103,103,103,102,103,103,101,
  103,104,103,104,102,103,103,104,103,104,102,103,104,95,5,92,90,88,111,103,
  105,105,105,255,0,32,96,96,100,102,101,99,101,100,101,101,101,100,98,99,100,
  101,100,100,98,99,100,101,100,101,96,111,92,111,111,111,102,101,106,106,255,
  0,32,97,97,101,98,98,100,101,101,101,101,100,98,99,98,98,100,98,99,100,101,
  101,99,100,100,96,111,92,109,100,100,100,99,107,107,255,0,32,96,96,101,99,
  101,101,101,99,98,98,100,98,100,100,99,99,99,98,98,100,98,98,100,104,96,94,
  92,90,88,100,100,100,107,107,255,0,32,95,95,99,100,101,101,99,100,100,101,
  100,100,101,103,101,101,100,100,99,99,98,97,101,100,101,94,111,90,88,111,101,
  101,107,107,255,0,32,96,96,98,98,100,98,98,100,104,100,99,100,100,101,103,
  101,104,101,99,101,103,96,98,100,103,100,111,101,111,111,101,101,108,108,255,
  0,32,97,97,103,101,101,101,100,103,101,100,100,101,103,101,103,103,101,103,
  103,103,101,101,101,101,101,94,92,90,88,101,101,101,107,107,255,0,32,99,99,
  103,101,98,98,101,103,103,101,101,103,103,103,103,103,103,103,103,103,103,
  103,103,103,96,94,92,90,88,111,103,103,108,108,255,0,32,97,97,103,101,103,
  103,101,101,103,104,103,103,103,103,103,103,103,101,103,103,101,101,103,103,
  103,94,92,111,111,111,103,101,109,109,255,0,32,98,98,103,103,103,104,104,103,
  101,101,100,103,103,103,103,103,104,103,103,103,103,103,103,103,101,103,92,
  90,101,103,103,103,108,108,255,0,32,98,98,103,103,103,103,103,104,104,103,
  103,104,104,103,103,103,104,103,103,101,103,101,103,103,103,94,92,111,111,
  103,103,104,109,109,255,0,32,99,99,105,104,104,103,103,103,103,103,103,103,
  104,102,103,102,101,102,102,103,101,101,101,102,96,94,92,90,88,102,104,102,
  109,109,255,0,32,100,100,104,105,105,105,104,104,106,106,103,105,104,106,105,
  106,106,104,104,104,103,103,102,104,106,94,92,90,88,111,104,104,109,109,255,
  0,32,100,100,106,105,107,105,106,104,104,105,102,104,104,105,107,105,105,106,
  105,105,106,104,106,106,104,105,5,6,6,5,104,104,109,109,255,0,32,100,100,104,
  105,105,104,104,105,105,105,105,105,104,105,105,105,104,105,105,103,103,103,
  103,103,103,94,92,90,104,105,105,105,109,109,255,0,32,100,100,105,105,104,
  105,104,105,104,104,104,105,105,105,104,105,105,104,104,103,105,104,104,104,
  96,94,92,90,88,105,104,105,108,108,255,0,32,99,99,103,105,104,104,103,103,
  104,103,104,104,104,104,103,104,104,104,103,103,103,103,103,103,95,111,111,
  111,88,5,105,105,109,109,255,0,32,98,98,103,101,107,105,105,103,103,103,104,
  104,104,103,104,104,103,103,103,103,103,104,104,103,96,111,103,103,88,111,
  103,103,109,109,255,0,32,98,98,103,103,103,103,103,104,103,104,103,103,103,
  103,104,104,104,104,103,103,103,103,103,103,96,111,103,103,88,111,104,104,
  109,109,255,0,32,98,98,103,104,103,103,100,103,103,103,103,103,103,103,103,
  103,103,103,103,103,101,101,103,103,96,94,92,90,88,111,103,104,108,108,255,0,
  32,99,99,103,103,103,104,103,101,101,101,103,103,103,103,103,103,103,100,101,
  101,100,103,103,103,101,94,92,90,111,111,103,104,107,107,255,0,32,98,98,103,
  103,104,103,105,104,102,102,102,102,102,101,100,102,105,104,102,101,101,101,
  105,102,103,103,111,111,111,104,101,102,107,107,255,0,32,99,99,103,102,102,
  101,101,101,99,101,101,101,102,101,102,100,101,101,102,100,98,101,101,102,96,
  101,92,90,88,102,102,101,105,105,255,0,32,100,100,102,102,102,103,101,102,
  102,103,103,102,101,102,101,101,102,102,100,100,100,102,101,102,96,111,92,90,
  88,111,105,101,108,108,255,0,32,98,98,103,103,103,103,105,105,103,103,104,
  102,102,102,102,102,101,102,101,101,101,101,101,101,95,111,92,111,111,111,
  103,99,108,108,255,0,32,98,98,103,103,103,103,104,105,105,103,105,104,106,
  106,106,106,105,102,104,105,101,101,104,105,96,111,92,111,104,105,102,102,
  108,108,255,0,32,99,99,103,101,105,105,104,104,104,104,104,104,104,102,103,
  102,102,101,101,101,104,101,102,102,96,94,92,90,88,102,103,102,109,109,255,0,
  32,99,99,105,104,104,104,101,104,102,103,103,103,104,102,103,102,101,102,102,
  103,101,101,101,102,104,94,111,90,88,111,104,102,109,109,255,0,32,100,100,
  104,105,105,105,104,104,106,106,103,105,104,106,105,106,106,104,104,104,103,
  103,102,104,106,104,111,105,111,111,104,104,111,111,255,0,32,100,100,106,105,
  107,105,106,104,104,105,102,104,104,105,107,105,105,106,105,105,106,104,106,
  106,104,105,106,108,108,106,104,104,109,109,255,0,32,97,97,101,103,102,103,
  102,102,102,103,102,102,103,104,103,104,102,102,103,103,102,104,108,107,107,
  107,105,105,105,105,104,107,109,109,255,0,32,98,98,103,102,103,103,102,102,
  103,102,103,103,104,104,103,103,103,104,104,104,104,105,105,105,107,105,105,
  105,104,102,104,105,5,5,255,0,32,99,99,102,102,102,102,101,103,102,101,103,
  103,103,104,103,104,103,105,105,105,103,101,103,101,105,107,105,107,107,105,
  105,105,111,111,255,0,32,99,99,102,102,102,102,101,103,102,101,103,103,103,
  104,103,104,103,105,105,105,103,101,103,101,105,107,105,107,107,105,105,105,
  111,111,255,0,32,100,100,104,104,104,103,104,104,105,105,102,104,104,107,105,
  105,109,106,105,105,105,108,108,107,109,110,108,109,109,110,108,110,111,111,
  255,0,32,100,100,104,105,108,104,103,104,104,104,104,105,106,105,106,108,108,
  105,105,107,108,109,108,106,105,106,109,108,109,109,108,108,111,111,255,0,32,
  97,97,99,104,104,105,102,104,104,105,105,105,104,102,104,103,101,106,106,107,
  107,108,108,108,109,108,109,108,108,108,108,108,111,111,255,0,32,97,97,104,
  104,103,104,101,102,101,104,105,104,104,103,104,104,104,105,105,105,104,107,
  109,108,109,109,109,108,108,107,107,107,5,5,255,0,32,97,97,104,104,102,104,
  104,104,104,104,104,104,101,101,105,104,105,105,105,105,107,109,109,109,109,
  109,109,106,105,105,107,108,111,111,255,0,32,109,109,5,5,5,5,5,5,111,5,5,5,5,
  5,5,5,5,5,6,6,6,6,6,6,5,5,5,5,6,6,6,6,6,6,255,0,32,104,104,104,104,103,103,
  105,105,105,104,105,105,105,105,106,105,105,108,108,108,108,105,108,106,106,
  106,108,108,110,110,109,107,5,5,255,0,32,108,108,105,96,100,100,100,101,99,
  100,100,102,105,96,100,100,100,100,101,100,100,110,108,102,101,102,102,102,
  102,101,101,111,111,111,255,0,32,104,104,104,100,105,105,105,104,104,108,106,
  109,105,100,106,107,108,108,107,107,106,111,106,101,108,106,108,109,109,109,
  109,5,111,111,255,0,32,101,101,101,99,105,105,105,98,105,107,105,5,106,100,
  106,107,107,106,106,106,106,109,107,101,107,109,109,110,109,109,106,111,110,
  110,255,0,32,101,101,105,100,108,103,103,101,108,105,105,5,106,100,105,107,
  106,107,109,109,109,111,109,101,107,107,107,108,107,107,109,111,109,109,255,
  0,32,104,104,104,99,104,102,102,104,104,104,106,5,106,99,104,104,104,104,106,
  106,106,109,106,99,104,106,106,106,106,104,102,109,108,108,255,0,32,100,100,
  104,98,101,101,101,100,100,101,101,111,104,97,104,103,103,103,101,104,104,
  109,101,99,104,103,103,104,103,103,101,107,107,107,255,0,32,103,103,106,99,
  104,103,103,103,106,103,106,111,104,99,103,103,101,101,101,101,100,109,103,
  98,103,103,103,104,103,103,103,108,107,107,255,0,32,101,101,100,96,101,103,
  103,101,100,101,100,110,104,96,100,100,103,103,101,100,103,106,101,98,102,
  103,104,103,103,103,101,107,109,109,255,0,32,101,101,104,97,103,100,100,101,
  100,103,101,111,108,99,101,103,104,100,103,104,103,110,106,97,100,103,104,
  104,103,103,103,107,109,109,255,0,32,103,103,101,98,104,103,103,103,103,103,
  104,5,106,98,103,103,103,103,104,106,106,110,106,100,3,106,106,104,106,104,
  104,109,110,110,255,0,32,106,106,110,107,110,110,110,110,110,111,111,5,108,
  110,5,5,5,111,5,5,5,109,104,6,6,6,5,5,5,5,5,5,110,110,255,0,32,105,105,106,
  106,106,105,105,105,105,105,107,106,105,105,105,101,103,104,103,104,106,105,
  105,105,109,104,106,106,105,105,105,106,109,109,255,0,32,94,94,96,96,98,98,
  95,94,96,96,96,96,96,96,96,95,95,97,96,96,95,96,95,96,96,96,96,96,96,96,96,
  96,109,109,255,0,32,99,99,105,105,105,106,105,105,104,104,104,105,104,101,
  107,108,101,105,101,104,104,104,104,104,105,105,101,102,102,105,105,105,109,
  109,255,0,32,97,97,103,104,102,103,104,103,104,105,104,104,105,104,101,104,
  103,98,98,104,105,104,105,106,105,104,104,104,102,104,104,105,109,109,255,0,
  32,98,98,104,104,104,104,101,101,102,101,103,101,102,104,104,104,105,107,103,
  105,103,105,105,103,105,104,104,104,102,104,105,105,109,109,255,0,32,98,98,
  105,104,105,105,104,104,102,102,102,105,102,104,103,104,104,103,103,101,103,
  104,102,104,102,104,105,103,102,105,104,104,109,109,255,0,32,100,100,105,103,
  104,105,95,94,92,90,88,102,104,94,105,105,88,104,95,94,92,90,88,105,104,94,
  92,90,104,104,104,105,109,109,255,0,32,100,100,105,101,104,105,96,111,92,111,
  88,104,96,111,92,105,88,104,95,111,92,111,111,103,96,5,111,111,88,104,104,
  105,108,108,255,0,32,99,99,105,104,104,105,96,104,92,104,88,102,96,101,92,
  105,88,101,95,101,92,101,102,104,96,103,106,106,88,104,104,104,109,109,255,0,
  32,99,99,104,104,101,104,111,94,111,90,111,104,96,104,5,90,111,104,107,94,
  109,90,88,101,95,101,105,106,88,104,104,102,109,109,255,0,32,99,99,102,103,
  103,104,104,111,102,111,102,101,111,105,104,111,104,104,101,110,104,111,111,
  104,5,104,107,104,5,108,108,105,109,109,255,0,32,98,98,101,102,103,104,96,94,
  92,90,103,104,96,94,92,90,88,102,104,94,92,90,104,101,96,94,92,90,88,106,105,
  105,107,107,255,0,32,96,96,102,102,103,103,111,111,111,111,88,103,111,111,92,
  111,111,105,96,5,111,111,88,104,96,111,92,111,88,102,103,105,105,105,255,0,
  32,96,96,100,102,101,99,101,100,101,101,88,100,98,99,92,101,100,101,95,101,
  101,100,88,100,95,99,109,101,88,101,102,101,106,106,255,0,32,97,97,101,98,98,
  100,95,94,92,90,109,98,95,94,92,90,88,100,111,98,99,100,111,100,109,101,101,
  99,109,100,100,99,107,107,255,0,32,96,96,101,99,101,101,111,109,109,109,100,
  98,109,109,109,109,109,100,96,94,92,90,88,100,96,94,92,90,88,100,100,100,107,
  107,255,0,32,95,95,99,100,101,101,96,94,92,90,88,100,96,94,92,90,88,101,111,
  111,92,111,111,101,109,109,109,109,88,102,101,101,107,107,255,0,32,96,96,98,
  98,100,98,109,109,111,109,88,100,96,111,92,111,88,98,98,94,111,90,98,98,99,
  101,103,96,88,102,101,101,108,108,255,0,32,97,97,103,101,101,101,100,103,101,
  100,88,101,95,101,111,103,88,101,96,111,101,111,88,101,103,103,101,101,111,
  101,101,101,107,107,255,0,32,99,99,103,101,98,98,101,103,103,101,111,103,111,
  103,103,103,111,103,111,101,101,101,111,101,96,94,92,90,88,103,103,103,108,
  108,255,0,32,97,97,103,101,103,103,96,94,92,90,88,103,96,94,92,90,88,101,93,
  100,101,103,101,103,111,111,111,111,88,103,103,101,109,109,255,0,32,98,98,
  103,103,103,104,111,111,111,111,88,103,111,111,111,111,88,101,96,94,92,90,88,
  103,103,103,103,103,88,103,103,103,108,108,255,0,32,98,98,103,103,103,103,
  103,104,104,103,88,104,104,103,103,103,88,103,96,110,110,110,110,103,103,101,
  103,101,111,103,103,104,109,109,255,0,32,99,99,105,104,104,103,103,103,103,
  103,111,103,104,102,103,102,111,105,110,106,105,105,103,105,105,104,105,106,
  105,102,104,102,109,109,255,0,32,100,100,104,105,105,105,104,104,106,106,103,
  105,104,106,105,106,106,105,106,105,105,105,105,106,106,104,103,105,104,104,
  104,104,111,111,255,0,32,100,100,106,105,107,105,106,104,104,105,102,104,104,
  105,107,105,105,107,105,105,108,105,105,104,104,105,106,108,108,106,104,104,
  109,109,255,0,32,100,100,105,104,104,105,104,104,104,105,106,105,104,105,105,
  105,104,105,106,105,105,105,106,105,104,104,105,103,104,105,108,107,109,109,
  255,0,32,100,100,104,105,107,104,104,104,104,104,104,104,104,105,105,101,104,
  105,104,102,101,101,102,102,101,101,104,105,104,104,105,105,109,109,255,0,32,
  101,101,105,105,102,105,105,107,104,105,104,106,106,107,105,106,106,104,104,
  103,105,105,106,106,104,104,105,104,104,105,104,104,111,111,255,0,32,100,100,
  105,106,105,105,105,105,108,104,106,105,105,105,105,108,104,106,106,104,102,
  104,104,104,104,105,106,107,105,107,106,105,111,111,255,0,32,99,99,105,105,
  107,106,106,102,105,101,105,106,105,105,106,105,105,105,105,105,105,104,104,
  104,104,103,104,104,103,105,104,108,109,109,255,0,32,99,99,104,103,105,105,
  106,106,103,104,104,104,104,105,105,107,106,106,102,102,102,101,104,104,103,
  99,103,104,105,105,107,107,109,109,255,0,32,97,97,104,103,101,104,104,104,
  103,105,104,103,104,104,103,105,105,106,106,106,106,101,101,104,106,107,105,
  106,105,105,105,105,5,5,255,0,32,99,99,101,103,103,101,103,102,104,104,101,
  102,101,104,103,101,104,104,104,104,104,108,105,102,101,103,101,103,102,103,
  103,104,111,111,255,0,32,100,100,106,104,104,104,103,105,104,101,101,104,104,
  101,103,103,101,103,102,102,102,104,104,105,104,103,107,108,108,109,110,110,
  109,109,255,0,32,100,100,104,104,102,105,104,104,105,105,104,105,105,106,104,
  104,104,103,105,105,105,102,104,105,107,109,107,105,108,108,108,107,109,109,
  255,0,32,100,100,105,105,105,105,106,106,104,104,102,105,105,104,104,102,105,
  104,104,104,104,103,108,108,107,105,102,103,103,104,102,105,109,109,255,0,32,
  97,97,101,104,102,104,104,104,105,105,106,105,105,105,105,105,105,106,106,
  106,106,104,105,108,108,105,105,104,103,104,105,105,109,109,255,0,32,101,101,
  107,102,104,102,104,103,104,104,104,101,101,101,104,102,104,104,104,104,104,
  107,106,108,105,108,109,105,105,105,107,105,109,109,255,0,32,100,100,106,105,
  105,105,105,106,106,106,104,105,102,102,102,104,102,104,103,103,103,103,104,
  101,104,104,104,105,105,107,107,105,5,5,255,0,32,99,99,105,106,105,105,104,
  105,106,108,106,105,106,106,105,105,105,105,106,106,106,106,106,106,105,104,
  105,105,106,105,105,104,109,109,255,0,32,99,99,104,104,104,105,104,104,104,
  102,104,105,104,105,106,105,105,104,105,105,105,107,105,106,107,108,105,106,
  106,105,105,109,10,10,255,0,32,98,98,103,103,103,104,104,103,103,102,104,103,
  103,104,104,104,104,104,104,104,103,103,105,107,107,107,107,105,107,159,107,
  105,111,111,255,0,32,98,98,103,103,105,105,105,105,104,105,105,104,107,105,
  105,105,104,157,105,105,104,104,107,105,107,107,107,107,109,107,107,158,5,5,
  255,0,32,100,100,105,104,105,105,105,159,110,107,88,105,105,107,107,105,88,
  105,103,105,107,104,88,105,103,105,107,107,88,107,105,107,5,5,255,0,32,101,
  101,109,109,106,107,109,109,108,90,6,109,110,108,109,90,6,106,107,107,109,90,
  6,108,108,110,110,90,127,109,110,109,5,5,255,0,32,100,100,106,108,109,106,
  106,106,92,6,109,109,108,110,92,6,106,106,109,109,92,6,109,110,109,110,92,6,
  109,109,110,109,5,5,255,0,32,102,102,107,109,109,106,106,94,6,109,109,109,
  109,94,6,109,109,106,109,94,6,110,110,110,109,94,6,109,109,109,110,110,5,5,
  255,0,32,101,101,106,106,109,106,96,6,108,109,109,107,96,6,106,102,109,109,
  96,6,109,109,109,106,95,6,109,110,110,109,109,110,5,5,255,0,32,106,106,108,
  109,106,106,5,105,106,107,107,107,6,106,103,101,108,108,6,107,108,107,105,
  104,5,107,108,110,110,109,109,110,5,5,255,0,32,104,104,109,109,108,105,105,
  106,105,106,106,108,108,106,108,106,108,106,107,107,107,107,108,106,108,109,
  109,109,109,109,110,110,5,5,255,0,32,99,99,109,106,104,105,105,106,105,105,
  104,107,106,105,107,105,108,106,107,105,107,107,108,108,108,109,110,109,106,
  109,107,109,5,5,255,0,32,101,101,105,102,105,105,105,105,105,105,102,105,105,
  105,106,106,105,104,105,109,108,105,108,105,104,105,107,109,110,109,109,110,
  5,5,255,0,32,98,98,104,102,104,105,106,105,104,104,104,105,105,106,105,105,
  105,108,109,110,105,105,105,105,105,105,106,109,108,109,110,110,5,5,255,0,32,
  100,100,102,102,104,105,105,104,104,104,105,105,105,105,106,105,105,108,108,
  107,107,108,108,109,108,108,109,110,109,110,109,110,110,110,255,0,32,99,99,
  102,104,105,105,105,104,104,101,104,105,106,105,105,106,105,107,107,107,107,
  108,110,109,108,109,109,110,110,110,109,110,109,109,255,0,32,98,98,102,102,
  102,102,104,102,106,104,102,104,104,104,106,104,104,104,104,104,106,104,104,
  104,104,106,108,110,110,106,104,106,5,5,255,0,32,99,99,106,102,102,101,104,
  104,106,104,106,101,102,106,104,104,106,104,104,104,104,106,106,106,106,106,
  106,106,106,106,104,104,5,5,255,0,32,100,100,106,105,104,105,104,105,104,106,
  105,105,105,107,107,105,105,105,106,106,106,106,106,106,107,108,106,106,106,
  107,106,109,111,111,255,0,32,99,99,105,105,104,104,108,104,101,105,105,104,
  104,107,107,106,105,105,105,106,108,108,107,109,108,109,109,107,107,107,107,
  109,111,111,255,0,32,100,100,103,101,103,104,105,105,104,104,107,107,104,105,
  107,106,105,107,108,109,108,106,108,123,108,106,109,109,108,106,107,107,5,5,
  255,0,32,100,100,102,104,104,105,106,106,106,105,105,105,106,107,104,105,108,
  105,105,106,107,108,108,109,108,106,107,108,107,109,109,108,111,111,255,0,32,
  101,101,104,104,105,104,105,105,105,103,105,105,105,108,105,105,107,109,106,
  105,106,108,107,107,105,109,109,108,108,107,108,109,5,5,255,0,32,95,95,100,
  102,103,101,101,103,105,102,105,105,104,104,105,106,105,107,108,106,105,105,
  105,105,106,108,106,107,109,110,109,108,111,111,255,0,32,97,97,102,102,102,
  102,105,103,102,101,102,104,104,105,105,105,105,105,105,104,105,105,104,105,
  106,109,109,108,108,108,109,109,111,111,255,0,32,98,98,103,103,104,103,105,
  104,102,103,104,102,104,105,104,105,104,106,105,106,105,106,106,105,106,105,
  107,109,107,106,108,108,111,111,255,0,32,98,98,104,104,104,102,101,100,101,
  104,104,104,105,105,105,105,105,105,106,105,106,109,106,106,105,105,105,106,
  106,106,106,107,5,5,255,0,32,98,98,104,106,106,104,104,104,105,105,106,106,
  105,105,105,105,105,105,104,105,106,105,106,106,106,105,106,106,108,108,104,
  108,110,110,255,0,32,96,96,102,103,104,104,103,105,107,105,105,105,105,105,
  106,106,105,105,105,105,105,106,107,106,107,107,105,106,106,106,108,109,111,
  111,255,0,32,98,98,102,104,104,101,101,101,104,102,103,105,105,101,104,104,
  105,105,105,105,106,106,107,106,105,104,106,106,106,106,107,106,110,110,255,
  0,32,97,97,102,101,101,101,102,102,101,101,104,104,104,104,101,103,105,105,
  105,105,106,106,106,105,105,105,105,107,106,107,105,107,109,109,255,0,32,104,
  104,106,106,108,108,109,109,109,109,109,109,109,110,109,110,109,109,109,109,
  109,109,109,109,109,111,110,109,111,111,111,110,109,109,255,
};

static const char m_nmare[] = {  // nightmare mode menu item
  124,0,19,0,0,0,0,0,248,1,0,0,12,2,0,0,34,2,0,0,56,2,0,0,80,2,0,0,102,2,0,0,
  120,2,0,0,133,2,0,0,146,2,0,0,159,2,0,0,172,2,0,0,193,2,0,0,215,2,0,0,238,2,
  0,0,4,3,0,0,25,3,0,0,47,3,0,0,67,3,0,0,86,3,0,0,105,3,0,0,123,3,0,0,139,3,0,
  0,152,3,0,0,168,3,0,0,186,3,0,0,206,3,0,0,225,3,0,0,242,3,0,0,4,4,0,0,23,4,0,
  0,41,4,0,0,63,4,0,0,86,4,0,0,108,4,0,0,130,4,0,0,151,4,0,0,170,4,0,0,190,4,0,
  0,209,4,0,0,228,4,0,0,246,4,0,0,7,5,0,0,18,5,0,0,28,5,0,0,38,5,0,0,52,5,0,0,
  70,5,0,0,89,5,0,0,107,5,0,0,124,5,0,0,140,5,0,0,151,5,0,0,163,5,0,0,180,5,0,
  0,198,5,0,0,217,5,0,0,235,5,0,0,253,5,0,0,14,6,0,0,23,6,0,0,32,6,0,0,49,6,0,
  0,67,6,0,0,87,6,0,0,106,6,0,0,124,6,0,0,140,6,0,0,152,6,0,0,164,6,0,0,176,6,
  0,0,188,6,0,0,203,6,0,0,221,6,0,0,240,6,0,0,2,7,0,0,19,7,0,0,34,7,0,0,45,7,0,
  0,59,7,0,0,74,7,0,0,88,7,0,0,102,7,0,0,114,7,0,0,128,7,0,0,143,7,0,0,161,7,0,
  0,180,7,0,0,200,7,0,0,219,7,0,0,236,7,0,0,253,7,0,0,15,8,0,0,34,8,0,0,53,8,0,
  0,73,8,0,0,92,8,0,0,105,8,0,0,118,8,0,0,131,8,0,0,147,8,0,0,164,8,0,0,183,8,
  0,0,203,8,0,0,221,8,0,0,235,8,0,0,247,8,0,0,5,9,0,0,22,9,0,0,41,9,0,0,59,9,0,
  0,77,9,0,0,96,9,0,0,114,9,0,0,132,9,0,0,151,9,0,0,169,9,0,0,186,9,0,0,202,9,
  0,0,203,9,0,0,225,9,0,0,246,9,0,0,11,10,0,0,32,10,0,0,53,10,0,0,2,15,47,47,
  47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,255,1,17,47,47,181,179,180,182,
  179,177,182,182,182,180,180,183,185,185,187,47,47,255,0,17,47,47,178,177,180,
  180,180,179,178,181,181,183,184,184,185,186,187,41,41,255,0,19,47,47,178,177,
  179,179,179,181,182,180,182,185,183,180,180,183,185,187,47,47,47,255,1,17,47,
  47,178,178,179,181,182,183,185,186,185,184,185,185,185,38,47,47,47,255,2,13,
  47,47,181,183,184,185,184,186,47,47,47,47,47,47,47,255,3,8,47,47,181,184,183,
  183,186,188,47,47,255,4,8,47,47,181,183,184,185,187,188,47,47,255,5,8,47,47,
  181,183,185,186,187,188,47,47,255,6,8,47,47,181,184,181,179,186,188,47,47,
  255,0,16,47,47,47,47,47,47,47,47,47,185,182,186,181,180,188,47,47,47,255,0,
  17,47,47,178,179,179,181,181,182,182,186,186,186,183,185,185,45,45,47,47,255,
  0,18,47,47,175,177,177,178,178,178,178,177,181,180,180,177,181,186,187,45,47,
  47,255,0,17,47,47,177,179,182,180,180,181,182,184,185,185,185,185,186,188,
  189,47,47,255,0,16,47,47,178,182,183,182,182,182,184,186,187,187,187,187,189,
  45,47,47,255,0,17,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,
  255,3,15,47,47,182,180,180,178,177,177,181,183,180,180,180,181,187,47,47,255,
  3,14,47,47,180,185,184,183,181,180,178,177,177,182,187,47,47,47,255,3,14,47,
  47,180,185,183,182,182,182,181,181,182,183,181,186,47,47,255,3,13,47,47,183,
  180,180,178,175,177,181,186,187,187,47,47,47,255,3,11,47,47,47,47,47,47,47,
  47,47,47,47,47,47,255,5,8,47,47,47,186,186,186,186,187,47,47,255,4,11,47,47,
  187,183,183,185,185,182,180,185,47,47,47,255,4,13,47,47,185,183,183,183,182,
  180,180,182,185,186,47,47,47,255,3,15,47,47,186,186,186,185,185,186,185,184,
  183,184,186,188,187,47,47,255,3,14,47,47,185,186,187,47,47,47,47,187,188,45,
  187,47,47,47,255,3,4,47,47,180,185,47,47,11,4,47,47,185,187,47,47,255,3,5,47,
  47,180,183,187,47,47,11,4,47,47,181,187,47,47,255,3,6,47,47,175,177,179,184,
  187,187,11,4,47,47,178,178,47,47,255,3,5,47,47,177,184,186,47,47,11,4,47,47,
  180,183,47,47,255,3,4,47,47,177,185,47,47,8,9,47,47,47,47,47,187,187,187,47,
  47,47,255,3,4,47,47,179,182,47,47,8,10,47,47,182,185,183,186,187,183,181,181,
  47,47,255,3,4,47,47,179,180,47,47,8,9,47,47,186,187,187,187,188,45,47,47,47,
  255,3,4,47,47,181,185,47,47,8,9,47,47,181,182,180,180,183,180,187,47,47,255,
  3,4,47,47,185,186,47,47,8,8,47,47,185,186,186,186,187,47,47,47,255,3,14,47,
  47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,255,3,15,47,47,183,186,186,186,
  186,186,186,183,180,180,181,180,187,47,47,255,3,14,47,47,177,178,179,181,180,
  178,182,182,185,186,47,47,47,47,255,3,14,47,47,181,184,184,184,185,186,182,
  180,180,183,181,187,47,47,255,3,13,47,47,183,182,182,185,183,184,185,185,185,
  185,187,47,47,255,3,12,47,47,47,47,47,47,182,186,188,47,47,47,47,47,255,7,6,
  47,47,177,182,185,47,47,47,255,7,5,47,47,179,186,187,47,47,255,7,5,47,47,179,
  180,180,185,185,255,3,9,47,47,47,47,47,47,180,185,188,47,47,255,3,13,47,47,
  183,180,180,178,175,177,181,186,186,186,186,47,47,255,3,14,47,47,179,183,186,
  181,181,179,179,175,180,180,183,186,47,47,255,3,13,47,47,180,178,175,177,181,
  182,185,182,178,178,186,47,47,255,3,12,47,47,182,186,185,185,184,184,184,185,
  185,187,47,47,255,3,11,47,47,47,47,47,47,47,47,47,47,47,47,47,255,3,6,47,47,
  183,186,186,186,47,47,255,3,7,47,47,179,177,181,184,185,45,45,255,3,12,47,47,
  178,182,47,47,45,47,47,47,47,47,47,47,255,3,13,47,47,177,177,177,180,182,180,
  178,178,187,186,187,45,45,255,3,14,47,47,177,177,179,180,178,175,178,183,180,
  180,178,181,47,47,255,3,13,47,47,178,180,180,182,182,182,181,183,185,185,187,
  45,45,255,3,13,47,47,179,182,183,182,185,185,182,180,178,186,187,47,47,255,3,
  12,47,47,179,185,47,47,47,47,47,47,47,47,47,47,255,3,4,47,47,179,186,47,47,
  255,3,4,47,47,181,186,47,47,255,3,12,47,47,47,47,47,47,47,47,47,47,47,47,47,
  47,255,4,13,47,47,184,183,184,182,180,178,181,182,185,187,47,47,47,255,3,15,
  47,47,181,179,180,180,180,180,181,178,30,177,183,181,181,47,47,255,3,14,47,
  47,178,178,180,182,182,182,182,182,180,185,186,187,47,47,255,3,13,47,47,182,
  182,182,182,180,178,178,180,180,178,182,47,47,255,4,11,47,47,182,186,186,187,
  187,47,47,47,47,47,47,255,5,7,47,47,179,175,177,185,187,47,47,255,6,7,47,47,
  181,185,186,186,187,47,47,255,6,7,47,47,181,185,185,182,186,47,47,255,5,7,47,
  47,181,182,182,182,186,47,47,255,4,10,47,47,182,185,183,183,184,47,47,47,47,
  47,255,3,13,47,47,175,177,181,185,185,180,185,185,185,187,47,47,47,255,3,14,
  47,47,178,181,182,182,182,182,181,178,178,183,180,181,47,47,255,3,13,47,47,
  179,182,184,182,186,186,186,186,185,187,47,47,47,255,4,12,47,47,185,186,186,
  187,182,185,182,180,181,187,47,47,255,5,10,47,47,47,47,47,47,47,47,47,47,47,
  47,255,10,6,47,47,47,185,185,47,47,47,255,8,9,47,47,47,186,185,182,181,181,
  187,47,47,255,6,10,47,47,47,186,185,182,180,181,187,47,47,47,255,5,9,47,47,
  186,184,182,181,181,181,187,47,47,255,4,9,47,47,186,184,182,182,182,186,47,
  47,47,255,4,7,47,47,184,182,178,181,186,47,47,255,3,9,47,47,183,185,186,47,
  186,47,47,47,47,255,3,10,47,47,182,184,47,47,178,179,182,187,47,47,255,3,13,
  47,47,179,179,47,47,181,182,186,47,47,47,47,47,47,255,3,14,47,47,179,186,185,
  185,184,186,186,187,187,187,187,187,47,47,255,3,15,47,47,180,182,182,182,180,
  178,175,180,178,178,183,180,187,47,47,255,3,14,47,47,186,183,183,184,184,183,
  182,180,180,183,180,187,47,47,255,4,12,47,47,187,186,185,186,186,186,187,187,
  187,47,47,47,255,3,12,47,47,47,47,47,47,47,47,47,47,47,47,47,47,255,3,13,47,
  47,183,186,47,47,184,185,180,183,182,181,186,47,47,255,3,14,47,47,178,184,47,
  47,175,178,180,177,182,180,181,187,47,47,255,3,14,47,47,179,180,185,47,177,
  185,185,185,187,188,47,47,74,74,255,3,15,47,47,178,177,178,180,178,181,179,
  180,180,180,183,186,187,47,47,255,3,14,47,47,178,180,185,185,178,185,47,47,
  47,47,47,47,47,47,255,3,8,47,47,179,185,47,47,175,186,47,47,255,3,8,47,47,
  178,183,188,188,178,178,186,186,255,3,8,47,47,178,180,182,185,180,186,47,47,
  255,3,11,47,47,179,183,47,47,179,185,186,47,47,47,47,255,3,12,47,47,179,178,
  182,185,180,180,179,180,180,185,47,47,255,3,14,47,47,179,181,181,180,178,175,
  180,180,180,181,183,47,47,47,255,3,15,47,47,186,179,180,182,182,180,178,177,
  177,178,179,179,184,47,47,255,4,13,47,47,186,182,184,47,47,185,185,183,186,
  47,47,47,47,255,5,9,47,47,47,47,47,47,47,47,47,47,47,255,5,7,47,47,47,186,
  185,186,186,47,47,255,4,9,47,47,187,185,182,181,181,182,185,47,47,255,4,12,
  47,47,183,182,180,182,182,181,182,185,47,47,47,47,255,3,14,47,47,181,180,178,
  175,177,175,178,180,180,182,185,186,47,47,255,3,13,47,47,181,179,185,185,182,
  182,186,186,185,187,187,47,47,255,3,13,47,47,182,186,188,47,181,186,47,47,
  180,184,47,74,74,255,3,14,47,47,180,186,186,47,181,180,186,47,180,181,183,
  187,47,47,255,3,13,47,47,177,178,181,185,181,185,187,47,180,184,47,47,47,255,
  3,13,47,47,181,186,186,47,177,178,180,185,179,186,47,47,47,255,3,14,47,47,
  181,179,182,185,179,185,186,47,181,184,183,187,47,47,255,3,13,47,47,180,185,
  188,47,185,186,47,47,183,187,187,47,47,255,3,12,47,47,183,186,45,47,185,187,
  47,47,188,188,47,47,255,3,11,47,47,47,47,47,47,47,47,47,47,47,47,47,255,255,
  0,9,47,47,47,47,47,47,47,47,47,47,47,10,4,47,47,47,47,47,47,255,0,16,47,47,
  178,179,179,181,181,183,184,47,47,186,181,47,180,47,47,47,255,0,16,47,47,175,
  177,177,178,178,178,180,185,47,181,178,186,47,182,47,47,255,0,16,47,47,178,
  180,180,179,178,179,182,185,47,181,185,47,186,184,47,47,255,0,16,47,47,178,
  180,182,180,180,183,185,47,47,186,181,47,180,47,47,47,255,0,9,47,47,47,47,47,
  47,47,47,47,47,47,10,4,47,47,47,47,47,47,255,0,
};

static const char wiminus[] = {   // status bar widget minus sign
  6,0,3,0,0,0,251,255,32,0,0,0,40,0,0,0,48,0,0,0,56,0,0,0,64,0,0,0,72,0,0,0,0,
  3,191,191,191,191,191,255,0,3,191,191,180,191,191,255,0,3,191,191,180,191,
  191,255,0,3,191,191,178,191,191,255,0,3,191,191,177,191,191,255,0,3,191,191,
  191,191,191,255,
};

static const char dsgetpow[] = {  // sound for getting powerup
  3,0,17,43,248,30,0,0,130,130,130,130,130,130,130,130,130,130,130,130,130,130,
  130,130,130,130,130,130,130,130,130,130,129,129,128,128,127,127,127,126,126,
  125,124,124,123,122,122,121,120,119,118,118,119,120,120,121,122,122,123,123,
  123,123,123,123,124,124,124,124,124,124,124,124,124,125,126,127,128,128,129,
  130,131,132,132,133,134,135,136,137,137,137,137,137,137,137,137,136,136,136,
  135,135,135,135,136,135,135,135,134,134,134,133,133,133,132,132,132,133,134,
  135,136,136,136,136,135,133,132,130,129,128,126,125,124,123,122,121,120,119,
  118,118,119,120,122,125,128,131,133,135,138,139,140,141,142,142,142,141,141,
  140,138,135,133,131,129,126,124,122,120,118,116,115,114,113,113,113,114,115,
  117,119,121,122,123,124,124,124,123,122,121,120,119,118,117,117,117,118,118,
  119,121,122,122,123,124,124,124,124,123,123,122,122,122,122,122,123,123,124,
  125,126,127,128,130,131,133,134,136,138,140,141,143,144,145,145,146,146,146,
  145,144,143,142,140,139,136,134,132,130,128,126,125,124,124,124,124,124,125,
  125,126,126,127,127,126,126,125,124,124,124,125,126,128,129,131,133,135,136,
  137,138,138,138,138,137,135,133,132,131,130,130,129,129,129,129,130,130,130,
  130,129,129,128,127,126,125,124,123,122,121,121,120,120,119,118,118,117,116,
  115,114,113,112,112,111,110,110,109,109,108,108,109,110,111,113,114,115,117,
  117,117,116,116,116,116,117,118,119,120,120,121,121,122,122,123,124,125,125,
  126,126,127,128,131,133,136,139,142,145,148,151,153,154,154,154,153,151,150,
  148,147,146,145,145,145,144,142,140,138,136,133,131,130,129,129,128,127,127,
  128,128,130,132,134,135,137,138,138,139,139,139,138,137,136,134,132,130,128,
  127,126,126,125,126,127,128,130,132,134,135,136,138,139,139,140,140,140,140,
  140,140,139,138,136,134,132,130,127,124,120,116,113,110,107,105,103,102,102,
  103,104,107,110,113,115,117,118,117,116,115,113,111,109,107,106,106,106,107,
  108,108,109,110,111,112,113,115,117,118,119,120,121,122,122,123,125,126,127,
  128,129,129,130,132,133,135,136,137,138,139,141,144,147,150,153,155,157,157,
  157,157,156,155,152,150,147,144,140,137,134,132,131,130,130,130,130,131,131,
  132,133,134,135,136,136,135,134,132,131,128,126,125,125,127,129,131,133,135,
  135,135,134,132,131,130,129,128,128,127,127,127,127,129,131,134,137,140,142,
  143,144,144,143,142,140,138,135,131,127,123,120,116,113,110,108,105,102,99,
  96,93,91,90,90,91,93,97,100,105,108,111,113,114,114,114,115,115,116,116,116,
  115,113,111,110,108,108,107,108,108,108,109,110,111,112,113,113,114,115,116,
  118,120,123,126,131,136,142,148,153,158,162,165,166,167,166,165,164,162,161,
  160,159,158,156,155,153,153,152,150,148,145,140,136,132,130,129,129,128,127,
  126,125,125,126,128,130,133,135,136,136,136,136,136,135,135,135,135,135,136,
  137,139,140,141,141,140,138,135,134,135,137,139,140,141,140,139,137,136,137,
  137,138,138,139,138,138,136,133,129,124,120,116,111,106,103,100,98,96,96,97,
  98,100,102,103,104,105,105,106,106,106,106,105,105,104,103,103,102,102,103,
  103,103,102,101,100,99,100,102,106,109,113,116,120,123,126,128,130,131,130,
  129,129,129,131,133,134,135,136,138,139,142,146,151,157,163,167,169,168,166,
  164,161,160,159,158,157,155,152,148,145,142,140,138,137,136,134,133,133,133,
  134,136,137,137,137,136,135,134,133,132,131,130,130,131,132,134,135,136,135,
  132,128,123,119,116,116,118,120,123,124,125,126,127,128,131,135,139,141,143,
  144,144,143,142,140,138,135,132,129,125,121,117,112,108,105,101,98,95,91,87,
  82,79,78,80,85,92,101,110,117,122,125,127,127,127,128,128,128,128,127,124,
  121,119,116,114,111,108,105,103,102,103,106,109,111,113,115,118,121,124,128,
  131,134,136,139,142,146,150,154,157,159,159,157,154,151,150,151,153,156,159,
  160,161,160,159,159,161,162,164,165,163,159,153,147,142,137,133,130,128,126,
  124,122,120,118,116,114,112,110,110,110,111,113,114,117,120,124,128,133,138,
  142,145,146,145,142,138,135,133,132,133,134,134,132,129,126,123,120,119,119,
  119,121,122,125,127,128,127,124,120,118,116,115,114,112,111,109,108,107,107,
  108,110,111,111,111,110,110,110,111,113,115,118,120,121,120,119,118,118,119,
  119,119,117,113,109,105,102,99,97,96,98,102,107,113,119,124,126,127,128,128,
  128,128,128,130,133,137,141,146,151,156,159,162,165,168,170,173,173,171,167,
  162,157,154,152,152,152,151,150,148,144,139,135,133,132,133,135,136,135,132,
  129,126,126,127,129,130,130,128,126,124,123,123,123,124,124,124,123,124,124,
  123,121,118,114,112,111,113,115,117,119,121,124,127,129,132,135,139,143,146,
  148,147,145,141,138,136,136,137,137,136,132,126,119,112,105,99,96,94,91,88,
  86,85,85,87,92,100,110,120,127,132,134,134,133,132,132,133,133,132,130,127,
  122,115,108,102,97,94,94,94,95,95,94,94,95,97,102,108,114,122,129,137,144,
  149,153,157,159,162,165,168,171,173,173,171,168,164,161,158,156,155,153,151,
  150,149,147,145,144,143,144,145,146,146,144,139,135,132,131,132,134,135,135,
  133,129,125,121,119,118,118,118,117,115,112,110,110,113,118,125,131,136,137,
  136,133,131,130,129,127,124,122,122,124,126,127,127,125,122,120,121,124,131,
  137,143,145,145,143,138,133,129,126,126,126,126,124,120,117,113,110,108,106,
  106,106,107,107,105,103,103,104,106,109,112,115,117,119,118,117,116,116,118,
  120,121,121,118,114,108,104,102,104,109,114,119,125,128,130,131,131,130,129,
  127,126,127,129,133,137,141,143,143,143,144,145,147,150,154,156,156,154,151,
  148,148,150,155,161,164,165,164,162,160,159,157,156,156,154,150,144,137,129,
  123,119,117,115,114,112,109,106,104,103,103,104,106,109,113,119,125,131,135,
  136,135,133,131,131,132,135,137,139,138,136,133,132,133,135,136,135,133,131,
  127,123,119,117,118,120,123,126,130,132,132,130,127,124,123,121,121,121,122,
  120,115,107,101,99,103,111,120,126,127,124,118,114,113,115,119,122,124,124,
  122,119,114,111,108,107,107,106,105,102,99,97,97,99,99,99,99,102,109,117,125,
  131,135,138,140,143,146,150,154,157,159,159,158,157,157,157,159,159,159,159,
  157,156,156,155,152,149,148,148,149,149,147,144,140,137,135,133,131,130,129,
  129,128,127,125,122,120,119,121,124,125,124,122,120,119,119,121,124,128,131,
  134,134,132,128,123,118,115,114,115,117,120,122,122,119,115,114,116,123,131,
  139,145,149,151,153,152,148,141,135,131,132,134,137,138,136,133,129,126,122,
  119,115,113,112,110,108,105,102,100,99,100,104,109,115,119,120,119,117,116,
  115,115,114,112,108,106,106,108,108,107,106,107,110,114,117,118,117,114,113,
  115,119,123,127,129,131,132,134,135,138,143,148,153,155,154,152,149,149,150,
  151,151,152,155,157,159,159,158,158,158,157,154,149,145,146,149,152,153,149,
  140,129,121,119,123,127,129,127,123,117,112,109,108,110,112,114,115,115,116,
  118,122,127,131,132,130,128,129,132,136,136,135,134,133,132,128,125,124,125,
  125,124,122,119,118,120,124,129,134,140,144,146,146,146,145,141,136,133,133,
  133,131,126,119,113,109,109,111,113,114,111,107,101,96,92,91,96,103,110,116,
  120,123,126,126,124,121,119,119,119,117,115,113,111,108,105,103,103,105,110,
  117,122,125,126,125,124,124,127,131,133,131,128,128,132,139,145,149,151,150,
  147,145,147,151,158,161,160,157,154,152,152,154,157,159,157,153,149,149,150,
  150,150,149,145,139,129,119,112,109,108,110,113,115,114,111,110,111,115,119,
  123,126,129,131,131,130,127,125,122,121,121,125,131,137,140,138,132,124,120,
  120,125,132,138,141,140,138,135,132,129,126,126,128,132,137,140,142,142,142,
  141,138,132,123,117,115,116,118,117,115,112,111,111,111,111,112,113,115,116,
  117,116,113,109,106,104,104,105,105,105,105,106,110,114,118,121,121,117,107,
  98,94,97,105,112,116,117,118,121,126,131,135,138,141,145,147,148,145,143,141,
  140,140,141,145,150,155,161,166,170,169,163,157,153,152,153,156,157,158,155,
  149,141,133,128,128,129,130,130,128,127,126,126,124,120,117,117,118,117,112,
  109,109,115,123,130,134,132,129,129,133,139,141,139,134,127,122,119,119,119,
  117,115,112,110,110,113,119,127,134,138,140,141,141,142,143,144,145,147,151,
  156,159,158,152,144,136,131,128,125,119,111,104,99,95,89,82,77,77,82,90,100,
  110,120,127,131,131,130,127,124,120,119,120,121,122,120,116,111,106,103,104,
  108,113,117,117,115,113,113,117,121,120,116,112,114,118,123,130,136,141,144,
  145,148,154,157,157,155,154,155,157,159,161,161,158,153,149,151,156,162,165,
  164,160,152,144,137,132,128,124,118,115,114,116,119,120,121,122,125,125,121,
  115,112,115,121,126,128,126,120,113,110,112,121,133,142,147,146,141,133,127,
  124,124,126,127,129,129,128,127,129,132,134,135,138,143,147,147,144,142,143,
  147,150,147,138,126,114,109,110,114,118,119,116,113,110,108,107,107,108,110,
  113,113,111,107,105,106,111,117,122,123,121,118,116,117,120,123,124,118,106,
  94,87,88,94,102,106,108,109,111,116,122,127,128,126,126,128,134,140,143,142,
  139,134,132,134,140,148,155,160,162,162,161,159,157,157,155,151,146,144,145,
  149,152,156,158,158,156,153,148,141,137,134,132,129,127,124,119,112,105,100,
  99,103,108,113,118,124,129,132,134,137,140,139,136,133,132,129,123,118,116,
  118,121,123,122,120,117,118,123,131,138,141,140,136,131,128,130,135,140,145,
  149,153,155,154,151,147,140,132,125,119,113,108,106,106,103,96,91,92,97,103,
  109,119,130,138,141,138,131,123,115,110,110,114,118,118,115,112,110,108,106,
  102,98,94,94,96,97,96,95,97,102,109,115,118,120,123,129,137,146,151,152,150,
  149,151,153,152,149,146,144,143,145,150,155,157,156,154,150,147,149,156,165,
  168,165,156,147,140,136,134,132,128,126,126,129,133,137,139,137,131,122,114,
  110,109,109,111,115,118,118,114,109,110,116,127,140,152,159,158,149,136,125,
  119,117,116,113,109,106,106,112,122,132,138,142,145,146,144,143,144,148,151,
  154,156,153,143,133,129,130,130,128,127,128,127,125,121,116,107,96,89,89,93,
  96,96,98,104,112,118,120,119,118,118,120,122,123,122,121,117,109,100,96,97,
  101,104,105,107,110,114,120,129,136,136,126,113,107,110,117,125,133,136,134,
  128,127,133,140,143,145,148,151,152,151,151,152,149,143,139,139,143,150,161,
  171,178,183,182,177,167,157,148,140,136,136,136,133,126,115,105,98,96,97,98,
  101,105,112,120,127,133,135,136,135,133,131,131,130,127,125,126,131,136,140,
  140,135,126,121,121,125,129,130,129,124,117,113,115,119,124,132,142,153,162,
  165,164,157,148,139,134,131,126,117,107,100,100,103,108,111,112,112,112,115,
  121,129,135,138,136,129,120,112,107,106,111,117,123,125,125,122,115,105,95,
  90,90,93,93,90,86,85,90,98,108,115,120,123,128,136,145,150,150,146,144,143,
  142,141,137,132,125,121,125,134,144,149,148,147,147,149,154,159,164,164,159,
  151,147,150,156,160,157,149,139,133,134,139,146,151,152,146,135,124,115,108,
  103,100,102,107,110,109,106,108,115,126,139,147,150,149,145,141,136,129,122,
  112,105,102,104,110,119,129,137,140,139,140,144,147,149,147,142,134,129,129,
  133,134,134,133,133,133,134,136,139,141,141,140,138,129,115,102,98,101,105,
  105,105,109,116,123,129,135,139,134,122,108,102,102,105,104,102,98,94,91,90,
  92,95,101,109,116,120,121,124,125,123,119,116,115,116,119,125,130,132,133,
  136,140,140,134,128,128,133,139,142,143,142,138,132,128,129,134,141,149,160,
  173,185,192,193,189,181,169,158,150,147,146,143,138,128,114,104,103,110,113,
  108,102,103,111,118,124,127,127,124,120,117,115,115,119,129,140,149,153,154,
  150,144,137,133,130,128,124,121,119,116,112,106,101,101,106,116,127,136,144,
  152,157,157,152,145,144,147,146,136,122,112,111,117,128,137,141,138,132,129,
  130,130,126,120,116,114,110,104,97,94,94,98,105,115,121,123,122,120,117,112,
  108,103,99,95,93,93,98,106,117,125,129,127,125,127,135,141,139,132,123,118,
  116,114,114,113,111,110,112,120,127,131,135,141,147,149,149,151,156,161,163,
  162,160,158,159,163,166,164,159,156,155,156,155,152,146,141,136,132,126,114,
  99,86,81,83,90,101,114,128,139,143,141,139,139,143,148,152,153,147,136,123,
  114,111,112,113,114,118,123,127,129,129,128,130,133,133,129,123,119,119,123,
  128,135,142,146,148,151,157,160,159,155,152,147,139,127,118,114,112,107,102,
  102,107,113,123,135,144,142,131,119,111,109,109,108,106,104,102,100,99,101,
  107,115,121,122,118,113,112,115,119,121,118,106,90,77,77,87,102,118,130,138,
  140,136,128,123,127,135,140,139,138,137,136,136,138,141,139,135,132,137,149,
  164,176,179,176,169,159,148,140,138,141,146,145,134,120,115,122,136,145,145,
  138,132,129,128,128,127,127,126,123,120,115,113,114,119,127,134,139,141,141,
  138,134,129,126,125,122,119,115,113,110,107,106,110,120,132,138,139,140,143,
  148,150,149,146,142,138,134,128,121,118,122,132,143,151,153,150,144,137,132,
  126,122,122,127,130,125,115,107,103,101,103,109,118,125,128,131,135,137,130,
  116,103,96,97,96,92,89,93,101,107,110,114,120,124,125,122,118,115,114,115,
  114,113,113,114,114,114,117,125,133,137,137,139,142,141,136,132,133,137,138,
  134,128,123,125,138,155,164,165,163,162,159,161,168,174,173,163,151,138,127,
  118,113,108,104,105,114,125,134,137,134,128,122,120,123,128,134,140,146,143,
  134,125,123,123,118,113,116,128,139,142,137,132,130,131,131,130,125,116,106,
  98,101,115,135,150,157,155,149,140,136,137,141,144,142,137,132,128,125,124,
  125,127,129,132,139,149,157,154,142,130,124,123,120,112,101,93,91,95,101,108,
  115,118,118,116,115,113,112,110,106,104,104,103,99,93,91,96,102,109,118,128,
  137,142,139,131,125,125,125,121,116,117,124,129,128,123,116,107,103,111,128,
  146,157,159,155,151,148,147,149,150,148,143,138,135,138,151,167,177,176,165,
  151,140,135,134,136,134,126,118,114,113,113,115,119,121,121,121,124,127,129,
  132,137,145,147,142,132,121,114,113,116,118,118,117,121,130,138,140,137,133,
  128,124,123,125,130,134,134,129,121,115,118,130,144,154,158,155,149,145,140,
  134,130,131,134,137,136,133,129,126,119,113,113,122,133,138,140,143,145,138,
  124,111,102,96,91,90,92,98,102,105,107,111,115,119,119,115,107,98,91,91,96,
  103,111,116,120,122,124,126,128,131,134,138,138,136,132,131,131,126,118,110,
  104,101,107,120,136,146,149,150,151,153,158,165,168,167,164,159,153,150,150,
  148,138,128,126,130,137,142,145,145,140,132,124,116,112,116,127,136,136,130,
  124,119,114,112,118,133,149,157,153,140,129,124,127,136,141,135,120,103,91,
  91,104,124,138,140,135,128,125,126,131,136,136,133,130,129,130,131,137,145,
  147,142,136,136,143,155,165,167,160,149,140,132,123,112,105,108,113,114,112,
  114,122,127,123,115,109,103,93,84,82,90,99,100,97,96,97,101,108,117,127,136,
  143,141,134,129,130,130,125,121,120,119,116,111,106,101,96,99,110,122,128,
  125,117,112,115,123,131,137,142,142,137,135,141,153,166,174,177,180,182,178,
  166,157,154,151,142,130,126,128,128,124,120,114,108,106,111,120,129,137,145,
  151,150,144,133,124,120,122,126,127,123,117,115,121,131,140,142,138,126,111,
  100,100,111,127,137,138,134,127,122,120,125,136,147,153,153,148,141,134,133,
  138,143,141,133,126,122,123,128,136,143,146,146,144,139,135,135,140,143,140,
  130,116,104,101,107,113,113,110,109,110,110,109,108,108,109,107,102,95,90,90,
  96,106,115,118,116,111,110,117,129,142,148,145,137,128,122,118,114,108,102,
  97,95,98,104,111,120,128,131,132,135,141,149,151,148,143,142,147,158,167,169,
  165,160,154,147,146,153,160,160,154,148,142,130,118,113,118,122,123,121,121,
  123,125,126,132,139,143,142,138,135,133,131,132,133,131,123,116,114,118,123,
  127,130,127,117,110,112,122,134,142,141,130,117,110,110,118,128,135,136,132,
  130,132,139,148,158,164,159,150,145,143,142,140,138,135,131,125,120,121,128,
  136,140,139,132,118,100,86,84,93,105,112,112,107,99,95,98,107,116,123,130,
  132,129,122,118,119,123,124,119,112,106,102,103,107,110,114,119,122,122,117,
  109,103,105,110,109,105,106,110,116,124,138,152,156,151,147,152,164,176,181,
  178,170,163,155,147,140,135,134,135,135,132,126,120,119,124,132,142,151,155,
  149,138,130,127,130,134,137,139,138,130,119,115,123,136,143,142,131,113,96,
  93,102,115,123,126,124,121,117,116,120,130,140,145,146,145,142,135,133,138,
  147,145,131,118,113,119,131,144,151,150,146,140,135,135,142,150,150,142,129,
  118,114,121,135,146,147,137,124,114,109,107,110,115,122,121,111,96,85,82,86,
  93,100,104,107,106,102,102,113,132,147,148,140,130,118,110,110,117,120,114,
  104,100,102,107,117,125,122,109,99,101,113,127,133,131,126,120,122,132,145,
  155,160,161,156,152,157,166,172,173,172,170,160,149,142,137,131,126,127,129,
  131,131,132,134,135,136,137,137,132,122,114,111,117,126,130,129,129,132,131,
  126,123,124,127,128,127,129,136,141,139,131,122,115,111,112,119,126,127,124,
  124,129,133,134,138,141,137,128,124,125,130,137,142,143,143,144,145,146,145,
  144,144,143,139,135,130,125,122,121,118,112,107,108,111,112,112,111,111,112,
  114,115,115,117,120,121,120,114,105,98,94,98,112,125,127,121,117,117,118,118,
  118,116,112,107,100,91,90,100,113,121,128,134,131,120,114,121,139,156,166,
  165,153,141,138,143,149,154,154,148,139,134,134,139,150,161,164,157,148,143,
  138,134,134,136,134,128,126,129,135,139,143,145,146,141,133,126,123,124,124,
  121,119,120,115,106,101,107,117,122,122,121,121,121,127,141,152,150,138,127,
  123,121,117,115,119,128,140,147,147,142,138,136,134,136,140,143,140,135,134,
  134,133,132,137,145,150,148,140,129,122,123,127,129,130,128,122,112,104,102,
  101,102,102,102,101,101,103,104,109,119,126,127,123,118,112,105,105,112,115,
  111,108,112,121,127,130,127,115,101,96,101,112,123,129,126,115,103,97,100,
  112,128,143,149,145,140,142,149,159,169,174,170,157,146,145,147,145,141,143,
  145,143,137,138,144,149,145,140,137,137,133,126,119,120,127,132,131,132,134,
  133,128,126,130,137,136,129,123,125,131,132,128,126,123,116,107,106,113,119,
  122,128,136,137,132,128,126,124,127,133,133,126,122,127,135,141,146,151,150,
  141,133,133,140,146,144,135,126,123,124,125,126,126,128,129,127,125,125,127,
  132,136,133,126,122,121,119,115,108,103,101,101,102,105,108,109,111,115,121,
  124,124,124,122,117,109,102,102,106,111,112,113,117,121,121,113,107,108,116,
  127,138,143,137,124,117,118,121,127,134,137,135,135,143,154,161,162,157,149,
  142,140,143,149,156,157,148,135,128,131,138,146,154,160,158,148,132,119,116,
  123,130,131,129,127,121,111,106,108,111,114,118,125,128,126,125,133,141,139,
  128,120,121,125,128,128,127,126,128,131,133,137,141,141,138,135,134,134,129,
  123,122,127,130,128,127,131,135,138,139,139,140,142,143,144,144,143,141,140,
  137,129,120,113,112,118,126,132,130,121,111,106,106,107,110,115,114,102,88,
  87,95,101,106,117,131,133,125,118,114,114,118,122,119,113,111,113,112,107,
  104,108,113,114,112,109,111,122,137,147,146,139,134,131,132,139,150,156,153,
  145,141,142,145,146,149,151,149,144,142,142,139,134,131,132,133,133,132,133,
  135,139,142,142,140,139,140,139,135,133,134,133,129,123,115,108,106,108,114,
  121,126,128,128,128,129,132,134,130,127,127,129,126,120,118,123,128,129,134,
  139,138,129,126,128,133,136,141,142,134,124,121,125,129,134,141,142,137,135,
  141,148,150,146,139,132,128,127,126,122,118,114,110,107,107,111,115,116,117,
  120,122,118,112,110,112,115,114,113,114,115,115,116,118,119,118,118,117,112,
  104,102,111,123,127,117,104,97,96,98,108,124,133,131,126,125,131,141,149,153,
  153,149,143,138,137,139,143,148,146,138,129,128,131,138,146,152,153,145,133,
  128,129,133,133,134,136,132,122,116,121,129,136,138,138,131,123,122,130,138,
  135,126,116,112,113,118,125,127,126,126,128,130,133,134,134,132,131,131,129,
  125,124,128,132,131,128,131,133,129,123,124,132,141,145,146,145,136,124,121,
  131,146,155,152,140,127,120,124,137,149,150,140,127,120,118,118,121,123,116,
  102,93,95,102,112,122,128,126,117,112,115,126,137,141,134,119,103,95,96,99,
  100,104,109,111,105,97,98,109,122,130,131,126,117,114,118,127,136,141,139,
  135,132,132,137,145,150,147,138,127,121,124,132,139,140,136,133,130,128,128,
  132,141,151,156,157,155,151,142,133,129,130,136,141,140,134,126,121,119,116,
  116,121,128,128,125,124,128,129,127,123,124,127,128,128,132,133,129,126,125,
  127,128,128,128,133,137,138,138,134,121,110,107,110,118,130,139,138,129,125,
  130,139,146,147,146,143,141,140,140,140,140,138,134,127,119,119,125,132,134,
  132,128,120,114,110,114,120,123,123,121,117,111,110,115,119,119,121,125,122,
  112,106,112,120,117,104,97,98,99,97,99,107,113,116,117,120,128,135,136,133,
  133,135,134,132,131,132,134,134,130,127,123,120,118,119,126,137,143,143,140,
  139,135,131,132,135,137,137,140,144,148,146,143,143,142,137,132,132,136,138,
  136,135,129,119,111,112,119,125,128,127,127,127,128,128,131,137,141,138,130,
  125,125,126,127,129,133,134,128,119,113,119,131,138,137,132,126,121,120,123,
  130,135,139,138,131,124,127,141,154,159,150,137,126,122,128,139,150,151,140,
  125,115,113,120,131,141,143,135,122,116,120,128,134,133,124,110,97,90,90,98,
  109,116,113,102,93,93,99,107,119,132,134,125,114,115,126,134,136,131,125,121,
  119,116,117,122,124,122,120,120,122,123,123,120,117,117,121,125,129,132,131,
  130,134,144,152,156,153,149,145,144,142,144,150,155,149,137,128,126,128,128,
  129,130,127,122,122,124,127,126,126,124,121,120,125,134,139,136,128,126,129,
  133,133,133,134,133,131,130,128,128,127,122,115,110,114,122,124,123,126,130,
  129,124,120,122,127,133,141,146,144,137,136,137,136,132,133,139,141,138,138,
  143,146,142,139,137,133,127,123,123,125,126,127,128,124,116,112,116,122,123,
  120,115,108,100,100,108,113,114,116,119,116,108,103,107,116,123,125,125,128,
  131,130,126,121,119,116,116,118,120,120,115,108,106,113,123,128,127,125,124,
  124,126,134,142,140,132,128,135,143,148,151,154,154,145,132,125,130,136,141,
  144,148,146,136,125,121,122,123,121,122,123,127,132,139,144,146,141,132,123,
  121,128,136,140,138,132,125,119,114,116,123,131,134,130,120,110,108,116,126,
  133,135,131,125,120,121,132,143,143,132,120,116,122,135,151,162,164,152,137,
  128,126,130,139,146,148,142,130,122,124,131,139,138,133,127,119,110,108,112,
  117,122,124,122,118,115,112,108,108,113,119,117,113,113,120,125,125,124,122,
  119,113,107,106,113,120,122,121,123,123,119,115,117,121,122,117,113,111,114,
  119,121,124,128,131,132,130,129,132,137,138,136,137,141,142,139,135,134,138,
  143,144,140,132,124,124,131,141,147,146,141,135,131,131,131,132,133,131,127,
  124,126,129,131,131,130,128,123,118,118,124,130,132,131,128,124,120,121,127,
  132,132,125,119,118,121,124,128,134,137,137,135,134,132,128,124,124,128,130,
  133,136,138,137,136,136,139,141,139,132,128,131,134,137,139,140,140,135,131,
  130,129,127,125,125,127,127,123,118,116,117,119,117,115,113,113,111,110,111,
  113,119,123,125,124,122,121,119,119,119,117,110,102,102,110,118,123,125,125,
  120,113,110,111,116,122,125,128,130,133,133,130,129,129,129,129,130,133,136,
  137,139,144,150,152,145,136,133,136,136,135,135,135,133,133,136,140,139,137,
  133,125,121,125,132,136,135,130,128,124,123,126,132,135,133,126,120,119,126,
  135,137,131,124,120,118,118,122,130,133,128,118,112,113,121,130,138,143,141,
  136,133,131,132,132,131,130,130,130,130,135,142,145,140,132,127,125,126,130,
  135,142,146,144,138,132,129,127,123,118,118,122,123,120,121,125,126,124,120,
  116,113,111,111,114,115,113,108,104,105,111,118,123,125,126,123,116,109,109,
  115,123,130,134,130,122,116,116,118,120,124,128,130,130,130,129,126,122,121,
  121,122,124,127,130,133,139,145,146,143,140,138,138,141,146,152,152,146,132,
  119,114,121,132,144,150,148,136,123,114,112,118,129,139,141,135,126,121,121,
  125,130,133,128,119,114,119,124,127,128,130,132,132,132,132,130,125,122,125,
  128,126,123,121,124,129,135,138,137,130,121,117,121,131,140,145,146,145,142,
  140,139,136,131,127,129,136,146,150,144,133,123,117,115,116,122,128,128,123,
  117,117,120,121,118,116,115,115,117,122,125,124,117,108,100,101,110,123,132,
  135,129,120,115,114,115,115,115,118,121,122,124,128,126,118,109,108,112,118,
  124,128,129,129,131,135,137,135,133,135,138,139,137,136,137,139,141,141,139,
  137,135,135,133,133,134,135,134,128,125,128,133,135,133,133,129,122,118,121,
  130,138,141,140,133,122,118,124,131,132,128,123,118,116,119,126,130,129,130,
  129,125,120,122,131,140,140,133,124,115,112,119,133,144,144,136,127,122,122,
  126,131,135,137,136,136,137,138,139,138,136,136,137,136,133,129,130,134,134,
  129,125,124,121,116,115,121,124,121,113,109,110,112,114,117,121,124,127,124,
  118,114,116,125,133,132,127,122,120,119,119,122,126,126,121,116,114,116,118,
  119,119,119,117,114,111,111,117,128,137,141,141,136,131,129,132,139,148,151,
  145,137,132,132,132,134,136,136,132,126,124,130,139,142,137,129,125,123,123,
  126,133,139,137,129,122,121,125,128,129,128,126,126,128,129,129,128,124,122,
  123,128,132,133,132,129,124,121,121,123,124,125,128,131,134,134,129,124,121,
  123,131,140,144,140,131,125,126,132,140,144,144,139,133,130,133,137,135,128,
  123,120,121,128,137,140,133,123,117,116,118,123,129,133,131,126,119,116,117,
  119,119,118,119,122,126,126,122,117,115,114,117,122,124,122,116,110,109,113,
  119,123,122,120,121,123,123,123,125,127,125,120,118,120,126,131,135,139,139,
  136,130,127,129,132,134,137,142,142,134,126,123,127,132,136,138,135,129,123,
  122,126,132,138,140,137,134,135,136,134,130,128,126,123,121,124,127,128,127,
  127,126,122,120,122,128,136,141,138,130,124,123,128,131,132,129,126,125,125,
  124,123,124,128,131,133,131,128,126,126,130,132,135,138,139,136,133,133,136,
  139,139,137,134,128,122,121,125,130,134,133,129,125,123,124,124,125,128,129,
  130,128,125,121,119,122,129,131,126,116,110,110,114,117,120,123,124,122,120,
  119,120,121,121,121,121,119,115,114,117,121,126,126,124,120,120,123,129,135,
  136,130,124,123,129,135,134,129,126,124,123,125,132,138,140,139,137,133,129,
  129,136,141,139,132,125,123,124,127,132,134,132,128,123,122,127,134,135,130,
  125,126,128,128,128,129,128,128,129,131,130,127,125,126,130,132,131,128,124,
  123,125,130,134,134,129,124,121,122,125,130,133,132,129,125,126,129,133,136,
  138,134,127,124,128,135,140,141,137,132,129,129,131,132,134,136,136,132,130,
  130,129,125,123,124,124,122,122,120,117,117,123,130,130,125,121,118,114,112,
  115,120,123,121,118,117,117,118,121,125,128,126,122,119,119,121,123,123,123,
  121,118,117,118,123,127,130,132,133,132,128,124,124,129,134,135,132,129,126,
  124,127,134,140,140,137,136,135,132,130,132,135,134,129,124,123,126,130,133,
  131,128,124,123,125,128,133,138,137,134,134,134,132,129,130,133,134,131,126,
  121,119,119,120,124,127,129,128,126,124,124,125,127,129,133,136,137,133,128,
  127,129,133,135,134,131,128,129,131,131,128,126,128,130,131,131,132,133,133,
  134,133,132,130,130,132,133,133,130,127,123,121,120,121,122,124,125,123,121,
  121,122,120,118,120,126,128,123,116,112,115,121,127,127,124,120,118,119,124,
  126,124,120,119,120,123,128,132,131,126,120,117,118,122,127,131,132,129,127,
  126,126,129,133,134,129,124,126,133,136,133,128,127,128,129,130,132,134,136,
  137,135,133,132,130,128,128,130,132,132,128,123,120,120,125,133,138,137,133,
  127,123,122,126,131,134,134,131,125,122,123,127,130,130,127,123,122,126,131,
  132,129,128,128,127,126,126,130,134,135,134,134,133,128,123,122,127,134,142,
  145,144,138,130,125,124,128,132,135,135,131,127,125,126,130,131,127,120,117,
  120,127,131,129,123,119,120,123,125,126,127,128,127,126,125,124,121,118,117,
  119,121,121,120,118,116,115,116,119,121,121,119,117,120,124,128,128,128,125,
  122,120,122,130,138,141,136,130,126,126,128,131,135,136,132,127,124,126,128,
  127,126,128,132,133,133,130,128,125,126,129,131,132,134,137,139,138,135,131,
  128,126,127,129,130,130,128,127,127,127,126,125,124,126,129,132,132,129,126,
  125,124,125,126,128,128,127,128,132,133,130,124,121,122,126,130,135,138,136,
  132,128,124,124,128,134,138,138,136,133,130,127,127,128,131,134,135,134,131,
  126,123,122,125,130,134,136,134,128,123,119,120,122,123,122,120,117,117,122,
  128,127,121,114,111,112,116,122,128,131,130,125,120,121,126,129,128,126,124,
  123,123,124,126,127,124,120,118,120,122,124,126,128,128,127,125,124,125,129,
  133,135,136,137,137,134,131,131,132,132,130,130,131,130,129,129,132,134,132,
  127,121,121,126,134,138,137,132,126,124,126,128,128,128,127,127,127,128,129,
  131,130,129,129,130,132,131,128,125,126,127,128,128,128,129,127,123,122,125,
  127,128,129,130,131,131,132,136,139,138,134,129,126,128,132,135,134,132,130,
  128,126,127,128,130,132,134,135,132,127,126,126,125,126,126,126,124,124,125,
  128,126,121,116,113,113,116,122,127,129,128,124,120,116,116,119,125,130,131,
  129,124,121,122,124,123,122,121,123,123,122,122,124,124,123,123,124,126,127,
  127,128,130,129,127,126,129,132,137,138,136,132,130,131,130,129,129,132,133,
  133,133,133,131,127,125,126,127,127,127,129,131,132,132,130,128,128,129,129,
  129,129,131,132,130,127,123,121,120,120,125,131,135,133,129,126,125,126,128,
  129,129,128,127,128,129,131,132,128,125,124,125,127,128,130,133,135,134,130,
  127,127,130,132,133,134,135,134,131,128,128,129,131,132,133,131,128,123,121,
  123,128,129,126,119,117,120,124,126,125,124,121,119,121,126,130,131,128,123,
  120,119,120,122,126,128,128,126,122,120,120,122,123,122,122,122,123,125,124,
  122,122,125,127,128,128,129,131,131,131,132,132,131,128,124,124,129,135,136,
  134,130,127,127,128,131,134,134,131,128,127,128,128,128,128,128,128,128,128,
  129,131,131,129,128,129,130,129,128,128,128,130,131,130,128,125,125,125,126,
  127,128,130,128,124,123,126,130,132,131,130,129,128,127,126,126,127,128,127,
  127,129,131,132,132,132,132,130,130,133,136,135,131,128,128,130,132,132,130,
  128,127,126,126,126,127,127,125,123,122,122,124,124,123,122,124,126,127,126,
  125,125,126,124,123,124,126,126,124,124,124,124,125,125,124,123,121,122,123,
  124,124,123,122,121,121,122,125,128,130,129,126,126,127,128,128,129,132,133,
  133,132,130,130,129,130,131,131,131,130,129,127,126,126,129,133,136,134,131,
  127,125,126,127,128,129,128,126,124,125,128,131,133,130,126,123,124,129,133,
  134,132,130,128,126,124,124,126,128,129,129,127,125,126,128,129,128,128,129,
  130,129,126,125,126,128,130,131,132,132,130,129,129,130,132,132,131,128,127,
  130,133,133,131,128,127,127,128,130,130,129,127,126,125,125,127,129,129,128,
  125,123,123,124,127,127,125,124,124,123,122,123,125,127,126,123,121,121,120,
  119,121,124,128,129,129,127,124,123,125,128,128,127,125,124,124,126,129,130,
  128,126,123,123,125,130,134,135,134,130,126,125,128,131,132,130,127,127,127,
  128,129,131,131,129,127,127,128,130,130,130,130,130,129,128,127,126,126,128,
  130,131,129,127,126,127,127,127,128,130,130,128,128,128,127,126,126,128,129,
  127,125,124,124,126,127,128,130,132,133,132,130,128,125,125,128,131,133,133,
  133,132,130,130,130,129,129,130,132,131,129,127,126,127,128,128,126,125,125,
  126,127,128,128,128,127,124,123,124,124,123,123,125,128,129,127,123,121,122,
  125,127,127,127,128,127,125,124,125,127,127,126,124,124,123,124,126,127,128,
  126,124,123,125,127,128,127,126,127,127,127,128,130,131,130,130,130,131,130,
  129,128,128,129,131,131,128,126,127,127,126,126,127,128,128,127,129,131,131,
  131,130,128,126,125,126,128,130,130,128,125,124,125,127,129,130,130,129,129,
  128,128,127,126,126,127,129,131,132,130,127,124,124,125,127,129,130,130,129,
  128,128,129,131,131,129,126,126,128,131,133,133,131,128,127,128,129,130,130,
  129,128,128,129,129,128,126,125,125,127,129,129,127,125,124,123,122,124,127,
  130,130,128,126,125,124,124,124,125,126,127,127,128,128,127,125,123,122,123,
  125,126,124,123,123,123,124,125,126,127,128,129,129,129,128,127,127,128,129,
  130,130,130,130,129,128,128,128,127,127,128,128,127,128,129,130,129,128,127,
  126,125,125,126,128,130,130,130,129,128,128,128,129,129,129,129,129,129,128,
  127,127,127,128,128,128,128,128,127,126,126,127,128,128,128,128,127,127,128,
  129,129,128,127,127,128,129,130,131,131,131,130,129,128,128,127,128,129,130,
  129,128,128,127,127,127,129,130,130,128,128,128,127,126,125,126,127,128,128,
  128,127,126,126,126,125,125,125,127,128,129,129,127,125,123,123,124,125,127,
  127,127,126,125,125,125,125,126,126,126,127,128,128,126,126,126,127,128,129,
  129,128,128,127,128,128,129,129,128,126,126,127,127,128,128,128,128,127,127,
  128,129,129,129,129,129,129,129,128,126,126,127,128,128,129,129,129,127,126,
  126,128,129,130,130,129,128,127,126,127,128,128,128,128,127,127,127,127,127,
  126,127,128,128,128,128,127,127,128,129,129,128,126,126,127,128,130,130,130,
  129,128,128,128,128,129,130,130,129,128,128,128,127,128,128,128,128,128,129,
  128,128,127,126,126,126,127,128,128,128,128,127,126,126,126,127,127,127,128,
  128,127,126,126,126,126,126,126,127,126,126,126,126,126,126,125,125,126,126,
  127,128,128,128,126,126,126,127,128,128,129,128,128,128,128,128,129,128,128,
  127,127,128,128,128,127,127,126,126,127,128,128,129,128,128,128,127,127,127,
  128,129,129,129,128,128,128,127,127,128,129,130,130,129,128,127,127,128,128,
  128,128,127,126,127,127,127,127,128,128,128,127,127,128,128,128,128,128,128,
  128,128,128,128,128,128,128,128,128,128,128,128,127,128,129,129,129,129,128,
  127,127,127,128,128,128,128,128,127,127,127,127,128,127,128,128,127,127,127,
  127,127,127,127,127,127,127,126,127,127,127,127,127,127,126,126,127,128,128,
  128,127,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,
  126,
};

// killough 1/31/98: 
// Table of predefined lumps, used to make up for any wad deficiencies.
// Always overriden by iwad or pwads.

// see also the lump definitions above for additional comments

const lumpinfo_t predefined_lumps[]={
  { "M_HORSEN", sizeof m_horsen, m_horsen },
  { "M_VERSEN", sizeof m_versen, m_versen },
  { "STBR123",  sizeof stbr123, stbr123 }, //jff 02/16/98 bargraph patches
  { "STBR124",  sizeof stbr124, stbr124 },
  { "STBR125",  sizeof stbr125, stbr125 },
  { "STBR126",  sizeof stbr126, stbr126 },
  { "STBR127",  sizeof stbr127, stbr127 },
  { "DIG0",     sizeof dig0, dig0 }, //jff 02/20/98 smaller digit patches
  { "DIG1",     sizeof dig1, dig1 },
  { "DIG2",     sizeof dig2, dig2 },
  { "DIG3",     sizeof dig3, dig3 },
  { "DIG4",     sizeof dig4, dig4 },
  { "DIG5",     sizeof dig5, dig5 },
  { "DIG6",     sizeof dig6, dig6 },
  { "DIG7",     sizeof dig7, dig7 },
  { "DIG8",     sizeof dig8, dig8 },
  { "DIG9",     sizeof dig9, dig9 },
  { "DIGA",     sizeof diga, diga }, //jff 2/22/98 full new smaller hud font
  { "DIGB",     sizeof digb, digb },
  { "DIGC",     sizeof digc, digc },
  { "DIGD",     sizeof digd, digd },
  { "DIGE",     sizeof dige, dige },
  { "DIGF",     sizeof digf, digf },
  { "DIGG",     sizeof digg, digg },
  { "DIGH",     sizeof digh, digh },
  { "DIGI",     sizeof digi, digi },
  { "DIGJ",     sizeof digj, digj },
  { "DIGK",     sizeof digk, digk },
  { "DIGL",     sizeof digl, digl },
  { "DIGM",     sizeof digm, digm },
  { "DIGN",     sizeof dign, dign },
  { "DIGO",     sizeof digo, digo },
  { "DIGP",     sizeof digp, digp },
  { "DIGQ",     sizeof digq, digq },
  { "DIGR",     sizeof digr, digr },
  { "DIGS",     sizeof digs, digs },
  { "DIGT",     sizeof digt, digt },
  { "DIGU",     sizeof digu, digu },
  { "DIGV",     sizeof digv, digv },
  { "DIGW",     sizeof digw, digw },
  { "DIGX",     sizeof digx, digx },
  { "DIGY",     sizeof digy, digy },
  { "DIGZ",     sizeof digz, digz },
  { "DIG45",    sizeof dig45, dig45 },        //jff 3/3/98 add minus sign
  { "DIG47",    sizeof dig47, dig47 },
  { "DIG58",    sizeof dig58, dig58 },
  { "DIG91",    sizeof dig91, dig91 },
  { "DIG93",    sizeof dig93, dig93 },
  { "STKEYS6",  sizeof stkeys6, stkeys6 }, //jff 2/24/98 double key graphics
  { "STKEYS7",  sizeof stkeys7, stkeys7 },
  { "STKEYS8",  sizeof stkeys8, stkeys8 },
  { "BOXUL",    sizeof boxul, boxul }, //jff 2/26/98 background window graphics
  { "BOXUC",    sizeof boxuc, boxuc },
  { "BOXUR",    sizeof boxur, boxur },
  { "BOXCL",    sizeof boxcl, boxcl },
  { "BOXCC",    sizeof boxcc, boxcc },
  { "BOXCR",    sizeof boxcr, boxcr },
  { "BOXLL",    sizeof boxll, boxll },
  { "BOXLC",    sizeof boxlc, boxlc },
  { "BOXLR",    sizeof boxlr, boxlr },
  { "STTMINUS", sizeof sttminus, sttminus }, //jff 2/27/98 -- for v1.2
  { "WIMINUS",  sizeof wiminus,  wiminus},   // killough 4/25/98 -- for v1.1
  { "M_NMARE",  sizeof m_nmare,  m_nmare},   // killough 4/25/98 -- for v1.1
  { "STBAR",    sizeof stbar,    stbar},     // killough 4/25/98 -- for v1.1
  { "DSGETPOW", sizeof dsgetpow, dsgetpow},  // killough 4/25/98 -- for v1.1
  { "ENDBOOM",  sizeof endboom, endboom }, //jff 4/1/98 our own endoom lump
  { "S_START"},                        // phares 3/9/98    killough 3/21/98
  { "TNT1A0",   sizeof invis_sprite, invis_sprite },            // invis sprite
  { "S_END"},                          // phares 3/9/98    killough 3/21/98
  { "SWITCHES", sizeof switches, switches},   // jff 3/23/98 switch list
  { "ANIMATED", sizeof animated, animated},   // jff 3/23/98 animation list
  { "M_SETUP" , sizeof m_setup,  m_setup },   // phares 3/24/98 menu item
  { "M_KEYBND", sizeof m_keybnd, m_keybnd},   // phares 3/24/98 menu item
  { "M_AUTO"  , sizeof m_auto,   m_auto  },   // phares 3/30/98 menu item
  { "M_CHAT"  , sizeof m_chat,   m_chat  },   // phares 4/10/98 menu item
  { "M_ENEM",   sizeof m_enem,   m_enem  },   // phares 4/08/98 menu item
  { "M_STAT",   sizeof m_stat,   m_stat  },   // phares 3/29/98 menu item
  { "M_WEAP",   sizeof m_weap,   m_weap  },   // phares 3/28/98 menu item
  { "M_MESS"  , sizeof m_mess,   m_mess  },   // phares 4/08/98 menu item
  { "M_COLORS", sizeof m_colors, m_colors},   // phares 4/01/98 menu item
  { "M_PALNO",  sizeof m_palno,  m_palno},    // phares 4/01/98 menu item
  { "C_START" },  // killough 4/4/98: colormap markers
  { "WATERMAP", sizeof watermap, watermap},   // killough 3/21/98, 4/4/98
  { "C_END" },    // killough 4/4/98: end colormap markers
  { "STCFN096", sizeof stcfn096, stcfn096},   // jff 4/5/98 missing char
  { "M_BUTT1",  sizeof m_butt1,  m_butt1},    // phares 4/16/98 reset button
  { "M_BUTT2",  sizeof m_butt2,  m_butt2},    // phares 4/16/98 reset button
  { "CRBRICK",  sizeof cr_brick, cr_brick},   // jff 4/24/98 brick color range
  { "CRTAN",    sizeof cr_tan,   cr_tan},     // jff 4/24/98 tan color range
  { "CRGRAY",   sizeof cr_gray,  cr_gray},    // jff 4/24/98 gray color range
  { "CRGREEN",  sizeof cr_green, cr_green},   // jff 4/24/98 green color range
  { "CRBROWN",  sizeof cr_brown, cr_brown},   // jff 4/24/98 brown color range
  { "CRGOLD",   sizeof cr_gold,  cr_gold},    // jff 4/24/98 gold color range
  { "CRRED",    sizeof cr_red,   cr_red},     // jff 4/24/98 red color range
  { "CRBLUE",   sizeof cr_blue,  cr_blue},    // jff 4/24/98 blue color range
  { "CRBLUE2",  sizeof cr_blue2, cr_blue2},   // jff 4/24/98 blue2 color range
  { "CRORANGE", sizeof cr_orange,cr_orange},  // jff 4/24/98 orange color range
  { "CRYELLOW", sizeof cr_yellow,cr_yellow},  // jff 4/24/98 yellow color range
};

// Calculate how many of them there are
const size_t num_predefined_lumps =
  sizeof predefined_lumps / sizeof *predefined_lumps;

//----------------------------------------------------------------------------
//
// $Log: info.c,v $
// Revision 1.44  1998/05/12  12:46:36  phares
// Removed OVER_UNDER code
//
// Revision 1.43  1998/05/12  09:35:07  phares
// Corrected 4001->5001 and 4002->5002 in OVER/UNDER table
//
// Revision 1.42  1998/05/12  08:41:13  jim
// fix decl of endboom
//
// Revision 1.40  1998/05/11  12:21:20  jim
// 4001/2 deconflicted with DosDOOM
//
// Revision 1.39  1998/05/06  11:30:54  jim
// Moved predefined lump writer info->w_wad
//
// Revision 1.38  1998/05/04  21:34:49  thldrmn
// commenting and reformatting
//
// Revision 1.37  1998/05/03  23:23:50  killough
// Fix #includes at the top, nothing else
//
// Revision 1.36  1998/04/29  09:20:37  jim
// New ENDBOOM
//
// Revision 1.35  1998/04/27  02:15:10  killough
// Fix cr_gold declaration, add missing v1.1 lumps
//
// Revision 1.34  1998/04/24  08:08:36  jim
// Make text translate tables lumps
//
// Revision 1.33  1998/04/22  13:45:37  phares
// Added Setup screen Reset to Defaults
//
// Revision 1.32  1998/04/22  06:34:43  killough
// Make WritePredefinedLumpWad endian-independent, remove tabs
//
// Revision 1.31  1998/04/21  23:46:21  jim
// Predefined lump dumper option
//
// Revision 1.30  1998/04/17  00:04:11  jim
// text file changes and new ENDBOOM
//
// Revision 1.29  1998/04/12  22:54:55  phares
// Remaining 3 Setup screens
//
// Revision 1.28  1998/04/06  04:36:51  killough
// Change WATERMAP, add C_START/C_END
//
// Revision 1.27  1998/04/05  10:10:13  jim
// added STCFN096 lump
//
// Revision 1.26  1998/04/03  19:18:46  phares
// Automap Palette work, slot 0 = disable, 247 = BLACK
//
// Revision 1.25  1998/04/02  05:01:49  jim
// Added ENDOOM, BOOM.TXT mods
//
// Revision 1.24  1998/04/01  15:34:30  phares
// Added Automap Setup Screen, fixed Seg Viol in Setup Menus
//
// Revision 1.23  1998/03/31  01:08:26  phares
// Initial Setup screens and Extended HELP screens
//
// Revision 1.22  1998/03/23  18:39:10  jim
// Switch and animation tables now lumps
//
// Revision 1.21  1998/03/23  15:23:54  phares
// Changed pushers to linedef control
//
// Revision 1.20  1998/03/23  03:18:09  killough
// Add WATERMAP colormap lump for underwater viewing
//
// Revision 1.19  1998/03/09  18:30:28  phares
// Added invisible sprite for MT_PUSH
//
// Revision 1.18  1998/03/09  07:15:14  killough
// Remove unnecessary translucency lumps
//
// Revision 1.17  1998/03/04  22:23:04  phares
// Removed BOOMHELP predefined lump
//
// Revision 1.16  1998/03/04  11:52:43  jim
// Add TRAN50 TRAN66 predefined lumps
//
// Revision 1.15  1998/03/03  00:21:54  jim
// Added predefined ENDBETA lump for beta test
//
// Revision 1.13  1998/02/27  11:51:50  jim
// Add predefined lump STTMINUS
//
// Revision 1.11  1998/02/24  08:45:44  phares
// Pushers, recoil, new friction, and over/under work
//
// Revision 1.10  1998/02/24  04:13:37  jim
// Added double keys to status
//
// Revision 1.8  1998/02/23  04:31:13  killough
// Make tranlucency apply realistically
//
// Revision 1.7  1998/02/22  12:51:38  jim
// HUD control on F5, z coord, spacing change
//
// Revision 1.5  1998/02/20  21:56:49  phares
// Preliminarey sprite translucency
//
// Revision 1.4  1998/02/18  00:59:44  jim
// Addition of HUD
//
// Revision 1.3  1998/02/02  13:36:12  killough
// Add predefined lumps
//
// Revision 1.2  1998/01/26  19:23:34  phares
// First rev with no ^Ms
//
// Revision 1.1.1.1  1998/01/19  14:02:56  rand
// Lee's Jan 19 sources
//
//
//----------------------------------------------------------------------------
