#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>

#include "lnspec.h"

typedef unsigned char	UBYTE;
typedef signed short	WORD;
typedef unsigned short	UWORD;
typedef unsigned int	ULONG;
typedef int				BOOL;

#define TRUE			1
#define FALSE			0

// Doomednum of teleport destination
#define T_DESTINATION	14

struct dir_s {
	ULONG pos;
	ULONG size;
	UBYTE name[8];
};
typedef struct dir_s dir_t;


// A SideDef, defining the visual appearance of a wall,
// by setting textures and offsets.
typedef struct
{
	short 		textureoffset;
	short 		rowoffset;
	char		toptexture[8];
	char		bottomtexture[8];
	char		midtexture[8];
	// Front sector, towards viewer.
	short 		sector;
} mapsidedef_t;

// A LineDef, as used for editing, and as input
// to the BSP builder.
typedef struct
{
	WORD 		v1;
	WORD 		v2;
	WORD 		flags;
	WORD 		special;
	WORD 		tag;
	WORD 		sidenum[2];
} maplinedef_t;

// [RH] Hexen-compatible LineDef.
typedef struct
{
	WORD		v1;
	WORD		v2;
	WORD		flags;
	UBYTE		special;
	UBYTE		args[5];
	WORD		sidenum[2];
} maplinedef2_t;


//
// LineDef attributes.
//

#define ML_BLOCKING 				0x0001
#define ML_BLOCKMONSTERS			0x0002
#define ML_TWOSIDED 				0x0004
#define ML_DONTPEGTOP				0x0008
#define ML_DONTPEGBOTTOM			0x0010		
#define ML_SECRET					0x0020
#define ML_SOUNDBLOCK				0x0040
#define ML_DONTDRAW 				0x0080
#define ML_MAPPED					0x0100
#define ML_REPEATABLE				0x0200

#define ML_ACTIVATIONMASK			0x1c00
#define ML_ACTIVATECROSS			0x0000
#define ML_ACTIVATEUSE				0x0400
#define ML_ACTIVATEMONSTERCROSS		0x0800
#define ML_ACTIVATEPROJECTILEHIT	0x0c00
#define ML_ACTIVATEPUSH				0x1000
#define ML_ACTIVATEPROJECTILECROSS	0x1400

#define ML_MONSTERSCANACTIVATE		0x2000
#define ML_PASSUSEORG				0x0200
#define ML_PASSUSE					0x4000


// Sector definition, from editing.
typedef struct
{
	WORD 		floorheight;
	WORD 		ceilingheight;
	UBYTE		floorpic[8];
	UBYTE		ceilingpic[8];
	WORD 		lightlevel;
	WORD 		special;
	UWORD 		tag;
} mapsector_t;

// SubSector, as generated by BSP.
typedef struct
{
	WORD 		numsegs;
	// Index of first one, segs are stored sequentially.
	WORD 		firstseg;
} mapsubsector_t;


// LineSeg, generated by splitting LineDefs
// using partition lines selected by BSP builder.
typedef struct
{
	WORD 		v1;
	WORD 		v2;
	WORD 		angle;
	WORD 		linedef;
	WORD 		side;
	WORD 		offset;
} mapseg_t;



// BSP node structure.

// Indicate a leaf.
#define NF_SUBSECTOR	0x8000

typedef struct
{
	// Partition line from (x,y) to x+dx,y+dy)
	WORD 		x;
	WORD 		y;
	WORD 		dx;
	WORD 		dy;

	// Bounding box for each child,
	// clip against view frustum.
	WORD 		bbox[2][4];

	// If NF_SUBSECTOR its a subsector,
	// else it's a node of another subtree.
	UWORD		children[2];

} mapnode_t;

// Thing definition, position, orientation and type,
// plus skill/visibility flags and attributes.
typedef struct
{
	WORD		x;
	WORD		y;
	WORD		angle;
	WORD		type;
	WORD		options;
} mapthing_t;

// [RH] Hexen-compatible MapThing.
typedef struct
{
	UWORD		thingid;
	WORD		x;
	WORD		y;
	WORD		z;
	WORD		angle;
	WORD		type;
	WORD		flags;
	UBYTE		special;
	UBYTE		args[5];
} mapthing2_t;


#define MTF_EASY					0x0001
#define MTF_MEDIUM					0x0002
#define MTF_HARD					0x0004
#define MTF_AMBUSH					0x0008
#define MTF_DORMANT					0x0010
#define MTF_SINGLE					0x0100
#define MTF_COOPERATIVE				0x0200
#define MTF_DEATHMATCH				0x0400

// BOOM and DOOM compatible versions of some of the above

#define BTF_NOTSINGLE				0x0010	// (TF_COOPERATIVE|TF_DEATHMATCH)
#define BTF_NOTDEATHMATCH			0x0020	// (TF_SINGLE|TF_COOPERATIVE)
#define BTF_NOTCOOPERATIVE			0x0040	// (TF_SINGLE|TF_DEATHMATCH)

// Include conversion tables
#include "xlat.h"

#define PCD_TERMINATE			1
#define PCD_LSPEC1DIRECT		9
#define PCD_LSPEC2DIRECT		10
#define PCD_LSPEC3DIRECT		11
#define PCD_LSPEC4DIRECT		12
#define PCD_LSPEC5DIRECT		13

extern mapsector_t *sectors;
extern mapthing2_t *things;
extern maplinedef2_t *lines;
extern mapnode_t *nodes;
extern mapsidedef_t *sides;
extern mapseg_t *segs;
extern mapsubsector_t *subsectors;
extern int numthings, numlines, numsectors, numnodes, numsegs, numsubsectors, numsides;

mapsector_t *PointInSector (WORD x, WORD y);
void GroupLines (void);
