// Emacs style mode select   -*- C++ -*-
// vi:set tabstop=8:
//-----------------------------------------------------------------------------
//
// $Id:$
//
// Copyright (C) 1993-1996 by id Software, Inc.
// Copyright (C) 1997-1999 by Udo Munk
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
//
//
// $Log:$
//
// DESCRIPTION:
//
//-----------------------------------------------------------------------------

static const char
rcsid[] = "$Id:$";

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <stdarg.h>
#include <sys/time.h>
#include <unistd.h>

#include "doomdef.h"
#include "m_misc.h"
#include "i_video.h"
#include "i_sound.h"
#include "d_net.h"
#include "g_game.h"
#include "endtxt.h"

#ifdef __GNUG__
#pragma implementation "i_system.h"
#endif
#include "i_system.h"

int	mb_used = 8;

void I_Tactile(int on, int off, int total)
{
  // UNUSED.
  on = off = total = 0;
}

ticcmd_t	emptycmd;

ticcmd_t	*I_BaseTiccmd(void)
{
    return &emptycmd;
}

int  I_GetHeapSize(void)
{
    return mb_used*1024*1024;
}

byte *I_ZoneBase (int *size)
{
    if (mb_used < 8)
	mb_used = 8;

    *size = mb_used * 1024 * 1024;
    return ((byte *)malloc(*size));
}

//
// I_GetTime
// returns time in 1/TICRATE second tics
//
int  I_GetTime(void)
{
    struct timeval	tp;
    struct timezone	tzp;
    int			newtics;
    static int		oldtics;
    static int		basetime = 0;

    gettimeofday(&tp, &tzp);
    if (!basetime)
	basetime = tp.tv_sec;

    // On systems with RTC drift correction or NTP we need to take
    // care about the system clock running backwards sometimes. Make
    // sure the new tic is later then the last one.
    // Some broken Linux drivers mess up the RTC too.
    newtics = (tp.tv_sec-basetime) * TICRATE + tp.tv_usec * TICRATE / 1000000;
    if (!oldtics)
	oldtics = newtics;
    if (newtics < oldtics)
	return oldtics;
    oldtics = newtics;
    return newtics;
}

//
// I_Init
//
void I_Init(void)
{
    I_InitSound();
    I_InitMusic();
}

//
// I_Quit
//
void I_Quit(void)
{
    D_QuitNetGame();
    I_ShutdownMusic();
    I_ShutdownSound();
    M_SaveDefaults();
    I_ShutdownGraphics();
    printf("\r");
    ShowEndTxt();
    exit(0);
}

void I_WaitVBL(int count)
{
    usleep(count * 10000);
}

void I_BeginRead(void)
{
}

void I_EndRead(void)
{
}

byte *I_AllocLow(int length)
{
    byte	*mem;

    mem = (byte *)malloc(length);
    memset(mem, 0, length);
    return mem;
}

//
// I_Error
//
extern boolean demorecording;

void I_Error(char *error, ...)
{
    va_list	argptr;

    // Message first.
    va_start(argptr, error);
    fprintf(stdout, "Error: ");
    vfprintf(stdout, error, argptr);
    fprintf(stdout, "\n");
    va_end(argptr);

    fflush(stdout);

    // Shutdown. Here might be other errors.
    if (demorecording)
	G_CheckDemoStatus();

    D_QuitNetGame();
    I_ShutdownMusic();
    I_ShutdownSound();
    I_ShutdownGraphics();

    exit(-1);
}
