
//
// screen.h
//

#ifndef __SCREEN_H__
#define __SCREEN_H__


//added:26-01-98: quickhack for V_Init()... to be cleaned up
#define NUMSCREENS    4


//added:20-01-98: used now as a maximum video mode size for extra vesa modes.

// we try to re-allocate a minimum of buffers for stability of the memory,
// so all the small-enough tables based on screen size, are allocated once
// and for all at the maximum size.

#define MAXVIDWIDTH	1024  //dont set this too high because actually
#define MAXVIDHEIGHT	768  // lots of tables are allocated with the MAX
			    // size.

#define BASEVIDWIDTH	320   //NEVER CHANGE THIS! this is the original
#define BASEVIDHEIGHT	200  // resolution of the graphics.

// global video state
typedef struct
{
    byte	    *buffer;	    // invisible buffer
    //byte	      *colormap;
    //unsigned short  *colormap16;
    unsigned	    rowbytes;	  // may be > width if displayed in a window
				  // (hardware video window)
    unsigned	    width;
    unsigned	    height;
    int 	    numpages;	  //added:20-01-98:always 1 now... TO DO!!!
    int 	    recalc;	  // if true, recalc vid-based stuff
    byte	    *direct;	   // linear frame buffer, or vga base mem.
} viddef_t;

extern viddef_t vid;
extern int	setmodeneeded;	   // mode number to set if needed, or 0

extern int	scr_width;	   // VID_Init() looks here to set the
extern int	scr_height;	   // first video mode, if scr_default_mode
				   // is zero.

extern int	scr_forcex;	   // screen size asked from the cmd-line
extern int	scr_forcey;


// Change video mode, only at the start of a refresh.
void SCR_SetMode (void);
// Recalc screen size dependent stuff
void SCR_Recalc (void);
// Check parms once at startup
void SCR_CheckParms (void);
// Set the mode number which is saved in the config
void SCR_SetDefaultMode (void);

#endif //__SCREEN_H__