
//
// screen.c : handles multiple resolutions.
//

#include <stdlib.h>
#include <stdio.h>

#include "doomdef.h"
#include "doomstat.h"

#include "m_argv.h"

#include "r_local.h"
#include "r_sky.h"

#include "v_video.h"
#include "am_map.h"

#include "screen.h"

#include "st_stuff.h"
#include "hu_stuff.h"

//#include "st_stuff.h"

// global video state
viddef_t  vid;
int	  setmodeneeded;     //video mode change asked from the menu
			    //if non-zero, it is the mode number to set


//added:26-01-98: not declared in m_menu.h, and should not be global since
//		  it's used only here.
extern int screenblocks;
extern int detailLevel;


//added:27-01-98: tell asm code the new rowbytes value.
void ASM_PatchRowBytes(int rowbytes);


//added:01-02-98:
//
// Change video mode right now. The menu asks for a mode change by setting
// the 'setmodeneeded' to the mode number.
// Since the menu is processed many times during the redraw (eg:netupdate),
// the video mode change is delayed until the start of the next refresh.
//
// shhhh... should include...
int  VID_SetMode(int modenum);

void SCR_SetMode (void)
{
    if (!setmodeneeded)
	return; 		//should never happen

    VID_SetMode(--setmodeneeded);

    setmodeneeded = 0;
}

  //added:27-01-98: quick hack test dynamic screen resize...
  //		    shared with default.cfg


//added:24-01-98:
//
// Called at new frame, if the video mode has changed
//
void SCR_Recalc (void)
{
    // patch the asm code depending on vid buffer rowbytes
    ASM_PatchRowBytes(vid.width);

    // toggle off automap because some screensize-dependent values will
    // be calculated next time the automap is activated.
    if (automapactive)
	AM_Stop();

    // fuzzoffsets for the 'spectre' effect,... this is a quick hack for
    // compatibility, because I don't use it anymore since transparency
    // looks much better.
    R_RecalcFuzzOffsets();

// r_plane stuff : visplanes, openings, floorclip, ceilingclip, spanstart,
//		   spanstop, yslope, distscale, cachedheight, cacheddistance,
//		   cachedxstep, cachedystep
//		-> allocated at the maximum vidsize, static.

    // r_main : xtoviewangle, allocated at the maximum size.
    // r_things : negonearray, screenheightarray allocated max. size.

    // re-center the sky on vid height
    R_RecalcSkyMap();

    // set the screen[x] ptrs on the new vidbuffers
    V_Init();

    // screenblocks doesn't change, neither detailLevel, but the pixels
    // per screenblock is different now, since we've changed resolution.
    // NOTE: it is supposed that R_ExecuteSetViewSize() is done just after
    //	     this at the start of D_Display()
    R_SetViewSize (screenblocks,detailLevel);

    // some HU widgets like the message and input texts need their coords
    // repositioned
    hu_recalc = true;

    // need another flag than vid.recalc because vid.recalc lasts only for
    // the next refresh
    st_recalc = true;
    am_recalc = true;
}


    //added:03-02-98: default screen mode, as loaded/saved in config
    int scr_width;
    int scr_height;

    int scr_forcex;	// resolution asked from the cmd-line
    int scr_forcey;

//added:24-01-98:
//
// Check for screen cmd-line parms : to force a resolution.
//
void SCR_CheckParms (void)
{
    int p;

    // 0 means not set at the cmd-line
    scr_forcex = 0;
    scr_forcey = 0;

    p = M_CheckParm("-x");
    if (p && p < myargc-1)
	scr_forcex = atoi(myargv[p+1]);

    p = M_CheckParm("-y");
    if (p && p < myargc-1)
	scr_forcey = atoi(myargv[p+1]);

    if (scr_forcex && scr_forcey)
	printf("Using resolution: %d x %d\n",scr_forcex,scr_forcey);
    else
	printf("Default resolution: %d x %d\n",scr_width,scr_height);
}


//added:03-02-98: sets the modenum as the new default video mode to be saved
//		  in the config file
void SCR_SetDefaultMode (void)
{
    // remember the default screen size
    scr_width  = vid.width;
    scr_height = vid.height;
}
