//-----------------------------------------------------------------------------
//
// g_input.h
//
//-----------------------------------------------------------------------------


#ifndef __G_INPUT__
#define __G_INPUT__

#include "d_event.h"
#include "keys.h"

#define MOUSEBUTTONS	3
#define JOYBUTTONS	4

// number of gamekeydown[] entries
#define NUMKEYS 	256

//
// mouse and joystick buttons are handled as 'virtual' keys
//
#define KEY_MOUSE1	NUMKEYS
#define KEY_JOY1	(KEY_MOUSE1+MOUSEBUTTONS)
#define KEY_DBLMOUSE1	(KEY_JOY1+JOYBUTTONS)		// double clicks
#define KEY_DBLJOY1	(KEY_DBLMOUSE1+MOUSEBUTTONS)

// number of total 'button' inputs, number of controlmap[] entries
#define NUMINPUTS	(KEY_DBLJOY1+JOYBUTTONS)

enum
{
    gc_null = 0,	//a key/button mapped to gc_null has no effect
    gc_forward,
    gc_backward,
    gc_strafe,
    gc_straferight,
    gc_strafeleft,
    gc_speed,
    gc_turnleft,
    gc_turnright,
    gc_fire,
    gc_use,
    gc_lookup,
    gc_lookdown,
    gc_centerview,
    gc_mouseaiming,	// mouse aiming is momentary (toggleable in the menu)
    gc_weapon1,
    gc_weapon2,
    gc_weapon3,
    gc_weapon4,
    gc_weapon5,
    gc_weapon6,
    gc_weapon7,
    gc_weapon8,
    num_gamecontrols
} gamecontrols_e;


extern boolean	       mousearray[4];
extern boolean*        mousebuttons;

// mouse values are used once
extern int	       mouseSensitivity;
extern int	       mlookSensitivity;
extern int	       mousex;
extern int	       mousey;
extern int	       mlooky;	//mousey with mlookSensitivity

extern int	       dclicktime;
extern int	       dclickstate;
extern int	       dclicks;
extern int	       dclicktime2;
extern int	       dclickstate2;
extern int	       dclicks2;

extern int	       mousebfire;
extern int	       mousebstrafe;
extern int	       mousebforward;

extern int	       joyxmove;
extern int	       joyymove;
extern boolean	       joyarray[5];
extern boolean*        joybuttons;

extern int	       joybfire;
extern int	       joybstrafe;
extern int	       joybuse;
extern int	       joybspeed;

// these keys are here for compatibility,
// most of them will disappear later...
extern int	       key_right;
extern int	       key_left;
extern int	       key_up;
extern int	       key_down;
extern int	       key_strafeleft;
extern int	       key_straferight;
extern int	       key_fire;
extern int	       key_use;
extern int	       key_strafe;
extern int	       key_speed;


// current state of the keys : true if pushed
extern	byte	gamekeydown[NUMKEYS];
// current state for each control
extern	byte	gamecontrol[num_gamecontrols];
// each key/button maps to a control or 0 (nothing)
extern	byte	controlmap[NUMINPUTS];	// for customise controls in m_menu.c

// remap default.cfg keys to controls and setup game controls
void  G_SetupDefaultGameControls (boolean gcfound);

// remaps the input event to a game control.
void  G_MapEventsToControls (event_t *ev);

// returns the name of a key
char* G_KeynumToString (int keynum);

// detach any keys associated to the given game control
void  G_ClearControlKeys (int control);

// temporary hack to get two keys for a control as an int saved in the config
int   G_TwokeysForControl (int control);

#endif
